/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.segment.*;

import java.util.List;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ADT_A60 message structure (see chapter 3). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: EVN (Event Type) <b> </b></li>
                 * <li>3: PID (Patient identification) <b> </b></li>
                 * <li>4: PV1 (Patient visit) <b>optional </b></li>
                 * <li>5: PV2 (Patient visit - additional information) <b>optional </b></li>
                 * <li>6: IAM (Patient adverse reaction information - unique iden) <b>optional repeating</b></li>
 * </ul>
 */
@SuppressWarnings("unused")
public class ADT_A60 extends AbstractMessage  {

    /**
     * Creates a new ADT_A60 message with DefaultModelClassFactory. 
     */ 
    public ADT_A60() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new ADT_A60 message with custom ModelClassFactory.
     */
    public ADT_A60(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(EVN.class, true, false);
                          this.add(PID.class, true, false);
                          this.add(PV1.class, false, false);
                          this.add(PV2.class, false, false);
                          this.add(IAM.class, false, true);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating ADT_A60 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       return getTyped("MSH", MSH.class);
    }




    /**
     * Returns
     * EVN (Event Type) - creates it if necessary
     */
    public EVN getEVN() { 
       return getTyped("EVN", EVN.class);
    }




    /**
     * Returns
     * PID (Patient identification) - creates it if necessary
     */
    public PID getPID() { 
       return getTyped("PID", PID.class);
    }




    /**
     * Returns
     * PV1 (Patient visit) - creates it if necessary
     */
    public PV1 getPV1() { 
       return getTyped("PV1", PV1.class);
    }




    /**
     * Returns
     * PV2 (Patient visit - additional information) - creates it if necessary
     */
    public PV2 getPV2() { 
       return getTyped("PV2", PV2.class);
    }




    /**
     * Returns
     * the first repetition of 
     * IAM (Patient adverse reaction information - unique iden) - creates it if necessary
     */
    public IAM getIAM() { 
       return getTyped("IAM", IAM.class);
    }


    /**
     * Returns a specific repetition of
     * IAM (Patient adverse reaction information - unique iden) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public IAM getIAM(int rep) { 
       return getTyped("IAM", rep, IAM.class);
    }

    /** 
     * Returns the number of existing repetitions of IAM 
     */ 
    public int getIAMReps() { 
    	return getReps("IAM");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of IAM.
     * <p>
     * <p>
     * Note that unlike {@link #getIAM()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<IAM> getIAMAll() throws HL7Exception {
    	return getAllAsList("IAM", IAM.class);
    } 

    /**
     * Inserts a specific repetition of IAM (Patient adverse reaction information - unique iden)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertIAM(IAM structure, int rep) throws HL7Exception { 
       super.insertRepetition( "IAM", structure, rep);
    }


    /**
     * Inserts a specific repetition of IAM (Patient adverse reaction information - unique iden)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public IAM insertIAM(int rep) throws HL7Exception { 
       return (IAM)super.insertRepetition("IAM", rep);
    }


    /**
     * Removes a specific repetition of IAM (Patient adverse reaction information - unique iden)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public IAM removeIAM(int rep) throws HL7Exception { 
       return (IAM)super.removeRepetition("IAM", rep);
    }



}

