/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.formats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Resource;

public class ResourceFolderVisitor {
    private IResourceObserver observer;
    private List<String> types = new ArrayList<String>();

    public ResourceFolderVisitor(IResourceObserver observer) {
        this.observer = observer;
    }

    public ResourceFolderVisitor(IResourceObserver observer, String ... types) {
        this.observer = observer;
        for (String t : types) {
            this.types.add(t);
        }
    }

    public void visit(String folder) {
        this.visit(new File(folder));
    }

    public void visit(File file) {
        for (File f : file.listFiles()) {
            Resource res2;
            if (f.isDirectory()) {
                this.visit(f);
                continue;
            }
            if (f.getName().endsWith(".xml")) {
                try {
                    res2 = new XmlParser().parse(new FileInputStream(f));
                    if (!this.types.isEmpty() && !this.types.contains(res2.fhirType()) || !this.observer.visitResource(f.getAbsolutePath(), res2)) continue;
                    new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(f), res2);
                }
                catch (Exception res2) {}
                continue;
            }
            if (!f.getName().endsWith(".json")) continue;
            try {
                res2 = new JsonParser().parse(new FileInputStream(f));
                if (!this.types.isEmpty() && !this.types.contains(res2.fhirType()) || !this.observer.visitResource(f.getAbsolutePath(), res2)) continue;
                new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(f), res2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface IResourceObserver {
        public boolean visitResource(String var1, Resource var2);
    }
}

