/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;

public class ResourceFixer {
    private Set<String> refs = new HashSet<String>();

    public static void main(String[] args) {
        new ResourceFixer().vistAllResources(args[0]);
    }

    private void vistAllResources(String folder) {
        for (File f : new File(folder).listFiles()) {
            Resource r;
            if (f.isDirectory()) {
                this.vistAllResources(f.getAbsolutePath());
                continue;
            }
            if (f.getName().endsWith(".json")) {
                r = null;
                try {
                    r = new JsonParser().parse(new FileInputStream(f));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (r == null) continue;
                try {
                    if (!this.visitResource(r)) continue;
                    new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(f), r);
                }
                catch (Exception e) {
                    System.out.println("Error processing " + f.getAbsolutePath() + ": " + e.getMessage());
                }
                continue;
            }
            if (!f.getName().endsWith(".xml")) continue;
            r = null;
            try {
                r = new XmlParser().parse(new FileInputStream(f));
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (r == null) continue;
            try {
                if (!this.visitResource(r)) continue;
                new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(f), r);
            }
            catch (Exception e) {
                System.out.println("Error processing " + f.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    private boolean visitResource(Resource r) {
        if (r.hasId()) {
            String ref = r.fhirType() + "/" + r.getId();
            if (this.refs.contains(ref)) {
                throw new FHIRException("Duplicate resource " + ref);
            }
            this.refs.add(ref);
        }
        if (r instanceof CodeSystem) {
            return this.visitCodeSystem((CodeSystem)r);
        }
        return false;
    }

    private boolean visitCodeSystem(CodeSystem cs) {
        if (!cs.hasContent()) {
            System.out.println("Setting content = complete for CodeSystem/" + cs.getId());
            cs.setContent(Enumerations.CodeSystemContentMode.COMPLETE);
            return true;
        }
        if (!cs.hasHierarchyMeaning() && this.hasHierarchy(cs)) {
            System.out.println("Setting hierarchyMeaning = is-a for CodeSystem/" + cs.getId());
            cs.setHierarchyMeaning(CodeSystem.CodeSystemHierarchyMeaning.ISA);
            return true;
        }
        return false;
    }

    private boolean hasHierarchy(CodeSystem cs) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            if (!c.hasConcept()) continue;
            return true;
        }
        return false;
    }
}

