/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.graphql.Argument;
import org.hl7.fhir.utilities.graphql.EGraphEngine;
import org.hl7.fhir.utilities.graphql.EGraphQLException;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.hl7.fhir.utilities.graphql.StringValue;
import org.hl7.fhir.utilities.graphql.Value;

public class GraphDefinitionEngine {
    private static final String TAG_NAME = "Compiled.expression";
    private IGraphQLStorageServices services;
    private IWorkerContext context;
    private Object appInfo;
    private Resource start;
    private GraphDefinition graphDefinition;
    private boolean validating;
    private Bundle bundle;
    private String baseURL;
    private FHIRPathEngine engine;

    public GraphDefinitionEngine(IGraphQLStorageServices services, IWorkerContext context) {
        this.services = services;
        this.context = context;
    }

    public Object getAppInfo() {
        return this.appInfo;
    }

    public void setAppInfo(Object appInfo) {
        this.appInfo = appInfo;
    }

    public Resource getFocus() {
        return this.start;
    }

    public void setFocus(Resource focus) {
        this.start = focus;
    }

    public GraphDefinition getGraphDefinition() {
        return this.graphDefinition;
    }

    public void setGraphDefinition(GraphDefinition graphDefinition) {
        this.graphDefinition = graphDefinition;
    }

    public Bundle getOutput() {
        return this.bundle;
    }

    public void setOutput(Bundle bundle) {
        this.bundle = bundle;
    }

    public IGraphQLStorageServices getServices() {
        return this.services;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void execute() throws EGraphEngine, EGraphQLException, FHIRException {
        assert (this.services != null);
        assert (this.start != null);
        assert (this.bundle != null);
        assert (this.baseURL != null);
        assert (this.graphDefinition != null);
        this.graphDefinition.checkNoModifiers("definition", "Building graph from GraphDefinition");
        this.check(!this.start.fhirType().equals(this.graphDefinition.getStart()), "The Graph definition requires that the start (focus reosource) is " + this.graphDefinition.getStart() + ", but instead found " + this.start.fhirType());
        if (!this.isInBundle(this.start)) {
            this.addToBundle(this.start);
        }
        for (GraphDefinition.GraphDefinitionLinkComponent l : this.graphDefinition.getLink()) {
            this.processLink(this.start.fhirType(), this.start, l, 1);
        }
    }

    private void check(boolean b, String msg) {
        if (!b) {
            throw new FHIRException(msg);
        }
    }

    private boolean isInBundle(Resource resource) {
        for (Bundle.BundleEntryComponent be : this.bundle.getEntry()) {
            if (!be.hasResource() || !be.getResource().fhirType().equals(resource.fhirType()) || !be.getResource().getId().equals(resource.getId())) continue;
            return true;
        }
        return false;
    }

    private void addToBundle(Resource resource) {
        Bundle.BundleEntryComponent be = this.bundle.addEntry();
        be.setFullUrl(Utilities.pathURL((String[])new String[]{this.baseURL, resource.fhirType(), resource.getId()}));
        be.setResource(resource);
    }

    private void processLink(String focusPath, Resource focus, GraphDefinition.GraphDefinitionLinkComponent link, int depth) {
        if (link.hasPath()) {
            this.processLinkPath(focusPath, focus, link, depth);
        } else {
            this.processLinkTarget(focusPath, focus, link, depth);
        }
    }

    private void processLinkPath(String focusPath, Resource focus, GraphDefinition.GraphDefinitionLinkComponent link, int depth) {
        ExpressionNode node;
        String path = focusPath + " -> " + link.getPath();
        this.check(link.hasPath(), "Path is needed at " + path);
        this.check(!link.hasSliceName(), "SliceName is not yet supported at " + path);
        if (link.getPathElement().hasUserData(TAG_NAME)) {
            node = (ExpressionNode)link.getPathElement().getUserData(TAG_NAME);
        } else {
            node = this.engine.parse(link.getPath());
            link.getPathElement().setUserData(TAG_NAME, node);
        }
        List<Base> matches = this.engine.evaluate(null, focus, focus, (Base)focus, node);
        this.check(!this.validating || matches.size() >= (link.hasMin() ? link.getMin() : 0), "Link at path " + path + " requires at least " + link.getMin() + " matches, but only found " + matches.size());
        this.check(!this.validating || matches.size() <= (link.hasMax() ? Integer.parseInt(link.getMax()) : Integer.MAX_VALUE), "Link at path " + path + " requires at most " + link.getMax() + " matches, but found " + matches.size());
    }

    private void processLinkTarget(String focusPath, Resource focus, GraphDefinition.GraphDefinitionLinkComponent link, int depth) {
    }

    /*
     * WARNING - void declaration
     */
    private void parseParams(List<Argument> params, String value, Resource res) {
        boolean refed = false;
        Map<String, List<String>> p = this.splitQuery(value);
        for (String n : p.keySet()) {
            for (String string : p.get(n)) {
                void var9_9;
                if (string.equals("{ref}")) {
                    refed = true;
                    String string2 = res.fhirType() + "/" + res.getId();
                }
                params.add(new Argument(n, (Value)new StringValue((String)var9_9)));
            }
        }
        this.check(refed, "no use of {ref} found");
    }

    public Map<String, List<String>> splitQuery(String string) {
        String[] pairs;
        LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = string.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string2 = key = idx > 0 ? this.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!query_pairs.containsKey(key)) {
                query_pairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? this.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)query_pairs.get(key)).add(value);
        }
        return query_pairs;
    }

    private String decode(String s, String enc) {
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

