/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;

public class ElementVisitor {
    private IElementVisitor visitor;

    public ElementVisitor(IElementVisitor visitor) {
        this.visitor = visitor;
    }

    private void visitBase(Base base) {
        for (Property p : base.children()) {
            if (!p.hasValues()) continue;
            for (Base b : p.getValues()) {
                if (b instanceof Resource) {
                    this.visit((Resource)b);
                    continue;
                }
                this.visit((Element)b);
            }
        }
    }

    public void visit(Resource res) {
        this.visitor.visit(res);
        this.visitBase(res);
    }

    public void visit(Element e) {
        this.visitor.visit(e);
        this.visitBase(e);
    }

    public static interface IElementVisitor {
        public void visit(Resource var1);

        public void visit(Element var1);
    }
}

