/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.validation;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.terminologies.validation.ValueSetValidator;

public class VersionInfo {
    private final ValueSetValidator valueSetCheckerSimple;
    private String expansionVersion;
    private String composeVersion;

    VersionInfo(ValueSetValidator valueSetCheckerSimple) {
        this.valueSetCheckerSimple = valueSetCheckerSimple;
    }

    public String getExpansionVersion() {
        return this.expansionVersion;
    }

    public void setExpansionVersion(String expansionVersion) {
        this.expansionVersion = expansionVersion;
    }

    public String getComposeVersion() {
        return this.composeVersion;
    }

    public void setComposeVersion(String composeVersion) {
        this.composeVersion = composeVersion;
    }

    public String getVersion(String system, String version) {
        String fixedVersion = this.getVersionParameter("force-system-version", system);
        if (fixedVersion != null) {
            return fixedVersion;
        }
        String checkVersion = this.getVersionParameter("check-system-version", system);
        if (version != null) {
            if (checkVersion != null && !version.equals(checkVersion)) {
                throw new FHIRException("Attempt to use version " + version + " of " + system + ", when the expansion parameters limit the use to " + checkVersion);
            }
            return version;
        }
        if (this.expansionVersion != null) {
            if (checkVersion != null && !this.expansionVersion.equals(checkVersion)) {
                throw new FHIRException("Attempt to use version " + this.expansionVersion + " of " + system + ", when the expansion parameters limit the use to " + checkVersion);
            }
            return this.expansionVersion;
        }
        if (this.composeVersion != null) {
            if (checkVersion != null && !this.composeVersion.equals(checkVersion)) {
                throw new FHIRException("Attempt to use version " + this.composeVersion + " of " + system + ", when the expansion parameters limit the use to " + checkVersion);
            }
            return this.composeVersion;
        }
        return this.getVersionParameter("system-version", system);
    }

    private String getVersionParameter(String name, String system) {
        if (this.valueSetCheckerSimple.expansionProfile != null) {
            for (Parameters.ParametersParameterComponent pc : this.valueSetCheckerSimple.expansionProfile.getParameter()) {
                String v;
                if (!name.equals(pc.getName()) || !pc.hasValue() || (v = pc.getValue().primitiveValue()) == null || !v.startsWith(system + "|")) continue;
                return v.substring(system.length() + 1);
            }
        }
        return null;
    }
}

