/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

public class ValueSetProcessBase {
    protected AlternateCodesProcessingRules altCodeParams = new AlternateCodesProcessingRules(false);
    protected AlternateCodesProcessingRules allAltCodes = new AlternateCodesProcessingRules(true);

    public static class AlternateCodesProcessingRules {
        private boolean all;
        private List<String> uses = new ArrayList<String>();

        public AlternateCodesProcessingRules(boolean b) {
            this.all = b;
        }

        private void seeParameter(DataType value) {
            if (value != null) {
                String s;
                if (value instanceof BooleanType) {
                    this.all = ((BooleanType)value).booleanValue();
                    this.uses.clear();
                } else if (value.isPrimitive() && !Utilities.noString((String)(s = value.primitiveValue()))) {
                    this.uses.add(s);
                }
            }
        }

        public void seeParameters(Parameters pp) {
            for (Parameters.ParametersParameterComponent p : pp.getParameter()) {
                String name = p.getName();
                if (!"includeAlternateCodes".equals(name)) continue;
                DataType value = p.getValue();
                this.seeParameter(value);
            }
        }

        public void seeValueSet(ValueSet vs) {
            if (vs != null) {
                for (Extension ext : vs.getCompose().getExtension()) {
                    if (!"http://hl7.org/fhir/tools/StructureDefinion/valueset-expansion-param".equals(ext.getUrl())) continue;
                    String name = ext.getExtensionString("name");
                    Extension value = ext.getExtensionByUrl("value");
                    if (!"includeAlternateCodes".equals(name) || value == null || !value.hasValue()) continue;
                    this.seeParameter(value.getValue());
                }
            }
        }

        public boolean passes(List<Extension> extensions) {
            if (this.all) {
                return true;
            }
            for (Extension ext : extensions) {
                if (!"http://hl7.org/fhir/StructureDefinition/alternate-code-use".equals(ext.getUrl()) || !ext.hasValueCoding() || !Utilities.existsInList((String)ext.getValueCoding().getCode(), this.uses)) continue;
                return true;
            }
            return false;
        }
    }
}

