/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.LoincLinker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ValueSetRenderer
extends TerminologyRenderer {
    private static final String ABSTRACT_CODE_HINT = "This code is not selectable ('Abstract')";
    private static final int MAX_DESIGNATIONS_IN_LINE = 5;
    private List<TerminologyRenderer.ConceptMapRenderInstructions> renderingMaps = new ArrayList<TerminologyRenderer.ConceptMapRenderInstructions>();

    public ValueSetRenderer(RenderingContext context) {
        super(context);
    }

    public ValueSetRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (ValueSet)dr, false);
    }

    public boolean render(XhtmlNode x, ValueSet vs, boolean header) throws FHIRFormatError, DefinitionException, IOException {
        List<TerminologyRenderer.UsedConceptMap> maps = this.findReleventMaps(vs);
        boolean hasExtensions = vs.hasExpansion() ? this.generateExpansion(x, vs, header, maps) : this.generateComposition(x, vs, header, maps);
        return hasExtensions;
    }

    public void describe(XhtmlNode x, ValueSet vs) {
        x.tx(this.display(vs));
    }

    public String display(ValueSet vs) {
        return vs.present();
    }

    private List<TerminologyRenderer.UsedConceptMap> findReleventMaps(ValueSet vs) throws FHIRException {
        ArrayList<TerminologyRenderer.UsedConceptMap> res = new ArrayList<TerminologyRenderer.UsedConceptMap>();
        for (ConceptMap cm : this.getContext().getWorker().fetchResourcesByType(ConceptMap.class)) {
            if (!this.isSource(vs, cm.getSourceScope())) continue;
            TerminologyRenderer.ConceptMapRenderInstructions re = this.findByTarget(cm.getTargetScope());
            if (re == null) {
                re = new TerminologyRenderer.ConceptMapRenderInstructions(cm.present(), cm.getUrl(), false);
            }
            if (re == null) continue;
            Resource vst = cm.hasTargetScope() ? this.getContext().getWorker().fetchResource(ValueSet.class, cm.hasTargetScopeCanonicalType() ? (String)cm.getTargetScopeCanonicalType().getValue() : cm.getTargetScopeUriType().asStringValue(), cm) : null;
            res.add(new TerminologyRenderer.UsedConceptMap(re, vst == null ? cm.getWebPath() : vst.getWebPath(), cm));
        }
        return res;
    }

    private boolean isSource(ValueSet vs, DataType source) {
        return vs.hasUrl() && source != null && vs.getUrl().equals(source.primitiveValue());
    }

    private boolean generateExpansion(XhtmlNode x, ValueSet vs, boolean header, List<TerminologyRenderer.UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        boolean hasExtensions = false;
        ArrayList<String> langs = new ArrayList<String>();
        HashMap<String, String> designations = new HashMap<String, String>();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (header) {
            XhtmlNode h = x.addTag(this.getHeader());
            h.tx("Value Set Contents");
            if (this.IsNotFixedExpansion(vs)) {
                this.addMarkdown(x, vs.getDescription());
            }
            if (vs.hasCopyright()) {
                this.generateCopyright(x, vs);
            }
        }
        if (ToolingExtensions.hasExtension(vs.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
            List<Extension> exl = vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-toocostly");
            boolean other = false;
            for (Extension ex : exl) {
                if (ex.getValue() instanceof BooleanType) {
                    x.para().style("border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(vs.getExpansion().getContains().isEmpty() ? this.getContext().getTooCostlyNoteEmpty() : this.getContext().getTooCostlyNoteNotEmpty());
                    continue;
                }
                if (other) continue;
                x.para().style("border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(vs.getExpansion().getContains().isEmpty() ? this.getContext().getTooCostlyNoteEmptyDependent() : this.getContext().getTooCostlyNoteNotEmptyDependent());
                other = true;
            }
        } else {
            Integer count = this.countMembership(vs);
            if (count == null) {
                x.para().tx("This value set does not contain a fixed number of concepts");
            } else {
                x.para().tx("This value set contains " + count.toString() + " concepts");
            }
        }
        this.generateContentModeNotices(x, vs.getExpansion(), vs);
        this.generateVersionNotice(x, vs.getExpansion(), vs);
        CodeSystem allCS = null;
        boolean doLevel = false;
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (!cc.hasContains()) continue;
            doLevel = true;
            break;
        }
        boolean doDefinition = this.checkDoDefinition(vs.getExpansion().getContains());
        XhtmlNode t = x.table("codes");
        XhtmlNode tr = t.tr();
        if (doLevel) {
            tr.td().b().tx("Level");
        }
        tr.td().attribute("style", "white-space:nowrap").b().tx("Code");
        tr.td().b().tx("System");
        XhtmlNode tdDisp = tr.td();
        tdDisp.b().tx("Display");
        boolean doDesignations = false;
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.scanForDesignations(c, langs, designations);
        }
        this.scanForProperties(vs.getExpansion(), langs, properties);
        if (doDefinition) {
            tr.td().b().tx("Definition");
            doDesignations = false;
            for (String n : Utilities.sorted(properties.keySet())) {
                tr.td().b().ah((String)properties.get(n)).addText(n);
            }
        } else {
            for (String n : Utilities.sorted(properties.keySet())) {
                tr.td().b().ah((String)properties.get(n)).addText(n);
            }
            boolean bl = doDesignations = langs.size() + properties.size() + designations.size() < 5;
            if (doDesignations) {
                if (vs.hasLanguage()) {
                    tdDisp.tx(" - " + this.describeLang(vs.getLanguage()));
                }
                for (String url : designations.keySet()) {
                    tr.td().b().addText((String)designations.get(url));
                }
                for (String lang : langs) {
                    tr.td().b().addText(this.describeLang(lang));
                }
            }
        }
        this.addMapHeaders(tr, maps);
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.addExpansionRowToTable(t, vs, c, 1, doLevel, true, doDefinition, maps, allCS, langs, designations, doDesignations, properties);
        }
        if (!doDesignations && langs.size() + designations.size() > 0) {
            Collections.sort(langs);
            if (designations.size() == 0) {
                x.para().b().tx("Additional Language Displays");
            } else if (langs.size() == 0) {
                x.para().b().tx("Additional Designations");
            } else {
                x.para().b().tx("Additional Designations and Language Displays");
            }
            t = x.table("codes");
            tr = t.tr();
            tr.td().b().tx("Code");
            for (String url : designations.keySet()) {
                tr.td().b().addText((String)designations.get(url));
            }
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
                this.addDesignationRow(c, t, langs, designations);
            }
        }
        return hasExtensions;
    }

    private void scanForProperties(ValueSet.ValueSetExpansionComponent exp, List<String> langs, Map<String, String> properties) {
        properties.clear();
        for (ValueSet.ValueSetExpansionPropertyComponent pp : exp.getProperty()) {
            if (!pp.hasCode() || !pp.hasUri() || !this.anyActualproperties(exp.getContains(), pp.getCode())) continue;
            properties.put(pp.getCode(), pp.getUri());
        }
    }

    private boolean anyActualproperties(List<ValueSet.ValueSetExpansionContainsComponent> contains, String pp) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            for (ValueSet.ConceptPropertyComponent cp : c.getProperty()) {
                if (!pp.equals(cp.getCode())) continue;
                return true;
            }
            if (!this.anyActualproperties(c.getContains(), pp)) continue;
            return true;
        }
        return false;
    }

    private void generateContentModeNotices(XhtmlNode x, ValueSet.ValueSetExpansionComponent expansion, Resource vs) {
        this.generateContentModeNotice(x, expansion, "example", "Expansion based on example code system", vs);
        this.generateContentModeNotice(x, expansion, "fragment", "Expansion based on code system fragment", vs);
    }

    private void generateContentModeNotice(XhtmlNode x, ValueSet.ValueSetExpansionComponent expansion, String mode, String text, Resource vs) {
        HashMultimap versions = HashMultimap.create();
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            String[] parts;
            if (!p.getName().equals(mode) || (parts = ((PrimitiveType)p.getValue()).asStringValue().split("\\|")).length != 2 || Utilities.noString((String)parts[0])) continue;
            versions.put((Object)parts[0], (Object)parts[1]);
        }
        if (versions.size() > 0) {
            XhtmlNode div = null;
            XhtmlNode ul = null;
            boolean first = true;
            for (String s : versions.keySet()) {
                if (versions.size() == 1 && versions.get((Object)s).size() == 1) {
                    for (String v : versions.get((Object)s)) {
                        XhtmlNode p = x.para().style("border: black 1px dotted; background-color: #ffcccc; padding: 8px; margin-bottom: 8px");
                        p.tx(text + " ");
                        this.expRef(p, s, v, vs);
                    }
                    continue;
                }
                for (String v : versions.get((Object)s)) {
                    if (first) {
                        div = x.div().style("border: black 1px dotted; background-color: #EEEEEE; padding: 8px; margin-bottom: 8px");
                        div.para().tx(text + "s: ");
                        ul = div.ul();
                        first = false;
                    }
                    this.expRef(ul.li(), s, v, vs);
                }
            }
        }
    }

    private boolean checkDoSystem(ValueSet vs, ValueSet src) {
        if (src != null) {
            vs = src;
        }
        return vs.hasCompose();
    }

    private boolean IsNotFixedExpansion(ValueSet vs) {
        if (vs.hasCompose()) {
            return false;
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            if (cc.hasValueSet()) {
                return true;
            }
            if (cc.hasVersion()) continue;
            return true;
        }
        return false;
    }

    private TerminologyRenderer.ConceptMapRenderInstructions findByTarget(DataType source) {
        if (source == null) {
            return null;
        }
        String src = source.primitiveValue();
        if (src == null) {
            return null;
        }
        for (TerminologyRenderer.ConceptMapRenderInstructions t : this.renderingMaps) {
            if (!src.equals(t.getUrl())) continue;
            return t;
        }
        return null;
    }

    private Integer countMembership(ValueSet vs) {
        int count = 0;
        if (vs.hasExpansion()) {
            count += this.conceptCount(vs.getExpansion().getContains());
        } else if (vs.hasCompose()) {
            if (vs.getCompose().hasExclude()) {
                try {
                    ValueSetExpansionOutcome vse = this.getContext().getWorker().expandVS(vs, true, false);
                    count = 0;
                    return count += this.conceptCount(vse.getValueset().getExpansion().getContains());
                }
                catch (Exception e) {
                    return null;
                }
            }
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                if (inc.hasFilter()) {
                    return null;
                }
                if (!inc.hasConcept()) {
                    return null;
                }
                count += inc.getConcept().size();
            }
        }
        return count;
    }

    private int conceptCount(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        int count = 0;
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (!c.getAbstract()) {
                ++count;
            }
            count += this.conceptCount(c.getContains());
        }
        return count;
    }

    private void addCSRef(XhtmlNode x, String url) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(url);
        if (cs == null) {
            x.code(url);
        } else if (cs.hasWebPath()) {
            x.ah(cs.getWebPath()).tx(cs.present());
        } else {
            x.code(url);
            x.tx(" (" + cs.present() + ")");
        }
    }

    private void generateVersionNotice(XhtmlNode x, ValueSet.ValueSetExpansionComponent expansion, Resource vs) {
        HashMultimap versions = HashMultimap.create();
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            String[] parts;
            if (!p.getName().equals("version") || (parts = ((PrimitiveType)p.getValue()).asStringValue().split("\\|")).length != 2 || Utilities.noString((String)parts[0])) continue;
            versions.put((Object)parts[0], (Object)parts[1]);
        }
        if (versions.size() > 0) {
            XhtmlNode div = null;
            XhtmlNode ul = null;
            boolean first = true;
            for (String s : versions.keySet()) {
                if (versions.size() == 1 && versions.get((Object)s).size() == 1) {
                    for (String v : versions.get((Object)s)) {
                        XhtmlNode p = x.para().style("border: black 1px dotted; background-color: #EEEEEE; padding: 8px; margin-bottom: 8px");
                        p.tx("Expansion based on ");
                        this.expRef(p, s, v, vs);
                    }
                    continue;
                }
                for (String v : versions.get((Object)s)) {
                    if (first) {
                        div = x.div().style("border: black 1px dotted; background-color: #EEEEEE; padding: 8px; margin-bottom: 8px");
                        div.para().tx("Expansion based on: ");
                        ul = div.ul();
                        first = false;
                    }
                    this.expRef(ul.li(), s, v, vs);
                }
            }
        }
    }

    private void expRef(XhtmlNode x, String u, String v, Resource source) {
        if (u.equals("http://snomed.info/sct")) {
            String[] parts = v.split("\\/");
            if (parts.length >= 5) {
                String m = this.describeModule(parts[4]);
                if (parts.length == 7) {
                    x.tx("SNOMED CT " + m + " edition " + this.formatSCTDate(parts[6]));
                } else {
                    x.tx("SNOMED CT " + m + " edition");
                }
            } else {
                x.tx(ValueSetRenderer.describeSystem(u) + " version " + v);
            }
        } else if (u.equals("http://loinc.org")) {
            String vd = this.describeLoincVer(v);
            if (vd != null) {
                x.tx("Loinc v" + v + " (" + vd + ")");
            } else {
                x.tx("Loinc v" + v);
            }
        } else if (Utilities.noString((String)v)) {
            CanonicalResource cr = (CanonicalResource)this.getContext().getWorker().fetchResource(Resource.class, u, source);
            if (cr != null) {
                if (cr.hasWebPath()) {
                    x.ah(cr.getWebPath()).tx(cr.present() + " (no version) (" + cr.fhirType() + ")");
                } else {
                    x.tx(ValueSetRenderer.describeSystem(u) + " (no version) (" + cr.fhirType() + ")");
                }
            } else {
                x.tx(ValueSetRenderer.describeSystem(u) + " (no version)");
            }
        } else {
            CanonicalResource cr = (CanonicalResource)this.getContext().getWorker().fetchResource(Resource.class, u + "|" + v, source);
            if (cr != null) {
                if (cr.hasWebPath()) {
                    x.ah(cr.getWebPath()).tx(cr.present() + " v" + v + " (" + cr.fhirType() + ")");
                } else {
                    x.tx(ValueSetRenderer.describeSystem(u) + " v" + v + " (" + cr.fhirType() + ")");
                }
            } else {
                x.tx(ValueSetRenderer.describeSystem(u) + " version " + v);
            }
        }
    }

    private String describeLoincVer(String v) {
        if ("2.67".equals(v)) {
            return "Dec 2019";
        }
        if ("2.66".equals(v)) {
            return "Jun 2019";
        }
        if ("2.65".equals(v)) {
            return "Dec 2018";
        }
        if ("2.64".equals(v)) {
            return "Jun 2018";
        }
        if ("2.63".equals(v)) {
            return "Dec 2017";
        }
        if ("2.61".equals(v)) {
            return "Jun 2017";
        }
        if ("2.59".equals(v)) {
            return "Feb 2017";
        }
        if ("2.58".equals(v)) {
            return "Dec 2016";
        }
        if ("2.56".equals(v)) {
            return "Jun 2016";
        }
        if ("2.54".equals(v)) {
            return "Dec 2015";
        }
        if ("2.52".equals(v)) {
            return "Jun 2015";
        }
        if ("2.50".equals(v)) {
            return "Dec 2014";
        }
        if ("2.48".equals(v)) {
            return "Jun 2014";
        }
        if ("2.46".equals(v)) {
            return "Dec 2013";
        }
        if ("2.44".equals(v)) {
            return "Jun 2013";
        }
        if ("2.42".equals(v)) {
            return "Dec 2012";
        }
        if ("2.40".equals(v)) {
            return "Jun 2012";
        }
        if ("2.38".equals(v)) {
            return "Dec 2011";
        }
        if ("2.36".equals(v)) {
            return "Jun 2011";
        }
        if ("2.34".equals(v)) {
            return "Dec 2010";
        }
        if ("2.32".equals(v)) {
            return "Jun 2010";
        }
        if ("2.30".equals(v)) {
            return "Feb 2010";
        }
        if ("2.29".equals(v)) {
            return "Dec 2009";
        }
        if ("2.27".equals(v)) {
            return "Jul 2009";
        }
        if ("2.26".equals(v)) {
            return "Jan 2009";
        }
        if ("2.24".equals(v)) {
            return "Jul 2008";
        }
        if ("2.22".equals(v)) {
            return "Dec 2007";
        }
        if ("2.21".equals(v)) {
            return "Jun 2007";
        }
        if ("2.19".equals(v)) {
            return "Dec 2006";
        }
        if ("2.17".equals(v)) {
            return "Jun 2006";
        }
        if ("2.16".equals(v)) {
            return "Dec 2005";
        }
        if ("2.15".equals(v)) {
            return "Jun 2005";
        }
        if ("2.14".equals(v)) {
            return "Dec 2004";
        }
        if ("2.13".equals(v)) {
            return "Aug 2004";
        }
        if ("2.12".equals(v)) {
            return "Feb 2004";
        }
        if ("2.10".equals(v)) {
            return "Oct 2003";
        }
        if ("2.09".equals(v)) {
            return "May 2003";
        }
        if ("2.08 ".equals(v)) {
            return "Sep 2002";
        }
        if ("2.07".equals(v)) {
            return "Aug 2002";
        }
        if ("2.05".equals(v)) {
            return "Feb 2002";
        }
        if ("2.04".equals(v)) {
            return "Jan 2002";
        }
        if ("2.03".equals(v)) {
            return "Jul 2001";
        }
        if ("2.02".equals(v)) {
            return "May 2001";
        }
        if ("2.01".equals(v)) {
            return "Jan 2001";
        }
        if ("2.00".equals(v)) {
            return "Jan 2001";
        }
        if ("1.0n".equals(v)) {
            return "Feb 2000";
        }
        if ("1.0ma".equals(v)) {
            return "Aug 1999";
        }
        if ("1.0m".equals(v)) {
            return "Jul 1999";
        }
        if ("1.0l".equals(v)) {
            return "Jan 1998";
        }
        if ("1.0ja".equals(v)) {
            return "Oct 1997";
        }
        return null;
    }

    private String formatSCTDate(String ds) {
        Date date;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            date = format.parse(ds);
        }
        catch (ParseException e) {
            return ds;
        }
        return new SimpleDateFormat("dd-MMM yyyy").format(date);
    }

    private String describeModule(String module) {
        if ("900000000000207008".equals(module)) {
            return "International";
        }
        if ("731000124108".equals(module)) {
            return "United States";
        }
        if ("32506021000036107".equals(module)) {
            return "Australian";
        }
        if ("449081005".equals(module)) {
            return "Spanish";
        }
        if ("554471000005108".equals(module)) {
            return "Danish";
        }
        if ("11000146104".equals(module)) {
            return "Dutch";
        }
        if ("45991000052106".equals(module)) {
            return "Swedish";
        }
        if ("999000041000000102".equals(module)) {
            return "United Kingdon";
        }
        return module;
    }

    private boolean hasVersionParameter(ValueSet.ValueSetExpansionComponent expansion) {
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            if (!p.getName().equals("version")) continue;
            return true;
        }
        return false;
    }

    private void addDesignationRow(ValueSet.ValueSetExpansionContainsComponent c, XhtmlNode t, List<String> langs, Map<String, String> designations) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        this.addDesignationsToRow(c, designations, tr);
        this.addLangaugesToRow(c, langs, tr);
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addDesignationRow(cc, t, langs, designations);
        }
    }

    public void addDesignationsToRow(ValueSet.ValueSetExpansionContainsComponent c, Map<String, String> designations, XhtmlNode tr) {
        for (String url : designations.keySet()) {
            String d = null;
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    if (!url.equals(this.getUrlForDesignation(dd))) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    public void addLangaugesToRow(ValueSet.ValueSetExpansionContainsComponent c, List<String> langs, XhtmlNode tr) {
        for (String lang : langs) {
            String l;
            String d = null;
            for (Extension ext : c.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || !lang.equals(l = ToolingExtensions.readStringExtension(ext, "lang"))) continue;
                d = ToolingExtensions.readStringExtension(ext, "content");
            }
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    l = dd.getLanguage();
                    if (!lang.equals(l)) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    private boolean checkDoDefinition(List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            CodeSystem.ConceptDefinitionComponent cd;
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(c.getSystem());
            if (cs != null && (cd = CodeSystemUtilities.getCode(cs, c.getCode())) != null && cd.hasDefinition()) {
                return true;
            }
            if (!this.checkDoDefinition(c.getContains())) continue;
            return true;
        }
        return false;
    }

    private boolean allFromOneSystem(ValueSet vs) {
        if (vs.getExpansion().getContains().isEmpty()) {
            return false;
        }
        String system = vs.getExpansion().getContains().get(0).getSystem();
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (this.checkSystemMatches(system, cc)) continue;
            return false;
        }
        return true;
    }

    private String getCsRef(String system) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(system);
        return this.getCsRef(cs);
    }

    private <T extends Resource> String getCsRef(T cs) {
        if (cs == null) {
            return "?cs-n?";
        }
        Object ref = (String)cs.getUserData("filename");
        if (ref == null) {
            ref = cs.getWebPath();
        }
        if (ref == null) {
            return "?ngen-14?.html";
        }
        if (!((String)ref).contains(".html")) {
            ref = (String)ref + ".html";
        }
        return ((String)ref).replace("\\", "/");
    }

    private void scanForDesignations(ValueSet.ValueSetExpansionContainsComponent c, List<String> langs, Map<String, String> designations) {
        String lang;
        for (Extension ext : c.getExtension()) {
            if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ToolingExtensions.readStringExtension(ext, "lang"))) || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : c.getDesignation()) {
            lang = d.getLanguage();
            if (!Utilities.noString((String)lang) && !langs.contains(lang)) {
                langs.add(lang);
                continue;
            }
            String disp = this.getDisplayForDesignation(d);
            String url = this.getUrlForDesignation(d);
            if (disp == null) {
                disp = this.getDisplayForUrl(url);
            }
            if (disp == null || designations.containsKey(url) || url == null) continue;
            designations.put(url, disp);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.scanForDesignations(cc, langs, designations);
        }
    }

    private void scanForLangs(ValueSet.ValueSetExpansionContainsComponent c, List<String> langs) {
        String lang;
        for (Extension ext : c.getExtension()) {
            if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ToolingExtensions.readStringExtension(ext, "lang"))) || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : c.getDesignation()) {
            lang = d.getLanguage();
            if (Utilities.noString((String)lang) || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.scanForLangs(cc, langs);
        }
    }

    private void addExpansionRowToTable(XhtmlNode t, ValueSet vs, ValueSet.ValueSetExpansionContainsComponent c, int i, boolean doLevel, boolean doSystem, boolean doDefinition, List<TerminologyRenderer.UsedConceptMap> maps, CodeSystem allCS, List<String> langs, Map<String, String> designations, boolean doDesignations, Map<String, String> properties) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode tr = t.tr();
        if (ValueSetUtilities.isDeprecated(vs, c)) {
            tr.setAttribute("style", "background-color: #ffeeee");
        }
        XhtmlNode td = tr.td();
        String tgt = this.makeAnchor(c.getSystem(), c.getCode());
        td.an(tgt);
        if (doLevel) {
            td.addText(Integer.toString(i));
            td = tr.td();
        }
        String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(i * 2));
        td.attribute("style", "white-space:nowrap").addText(s);
        this.addCodeToTable(c.getAbstract(), c.getSystem(), c.getCode(), c.getDisplay(), td);
        if (doSystem) {
            td = tr.td();
            td.addText(c.getSystem());
        }
        td = tr.td();
        if (c.hasDisplayElement()) {
            td.addText(c.getDisplay());
        }
        if (doDefinition) {
            CodeSystem cs = allCS;
            if (cs == null) {
                cs = this.getContext().getWorker().fetchCodeSystem(c.getSystem());
            }
            td = tr.td();
            if (cs != null) {
                String defn = CodeSystemUtilities.getCodeDefinition(cs, c.getCode());
                this.addMarkdown(td, defn, cs.getWebPath());
            }
        }
        for (String n : Utilities.sorted(properties.keySet())) {
            td = tr.td();
            String ps = this.getPropertyValue(c, n);
            if (Utilities.noString((String)ps)) continue;
            td.addText(ps);
        }
        for (TerminologyRenderer.UsedConceptMap m : maps) {
            td = tr.td();
            List<TerminologyRenderer.TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), m.getMap());
            boolean first = true;
            for (TerminologyRenderer.TargetElementComponentWrapper mapping : mappings) {
                if (!first) {
                    td.br();
                }
                first = false;
                XhtmlNode span = td.span(null, mapping.comp.getRelationship().toString());
                span.addText(this.getCharForRelationship(mapping.comp));
                this.addRefToCode(td, mapping.group.getTarget(), m.getLink(), mapping.comp.getCode());
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
        if (doDesignations) {
            this.addDesignationsToRow(c, designations, tr);
            this.addLangaugesToRow(c, langs, tr);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addExpansionRowToTable(t, vs, cc, i + 1, doLevel, doSystem, doDefinition, maps, allCS, langs, designations, doDesignations, properties);
        }
    }

    private String getPropertyValue(ValueSet.ValueSetExpansionContainsComponent c, String n) {
        for (ValueSet.ConceptPropertyComponent cp : c.getProperty()) {
            if (!n.equals(cp.getCode())) continue;
            return cp.getValue().primitiveValue();
        }
        return null;
    }

    private boolean checkSystemMatches(String system, ValueSet.ValueSetExpansionContainsComponent cc) {
        if (!system.equals(cc.getSystem())) {
            return false;
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : cc.getContains()) {
            if (this.checkSystemMatches(system, cc1)) continue;
            return false;
        }
        return true;
    }

    private void addCodeToTable(boolean isAbstract, String system, String code, String display, XhtmlNode td) {
        CodeSystem e = this.getContext().getWorker().fetchCodeSystem(system);
        if (e == null || e.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && e.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
            if (isAbstract) {
                td.i().setAttribute("title", ABSTRACT_CODE_HINT).addText(code);
            } else if ("http://snomed.info/sct".equals(system)) {
                td.ah(this.sctLink(code)).addText(code);
            } else if ("http://loinc.org".equals(system)) {
                td.ah(LoincLinker.getLinkForCode((String)code)).addText(code);
            } else {
                td.addText(code);
            }
        } else {
            Object href = this.context.fixReference(this.getCsRef(e));
            href = ((String)href).contains("#") ? (String)href + "-" + Utilities.nmtokenize((String)code) : (String)href + "#" + e.getId() + "-" + Utilities.nmtokenize((String)code);
            if (isAbstract) {
                td.ah((String)href).setAttribute("title", ABSTRACT_CODE_HINT).i().addText(code);
            } else {
                td.ah((String)href).addText(code);
            }
        }
    }

    public String sctLink(String code) {
        return "http://snomed.info/id/" + code;
    }

    private void addRefToCode(XhtmlNode td, String target, String vslink, String code) {
        this.addCodeToTable(false, target, code, null, td);
    }

    private boolean generateComposition(XhtmlNode x, ValueSet vs, boolean header, List<TerminologyRenderer.UsedConceptMap> maps) throws FHIRException, IOException {
        boolean doDesignations;
        boolean hasExtensions = false;
        ArrayList<String> langs = new ArrayList<String>();
        HashMap<String, String> designations = new HashMap<String, String>();
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.scanDesignations(inc, langs, designations);
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.scanDesignations(inc, langs, designations);
        }
        boolean bl = doDesignations = langs.size() + designations.size() < 5;
        if (header) {
            XhtmlNode h = x.h2();
            h.addText(vs.present());
            this.addMarkdown(x, vs.getDescription());
            if (vs.hasCopyrightElement()) {
                this.generateCopyright(x, vs);
            }
        }
        int index = 0;
        if (vs.getCompose().getInclude().size() == 1 && vs.getCompose().getExclude().size() == 0) {
            hasExtensions = this.genInclude(x.ul(), vs.getCompose().getInclude().get(0), "Include", langs, doDesignations, maps, designations, index, vs) || hasExtensions;
        } else {
            XhtmlNode p = x.para();
            p.tx("This value set includes codes based on the following rules:");
            XhtmlNode ul = x.ul();
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                hasExtensions = this.genInclude(ul, inc, "Include", langs, doDesignations, maps, designations, index, vs) || hasExtensions;
                ++index;
            }
            if (vs.getCompose().hasExclude()) {
                p = x.para();
                p.tx("This value set excludes codes based on the following rules:");
                ul = x.ul();
                for (ValueSet.ConceptSetComponent exc : vs.getCompose().getExclude()) {
                    hasExtensions = this.genInclude(ul, exc, "Exclude", langs, doDesignations, maps, designations, index, vs) || hasExtensions;
                    ++index;
                }
            }
        }
        if (!doDesignations && langs.size() + designations.size() > 0) {
            Collections.sort(langs);
            if (designations.size() == 0) {
                x.para().b().tx("Additional Language Displays");
            } else if (langs.size() == 0) {
                x.para().b().tx("Additional Designations");
            } else {
                x.para().b().tx("Additional Designations and Language Displays");
            }
            XhtmlNode t = x.table("codes");
            XhtmlNode tr = t.tr();
            tr.td().b().tx("Code");
            for (String url : designations.keySet()) {
                tr.td().b().addText((String)designations.get(url));
            }
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (ValueSet.ConceptSetComponent c : vs.getCompose().getInclude()) {
                for (ValueSet.ConceptReferenceComponent cc : c.getConcept()) {
                    this.addDesignationRow(cc, t, langs, designations);
                }
            }
        }
        return hasExtensions;
    }

    private void renderExpansionRules(XhtmlNode x, ValueSet.ConceptSetComponent inc, int index, Map<String, CodeSystem.ConceptDefinitionComponent> definitions) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        String rule;
        String s = "This include specifies a heirarchy for when value sets are generated for use in a User Interface, but the rules are not properly defined";
        if (inc.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-expand-rules") && (rule = inc.getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-expand-rules")) != null) {
            switch (rule) {
                case "all-codes": {
                    s = "This include specifies a heirarchy for when value sets are generated for use in a User Interface. The expansion contains all the codes, and also this structure:";
                }
                case "ungrouped": {
                    s = "This include specifies a heirarchy for when value sets are generated for use in a User Interface. The expansion contains this structure, and any codes not found in the structure:";
                }
                case "groups-only": {
                    s = "This include specifies a heirarchy for when value sets are generated for use in a User Interface. The expansion contains this structure:";
                }
            }
        }
        x.br();
        x.tx(s);
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "exp.h=" + index, this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER);
        model.setAlternating(true);
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("vs.exp.header", "Code"), this.translate("vs.exp.hint", "The code for the item"), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("vs.exp.header", "Display"), this.translate("vs.exp.hint", "The display for the item"), null, 0));
        for (Extension ext : inc.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-expand-group")) {
            this.renderExpandGroup(gen, model, ext, inc, definitions);
        }
        x.br();
        x.tx("table");
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
    }

    private void renderExpandGroup(HierarchicalTableGenerator gen, HierarchicalTableGenerator.TableModel model, Extension ext, ValueSet.ConceptSetComponent inc, Map<String, CodeSystem.ConceptDefinitionComponent> definitions) {
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        model.getRows().add(row);
        row.setIcon("icon_entry_blue.png", "entry");
        String code = ext.getExtensionString("code");
        if (code != null) {
            List list = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, code, null, null));
            List list2 = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, this.getDisplayForCode(inc, code, definitions), null, null));
        } else if (ext.hasId()) {
            List list = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "(#" + ext.getId() + ")", null, null));
            List list3 = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, ext.getExtensionString("display"), null, null));
        } else {
            List list = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null));
            List list4 = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, ext.getExtensionString("display"), null, null));
        }
        for (Extension member : ext.getExtensionsByUrl("member")) {
            HierarchicalTableGenerator.Row subRow = new HierarchicalTableGenerator.Row(gen);
            row.getSubRows().add(subRow);
            subRow.setIcon("icon_entry_blue.png", "entry");
            String mc = member.getValue().primitiveValue();
            if (mc.startsWith("#")) {
                List list = subRow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "(" + mc + ")", null, null));
                List list5 = subRow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "group reference by id", null, null));
                continue;
            }
            Extension tgt = this.findTargetByCode(inc, mc);
            if (tgt != null) {
                List list = subRow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, mc, null, null));
                List list6 = subRow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, "group reference by code", null, null));
                continue;
            }
            List list = subRow.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, mc, null, null));
            List list7 = subRow.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, this.getDisplayForCode(inc, mc, definitions), null, null));
        }
    }

    private Extension findTargetByCode(ValueSet.ConceptSetComponent inc, String mc) {
        for (Extension ext : inc.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-expand-group")) {
            String code = ext.getExtensionString("code");
            if (!mc.equals(code)) continue;
            return ext;
        }
        return null;
    }

    private String getDisplayForCode(ValueSet.ConceptSetComponent inc, String code, Map<String, CodeSystem.ConceptDefinitionComponent> definitions) {
        for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
            if (!code.equals(cc.getCode()) || !cc.hasDisplay()) continue;
            return cc.getDisplay();
        }
        if (definitions.containsKey(code)) {
            return definitions.get(code).getDisplay();
        }
        return null;
    }

    private void scanDesignations(ValueSet.ConceptSetComponent inc, List<String> langs, Map<String, String> designations) {
        for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
            String lang;
            for (Extension ext : cc.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ToolingExtensions.readStringExtension(ext, "lang"))) || langs.contains(lang)) continue;
                langs.add(lang);
            }
            for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
                lang = d.getLanguage();
                if (!Utilities.noString((String)lang) && !langs.contains(lang)) {
                    langs.add(lang);
                    continue;
                }
                String disp = this.getDisplayForDesignation(d);
                String url = this.getUrlForDesignation(d);
                if (disp == null) {
                    disp = this.getDisplayForUrl(url);
                }
                if (disp == null || designations.containsKey(url)) continue;
                designations.put(url, disp);
            }
        }
    }

    private String getDisplayForUrl(String url) {
        if (url == null) {
            return null;
        }
        switch (url) {
            case "http://snomed.info/sct#900000000000003001": {
                return "Fully specified name";
            }
            case "http://snomed.info/sct#900000000000013009": {
                return "Synonym";
            }
        }
        return url;
    }

    private String getUrlForDesignation(ValueSet.ConceptReferenceDesignationComponent d) {
        if (d.hasUse() && d.getUse().hasSystem() && d.getUse().hasCode()) {
            return d.getUse().getSystem() + "#" + d.getUse().getCode();
        }
        return null;
    }

    private String getDisplayForDesignation(ValueSet.ConceptReferenceDesignationComponent d) {
        if (d.hasUse() && d.getUse().hasDisplay()) {
            return d.getUse().getDisplay();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean genInclude(XhtmlNode ul, ValueSet.ConceptSetComponent inc, String type, List<String> langs, boolean doDesignations, List<TerminologyRenderer.UsedConceptMap> maps, Map<String, String> designations, int index, Resource vsRes) throws FHIRException, IOException {
        boolean hasExtensions;
        block45: {
            XhtmlNode li;
            block44: {
                hasExtensions = false;
                li = ul.li();
                CodeSystem e = this.getContext().getWorker().fetchCodeSystem(inc.getSystem());
                HashMap<String, CodeSystem.ConceptDefinitionComponent> definitions = new HashMap();
                if (!inc.hasSystem()) break block44;
                if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
                    li.addText(type + " all codes defined in ");
                    this.addCsRef(inc, li, e);
                } else {
                    if (inc.getConcept().size() > 0) {
                        boolean bl;
                        li.addText(type + " these codes as defined in ");
                        this.addCsRef(inc, li, e);
                        if (inc.hasVersion()) {
                            li.addText(" version ");
                            li.code(inc.getVersion());
                        }
                        definitions = this.getConceptsForCodes(e, inc);
                        XhtmlNode t = li.table("none");
                        boolean hasComments = false;
                        boolean bl2 = false;
                        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                            hasComments = hasComments || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments");
                            CodeSystem.ConceptDefinitionComponent cc = definitions == null ? null : (CodeSystem.ConceptDefinitionComponent)definitions.get(c.getCode());
                            bl = bl || cc != null && cc.hasDefinition() || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition");
                        }
                        if (hasComments || bl) {
                            hasExtensions = true;
                        }
                        this.addMapHeaders(this.addTableHeaderRowStandard(t, false, true, bl, hasComments, false, false, null, langs, designations, doDesignations), maps);
                        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                            XhtmlNode tr = t.tr();
                            XhtmlNode td = tr.td();
                            CodeSystem.ConceptDefinitionComponent cc = definitions == null ? null : (CodeSystem.ConceptDefinitionComponent)definitions.get(c.getCode());
                            this.addCodeToTable(false, inc.getSystem(), c.getCode(), c.hasDisplay() ? c.getDisplay() : (cc != null ? cc.getDisplay() : ""), td);
                            td = tr.td();
                            if (!Utilities.noString((String)c.getDisplay())) {
                                td.addText(c.getDisplay());
                            } else if (cc != null && !Utilities.noString((String)cc.getDisplay())) {
                                td.addText(cc.getDisplay());
                            }
                            if (bl) {
                                td = tr.td();
                                if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition")) {
                                    this.smartAddText(td, ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"));
                                } else if (cc != null && !Utilities.noString((String)cc.getDefinition())) {
                                    this.smartAddText(td, cc.getDefinition());
                                }
                            }
                            if (hasComments) {
                                td = tr.td();
                                if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments")) {
                                    this.smartAddText(td, "Note: " + ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments"));
                                }
                            }
                            if (doDesignations) {
                                this.addDesignationsToRow(c, designations, tr);
                                this.addLangaugesToRow(c, langs, tr);
                            }
                            for (TerminologyRenderer.UsedConceptMap m : maps) {
                                td = tr.td();
                                List<TerminologyRenderer.TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), m.getMap());
                                boolean first = true;
                                for (TerminologyRenderer.TargetElementComponentWrapper mapping : mappings) {
                                    if (!first) {
                                        td.br();
                                    }
                                    first = false;
                                    XhtmlNode span = td.span(null, mapping.comp.getRelationship().toString());
                                    span.addText(this.getCharForRelationship(mapping.comp));
                                    this.addRefToCode(td, mapping.group.getTarget(), m.getLink(), mapping.comp.getCode());
                                    if (Utilities.noString((String)mapping.comp.getComment())) continue;
                                    td.i().tx("(" + mapping.comp.getComment() + ")");
                                }
                            }
                        }
                    }
                    if (inc.getFilter().size() > 0) {
                        li.addText(type + " codes from ");
                        this.addCsRef(inc, li, e);
                        li.tx(" where ");
                        for (int i = 0; i < inc.getFilter().size(); ++i) {
                            ValueSet.ConceptSetFilterComponent f = inc.getFilter().get(i);
                            if (i > 0) {
                                if (i == inc.getFilter().size() - 1) {
                                    li.tx(" and ");
                                } else {
                                    li.tx(", ");
                                }
                            }
                            if (f.getOp() == Enumerations.FilterOperator.EXISTS) {
                                if (f.getValue().equals("true")) {
                                    li.tx(f.getProperty() + " exists");
                                    continue;
                                }
                                li.tx(f.getProperty() + " doesn't exist");
                                continue;
                            }
                            li.tx(f.getProperty() + " " + this.describe(f.getOp()) + " ");
                            if (e != null && this.codeExistsInValueSet(e, f.getValue())) {
                                void var16_29;
                                String string = this.getContext().fixReference(this.getCsRef(e));
                                if (string.contains("#")) {
                                    String string2 = string + "-" + Utilities.nmtokenize((String)f.getValue());
                                } else {
                                    String string3 = string + "#" + e.getId() + "-" + Utilities.nmtokenize((String)f.getValue());
                                }
                                li.ah((String)var16_29).addText(f.getValue());
                            } else if ("concept".equals(f.getProperty()) && inc.hasSystem()) {
                                li.addText(f.getValue());
                                IWorkerContext.ValidationResult validationResult = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions(), inc.getSystem(), inc.getVersion(), f.getValue(), null);
                                if (validationResult.isOk()) {
                                    li.tx(" (" + validationResult.getDisplay() + ")");
                                }
                            } else {
                                li.addText(f.getValue());
                            }
                            String string = ToolingExtensions.getDisplayHint(f);
                            if (string == null) continue;
                            li.tx(" (" + string + ")");
                        }
                    }
                }
                if (inc.hasValueSet()) {
                    li.tx(", where the codes are contained in ");
                    boolean first = true;
                    for (UriType uriType : inc.getValueSet()) {
                        if (first) {
                            first = false;
                        } else {
                            li.tx(", ");
                        }
                        this.AddVsRef(uriType.asStringValue(), li, vsRes);
                    }
                }
                if (!inc.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-expand-rules") && !inc.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-expand-group")) break block45;
                hasExtensions = true;
                this.renderExpansionRules(li, inc, index, definitions);
                break block45;
            }
            li.tx("Import all the codes that are contained in ");
            if (inc.getValueSet().size() < 4) {
                boolean first = true;
                for (UriType uriType : inc.getValueSet()) {
                    if (first) {
                        first = false;
                    } else {
                        li.tx(", ");
                    }
                    this.AddVsRef(uriType.asStringValue(), li, vsRes);
                }
            } else {
                XhtmlNode xul = li.ul();
                for (UriType uriType : inc.getValueSet()) {
                    this.AddVsRef(uriType.asStringValue(), xul.li(), vsRes);
                }
            }
        }
        return hasExtensions;
    }

    public void addDesignationsToRow(ValueSet.ConceptReferenceComponent c, Map<String, String> designations, XhtmlNode tr) {
        for (String url : designations.keySet()) {
            String d = null;
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    if (!url.equals(this.getUrlForDesignation(dd))) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    public void addLangaugesToRow(ValueSet.ConceptReferenceComponent c, List<String> langs, XhtmlNode tr) {
        for (String lang : langs) {
            String l;
            String d = null;
            for (Extension ext : c.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || !lang.equals(l = ToolingExtensions.readStringExtension(ext, "lang"))) continue;
                d = ToolingExtensions.readStringExtension(ext, "content");
            }
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    l = dd.getLanguage();
                    if (!lang.equals(l)) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    private Map<String, CodeSystem.ConceptDefinitionComponent> getConceptsForCodes(CodeSystem e, ValueSet.ConceptSetComponent inc) {
        if (e == null) {
            e = this.getContext().getWorker().fetchCodeSystem(inc.getSystem());
        }
        ValueSet.ValueSetExpansionComponent vse = null;
        if (!this.context.isNoSlowLookup()) {
            try {
                ValueSetExpansionOutcome vso = this.getContext().getWorker().expandVS(inc, false, false);
                ValueSet valueset = vso.getValueset();
                if (valueset == null) {
                    throw new TerminologyServiceException("Error Expanding ValueSet: " + vso.getError());
                }
                vse = valueset.getExpansion();
            }
            catch (TerminologyServiceException e1) {
                return null;
            }
        }
        HashMap<String, CodeSystem.ConceptDefinitionComponent> results = new HashMap<String, CodeSystem.ConceptDefinitionComponent>();
        ArrayList<IWorkerContext.CodingValidationRequest> serverList = new ArrayList<IWorkerContext.CodingValidationRequest>();
        for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
            String code = cc.getCode();
            CodeSystem.ConceptDefinitionComponent v = null;
            if (e != null && code != null) {
                v = this.getConceptForCode(e.getConcept(), code);
            }
            if (v == null && vse != null) {
                v = this.getConceptForCodeFromExpansion(vse.getContains(), code);
            }
            if (v != null) {
                results.put(code, v);
                continue;
            }
            serverList.add(new IWorkerContext.CodingValidationRequest(new Coding(inc.getSystem(), code, null)));
        }
        if (!this.context.isNoSlowLookup() && !serverList.isEmpty()) {
            this.getContext().getWorker().validateCodeBatch(this.getContext().getTerminologyServiceOptions(), serverList, null);
            for (IWorkerContext.CodingValidationRequest vr : serverList) {
                CodeSystem.ConceptDefinitionComponent v = vr.getResult().asConceptDefinition();
                if (v == null) continue;
                results.put(vr.getCoding().getCode(), v);
            }
        }
        return results;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCodeFromExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (code.equals(c.getCode())) {
                CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
                res.setCode(c.getCode());
                res.setDisplay(c.getDisplay());
                return res;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCodeFromExpansion(c.getContains(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private boolean codeExistsInValueSet(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            if (!this.inConcept(code, c)) continue;
            return true;
        }
        return false;
    }

    private void addDesignationRow(ValueSet.ConceptReferenceComponent c, XhtmlNode t, List<String> langs, Map<String, String> designations) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        this.addDesignationsToRow(c, designations, tr);
        this.addLangaugesToRow(c, langs, tr);
    }

    private String describe(Enumerations.FilterOperator op) {
        if (op == null) {
            return " null ";
        }
        switch (op) {
            case EQUAL: {
                return " = ";
            }
            case ISA: {
                return " is-a ";
            }
            case ISNOTA: {
                return " is-not-a ";
            }
            case REGEX: {
                return " matches (by regex) ";
            }
            case NULL: {
                return " ?ngen-13? ";
            }
            case IN: {
                return " in ";
            }
            case NOTIN: {
                return " not in ";
            }
            case DESCENDENTOF: {
                return " descends from ";
            }
            case EXISTS: {
                return " exists ";
            }
            case GENERALIZES: {
                return " generalizes ";
            }
        }
        return null;
    }

    private boolean inConcept(String code, CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasCodeElement() && c.getCode().equals(code)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.inConcept(code, g)) continue;
            return true;
        }
        return false;
    }
}

