/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.CodeResolver;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.terminologies.JurisdictionUtilities;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class DataRenderer
extends Renderer
implements CodeResolver {
    public DataRenderer(RenderingContext context) {
        super(context);
    }

    public DataRenderer(IWorkerContext worker) {
        super(worker);
    }

    public static String processRelativeUrls(String markdown, String path) {
        if (markdown == null) {
            return "";
        }
        if (!Utilities.isAbsoluteUrl((String)path)) {
            return markdown;
        }
        String basePath = path.contains("/") ? path.substring(0, path.lastIndexOf("/") + 1) : path + "/";
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < markdown.length(); ++i) {
            if (i < markdown.length() - 3 && markdown.substring(i, i + 2).equals("](")) {
                int j;
                for (j = i + 2; j < markdown.length() && markdown.charAt(j) != ')'; ++j) {
                }
                if (j < markdown.length()) {
                    String url = markdown.substring(i + 2, j);
                    if (!Utilities.isAbsoluteUrl((String)url) && !url.startsWith("..")) {
                        b.append("](");
                        b.append(basePath);
                    } else {
                        b.append("](");
                    }
                    ++i;
                    continue;
                }
                b.append(markdown.charAt(i));
                continue;
            }
            b.append(markdown.charAt(i));
        }
        return b.toString();
    }

    protected void addMarkdown(XhtmlNode x, String text, String path) throws FHIRFormatError, IOException, DefinitionException {
        this.addMarkdown(x, DataRenderer.processRelativeUrls(text, path));
    }

    protected void addMarkdown(XhtmlNode x, String text) throws FHIRFormatError, IOException, DefinitionException {
        if (text != null) {
            XhtmlDocument m;
            while (((String)text).contains("[[[")) {
                StructureDefinition p;
                String left = ((String)text).substring(0, ((String)text).indexOf("[[["));
                String link = ((String)text).substring(((String)text).indexOf("[[[") + 3, ((String)text).indexOf("]]]"));
                String right = ((String)text).substring(((String)text).indexOf("]]]") + 3);
                String path = null;
                String url = link;
                String[] parts = link.split("\\#");
                if (parts[0].contains(".")) {
                    path = parts[0];
                    parts[0] = parts[0].substring(0, parts[0].indexOf("."));
                }
                if ((p = this.getContext().getWorker().fetchResource(StructureDefinition.class, parts[0])) == null) {
                    p = this.getContext().getWorker().fetchTypeDefinition(parts[0]);
                }
                if (p == null) {
                    p = this.getContext().getWorker().fetchResource(StructureDefinition.class, link);
                }
                if (p != null) {
                    url = p.getWebPath();
                    if (url == null) {
                        url = p.getUserString("filename");
                    }
                } else {
                    throw new DefinitionException("Unable to resolve markdown link " + link);
                }
                text = left + "[" + link + "](" + url + (String)(path == null ? "" : "#" + path) + ")" + right;
            }
            String s = this.getContext().getMarkdown().process((String)text, "narrative generator");
            XhtmlParser p = new XhtmlParser();
            try {
                m = p.parse("<div>" + s + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), (Throwable)e);
            }
            x.getChildNodes().addAll((Collection)m.getChildNodes());
        }
    }

    protected void smartAddText(XhtmlNode p, String text) {
        if (text == null) {
            return;
        }
        String[] lines = text.split("\\r\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                p.br();
            }
            p.addText(lines[i]);
        }
    }

    private static String month(String m) {
        switch (m) {
            case "1": {
                return "Jan";
            }
            case "2": {
                return "Feb";
            }
            case "3": {
                return "Mar";
            }
            case "4": {
                return "Apr";
            }
            case "5": {
                return "May";
            }
            case "6": {
                return "Jun";
            }
            case "7": {
                return "Jul";
            }
            case "8": {
                return "Aug";
            }
            case "9": {
                return "Sep";
            }
            case "10": {
                return "Oct";
            }
            case "11": {
                return "Nov";
            }
            case "12": {
                return "Dec";
            }
        }
        return null;
    }

    public static String describeVersion(String version) {
        if (version.startsWith("http://snomed.info/sct")) {
            String[] p = version.split("\\/");
            String ed = null;
            Object dt = "";
            if (p[p.length - 2].equals("version")) {
                ed = p[p.length - 3];
                String y = p[p.length - 3].substring(4, 8);
                String m = p[p.length - 3].substring(2, 4);
                dt = " rel. " + DataRenderer.month(m) + " " + y;
            } else {
                ed = p[p.length - 1];
            }
            switch (ed) {
                case "900000000000207008": {
                    return "Intl" + (String)dt;
                }
                case "731000124108": {
                    return "US" + (String)dt;
                }
                case "32506021000036107": {
                    return "AU" + (String)dt;
                }
                case "449081005": {
                    return "ES" + (String)dt;
                }
                case "554471000005108": {
                    return "DK" + (String)dt;
                }
                case "11000146104": {
                    return "NL" + (String)dt;
                }
                case "45991000052106": {
                    return "SE" + (String)dt;
                }
                case "999000041000000102": {
                    return "UK" + (String)dt;
                }
                case "20611000087101": {
                    return "CA" + (String)dt;
                }
                case "11000172109": {
                    return "BE" + (String)dt;
                }
            }
            return "??" + (String)dt;
        }
        return version;
    }

    public static String describeSystem(String system) {
        if (system == null) {
            return "[not stated]";
        }
        if (system.equals("http://loinc.org")) {
            return "LOINC";
        }
        if (system.startsWith("http://snomed.info")) {
            return "SNOMED CT";
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return "RxNorm";
        }
        if (system.equals("http://hl7.org/fhir/sid/icd-9")) {
            return "ICD-9";
        }
        if (system.equals("http://dicom.nema.org/resources/ontology/DCM")) {
            return "DICOM";
        }
        if (system.equals("http://unitsofmeasure.org")) {
            return "UCUM";
        }
        return system;
    }

    public String displaySystem(String system) {
        if (system == null) {
            return "[not stated]";
        }
        if (system.equals("http://loinc.org")) {
            return "LOINC";
        }
        if (system.startsWith("http://snomed.info")) {
            return "SNOMED CT";
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return "RxNorm";
        }
        if (system.equals("http://hl7.org/fhir/sid/icd-9")) {
            return "ICD-9";
        }
        if (system.equals("http://dicom.nema.org/resources/ontology/DCM")) {
            return "DICOM";
        }
        if (system.equals("http://unitsofmeasure.org")) {
            return "UCUM";
        }
        CodeSystem cs = this.context.getContext().fetchCodeSystem(system);
        if (cs != null) {
            return cs.present();
        }
        return this.tails(system);
    }

    private String tails(String system) {
        if (system.contains("/")) {
            return system.substring(system.lastIndexOf("/") + 1);
        }
        return "unknown";
    }

    protected String makeAnchor(String codeSystem, String code) {
        String s = codeSystem + "-" + code;
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '.') {
                b.append(c);
                continue;
            }
            b.append('-');
        }
        return b.toString();
    }

    private String lookupCode(String system, String version, String code) {
        if (JurisdictionUtilities.isJurisdiction(system)) {
            return JurisdictionUtilities.displayJurisdiction(system + "#" + code);
        }
        IWorkerContext.ValidationResult t = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions().withVersionFlexible(true), system, version, code, null);
        if (t != null && t.getDisplay() != null) {
            return t.getDisplay();
        }
        return code;
    }

    protected String describeLang(String lang) {
        if ("fr-CA".equals(lang)) {
            return "French (Canadian)";
        }
        ValueSet v = this.getContext().getWorker().fetchResource(ValueSet.class, "http://hl7.org/fhir/ValueSet/languages");
        if (v != null) {
            ValueSet.ConceptReferenceComponent l = null;
            for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                if (!cc.getCode().equals(lang)) continue;
                l = cc;
            }
            if (l == null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                    if (!cc.getCode().equals(lang)) continue;
                    l = cc;
                    break;
                }
                if (l == null) {
                    for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                        if (!cc.getCode().startsWith(lang + "-")) continue;
                        l = cc;
                        break;
                    }
                }
            }
            if (l != null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                String en = l.getDisplay();
                String nativelang = null;
                for (ValueSet.ConceptReferenceDesignationComponent cd : l.getDesignation()) {
                    if (!cd.getLanguage().equals(lang)) continue;
                    nativelang = cd.getValue();
                }
                if (nativelang == null) {
                    return en + " (" + lang + ")";
                }
                return nativelang + " (" + en + ", " + lang + ")";
            }
        }
        return lang;
    }

    private boolean isCanonical(String path) {
        if (!path.endsWith(".url")) {
            return false;
        }
        String t = path.substring(0, path.length() - 4);
        StructureDefinition sd = this.getContext().getWorker().fetchTypeDefinition(t);
        if (sd == null) {
            return false;
        }
        if (VersionUtilities.getCanonicalResourceNames((String)this.getContext().getWorker().getVersion()).contains(t)) {
            return true;
        }
        return Utilities.existsInList((String)t, (String[])new String[]{"ActivityDefinition", "CapabilityStatement", "ChargeItemDefinition", "Citation", "CodeSystem", "CompartmentDefinition", "ConceptMap", "ConditionDefinition", "EventDefinition", "Evidence", "EvidenceReport", "EvidenceVariable", "ExampleScenario", "GraphDefinition", "ImplementationGuide", "Library", "Measure", "MessageDefinition", "NamingSystem", "PlanDefinition"});
    }

    protected String translate(String source, String content) {
        return content;
    }

    @Override
    public String gt(PrimitiveType value) {
        return value.primitiveValue();
    }

    public boolean hasRenderableExtensions(DataType element) {
        for (Extension ext : element.getExtension()) {
            if (!this.canRender(ext)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRenderableExtensions(BackboneType element) {
        for (Extension ext : element.getExtension()) {
            if (!this.canRender(ext)) continue;
            return true;
        }
        return element.hasModifierExtension();
    }

    private String getExtensionLabel(Extension ext) {
        StructureDefinition sd = this.context.getWorker().fetchResource(StructureDefinition.class, ext.getUrl());
        if (sd != null && ext.hasValue() && ext.getValue().isPrimitive() && sd.hasSnapshot()) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!Utilities.existsInList((String)ed.getPath(), (String[])new String[]{"Extension", "Extension.value[x]"}) || !ed.hasLabel()) continue;
                return ed.getLabel();
            }
        }
        return null;
    }

    private boolean canRender(Extension ext) {
        return this.getExtensionLabel(ext) != null;
    }

    public void renderExtensionsInList(XhtmlNode ul, DataType element) throws FHIRFormatError, DefinitionException, IOException {
        for (Extension ext : element.getExtension()) {
            if (!this.canRender(ext)) continue;
            String lbl = this.getExtensionLabel(ext);
            XhtmlNode li = ul.li();
            li.tx(lbl);
            li.tx(": ");
            this.render(li, ext.getValue());
        }
    }

    public void renderExtensionsInList(XhtmlNode ul, BackboneType element) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode li;
        String lbl;
        for (Extension ext : element.getModifierExtension()) {
            if (this.canRender(ext)) {
                lbl = this.getExtensionLabel(ext);
                li = ul.li();
                li = li.b();
                li.tx(lbl);
                li.tx(": ");
                this.render(li, ext.getValue());
                continue;
            }
            XhtmlNode li2 = ul.li();
            li2.b().tx("WARNING: Unrenderable Modifier Extension!");
        }
        for (Extension ext : element.getExtension()) {
            if (!this.canRender(ext)) continue;
            lbl = this.getExtensionLabel(ext);
            li = ul.li();
            li.tx(lbl);
            li.tx(": ");
            this.render(li, ext.getValue());
        }
    }

    public void renderExtensionsInText(XhtmlNode div, DataType element, String sep) throws FHIRFormatError, DefinitionException, IOException {
        boolean first = true;
        for (Extension ext : element.getExtension()) {
            if (!this.canRender(ext)) continue;
            if (first) {
                first = false;
            } else {
                div.tx(sep);
                div.tx(" ");
            }
            String lbl = this.getExtensionLabel(ext);
            div.tx(lbl);
            div.tx(": ");
            this.render(div, ext.getValue());
        }
    }

    public void renderExtensionsInList(XhtmlNode div, BackboneType element, String sep) throws FHIRFormatError, DefinitionException, IOException {
        String lbl;
        boolean first = true;
        for (Extension ext : element.getModifierExtension()) {
            if (first) {
                first = false;
            } else {
                div.tx(sep);
                div.tx(" ");
            }
            if (this.canRender(ext)) {
                lbl = this.getExtensionLabel(ext);
                XhtmlNode b = div.b();
                b.tx(lbl);
                b.tx(": ");
                this.render(div, ext.getValue());
                continue;
            }
            div.b().tx("WARNING: Unrenderable Modifier Extension!");
        }
        for (Extension ext : element.getExtension()) {
            if (!this.canRender(ext)) continue;
            if (first) {
                first = false;
            } else {
                div.tx(sep);
                div.tx(" ");
            }
            lbl = this.getExtensionLabel(ext);
            div.tx(lbl);
            div.tx(": ");
            this.render(div, ext.getValue());
        }
    }

    public static String display(IWorkerContext context, DataType type) {
        return new DataRenderer(new RenderingContext(context, null, null, "http://hl7.org/fhir/R4", "", null, RenderingContext.ResourceRendererMode.END_USER, RenderingContext.GenerationRules.VALID_RESOURCE)).display(type);
    }

    public String displayBase(Base b) {
        if (b instanceof DataType) {
            return this.display((DataType)b);
        }
        return "No display for " + b.fhirType();
    }

    public String display(DataType type) {
        if (type == null || type.isEmpty()) {
            return "";
        }
        if (type instanceof Coding) {
            return this.displayCoding((Coding)type);
        }
        if (type instanceof CodeableConcept) {
            return this.displayCodeableConcept((CodeableConcept)type);
        }
        if (type instanceof Identifier) {
            return this.displayIdentifier((Identifier)type);
        }
        if (type instanceof HumanName) {
            return DataRenderer.displayHumanName((HumanName)type);
        }
        if (type instanceof Address) {
            return this.displayAddress((Address)type);
        }
        if (type instanceof ContactPoint) {
            return DataRenderer.displayContactPoint((ContactPoint)type);
        }
        if (type instanceof Quantity) {
            return this.displayQuantity((Quantity)type);
        }
        if (type instanceof Range) {
            return this.displayRange((Range)type);
        }
        if (type instanceof Period) {
            return this.displayPeriod((Period)type);
        }
        if (type instanceof Timing) {
            return this.displayTiming((Timing)type);
        }
        if (type instanceof SampledData) {
            return this.displaySampledData((SampledData)type);
        }
        if (type.isDateTime()) {
            return this.displayDateTime((BaseDateTimeType)type);
        }
        if (type.isPrimitive()) {
            return type.primitiveValue();
        }
        return "No display for " + type.fhirType();
    }

    private String displayDateTime(BaseDateTimeType type) {
        if (!type.hasPrimitiveValue()) {
            return "";
        }
        if (this.isOnlyDate(type.getPrecision())) {
            DateTimeFormatter fmt = this.getDateFormatForPrecision(type);
            LocalDate date = LocalDate.of((int)type.getYear(), type.getMonth() + 1, (int)type.getDay());
            return fmt.format(date);
        }
        DateTimeFormatter fmt = this.context.getDateTimeFormat();
        if (fmt == null) {
            fmt = this.context.isTechnicalMode() ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(this.context.getLocale());
        }
        ZonedDateTime zdt = ZonedDateTime.parse(type.primitiveValue());
        ZoneId zone = this.context.getTimeZoneId();
        if (zone != null) {
            zdt = zdt.withZoneSameInstant(zone);
        }
        return fmt.format(zdt);
    }

    private DateTimeFormatter getDateFormatForPrecision(BaseDateTimeType type) {
        DateTimeFormatter fmt = this.getContextDateFormat(type);
        if (fmt != null) {
            return fmt;
        }
        if (this.context.isTechnicalMode()) {
            switch (type.getPrecision()) {
                case YEAR: {
                    return new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();
                }
                case MONTH: {
                    return new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();
                }
            }
            return DateTimeFormatter.ISO_DATE;
        }
        switch (type.getPrecision()) {
            case YEAR: {
                return DateTimeFormatter.ofPattern("uuuu");
            }
            case MONTH: {
                return DateTimeFormatter.ofPattern("MMM uuuu");
            }
        }
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(this.context.getLocale());
    }

    private DateTimeFormatter getContextDateFormat(BaseDateTimeType type) {
        switch (type.getPrecision()) {
            case YEAR: {
                return this.context.getDateYearFormat();
            }
            case MONTH: {
                return this.context.getDateYearMonthFormat();
            }
        }
        return this.context.getDateFormat();
    }

    private boolean isOnlyDate(TemporalPrecisionEnum temporalPrecisionEnum) {
        return temporalPrecisionEnum == TemporalPrecisionEnum.YEAR || temporalPrecisionEnum == TemporalPrecisionEnum.MONTH || temporalPrecisionEnum == TemporalPrecisionEnum.DAY;
    }

    public String display(BaseWrappers.BaseWrapper type) {
        return "to do";
    }

    public void render(XhtmlNode x, BaseWrappers.BaseWrapper type) throws FHIRFormatError, DefinitionException, IOException {
        Base base = null;
        try {
            base = type.getBase();
        }
        catch (IOException | FHIRException e) {
            x.tx("Error: " + e.getMessage());
            return;
        }
        if (base instanceof DataType) {
            this.render(x, (DataType)base);
        } else {
            x.tx("to do: " + base.fhirType());
        }
    }

    public void renderBase(XhtmlNode x, Base b) throws FHIRFormatError, DefinitionException, IOException {
        if (b instanceof DataType) {
            this.render(x, (DataType)b);
        } else {
            x.tx("No display for " + b.fhirType());
        }
    }

    public void render(XhtmlNode x, DataType type) throws FHIRFormatError, DefinitionException, IOException {
        if (type instanceof BaseDateTimeType) {
            x.tx(this.displayDateTime((BaseDateTimeType)type));
        } else if (type instanceof UriType) {
            this.renderUri(x, (UriType)type);
        } else if (type instanceof Annotation) {
            this.renderAnnotation(x, (Annotation)type);
        } else if (type instanceof Coding) {
            this.renderCodingWithDetails(x, (Coding)type);
        } else if (type instanceof CodeableConcept) {
            this.renderCodeableConcept(x, (CodeableConcept)type);
        } else if (type instanceof Identifier) {
            this.renderIdentifier(x, (Identifier)type);
        } else if (type instanceof HumanName) {
            this.renderHumanName(x, (HumanName)type);
        } else if (type instanceof Address) {
            this.renderAddress(x, (Address)type);
        } else if (type instanceof Expression) {
            this.renderExpression(x, (Expression)type);
        } else if (type instanceof Money) {
            this.renderMoney(x, (Money)type);
        } else if (type instanceof ContactPoint) {
            this.renderContactPoint(x, (ContactPoint)type);
        } else if (type instanceof Quantity) {
            this.renderQuantity(x, (Quantity)type);
        } else if (type instanceof Range) {
            this.renderRange(x, (Range)type);
        } else if (type instanceof Period) {
            this.renderPeriod(x, (Period)type);
        } else if (type instanceof Timing) {
            this.renderTiming(x, (Timing)type);
        } else if (type instanceof SampledData) {
            this.renderSampledData(x, (SampledData)type);
        } else if (type instanceof Reference) {
            this.renderReference(x, (Reference)type);
        } else if (type instanceof CodeableReference) {
            CodeableReference cr = (CodeableReference)type;
            if (cr.hasConcept()) {
                this.renderCodeableConcept(x, cr.getConcept());
            } else {
                this.renderReference(x, cr.getReference());
            }
        } else if (type instanceof MarkdownType) {
            this.addMarkdown(x, ((MarkdownType)type).asStringValue());
        } else if (type instanceof Base64BinaryType) {
            Base64BinaryType b64 = (Base64BinaryType)type;
            x.tx("(base64 data - " + (Serializable)(b64.getValue() == null ? "0" : Integer.valueOf(b64.getValue().length)) + " bytes)");
        } else if (type.isPrimitive()) {
            x.tx(type.primitiveValue());
        } else {
            x.tx("No display for " + type.fhirType());
        }
    }

    private void renderReference(XhtmlNode x, Reference ref) {
        if (ref.hasDisplay()) {
            x.tx(ref.getDisplay());
        } else if (ref.hasReference()) {
            x.tx(ref.getReference());
        } else {
            x.tx("??");
        }
    }

    public void renderDateTime(XhtmlNode x, Base e) {
        if (e.hasPrimitiveValue()) {
            x.addText(this.displayDateTime((DateTimeType)e));
        }
    }

    public void renderDate(XhtmlNode x, Base e) {
        if (e.hasPrimitiveValue()) {
            x.addText(this.displayDateTime((DateType)e));
        }
    }

    public void renderDateTime(XhtmlNode x, String s) {
        if (s != null) {
            DateTimeType dt = new DateTimeType(s);
            x.addText(this.displayDateTime(dt));
        }
    }

    protected void renderUri(XhtmlNode x, UriType uri) {
        if (((String)uri.getValue()).startsWith("mailto:")) {
            x.ah((String)uri.getValue()).addText(((String)uri.getValue()).substring(7));
        } else {
            Resource r = this.context.getContext().fetchResource(Resource.class, (String)uri.getValue());
            if (r != null && r.getWebPath() != null) {
                if (r instanceof CanonicalResource) {
                    x.ah(r.getWebPath()).addText(((CanonicalResource)r).present());
                } else {
                    x.ah(r.getWebPath()).addText((String)uri.getValue());
                }
            } else if (Utilities.isAbsoluteUrlLinkable((String)((String)uri.getValue())) && !(uri instanceof IdType)) {
                x.ah((String)uri.getValue()).addText((String)uri.getValue());
            } else {
                x.addText((String)uri.getValue());
            }
        }
    }

    protected void renderUri(XhtmlNode x, UriType uri, String path, String id, Resource src) {
        if (this.isCanonical(path)) {
            x.code().tx((String)uri.getValue());
        } else {
            String url = (String)uri.getValue();
            if (url == null) {
                x.b().tx((String)uri.getValue());
            } else if (((String)uri.getValue()).startsWith("mailto:")) {
                x.ah((String)uri.getValue()).addText(((String)uri.getValue()).substring(7));
            } else {
                Resource target = this.context.getContext().fetchResource(Resource.class, (String)uri.getValue(), src);
                if (target != null && target.hasWebPath()) {
                    String title = target instanceof CanonicalResource ? ((CanonicalResource)target).present() : (String)uri.getValue();
                    x.ah(target.getWebPath()).addText(title);
                } else if (((String)uri.getValue()).contains("|")) {
                    x.ah(((String)uri.getValue()).substring(0, ((String)uri.getValue()).indexOf("|"))).addText((String)uri.getValue());
                } else if (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("ftp:")) {
                    x.ah((String)uri.getValue()).addText((String)uri.getValue());
                } else {
                    x.code().addText((String)uri.getValue());
                }
            }
        }
    }

    protected void renderAnnotation(XhtmlNode x, Annotation annot) {
        this.renderAnnotation(x, annot, false);
    }

    protected void renderAnnotation(XhtmlNode x, Annotation a, boolean showCodeDetails) throws FHIRException {
        StringBuilder b = new StringBuilder();
        if (a.hasText()) {
            b.append(a.getText());
        }
        if (a.hasText() && (a.hasAuthor() || a.hasTimeElement())) {
            b.append(" (");
        }
        if (a.hasAuthor()) {
            b.append("By ");
            if (a.hasAuthorReference()) {
                b.append(a.getAuthorReference().getReference());
            } else if (a.hasAuthorStringType()) {
                b.append((String)a.getAuthorStringType().getValue());
            }
        }
        if (a.hasTimeElement()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append("@").append(a.getTimeElement().toHumanDisplay());
        }
        if (a.hasText() && (a.hasAuthor() || a.hasTimeElement())) {
            b.append(")");
        }
        x.addText(b.toString());
    }

    public String displayCoding(Coding c) {
        Object s = "";
        if (this.context.isTechnicalMode()) {
            s = c.getDisplay();
            if (Utilities.noString((String)s)) {
                s = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode());
            }
            if (Utilities.noString((String)s)) {
                s = this.displayCodeTriple(c.getSystem(), c.getVersion(), c.getCode());
            } else if (c.hasSystem()) {
                s = (String)s + " (" + this.displayCodeTriple(c.getSystem(), c.getVersion(), c.getCode()) + ")";
            } else if (c.hasCode()) {
                s = (String)s + " (" + c.getCode() + ")";
            }
        } else {
            if (c.hasDisplayElement()) {
                return c.getDisplay();
            }
            if (Utilities.noString((String)s)) {
                s = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode());
            }
            if (Utilities.noString((String)s)) {
                s = c.getCode();
            }
        }
        return s;
    }

    private String displayCodeSource(String system, String version) {
        Object s = this.displaySystem(system);
        if (version != null) {
            s = (String)s + "[" + DataRenderer.describeVersion(version) + "]";
        }
        return s;
    }

    private String displayCodeTriple(String system, String version, String code) {
        if (system == null) {
            if (code == null) {
                return "";
            }
            return "#" + code;
        }
        Object s = this.displayCodeSource(system, version);
        if (code != null) {
            s = (String)s + "#" + code;
        }
        return s;
    }

    public String displayCoding(List<Coding> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : list) {
            b.append(this.displayCoding(c));
        }
        return b.toString();
    }

    protected void renderCoding(XhtmlNode x, Coding c) {
        this.renderCoding(x, c, false);
    }

    protected void renderCoding(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Piece> pieces, Coding c) {
        if (c.isEmpty()) {
            return;
        }
        String url = this.getLinkForSystem(c.getSystem(), c.getVersion());
        String name = this.displayCodeSource(c.getSystem(), c.getVersion());
        if (!Utilities.noString((String)url)) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url, name, c.getSystem() + (String)(c.hasVersion() ? "#" + c.getVersion() : "")));
        } else {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, name, c.getSystem() + (String)(c.hasVersion() ? "#" + c.getVersion() : "")));
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "#" + c.getCode(), null));
        String s = c.getDisplay();
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode());
        }
        if (!Utilities.noString((String)s)) {
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, " \"" + s + "\"", null));
        }
    }

    private String getLinkForSystem(String system, String version) {
        CodeSystem cs;
        if ("http://snomed.info/sct".equals(system)) {
            return "https://browser.ihtsdotools.org/";
        }
        if ("http://loinc.org".equals(system)) {
            return "https://loinc.org/";
        }
        if ("http://unitsofmeasure.org".equals(system)) {
            return "http://ucum.org";
        }
        Object url = system;
        if (version != null) {
            url = (String)url + "|" + version;
        }
        if ((cs = this.context.getWorker().fetchCodeSystem((String)url)) != null && cs.hasWebPath()) {
            return cs.getWebPath();
        }
        return null;
    }

    protected String getLinkForCode(String system, String version, String code) {
        if ("http://snomed.info/sct".equals(system)) {
            if (!Utilities.noString((String)code)) {
                return "http://snomed.info/id/" + code;
            }
            return "https://browser.ihtsdotools.org/";
        }
        if ("http://loinc.org".equals(system)) {
            if (!Utilities.noString((String)code)) {
                return "https://loinc.org/" + code;
            }
            return "https://loinc.org/";
        }
        if ("http://www.nlm.nih.gov/research/umls/rxnorm".equals(system)) {
            if (!Utilities.noString((String)code)) {
                return "https://mor.nlm.nih.gov/RxNav/search?searchBy=RXCUI&searchTerm=" + code;
            }
            return "https://www.nlm.nih.gov/research/umls/rxnorm/index.html";
        }
        if ("urn:iso:std:iso:3166".equals(system)) {
            if (!Utilities.noString((String)code)) {
                return "https://en.wikipedia.org/wiki/ISO_3166-2:" + code;
            }
            return "https://en.wikipedia.org/wiki/ISO_3166-2";
        }
        CodeSystem cs = this.context.getWorker().fetchCodeSystem(system, version);
        if (cs != null && cs.hasWebPath()) {
            if (!Utilities.noString((String)code)) {
                return cs.getWebPath() + "#" + cs.getId() + "-" + Utilities.nmtokenize((String)code);
            }
            return cs.getWebPath();
        }
        return null;
    }

    @Override
    public CodeResolver.CodeResolution resolveCode(String system, String code) {
        return this.resolveCode(new Coding().setSystem(system).setCode(code));
    }

    @Override
    public CodeResolver.CodeResolution resolveCode(Coding c) {
        CodeSystem cs;
        String display = null;
        if (c.hasDisplayElement()) {
            display = c.getDisplay();
        }
        if (Utilities.noString(display)) {
            display = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode());
        }
        if (Utilities.noString((String)display)) {
            display = c.getCode();
        }
        String systemLink = (cs = this.context.getWorker().fetchCodeSystem(c.getSystem())) != null ? cs.getWebPath() : null;
        String systemName = cs != null ? cs.present() : DataRenderer.describeSystem(c.getSystem());
        String link = this.getLinkForCode(c.getSystem(), c.getVersion(), c.getCode());
        String hint = systemName + ": " + display + (String)(c.hasVersion() ? " (version = " + c.getVersion() + ")" : "");
        return new CodeResolver.CodeResolution(systemName, systemLink, link, display, hint);
    }

    @Override
    public CodeResolver.CodeResolution resolveCode(CodeableConcept code) {
        if (code.hasCoding()) {
            return this.resolveCode(code.getCodingFirstRep());
        }
        return new CodeResolver.CodeResolution(null, null, null, code.getText(), code.getText());
    }

    protected void renderCodingWithDetails(XhtmlNode x, Coding c) {
        CodeSystem cs;
        String s = "";
        if (c.hasDisplayElement()) {
            s = c.getDisplay();
        }
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode());
        }
        String sn = (cs = this.context.getWorker().fetchCodeSystem(c.getSystem())) != null ? cs.present() : DataRenderer.describeSystem(c.getSystem());
        String link = this.getLinkForCode(c.getSystem(), c.getVersion(), c.getCode());
        if (link != null) {
            x.ah(link).tx(sn);
        } else {
            x.tx(sn);
        }
        x.tx(" ");
        x.tx(c.getCode());
        if (!Utilities.noString((String)s)) {
            x.tx(": ");
            x.tx(s);
        }
        if (c.hasVersion()) {
            x.tx(" (version = " + c.getVersion() + ")");
        }
    }

    protected void renderCoding(XhtmlNode x, Coding c, boolean showCodeDetails) {
        String s = "";
        if (c.hasDisplayElement()) {
            s = c.getDisplay();
        }
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode());
        }
        if (Utilities.noString((String)s)) {
            s = c.getCode();
        }
        if (showCodeDetails) {
            x.addText(s + " (Details: " + TerminologyRenderer.describeSystem(c.getSystem()) + " code " + c.getCode() + " = '" + this.lookupCode(c.getSystem(), c.getVersion(), c.getCode()) + "', stated as '" + c.getDisplay() + "')");
        } else {
            x.span(null, "{" + c.getSystem() + " " + c.getCode() + "}").addText(s);
        }
    }

    public String displayCodeableConcept(CodeableConcept cc) {
        String s = cc.getText();
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCode() && c.hasSystem() && !Utilities.noString((String)(s = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode())))) break;
            }
        }
        if (Utilities.noString((String)s)) {
            s = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        return s;
    }

    protected void renderCodeableConcept(XhtmlNode x, CodeableConcept cc) throws FHIRFormatError, DefinitionException, IOException {
        this.renderCodeableConcept(x, cc, false);
    }

    protected void renderCodeableReference(XhtmlNode x, CodeableReference e, boolean showCodeDetails) throws FHIRFormatError, DefinitionException, IOException {
        if (e.hasConcept()) {
            this.renderCodeableConcept(x, e.getConcept(), showCodeDetails);
        }
        if (e.hasReference()) {
            this.renderReference(x, e.getReference());
        }
    }

    protected void renderCodeableConcept(XhtmlNode x, CodeableConcept cc, boolean showCodeDetails) throws FHIRFormatError, DefinitionException, IOException {
        if (cc.isEmpty()) {
            return;
        }
        String s = cc.getText();
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCodeElement() && c.hasSystemElement() && !Utilities.noString((String)(s = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode())))) break;
            }
        }
        if (Utilities.noString((String)s)) {
            s = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        if (showCodeDetails) {
            x.addText(s + " ");
            XhtmlNode sp = x.span("background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki", null);
            sp.tx(" (");
            boolean first = true;
            for (Coding c : cc.getCoding()) {
                if (first) {
                    first = false;
                } else {
                    sp.tx("; ");
                }
                String url = this.getLinkForSystem(c.getSystem(), c.getVersion());
                if (url != null) {
                    sp.ah(url).tx(this.displayCodeSource(c.getSystem(), c.getVersion()));
                } else {
                    sp.tx(this.displayCodeSource(c.getSystem(), c.getVersion()));
                }
                if (c.hasCode()) {
                    sp.tx("#" + c.getCode());
                }
                if (!c.hasDisplay() || s.equals(c.getDisplay())) continue;
                sp.tx(" \"" + c.getDisplay() + "\"");
            }
            if (this.hasRenderableExtensions(cc)) {
                if (!first) {
                    sp.tx("; ");
                }
                this.renderExtensionsInText(sp, cc, ";");
            }
            sp.tx(")");
        } else {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Coding c : cc.getCoding()) {
                if (!c.hasCodeElement() || !c.hasSystemElement()) continue;
                b.append("{" + c.getSystem() + " " + c.getCode() + "}");
            }
            x.span(null, "Codes: " + b.toString()).addText(s);
        }
    }

    private String displayIdentifier(Identifier ii) {
        Object s;
        Object object = s = Utilities.noString((String)ii.getValue()) ? "?ngen-9?" : ii.getValue();
        if (ii.hasType()) {
            if (ii.getType().hasText()) {
                s = ii.getType().getText() + ":\u00a0" + (String)s;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasDisplay()) {
                s = ii.getType().getCoding().get(0).getDisplay() + ": " + (String)s;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasCode()) {
                s = this.lookupCode(ii.getType().getCoding().get(0).getSystem(), ii.getType().getCoding().get(0).getVersion(), ii.getType().getCoding().get(0).getCode()) + ": " + (String)s;
            }
        } else {
            s = "id:\u00a0" + (String)s;
        }
        if (ii.hasUse() || ii.hasPeriod()) {
            s = (String)s + "\u00a0(";
            if (ii.hasUse()) {
                s = (String)s + "use:\u00a0" + ii.getUse().toString();
            }
            if (ii.hasUse() && ii.hasPeriod()) {
                s = (String)s + ",\u00a0";
            }
            if (ii.hasPeriod()) {
                s = (String)s + "period:\u00a0" + this.displayPeriod(ii.getPeriod());
            }
            s = (String)s + ")";
        }
        return s;
    }

    protected void renderIdentifier(XhtmlNode x, Identifier ii) {
        x.addText(this.displayIdentifier(ii));
    }

    public static String displayHumanName(HumanName name) {
        StringBuilder s = new StringBuilder();
        if (name.hasText()) {
            s.append(name.getText());
        } else {
            for (StringType p : name.getGiven()) {
                s.append((String)p.getValue());
                s.append(" ");
            }
            if (name.hasFamily()) {
                s.append(name.getFamily());
                s.append(" ");
            }
        }
        if (name.hasUse() && name.getUse() != HumanName.NameUse.USUAL) {
            s.append("(" + name.getUse().toString() + ")");
        }
        return s.toString();
    }

    protected void renderHumanName(XhtmlNode x, HumanName name) {
        x.addText(DataRenderer.displayHumanName(name));
    }

    private String displayAddress(Address address) {
        StringBuilder s = new StringBuilder();
        if (address.hasText()) {
            s.append(address.getText());
        } else {
            for (StringType p : address.getLine()) {
                s.append((String)p.getValue());
                s.append(" ");
            }
            if (address.hasCity()) {
                s.append(address.getCity());
                s.append(" ");
            }
            if (address.hasState()) {
                s.append(address.getState());
                s.append(" ");
            }
            if (address.hasPostalCode()) {
                s.append(address.getPostalCode());
                s.append(" ");
            }
            if (address.hasCountry()) {
                s.append(address.getCountry());
                s.append(" ");
            }
        }
        if (address.hasUse()) {
            s.append("(" + address.getUse().toString() + ")");
        }
        return s.toString();
    }

    protected void renderAddress(XhtmlNode x, Address address) {
        x.addText(this.displayAddress(address));
    }

    public static String displayContactPoint(ContactPoint contact) {
        StringBuilder s = new StringBuilder();
        s.append(DataRenderer.describeSystem(contact.getSystem()));
        if (Utilities.noString((String)contact.getValue())) {
            s.append("-unknown-");
        } else {
            s.append(contact.getValue());
        }
        if (contact.hasUse()) {
            s.append("(" + contact.getUse().toString() + ")");
        }
        return s.toString();
    }

    protected String getLocalizedBigDecimalValue(BigDecimal input, Currency c) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(this.context.getLocale());
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(c.getDefaultFractionDigits());
        numberFormat.setMinimumFractionDigits(c.getDefaultFractionDigits());
        return numberFormat.format(input);
    }

    protected void renderMoney(XhtmlNode x, Money money) {
        Currency c;
        if (x.getName().equals("blockquote")) {
            x = x.para();
        }
        if ((c = Currency.getInstance(money.getCurrency())) != null) {
            XhtmlNode s = x.span(null, c.getDisplayName());
            s.tx(c.getSymbol(this.context.getLocale()));
            s.tx(this.getLocalizedBigDecimalValue(money.getValue(), c));
            x.tx(" (" + c.getCurrencyCode() + ")");
        } else {
            x.tx(money.getCurrency());
            x.tx(money.getValue().toPlainString());
        }
    }

    protected void renderExpression(XhtmlNode x, Expression expr) {
        XhtmlNode p = x;
        if (p.getName().equals("blockquote")) {
            p = p.para();
        }
        if (expr.hasExpression()) {
            if (expr.hasReference()) {
                p = x.ah(expr.getReference());
            }
            XhtmlNode c = p;
            if (expr.hasLanguage()) {
                c = c.span(null, expr.getLanguage());
            }
            c.code().tx(expr.getExpression());
        } else if (expr.hasReference()) {
            p.ah(expr.getReference()).tx("source");
        }
        if (expr.hasName() || expr.hasDescription()) {
            p.tx("(");
            if (expr.hasName()) {
                p.b().tx(expr.getName());
            }
            if (expr.hasDescription()) {
                p.tx("\"");
                p.tx(expr.getDescription());
                p.tx("\"");
            }
            p.tx(")");
        }
    }

    protected void renderContactPoint(XhtmlNode x, ContactPoint contact) {
        if (contact != null) {
            if (!contact.hasSystem()) {
                x.addText(DataRenderer.displayContactPoint(contact));
            } else {
                switch (contact.getSystem()) {
                    case EMAIL: {
                        x.ah("mailto:" + contact.getValue()).tx(contact.getValue());
                        break;
                    }
                    case FAX: {
                        x.addText(DataRenderer.displayContactPoint(contact));
                        break;
                    }
                    case NULL: {
                        x.addText(DataRenderer.displayContactPoint(contact));
                        break;
                    }
                    case OTHER: {
                        x.addText(DataRenderer.displayContactPoint(contact));
                        break;
                    }
                    case PAGER: {
                        x.addText(DataRenderer.displayContactPoint(contact));
                        break;
                    }
                    case PHONE: {
                        if (contact.hasValue() && contact.getValue().startsWith("+")) {
                            x.ah("tel:" + contact.getValue().replace(" ", "")).tx(contact.getValue());
                            break;
                        }
                        x.addText(DataRenderer.displayContactPoint(contact));
                        break;
                    }
                    case SMS: {
                        x.addText(DataRenderer.displayContactPoint(contact));
                        break;
                    }
                    case URL: {
                        x.ah(contact.getValue()).tx(contact.getValue());
                        break;
                    }
                }
            }
        }
    }

    protected void displayContactPoint(XhtmlNode p, ContactPoint c) {
        if (c != null) {
            if (c.getSystem() == ContactPoint.ContactPointSystem.PHONE) {
                p.tx("Phone: " + c.getValue());
            } else if (c.getSystem() == ContactPoint.ContactPointSystem.FAX) {
                p.tx("Fax: " + c.getValue());
            } else if (c.getSystem() == ContactPoint.ContactPointSystem.EMAIL) {
                p.tx(c.getValue());
            } else if (c.getSystem() == ContactPoint.ContactPointSystem.URL) {
                if (c.getValue().length() > 30) {
                    p.addText(c.getValue().substring(0, 30) + "...");
                } else {
                    p.addText(c.getValue());
                }
            }
        }
    }

    protected void addTelecom(XhtmlNode p, ContactPoint c) {
        if (c.getSystem() == ContactPoint.ContactPointSystem.PHONE) {
            p.tx("Phone: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.FAX) {
            p.tx("Fax: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.EMAIL) {
            p.ah("mailto:" + c.getValue()).addText(c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.URL) {
            if (c.getValue().length() > 30) {
                p.ah(c.getValue()).addText(c.getValue().substring(0, 30) + "...");
            } else {
                p.ah(c.getValue()).addText(c.getValue());
            }
        }
    }

    private static String describeSystem(ContactPoint.ContactPointSystem system) {
        if (system == null) {
            return "";
        }
        switch (system) {
            case PHONE: {
                return "ph: ";
            }
            case FAX: {
                return "fax: ";
            }
        }
        return "";
    }

    protected String displayQuantity(Quantity q) {
        StringBuilder s = new StringBuilder();
        s.append(q.hasValue() ? q.getValue() : "?");
        if (q.hasUnit()) {
            s.append(" ").append(q.getUnit());
        } else if (q.hasCode()) {
            s.append(" ").append(q.getCode());
        }
        return s.toString();
    }

    protected void renderQuantity(XhtmlNode x, Quantity q) {
        this.renderQuantity(x, q, false);
    }

    protected void renderQuantity(XhtmlNode x, Quantity q, boolean showCodeDetails) {
        if (q.hasComparator()) {
            x.addText(q.getComparator().toCode());
        }
        if (q.hasValue()) {
            x.addText(q.getValue().toString());
        }
        if (q.hasUnit()) {
            x.tx(" " + q.getUnit());
        } else if (q.hasCode() && q.hasSystem()) {
            if (q.hasSystem() && q.getSystem().equals("http://unitsofmeasure.org")) {
                x.tx(" " + q.getCode());
            } else {
                x.tx("(unit " + q.getCode() + " from " + q.getSystem() + ")");
            }
        }
        if (showCodeDetails && q.hasCode()) {
            x.span("background: LightGoldenRodYellow", null).tx(" (Details: " + TerminologyRenderer.describeSystem(q.getSystem()) + " code " + q.getCode() + " = '" + this.lookupCode(q.getSystem(), null, q.getCode()) + "')");
        }
    }

    public String displayRange(Range q) {
        String high;
        if (!q.hasLow() && !q.hasHigh()) {
            return "?";
        }
        StringBuilder b = new StringBuilder();
        boolean sameUnits = q.getLow().hasUnit() && q.getHigh().hasUnit() && q.getLow().getUnit().equals(q.getHigh().getUnit()) || q.getLow().hasCode() && q.getHigh().hasCode() && q.getLow().getCode().equals(q.getHigh().getCode());
        String low = "?";
        if (q.hasLow() && q.getLow().hasValue()) {
            String string = low = sameUnits ? q.getLow().getValue().toString() : this.displayQuantity(q.getLow());
        }
        if ((high = this.displayQuantity(q.getHigh())).isEmpty()) {
            high = "?";
        }
        b.append(low).append("\u00a0to\u00a0").append(high);
        return b.toString();
    }

    protected void renderRange(XhtmlNode x, Range q) {
        if (q.hasLow()) {
            x.addText(q.getLow().getValue().toString());
        } else {
            x.tx("?");
        }
        x.tx("-");
        if (q.hasHigh()) {
            x.addText(q.getHigh().getValue().toString());
        } else {
            x.tx("?");
        }
        if (q.getLow().hasUnit()) {
            x.tx(" " + q.getLow().getUnit());
        }
    }

    public String displayPeriod(Period p) {
        Object s = !p.hasStart() ? "(?)" : this.displayDateTime(p.getStartElement());
        s = (String)s + " --> ";
        return (String)s + (!p.hasEnd() ? "(ongoing)" : this.displayDateTime(p.getEndElement()));
    }

    public void renderPeriod(XhtmlNode x, Period p) {
        x.addText(!p.hasStart() ? "??" : this.displayDateTime(p.getStartElement()));
        x.tx(" --> ");
        x.addText(!p.hasEnd() ? "(ongoing)" : this.displayDateTime(p.getEndElement()));
    }

    public void renderDataRequirement(XhtmlNode x, DataRequirement dr) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        XhtmlNode td = tr.td().colspan("2");
        td.b().tx("Type");
        td.tx(": ");
        StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(dr.getType().toCode());
        if (sd != null && sd.hasWebPath()) {
            td.ah(sd.getWebPath()).tx(dr.getType().toCode());
        } else {
            td.tx(dr.getType().toCode());
        }
        if (dr.hasProfile()) {
            td.tx(" (");
            boolean first = true;
            for (CanonicalType p : dr.getProfile()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(" | ");
                }
                sd = this.context.getWorker().fetchResource(StructureDefinition.class, (String)p.getValue());
                if (sd != null && sd.hasWebPath()) {
                    td.ah(sd.getWebPath()).tx(sd.present());
                    continue;
                }
                td.tx(p.asStringValue());
            }
            td.tx(")");
        }
        if (dr.hasSubject()) {
            tr = tbl.tr();
            td = tr.td().colspan("2");
            td.b().tx("Subject");
            if (dr.hasSubjectReference()) {
                this.renderReference(td, dr.getSubjectReference());
            } else {
                this.renderCodeableConcept(td, dr.getSubjectCodeableConcept());
            }
        }
        if (dr.hasCodeFilter() || dr.hasDateFilter()) {
            tr = tbl.tr().backgroundColor("#efefef");
            tr.td().tx("Filter");
            tr.td().tx("Value");
        }
        for (DataRequirement.DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : dr.getCodeFilter()) {
            tr = tbl.tr();
            if (dataRequirementCodeFilterComponent.hasPath()) {
                tr.td().tx(dataRequirementCodeFilterComponent.getPath());
            } else {
                tr.td().tx("Search on " + dataRequirementCodeFilterComponent.getSearchParam());
            }
            if (dataRequirementCodeFilterComponent.hasValueSet()) {
                td = tr.td();
                td.tx("In ValueSet ");
                this.render(td, dataRequirementCodeFilterComponent.getValueSetElement());
                continue;
            }
            boolean first = true;
            td = tr.td();
            td.tx("One of these codes: ");
            for (Coding c : dataRequirementCodeFilterComponent.getCode()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                this.render(td, c);
            }
        }
        for (DataRequirement.DataRequirementDateFilterComponent dataRequirementDateFilterComponent : dr.getDateFilter()) {
            tr = tbl.tr();
            if (dataRequirementDateFilterComponent.hasPath()) {
                tr.td().tx(dataRequirementDateFilterComponent.getPath());
            } else {
                tr.td().tx("Search on " + dataRequirementDateFilterComponent.getSearchParam());
            }
            this.render(tr.td(), dataRequirementDateFilterComponent.getValue());
        }
        if (dr.hasSort() || dr.hasLimit()) {
            tr = tbl.tr();
            td = tr.td().colspan("2");
            if (dr.hasLimit()) {
                td.b().tx("Limit");
                td.tx(": ");
                td.tx(dr.getLimit());
                if (dr.hasSort()) {
                    td.tx(", ");
                }
            }
            if (dr.hasSort()) {
                td.b().tx("Sort");
                td.tx(": ");
                boolean first = true;
                for (DataRequirement.DataRequirementSortComponent p : dr.getSort()) {
                    if (first) {
                        first = false;
                    } else {
                        td.tx(" | ");
                    }
                    td.tx(p.getDirection() == DataRequirement.SortDirection.ASCENDING ? "+" : "-");
                    td.tx(p.getPath());
                }
            }
        }
    }

    private String displayTiming(Timing s) throws FHIRException {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s.hasCode()) {
            b.append("Code: " + this.displayCodeableConcept(s.getCode()));
        }
        if (s.getEvent().size() > 0) {
            CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
            for (DateTimeType p : s.getEvent()) {
                if (p.hasValue()) {
                    c.append(this.displayDateTime(p));
                    continue;
                }
                if (this.renderExpression(c, p)) continue;
                c.append("??");
            }
            b.append("Events: " + c.toString());
        }
        if (s.hasRepeat()) {
            Object st;
            Timing.TimingRepeatComponent rep = s.getRepeat();
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasStart()) {
                b.append("Starting " + this.displayDateTime(rep.getBoundsPeriod().getStartElement()));
            }
            if (rep.hasCount()) {
                b.append("Count " + Integer.toString(rep.getCount()) + " times");
            }
            if (rep.hasDuration()) {
                b.append("Duration " + rep.getDuration().toPlainString() + this.displayTimeUnits(rep.getPeriodUnit()));
            }
            if (rep.hasWhen()) {
                st = "";
                if (rep.hasOffset()) {
                    st = Integer.toString(rep.getOffset()) + "min ";
                }
                b.append((String)st);
                for (Enumeration<Timing.EventTiming> wh : rep.getWhen()) {
                    b.append(this.displayEventCode((Timing.EventTiming)((Object)wh.getValue())));
                }
            } else {
                st = "";
                if (!rep.hasFrequency() || !rep.hasFrequencyMax() && rep.getFrequency() == 1) {
                    st = "Once";
                } else {
                    st = Integer.toString(rep.getFrequency());
                    if (rep.hasFrequencyMax()) {
                        st = (String)st + "-" + Integer.toString(rep.getFrequency());
                    }
                }
                if (rep.hasPeriod()) {
                    st = (String)st + " per " + rep.getPeriod().toPlainString();
                    if (rep.hasPeriodMax()) {
                        st = (String)st + "-" + rep.getPeriodMax().toPlainString();
                    }
                    st = (String)st + " " + this.displayTimeUnits(rep.getPeriodUnit());
                }
                b.append((String)st);
            }
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasEnd()) {
                b.append("Until " + this.displayDateTime(rep.getBoundsPeriod().getEndElement()));
            }
        }
        return b.toString();
    }

    private boolean renderExpression(CommaSeparatedStringBuilder c, PrimitiveType p) {
        Extension exp = p.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expression");
        if (exp == null) {
            return false;
        }
        c.append(exp.getValueExpression().getExpression());
        return true;
    }

    private String displayEventCode(Timing.EventTiming when) {
        switch (when) {
            case C: {
                return "at meals";
            }
            case CD: {
                return "at lunch";
            }
            case CM: {
                return "at breakfast";
            }
            case CV: {
                return "at dinner";
            }
            case AC: {
                return "before meals";
            }
            case ACD: {
                return "before lunch";
            }
            case ACM: {
                return "before breakfast";
            }
            case ACV: {
                return "before dinner";
            }
            case HS: {
                return "before sleeping";
            }
            case PC: {
                return "after meals";
            }
            case PCD: {
                return "after lunch";
            }
            case PCM: {
                return "after breakfast";
            }
            case PCV: {
                return "after dinner";
            }
            case WAKE: {
                return "after waking";
            }
        }
        return "?ngen-6?";
    }

    private String displayTimeUnits(Timing.UnitsOfTime units) {
        if (units == null) {
            return "?ngen-7?";
        }
        switch (units) {
            case A: {
                return "years";
            }
            case D: {
                return "days";
            }
            case H: {
                return "hours";
            }
            case MIN: {
                return "minutes";
            }
            case MO: {
                return "months";
            }
            case S: {
                return "seconds";
            }
            case WK: {
                return "weeks";
            }
        }
        return "?ngen-8?";
    }

    protected void renderTiming(XhtmlNode x, Timing s) throws FHIRException {
        x.addText(this.displayTiming(s));
    }

    private String displaySampledData(SampledData s) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s.hasOrigin()) {
            b.append("Origin: " + this.displayQuantity(s.getOrigin()));
        }
        if (s.hasInterval()) {
            b.append("Interval: " + s.getInterval().toString());
            if (s.hasIntervalUnit()) {
                b.append(s.getIntervalUnit().toString());
            }
        }
        if (s.hasFactor()) {
            b.append("Factor: " + s.getFactor().toString());
        }
        if (s.hasLowerLimit()) {
            b.append("Lower: " + s.getLowerLimit().toString());
        }
        if (s.hasUpperLimit()) {
            b.append("Upper: " + s.getUpperLimit().toString());
        }
        if (s.hasDimensions()) {
            b.append("Dimensions: " + s.getDimensions());
        }
        if (s.hasData()) {
            b.append("Data: " + s.getData());
        }
        return b.toString();
    }

    protected void renderSampledData(XhtmlNode x, SampledData sampledData) {
        x.addText(this.displaySampledData(sampledData));
    }

    public RenderingContext getContext() {
        return this.context;
    }

    public XhtmlNode makeExceptionXhtml(Exception e, String function) {
        XhtmlNode xn = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode p = xn.para();
        p.b().tx("Exception " + function + ": " + e.getMessage());
        p.addComment(this.getStackTrace(e));
        return xn;
    }

    private String getStackTrace(Exception e) {
        StringBuilder b = new StringBuilder();
        b.append("\r\n");
        for (StackTraceElement t : e.getStackTrace()) {
            b.append(t.getClassName() + "." + t.getMethodName() + " (" + t.getFileName() + ":" + t.getLineNumber());
            b.append("\r\n");
        }
        return b.toString();
    }

    protected String versionFromCanonical(String system) {
        if (system == null) {
            return null;
        }
        if (system.contains("|")) {
            return system.substring(0, system.indexOf("|"));
        }
        return null;
    }

    protected String systemFromCanonical(String system) {
        if (system == null) {
            return null;
        }
        if (system.contains("|")) {
            return system.substring(system.indexOf("|") + 1);
        }
        return system;
    }
}

