/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.profilemodel.gen;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.profilemodel.PEInstance;
import org.hl7.fhir.r5.profilemodel.gen.PEGeneratedBase;

public class ProfileExample
extends PEGeneratedBase {
    public ProfileExample(IWorkerContext context, Observation observation) {
        PEBuilder builder = new PEBuilder(context, PEBuilder.PEElementPropertiesPolicy.EXTENSION_ID, true);
        this.instance = builder.buildPEInstance("http://hl7.org/fhir/test/StructureDefinition/pe-profile1", "0.1", observation);
    }

    public ProfileExample(PEInstance instance) {
        this.instance = instance;
    }

    public Enumerations.ObservationStatus getStatus() {
        return Enumerations.ObservationStatus.FINAL;
    }

    public CodeableConcept getCode() {
        return this.instance.forceChild("code").asCodeableConcept();
    }

    public LOINCCodesForCholesterolInSerumPlasma getSimple() {
        return LOINCCodesForCholesterolInSerumPlasma.fromCode(((CodeType)this.instance.forceChild("simple").asDataType()).primitiveValue());
    }

    public boolean hasSimple() {
        return this.instance.child("simple") != null;
    }

    public ProfileExample clearSimple() {
        this.removeChild("simple");
        return this;
    }

    public ProfileExampleComplex getComplex() {
        PEInstance pe = this.instance.child("complex");
        return new ProfileExampleComplex(pe);
    }

    public boolean hasComplex() {
        return this.instance.child("complex") != null;
    }

    public ProfileExample clearComplex() {
        this.removeChild("complex");
        return this;
    }

    public static class ProfileExampleComplex
    extends PEGeneratedBase {
        private ProfileExampleComplex(PEInstance instance) {
            this.instance = instance;
        }

        public List<Coding> getSlice1() {
            ArrayList<Coding> res = new ArrayList<Coding>();
            for (PEInstance pe : this.instance.children("slice1")) {
                res.add((Coding)pe.asDataType());
            }
            return res;
        }

        public boolean hasSlice1() {
            return this.instance.children("slice1").size() > 0;
        }

        public ProfileExampleComplex clearSlice1() {
            this.removeChildren("slice1");
            return this;
        }

        public List<StringType> getSlice2() {
            ArrayList<StringType> res = new ArrayList<StringType>();
            for (PEInstance pe : this.instance.children("slice2")) {
                res.add((StringType)pe.asDataType());
            }
            return res;
        }

        public boolean hasSlice2() {
            return this.instance.children("slice2").size() > 0;
        }

        public ProfileExampleComplex clearSlice2() {
            this.removeChildren("slice1");
            return this;
        }

        public ProfileExampleComplexSlice3 getSlice3() {
            PEInstance pe = this.instance.forceChild("slice3");
            return new ProfileExampleComplexSlice3(pe);
        }

        public boolean hasComplex() {
            return this.instance.child("slice3") != null;
        }

        public ProfileExampleComplex clearComplex() {
            this.removeChild("slice3");
            return this;
        }
    }

    public static class ProfileExampleComplexSlice3
    extends PEGeneratedBase {
        private ProfileExampleComplexSlice3(PEInstance instance) {
            this.instance = instance;
        }

        public List<Coding> getSlice3a() {
            ArrayList<Coding> res = new ArrayList<Coding>();
            for (PEInstance pe : this.instance.children("slice3a")) {
                res.add((Coding)pe.asDataType());
            }
            return res;
        }

        public boolean hasSlice3a() {
            return this.instance.children("slice3a").size() > 0;
        }

        public ProfileExampleComplexSlice3 clearSlice3a() {
            this.removeChildren("slice3a");
            return this;
        }

        public List<StringType> getSlice3b() {
            ArrayList<StringType> res = new ArrayList<StringType>();
            for (PEInstance pe : this.instance.children("slice3b")) {
                res.add((StringType)pe.asDataType());
            }
            return res;
        }

        public boolean hasSlice3b() {
            return this.instance.children("slice3b").size() > 0;
        }

        public ProfileExampleComplexSlice3 clearSlice3b() {
            this.removeChildren("slice3b");
            return this;
        }
    }

    public static enum LOINCCodesForCholesterolInSerumPlasma {
        L14647_2,
        L2093_3,
        L35200_5,
        L9342_7;


        public String getCode() {
            switch (this) {
                case L14647_2: {
                    return "14647-2";
                }
                case L2093_3: {
                    return "2093-3";
                }
                case L35200_5: {
                    return "35200-5";
                }
                case L9342_7: {
                    return "9342-7";
                }
            }
            return null;
        }

        public String getDisplay() {
            switch (this) {
                case L14647_2: {
                    return "Cholesterol [Moles/Volume]";
                }
                case L2093_3: {
                    return "Cholesterol [Mass/Volume]";
                }
                case L35200_5: {
                    return "Cholesterol [Mass Or Moles/Volume]";
                }
                case L9342_7: {
                    return "Cholesterol [Percentile]";
                }
            }
            return null;
        }

        public static LOINCCodesForCholesterolInSerumPlasma fromCode(String code) {
            if (code != null) {
                switch (code) {
                    case "14647-2": {
                        return L14647_2;
                    }
                    case "2093-3": {
                        return L2093_3;
                    }
                    case "35200-5": {
                        return L35200_5;
                    }
                    case "9342-7": {
                        return L9342_7;
                    }
                }
            }
            return null;
        }
    }
}

