/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="TestPlan", profile="http://hl7.org/fhir/StructureDefinition/TestPlan")
public class TestPlan
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this test plan, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this test plan when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this test plan is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the test plan is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier identifier for the test plan", formalDefinition="A formal identifier that is used to identify this test plan when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the test plan", formalDefinition="The identifier that is used to identify this version of the test plan when it is referenced in a specification, model, design or instance.  This is an arbitrary value managed by the test plan author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this test plan (computer friendly)", formalDefinition="A natural language name identifying the test plan. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name for this test plan (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the test plan.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this test plan. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this test plan is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date (and optionally time) when the test plan was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the test plan changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the test plan.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the test plan", formalDefinition="A free text natural language description of the test plan from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate test plan instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction where the test plan applies (if applicable)", formalDefinition="A legal or geographic region in which the test plan is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this test plan is defined", formalDefinition="Explanation of why this test plan is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the test plan and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the test plan. The short copyright declaration (e.g. (c) '2015+ xyz organization' should be sent in the copyrightLabel element.")
    protected MarkdownType copyright;
    @Child(name="copyrightLabel", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright holder and year(s)", formalDefinition="A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').")
    protected StringType copyrightLabel;
    @Child(name="category", type={CodeableConcept.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The category of the Test Plan - can be acceptance, unit, performance", formalDefinition="The category of the Test Plan - can be acceptance, unit, performance, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/testscript-scope-phase-codes")
    protected List<CodeableConcept> category;
    @Child(name="scope", type={Reference.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What is being tested with this Test Plan - a conformance resource, or narrative criteria, or an external reference", formalDefinition="What is being tested with this Test Plan - a conformance resource, or narrative criteria, or an external reference...")
    protected List<Reference> scope;
    @Child(name="testTools", type={MarkdownType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A description of test tools to be used in the test plan - narrative for now", formalDefinition="A description of test tools to be used in the test plan.")
    protected MarkdownType testTools;
    @Child(name="dependency", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The required criteria to execute the test plan - e.g. preconditions, previous tests", formalDefinition="The required criteria to execute the test plan - e.g. preconditions, previous tests...")
    protected List<TestPlanDependencyComponent> dependency;
    @Child(name="exitCriteria", type={MarkdownType.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The threshold or criteria for the test plan to be considered successfully executed - narrative", formalDefinition="The threshold or criteria for the test plan to be considered successfully executed - narrative.")
    protected MarkdownType exitCriteria;
    @Child(name="testCase", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The test cases that constitute this plan", formalDefinition="The individual test cases that are part of this plan, when they they are made explicit.")
    protected List<TestPlanTestCaseComponent> testCase;
    private static final long serialVersionUID = 235546950L;
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | CapabilityStatement.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | GraphDefinition.identifier | ImplementationGuide.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | OperationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SearchParameter.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestPlan.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [GraphDefinition](graphdefinition.html): External identifier for the graph definition\r\n* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [OperationDefinition](operationdefinition.html): External identifier for the search parameter\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SearchParameter](searchparameter.html): External identifier for the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestPlan](testplan.html): An identifier for the test plan\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestPlan.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestPlan](testplan.html): The current status of the test plan\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestPlan.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestPlan](testplan.html): The uri that identifies the test plan\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="scope", path="TestPlan.scope", description="The scope that is to be tested with this test plan", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SCOPE = "scope";
    public static final ReferenceClientParam SCOPE = new ReferenceClientParam("scope");
    public static final Include INCLUDE_SCOPE = new Include("TestPlan:scope").toLocked();

    public TestPlan() {
    }

    public TestPlan(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public TestPlan setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public TestPlan setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public TestPlan setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public TestPlan addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public TestPlan setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public TestPlan setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    @Override
    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return this != null && this.versionAlgorithm instanceof StringType;
    }

    @Override
    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return this != null && this.versionAlgorithm instanceof Coding;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    @Override
    public TestPlan setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new FHIRException("Not the right type for TestPlan.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public TestPlan setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public TestPlan setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public TestPlan setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public TestPlan setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public TestPlan setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public TestPlan setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public TestPlan setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public TestPlan setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public TestPlan setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public TestPlan setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public TestPlan setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public TestPlan setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public TestPlan setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public TestPlan addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public TestPlan setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public TestPlan setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public TestPlan setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public TestPlan addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public TestPlan setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public TestPlan addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public TestPlan setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public TestPlan setPurpose(String value) {
        if (Utilities.noString((String)value)) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public TestPlan setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public TestPlan setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        if (this.copyrightLabel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.copyrightLabel");
            }
            if (Configuration.doAutoCreate()) {
                this.copyrightLabel = new StringType();
            }
        }
        return this.copyrightLabel;
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public boolean hasCopyrightLabel() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public TestPlan setCopyrightLabelElement(StringType value) {
        this.copyrightLabel = value;
        return this;
    }

    @Override
    public String getCopyrightLabel() {
        return this.copyrightLabel == null ? null : (String)this.copyrightLabel.getValue();
    }

    @Override
    public TestPlan setCopyrightLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.copyrightLabel = null;
        } else {
            if (this.copyrightLabel == null) {
                this.copyrightLabel = new StringType();
            }
            this.copyrightLabel.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public TestPlan setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public TestPlan addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<Reference> getScope() {
        if (this.scope == null) {
            this.scope = new ArrayList<Reference>();
        }
        return this.scope;
    }

    public TestPlan setScope(List<Reference> theScope) {
        this.scope = theScope;
        return this;
    }

    public boolean hasScope() {
        if (this.scope == null) {
            return false;
        }
        for (Reference item : this.scope) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addScope() {
        Reference t = new Reference();
        if (this.scope == null) {
            this.scope = new ArrayList<Reference>();
        }
        this.scope.add(t);
        return t;
    }

    public TestPlan addScope(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.scope == null) {
            this.scope = new ArrayList<Reference>();
        }
        this.scope.add(t);
        return this;
    }

    public Reference getScopeFirstRep() {
        if (this.getScope().isEmpty()) {
            this.addScope();
        }
        return this.getScope().get(0);
    }

    public MarkdownType getTestToolsElement() {
        if (this.testTools == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.testTools");
            }
            if (Configuration.doAutoCreate()) {
                this.testTools = new MarkdownType();
            }
        }
        return this.testTools;
    }

    public boolean hasTestToolsElement() {
        return this.testTools != null && !this.testTools.isEmpty();
    }

    public boolean hasTestTools() {
        return this.testTools != null && !this.testTools.isEmpty();
    }

    public TestPlan setTestToolsElement(MarkdownType value) {
        this.testTools = value;
        return this;
    }

    public String getTestTools() {
        return this.testTools == null ? null : (String)this.testTools.getValue();
    }

    public TestPlan setTestTools(String value) {
        if (Utilities.noString((String)value)) {
            this.testTools = null;
        } else {
            if (this.testTools == null) {
                this.testTools = new MarkdownType();
            }
            this.testTools.setValue(value);
        }
        return this;
    }

    public List<TestPlanDependencyComponent> getDependency() {
        if (this.dependency == null) {
            this.dependency = new ArrayList<TestPlanDependencyComponent>();
        }
        return this.dependency;
    }

    public TestPlan setDependency(List<TestPlanDependencyComponent> theDependency) {
        this.dependency = theDependency;
        return this;
    }

    public boolean hasDependency() {
        if (this.dependency == null) {
            return false;
        }
        for (TestPlanDependencyComponent item : this.dependency) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestPlanDependencyComponent addDependency() {
        TestPlanDependencyComponent t = new TestPlanDependencyComponent();
        if (this.dependency == null) {
            this.dependency = new ArrayList<TestPlanDependencyComponent>();
        }
        this.dependency.add(t);
        return t;
    }

    public TestPlan addDependency(TestPlanDependencyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dependency == null) {
            this.dependency = new ArrayList<TestPlanDependencyComponent>();
        }
        this.dependency.add(t);
        return this;
    }

    public TestPlanDependencyComponent getDependencyFirstRep() {
        if (this.getDependency().isEmpty()) {
            this.addDependency();
        }
        return this.getDependency().get(0);
    }

    public MarkdownType getExitCriteriaElement() {
        if (this.exitCriteria == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestPlan.exitCriteria");
            }
            if (Configuration.doAutoCreate()) {
                this.exitCriteria = new MarkdownType();
            }
        }
        return this.exitCriteria;
    }

    public boolean hasExitCriteriaElement() {
        return this.exitCriteria != null && !this.exitCriteria.isEmpty();
    }

    public boolean hasExitCriteria() {
        return this.exitCriteria != null && !this.exitCriteria.isEmpty();
    }

    public TestPlan setExitCriteriaElement(MarkdownType value) {
        this.exitCriteria = value;
        return this;
    }

    public String getExitCriteria() {
        return this.exitCriteria == null ? null : (String)this.exitCriteria.getValue();
    }

    public TestPlan setExitCriteria(String value) {
        if (Utilities.noString((String)value)) {
            this.exitCriteria = null;
        } else {
            if (this.exitCriteria == null) {
                this.exitCriteria = new MarkdownType();
            }
            this.exitCriteria.setValue(value);
        }
        return this;
    }

    public List<TestPlanTestCaseComponent> getTestCase() {
        if (this.testCase == null) {
            this.testCase = new ArrayList<TestPlanTestCaseComponent>();
        }
        return this.testCase;
    }

    public TestPlan setTestCase(List<TestPlanTestCaseComponent> theTestCase) {
        this.testCase = theTestCase;
        return this;
    }

    public boolean hasTestCase() {
        if (this.testCase == null) {
            return false;
        }
        for (TestPlanTestCaseComponent item : this.testCase) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestPlanTestCaseComponent addTestCase() {
        TestPlanTestCaseComponent t = new TestPlanTestCaseComponent();
        if (this.testCase == null) {
            this.testCase = new ArrayList<TestPlanTestCaseComponent>();
        }
        this.testCase.add(t);
        return t;
    }

    public TestPlan addTestCase(TestPlanTestCaseComponent t) {
        if (t == null) {
            return this;
        }
        if (this.testCase == null) {
            this.testCase = new ArrayList<TestPlanTestCaseComponent>();
        }
        this.testCase.add(t);
        return this;
    }

    public TestPlanTestCaseComponent getTestCaseFirstRep() {
        if (this.getTestCase().isEmpty()) {
            this.addTestCase();
        }
        return this.getTestCase().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this test plan when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this test plan is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the test plan is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this test plan when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("version", "string", "The identifier that is used to identify this version of the test plan when it is referenced in a specification, model, design or instance.  This is an arbitrary value managed by the test plan author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property("name", "string", "A natural language name identifying the test plan. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property("title", "string", "A short, descriptive, user-friendly title for the test plan.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this test plan. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this test plan is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property("date", "dateTime", "The date (and optionally time) when the test plan was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the test plan changes.", 0, 1, this.date));
        children.add(new Property("publisher", "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the test plan.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("description", "markdown", "A free text natural language description of the test plan from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate test plan instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("jurisdiction", "CodeableConcept", "A legal or geographic region in which the test plan is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this test plan is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the test plan and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the test plan. The short copyright declaration (e.g. (c) '2015+ xyz organization' should be sent in the copyrightLabel element.", 0, 1, this.copyright));
        children.add(new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel));
        children.add(new Property("category", "CodeableConcept", "The category of the Test Plan - can be acceptance, unit, performance, etc.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SCOPE, "Reference", "What is being tested with this Test Plan - a conformance resource, or narrative criteria, or an external reference...", 0, Integer.MAX_VALUE, this.scope));
        children.add(new Property("testTools", "markdown", "A description of test tools to be used in the test plan.", 0, 1, this.testTools));
        children.add(new Property("dependency", "", "The required criteria to execute the test plan - e.g. preconditions, previous tests...", 0, Integer.MAX_VALUE, this.dependency));
        children.add(new Property("exitCriteria", "markdown", "The threshold or criteria for the test plan to be considered successfully executed - narrative.", 0, 1, this.exitCriteria));
        children.add(new Property("testCase", "", "The individual test cases that are part of this plan, when they they are made explicit.", 0, Integer.MAX_VALUE, this.testCase));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this test plan when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this test plan is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the test plan is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this test plan when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property("version", "string", "The identifier that is used to identify this version of the test plan when it is referenced in a specification, model, design or instance.  This is an arbitrary value managed by the test plan author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property("name", "string", "A natural language name identifying the test plan. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property("title", "string", "A short, descriptive, user-friendly title for the test plan.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this test plan. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this test plan is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property("date", "dateTime", "The date (and optionally time) when the test plan was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the test plan changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property("publisher", "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the test plan.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A free text natural language description of the test plan from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate test plan instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "A legal or geographic region in which the test plan is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this test plan is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the test plan and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the test plan. The short copyright declaration (e.g. (c) '2015+ xyz organization' should be sent in the copyrightLabel element.", 0, 1, this.copyright);
            }
            case 765157229: {
                return new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "The category of the Test Plan - can be acceptance, unit, performance, etc.", 0, Integer.MAX_VALUE, this.category);
            }
            case 109264468: {
                return new Property(SP_SCOPE, "Reference", "What is being tested with this Test Plan - a conformance resource, or narrative criteria, or an external reference...", 0, Integer.MAX_VALUE, this.scope);
            }
            case -1190420375: {
                return new Property("testTools", "markdown", "A description of test tools to be used in the test plan.", 0, 1, this.testTools);
            }
            case -26291381: {
                return new Property("dependency", "", "The required criteria to execute the test plan - e.g. preconditions, previous tests...", 0, Integer.MAX_VALUE, this.dependency);
            }
            case -1382023523: {
                return new Property("exitCriteria", "markdown", "The threshold or criteria for the test plan to be considered successfully executed - narrative.", 0, 1, this.exitCriteria);
            }
            case -1147299102: {
                return new Property("testCase", "", "The individual test cases that are part of this plan, when they they are made explicit.", 0, Integer.MAX_VALUE, this.testCase);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case 765157229: {
                Base[] baseArray;
                if (this.copyrightLabel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.copyrightLabel;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 109264468: {
                return this.scope == null ? new Base[]{} : this.scope.toArray(new Base[this.scope.size()]);
            }
            case -1190420375: {
                Base[] baseArray;
                if (this.testTools == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.testTools;
                }
                return baseArray;
            }
            case -26291381: {
                return this.dependency == null ? new Base[]{} : this.dependency.toArray(new Base[this.dependency.size()]);
            }
            case -1382023523: {
                Base[] baseArray;
                if (this.exitCriteria == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.exitCriteria;
                }
                return baseArray;
            }
            case -1147299102: {
                return this.testCase == null ? new Base[]{} : this.testCase.toArray(new Base[this.testCase.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 765157229: {
                this.copyrightLabel = TypeConvertor.castToString(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 109264468: {
                this.getScope().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1190420375: {
                this.testTools = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -26291381: {
                this.getDependency().add((TestPlanDependencyComponent)((Object)value));
                return value;
            }
            case -1382023523: {
                this.exitCriteria = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1147299102: {
                this.getTestCase().add((TestPlanTestCaseComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("title")) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals("date")) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("publisher")) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = TypeConvertor.castToString(value);
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SCOPE)) {
            this.getScope().add(TypeConvertor.castToReference(value));
        } else if (name.equals("testTools")) {
            this.testTools = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("dependency")) {
            this.getDependency().add((TestPlanDependencyComponent)((Object)value));
        } else if (name.equals("exitCriteria")) {
            this.exitCriteria = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("testCase")) {
            this.getTestCase().add((TestPlanTestCaseComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 765157229: {
                return this.getCopyrightLabelElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 109264468: {
                return this.addScope();
            }
            case -1190420375: {
                return this.getTestToolsElement();
            }
            case -26291381: {
                return this.addDependency();
            }
            case -1382023523: {
                return this.getExitCriteriaElement();
            }
            case -1147299102: {
                return this.addTestCase();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 765157229: {
                return new String[]{"string"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 109264468: {
                return new String[]{"Reference"};
            }
            case -1190420375: {
                return new String[]{"markdown"};
            }
            case -26291381: {
                return new String[0];
            }
            case -1382023523: {
                return new String[]{"markdown"};
            }
            case -1147299102: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.name");
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.experimental");
        }
        if (name.equals("date")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.date");
        }
        if (name.equals("publisher")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("jurisdiction")) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.copyright");
        }
        if (name.equals("copyrightLabel")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.copyrightLabel");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_SCOPE)) {
            return this.addScope();
        }
        if (name.equals("testTools")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.testTools");
        }
        if (name.equals("dependency")) {
            return this.addDependency();
        }
        if (name.equals("exitCriteria")) {
            throw new FHIRException("Cannot call addChild on a primitive type TestPlan.exitCriteria");
        }
        if (name.equals("testCase")) {
            return this.addTestCase();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TestPlan";
    }

    @Override
    public TestPlan copy() {
        TestPlan dst = new TestPlan();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(TestPlan dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        StringType stringType2 = dst.copyrightLabel = this.copyrightLabel == null ? null : this.copyrightLabel.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        if (this.scope != null) {
            dst.scope = new ArrayList<Reference>();
            for (Reference reference : this.scope) {
                dst.scope.add(reference.copy());
            }
        }
        MarkdownType markdownType2 = dst.testTools = this.testTools == null ? null : this.testTools.copy();
        if (this.dependency != null) {
            dst.dependency = new ArrayList<TestPlanDependencyComponent>();
            for (TestPlanDependencyComponent testPlanDependencyComponent : this.dependency) {
                dst.dependency.add(testPlanDependencyComponent.copy());
            }
        }
        MarkdownType markdownType3 = dst.exitCriteria = this.exitCriteria == null ? null : this.exitCriteria.copy();
        if (this.testCase != null) {
            dst.testCase = new ArrayList<TestPlanTestCaseComponent>();
            for (TestPlanTestCaseComponent testPlanTestCaseComponent : this.testCase) {
                dst.testCase.add(testPlanTestCaseComponent.copy());
            }
        }
    }

    protected TestPlan typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TestPlan)) {
            return false;
        }
        TestPlan o = (TestPlan)other_;
        return TestPlan.compareDeep(this.url, o.url, true) && TestPlan.compareDeep(this.identifier, o.identifier, true) && TestPlan.compareDeep(this.version, o.version, true) && TestPlan.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && TestPlan.compareDeep(this.name, o.name, true) && TestPlan.compareDeep(this.title, o.title, true) && TestPlan.compareDeep(this.status, o.status, true) && TestPlan.compareDeep(this.experimental, o.experimental, true) && TestPlan.compareDeep(this.date, o.date, true) && TestPlan.compareDeep(this.publisher, o.publisher, true) && TestPlan.compareDeep(this.contact, o.contact, true) && TestPlan.compareDeep(this.description, o.description, true) && TestPlan.compareDeep(this.useContext, o.useContext, true) && TestPlan.compareDeep(this.jurisdiction, o.jurisdiction, true) && TestPlan.compareDeep(this.purpose, o.purpose, true) && TestPlan.compareDeep(this.copyright, o.copyright, true) && TestPlan.compareDeep(this.copyrightLabel, o.copyrightLabel, true) && TestPlan.compareDeep(this.category, o.category, true) && TestPlan.compareDeep(this.scope, o.scope, true) && TestPlan.compareDeep(this.testTools, o.testTools, true) && TestPlan.compareDeep(this.dependency, o.dependency, true) && TestPlan.compareDeep(this.exitCriteria, o.exitCriteria, true) && TestPlan.compareDeep(this.testCase, o.testCase, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TestPlan)) {
            return false;
        }
        TestPlan o = (TestPlan)other_;
        return TestPlan.compareValues(this.url, o.url, true) && TestPlan.compareValues(this.version, o.version, true) && TestPlan.compareValues(this.name, o.name, true) && TestPlan.compareValues(this.title, o.title, true) && TestPlan.compareValues(this.status, o.status, true) && TestPlan.compareValues(this.experimental, o.experimental, true) && TestPlan.compareValues(this.date, o.date, true) && TestPlan.compareValues(this.publisher, o.publisher, true) && TestPlan.compareValues(this.description, o.description, true) && TestPlan.compareValues(this.purpose, o.purpose, true) && TestPlan.compareValues(this.copyright, o.copyright, true) && TestPlan.compareValues(this.copyrightLabel, o.copyrightLabel, true) && TestPlan.compareValues(this.testTools, o.testTools, true) && TestPlan.compareValues(this.exitCriteria, o.exitCriteria, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.versionAlgorithm, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.copyrightLabel, this.category, this.scope, this.testTools, this.dependency, this.exitCriteria, this.testCase});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.TestPlan;
    }

    @Block
    public static class TestPlanTestCaseAssertionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Assertion type - for example 'informative' or 'required' ", formalDefinition="The test assertion type - this can be used to group assertions as 'required' or 'optional', or can be used for other classification of the assertion.")
        protected List<CodeableConcept> type;
        @Child(name="object", type={CodeableReference.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The focus or object of the assertion", formalDefinition="The focus or object of the assertion i.e. a resource.")
        protected List<CodeableReference> object;
        @Child(name="result", type={CodeableReference.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The actual result assertion", formalDefinition="The test assertion - the expected outcome from the test case execution.")
        protected List<CodeableReference> result;
        private static final long serialVersionUID = 481177705L;

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public TestPlanTestCaseAssertionComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public TestPlanTestCaseAssertionComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public List<CodeableReference> getObject() {
            if (this.object == null) {
                this.object = new ArrayList<CodeableReference>();
            }
            return this.object;
        }

        public TestPlanTestCaseAssertionComponent setObject(List<CodeableReference> theObject) {
            this.object = theObject;
            return this;
        }

        public boolean hasObject() {
            if (this.object == null) {
                return false;
            }
            for (CodeableReference item : this.object) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addObject() {
            CodeableReference t = new CodeableReference();
            if (this.object == null) {
                this.object = new ArrayList<CodeableReference>();
            }
            this.object.add(t);
            return t;
        }

        public TestPlanTestCaseAssertionComponent addObject(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.object == null) {
                this.object = new ArrayList<CodeableReference>();
            }
            this.object.add(t);
            return this;
        }

        public CodeableReference getObjectFirstRep() {
            if (this.getObject().isEmpty()) {
                this.addObject();
            }
            return this.getObject().get(0);
        }

        public List<CodeableReference> getResult() {
            if (this.result == null) {
                this.result = new ArrayList<CodeableReference>();
            }
            return this.result;
        }

        public TestPlanTestCaseAssertionComponent setResult(List<CodeableReference> theResult) {
            this.result = theResult;
            return this;
        }

        public boolean hasResult() {
            if (this.result == null) {
                return false;
            }
            for (CodeableReference item : this.result) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addResult() {
            CodeableReference t = new CodeableReference();
            if (this.result == null) {
                this.result = new ArrayList<CodeableReference>();
            }
            this.result.add(t);
            return t;
        }

        public TestPlanTestCaseAssertionComponent addResult(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.result == null) {
                this.result = new ArrayList<CodeableReference>();
            }
            this.result.add(t);
            return this;
        }

        public CodeableReference getResultFirstRep() {
            if (this.getResult().isEmpty()) {
                this.addResult();
            }
            return this.getResult().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The test assertion type - this can be used to group assertions as 'required' or 'optional', or can be used for other classification of the assertion.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("object", "CodeableReference", "The focus or object of the assertion i.e. a resource.", 0, Integer.MAX_VALUE, this.object));
            children.add(new Property("result", "CodeableReference", "The test assertion - the expected outcome from the test case execution.", 0, Integer.MAX_VALUE, this.result));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The test assertion type - this can be used to group assertions as 'required' or 'optional', or can be used for other classification of the assertion.", 0, Integer.MAX_VALUE, this.type);
                }
                case -1023368385: {
                    return new Property("object", "CodeableReference", "The focus or object of the assertion i.e. a resource.", 0, Integer.MAX_VALUE, this.object);
                }
                case -934426595: {
                    return new Property("result", "CodeableReference", "The test assertion - the expected outcome from the test case execution.", 0, Integer.MAX_VALUE, this.result);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -1023368385: {
                    return this.object == null ? new Base[]{} : this.object.toArray(new Base[this.object.size()]);
                }
                case -934426595: {
                    return this.result == null ? new Base[]{} : this.result.toArray(new Base[this.result.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1023368385: {
                    this.getObject().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case -934426595: {
                    this.getResult().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("object")) {
                this.getObject().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("result")) {
                this.getResult().add(TypeConvertor.castToCodeableReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -1023368385: {
                    return this.addObject();
                }
                case -934426595: {
                    return this.addResult();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1023368385: {
                    return new String[]{"CodeableReference"};
                }
                case -934426595: {
                    return new String[]{"CodeableReference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("object")) {
                return this.addObject();
            }
            if (name.equals("result")) {
                return this.addResult();
            }
            return super.addChild(name);
        }

        @Override
        public TestPlanTestCaseAssertionComponent copy() {
            TestPlanTestCaseAssertionComponent dst = new TestPlanTestCaseAssertionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestPlanTestCaseAssertionComponent dst) {
            super.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.type) {
                    dst.type.add(codeableConcept.copy());
                }
            }
            if (this.object != null) {
                dst.object = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.object) {
                    dst.object.add(codeableReference.copy());
                }
            }
            if (this.result != null) {
                dst.result = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.result) {
                    dst.result.add(codeableReference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseAssertionComponent)) {
                return false;
            }
            TestPlanTestCaseAssertionComponent o = (TestPlanTestCaseAssertionComponent)other_;
            return TestPlanTestCaseAssertionComponent.compareDeep(this.type, o.type, true) && TestPlanTestCaseAssertionComponent.compareDeep(this.object, o.object, true) && TestPlanTestCaseAssertionComponent.compareDeep(this.result, o.result, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseAssertionComponent)) {
                return false;
            }
            TestPlanTestCaseAssertionComponent o = (TestPlanTestCaseAssertionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.object, this.result});
        }

        @Override
        public String fhirType() {
            return "TestPlan.testCase.assertion";
        }
    }

    @Block
    public static class TestPlanTestCaseTestDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of test data description, e.g. 'synthea'", formalDefinition="The type of test data description, e.g. 'synthea'.")
        protected Coding type;
        @Child(name="content", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The actual test resources when they exist", formalDefinition="The actual test resources when they exist.")
        protected Reference content;
        @Child(name="source", type={StringType.class, Reference.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pointer to a definition of test resources - narrative or structured e.g. synthetic data generation, etc", formalDefinition="Pointer to a definition of test resources - narrative or structured e.g. synthetic data generation, etc.")
        protected DataType source;
        private static final long serialVersionUID = -300912813L;

        public TestPlanTestCaseTestDataComponent() {
        }

        public TestPlanTestCaseTestDataComponent(Coding type) {
            this.setType(type);
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestPlanTestCaseTestDataComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TestPlanTestCaseTestDataComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Reference getContent() {
            if (this.content == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestPlanTestCaseTestDataComponent.content");
                }
                if (Configuration.doAutoCreate()) {
                    this.content = new Reference();
                }
            }
            return this.content;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public TestPlanTestCaseTestDataComponent setContent(Reference value) {
            this.content = value;
            return this;
        }

        public DataType getSource() {
            return this.source;
        }

        public StringType getSourceStringType() throws FHIRException {
            if (this.source == null) {
                this.source = new StringType();
            }
            if (!(this.source instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (StringType)this.source;
        }

        public boolean hasSourceStringType() {
            return this != null && this.source instanceof StringType;
        }

        public Reference getSourceReference() throws FHIRException {
            if (this.source == null) {
                this.source = new Reference();
            }
            if (!(this.source instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (Reference)this.source;
        }

        public boolean hasSourceReference() {
            return this != null && this.source instanceof Reference;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public TestPlanTestCaseTestDataComponent setSource(DataType value) {
            if (value != null && !(value instanceof StringType) && !(value instanceof Reference)) {
                throw new FHIRException("Not the right type for TestPlan.testCase.testData.source[x]: " + value.fhirType());
            }
            this.source = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "Coding", "The type of test data description, e.g. 'synthea'.", 0, 1, this.type));
            children.add(new Property("content", "Reference", "The actual test resources when they exist.", 0, 1, this.content));
            children.add(new Property("source[x]", "string|Reference", "Pointer to a definition of test resources - narrative or structured e.g. synthetic data generation, etc.", 0, 1, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "Coding", "The type of test data description, e.g. 'synthea'.", 0, 1, this.type);
                }
                case 951530617: {
                    return new Property("content", "Reference", "The actual test resources when they exist.", 0, 1, this.content);
                }
                case -1698413947: {
                    return new Property("source[x]", "string|Reference", "Pointer to a definition of test resources - narrative or structured e.g. synthetic data generation, etc.", 0, 1, this.source);
                }
                case -896505829: {
                    return new Property("source[x]", "string|Reference", "Pointer to a definition of test resources - narrative or structured e.g. synthetic data generation, etc.", 0, 1, this.source);
                }
                case 1327821836: {
                    return new Property("source[x]", "string", "Pointer to a definition of test resources - narrative or structured e.g. synthetic data generation, etc.", 0, 1, this.source);
                }
                case -244259472: {
                    return new Property("source[x]", "Reference", "Pointer to a definition of test resources - narrative or structured e.g. synthetic data generation, etc.", 0, 1, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.content;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.source;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCoding(value);
                    return value;
                }
                case 951530617: {
                    this.content = TypeConvertor.castToReference(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCoding(value);
            } else if (name.equals("content")) {
                this.content = TypeConvertor.castToReference(value);
            } else if (name.equals("source[x]")) {
                this.source = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 951530617: {
                    return this.getContent();
                }
                case -1698413947: {
                    return this.getSource();
                }
                case -896505829: {
                    return this.getSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case 951530617: {
                    return new String[]{"Reference"};
                }
                case -896505829: {
                    return new String[]{"string", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("content")) {
                this.content = new Reference();
                return this.content;
            }
            if (name.equals("sourceString")) {
                this.source = new StringType();
                return this.source;
            }
            if (name.equals("sourceReference")) {
                this.source = new Reference();
                return this.source;
            }
            return super.addChild(name);
        }

        @Override
        public TestPlanTestCaseTestDataComponent copy() {
            TestPlanTestCaseTestDataComponent dst = new TestPlanTestCaseTestDataComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestPlanTestCaseTestDataComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.content = this.content == null ? null : this.content.copy();
            dst.source = this.source == null ? null : this.source.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseTestDataComponent)) {
                return false;
            }
            TestPlanTestCaseTestDataComponent o = (TestPlanTestCaseTestDataComponent)other_;
            return TestPlanTestCaseTestDataComponent.compareDeep(this.type, o.type, true) && TestPlanTestCaseTestDataComponent.compareDeep(this.content, o.content, true) && TestPlanTestCaseTestDataComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseTestDataComponent)) {
                return false;
            }
            TestPlanTestCaseTestDataComponent o = (TestPlanTestCaseTestDataComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.content, this.source});
        }

        @Override
        public String fhirType() {
            return "TestPlan.testCase.testData";
        }
    }

    @Block
    public static class TestPlanTestCaseTestRunScriptComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The language for the test cases e.g. 'gherkin', 'testscript'", formalDefinition="The language for the test cases e.g. 'gherkin', 'testscript'.")
        protected CodeableConcept language;
        @Child(name="source", type={StringType.class, Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The actual content of the cases - references to TestScripts or externally defined content", formalDefinition="The actual content of the cases - references to TestScripts or externally defined content.")
        protected DataType source;
        private static final long serialVersionUID = 1308596610L;

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestPlanTestCaseTestRunScriptComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public TestPlanTestCaseTestRunScriptComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public DataType getSource() {
            return this.source;
        }

        public StringType getSourceStringType() throws FHIRException {
            if (this.source == null) {
                this.source = new StringType();
            }
            if (!(this.source instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (StringType)this.source;
        }

        public boolean hasSourceStringType() {
            return this != null && this.source instanceof StringType;
        }

        public Reference getSourceReference() throws FHIRException {
            if (this.source == null) {
                this.source = new Reference();
            }
            if (!(this.source instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (Reference)this.source;
        }

        public boolean hasSourceReference() {
            return this != null && this.source instanceof Reference;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public TestPlanTestCaseTestRunScriptComponent setSource(DataType value) {
            if (value != null && !(value instanceof StringType) && !(value instanceof Reference)) {
                throw new FHIRException("Not the right type for TestPlan.testCase.testRun.script.source[x]: " + value.fhirType());
            }
            this.source = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("language", "CodeableConcept", "The language for the test cases e.g. 'gherkin', 'testscript'.", 0, 1, this.language));
            children.add(new Property("source[x]", "string|Reference", "The actual content of the cases - references to TestScripts or externally defined content.", 0, 1, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "The language for the test cases e.g. 'gherkin', 'testscript'.", 0, 1, this.language);
                }
                case -1698413947: {
                    return new Property("source[x]", "string|Reference", "The actual content of the cases - references to TestScripts or externally defined content.", 0, 1, this.source);
                }
                case -896505829: {
                    return new Property("source[x]", "string|Reference", "The actual content of the cases - references to TestScripts or externally defined content.", 0, 1, this.source);
                }
                case 1327821836: {
                    return new Property("source[x]", "string", "The actual content of the cases - references to TestScripts or externally defined content.", 0, 1, this.source);
                }
                case -244259472: {
                    return new Property("source[x]", "Reference", "The actual content of the cases - references to TestScripts or externally defined content.", 0, 1, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source[x]")) {
                this.source = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguage();
                }
                case -1698413947: {
                    return this.getSource();
                }
                case -896505829: {
                    return this.getSource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"string", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("sourceString")) {
                this.source = new StringType();
                return this.source;
            }
            if (name.equals("sourceReference")) {
                this.source = new Reference();
                return this.source;
            }
            return super.addChild(name);
        }

        @Override
        public TestPlanTestCaseTestRunScriptComponent copy() {
            TestPlanTestCaseTestRunScriptComponent dst = new TestPlanTestCaseTestRunScriptComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestPlanTestCaseTestRunScriptComponent dst) {
            super.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.source = this.source == null ? null : this.source.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseTestRunScriptComponent)) {
                return false;
            }
            TestPlanTestCaseTestRunScriptComponent o = (TestPlanTestCaseTestRunScriptComponent)other_;
            return TestPlanTestCaseTestRunScriptComponent.compareDeep(this.language, o.language, true) && TestPlanTestCaseTestRunScriptComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseTestRunScriptComponent)) {
                return false;
            }
            TestPlanTestCaseTestRunScriptComponent o = (TestPlanTestCaseTestRunScriptComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.language, this.source});
        }

        @Override
        public String fhirType() {
            return "TestPlan.testCase.testRun.script";
        }
    }

    @Block
    public static class TestPlanTestCaseTestRunComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="narrative", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The narrative description of the tests", formalDefinition="The narrative description of the tests.")
        protected MarkdownType narrative;
        @Child(name="script", type={}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The test cases in a structured language e.g. gherkin, Postman, or FHIR TestScript", formalDefinition="The test cases in a structured language e.g. gherkin, Postman, or FHIR TestScript.")
        protected TestPlanTestCaseTestRunScriptComponent script;
        private static final long serialVersionUID = -763780736L;

        public MarkdownType getNarrativeElement() {
            if (this.narrative == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestPlanTestCaseTestRunComponent.narrative");
                }
                if (Configuration.doAutoCreate()) {
                    this.narrative = new MarkdownType();
                }
            }
            return this.narrative;
        }

        public boolean hasNarrativeElement() {
            return this.narrative != null && !this.narrative.isEmpty();
        }

        public boolean hasNarrative() {
            return this.narrative != null && !this.narrative.isEmpty();
        }

        public TestPlanTestCaseTestRunComponent setNarrativeElement(MarkdownType value) {
            this.narrative = value;
            return this;
        }

        public String getNarrative() {
            return this.narrative == null ? null : (String)this.narrative.getValue();
        }

        public TestPlanTestCaseTestRunComponent setNarrative(String value) {
            if (Utilities.noString((String)value)) {
                this.narrative = null;
            } else {
                if (this.narrative == null) {
                    this.narrative = new MarkdownType();
                }
                this.narrative.setValue(value);
            }
            return this;
        }

        public TestPlanTestCaseTestRunScriptComponent getScript() {
            if (this.script == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestPlanTestCaseTestRunComponent.script");
                }
                if (Configuration.doAutoCreate()) {
                    this.script = new TestPlanTestCaseTestRunScriptComponent();
                }
            }
            return this.script;
        }

        public boolean hasScript() {
            return this.script != null && !this.script.isEmpty();
        }

        public TestPlanTestCaseTestRunComponent setScript(TestPlanTestCaseTestRunScriptComponent value) {
            this.script = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("narrative", "markdown", "The narrative description of the tests.", 0, 1, this.narrative));
            children.add(new Property("script", "", "The test cases in a structured language e.g. gherkin, Postman, or FHIR TestScript.", 0, 1, this.script));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1750452338: {
                    return new Property("narrative", "markdown", "The narrative description of the tests.", 0, 1, this.narrative);
                }
                case -907685685: {
                    return new Property("script", "", "The test cases in a structured language e.g. gherkin, Postman, or FHIR TestScript.", 0, 1, this.script);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1750452338: {
                    Base[] baseArray;
                    if (this.narrative == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.narrative;
                    }
                    return baseArray;
                }
                case -907685685: {
                    Base[] baseArray;
                    if (this.script == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.script;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1750452338: {
                    this.narrative = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -907685685: {
                    this.script = (TestPlanTestCaseTestRunScriptComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("narrative")) {
                this.narrative = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("script")) {
                this.script = (TestPlanTestCaseTestRunScriptComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1750452338: {
                    return this.getNarrativeElement();
                }
                case -907685685: {
                    return this.getScript();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1750452338: {
                    return new String[]{"markdown"};
                }
                case -907685685: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("narrative")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestPlan.testCase.testRun.narrative");
            }
            if (name.equals("script")) {
                this.script = new TestPlanTestCaseTestRunScriptComponent();
                return this.script;
            }
            return super.addChild(name);
        }

        @Override
        public TestPlanTestCaseTestRunComponent copy() {
            TestPlanTestCaseTestRunComponent dst = new TestPlanTestCaseTestRunComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestPlanTestCaseTestRunComponent dst) {
            super.copyValues(dst);
            dst.narrative = this.narrative == null ? null : this.narrative.copy();
            dst.script = this.script == null ? null : this.script.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseTestRunComponent)) {
                return false;
            }
            TestPlanTestCaseTestRunComponent o = (TestPlanTestCaseTestRunComponent)other_;
            return TestPlanTestCaseTestRunComponent.compareDeep(this.narrative, o.narrative, true) && TestPlanTestCaseTestRunComponent.compareDeep(this.script, o.script, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseTestRunComponent)) {
                return false;
            }
            TestPlanTestCaseTestRunComponent o = (TestPlanTestCaseTestRunComponent)other_;
            return TestPlanTestCaseTestRunComponent.compareValues(this.narrative, o.narrative, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.narrative, this.script});
        }

        @Override
        public String fhirType() {
            return "TestPlan.testCase.testRun";
        }
    }

    @Block
    public static class TestCaseDependencyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the criteria", formalDefinition="Description of the criteria.")
        protected MarkdownType description;
        @Child(name="predecessor", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Link to predecessor test plans", formalDefinition="Link to predecessor test plans.")
        protected Reference predecessor;
        private static final long serialVersionUID = 1630757943L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCaseDependencyComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestCaseDependencyComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestCaseDependencyComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Reference getPredecessor() {
            if (this.predecessor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCaseDependencyComponent.predecessor");
                }
                if (Configuration.doAutoCreate()) {
                    this.predecessor = new Reference();
                }
            }
            return this.predecessor;
        }

        public boolean hasPredecessor() {
            return this.predecessor != null && !this.predecessor.isEmpty();
        }

        public TestCaseDependencyComponent setPredecessor(Reference value) {
            this.predecessor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "Description of the criteria.", 0, 1, this.description));
            children.add(new Property("predecessor", "Reference", "Link to predecessor test plans.", 0, 1, this.predecessor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "Description of the criteria.", 0, 1, this.description);
                }
                case -1925032183: {
                    return new Property("predecessor", "Reference", "Link to predecessor test plans.", 0, 1, this.predecessor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1925032183: {
                    Base[] baseArray;
                    if (this.predecessor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.predecessor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -1925032183: {
                    this.predecessor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("predecessor")) {
                this.predecessor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1925032183: {
                    return this.getPredecessor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -1925032183: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestPlan.testCase.dependency.description");
            }
            if (name.equals("predecessor")) {
                this.predecessor = new Reference();
                return this.predecessor;
            }
            return super.addChild(name);
        }

        @Override
        public TestCaseDependencyComponent copy() {
            TestCaseDependencyComponent dst = new TestCaseDependencyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestCaseDependencyComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.predecessor = this.predecessor == null ? null : this.predecessor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCaseDependencyComponent)) {
                return false;
            }
            TestCaseDependencyComponent o = (TestCaseDependencyComponent)other_;
            return TestCaseDependencyComponent.compareDeep(this.description, o.description, true) && TestCaseDependencyComponent.compareDeep(this.predecessor, o.predecessor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCaseDependencyComponent)) {
                return false;
            }
            TestCaseDependencyComponent o = (TestCaseDependencyComponent)other_;
            return TestCaseDependencyComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.predecessor});
        }

        @Override
        public String fhirType() {
            return "TestPlan.testCase.dependency";
        }
    }

    @Block
    public static class TestPlanTestCaseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sequence of test case in the test plan", formalDefinition="Sequence of test case - an ordinal number that indicates the order for the present test case in the test plan.")
        protected IntegerType sequence;
        @Child(name="scope", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The scope or artifact covered by the case", formalDefinition="The scope or artifact covered by the case, when the individual test case is associated with a testable artifact.")
        protected List<Reference> scope;
        @Child(name="dependency", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Required criteria to execute the test case", formalDefinition="The required criteria to execute the test case - e.g. preconditions, previous tests.")
        protected List<TestCaseDependencyComponent> dependency;
        @Child(name="testRun", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The actual test to be executed", formalDefinition="The actual test to be executed.")
        protected List<TestPlanTestCaseTestRunComponent> testRun;
        @Child(name="testData", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The test data used in the test case", formalDefinition="The test data used in the test case.")
        protected List<TestPlanTestCaseTestDataComponent> testData;
        @Child(name="assertion", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Test assertions or expectations", formalDefinition="The test assertions - the expectations of test results from the execution of the test case.")
        protected List<TestPlanTestCaseAssertionComponent> assertion;
        private static final long serialVersionUID = 1605296611L;

        public IntegerType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestPlanTestCaseComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new IntegerType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public TestPlanTestCaseComponent setSequenceElement(IntegerType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public TestPlanTestCaseComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new IntegerType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public List<Reference> getScope() {
            if (this.scope == null) {
                this.scope = new ArrayList<Reference>();
            }
            return this.scope;
        }

        public TestPlanTestCaseComponent setScope(List<Reference> theScope) {
            this.scope = theScope;
            return this;
        }

        public boolean hasScope() {
            if (this.scope == null) {
                return false;
            }
            for (Reference item : this.scope) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addScope() {
            Reference t = new Reference();
            if (this.scope == null) {
                this.scope = new ArrayList<Reference>();
            }
            this.scope.add(t);
            return t;
        }

        public TestPlanTestCaseComponent addScope(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.scope == null) {
                this.scope = new ArrayList<Reference>();
            }
            this.scope.add(t);
            return this;
        }

        public Reference getScopeFirstRep() {
            if (this.getScope().isEmpty()) {
                this.addScope();
            }
            return this.getScope().get(0);
        }

        public List<TestCaseDependencyComponent> getDependency() {
            if (this.dependency == null) {
                this.dependency = new ArrayList<TestCaseDependencyComponent>();
            }
            return this.dependency;
        }

        public TestPlanTestCaseComponent setDependency(List<TestCaseDependencyComponent> theDependency) {
            this.dependency = theDependency;
            return this;
        }

        public boolean hasDependency() {
            if (this.dependency == null) {
                return false;
            }
            for (TestCaseDependencyComponent item : this.dependency) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestCaseDependencyComponent addDependency() {
            TestCaseDependencyComponent t = new TestCaseDependencyComponent();
            if (this.dependency == null) {
                this.dependency = new ArrayList<TestCaseDependencyComponent>();
            }
            this.dependency.add(t);
            return t;
        }

        public TestPlanTestCaseComponent addDependency(TestCaseDependencyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dependency == null) {
                this.dependency = new ArrayList<TestCaseDependencyComponent>();
            }
            this.dependency.add(t);
            return this;
        }

        public TestCaseDependencyComponent getDependencyFirstRep() {
            if (this.getDependency().isEmpty()) {
                this.addDependency();
            }
            return this.getDependency().get(0);
        }

        public List<TestPlanTestCaseTestRunComponent> getTestRun() {
            if (this.testRun == null) {
                this.testRun = new ArrayList<TestPlanTestCaseTestRunComponent>();
            }
            return this.testRun;
        }

        public TestPlanTestCaseComponent setTestRun(List<TestPlanTestCaseTestRunComponent> theTestRun) {
            this.testRun = theTestRun;
            return this;
        }

        public boolean hasTestRun() {
            if (this.testRun == null) {
                return false;
            }
            for (TestPlanTestCaseTestRunComponent item : this.testRun) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestPlanTestCaseTestRunComponent addTestRun() {
            TestPlanTestCaseTestRunComponent t = new TestPlanTestCaseTestRunComponent();
            if (this.testRun == null) {
                this.testRun = new ArrayList<TestPlanTestCaseTestRunComponent>();
            }
            this.testRun.add(t);
            return t;
        }

        public TestPlanTestCaseComponent addTestRun(TestPlanTestCaseTestRunComponent t) {
            if (t == null) {
                return this;
            }
            if (this.testRun == null) {
                this.testRun = new ArrayList<TestPlanTestCaseTestRunComponent>();
            }
            this.testRun.add(t);
            return this;
        }

        public TestPlanTestCaseTestRunComponent getTestRunFirstRep() {
            if (this.getTestRun().isEmpty()) {
                this.addTestRun();
            }
            return this.getTestRun().get(0);
        }

        public List<TestPlanTestCaseTestDataComponent> getTestData() {
            if (this.testData == null) {
                this.testData = new ArrayList<TestPlanTestCaseTestDataComponent>();
            }
            return this.testData;
        }

        public TestPlanTestCaseComponent setTestData(List<TestPlanTestCaseTestDataComponent> theTestData) {
            this.testData = theTestData;
            return this;
        }

        public boolean hasTestData() {
            if (this.testData == null) {
                return false;
            }
            for (TestPlanTestCaseTestDataComponent item : this.testData) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestPlanTestCaseTestDataComponent addTestData() {
            TestPlanTestCaseTestDataComponent t = new TestPlanTestCaseTestDataComponent();
            if (this.testData == null) {
                this.testData = new ArrayList<TestPlanTestCaseTestDataComponent>();
            }
            this.testData.add(t);
            return t;
        }

        public TestPlanTestCaseComponent addTestData(TestPlanTestCaseTestDataComponent t) {
            if (t == null) {
                return this;
            }
            if (this.testData == null) {
                this.testData = new ArrayList<TestPlanTestCaseTestDataComponent>();
            }
            this.testData.add(t);
            return this;
        }

        public TestPlanTestCaseTestDataComponent getTestDataFirstRep() {
            if (this.getTestData().isEmpty()) {
                this.addTestData();
            }
            return this.getTestData().get(0);
        }

        public List<TestPlanTestCaseAssertionComponent> getAssertion() {
            if (this.assertion == null) {
                this.assertion = new ArrayList<TestPlanTestCaseAssertionComponent>();
            }
            return this.assertion;
        }

        public TestPlanTestCaseComponent setAssertion(List<TestPlanTestCaseAssertionComponent> theAssertion) {
            this.assertion = theAssertion;
            return this;
        }

        public boolean hasAssertion() {
            if (this.assertion == null) {
                return false;
            }
            for (TestPlanTestCaseAssertionComponent item : this.assertion) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestPlanTestCaseAssertionComponent addAssertion() {
            TestPlanTestCaseAssertionComponent t = new TestPlanTestCaseAssertionComponent();
            if (this.assertion == null) {
                this.assertion = new ArrayList<TestPlanTestCaseAssertionComponent>();
            }
            this.assertion.add(t);
            return t;
        }

        public TestPlanTestCaseComponent addAssertion(TestPlanTestCaseAssertionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.assertion == null) {
                this.assertion = new ArrayList<TestPlanTestCaseAssertionComponent>();
            }
            this.assertion.add(t);
            return this;
        }

        public TestPlanTestCaseAssertionComponent getAssertionFirstRep() {
            if (this.getAssertion().isEmpty()) {
                this.addAssertion();
            }
            return this.getAssertion().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "integer", "Sequence of test case - an ordinal number that indicates the order for the present test case in the test plan.", 0, 1, this.sequence));
            children.add(new Property(TestPlan.SP_SCOPE, "Reference", "The scope or artifact covered by the case, when the individual test case is associated with a testable artifact.", 0, Integer.MAX_VALUE, this.scope));
            children.add(new Property("dependency", "", "The required criteria to execute the test case - e.g. preconditions, previous tests.", 0, Integer.MAX_VALUE, this.dependency));
            children.add(new Property("testRun", "", "The actual test to be executed.", 0, Integer.MAX_VALUE, this.testRun));
            children.add(new Property("testData", "", "The test data used in the test case.", 0, Integer.MAX_VALUE, this.testData));
            children.add(new Property("assertion", "", "The test assertions - the expectations of test results from the execution of the test case.", 0, Integer.MAX_VALUE, this.assertion));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "integer", "Sequence of test case - an ordinal number that indicates the order for the present test case in the test plan.", 0, 1, this.sequence);
                }
                case 109264468: {
                    return new Property(TestPlan.SP_SCOPE, "Reference", "The scope or artifact covered by the case, when the individual test case is associated with a testable artifact.", 0, Integer.MAX_VALUE, this.scope);
                }
                case -26291381: {
                    return new Property("dependency", "", "The required criteria to execute the test case - e.g. preconditions, previous tests.", 0, Integer.MAX_VALUE, this.dependency);
                }
                case -1422467943: {
                    return new Property("testRun", "", "The actual test to be executed.", 0, Integer.MAX_VALUE, this.testRun);
                }
                case -1147269284: {
                    return new Property("testData", "", "The test data used in the test case.", 0, Integer.MAX_VALUE, this.testData);
                }
                case 1314395906: {
                    return new Property("assertion", "", "The test assertions - the expectations of test results from the execution of the test case.", 0, Integer.MAX_VALUE, this.assertion);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 109264468: {
                    return this.scope == null ? new Base[]{} : this.scope.toArray(new Base[this.scope.size()]);
                }
                case -26291381: {
                    return this.dependency == null ? new Base[]{} : this.dependency.toArray(new Base[this.dependency.size()]);
                }
                case -1422467943: {
                    return this.testRun == null ? new Base[]{} : this.testRun.toArray(new Base[this.testRun.size()]);
                }
                case -1147269284: {
                    return this.testData == null ? new Base[]{} : this.testData.toArray(new Base[this.testData.size()]);
                }
                case 1314395906: {
                    return this.assertion == null ? new Base[]{} : this.assertion.toArray(new Base[this.assertion.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 109264468: {
                    this.getScope().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -26291381: {
                    this.getDependency().add((TestCaseDependencyComponent)value);
                    return value;
                }
                case -1422467943: {
                    this.getTestRun().add((TestPlanTestCaseTestRunComponent)value);
                    return value;
                }
                case -1147269284: {
                    this.getTestData().add((TestPlanTestCaseTestDataComponent)value);
                    return value;
                }
                case 1314395906: {
                    this.getAssertion().add((TestPlanTestCaseAssertionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = TypeConvertor.castToInteger(value);
            } else if (name.equals(TestPlan.SP_SCOPE)) {
                this.getScope().add(TypeConvertor.castToReference(value));
            } else if (name.equals("dependency")) {
                this.getDependency().add((TestCaseDependencyComponent)value);
            } else if (name.equals("testRun")) {
                this.getTestRun().add((TestPlanTestCaseTestRunComponent)value);
            } else if (name.equals("testData")) {
                this.getTestData().add((TestPlanTestCaseTestDataComponent)value);
            } else if (name.equals("assertion")) {
                this.getAssertion().add((TestPlanTestCaseAssertionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 109264468: {
                    return this.addScope();
                }
                case -26291381: {
                    return this.addDependency();
                }
                case -1422467943: {
                    return this.addTestRun();
                }
                case -1147269284: {
                    return this.addTestData();
                }
                case 1314395906: {
                    return this.addAssertion();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"integer"};
                }
                case 109264468: {
                    return new String[]{"Reference"};
                }
                case -26291381: {
                    return new String[0];
                }
                case -1422467943: {
                    return new String[0];
                }
                case -1147269284: {
                    return new String[0];
                }
                case 1314395906: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestPlan.testCase.sequence");
            }
            if (name.equals(TestPlan.SP_SCOPE)) {
                return this.addScope();
            }
            if (name.equals("dependency")) {
                return this.addDependency();
            }
            if (name.equals("testRun")) {
                return this.addTestRun();
            }
            if (name.equals("testData")) {
                return this.addTestData();
            }
            if (name.equals("assertion")) {
                return this.addAssertion();
            }
            return super.addChild(name);
        }

        @Override
        public TestPlanTestCaseComponent copy() {
            TestPlanTestCaseComponent dst = new TestPlanTestCaseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestPlanTestCaseComponent dst) {
            super.copyValues(dst);
            IntegerType integerType = dst.sequence = this.sequence == null ? null : this.sequence.copy();
            if (this.scope != null) {
                dst.scope = new ArrayList<Reference>();
                for (Reference reference : this.scope) {
                    dst.scope.add(reference.copy());
                }
            }
            if (this.dependency != null) {
                dst.dependency = new ArrayList<TestCaseDependencyComponent>();
                for (TestCaseDependencyComponent testCaseDependencyComponent : this.dependency) {
                    dst.dependency.add(testCaseDependencyComponent.copy());
                }
            }
            if (this.testRun != null) {
                dst.testRun = new ArrayList<TestPlanTestCaseTestRunComponent>();
                for (TestPlanTestCaseTestRunComponent testPlanTestCaseTestRunComponent : this.testRun) {
                    dst.testRun.add(testPlanTestCaseTestRunComponent.copy());
                }
            }
            if (this.testData != null) {
                dst.testData = new ArrayList<TestPlanTestCaseTestDataComponent>();
                for (TestPlanTestCaseTestDataComponent testPlanTestCaseTestDataComponent : this.testData) {
                    dst.testData.add(testPlanTestCaseTestDataComponent.copy());
                }
            }
            if (this.assertion != null) {
                dst.assertion = new ArrayList<TestPlanTestCaseAssertionComponent>();
                for (TestPlanTestCaseAssertionComponent testPlanTestCaseAssertionComponent : this.assertion) {
                    dst.assertion.add(testPlanTestCaseAssertionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseComponent)) {
                return false;
            }
            TestPlanTestCaseComponent o = (TestPlanTestCaseComponent)other_;
            return TestPlanTestCaseComponent.compareDeep(this.sequence, o.sequence, true) && TestPlanTestCaseComponent.compareDeep(this.scope, o.scope, true) && TestPlanTestCaseComponent.compareDeep(this.dependency, o.dependency, true) && TestPlanTestCaseComponent.compareDeep(this.testRun, o.testRun, true) && TestPlanTestCaseComponent.compareDeep(this.testData, o.testData, true) && TestPlanTestCaseComponent.compareDeep(this.assertion, o.assertion, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanTestCaseComponent)) {
                return false;
            }
            TestPlanTestCaseComponent o = (TestPlanTestCaseComponent)other_;
            return TestPlanTestCaseComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.scope, this.dependency, this.testRun, this.testData, this.assertion});
        }

        @Override
        public String fhirType() {
            return "TestPlan.testCase";
        }
    }

    @Block
    public static class TestPlanDependencyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the dependency criterium", formalDefinition="A textual description of the criterium - what is needed for the dependency to be considered met.")
        protected MarkdownType description;
        @Child(name="predecessor", type={Reference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Link to predecessor test plans", formalDefinition="Predecessor test plans - those that are expected to be successfully performed as a dependency for the execution of this test plan.")
        protected Reference predecessor;
        private static final long serialVersionUID = 1630757943L;

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestPlanDependencyComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestPlanDependencyComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestPlanDependencyComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Reference getPredecessor() {
            if (this.predecessor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestPlanDependencyComponent.predecessor");
                }
                if (Configuration.doAutoCreate()) {
                    this.predecessor = new Reference();
                }
            }
            return this.predecessor;
        }

        public boolean hasPredecessor() {
            return this.predecessor != null && !this.predecessor.isEmpty();
        }

        public TestPlanDependencyComponent setPredecessor(Reference value) {
            this.predecessor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "A textual description of the criterium - what is needed for the dependency to be considered met.", 0, 1, this.description));
            children.add(new Property("predecessor", "Reference", "Predecessor test plans - those that are expected to be successfully performed as a dependency for the execution of this test plan.", 0, 1, this.predecessor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "A textual description of the criterium - what is needed for the dependency to be considered met.", 0, 1, this.description);
                }
                case -1925032183: {
                    return new Property("predecessor", "Reference", "Predecessor test plans - those that are expected to be successfully performed as a dependency for the execution of this test plan.", 0, 1, this.predecessor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1925032183: {
                    Base[] baseArray;
                    if (this.predecessor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.predecessor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -1925032183: {
                    this.predecessor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("predecessor")) {
                this.predecessor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1925032183: {
                    return this.getPredecessor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -1925032183: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type TestPlan.dependency.description");
            }
            if (name.equals("predecessor")) {
                this.predecessor = new Reference();
                return this.predecessor;
            }
            return super.addChild(name);
        }

        @Override
        public TestPlanDependencyComponent copy() {
            TestPlanDependencyComponent dst = new TestPlanDependencyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestPlanDependencyComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.predecessor = this.predecessor == null ? null : this.predecessor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanDependencyComponent)) {
                return false;
            }
            TestPlanDependencyComponent o = (TestPlanDependencyComponent)other_;
            return TestPlanDependencyComponent.compareDeep(this.description, o.description, true) && TestPlanDependencyComponent.compareDeep(this.predecessor, o.predecessor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestPlanDependencyComponent)) {
                return false;
            }
            TestPlanDependencyComponent o = (TestPlanDependencyComponent)other_;
            return TestPlanDependencyComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.predecessor});
        }

        @Override
        public String fhirType() {
            return "TestPlan.dependency";
        }
    }
}

