/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Organization", profile="http://hl7.org/fhir/StructureDefinition/Organization")
public class Organization
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies this organization  across multiple systems", formalDefinition="Identifier for the organization that is used to identify the organization across multiple disparate systems.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether the organization's record is still in active use", formalDefinition="Whether the organization's record is still in active use.")
    protected BooleanType active;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of organization", formalDefinition="The kind(s) of organization that this is.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/organization-type")
    protected List<CodeableConcept> type;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name used for the organization", formalDefinition="A name associated with the organization.")
    protected StringType name;
    @Child(name="alias", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of alternate names that the organization is known as, or was known as in the past", formalDefinition="A list of alternate names that the organization is known as, or was known as in the past.")
    protected List<StringType> alias;
    @Child(name="description", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional details about the Organization that could be displayed as further information to identify the Organization beyond its name", formalDefinition="Description of the organization, which helps provide additional general context on the organization to ensure that the correct organization is selected.")
    protected MarkdownType description;
    @Child(name="contact", type={ExtendedContactDetail.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Official contact details for the Organization", formalDefinition="The contact details of communication devices available relevant to the specific Organization. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.")
    protected List<ExtendedContactDetail> contact;
    @Child(name="partOf", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The organization of which this organization forms a part", formalDefinition="The organization of which this organization forms a part.")
    protected Reference partOf;
    @Child(name="endpoint", type={Endpoint.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to services operated for the organization", formalDefinition="Technical endpoints providing access to services operated for the organization.")
    protected List<Reference> endpoint;
    @Child(name="qualification", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Qualifications, certifications, accreditations, licenses, training, etc. pertaining to the provision of care", formalDefinition="The official certifications, accreditations, training, designations and licenses that authorize and/or otherwise endorse the provision of care by the organization.\r\rFor example, an approval to provide a type of services issued by a certifying body (such as the US Joint Commission) to an organization.")
    protected List<OrganizationQualificationComponent> qualification;
    private static final long serialVersionUID = 1270045104L;
    @SearchParamDefinition(name="active", path="Organization.active", description="Is the Organization record active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="address-city", path="Organization.contact.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-country", path="Organization.contact.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="address-postalcode", path="Organization.contact.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-state", path="Organization.contact.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="address-use", path="Organization.contact.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="address", path="Organization.contact.address", description="A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="endpoint", path="Organization.endpoint", description="Technical endpoints providing access to services operated for the organization", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("Organization:endpoint").toLocked();
    @SearchParamDefinition(name="identifier", path="Organization.identifier | Organization.qualification.identifier", description="Any identifier for the organization (not the accreditation issuer's identifier)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Organization.name | Organization.alias", description="A portion of the organization's name or alias", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="partof", path="Organization.partOf", description="An organization of which this organization forms a part", type="reference", target={Organization.class})
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    public static final Include INCLUDE_PARTOF = new Include("Organization:partof").toLocked();
    @SearchParamDefinition(name="phonetic", path="Organization.name", description="A portion of the organization's name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="type", path="Organization.type", description="A code for the type of organization", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Organization setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Organization addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Organization setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Organization setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public Organization setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Organization addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Organization setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Organization setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<StringType> getAlias() {
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        return this.alias;
    }

    public Organization setAlias(List<StringType> theAlias) {
        this.alias = theAlias;
        return this;
    }

    public boolean hasAlias() {
        if (this.alias == null) {
            return false;
        }
        for (StringType item : this.alias) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAliasElement() {
        StringType t = new StringType();
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return t;
    }

    public Organization addAlias(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.alias == null) {
            this.alias = new ArrayList<StringType>();
        }
        this.alias.add(t);
        return this;
    }

    public boolean hasAlias(String value) {
        if (this.alias == null) {
            return false;
        }
        for (StringType v : this.alias) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Organization setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Organization setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<ExtendedContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        return this.contact;
    }

    public Organization setContact(List<ExtendedContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ExtendedContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExtendedContactDetail addContact() {
        ExtendedContactDetail t = new ExtendedContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public Organization addContact(ExtendedContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ExtendedContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Organization setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public Organization setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public Organization addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    public List<OrganizationQualificationComponent> getQualification() {
        if (this.qualification == null) {
            this.qualification = new ArrayList<OrganizationQualificationComponent>();
        }
        return this.qualification;
    }

    public Organization setQualification(List<OrganizationQualificationComponent> theQualification) {
        this.qualification = theQualification;
        return this;
    }

    public boolean hasQualification() {
        if (this.qualification == null) {
            return false;
        }
        for (OrganizationQualificationComponent item : this.qualification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OrganizationQualificationComponent addQualification() {
        OrganizationQualificationComponent t = new OrganizationQualificationComponent();
        if (this.qualification == null) {
            this.qualification = new ArrayList<OrganizationQualificationComponent>();
        }
        this.qualification.add(t);
        return t;
    }

    public Organization addQualification(OrganizationQualificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.qualification == null) {
            this.qualification = new ArrayList<OrganizationQualificationComponent>();
        }
        this.qualification.add(t);
        return this;
    }

    public OrganizationQualificationComponent getQualificationFirstRep() {
        if (this.getQualification().isEmpty()) {
            this.addQualification();
        }
        return this.getQualification().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the organization across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether the organization's record is still in active use.", 0, 1, this.active));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The kind(s) of organization that this is.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property(SP_NAME, "string", "A name associated with the organization.", 0, 1, this.name));
        children.add(new Property("alias", "string", "A list of alternate names that the organization is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias));
        children.add(new Property("description", "markdown", "Description of the organization, which helps provide additional general context on the organization to ensure that the correct organization is selected.", 0, 1, this.description));
        children.add(new Property("contact", "ExtendedContactDetail", "The contact details of communication devices available relevant to the specific Organization. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("partOf", "Reference(Organization)", "The organization of which this organization forms a part.", 0, 1, this.partOf));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the organization.", 0, Integer.MAX_VALUE, this.endpoint));
        children.add(new Property("qualification", "", "The official certifications, accreditations, training, designations and licenses that authorize and/or otherwise endorse the provision of care by the organization.\r\rFor example, an approval to provide a type of services issued by a certifying body (such as the US Joint Commission) to an organization.", 0, Integer.MAX_VALUE, this.qualification));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the organization across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether the organization's record is still in active use.", 0, 1, this.active);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The kind(s) of organization that this is.", 0, Integer.MAX_VALUE, this.type);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A name associated with the organization.", 0, 1, this.name);
            }
            case 92902992: {
                return new Property("alias", "string", "A list of alternate names that the organization is known as, or was known as in the past.", 0, Integer.MAX_VALUE, this.alias);
            }
            case -1724546052: {
                return new Property("description", "markdown", "Description of the organization, which helps provide additional general context on the organization to ensure that the correct organization is selected.", 0, 1, this.description);
            }
            case 951526432: {
                return new Property("contact", "ExtendedContactDetail", "The contact details of communication devices available relevant to the specific Organization. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Organization)", "The organization of which this organization forms a part.", 0, 1, this.partOf);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the organization.", 0, Integer.MAX_VALUE, this.endpoint);
            }
            case -631333393: {
                return new Property("qualification", "", "The official certifications, accreditations, training, designations and licenses that authorize and/or otherwise endorse the provision of care by the organization.\r\rFor example, an approval to provide a type of services issued by a certifying body (such as the US Joint Commission) to an organization.", 0, Integer.MAX_VALUE, this.qualification);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case 92902992: {
                return this.alias == null ? new Base[]{} : this.alias.toArray(new Base[this.alias.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -995410646: {
                Base[] baseArray;
                if (this.partOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.partOf;
                }
                return baseArray;
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
            case -631333393: {
                return this.qualification == null ? new Base[]{} : this.qualification.toArray(new Base[this.qualification.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 92902992: {
                this.getAlias().add(TypeConvertor.castToString(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToExtendedContactDetail(value));
                return value;
            }
            case -995410646: {
                this.partOf = TypeConvertor.castToReference(value);
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -631333393: {
                this.getQualification().add((OrganizationQualificationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("alias")) {
            this.getAlias().add(TypeConvertor.castToString(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToExtendedContactDetail(value));
        } else if (name.equals("partOf")) {
            this.partOf = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(TypeConvertor.castToReference(value));
        } else if (name.equals("qualification")) {
            this.getQualification().add((OrganizationQualificationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 3575610: {
                return this.addType();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 92902992: {
                return this.addAliasElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -995410646: {
                return this.getPartOf();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
            case -631333393: {
                return this.addQualification();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 92902992: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 951526432: {
                return new String[]{"ExtendedContactDetail"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
            case -631333393: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.active");
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.name");
        }
        if (name.equals("alias")) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.alias");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.description");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        if (name.equals("qualification")) {
            return this.addQualification();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Organization";
    }

    @Override
    public Organization copy() {
        Organization dst = new Organization();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Organization dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        BooleanType booleanType = dst.active = this.active == null ? null : this.active.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.alias != null) {
            dst.alias = new ArrayList<StringType>();
            for (StringType stringType2 : this.alias) {
                dst.alias.add(stringType2.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ExtendedContactDetail>();
            for (ExtendedContactDetail extendedContactDetail : this.contact) {
                dst.contact.add(extendedContactDetail.copy());
            }
        }
        Reference reference = dst.partOf = this.partOf == null ? null : this.partOf.copy();
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference2 : this.endpoint) {
                dst.endpoint.add(reference2.copy());
            }
        }
        if (this.qualification != null) {
            dst.qualification = new ArrayList<OrganizationQualificationComponent>();
            for (OrganizationQualificationComponent organizationQualificationComponent : this.qualification) {
                dst.qualification.add(organizationQualificationComponent.copy());
            }
        }
    }

    protected Organization typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)other_;
        return Organization.compareDeep(this.identifier, o.identifier, true) && Organization.compareDeep(this.active, o.active, true) && Organization.compareDeep(this.type, o.type, true) && Organization.compareDeep(this.name, o.name, true) && Organization.compareDeep(this.alias, o.alias, true) && Organization.compareDeep(this.description, o.description, true) && Organization.compareDeep(this.contact, o.contact, true) && Organization.compareDeep(this.partOf, o.partOf, true) && Organization.compareDeep(this.endpoint, o.endpoint, true) && Organization.compareDeep(this.qualification, o.qualification, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)other_;
        return Organization.compareValues(this.active, o.active, true) && Organization.compareValues(this.name, o.name, true) && Organization.compareValues(this.alias, o.alias, true) && Organization.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.type, this.name, this.alias, this.description, this.contact, this.partOf, this.endpoint, this.qualification});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Organization;
    }

    @Block
    public static class OrganizationQualificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An identifier for this qualification for the organization", formalDefinition="An identifier allocated to this qualification for this organization.")
        protected List<Identifier> identifier;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Coded representation of the qualification", formalDefinition="Coded representation of the qualification.")
        protected CodeableConcept code;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period during which the qualification is valid", formalDefinition="Period during which the qualification is valid.")
        protected Period period;
        @Child(name="issuer", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization that regulates and issues the qualification", formalDefinition="Organization that regulates and issues the qualification.")
        protected Reference issuer;
        private static final long serialVersionUID = 1561812204L;

        public OrganizationQualificationComponent() {
        }

        public OrganizationQualificationComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public OrganizationQualificationComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public OrganizationQualificationComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationQualificationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public OrganizationQualificationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationQualificationComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public OrganizationQualificationComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public Reference getIssuer() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationQualificationComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new Reference();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public OrganizationQualificationComponent setIssuer(Reference value) {
            this.issuer = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Organization.SP_IDENTIFIER, "Identifier", "An identifier allocated to this qualification for this organization.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("code", "CodeableConcept", "Coded representation of the qualification.", 0, 1, this.code));
            children.add(new Property("period", "Period", "Period during which the qualification is valid.", 0, 1, this.period));
            children.add(new Property("issuer", "Reference(Organization)", "Organization that regulates and issues the qualification.", 0, 1, this.issuer));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Organization.SP_IDENTIFIER, "Identifier", "An identifier allocated to this qualification for this organization.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Coded representation of the qualification.", 0, 1, this.code);
                }
                case -991726143: {
                    return new Property("period", "Period", "Period during which the qualification is valid.", 0, 1, this.period);
                }
                case -1179159879: {
                    return new Property("issuer", "Reference(Organization)", "Organization that regulates and issues the qualification.", 0, 1, this.issuer);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.issuer;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case -1179159879: {
                    this.issuer = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Organization.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals("issuer")) {
                this.issuer = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case -1179159879: {
                    return this.getIssuer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -1179159879: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Organization.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("issuer")) {
                this.issuer = new Reference();
                return this.issuer;
            }
            return super.addChild(name);
        }

        @Override
        public OrganizationQualificationComponent copy() {
            OrganizationQualificationComponent dst = new OrganizationQualificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OrganizationQualificationComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
            dst.code = this.code == null ? null : this.code.copy();
            dst.period = this.period == null ? null : this.period.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OrganizationQualificationComponent)) {
                return false;
            }
            OrganizationQualificationComponent o = (OrganizationQualificationComponent)other_;
            return OrganizationQualificationComponent.compareDeep(this.identifier, o.identifier, true) && OrganizationQualificationComponent.compareDeep(this.code, o.code, true) && OrganizationQualificationComponent.compareDeep(this.period, o.period, true) && OrganizationQualificationComponent.compareDeep(this.issuer, o.issuer, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OrganizationQualificationComponent)) {
                return false;
            }
            OrganizationQualificationComponent o = (OrganizationQualificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.code, this.period, this.issuer});
        }

        @Override
        public String fhirType() {
            return "Organization.qualification";
        }
    }
}

