/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Account", profile="http://hl7.org/fhir/StructureDefinition/Account")
public class Account
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Account number", formalDefinition="Unique identifier used to reference the account.  Might or might not be intended for human use (e.g. credit card number).")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error | on-hold | unknown", formalDefinition="Indicates whether the account is presently used/usable or not.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/account-status")
    protected Enumeration<AccountStatus> status;
    @Child(name="billingStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Tracks the lifecycle of the account through the billing process", formalDefinition="The BillingStatus tracks the lifecycle of the account through the billing process. It indicates how transactions are treated when they are allocated to the account.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/account-billing-status")
    protected CodeableConcept billingStatus;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="E.g. patient, expense, depreciation", formalDefinition="Categorizes the account for reporting and searching purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/account-type")
    protected CodeableConcept type;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable label", formalDefinition="Name used for the account when displaying it to humans in reports, etc.")
    protected StringType name;
    @Child(name="subject", type={Patient.class, Device.class, Practitioner.class, PractitionerRole.class, Location.class, HealthcareService.class, Organization.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The entity that caused the expenses", formalDefinition="Identifies the entity which incurs the expenses. While the immediate recipients of services or goods might be entities related to the subject, the expenses were ultimately incurred by the subject of the Account.")
    protected List<Reference> subject;
    @Child(name="servicePeriod", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Transaction window", formalDefinition="The date range of services associated with this account.")
    protected Period servicePeriod;
    @Child(name="coverage", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account", formalDefinition="The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account.")
    protected List<CoverageComponent> coverage;
    @Child(name="owner", type={Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Entity managing the Account", formalDefinition="Indicates the service area, hospital, department, etc. with responsibility for managing the Account.")
    protected Reference owner;
    @Child(name="description", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Explanation of purpose/use", formalDefinition="Provides additional information about what the account tracks and how it is used.")
    protected MarkdownType description;
    @Child(name="guarantor", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The parties ultimately responsible for balancing the Account", formalDefinition="The parties responsible for balancing the account if other payment options fall short.")
    protected List<GuarantorComponent> guarantor;
    @Child(name="diagnosis", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of diagnoses relevant to this account", formalDefinition="When using an account for billing a specific Encounter the set of diagnoses that are relevant for billing are stored here on the account where they are able to be sequenced appropriately prior to processing to produce claim(s).")
    protected List<AccountDiagnosisComponent> diagnosis;
    @Child(name="procedure", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of procedures relevant to this account", formalDefinition="When using an account for billing a specific Encounter the set of procedures that are relevant for billing are stored here on the account where they are able to be sequenced appropriately prior to processing to produce claim(s).")
    protected List<AccountProcedureComponent> procedure;
    @Child(name="relatedAccount", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Other associated accounts related to this account", formalDefinition="Other associated accounts related to this account.")
    protected List<AccountRelatedAccountComponent> relatedAccount;
    @Child(name="currency", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The base or default currency", formalDefinition="The default currency for the account.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/currencies")
    protected CodeableConcept currency;
    @Child(name="balance", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Calculated account balance(s)", formalDefinition="The calculated account balances - these are calculated and processed by the finance system.\r\rThe balances with a `term` that is not current are usually generated/updated by an invoicing or similar process.")
    protected List<AccountBalanceComponent> balance;
    @Child(name="calculatedAt", type={InstantType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time the balance amount was calculated", formalDefinition="Time the balance amount was calculated.")
    protected InstantType calculatedAt;
    private static final long serialVersionUID = -924752626L;
    @SearchParamDefinition(name="guarantor", path="Account.guarantor.party", description="The parties ultimately responsible for balancing the Account", type="reference", target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_GUARANTOR = "guarantor";
    public static final ReferenceClientParam GUARANTOR = new ReferenceClientParam("guarantor");
    public static final Include INCLUDE_GUARANTOR = new Include("Account:guarantor").toLocked();
    @SearchParamDefinition(name="name", path="Account.name", description="Human-readable label", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="owner", path="Account.owner", description="Entity managing the Account", type="reference", target={Organization.class})
    public static final String SP_OWNER = "owner";
    public static final ReferenceClientParam OWNER = new ReferenceClientParam("owner");
    public static final Include INCLUDE_OWNER = new Include("Account:owner").toLocked();
    @SearchParamDefinition(name="period", path="Account.servicePeriod", description="Transaction window", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="relatedaccount", path="Account.relatedAccount.account", description="Parent and other related accounts", type="reference", target={Account.class})
    public static final String SP_RELATEDACCOUNT = "relatedaccount";
    public static final ReferenceClientParam RELATEDACCOUNT = new ReferenceClientParam("relatedaccount");
    public static final Include INCLUDE_RELATEDACCOUNT = new Include("Account:relatedaccount").toLocked();
    @SearchParamDefinition(name="status", path="Account.status", description="active | inactive | entered-in-error | on-hold | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Account.subject", description="The entity that caused the expenses", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Account:subject").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Account:patient").toLocked();
    @SearchParamDefinition(name="type", path="Account.type | AllergyIntolerance.type | Composition.type | Coverage.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type | Invoice.type | MedicationDispense.type | MolecularSequence.type | Specimen.type", description="Multiple Resources: \r\n\r\n* [Account](account.html): E.g. patient, expense, depreciation\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [Coverage](coverage.html): The kind of coverage (health plan, auto, Workers Compensation)\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n* [Invoice](invoice.html): Type of Invoice\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of a specific type\r\n* [MolecularSequence](molecularsequence.html): Amino Acid Sequence/ DNA Sequence / RNA Sequence\r\n* [Specimen](specimen.html): The specimen type\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Account() {
    }

    public Account(AccountStatus status) {
        this.setStatus(status);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Account setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Account addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<AccountStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<AccountStatus>(new AccountStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Account setStatusElement(Enumeration<AccountStatus> value) {
        this.status = value;
        return this;
    }

    public AccountStatus getStatus() {
        return this.status == null ? null : (AccountStatus)((Object)this.status.getValue());
    }

    public Account setStatus(AccountStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<AccountStatus>(new AccountStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getBillingStatus() {
        if (this.billingStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.billingStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.billingStatus = new CodeableConcept();
            }
        }
        return this.billingStatus;
    }

    public boolean hasBillingStatus() {
        return this.billingStatus != null && !this.billingStatus.isEmpty();
    }

    public Account setBillingStatus(CodeableConcept value) {
        this.billingStatus = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Account setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Account setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Account setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public Account setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public Account addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public Period getServicePeriod() {
        if (this.servicePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.servicePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.servicePeriod = new Period();
            }
        }
        return this.servicePeriod;
    }

    public boolean hasServicePeriod() {
        return this.servicePeriod != null && !this.servicePeriod.isEmpty();
    }

    public Account setServicePeriod(Period value) {
        this.servicePeriod = value;
        return this;
    }

    public List<CoverageComponent> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        return this.coverage;
    }

    public Account setCoverage(List<CoverageComponent> theCoverage) {
        this.coverage = theCoverage;
        return this;
    }

    public boolean hasCoverage() {
        if (this.coverage == null) {
            return false;
        }
        for (CoverageComponent item : this.coverage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CoverageComponent addCoverage() {
        CoverageComponent t = new CoverageComponent();
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        this.coverage.add(t);
        return t;
    }

    public Account addCoverage(CoverageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        this.coverage.add(t);
        return this;
    }

    public CoverageComponent getCoverageFirstRep() {
        if (this.getCoverage().isEmpty()) {
            this.addCoverage();
        }
        return this.getCoverage().get(0);
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Account setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Account setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Account setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<GuarantorComponent> getGuarantor() {
        if (this.guarantor == null) {
            this.guarantor = new ArrayList<GuarantorComponent>();
        }
        return this.guarantor;
    }

    public Account setGuarantor(List<GuarantorComponent> theGuarantor) {
        this.guarantor = theGuarantor;
        return this;
    }

    public boolean hasGuarantor() {
        if (this.guarantor == null) {
            return false;
        }
        for (GuarantorComponent item : this.guarantor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GuarantorComponent addGuarantor() {
        GuarantorComponent t = new GuarantorComponent();
        if (this.guarantor == null) {
            this.guarantor = new ArrayList<GuarantorComponent>();
        }
        this.guarantor.add(t);
        return t;
    }

    public Account addGuarantor(GuarantorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.guarantor == null) {
            this.guarantor = new ArrayList<GuarantorComponent>();
        }
        this.guarantor.add(t);
        return this;
    }

    public GuarantorComponent getGuarantorFirstRep() {
        if (this.getGuarantor().isEmpty()) {
            this.addGuarantor();
        }
        return this.getGuarantor().get(0);
    }

    public List<AccountDiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<AccountDiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public Account setDiagnosis(List<AccountDiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (AccountDiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AccountDiagnosisComponent addDiagnosis() {
        AccountDiagnosisComponent t = new AccountDiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<AccountDiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public Account addDiagnosis(AccountDiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<AccountDiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public AccountDiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public List<AccountProcedureComponent> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<AccountProcedureComponent>();
        }
        return this.procedure;
    }

    public Account setProcedure(List<AccountProcedureComponent> theProcedure) {
        this.procedure = theProcedure;
        return this;
    }

    public boolean hasProcedure() {
        if (this.procedure == null) {
            return false;
        }
        for (AccountProcedureComponent item : this.procedure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AccountProcedureComponent addProcedure() {
        AccountProcedureComponent t = new AccountProcedureComponent();
        if (this.procedure == null) {
            this.procedure = new ArrayList<AccountProcedureComponent>();
        }
        this.procedure.add(t);
        return t;
    }

    public Account addProcedure(AccountProcedureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.procedure == null) {
            this.procedure = new ArrayList<AccountProcedureComponent>();
        }
        this.procedure.add(t);
        return this;
    }

    public AccountProcedureComponent getProcedureFirstRep() {
        if (this.getProcedure().isEmpty()) {
            this.addProcedure();
        }
        return this.getProcedure().get(0);
    }

    public List<AccountRelatedAccountComponent> getRelatedAccount() {
        if (this.relatedAccount == null) {
            this.relatedAccount = new ArrayList<AccountRelatedAccountComponent>();
        }
        return this.relatedAccount;
    }

    public Account setRelatedAccount(List<AccountRelatedAccountComponent> theRelatedAccount) {
        this.relatedAccount = theRelatedAccount;
        return this;
    }

    public boolean hasRelatedAccount() {
        if (this.relatedAccount == null) {
            return false;
        }
        for (AccountRelatedAccountComponent item : this.relatedAccount) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AccountRelatedAccountComponent addRelatedAccount() {
        AccountRelatedAccountComponent t = new AccountRelatedAccountComponent();
        if (this.relatedAccount == null) {
            this.relatedAccount = new ArrayList<AccountRelatedAccountComponent>();
        }
        this.relatedAccount.add(t);
        return t;
    }

    public Account addRelatedAccount(AccountRelatedAccountComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedAccount == null) {
            this.relatedAccount = new ArrayList<AccountRelatedAccountComponent>();
        }
        this.relatedAccount.add(t);
        return this;
    }

    public AccountRelatedAccountComponent getRelatedAccountFirstRep() {
        if (this.getRelatedAccount().isEmpty()) {
            this.addRelatedAccount();
        }
        return this.getRelatedAccount().get(0);
    }

    public CodeableConcept getCurrency() {
        if (this.currency == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.currency");
            }
            if (Configuration.doAutoCreate()) {
                this.currency = new CodeableConcept();
            }
        }
        return this.currency;
    }

    public boolean hasCurrency() {
        return this.currency != null && !this.currency.isEmpty();
    }

    public Account setCurrency(CodeableConcept value) {
        this.currency = value;
        return this;
    }

    public List<AccountBalanceComponent> getBalance() {
        if (this.balance == null) {
            this.balance = new ArrayList<AccountBalanceComponent>();
        }
        return this.balance;
    }

    public Account setBalance(List<AccountBalanceComponent> theBalance) {
        this.balance = theBalance;
        return this;
    }

    public boolean hasBalance() {
        if (this.balance == null) {
            return false;
        }
        for (AccountBalanceComponent item : this.balance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AccountBalanceComponent addBalance() {
        AccountBalanceComponent t = new AccountBalanceComponent();
        if (this.balance == null) {
            this.balance = new ArrayList<AccountBalanceComponent>();
        }
        this.balance.add(t);
        return t;
    }

    public Account addBalance(AccountBalanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.balance == null) {
            this.balance = new ArrayList<AccountBalanceComponent>();
        }
        this.balance.add(t);
        return this;
    }

    public AccountBalanceComponent getBalanceFirstRep() {
        if (this.getBalance().isEmpty()) {
            this.addBalance();
        }
        return this.getBalance().get(0);
    }

    public InstantType getCalculatedAtElement() {
        if (this.calculatedAt == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.calculatedAt");
            }
            if (Configuration.doAutoCreate()) {
                this.calculatedAt = new InstantType();
            }
        }
        return this.calculatedAt;
    }

    public boolean hasCalculatedAtElement() {
        return this.calculatedAt != null && !this.calculatedAt.isEmpty();
    }

    public boolean hasCalculatedAt() {
        return this.calculatedAt != null && !this.calculatedAt.isEmpty();
    }

    public Account setCalculatedAtElement(InstantType value) {
        this.calculatedAt = value;
        return this;
    }

    public Date getCalculatedAt() {
        return this.calculatedAt == null ? null : (Date)this.calculatedAt.getValue();
    }

    public Account setCalculatedAt(Date value) {
        if (value == null) {
            this.calculatedAt = null;
        } else {
            if (this.calculatedAt == null) {
                this.calculatedAt = new InstantType();
            }
            this.calculatedAt.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier used to reference the account.  Might or might not be intended for human use (e.g. credit card number).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Indicates whether the account is presently used/usable or not.", 0, 1, this.status));
        children.add(new Property("billingStatus", "CodeableConcept", "The BillingStatus tracks the lifecycle of the account through the billing process. It indicates how transactions are treated when they are allocated to the account.", 0, 1, this.billingStatus));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Categorizes the account for reporting and searching purposes.", 0, 1, this.type));
        children.add(new Property(SP_NAME, "string", "Name used for the account when displaying it to humans in reports, etc.", 0, 1, this.name));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Device|Practitioner|PractitionerRole|Location|HealthcareService|Organization)", "Identifies the entity which incurs the expenses. While the immediate recipients of services or goods might be entities related to the subject, the expenses were ultimately incurred by the subject of the Account.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("servicePeriod", "Period", "The date range of services associated with this account.", 0, 1, this.servicePeriod));
        children.add(new Property("coverage", "", "The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account.", 0, Integer.MAX_VALUE, this.coverage));
        children.add(new Property(SP_OWNER, "Reference(Organization)", "Indicates the service area, hospital, department, etc. with responsibility for managing the Account.", 0, 1, this.owner));
        children.add(new Property("description", "markdown", "Provides additional information about what the account tracks and how it is used.", 0, 1, this.description));
        children.add(new Property(SP_GUARANTOR, "", "The parties responsible for balancing the account if other payment options fall short.", 0, Integer.MAX_VALUE, this.guarantor));
        children.add(new Property("diagnosis", "", "When using an account for billing a specific Encounter the set of diagnoses that are relevant for billing are stored here on the account where they are able to be sequenced appropriately prior to processing to produce claim(s).", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property("procedure", "", "When using an account for billing a specific Encounter the set of procedures that are relevant for billing are stored here on the account where they are able to be sequenced appropriately prior to processing to produce claim(s).", 0, Integer.MAX_VALUE, this.procedure));
        children.add(new Property("relatedAccount", "", "Other associated accounts related to this account.", 0, Integer.MAX_VALUE, this.relatedAccount));
        children.add(new Property("currency", "CodeableConcept", "The default currency for the account.", 0, 1, this.currency));
        children.add(new Property("balance", "", "The calculated account balances - these are calculated and processed by the finance system.\r\rThe balances with a `term` that is not current are usually generated/updated by an invoicing or similar process.", 0, Integer.MAX_VALUE, this.balance));
        children.add(new Property("calculatedAt", "instant", "Time the balance amount was calculated.", 0, 1, this.calculatedAt));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier used to reference the account.  Might or might not be intended for human use (e.g. credit card number).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates whether the account is presently used/usable or not.", 0, 1, this.status);
            }
            case -1524378035: {
                return new Property("billingStatus", "CodeableConcept", "The BillingStatus tracks the lifecycle of the account through the billing process. It indicates how transactions are treated when they are allocated to the account.", 0, 1, this.billingStatus);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Categorizes the account for reporting and searching purposes.", 0, 1, this.type);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "Name used for the account when displaying it to humans in reports, etc.", 0, 1, this.name);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Device|Practitioner|PractitionerRole|Location|HealthcareService|Organization)", "Identifies the entity which incurs the expenses. While the immediate recipients of services or goods might be entities related to the subject, the expenses were ultimately incurred by the subject of the Account.", 0, Integer.MAX_VALUE, this.subject);
            }
            case 2129104086: {
                return new Property("servicePeriod", "Period", "The date range of services associated with this account.", 0, 1, this.servicePeriod);
            }
            case -351767064: {
                return new Property("coverage", "", "The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account.", 0, Integer.MAX_VALUE, this.coverage);
            }
            case 106164915: {
                return new Property(SP_OWNER, "Reference(Organization)", "Indicates the service area, hospital, department, etc. with responsibility for managing the Account.", 0, 1, this.owner);
            }
            case -1724546052: {
                return new Property("description", "markdown", "Provides additional information about what the account tracks and how it is used.", 0, 1, this.description);
            }
            case -188629045: {
                return new Property(SP_GUARANTOR, "", "The parties responsible for balancing the account if other payment options fall short.", 0, Integer.MAX_VALUE, this.guarantor);
            }
            case 1196993265: {
                return new Property("diagnosis", "", "When using an account for billing a specific Encounter the set of diagnoses that are relevant for billing are stored here on the account where they are able to be sequenced appropriately prior to processing to produce claim(s).", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -1095204141: {
                return new Property("procedure", "", "When using an account for billing a specific Encounter the set of procedures that are relevant for billing are stored here on the account where they are able to be sequenced appropriately prior to processing to produce claim(s).", 0, Integer.MAX_VALUE, this.procedure);
            }
            case 962039682: {
                return new Property("relatedAccount", "", "Other associated accounts related to this account.", 0, Integer.MAX_VALUE, this.relatedAccount);
            }
            case 575402001: {
                return new Property("currency", "CodeableConcept", "The default currency for the account.", 0, 1, this.currency);
            }
            case -339185956: {
                return new Property("balance", "", "The calculated account balances - these are calculated and processed by the finance system.\r\rThe balances with a `term` that is not current are usually generated/updated by an invoicing or similar process.", 0, Integer.MAX_VALUE, this.balance);
            }
            case 1089469073: {
                return new Property("calculatedAt", "instant", "Time the balance amount was calculated.", 0, 1, this.calculatedAt);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1524378035: {
                Base[] baseArray;
                if (this.billingStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.billingStatus;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case 2129104086: {
                Base[] baseArray;
                if (this.servicePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.servicePeriod;
                }
                return baseArray;
            }
            case -351767064: {
                return this.coverage == null ? new Base[]{} : this.coverage.toArray(new Base[this.coverage.size()]);
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.owner;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.description;
                }
                return baseArray;
            }
            case -188629045: {
                return this.guarantor == null ? new Base[]{} : this.guarantor.toArray(new Base[this.guarantor.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -1095204141: {
                return this.procedure == null ? new Base[]{} : this.procedure.toArray(new Base[this.procedure.size()]);
            }
            case 962039682: {
                return this.relatedAccount == null ? new Base[]{} : this.relatedAccount.toArray(new Base[this.relatedAccount.size()]);
            }
            case 575402001: {
                Base[] baseArray;
                if (this.currency == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.currency;
                }
                return baseArray;
            }
            case -339185956: {
                return this.balance == null ? new Base[]{} : this.balance.toArray(new Base[this.balance.size()]);
            }
            case 1089469073: {
                Base[] baseArray;
                if (this.calculatedAt == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.calculatedAt;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new AccountStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1524378035: {
                this.billingStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -1867885268: {
                this.getSubject().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 2129104086: {
                this.servicePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -351767064: {
                this.getCoverage().add((CoverageComponent)((Object)value));
                return value;
            }
            case 106164915: {
                this.owner = TypeConvertor.castToReference(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -188629045: {
                this.getGuarantor().add((GuarantorComponent)((Object)value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((AccountDiagnosisComponent)((Object)value));
                return value;
            }
            case -1095204141: {
                this.getProcedure().add((AccountProcedureComponent)((Object)value));
                return value;
            }
            case 962039682: {
                this.getRelatedAccount().add((AccountRelatedAccountComponent)((Object)value));
                return value;
            }
            case 575402001: {
                this.currency = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -339185956: {
                this.getBalance().add((AccountBalanceComponent)((Object)value));
                return value;
            }
            case 1089469073: {
                this.calculatedAt = TypeConvertor.castToInstant(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new AccountStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("billingStatus")) {
            this.billingStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(TypeConvertor.castToReference(value));
        } else if (name.equals("servicePeriod")) {
            this.servicePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("coverage")) {
            this.getCoverage().add((CoverageComponent)((Object)value));
        } else if (name.equals(SP_OWNER)) {
            this.owner = TypeConvertor.castToReference(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals(SP_GUARANTOR)) {
            this.getGuarantor().add((GuarantorComponent)((Object)value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((AccountDiagnosisComponent)((Object)value));
        } else if (name.equals("procedure")) {
            this.getProcedure().add((AccountProcedureComponent)((Object)value));
        } else if (name.equals("relatedAccount")) {
            this.getRelatedAccount().add((AccountRelatedAccountComponent)((Object)value));
        } else if (name.equals("currency")) {
            this.currency = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("balance")) {
            this.getBalance().add((AccountBalanceComponent)((Object)value));
        } else if (name.equals("calculatedAt")) {
            this.calculatedAt = TypeConvertor.castToInstant(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1524378035: {
                return this.getBillingStatus();
            }
            case 3575610: {
                return this.getType();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case 2129104086: {
                return this.getServicePeriod();
            }
            case -351767064: {
                return this.addCoverage();
            }
            case 106164915: {
                return this.getOwner();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -188629045: {
                return this.addGuarantor();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -1095204141: {
                return this.addProcedure();
            }
            case 962039682: {
                return this.addRelatedAccount();
            }
            case 575402001: {
                return this.getCurrency();
            }
            case -339185956: {
                return this.addBalance();
            }
            case 1089469073: {
                return this.getCalculatedAtElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1524378035: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 2129104086: {
                return new String[]{"Period"};
            }
            case -351767064: {
                return new String[0];
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -188629045: {
                return new String[0];
            }
            case 1196993265: {
                return new String[0];
            }
            case -1095204141: {
                return new String[0];
            }
            case 962039682: {
                return new String[0];
            }
            case 575402001: {
                return new String[]{"CodeableConcept"};
            }
            case -339185956: {
                return new String[0];
            }
            case 1089469073: {
                return new String[]{"instant"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Account.status");
        }
        if (name.equals("billingStatus")) {
            this.billingStatus = new CodeableConcept();
            return this.billingStatus;
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Account.name");
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("servicePeriod")) {
            this.servicePeriod = new Period();
            return this.servicePeriod;
        }
        if (name.equals("coverage")) {
            return this.addCoverage();
        }
        if (name.equals(SP_OWNER)) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Account.description");
        }
        if (name.equals(SP_GUARANTOR)) {
            return this.addGuarantor();
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals("procedure")) {
            return this.addProcedure();
        }
        if (name.equals("relatedAccount")) {
            return this.addRelatedAccount();
        }
        if (name.equals("currency")) {
            this.currency = new CodeableConcept();
            return this.currency;
        }
        if (name.equals("balance")) {
            return this.addBalance();
        }
        if (name.equals("calculatedAt")) {
            throw new FHIRException("Cannot call addChild on a primitive type Account.calculatedAt");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Account";
    }

    @Override
    public Account copy() {
        Account dst = new Account();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Account dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.billingStatus = this.billingStatus == null ? null : this.billingStatus.copy();
        dst.type = this.type == null ? null : this.type.copy();
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        Period period = dst.servicePeriod = this.servicePeriod == null ? null : this.servicePeriod.copy();
        if (this.coverage != null) {
            dst.coverage = new ArrayList<CoverageComponent>();
            for (CoverageComponent coverageComponent : this.coverage) {
                dst.coverage.add(coverageComponent.copy());
            }
        }
        dst.owner = this.owner == null ? null : this.owner.copy();
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.guarantor != null) {
            dst.guarantor = new ArrayList<GuarantorComponent>();
            for (GuarantorComponent guarantorComponent : this.guarantor) {
                dst.guarantor.add(guarantorComponent.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<AccountDiagnosisComponent>();
            for (AccountDiagnosisComponent accountDiagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(accountDiagnosisComponent.copy());
            }
        }
        if (this.procedure != null) {
            dst.procedure = new ArrayList<AccountProcedureComponent>();
            for (AccountProcedureComponent accountProcedureComponent : this.procedure) {
                dst.procedure.add(accountProcedureComponent.copy());
            }
        }
        if (this.relatedAccount != null) {
            dst.relatedAccount = new ArrayList<AccountRelatedAccountComponent>();
            for (AccountRelatedAccountComponent accountRelatedAccountComponent : this.relatedAccount) {
                dst.relatedAccount.add(accountRelatedAccountComponent.copy());
            }
        }
        CodeableConcept codeableConcept = dst.currency = this.currency == null ? null : this.currency.copy();
        if (this.balance != null) {
            dst.balance = new ArrayList<AccountBalanceComponent>();
            for (AccountBalanceComponent accountBalanceComponent : this.balance) {
                dst.balance.add(accountBalanceComponent.copy());
            }
        }
        dst.calculatedAt = this.calculatedAt == null ? null : this.calculatedAt.copy();
    }

    protected Account typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Account)) {
            return false;
        }
        Account o = (Account)other_;
        return Account.compareDeep(this.identifier, o.identifier, true) && Account.compareDeep(this.status, o.status, true) && Account.compareDeep(this.billingStatus, o.billingStatus, true) && Account.compareDeep(this.type, o.type, true) && Account.compareDeep(this.name, o.name, true) && Account.compareDeep(this.subject, o.subject, true) && Account.compareDeep(this.servicePeriod, o.servicePeriod, true) && Account.compareDeep(this.coverage, o.coverage, true) && Account.compareDeep(this.owner, o.owner, true) && Account.compareDeep(this.description, o.description, true) && Account.compareDeep(this.guarantor, o.guarantor, true) && Account.compareDeep(this.diagnosis, o.diagnosis, true) && Account.compareDeep(this.procedure, o.procedure, true) && Account.compareDeep(this.relatedAccount, o.relatedAccount, true) && Account.compareDeep(this.currency, o.currency, true) && Account.compareDeep(this.balance, o.balance, true) && Account.compareDeep(this.calculatedAt, o.calculatedAt, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Account)) {
            return false;
        }
        Account o = (Account)other_;
        return Account.compareValues(this.status, o.status, true) && Account.compareValues(this.name, o.name, true) && Account.compareValues(this.description, o.description, true) && Account.compareValues(this.calculatedAt, o.calculatedAt, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.billingStatus, this.type, this.name, this.subject, this.servicePeriod, this.coverage, this.owner, this.description, this.guarantor, this.diagnosis, this.procedure, this.relatedAccount, this.currency, this.balance, this.calculatedAt});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Account;
    }

    @Block
    public static class AccountBalanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="aggregate", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is expected to pay this part of the balance", formalDefinition="Who is expected to pay this part of the balance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/account-aggregate")
        protected CodeableConcept aggregate;
        @Child(name="term", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="current | 30 | 60 | 90 | 120", formalDefinition="The term of the account balances - The balance value is the amount that was outstanding for this age.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/account-balance-term")
        protected CodeableConcept term;
        @Child(name="estimate", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Estimated balance", formalDefinition="The amount is only an estimated value - this is likely common for `current` term balances, but not with known terms (that were generated by a backend process).")
        protected BooleanType estimate;
        @Child(name="amount", type={Money.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Calculated amount", formalDefinition="The actual balance value calculated for the age defined in the term property.")
        protected Money amount;
        private static final long serialVersionUID = -338990145L;

        public AccountBalanceComponent() {
        }

        public AccountBalanceComponent(Money amount) {
            this.setAmount(amount);
        }

        public CodeableConcept getAggregate() {
            if (this.aggregate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountBalanceComponent.aggregate");
                }
                if (Configuration.doAutoCreate()) {
                    this.aggregate = new CodeableConcept();
                }
            }
            return this.aggregate;
        }

        public boolean hasAggregate() {
            return this.aggregate != null && !this.aggregate.isEmpty();
        }

        public AccountBalanceComponent setAggregate(CodeableConcept value) {
            this.aggregate = value;
            return this;
        }

        public CodeableConcept getTerm() {
            if (this.term == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountBalanceComponent.term");
                }
                if (Configuration.doAutoCreate()) {
                    this.term = new CodeableConcept();
                }
            }
            return this.term;
        }

        public boolean hasTerm() {
            return this.term != null && !this.term.isEmpty();
        }

        public AccountBalanceComponent setTerm(CodeableConcept value) {
            this.term = value;
            return this;
        }

        public BooleanType getEstimateElement() {
            if (this.estimate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountBalanceComponent.estimate");
                }
                if (Configuration.doAutoCreate()) {
                    this.estimate = new BooleanType();
                }
            }
            return this.estimate;
        }

        public boolean hasEstimateElement() {
            return this.estimate != null && !this.estimate.isEmpty();
        }

        public boolean hasEstimate() {
            return this.estimate != null && !this.estimate.isEmpty();
        }

        public AccountBalanceComponent setEstimateElement(BooleanType value) {
            this.estimate = value;
            return this;
        }

        public boolean getEstimate() {
            return this.estimate == null || this.estimate.isEmpty() ? false : (Boolean)this.estimate.getValue();
        }

        public AccountBalanceComponent setEstimate(boolean value) {
            if (this.estimate == null) {
                this.estimate = new BooleanType();
            }
            this.estimate.setValue((Object)value);
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountBalanceComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AccountBalanceComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("aggregate", "CodeableConcept", "Who is expected to pay this part of the balance.", 0, 1, this.aggregate));
            children.add(new Property("term", "CodeableConcept", "The term of the account balances - The balance value is the amount that was outstanding for this age.", 0, 1, this.term));
            children.add(new Property("estimate", "boolean", "The amount is only an estimated value - this is likely common for `current` term balances, but not with known terms (that were generated by a backend process).", 0, 1, this.estimate));
            children.add(new Property("amount", "Money", "The actual balance value calculated for the age defined in the term property.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 175177151: {
                    return new Property("aggregate", "CodeableConcept", "Who is expected to pay this part of the balance.", 0, 1, this.aggregate);
                }
                case 3556460: {
                    return new Property("term", "CodeableConcept", "The term of the account balances - The balance value is the amount that was outstanding for this age.", 0, 1, this.term);
                }
                case -1959779032: {
                    return new Property("estimate", "boolean", "The amount is only an estimated value - this is likely common for `current` term balances, but not with known terms (that were generated by a backend process).", 0, 1, this.estimate);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "The actual balance value calculated for the age defined in the term property.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 175177151: {
                    Base[] baseArray;
                    if (this.aggregate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.aggregate;
                    }
                    return baseArray;
                }
                case 3556460: {
                    Base[] baseArray;
                    if (this.term == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.term;
                    }
                    return baseArray;
                }
                case -1959779032: {
                    Base[] baseArray;
                    if (this.estimate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.estimate;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 175177151: {
                    this.aggregate = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556460: {
                    this.term = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1959779032: {
                    this.estimate = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("aggregate")) {
                this.aggregate = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("term")) {
                this.term = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("estimate")) {
                this.estimate = TypeConvertor.castToBoolean(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 175177151: {
                    return this.getAggregate();
                }
                case 3556460: {
                    return this.getTerm();
                }
                case -1959779032: {
                    return this.getEstimateElement();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 175177151: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556460: {
                    return new String[]{"CodeableConcept"};
                }
                case -1959779032: {
                    return new String[]{"boolean"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("aggregate")) {
                this.aggregate = new CodeableConcept();
                return this.aggregate;
            }
            if (name.equals("term")) {
                this.term = new CodeableConcept();
                return this.term;
            }
            if (name.equals("estimate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.balance.estimate");
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public AccountBalanceComponent copy() {
            AccountBalanceComponent dst = new AccountBalanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AccountBalanceComponent dst) {
            super.copyValues(dst);
            dst.aggregate = this.aggregate == null ? null : this.aggregate.copy();
            dst.term = this.term == null ? null : this.term.copy();
            dst.estimate = this.estimate == null ? null : this.estimate.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AccountBalanceComponent)) {
                return false;
            }
            AccountBalanceComponent o = (AccountBalanceComponent)other_;
            return AccountBalanceComponent.compareDeep(this.aggregate, o.aggregate, true) && AccountBalanceComponent.compareDeep(this.term, o.term, true) && AccountBalanceComponent.compareDeep(this.estimate, o.estimate, true) && AccountBalanceComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AccountBalanceComponent)) {
                return false;
            }
            AccountBalanceComponent o = (AccountBalanceComponent)other_;
            return AccountBalanceComponent.compareValues(this.estimate, o.estimate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.aggregate, this.term, this.estimate, this.amount});
        }

        @Override
        public String fhirType() {
            return "Account.balance";
        }
    }

    @Block
    public static class AccountRelatedAccountComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationship", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Relationship of the associated Account", formalDefinition="Relationship of the associated Account.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/account-relationship")
        protected CodeableConcept relationship;
        @Child(name="account", type={Account.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to an associated Account", formalDefinition="Reference to an associated Account.")
        protected Reference account;
        private static final long serialVersionUID = 1586291361L;

        public AccountRelatedAccountComponent() {
        }

        public AccountRelatedAccountComponent(Reference account) {
            this.setAccount(account);
        }

        public CodeableConcept getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountRelatedAccountComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new CodeableConcept();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public AccountRelatedAccountComponent setRelationship(CodeableConcept value) {
            this.relationship = value;
            return this;
        }

        public Reference getAccount() {
            if (this.account == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountRelatedAccountComponent.account");
                }
                if (Configuration.doAutoCreate()) {
                    this.account = new Reference();
                }
            }
            return this.account;
        }

        public boolean hasAccount() {
            return this.account != null && !this.account.isEmpty();
        }

        public AccountRelatedAccountComponent setAccount(Reference value) {
            this.account = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relationship", "CodeableConcept", "Relationship of the associated Account.", 0, 1, this.relationship));
            children.add(new Property("account", "Reference(Account)", "Reference to an associated Account.", 0, 1, this.account));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -261851592: {
                    return new Property("relationship", "CodeableConcept", "Relationship of the associated Account.", 0, 1, this.relationship);
                }
                case -1177318867: {
                    return new Property("account", "Reference(Account)", "Reference to an associated Account.", 0, 1, this.account);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1177318867: {
                    Base[] baseArray;
                    if (this.account == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.account;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    this.relationship = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1177318867: {
                    this.account = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationship")) {
                this.relationship = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("account")) {
                this.account = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    return this.getRelationship();
                }
                case -1177318867: {
                    return this.getAccount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    return new String[]{"CodeableConcept"};
                }
                case -1177318867: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationship")) {
                this.relationship = new CodeableConcept();
                return this.relationship;
            }
            if (name.equals("account")) {
                this.account = new Reference();
                return this.account;
            }
            return super.addChild(name);
        }

        @Override
        public AccountRelatedAccountComponent copy() {
            AccountRelatedAccountComponent dst = new AccountRelatedAccountComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AccountRelatedAccountComponent dst) {
            super.copyValues(dst);
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.account = this.account == null ? null : this.account.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AccountRelatedAccountComponent)) {
                return false;
            }
            AccountRelatedAccountComponent o = (AccountRelatedAccountComponent)other_;
            return AccountRelatedAccountComponent.compareDeep(this.relationship, o.relationship, true) && AccountRelatedAccountComponent.compareDeep(this.account, o.account, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AccountRelatedAccountComponent)) {
                return false;
            }
            AccountRelatedAccountComponent o = (AccountRelatedAccountComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.relationship, this.account});
        }

        @Override
        public String fhirType() {
            return "Account.relatedAccount";
        }
    }

    @Block
    public static class AccountProcedureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Ranking of the procedure (for each type)", formalDefinition="Ranking of the procedure (for each type).")
        protected PositiveIntType sequence;
        @Child(name="code", type={CodeableReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The procedure relevant to the account", formalDefinition="The procedure relevant to the account.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
        protected CodeableReference code;
        @Child(name="dateOfService", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date of the procedure (when coded procedure)", formalDefinition="Date of the procedure when using a coded procedure. If using a reference to a procedure, then the date on the procedure should be used.")
        protected DateTimeType dateOfService;
        @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="How this procedure value should be used in charging the account", formalDefinition="How this procedure value should be used in charging the account.")
        protected List<CodeableConcept> type;
        @Child(name="packageCode", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Package Code specific for billing", formalDefinition="The package code can be used to group procedures that may be priced or delivered as a single product. Such as DRGs.")
        protected List<CodeableConcept> packageCode;
        @Child(name="device", type={Device.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Any devices that were associated with the procedure", formalDefinition="Any devices that were associated with the procedure relevant to the account.")
        protected List<Reference> device;
        private static final long serialVersionUID = -797201673L;

        public AccountProcedureComponent() {
        }

        public AccountProcedureComponent(CodeableReference code) {
            this.setCode(code);
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountProcedureComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public AccountProcedureComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public AccountProcedureComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableReference getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountProcedureComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableReference();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public AccountProcedureComponent setCode(CodeableReference value) {
            this.code = value;
            return this;
        }

        public DateTimeType getDateOfServiceElement() {
            if (this.dateOfService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountProcedureComponent.dateOfService");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateOfService = new DateTimeType();
                }
            }
            return this.dateOfService;
        }

        public boolean hasDateOfServiceElement() {
            return this.dateOfService != null && !this.dateOfService.isEmpty();
        }

        public boolean hasDateOfService() {
            return this.dateOfService != null && !this.dateOfService.isEmpty();
        }

        public AccountProcedureComponent setDateOfServiceElement(DateTimeType value) {
            this.dateOfService = value;
            return this;
        }

        public Date getDateOfService() {
            return this.dateOfService == null ? null : (Date)this.dateOfService.getValue();
        }

        public AccountProcedureComponent setDateOfService(Date value) {
            if (value == null) {
                this.dateOfService = null;
            } else {
                if (this.dateOfService == null) {
                    this.dateOfService = new DateTimeType();
                }
                this.dateOfService.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public AccountProcedureComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public AccountProcedureComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public List<CodeableConcept> getPackageCode() {
            if (this.packageCode == null) {
                this.packageCode = new ArrayList<CodeableConcept>();
            }
            return this.packageCode;
        }

        public AccountProcedureComponent setPackageCode(List<CodeableConcept> thePackageCode) {
            this.packageCode = thePackageCode;
            return this;
        }

        public boolean hasPackageCode() {
            if (this.packageCode == null) {
                return false;
            }
            for (CodeableConcept item : this.packageCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPackageCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.packageCode == null) {
                this.packageCode = new ArrayList<CodeableConcept>();
            }
            this.packageCode.add(t);
            return t;
        }

        public AccountProcedureComponent addPackageCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.packageCode == null) {
                this.packageCode = new ArrayList<CodeableConcept>();
            }
            this.packageCode.add(t);
            return this;
        }

        public CodeableConcept getPackageCodeFirstRep() {
            if (this.getPackageCode().isEmpty()) {
                this.addPackageCode();
            }
            return this.getPackageCode().get(0);
        }

        public List<Reference> getDevice() {
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            return this.device;
        }

        public AccountProcedureComponent setDevice(List<Reference> theDevice) {
            this.device = theDevice;
            return this;
        }

        public boolean hasDevice() {
            if (this.device == null) {
                return false;
            }
            for (Reference item : this.device) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDevice() {
            Reference t = new Reference();
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            this.device.add(t);
            return t;
        }

        public AccountProcedureComponent addDevice(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            this.device.add(t);
            return this;
        }

        public Reference getDeviceFirstRep() {
            if (this.getDevice().isEmpty()) {
                this.addDevice();
            }
            return this.getDevice().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Ranking of the procedure (for each type).", 0, 1, this.sequence));
            children.add(new Property("code", "CodeableReference(Procedure)", "The procedure relevant to the account.", 0, 1, this.code));
            children.add(new Property("dateOfService", "dateTime", "Date of the procedure when using a coded procedure. If using a reference to a procedure, then the date on the procedure should be used.", 0, 1, this.dateOfService));
            children.add(new Property(Account.SP_TYPE, "CodeableConcept", "How this procedure value should be used in charging the account.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("packageCode", "CodeableConcept", "The package code can be used to group procedures that may be priced or delivered as a single product. Such as DRGs.", 0, Integer.MAX_VALUE, this.packageCode));
            children.add(new Property("device", "Reference(Device)", "Any devices that were associated with the procedure relevant to the account.", 0, Integer.MAX_VALUE, this.device));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Ranking of the procedure (for each type).", 0, 1, this.sequence);
                }
                case 3059181: {
                    return new Property("code", "CodeableReference(Procedure)", "The procedure relevant to the account.", 0, 1, this.code);
                }
                case -328510256: {
                    return new Property("dateOfService", "dateTime", "Date of the procedure when using a coded procedure. If using a reference to a procedure, then the date on the procedure should be used.", 0, 1, this.dateOfService);
                }
                case 3575610: {
                    return new Property(Account.SP_TYPE, "CodeableConcept", "How this procedure value should be used in charging the account.", 0, Integer.MAX_VALUE, this.type);
                }
                case 908444499: {
                    return new Property("packageCode", "CodeableConcept", "The package code can be used to group procedures that may be priced or delivered as a single product. Such as DRGs.", 0, Integer.MAX_VALUE, this.packageCode);
                }
                case -1335157162: {
                    return new Property("device", "Reference(Device)", "Any devices that were associated with the procedure relevant to the account.", 0, Integer.MAX_VALUE, this.device);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case -328510256: {
                    Base[] baseArray;
                    if (this.dateOfService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dateOfService;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case 908444499: {
                    return this.packageCode == null ? new Base[]{} : this.packageCode.toArray(new Base[this.packageCode.size()]);
                }
                case -1335157162: {
                    return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -328510256: {
                    this.dateOfService = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 908444499: {
                    this.getPackageCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1335157162: {
                    this.getDevice().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("dateOfService")) {
                this.dateOfService = TypeConvertor.castToDateTime(value);
            } else if (name.equals(Account.SP_TYPE)) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("packageCode")) {
                this.getPackageCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("device")) {
                this.getDevice().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -328510256: {
                    return this.getDateOfServiceElement();
                }
                case 3575610: {
                    return this.addType();
                }
                case 908444499: {
                    return this.addPackageCode();
                }
                case -1335157162: {
                    return this.addDevice();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 3059181: {
                    return new String[]{"CodeableReference"};
                }
                case -328510256: {
                    return new String[]{"dateTime"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 908444499: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335157162: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.procedure.sequence");
            }
            if (name.equals("code")) {
                this.code = new CodeableReference();
                return this.code;
            }
            if (name.equals("dateOfService")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.procedure.dateOfService");
            }
            if (name.equals(Account.SP_TYPE)) {
                return this.addType();
            }
            if (name.equals("packageCode")) {
                return this.addPackageCode();
            }
            if (name.equals("device")) {
                return this.addDevice();
            }
            return super.addChild(name);
        }

        @Override
        public AccountProcedureComponent copy() {
            AccountProcedureComponent dst = new AccountProcedureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AccountProcedureComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.code = this.code == null ? null : this.code.copy();
            DateTimeType dateTimeType = dst.dateOfService = this.dateOfService == null ? null : this.dateOfService.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.type) {
                    dst.type.add(codeableConcept.copy());
                }
            }
            if (this.packageCode != null) {
                dst.packageCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.packageCode) {
                    dst.packageCode.add(codeableConcept.copy());
                }
            }
            if (this.device != null) {
                dst.device = new ArrayList<Reference>();
                for (Reference reference : this.device) {
                    dst.device.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AccountProcedureComponent)) {
                return false;
            }
            AccountProcedureComponent o = (AccountProcedureComponent)other_;
            return AccountProcedureComponent.compareDeep(this.sequence, o.sequence, true) && AccountProcedureComponent.compareDeep(this.code, o.code, true) && AccountProcedureComponent.compareDeep(this.dateOfService, o.dateOfService, true) && AccountProcedureComponent.compareDeep(this.type, o.type, true) && AccountProcedureComponent.compareDeep(this.packageCode, o.packageCode, true) && AccountProcedureComponent.compareDeep(this.device, o.device, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AccountProcedureComponent)) {
                return false;
            }
            AccountProcedureComponent o = (AccountProcedureComponent)other_;
            return AccountProcedureComponent.compareValues(this.sequence, o.sequence, true) && AccountProcedureComponent.compareValues(this.dateOfService, o.dateOfService, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.code, this.dateOfService, this.type, this.packageCode, this.device});
        }

        @Override
        public String fhirType() {
            return "Account.procedure";
        }
    }

    @Block
    public static class AccountDiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Ranking of the diagnosis (for each type)", formalDefinition="Ranking of the diagnosis (for each type).")
        protected PositiveIntType sequence;
        @Child(name="condition", type={CodeableReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The diagnosis relevant to the account", formalDefinition="The diagnosis relevant to the account.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected CodeableReference condition;
        @Child(name="dateOfDiagnosis", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date of the diagnosis (when coded diagnosis)", formalDefinition="Ranking of the diagnosis (for each type).")
        protected DateTimeType dateOfDiagnosis;
        @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Type that this diagnosis has relevant to the account (e.g. admission, billing, discharge \u2026)", formalDefinition="Type that this diagnosis has relevant to the account (e.g. admission, billing, discharge \u2026).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-diagnosis-use")
        protected List<CodeableConcept> type;
        @Child(name="onAdmission", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Diagnosis present on Admission", formalDefinition="Was the Diagnosis present on Admission in the related Encounter.")
        protected BooleanType onAdmission;
        @Child(name="packageCode", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Package Code specific for billing", formalDefinition="The package code can be used to group diagnoses that may be priced or delivered as a single product. Such as DRGs.")
        protected List<CodeableConcept> packageCode;
        private static final long serialVersionUID = 57125500L;

        public AccountDiagnosisComponent() {
        }

        public AccountDiagnosisComponent(CodeableReference condition) {
            this.setCondition(condition);
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountDiagnosisComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public AccountDiagnosisComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public AccountDiagnosisComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableReference getCondition() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountDiagnosisComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new CodeableReference();
                }
            }
            return this.condition;
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public AccountDiagnosisComponent setCondition(CodeableReference value) {
            this.condition = value;
            return this;
        }

        public DateTimeType getDateOfDiagnosisElement() {
            if (this.dateOfDiagnosis == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountDiagnosisComponent.dateOfDiagnosis");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateOfDiagnosis = new DateTimeType();
                }
            }
            return this.dateOfDiagnosis;
        }

        public boolean hasDateOfDiagnosisElement() {
            return this.dateOfDiagnosis != null && !this.dateOfDiagnosis.isEmpty();
        }

        public boolean hasDateOfDiagnosis() {
            return this.dateOfDiagnosis != null && !this.dateOfDiagnosis.isEmpty();
        }

        public AccountDiagnosisComponent setDateOfDiagnosisElement(DateTimeType value) {
            this.dateOfDiagnosis = value;
            return this;
        }

        public Date getDateOfDiagnosis() {
            return this.dateOfDiagnosis == null ? null : (Date)this.dateOfDiagnosis.getValue();
        }

        public AccountDiagnosisComponent setDateOfDiagnosis(Date value) {
            if (value == null) {
                this.dateOfDiagnosis = null;
            } else {
                if (this.dateOfDiagnosis == null) {
                    this.dateOfDiagnosis = new DateTimeType();
                }
                this.dateOfDiagnosis.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public AccountDiagnosisComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public AccountDiagnosisComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public BooleanType getOnAdmissionElement() {
            if (this.onAdmission == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccountDiagnosisComponent.onAdmission");
                }
                if (Configuration.doAutoCreate()) {
                    this.onAdmission = new BooleanType();
                }
            }
            return this.onAdmission;
        }

        public boolean hasOnAdmissionElement() {
            return this.onAdmission != null && !this.onAdmission.isEmpty();
        }

        public boolean hasOnAdmission() {
            return this.onAdmission != null && !this.onAdmission.isEmpty();
        }

        public AccountDiagnosisComponent setOnAdmissionElement(BooleanType value) {
            this.onAdmission = value;
            return this;
        }

        public boolean getOnAdmission() {
            return this.onAdmission == null || this.onAdmission.isEmpty() ? false : (Boolean)this.onAdmission.getValue();
        }

        public AccountDiagnosisComponent setOnAdmission(boolean value) {
            if (this.onAdmission == null) {
                this.onAdmission = new BooleanType();
            }
            this.onAdmission.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getPackageCode() {
            if (this.packageCode == null) {
                this.packageCode = new ArrayList<CodeableConcept>();
            }
            return this.packageCode;
        }

        public AccountDiagnosisComponent setPackageCode(List<CodeableConcept> thePackageCode) {
            this.packageCode = thePackageCode;
            return this;
        }

        public boolean hasPackageCode() {
            if (this.packageCode == null) {
                return false;
            }
            for (CodeableConcept item : this.packageCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPackageCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.packageCode == null) {
                this.packageCode = new ArrayList<CodeableConcept>();
            }
            this.packageCode.add(t);
            return t;
        }

        public AccountDiagnosisComponent addPackageCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.packageCode == null) {
                this.packageCode = new ArrayList<CodeableConcept>();
            }
            this.packageCode.add(t);
            return this;
        }

        public CodeableConcept getPackageCodeFirstRep() {
            if (this.getPackageCode().isEmpty()) {
                this.addPackageCode();
            }
            return this.getPackageCode().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Ranking of the diagnosis (for each type).", 0, 1, this.sequence));
            children.add(new Property("condition", "CodeableReference(Condition)", "The diagnosis relevant to the account.", 0, 1, this.condition));
            children.add(new Property("dateOfDiagnosis", "dateTime", "Ranking of the diagnosis (for each type).", 0, 1, this.dateOfDiagnosis));
            children.add(new Property(Account.SP_TYPE, "CodeableConcept", "Type that this diagnosis has relevant to the account (e.g. admission, billing, discharge \u2026).", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("onAdmission", "boolean", "Was the Diagnosis present on Admission in the related Encounter.", 0, 1, this.onAdmission));
            children.add(new Property("packageCode", "CodeableConcept", "The package code can be used to group diagnoses that may be priced or delivered as a single product. Such as DRGs.", 0, Integer.MAX_VALUE, this.packageCode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Ranking of the diagnosis (for each type).", 0, 1, this.sequence);
                }
                case -861311717: {
                    return new Property("condition", "CodeableReference(Condition)", "The diagnosis relevant to the account.", 0, 1, this.condition);
                }
                case -774562228: {
                    return new Property("dateOfDiagnosis", "dateTime", "Ranking of the diagnosis (for each type).", 0, 1, this.dateOfDiagnosis);
                }
                case 3575610: {
                    return new Property(Account.SP_TYPE, "CodeableConcept", "Type that this diagnosis has relevant to the account (e.g. admission, billing, discharge \u2026).", 0, Integer.MAX_VALUE, this.type);
                }
                case -3386134: {
                    return new Property("onAdmission", "boolean", "Was the Diagnosis present on Admission in the related Encounter.", 0, 1, this.onAdmission);
                }
                case 908444499: {
                    return new Property("packageCode", "CodeableConcept", "The package code can be used to group diagnoses that may be priced or delivered as a single product. Such as DRGs.", 0, Integer.MAX_VALUE, this.packageCode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.condition;
                    }
                    return baseArray;
                }
                case -774562228: {
                    Base[] baseArray;
                    if (this.dateOfDiagnosis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dateOfDiagnosis;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -3386134: {
                    Base[] baseArray;
                    if (this.onAdmission == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.onAdmission;
                    }
                    return baseArray;
                }
                case 908444499: {
                    return this.packageCode == null ? new Base[]{} : this.packageCode.toArray(new Base[this.packageCode.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case -861311717: {
                    this.condition = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -774562228: {
                    this.dateOfDiagnosis = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -3386134: {
                    this.onAdmission = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 908444499: {
                    this.getPackageCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("condition")) {
                this.condition = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("dateOfDiagnosis")) {
                this.dateOfDiagnosis = TypeConvertor.castToDateTime(value);
            } else if (name.equals(Account.SP_TYPE)) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("onAdmission")) {
                this.onAdmission = TypeConvertor.castToBoolean(value);
            } else if (name.equals("packageCode")) {
                this.getPackageCode().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -861311717: {
                    return this.getCondition();
                }
                case -774562228: {
                    return this.getDateOfDiagnosisElement();
                }
                case 3575610: {
                    return this.addType();
                }
                case -3386134: {
                    return this.getOnAdmissionElement();
                }
                case 908444499: {
                    return this.addPackageCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case -861311717: {
                    return new String[]{"CodeableReference"};
                }
                case -774562228: {
                    return new String[]{"dateTime"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -3386134: {
                    return new String[]{"boolean"};
                }
                case 908444499: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.diagnosis.sequence");
            }
            if (name.equals("condition")) {
                this.condition = new CodeableReference();
                return this.condition;
            }
            if (name.equals("dateOfDiagnosis")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.diagnosis.dateOfDiagnosis");
            }
            if (name.equals(Account.SP_TYPE)) {
                return this.addType();
            }
            if (name.equals("onAdmission")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.diagnosis.onAdmission");
            }
            if (name.equals("packageCode")) {
                return this.addPackageCode();
            }
            return super.addChild(name);
        }

        @Override
        public AccountDiagnosisComponent copy() {
            AccountDiagnosisComponent dst = new AccountDiagnosisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AccountDiagnosisComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.condition = this.condition == null ? null : this.condition.copy();
            DateTimeType dateTimeType = dst.dateOfDiagnosis = this.dateOfDiagnosis == null ? null : this.dateOfDiagnosis.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            BooleanType booleanType = dst.onAdmission = this.onAdmission == null ? null : this.onAdmission.copy();
            if (this.packageCode != null) {
                dst.packageCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.packageCode) {
                    dst.packageCode.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AccountDiagnosisComponent)) {
                return false;
            }
            AccountDiagnosisComponent o = (AccountDiagnosisComponent)other_;
            return AccountDiagnosisComponent.compareDeep(this.sequence, o.sequence, true) && AccountDiagnosisComponent.compareDeep(this.condition, o.condition, true) && AccountDiagnosisComponent.compareDeep(this.dateOfDiagnosis, o.dateOfDiagnosis, true) && AccountDiagnosisComponent.compareDeep(this.type, o.type, true) && AccountDiagnosisComponent.compareDeep(this.onAdmission, o.onAdmission, true) && AccountDiagnosisComponent.compareDeep(this.packageCode, o.packageCode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AccountDiagnosisComponent)) {
                return false;
            }
            AccountDiagnosisComponent o = (AccountDiagnosisComponent)other_;
            return AccountDiagnosisComponent.compareValues(this.sequence, o.sequence, true) && AccountDiagnosisComponent.compareValues(this.dateOfDiagnosis, o.dateOfDiagnosis, true) && AccountDiagnosisComponent.compareValues(this.onAdmission, o.onAdmission, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.condition, this.dateOfDiagnosis, this.type, this.onAdmission, this.packageCode});
        }

        @Override
        public String fhirType() {
            return "Account.diagnosis";
        }
    }

    @Block
    public static class GuarantorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="party", type={Patient.class, RelatedPerson.class, Organization.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Responsible entity", formalDefinition="The entity who is responsible.")
        protected Reference party;
        @Child(name="onHold", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Credit or other hold applied", formalDefinition="A guarantor may be placed on credit hold or otherwise have their role temporarily suspended.")
        protected BooleanType onHold;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Guarantee account during", formalDefinition="The timeframe during which the guarantor accepts responsibility for the account.")
        protected Period period;
        private static final long serialVersionUID = -523056773L;

        public GuarantorComponent() {
        }

        public GuarantorComponent(Reference party) {
            this.setParty(party);
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuarantorComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public GuarantorComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public BooleanType getOnHoldElement() {
            if (this.onHold == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuarantorComponent.onHold");
                }
                if (Configuration.doAutoCreate()) {
                    this.onHold = new BooleanType();
                }
            }
            return this.onHold;
        }

        public boolean hasOnHoldElement() {
            return this.onHold != null && !this.onHold.isEmpty();
        }

        public boolean hasOnHold() {
            return this.onHold != null && !this.onHold.isEmpty();
        }

        public GuarantorComponent setOnHoldElement(BooleanType value) {
            this.onHold = value;
            return this;
        }

        public boolean getOnHold() {
            return this.onHold == null || this.onHold.isEmpty() ? false : (Boolean)this.onHold.getValue();
        }

        public GuarantorComponent setOnHold(boolean value) {
            if (this.onHold == null) {
                this.onHold = new BooleanType();
            }
            this.onHold.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GuarantorComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public GuarantorComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("party", "Reference(Patient|RelatedPerson|Organization)", "The entity who is responsible.", 0, 1, this.party));
            children.add(new Property("onHold", "boolean", "A guarantor may be placed on credit hold or otherwise have their role temporarily suspended.", 0, 1, this.onHold));
            children.add(new Property(Account.SP_PERIOD, "Period", "The timeframe during which the guarantor accepts responsibility for the account.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 106437350: {
                    return new Property("party", "Reference(Patient|RelatedPerson|Organization)", "The entity who is responsible.", 0, 1, this.party);
                }
                case -1013289154: {
                    return new Property("onHold", "boolean", "A guarantor may be placed on credit hold or otherwise have their role temporarily suspended.", 0, 1, this.onHold);
                }
                case -991726143: {
                    return new Property(Account.SP_PERIOD, "Period", "The timeframe during which the guarantor accepts responsibility for the account.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.party;
                    }
                    return baseArray;
                }
                case -1013289154: {
                    Base[] baseArray;
                    if (this.onHold == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onHold;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    this.party = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1013289154: {
                    this.onHold = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("party")) {
                this.party = TypeConvertor.castToReference(value);
            } else if (name.equals("onHold")) {
                this.onHold = TypeConvertor.castToBoolean(value);
            } else if (name.equals(Account.SP_PERIOD)) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    return this.getParty();
                }
                case -1013289154: {
                    return this.getOnHoldElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106437350: {
                    return new String[]{"Reference"};
                }
                case -1013289154: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            if (name.equals("onHold")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.guarantor.onHold");
            }
            if (name.equals(Account.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public GuarantorComponent copy() {
            GuarantorComponent dst = new GuarantorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GuarantorComponent dst) {
            super.copyValues(dst);
            dst.party = this.party == null ? null : this.party.copy();
            dst.onHold = this.onHold == null ? null : this.onHold.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GuarantorComponent)) {
                return false;
            }
            GuarantorComponent o = (GuarantorComponent)other_;
            return GuarantorComponent.compareDeep(this.party, o.party, true) && GuarantorComponent.compareDeep(this.onHold, o.onHold, true) && GuarantorComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GuarantorComponent)) {
                return false;
            }
            GuarantorComponent o = (GuarantorComponent)other_;
            return GuarantorComponent.compareValues(this.onHold, o.onHold, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.party, this.onHold, this.period});
        }

        @Override
        public String fhirType() {
            return "Account.guarantor";
        }
    }

    @Block
    public static class CoverageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="coverage", type={Coverage.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The party(s), such as insurances, that may contribute to the payment of this account", formalDefinition="The party(s) that contribute to payment (or part of) of the charges applied to this account (including self-pay).\n\nA coverage may only be responsible for specific types of charges, and the sequence of the coverages in the account could be important when processing billing.")
        protected Reference coverage;
        @Child(name="priority", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The priority of the coverage in the context of this account", formalDefinition="The priority of the coverage in the context of this account.")
        protected PositiveIntType priority;
        private static final long serialVersionUID = 1695665065L;

        public CoverageComponent() {
        }

        public CoverageComponent(Reference coverage) {
            this.setCoverage(coverage);
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public CoverageComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public PositiveIntType getPriorityElement() {
            if (this.priority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.priority");
                }
                if (Configuration.doAutoCreate()) {
                    this.priority = new PositiveIntType();
                }
            }
            return this.priority;
        }

        public boolean hasPriorityElement() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public boolean hasPriority() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public CoverageComponent setPriorityElement(PositiveIntType value) {
            this.priority = value;
            return this;
        }

        public int getPriority() {
            return this.priority == null || this.priority.isEmpty() ? 0 : (Integer)this.priority.getValue();
        }

        public CoverageComponent setPriority(int value) {
            if (this.priority == null) {
                this.priority = new PositiveIntType();
            }
            this.priority.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("coverage", "Reference(Coverage)", "The party(s) that contribute to payment (or part of) of the charges applied to this account (including self-pay).\n\nA coverage may only be responsible for specific types of charges, and the sequence of the coverages in the account could be important when processing billing.", 0, 1, this.coverage));
            children.add(new Property("priority", "positiveInt", "The priority of the coverage in the context of this account.", 0, 1, this.priority));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "The party(s) that contribute to payment (or part of) of the charges applied to this account (including self-pay).\n\nA coverage may only be responsible for specific types of charges, and the sequence of the coverages in the account could be important when processing billing.", 0, 1, this.coverage);
                }
                case -1165461084: {
                    return new Property("priority", "positiveInt", "The priority of the coverage in the context of this account.", 0, 1, this.priority);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.coverage;
                    }
                    return baseArray;
                }
                case -1165461084: {
                    Base[] baseArray;
                    if (this.priority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.priority;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    this.coverage = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1165461084: {
                    this.priority = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("coverage")) {
                this.coverage = TypeConvertor.castToReference(value);
            } else if (name.equals("priority")) {
                this.priority = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    return this.getCoverage();
                }
                case -1165461084: {
                    return this.getPriorityElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case -1165461084: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("priority")) {
                throw new FHIRException("Cannot call addChild on a primitive type Account.coverage.priority");
            }
            return super.addChild(name);
        }

        @Override
        public CoverageComponent copy() {
            CoverageComponent dst = new CoverageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CoverageComponent dst) {
            super.copyValues(dst);
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            dst.priority = this.priority == null ? null : this.priority.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other_;
            return CoverageComponent.compareDeep(this.coverage, o.coverage, true) && CoverageComponent.compareDeep(this.priority, o.priority, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other_;
            return CoverageComponent.compareValues(this.priority, o.priority, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.coverage, this.priority});
        }

        @Override
        public String fhirType() {
            return "Account.coverage";
        }
    }

    public static class AccountStatusEnumFactory
    implements EnumFactory<AccountStatus> {
        @Override
        public AccountStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return AccountStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return AccountStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return AccountStatus.ENTEREDINERROR;
            }
            if ("on-hold".equals(codeString)) {
                return AccountStatus.ONHOLD;
            }
            if ("unknown".equals(codeString)) {
                return AccountStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown AccountStatus code '" + codeString + "'");
        }

        public Enumeration<AccountStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AccountStatus>(this, AccountStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.ACTIVE, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.INACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.ENTEREDINERROR, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.ONHOLD, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown AccountStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AccountStatus code) {
            if (code == AccountStatus.ACTIVE) {
                return "active";
            }
            if (code == AccountStatus.INACTIVE) {
                return "inactive";
            }
            if (code == AccountStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == AccountStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == AccountStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(AccountStatus code) {
            return code.getSystem();
        }
    }

    public static enum AccountStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        ONHOLD,
        UNKNOWN,
        NULL;


        public static AccountStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AccountStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/account-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/account-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/account-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/account-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/account-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "This account is active and may be used.";
                }
                case INACTIVE: {
                    return "This account is inactive and should not be used to track financial information.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case ONHOLD: {
                    return "This account is on hold.";
                }
                case UNKNOWN: {
                    return "The account status is unknown.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

