package org.hl7.fhir.r5.formats;


// generated

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Tue, Dec 13, 2022 17:53+1100 for FHIR vcurrent



import org.hl7.fhir.r5.model.*;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.turtle.Turtle.*;
import java.io.IOException;

public class RdfParser extends RdfParserBase {

  public RdfParser() {
    super();
  }

  public RdfParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }

  private void composeEnum(Complex parent, String parentType, String name, Enumeration<? extends Enum> value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
    decorateCode(t, value);
  }


  protected void composeDate(Complex parent, String parentType, String name, DateType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeDateTime(Complex parent, String parentType, String name, DateTimeType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeCode(Complex parent, String parentType, String name, CodeType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
    decorateCode(t, value);
  }

  protected void composeString(Complex parent, String parentType, String name, StringType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeInteger(Complex parent, String parentType, String name, IntegerType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeInteger64(Complex parent, String parentType, String name, Integer64Type value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeOid(Complex parent, String parentType, String name, OidType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeCanonical(Complex parent, String parentType, String name, CanonicalType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeUri(Complex parent, String parentType, String name, UriType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeUuid(Complex parent, String parentType, String name, UuidType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeUrl(Complex parent, String parentType, String name, UrlType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeInstant(Complex parent, String parentType, String name, InstantType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeBoolean(Complex parent, String parentType, String name, BooleanType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeBase64Binary(Complex parent, String parentType, String name, Base64BinaryType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeUnsignedInt(Complex parent, String parentType, String name, UnsignedIntType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeMarkdown(Complex parent, String parentType, String name, MarkdownType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeTime(Complex parent, String parentType, String name, TimeType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeId(Complex parent, String parentType, String name, IdType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composePositiveInt(Complex parent, String parentType, String name, PositiveIntType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeDecimal(Complex parent, String parentType, String name, DecimalType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeBackboneElement(Complex t, String parentType, String name, BackboneElement element, int index) {
    composeElement(t, parentType, name, element, index);
    for (int i = 0; i < element.getModifierExtension().size(); i++) {
      composeExtension(t, "BackboneElement", "modifierExtension", element.getModifierExtension().get(i), i);
    }
  }

  protected void composeBackboneType(Complex t, String parentType, String name, BackboneType element, int index) {
    composeDataType(t, parentType, name, element, index);
    for (int i = 0; i < element.getModifierExtension().size(); i++) {
      composeExtension(t, "BackboneType", "modifierExtension", element.getModifierExtension().get(i), i);
    }
  }

  protected void composeDataType(Complex t, String parentType, String name, DataType element, int index) {
    composeElement(t, parentType, name, element, index);
  }

  protected void composeElement(Complex t, String parentType, String name, Element element, int index) {
    composeBase(t, parentType, name, element, index);
    if (element.hasIdElement()) {
      composeString(t, "Element", "id", element.getIdElement(), -1);
    }
    for (int i = 0; i < element.getExtension().size(); i++) {
      composeExtension(t, "Element", "extension", element.getExtension().get(i), i);
    }
  }

  protected void composeAddress(Complex parent, String parentType, String name, Address element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Address", name, element, index);
    if (element.hasUseElement()) {
      composeEnum(t, "Address", "use", element.getUseElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "Address", "type", element.getTypeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "Address", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getLine().size(); i++) {
      composeString(t, "Address", "line", element.getLine().get(i), i);
    }
    if (element.hasCityElement()) {
      composeString(t, "Address", "city", element.getCityElement(), -1);
    }
    if (element.hasDistrictElement()) {
      composeString(t, "Address", "district", element.getDistrictElement(), -1);
    }
    if (element.hasStateElement()) {
      composeString(t, "Address", "state", element.getStateElement(), -1);
    }
    if (element.hasPostalCodeElement()) {
      composeString(t, "Address", "postalCode", element.getPostalCodeElement(), -1);
    }
    if (element.hasCountryElement()) {
      composeString(t, "Address", "country", element.getCountryElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Address", "period", element.getPeriod(), -1);
    }
  }

  protected void composeAge(Complex parent, String parentType, String name, Age element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeQuantity(t, "Age", name, element, index);
  }

  protected void composeAnnotation(Complex parent, String parentType, String name, Annotation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Annotation", name, element, index);
    if (element.hasAuthor()) {
      composeType(t, "Annotation", "author", element.getAuthor(), -1);
    }
    if (element.hasTimeElement()) {
      composeDateTime(t, "Annotation", "time", element.getTimeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeMarkdown(t, "Annotation", "text", element.getTextElement(), -1);
    }
  }

  protected void composeAttachment(Complex parent, String parentType, String name, Attachment element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Attachment", name, element, index);
    if (element.hasContentTypeElement()) {
      composeCode(t, "Attachment", "contentType", element.getContentTypeElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeCode(t, "Attachment", "language", element.getLanguageElement(), -1);
    }
    if (element.hasDataElement()) {
      composeBase64Binary(t, "Attachment", "data", element.getDataElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUrl(t, "Attachment", "url", element.getUrlElement(), -1);
    }
    if (element.hasSizeElement()) {
      composeInteger64(t, "Attachment", "size", element.getSizeElement(), -1);
    }
    if (element.hasHashElement()) {
      composeBase64Binary(t, "Attachment", "hash", element.getHashElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Attachment", "title", element.getTitleElement(), -1);
    }
    if (element.hasCreationElement()) {
      composeDateTime(t, "Attachment", "creation", element.getCreationElement(), -1);
    }
    if (element.hasHeightElement()) {
      composePositiveInt(t, "Attachment", "height", element.getHeightElement(), -1);
    }
    if (element.hasWidthElement()) {
      composePositiveInt(t, "Attachment", "width", element.getWidthElement(), -1);
    }
    if (element.hasFramesElement()) {
      composePositiveInt(t, "Attachment", "frames", element.getFramesElement(), -1);
    }
    if (element.hasDurationElement()) {
      composeDecimal(t, "Attachment", "duration", element.getDurationElement(), -1);
    }
    if (element.hasPagesElement()) {
      composePositiveInt(t, "Attachment", "pages", element.getPagesElement(), -1);
    }
  }

  protected void composeAvailability(Complex parent, String parentType, String name, Availability element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Availability", name, element, index);
    for (int i = 0; i < element.getAvailableTime().size(); i++) {
      composeAvailabilityAvailableTimeComponent(t, "Availability", "availableTime", element.getAvailableTime().get(i), i);
    }
    for (int i = 0; i < element.getNotAvailableTime().size(); i++) {
      composeAvailabilityNotAvailableTimeComponent(t, "Availability", "notAvailableTime", element.getNotAvailableTime().get(i), i);
    }
  }

  protected void composeAvailabilityAvailableTimeComponent(Complex parent, String parentType, String name, Availability.AvailabilityAvailableTimeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "availableTime", name, element, index);
    for (int i = 0; i < element.getDaysOfWeek().size(); i++) {
      composeEnum(t, "AvailabilityAvailableTimeComponent", "daysOfWeek", element.getDaysOfWeek().get(i), i);
    }
    if (element.hasAllDayElement()) {
      composeBoolean(t, "AvailabilityAvailableTimeComponent", "allDay", element.getAllDayElement(), -1);
    }
    if (element.hasAvailableStartTimeElement()) {
      composeTime(t, "AvailabilityAvailableTimeComponent", "availableStartTime", element.getAvailableStartTimeElement(), -1);
    }
    if (element.hasAvailableEndTimeElement()) {
      composeTime(t, "AvailabilityAvailableTimeComponent", "availableEndTime", element.getAvailableEndTimeElement(), -1);
    }
  }

  protected void composeAvailabilityNotAvailableTimeComponent(Complex parent, String parentType, String name, Availability.AvailabilityNotAvailableTimeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "notAvailableTime", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "AvailabilityNotAvailableTimeComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasDuring()) {
      composePeriod(t, "AvailabilityNotAvailableTimeComponent", "during", element.getDuring(), -1);
    }
  }

  protected void composeCodeableConcept(Complex parent, String parentType, String name, CodeableConcept element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "CodeableConcept", name, element, index);
    decorateCodeableConcept(t, element);
    for (int i = 0; i < element.getCoding().size(); i++) {
      composeCoding(t, "CodeableConcept", "coding", element.getCoding().get(i), i);
    }
    if (element.hasTextElement()) {
      composeString(t, "CodeableConcept", "text", element.getTextElement(), -1);
    }
  }

  protected void composeCodeableReference(Complex parent, String parentType, String name, CodeableReference element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "CodeableReference", name, element, index);
    if (element.hasConcept()) {
      composeCodeableConcept(t, "CodeableReference", "concept", element.getConcept(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "CodeableReference", "reference", element.getReference(), -1);
    }
  }

  protected void composeCoding(Complex parent, String parentType, String name, Coding element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Coding", name, element, index);
    decorateCoding(t, element);
    if (element.hasSystemElement()) {
      composeUri(t, "Coding", "system", element.getSystemElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Coding", "version", element.getVersionElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "Coding", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "Coding", "display", element.getDisplayElement(), -1);
    }
    if (element.hasUserSelectedElement()) {
      composeBoolean(t, "Coding", "userSelected", element.getUserSelectedElement(), -1);
    }
  }

  protected void composeContactDetail(Complex parent, String parentType, String name, ContactDetail element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ContactDetail", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ContactDetail", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "ContactDetail", "telecom", element.getTelecom().get(i), i);
    }
  }

  protected void composeContactPoint(Complex parent, String parentType, String name, ContactPoint element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ContactPoint", name, element, index);
    if (element.hasSystemElement()) {
      composeEnum(t, "ContactPoint", "system", element.getSystemElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "ContactPoint", "value", element.getValueElement(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "ContactPoint", "use", element.getUseElement(), -1);
    }
    if (element.hasRankElement()) {
      composePositiveInt(t, "ContactPoint", "rank", element.getRankElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ContactPoint", "period", element.getPeriod(), -1);
    }
  }

  protected void composeContributor(Complex parent, String parentType, String name, Contributor element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Contributor", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "Contributor", "type", element.getTypeElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Contributor", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Contributor", "contact", element.getContact().get(i), i);
    }
  }

  protected void composeCount(Complex parent, String parentType, String name, Count element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeQuantity(t, "Count", name, element, index);
  }

  protected void composeDataRequirement(Complex parent, String parentType, String name, DataRequirement element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "DataRequirement", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "DataRequirement", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeCanonical(t, "DataRequirement", "profile", element.getProfile().get(i), i);
    }
    if (element.hasSubject()) {
      composeType(t, "DataRequirement", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getMustSupport().size(); i++) {
      composeString(t, "DataRequirement", "mustSupport", element.getMustSupport().get(i), i);
    }
    for (int i = 0; i < element.getCodeFilter().size(); i++) {
      composeDataRequirementCodeFilterComponent(t, "DataRequirement", "codeFilter", element.getCodeFilter().get(i), i);
    }
    for (int i = 0; i < element.getDateFilter().size(); i++) {
      composeDataRequirementDateFilterComponent(t, "DataRequirement", "dateFilter", element.getDateFilter().get(i), i);
    }
    for (int i = 0; i < element.getValueFilter().size(); i++) {
      composeDataRequirementValueFilterComponent(t, "DataRequirement", "valueFilter", element.getValueFilter().get(i), i);
    }
    if (element.hasLimitElement()) {
      composePositiveInt(t, "DataRequirement", "limit", element.getLimitElement(), -1);
    }
    for (int i = 0; i < element.getSort().size(); i++) {
      composeDataRequirementSortComponent(t, "DataRequirement", "sort", element.getSort().get(i), i);
    }
  }

  protected void composeDataRequirementCodeFilterComponent(Complex parent, String parentType, String name, DataRequirement.DataRequirementCodeFilterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "codeFilter", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "DataRequirementCodeFilterComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasSearchParamElement()) {
      composeString(t, "DataRequirementCodeFilterComponent", "searchParam", element.getSearchParamElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "DataRequirementCodeFilterComponent", "valueSet", element.getValueSetElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "DataRequirementCodeFilterComponent", "code", element.getCode().get(i), i);
    }
  }

  protected void composeDataRequirementDateFilterComponent(Complex parent, String parentType, String name, DataRequirement.DataRequirementDateFilterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "dateFilter", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "DataRequirementDateFilterComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasSearchParamElement()) {
      composeString(t, "DataRequirementDateFilterComponent", "searchParam", element.getSearchParamElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "DataRequirementDateFilterComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeDataRequirementValueFilterComponent(Complex parent, String parentType, String name, DataRequirement.DataRequirementValueFilterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "valueFilter", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "DataRequirementValueFilterComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasSearchParamElement()) {
      composeString(t, "DataRequirementValueFilterComponent", "searchParam", element.getSearchParamElement(), -1);
    }
    if (element.hasComparatorElement()) {
      composeEnum(t, "DataRequirementValueFilterComponent", "comparator", element.getComparatorElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "DataRequirementValueFilterComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeDataRequirementSortComponent(Complex parent, String parentType, String name, DataRequirement.DataRequirementSortComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "sort", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "DataRequirementSortComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasDirectionElement()) {
      composeEnum(t, "DataRequirementSortComponent", "direction", element.getDirectionElement(), -1);
    }
  }

  protected void composeDistance(Complex parent, String parentType, String name, Distance element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeQuantity(t, "Distance", name, element, index);
  }

  protected void composeDosage(Complex parent, String parentType, String name, Dosage element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneType(t, "Dosage", name, element, index);
    if (element.hasSequenceElement()) {
      composeInteger(t, "Dosage", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "Dosage", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getAdditionalInstruction().size(); i++) {
      composeCodeableConcept(t, "Dosage", "additionalInstruction", element.getAdditionalInstruction().get(i), i);
    }
    if (element.hasPatientInstructionElement()) {
      composeString(t, "Dosage", "patientInstruction", element.getPatientInstructionElement(), -1);
    }
    if (element.hasTiming()) {
      composeTiming(t, "Dosage", "timing", element.getTiming(), -1);
    }
    if (element.hasAsNeededElement()) {
      composeBoolean(t, "Dosage", "asNeeded", element.getAsNeededElement(), -1);
    }
    for (int i = 0; i < element.getAsNeededFor().size(); i++) {
      composeCodeableConcept(t, "Dosage", "asNeededFor", element.getAsNeededFor().get(i), i);
    }
    if (element.hasSite()) {
      composeCodeableConcept(t, "Dosage", "site", element.getSite(), -1);
    }
    if (element.hasRoute()) {
      composeCodeableConcept(t, "Dosage", "route", element.getRoute(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "Dosage", "method", element.getMethod(), -1);
    }
    for (int i = 0; i < element.getDoseAndRate().size(); i++) {
      composeDosageDoseAndRateComponent(t, "Dosage", "doseAndRate", element.getDoseAndRate().get(i), i);
    }
    for (int i = 0; i < element.getMaxDosePerPeriod().size(); i++) {
      composeRatio(t, "Dosage", "maxDosePerPeriod", element.getMaxDosePerPeriod().get(i), i);
    }
    if (element.hasMaxDosePerAdministration()) {
      composeQuantity(t, "Dosage", "maxDosePerAdministration", element.getMaxDosePerAdministration(), -1);
    }
    if (element.hasMaxDosePerLifetime()) {
      composeQuantity(t, "Dosage", "maxDosePerLifetime", element.getMaxDosePerLifetime(), -1);
    }
  }

  protected void composeDosageDoseAndRateComponent(Complex parent, String parentType, String name, Dosage.DosageDoseAndRateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "doseAndRate", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DosageDoseAndRateComponent", "type", element.getType(), -1);
    }
    if (element.hasDose()) {
      composeType(t, "DosageDoseAndRateComponent", "dose", element.getDose(), -1);
    }
    if (element.hasRate()) {
      composeType(t, "DosageDoseAndRateComponent", "rate", element.getRate(), -1);
    }
  }

  protected void composeDuration(Complex parent, String parentType, String name, Duration element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeQuantity(t, "Duration", name, element, index);
  }

  protected void composeElementDefinition(Complex parent, String parentType, String name, ElementDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneType(t, "ElementDefinition", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
    }
    for (int i = 0; i < element.getRepresentation().size(); i++) {
      composeEnum(t, "ElementDefinition", "representation", element.getRepresentation().get(i), i);
    }
    if (element.hasSliceNameElement()) {
      composeString(t, "ElementDefinition", "sliceName", element.getSliceNameElement(), -1);
    }
    if (element.hasSliceIsConstrainingElement()) {
      composeBoolean(t, "ElementDefinition", "sliceIsConstraining", element.getSliceIsConstrainingElement(), -1);
    }
    if (element.hasLabelElement()) {
      composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "ElementDefinition", "code", element.getCode().get(i), i);
    }
    if (element.hasSlicing()) {
      composeElementDefinitionSlicingComponent(t, "ElementDefinition", "slicing", element.getSlicing(), -1);
    }
    if (element.hasShortElement()) {
      composeString(t, "ElementDefinition", "short", element.getShortElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeMarkdown(t, "ElementDefinition", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeMarkdown(t, "ElementDefinition", "comment", element.getCommentElement(), -1);
    }
    if (element.hasRequirementsElement()) {
      composeMarkdown(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "ElementDefinition", "alias", element.getAlias().get(i), i);
    }
    if (element.hasMinElement()) {
      composeUnsignedInt(t, "ElementDefinition", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
    }
    if (element.hasBase()) {
      composeElementDefinitionBaseComponent(t, "ElementDefinition", "base", element.getBase(), -1);
    }
    if (element.hasContentReferenceElement()) {
      composeUri(t, "ElementDefinition", "contentReference", element.getContentReferenceElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeElementDefinitionTypeRefComponent(t, "ElementDefinition", "type", element.getType().get(i), i);
    }
    if (element.hasDefaultValue()) {
      composeType(t, "ElementDefinition", "defaultValue", element.getDefaultValue(), -1);
    }
    if (element.hasMeaningWhenMissingElement()) {
      composeMarkdown(t, "ElementDefinition", "meaningWhenMissing", element.getMeaningWhenMissingElement(), -1);
    }
    if (element.hasOrderMeaningElement()) {
      composeString(t, "ElementDefinition", "orderMeaning", element.getOrderMeaningElement(), -1);
    }
    if (element.hasFixed()) {
      composeType(t, "ElementDefinition", "fixed", element.getFixed(), -1);
    }
    if (element.hasPattern()) {
      composeType(t, "ElementDefinition", "pattern", element.getPattern(), -1);
    }
    for (int i = 0; i < element.getExample().size(); i++) {
      composeElementDefinitionExampleComponent(t, "ElementDefinition", "example", element.getExample().get(i), i);
    }
    if (element.hasMinValue()) {
      composeType(t, "ElementDefinition", "minValue", element.getMinValue(), -1);
    }
    if (element.hasMaxValue()) {
      composeType(t, "ElementDefinition", "maxValue", element.getMaxValue(), -1);
    }
    if (element.hasMaxLengthElement()) {
      composeInteger(t, "ElementDefinition", "maxLength", element.getMaxLengthElement(), -1);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeId(t, "ElementDefinition", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getConstraint().size(); i++) {
      composeElementDefinitionConstraintComponent(t, "ElementDefinition", "constraint", element.getConstraint().get(i), i);
    }
    if (element.hasMustHaveValueElement()) {
      composeBoolean(t, "ElementDefinition", "mustHaveValue", element.getMustHaveValueElement(), -1);
    }
    for (int i = 0; i < element.getValueAlternatives().size(); i++) {
      composeCanonical(t, "ElementDefinition", "valueAlternatives", element.getValueAlternatives().get(i), i);
    }
    if (element.hasMustSupportElement()) {
      composeBoolean(t, "ElementDefinition", "mustSupport", element.getMustSupportElement(), -1);
    }
    for (int i = 0; i < element.getObligation().size(); i++) {
      composeElementDefinitionObligationComponent(t, "ElementDefinition", "obligation", element.getObligation().get(i), i);
    }
    if (element.hasIsModifierElement()) {
      composeBoolean(t, "ElementDefinition", "isModifier", element.getIsModifierElement(), -1);
    }
    if (element.hasIsModifierReasonElement()) {
      composeString(t, "ElementDefinition", "isModifierReason", element.getIsModifierReasonElement(), -1);
    }
    if (element.hasIsSummaryElement()) {
      composeBoolean(t, "ElementDefinition", "isSummary", element.getIsSummaryElement(), -1);
    }
    if (element.hasBinding()) {
      composeElementDefinitionBindingComponent(t, "ElementDefinition", "binding", element.getBinding(), -1);
    }
    for (int i = 0; i < element.getMapping().size(); i++) {
      composeElementDefinitionMappingComponent(t, "ElementDefinition", "mapping", element.getMapping().get(i), i);
    }
  }

  protected void composeElementDefinitionSlicingComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "slicing", name, element, index);
    for (int i = 0; i < element.getDiscriminator().size(); i++) {
      composeElementDefinitionSlicingDiscriminatorComponent(t, "ElementDefinitionSlicingComponent", "discriminator", element.getDiscriminator().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ElementDefinitionSlicingComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasOrderedElement()) {
      composeBoolean(t, "ElementDefinitionSlicingComponent", "ordered", element.getOrderedElement(), -1);
    }
    if (element.hasRulesElement()) {
      composeEnum(t, "ElementDefinitionSlicingComponent", "rules", element.getRulesElement(), -1);
    }
  }

  protected void composeElementDefinitionSlicingDiscriminatorComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "discriminator", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "ElementDefinitionSlicingDiscriminatorComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasPathElement()) {
      composeString(t, "ElementDefinitionSlicingDiscriminatorComponent", "path", element.getPathElement(), -1);
    }
  }

  protected void composeElementDefinitionBaseComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBaseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "base", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "ElementDefinitionBaseComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasMinElement()) {
      composeUnsignedInt(t, "ElementDefinitionBaseComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "ElementDefinitionBaseComponent", "max", element.getMaxElement(), -1);
    }
  }

  protected void composeElementDefinitionTypeRefComponent(Complex parent, String parentType, String name, ElementDefinition.TypeRefComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "type", name, element, index);
    if (element.hasCodeElement()) {
      composeUri(t, "TypeRefComponent", "code", element.getCodeElement(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeCanonical(t, "TypeRefComponent", "profile", element.getProfile().get(i), i);
    }
    for (int i = 0; i < element.getTargetProfile().size(); i++) {
      composeCanonical(t, "TypeRefComponent", "targetProfile", element.getTargetProfile().get(i), i);
    }
    for (int i = 0; i < element.getAggregation().size(); i++) {
      composeEnum(t, "TypeRefComponent", "aggregation", element.getAggregation().get(i), i);
    }
    if (element.hasVersioningElement()) {
      composeEnum(t, "TypeRefComponent", "versioning", element.getVersioningElement(), -1);
    }
  }

  protected void composeElementDefinitionExampleComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionExampleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "example", name, element, index);
    if (element.hasLabelElement()) {
      composeString(t, "ElementDefinitionExampleComponent", "label", element.getLabelElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ElementDefinitionExampleComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeElementDefinitionConstraintComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionConstraintComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "constraint", name, element, index);
    if (element.hasKeyElement()) {
      composeId(t, "ElementDefinitionConstraintComponent", "key", element.getKeyElement(), -1);
    }
    if (element.hasRequirementsElement()) {
      composeMarkdown(t, "ElementDefinitionConstraintComponent", "requirements", element.getRequirementsElement(), -1);
    }
    if (element.hasSeverityElement()) {
      composeEnum(t, "ElementDefinitionConstraintComponent", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasSuppressElement()) {
      composeBoolean(t, "ElementDefinitionConstraintComponent", "suppress", element.getSuppressElement(), -1);
    }
    if (element.hasHumanElement()) {
      composeString(t, "ElementDefinitionConstraintComponent", "human", element.getHumanElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "ElementDefinitionConstraintComponent", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasSourceElement()) {
      composeCanonical(t, "ElementDefinitionConstraintComponent", "source", element.getSourceElement(), -1);
    }
  }

  protected void composeElementDefinitionObligationComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionObligationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "obligation", name, element, index);
    if (element.hasCode()) {
      composeCoding(t, "ElementDefinitionObligationComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getActor().size(); i++) {
      composeCanonical(t, "ElementDefinitionObligationComponent", "actor", element.getActor().get(i), i);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "ElementDefinitionObligationComponent", "documentation", element.getDocumentationElement(), -1);
    }
    for (int i = 0; i < element.getUsage().size(); i++) {
      composeUsageContext(t, "ElementDefinitionObligationComponent", "usage", element.getUsage().get(i), i);
    }
    if (element.hasFilterElement()) {
      composeString(t, "ElementDefinitionObligationComponent", "filter", element.getFilterElement(), -1);
    }
    if (element.hasFilterDocumentationElement()) {
      composeString(t, "ElementDefinitionObligationComponent", "filterDocumentation", element.getFilterDocumentationElement(), -1);
    }
    for (int i = 0; i < element.getProcess().size(); i++) {
      composeUri(t, "ElementDefinitionObligationComponent", "process", element.getProcess().get(i), i);
    }
  }

  protected void composeElementDefinitionBindingComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "binding", name, element, index);
    if (element.hasStrengthElement()) {
      composeEnum(t, "ElementDefinitionBindingComponent", "strength", element.getStrengthElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ElementDefinitionBindingComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "ElementDefinitionBindingComponent", "valueSet", element.getValueSetElement(), -1);
    }
    for (int i = 0; i < element.getAdditional().size(); i++) {
      composeElementDefinitionBindingAdditionalComponent(t, "ElementDefinitionBindingComponent", "additional", element.getAdditional().get(i), i);
    }
  }

  protected void composeElementDefinitionBindingAdditionalComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingAdditionalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "additional", name, element, index);
    if (element.hasPurposeElement()) {
      composeEnum(t, "ElementDefinitionBindingAdditionalComponent", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "ElementDefinitionBindingAdditionalComponent", "valueSet", element.getValueSetElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "ElementDefinitionBindingAdditionalComponent", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasShortDocoElement()) {
      composeString(t, "ElementDefinitionBindingAdditionalComponent", "shortDoco", element.getShortDocoElement(), -1);
    }
    for (int i = 0; i < element.getUsage().size(); i++) {
      composeUsageContext(t, "ElementDefinitionBindingAdditionalComponent", "usage", element.getUsage().get(i), i);
    }
    if (element.hasAnyElement()) {
      composeBoolean(t, "ElementDefinitionBindingAdditionalComponent", "any", element.getAnyElement(), -1);
    }
  }

  protected void composeElementDefinitionMappingComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionMappingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "mapping", name, element, index);
    if (element.hasIdentityElement()) {
      composeId(t, "ElementDefinitionMappingComponent", "identity", element.getIdentityElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeCode(t, "ElementDefinitionMappingComponent", "language", element.getLanguageElement(), -1);
    }
    if (element.hasMapElement()) {
      composeString(t, "ElementDefinitionMappingComponent", "map", element.getMapElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeMarkdown(t, "ElementDefinitionMappingComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeExpression(Complex parent, String parentType, String name, Expression element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Expression", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "Expression", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeId(t, "Expression", "name", element.getNameElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeCode(t, "Expression", "language", element.getLanguageElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "Expression", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasReferenceElement()) {
      composeUri(t, "Expression", "reference", element.getReferenceElement(), -1);
    }
  }

  protected void composeExtendedContactDetail(Complex parent, String parentType, String name, ExtendedContactDetail element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ExtendedContactDetail", name, element, index);
    if (element.hasPurpose()) {
      composeCodeableConcept(t, "ExtendedContactDetail", "purpose", element.getPurpose(), -1);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "ExtendedContactDetail", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "ExtendedContactDetail", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasAddress()) {
      composeAddress(t, "ExtendedContactDetail", "address", element.getAddress(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "ExtendedContactDetail", "organization", element.getOrganization(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ExtendedContactDetail", "period", element.getPeriod(), -1);
    }
  }

  protected void composeExtension(Complex parent, String parentType, String name, Extension element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Extension", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Extension", "url", element.getUrlElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "Extension", "value", element.getValue(), -1);
    }
  }

  protected void composeHumanName(Complex parent, String parentType, String name, HumanName element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "HumanName", name, element, index);
    if (element.hasUseElement()) {
      composeEnum(t, "HumanName", "use", element.getUseElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "HumanName", "text", element.getTextElement(), -1);
    }
    if (element.hasFamilyElement()) {
      composeString(t, "HumanName", "family", element.getFamilyElement(), -1);
    }
    for (int i = 0; i < element.getGiven().size(); i++) {
      composeString(t, "HumanName", "given", element.getGiven().get(i), i);
    }
    for (int i = 0; i < element.getPrefix().size(); i++) {
      composeString(t, "HumanName", "prefix", element.getPrefix().get(i), i);
    }
    for (int i = 0; i < element.getSuffix().size(); i++) {
      composeString(t, "HumanName", "suffix", element.getSuffix().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "HumanName", "period", element.getPeriod(), -1);
    }
  }

  protected void composeIdentifier(Complex parent, String parentType, String name, Identifier element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Identifier", name, element, index);
    if (element.hasUseElement()) {
      composeEnum(t, "Identifier", "use", element.getUseElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Identifier", "type", element.getType(), -1);
    }
    if (element.hasSystemElement()) {
      composeUri(t, "Identifier", "system", element.getSystemElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "Identifier", "value", element.getValueElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Identifier", "period", element.getPeriod(), -1);
    }
    if (element.hasAssigner()) {
      composeReference(t, "Identifier", "assigner", element.getAssigner(), -1);
    }
  }

  protected void composeMarketingStatus(Complex parent, String parentType, String name, MarketingStatus element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneType(t, "MarketingStatus", name, element, index);
    if (element.hasCountry()) {
      composeCodeableConcept(t, "MarketingStatus", "country", element.getCountry(), -1);
    }
    if (element.hasJurisdiction()) {
      composeCodeableConcept(t, "MarketingStatus", "jurisdiction", element.getJurisdiction(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "MarketingStatus", "status", element.getStatus(), -1);
    }
    if (element.hasDateRange()) {
      composePeriod(t, "MarketingStatus", "dateRange", element.getDateRange(), -1);
    }
    if (element.hasRestoreDateElement()) {
      composeDateTime(t, "MarketingStatus", "restoreDate", element.getRestoreDateElement(), -1);
    }
  }

  protected void composeMeta(Complex parent, String parentType, String name, Meta element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Meta", name, element, index);
    if (element.hasVersionIdElement()) {
      composeId(t, "Meta", "versionId", element.getVersionIdElement(), -1);
    }
    if (element.hasLastUpdatedElement()) {
      composeInstant(t, "Meta", "lastUpdated", element.getLastUpdatedElement(), -1);
    }
    if (element.hasSourceElement()) {
      composeUri(t, "Meta", "source", element.getSourceElement(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeCanonical(t, "Meta", "profile", element.getProfile().get(i), i);
    }
    for (int i = 0; i < element.getSecurity().size(); i++) {
      composeCoding(t, "Meta", "security", element.getSecurity().get(i), i);
    }
    for (int i = 0; i < element.getTag().size(); i++) {
      composeCoding(t, "Meta", "tag", element.getTag().get(i), i);
    }
  }

  protected void composeMonetaryComponent(Complex parent, String parentType, String name, MonetaryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "MonetaryComponent", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "MonetaryComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "MonetaryComponent", "code", element.getCode(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "MonetaryComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "MonetaryComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeMoney(Complex parent, String parentType, String name, Money element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Money", name, element, index);
    if (element.hasValueElement()) {
      composeDecimal(t, "Money", "value", element.getValueElement(), -1);
    }
    if (element.hasCurrencyElement()) {
      composeCode(t, "Money", "currency", element.getCurrencyElement(), -1);
    }
  }

  protected void composeNarrative(Complex parent, String parentType, String name, Narrative element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Narrative", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "Narrative", "status", element.getStatusElement(), -1);
    }
    if (element.hasDiv()) {
      composeXhtmlNode(t, "Narrative", "div", element.getDiv(), -1);
    }
  }

  protected void composeParameterDefinition(Complex parent, String parentType, String name, ParameterDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ParameterDefinition", name, element, index);
    if (element.hasNameElement()) {
      composeCode(t, "ParameterDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "ParameterDefinition", "use", element.getUseElement(), -1);
    }
    if (element.hasMinElement()) {
      composeInteger(t, "ParameterDefinition", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "ParameterDefinition", "max", element.getMaxElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "ParameterDefinition", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ParameterDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "ParameterDefinition", "profile", element.getProfileElement(), -1);
    }
  }

  protected void composePeriod(Complex parent, String parentType, String name, Period element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Period", name, element, index);
    if (element.hasStartElement()) {
      composeDateTime(t, "Period", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeDateTime(t, "Period", "end", element.getEndElement(), -1);
    }
  }

  protected void composePopulation(Complex parent, String parentType, String name, Population element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneType(t, "Population", name, element, index);
    if (element.hasAge()) {
      composeType(t, "Population", "age", element.getAge(), -1);
    }
    if (element.hasGender()) {
      composeCodeableConcept(t, "Population", "gender", element.getGender(), -1);
    }
    if (element.hasRace()) {
      composeCodeableConcept(t, "Population", "race", element.getRace(), -1);
    }
    if (element.hasPhysiologicalCondition()) {
      composeCodeableConcept(t, "Population", "physiologicalCondition", element.getPhysiologicalCondition(), -1);
    }
  }

  protected void composeProductShelfLife(Complex parent, String parentType, String name, ProductShelfLife element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneType(t, "ProductShelfLife", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ProductShelfLife", "type", element.getType(), -1);
    }
    if (element.hasPeriod()) {
      composeType(t, "ProductShelfLife", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getSpecialPrecautionsForStorage().size(); i++) {
      composeCodeableConcept(t, "ProductShelfLife", "specialPrecautionsForStorage", element.getSpecialPrecautionsForStorage().get(i), i);
    }
  }

  protected void composeQuantity(Complex parent, String parentType, String name, Quantity element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Quantity", name, element, index);
    if (element.hasValueElement()) {
      composeDecimal(t, "Quantity", "value", element.getValueElement(), -1);
    }
    if (element.hasComparatorElement()) {
      composeEnum(t, "Quantity", "comparator", element.getComparatorElement(), -1);
    }
    if (element.hasUnitElement()) {
      composeString(t, "Quantity", "unit", element.getUnitElement(), -1);
    }
    if (element.hasSystemElement()) {
      composeUri(t, "Quantity", "system", element.getSystemElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "Quantity", "code", element.getCodeElement(), -1);
    }
  }

  protected void composeRange(Complex parent, String parentType, String name, Range element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Range", name, element, index);
    if (element.hasLow()) {
      composeQuantity(t, "Range", "low", element.getLow(), -1);
    }
    if (element.hasHigh()) {
      composeQuantity(t, "Range", "high", element.getHigh(), -1);
    }
  }

  protected void composeRatio(Complex parent, String parentType, String name, Ratio element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Ratio", name, element, index);
    if (element.hasNumerator()) {
      composeQuantity(t, "Ratio", "numerator", element.getNumerator(), -1);
    }
    if (element.hasDenominator()) {
      composeQuantity(t, "Ratio", "denominator", element.getDenominator(), -1);
    }
  }

  protected void composeRatioRange(Complex parent, String parentType, String name, RatioRange element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "RatioRange", name, element, index);
    if (element.hasLowNumerator()) {
      composeQuantity(t, "RatioRange", "lowNumerator", element.getLowNumerator(), -1);
    }
    if (element.hasHighNumerator()) {
      composeQuantity(t, "RatioRange", "highNumerator", element.getHighNumerator(), -1);
    }
    if (element.hasDenominator()) {
      composeQuantity(t, "RatioRange", "denominator", element.getDenominator(), -1);
    }
  }

  protected void composeReference(Complex parent, String parentType, String name, Reference element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Reference", name, element, index);
    if (element.hasReferenceElement()) {
      composeString(t, "Reference", "reference", element.getReferenceElement_(), -1);
    }
    if (element.hasTypeElement()) {
      composeUri(t, "Reference", "type", element.getTypeElement(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "Reference", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "Reference", "display", element.getDisplayElement(), -1);
    }
  }

  protected void composeRelatedArtifact(Complex parent, String parentType, String name, RelatedArtifact element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "RelatedArtifact", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "RelatedArtifact", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "RelatedArtifact", "classifier", element.getClassifier().get(i), i);
    }
    if (element.hasLabelElement()) {
      composeString(t, "RelatedArtifact", "label", element.getLabelElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "RelatedArtifact", "display", element.getDisplayElement(), -1);
    }
    if (element.hasCitationElement()) {
      composeMarkdown(t, "RelatedArtifact", "citation", element.getCitationElement(), -1);
    }
    if (element.hasDocument()) {
      composeAttachment(t, "RelatedArtifact", "document", element.getDocument(), -1);
    }
    if (element.hasResourceElement()) {
      composeCanonical(t, "RelatedArtifact", "resource", element.getResourceElement(), -1);
    }
    if (element.hasResourceReference()) {
      composeReference(t, "RelatedArtifact", "resourceReference", element.getResourceReference(), -1);
    }
    if (element.hasPublicationStatusElement()) {
      composeEnum(t, "RelatedArtifact", "publicationStatus", element.getPublicationStatusElement(), -1);
    }
    if (element.hasPublicationDateElement()) {
      composeDate(t, "RelatedArtifact", "publicationDate", element.getPublicationDateElement(), -1);
    }
  }

  protected void composeSampledData(Complex parent, String parentType, String name, SampledData element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "SampledData", name, element, index);
    if (element.hasOrigin()) {
      composeQuantity(t, "SampledData", "origin", element.getOrigin(), -1);
    }
    if (element.hasIntervalElement()) {
      composeDecimal(t, "SampledData", "interval", element.getIntervalElement(), -1);
    }
    if (element.hasIntervalUnitElement()) {
      composeCode(t, "SampledData", "intervalUnit", element.getIntervalUnitElement(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "SampledData", "factor", element.getFactorElement(), -1);
    }
    if (element.hasLowerLimitElement()) {
      composeDecimal(t, "SampledData", "lowerLimit", element.getLowerLimitElement(), -1);
    }
    if (element.hasUpperLimitElement()) {
      composeDecimal(t, "SampledData", "upperLimit", element.getUpperLimitElement(), -1);
    }
    if (element.hasDimensionsElement()) {
      composePositiveInt(t, "SampledData", "dimensions", element.getDimensionsElement(), -1);
    }
    if (element.hasDataElement()) {
      composeString(t, "SampledData", "data", element.getDataElement(), -1);
    }
  }

  protected void composeSignature(Complex parent, String parentType, String name, Signature element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Signature", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCoding(t, "Signature", "type", element.getType().get(i), i);
    }
    if (element.hasWhenElement()) {
      composeInstant(t, "Signature", "when", element.getWhenElement(), -1);
    }
    if (element.hasWho()) {
      composeReference(t, "Signature", "who", element.getWho(), -1);
    }
    if (element.hasOnBehalfOf()) {
      composeReference(t, "Signature", "onBehalfOf", element.getOnBehalfOf(), -1);
    }
    if (element.hasTargetFormatElement()) {
      composeCode(t, "Signature", "targetFormat", element.getTargetFormatElement(), -1);
    }
    if (element.hasSigFormatElement()) {
      composeCode(t, "Signature", "sigFormat", element.getSigFormatElement(), -1);
    }
    if (element.hasDataElement()) {
      composeBase64Binary(t, "Signature", "data", element.getDataElement(), -1);
    }
  }

  protected void composeTiming(Complex parent, String parentType, String name, Timing element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneType(t, "Timing", name, element, index);
    for (int i = 0; i < element.getEvent().size(); i++) {
      composeDateTime(t, "Timing", "event", element.getEvent().get(i), i);
    }
    if (element.hasRepeat()) {
      composeTimingRepeatComponent(t, "Timing", "repeat", element.getRepeat(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Timing", "code", element.getCode(), -1);
    }
  }

  protected void composeTimingRepeatComponent(Complex parent, String parentType, String name, Timing.TimingRepeatComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "repeat", name, element, index);
    if (element.hasBounds()) {
      composeType(t, "TimingRepeatComponent", "bounds", element.getBounds(), -1);
    }
    if (element.hasCountElement()) {
      composePositiveInt(t, "TimingRepeatComponent", "count", element.getCountElement(), -1);
    }
    if (element.hasCountMaxElement()) {
      composePositiveInt(t, "TimingRepeatComponent", "countMax", element.getCountMaxElement(), -1);
    }
    if (element.hasDurationElement()) {
      composeDecimal(t, "TimingRepeatComponent", "duration", element.getDurationElement(), -1);
    }
    if (element.hasDurationMaxElement()) {
      composeDecimal(t, "TimingRepeatComponent", "durationMax", element.getDurationMaxElement(), -1);
    }
    if (element.hasDurationUnitElement()) {
      composeEnum(t, "TimingRepeatComponent", "durationUnit", element.getDurationUnitElement(), -1);
    }
    if (element.hasFrequencyElement()) {
      composePositiveInt(t, "TimingRepeatComponent", "frequency", element.getFrequencyElement(), -1);
    }
    if (element.hasFrequencyMaxElement()) {
      composePositiveInt(t, "TimingRepeatComponent", "frequencyMax", element.getFrequencyMaxElement(), -1);
    }
    if (element.hasPeriodElement()) {
      composeDecimal(t, "TimingRepeatComponent", "period", element.getPeriodElement(), -1);
    }
    if (element.hasPeriodMaxElement()) {
      composeDecimal(t, "TimingRepeatComponent", "periodMax", element.getPeriodMaxElement(), -1);
    }
    if (element.hasPeriodUnitElement()) {
      composeEnum(t, "TimingRepeatComponent", "periodUnit", element.getPeriodUnitElement(), -1);
    }
    for (int i = 0; i < element.getDayOfWeek().size(); i++) {
      composeEnum(t, "TimingRepeatComponent", "dayOfWeek", element.getDayOfWeek().get(i), i);
    }
    for (int i = 0; i < element.getTimeOfDay().size(); i++) {
      composeTime(t, "TimingRepeatComponent", "timeOfDay", element.getTimeOfDay().get(i), i);
    }
    for (int i = 0; i < element.getWhen().size(); i++) {
      composeEnum(t, "TimingRepeatComponent", "when", element.getWhen().get(i), i);
    }
    if (element.hasOffsetElement()) {
      composeUnsignedInt(t, "TimingRepeatComponent", "offset", element.getOffsetElement(), -1);
    }
  }

  protected void composeTriggerDefinition(Complex parent, String parentType, String name, TriggerDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "TriggerDefinition", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "TriggerDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "TriggerDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "TriggerDefinition", "code", element.getCode(), -1);
    }
    if (element.hasSubscriptionTopicElement()) {
      composeCanonical(t, "TriggerDefinition", "subscriptionTopic", element.getSubscriptionTopicElement(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "TriggerDefinition", "timing", element.getTiming(), -1);
    }
    for (int i = 0; i < element.getData().size(); i++) {
      composeDataRequirement(t, "TriggerDefinition", "data", element.getData().get(i), i);
    }
    if (element.hasCondition()) {
      composeExpression(t, "TriggerDefinition", "condition", element.getCondition(), -1);
    }
  }

  protected void composeUsageContext(Complex parent, String parentType, String name, UsageContext element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "UsageContext", name, element, index);
    if (element.hasCode()) {
      composeCoding(t, "UsageContext", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "UsageContext", "value", element.getValue(), -1);
    }
  }

  protected void composeVirtualServiceDetail(Complex parent, String parentType, String name, VirtualServiceDetail element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "VirtualServiceDetail", name, element, index);
    if (element.hasChannelType()) {
      composeCoding(t, "VirtualServiceDetail", "channelType", element.getChannelType(), -1);
    }
    if (element.hasAddress()) {
      composeType(t, "VirtualServiceDetail", "address", element.getAddress(), -1);
    }
    for (int i = 0; i < element.getAdditionalInfo().size(); i++) {
      composeUrl(t, "VirtualServiceDetail", "additionalInfo", element.getAdditionalInfo().get(i), i);
    }
    if (element.hasMaxParticipantsElement()) {
      composePositiveInt(t, "VirtualServiceDetail", "maxParticipants", element.getMaxParticipantsElement(), -1);
    }
    if (element.hasSessionKeyElement()) {
      composeString(t, "VirtualServiceDetail", "sessionKey", element.getSessionKeyElement(), -1);
    }
  }

  protected void composeCanonicalResource(Complex t, String parentType, String name, CanonicalResource element, int index) {
    composeDomainResource(t, parentType, name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "CanonicalResource", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CanonicalResource", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CanonicalResource", "version", element.getVersionElement(), -1);
    }
    if (element.hasVersionAlgorithm()) {
      composeType(t, "CanonicalResource", "versionAlgorithm", element.getVersionAlgorithm(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "CanonicalResource", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CanonicalResource", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CanonicalResource", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "CanonicalResource", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "CanonicalResource", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "CanonicalResource", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "CanonicalResource", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CanonicalResource", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "CanonicalResource", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "CanonicalResource", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "CanonicalResource", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CanonicalResource", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCopyrightLabelElement()) {
      composeString(t, "CanonicalResource", "copyrightLabel", element.getCopyrightLabelElement(), -1);
    }
  }

  protected void composeDomainResource(Complex t, String parentType, String name, DomainResource element, int index) {
    composeResource(t, parentType, name, element, index);
    if (element.hasText()) {
      composeNarrative(t, "DomainResource", "text", element.getText(), -1);
    }
    for (int i = 0; i < element.getContained().size(); i++) {
      composeResource(t, "DomainResource", "contained", element.getContained().get(i), i);
    }
    for (int i = 0; i < element.getExtension().size(); i++) {
      composeExtension(t, "DomainResource", "extension", element.getExtension().get(i), i);
    }
    for (int i = 0; i < element.getModifierExtension().size(); i++) {
      composeExtension(t, "DomainResource", "modifierExtension", element.getModifierExtension().get(i), i);
    }
  }

  protected void composeMetadataResource(Complex t, String parentType, String name, MetadataResource element, int index) {
    composeCanonicalResource(t, parentType, name, element, index);
    if (element.hasApprovalDateElement()) {
      composeDate(t, "MetadataResource", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "MetadataResource", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "MetadataResource", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "MetadataResource", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "MetadataResource", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "MetadataResource", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "MetadataResource", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "MetadataResource", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "MetadataResource", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
  }

  protected void composeResource(Complex t, String parentType, String name, Resource element, int index) {
    composeBase(t, parentType, name, element, index);
    if (element.hasIdElement()) {
      composeId(t, "Resource", "id", element.getIdElement(), -1);
    }
    if (element.hasMeta()) {
      composeMeta(t, "Resource", "meta", element.getMeta(), -1);
    }
    if (element.hasImplicitRulesElement()) {
      composeUri(t, "Resource", "implicitRules", element.getImplicitRulesElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeCode(t, "Resource", "language", element.getLanguageElement(), -1);
    }
  }

  protected void composeAccount(Complex parent, String parentType, String name, Account element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Account", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Account", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Account", "status", element.getStatusElement(), -1);
    }
    if (element.hasBillingStatus()) {
      composeCodeableConcept(t, "Account", "billingStatus", element.getBillingStatus(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Account", "type", element.getType(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Account", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "Account", "subject", element.getSubject().get(i), i);
    }
    if (element.hasServicePeriod()) {
      composePeriod(t, "Account", "servicePeriod", element.getServicePeriod(), -1);
    }
    for (int i = 0; i < element.getCoverage().size(); i++) {
      composeAccountCoverageComponent(t, "Account", "coverage", element.getCoverage().get(i), i);
    }
    if (element.hasOwner()) {
      composeReference(t, "Account", "owner", element.getOwner(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Account", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getGuarantor().size(); i++) {
      composeAccountGuarantorComponent(t, "Account", "guarantor", element.getGuarantor().get(i), i);
    }
    for (int i = 0; i < element.getRelatedAccount().size(); i++) {
      composeAccountRelatedAccountComponent(t, "Account", "relatedAccount", element.getRelatedAccount().get(i), i);
    }
    if (element.hasCurrency()) {
      composeCodeableConcept(t, "Account", "currency", element.getCurrency(), -1);
    }
    for (int i = 0; i < element.getBalance().size(); i++) {
      composeAccountBalanceComponent(t, "Account", "balance", element.getBalance().get(i), i);
    }
    if (element.hasCalculatedAtElement()) {
      composeInstant(t, "Account", "calculatedAt", element.getCalculatedAtElement(), -1);
    }
  }

  protected void composeAccountCoverageComponent(Complex parent, String parentType, String name, Account.CoverageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "coverage", name, element, index);
    if (element.hasCoverage()) {
      composeReference(t, "CoverageComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasPriorityElement()) {
      composePositiveInt(t, "CoverageComponent", "priority", element.getPriorityElement(), -1);
    }
  }

  protected void composeAccountGuarantorComponent(Complex parent, String parentType, String name, Account.GuarantorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "guarantor", name, element, index);
    if (element.hasParty()) {
      composeReference(t, "GuarantorComponent", "party", element.getParty(), -1);
    }
    if (element.hasOnHoldElement()) {
      composeBoolean(t, "GuarantorComponent", "onHold", element.getOnHoldElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "GuarantorComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeAccountRelatedAccountComponent(Complex parent, String parentType, String name, Account.AccountRelatedAccountComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatedAccount", name, element, index);
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "AccountRelatedAccountComponent", "relationship", element.getRelationship(), -1);
    }
    if (element.hasAccount()) {
      composeReference(t, "AccountRelatedAccountComponent", "account", element.getAccount(), -1);
    }
  }

  protected void composeAccountBalanceComponent(Complex parent, String parentType, String name, Account.AccountBalanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "balance", name, element, index);
    if (element.hasAggregate()) {
      composeCodeableConcept(t, "AccountBalanceComponent", "aggregate", element.getAggregate(), -1);
    }
    if (element.hasTerm()) {
      composeCodeableConcept(t, "AccountBalanceComponent", "term", element.getTerm(), -1);
    }
    if (element.hasEstimateElement()) {
      composeBoolean(t, "AccountBalanceComponent", "estimate", element.getEstimateElement(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "AccountBalanceComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeActivityDefinition(Complex parent, String parentType, String name, ActivityDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "ActivityDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ActivityDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ActivityDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ActivityDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ActivityDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ActivityDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "ActivityDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ActivityDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ActivityDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "ActivityDefinition", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ActivityDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ActivityDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ActivityDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ActivityDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ActivityDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ActivityDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "ActivityDefinition", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ActivityDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ActivityDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ActivityDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "ActivityDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "ActivityDefinition", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "ActivityDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "ActivityDefinition", "library", element.getLibrary().get(i), i);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "ActivityDefinition", "kind", element.getKindElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "ActivityDefinition", "profile", element.getProfileElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ActivityDefinition", "code", element.getCode(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "ActivityDefinition", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "ActivityDefinition", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "ActivityDefinition", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "ActivityDefinition", "timing", element.getTiming(), -1);
    }
    if (element.hasAsNeeded()) {
      composeType(t, "ActivityDefinition", "asNeeded", element.getAsNeeded(), -1);
    }
    if (element.hasLocation()) {
      composeCodeableReference(t, "ActivityDefinition", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeActivityDefinitionParticipantComponent(t, "ActivityDefinition", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasProduct()) {
      composeType(t, "ActivityDefinition", "product", element.getProduct(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ActivityDefinition", "quantity", element.getQuantity(), -1);
    }
    for (int i = 0; i < element.getDosage().size(); i++) {
      composeDosage(t, "ActivityDefinition", "dosage", element.getDosage().get(i), i);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeCodeableConcept(t, "ActivityDefinition", "bodySite", element.getBodySite().get(i), i);
    }
    for (int i = 0; i < element.getSpecimenRequirement().size(); i++) {
      composeCanonical(t, "ActivityDefinition", "specimenRequirement", element.getSpecimenRequirement().get(i), i);
    }
    for (int i = 0; i < element.getObservationRequirement().size(); i++) {
      composeCanonical(t, "ActivityDefinition", "observationRequirement", element.getObservationRequirement().get(i), i);
    }
    for (int i = 0; i < element.getObservationResultRequirement().size(); i++) {
      composeCanonical(t, "ActivityDefinition", "observationResultRequirement", element.getObservationResultRequirement().get(i), i);
    }
    if (element.hasTransformElement()) {
      composeCanonical(t, "ActivityDefinition", "transform", element.getTransformElement(), -1);
    }
    for (int i = 0; i < element.getDynamicValue().size(); i++) {
      composeActivityDefinitionDynamicValueComponent(t, "ActivityDefinition", "dynamicValue", element.getDynamicValue().get(i), i);
    }
  }

  protected void composeActivityDefinitionParticipantComponent(Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "ActivityDefinitionParticipantComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTypeCanonicalElement()) {
      composeCanonical(t, "ActivityDefinitionParticipantComponent", "typeCanonical", element.getTypeCanonicalElement(), -1);
    }
    if (element.hasTypeReference()) {
      composeReference(t, "ActivityDefinitionParticipantComponent", "typeReference", element.getTypeReference(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "ActivityDefinitionParticipantComponent", "role", element.getRole(), -1);
    }
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ActivityDefinitionParticipantComponent", "function", element.getFunction(), -1);
    }
  }

  protected void composeActivityDefinitionDynamicValueComponent(Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionDynamicValueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dynamicValue", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "ActivityDefinitionDynamicValueComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "ActivityDefinitionDynamicValueComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composeActorDefinition(Complex parent, String parentType, String name, ActorDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "ActorDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ActorDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ActorDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ActorDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ActorDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ActorDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ActorDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ActorDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ActorDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ActorDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ActorDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ActorDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ActorDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ActorDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ActorDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ActorDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCopyrightLabelElement()) {
      composeString(t, "ActorDefinition", "copyrightLabel", element.getCopyrightLabelElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ActorDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "ActorDefinition", "documentation", element.getDocumentationElement(), -1);
    }
    for (int i = 0; i < element.getReference().size(); i++) {
      composeUrl(t, "ActorDefinition", "reference", element.getReference().get(i), i);
    }
    if (element.hasCapabilitiesElement()) {
      composeCanonical(t, "ActorDefinition", "capabilities", element.getCapabilitiesElement(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeCanonical(t, "ActorDefinition", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
  }

  protected void composeAdministrableProductDefinition(Complex parent, String parentType, String name, AdministrableProductDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AdministrableProductDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "AdministrableProductDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "AdministrableProductDefinition", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getFormOf().size(); i++) {
      composeReference(t, "AdministrableProductDefinition", "formOf", element.getFormOf().get(i), i);
    }
    if (element.hasAdministrableDoseForm()) {
      composeCodeableConcept(t, "AdministrableProductDefinition", "administrableDoseForm", element.getAdministrableDoseForm(), -1);
    }
    if (element.hasUnitOfPresentation()) {
      composeCodeableConcept(t, "AdministrableProductDefinition", "unitOfPresentation", element.getUnitOfPresentation(), -1);
    }
    for (int i = 0; i < element.getProducedFrom().size(); i++) {
      composeReference(t, "AdministrableProductDefinition", "producedFrom", element.getProducedFrom().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeCodeableConcept(t, "AdministrableProductDefinition", "ingredient", element.getIngredient().get(i), i);
    }
    if (element.hasDevice()) {
      composeReference(t, "AdministrableProductDefinition", "device", element.getDevice(), -1);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeAdministrableProductDefinitionPropertyComponent(t, "AdministrableProductDefinition", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getRouteOfAdministration().size(); i++) {
      composeAdministrableProductDefinitionRouteOfAdministrationComponent(t, "AdministrableProductDefinition", "routeOfAdministration", element.getRouteOfAdministration().get(i), i);
    }
  }

  protected void composeAdministrableProductDefinitionPropertyComponent(Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionPropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "AdministrableProductDefinitionPropertyComponent", "value", element.getValue(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionPropertyComponent", "status", element.getStatus(), -1);
    }
  }

  protected void composeAdministrableProductDefinitionRouteOfAdministrationComponent(Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "routeOfAdministration", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "code", element.getCode(), -1);
    }
    if (element.hasFirstDose()) {
      composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "firstDose", element.getFirstDose(), -1);
    }
    if (element.hasMaxSingleDose()) {
      composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxSingleDose", element.getMaxSingleDose(), -1);
    }
    if (element.hasMaxDosePerDay()) {
      composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxDosePerDay", element.getMaxDosePerDay(), -1);
    }
    if (element.hasMaxDosePerTreatmentPeriod()) {
      composeRatio(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxDosePerTreatmentPeriod", element.getMaxDosePerTreatmentPeriod(), -1);
    }
    if (element.hasMaxTreatmentPeriod()) {
      composeDuration(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxTreatmentPeriod", element.getMaxTreatmentPeriod(), -1);
    }
    for (int i = 0; i < element.getTargetSpecies().size(); i++) {
      composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "targetSpecies", element.getTargetSpecies().get(i), i);
    }
  }

  protected void composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "targetSpecies", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getWithdrawalPeriod().size(); i++) {
      composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent", "withdrawalPeriod", element.getWithdrawalPeriod().get(i), i);
    }
  }

  protected void composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "withdrawalPeriod", name, element, index);
    if (element.hasTissue()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "tissue", element.getTissue(), -1);
    }
    if (element.hasValue()) {
      composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "value", element.getValue(), -1);
    }
    if (element.hasSupportingInformationElement()) {
      composeString(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "supportingInformation", element.getSupportingInformationElement(), -1);
    }
  }

  protected void composeAdverseEvent(Complex parent, String parentType, String name, AdverseEvent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AdverseEvent", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "AdverseEvent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "AdverseEvent", "status", element.getStatusElement(), -1);
    }
    if (element.hasActualityElement()) {
      composeEnum(t, "AdverseEvent", "actuality", element.getActualityElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "AdverseEvent", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "AdverseEvent", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "AdverseEvent", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "AdverseEvent", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "AdverseEvent", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasDetectedElement()) {
      composeDateTime(t, "AdverseEvent", "detected", element.getDetectedElement(), -1);
    }
    if (element.hasRecordedDateElement()) {
      composeDateTime(t, "AdverseEvent", "recordedDate", element.getRecordedDateElement(), -1);
    }
    for (int i = 0; i < element.getResultingEffect().size(); i++) {
      composeReference(t, "AdverseEvent", "resultingEffect", element.getResultingEffect().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "AdverseEvent", "location", element.getLocation(), -1);
    }
    if (element.hasSeriousness()) {
      composeCodeableConcept(t, "AdverseEvent", "seriousness", element.getSeriousness(), -1);
    }
    for (int i = 0; i < element.getOutcome().size(); i++) {
      composeCodeableConcept(t, "AdverseEvent", "outcome", element.getOutcome().get(i), i);
    }
    if (element.hasRecorder()) {
      composeReference(t, "AdverseEvent", "recorder", element.getRecorder(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeAdverseEventParticipantComponent(t, "AdverseEvent", "participant", element.getParticipant().get(i), i);
    }
    for (int i = 0; i < element.getStudy().size(); i++) {
      composeReference(t, "AdverseEvent", "study", element.getStudy().get(i), i);
    }
    if (element.hasExpectedInResearchStudyElement()) {
      composeBoolean(t, "AdverseEvent", "expectedInResearchStudy", element.getExpectedInResearchStudyElement(), -1);
    }
    for (int i = 0; i < element.getSuspectEntity().size(); i++) {
      composeAdverseEventSuspectEntityComponent(t, "AdverseEvent", "suspectEntity", element.getSuspectEntity().get(i), i);
    }
    for (int i = 0; i < element.getContributingFactor().size(); i++) {
      composeAdverseEventContributingFactorComponent(t, "AdverseEvent", "contributingFactor", element.getContributingFactor().get(i), i);
    }
    for (int i = 0; i < element.getPreventiveAction().size(); i++) {
      composeAdverseEventPreventiveActionComponent(t, "AdverseEvent", "preventiveAction", element.getPreventiveAction().get(i), i);
    }
    for (int i = 0; i < element.getMitigatingAction().size(); i++) {
      composeAdverseEventMitigatingActionComponent(t, "AdverseEvent", "mitigatingAction", element.getMitigatingAction().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeAdverseEventSupportingInfoComponent(t, "AdverseEvent", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "AdverseEvent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeAdverseEventParticipantComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "AdverseEventParticipantComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "AdverseEventParticipantComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeAdverseEventSuspectEntityComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "suspectEntity", name, element, index);
    if (element.hasInstance()) {
      composeType(t, "AdverseEventSuspectEntityComponent", "instance", element.getInstance(), -1);
    }
    if (element.hasCausality()) {
      composeAdverseEventSuspectEntityCausalityComponent(t, "AdverseEventSuspectEntityComponent", "causality", element.getCausality(), -1);
    }
  }

  protected void composeAdverseEventSuspectEntityCausalityComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityCausalityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "causality", name, element, index);
    if (element.hasAssessmentMethod()) {
      composeCodeableConcept(t, "AdverseEventSuspectEntityCausalityComponent", "assessmentMethod", element.getAssessmentMethod(), -1);
    }
    if (element.hasEntityRelatedness()) {
      composeCodeableConcept(t, "AdverseEventSuspectEntityCausalityComponent", "entityRelatedness", element.getEntityRelatedness(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "AdverseEventSuspectEntityCausalityComponent", "author", element.getAuthor(), -1);
    }
  }

  protected void composeAdverseEventContributingFactorComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventContributingFactorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contributingFactor", name, element, index);
    if (element.hasItem()) {
      composeType(t, "AdverseEventContributingFactorComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeAdverseEventPreventiveActionComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventPreventiveActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "preventiveAction", name, element, index);
    if (element.hasItem()) {
      composeType(t, "AdverseEventPreventiveActionComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeAdverseEventMitigatingActionComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventMitigatingActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "mitigatingAction", name, element, index);
    if (element.hasItem()) {
      composeType(t, "AdverseEventMitigatingActionComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeAdverseEventSupportingInfoComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventSupportingInfoComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportingInfo", name, element, index);
    if (element.hasItem()) {
      composeType(t, "AdverseEventSupportingInfoComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeAllergyIntolerance(Complex parent, String parentType, String name, AllergyIntolerance element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AllergyIntolerance", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "AllergyIntolerance", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasClinicalStatus()) {
      composeCodeableConcept(t, "AllergyIntolerance", "clinicalStatus", element.getClinicalStatus(), -1);
    }
    if (element.hasVerificationStatus()) {
      composeCodeableConcept(t, "AllergyIntolerance", "verificationStatus", element.getVerificationStatus(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "AllergyIntolerance", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeEnum(t, "AllergyIntolerance", "category", element.getCategory().get(i), i);
    }
    if (element.hasCriticalityElement()) {
      composeEnum(t, "AllergyIntolerance", "criticality", element.getCriticalityElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "AllergyIntolerance", "code", element.getCode(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "AllergyIntolerance", "patient", element.getPatient(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "AllergyIntolerance", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOnset()) {
      composeType(t, "AllergyIntolerance", "onset", element.getOnset(), -1);
    }
    if (element.hasRecordedDateElement()) {
      composeDateTime(t, "AllergyIntolerance", "recordedDate", element.getRecordedDateElement(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeAllergyIntoleranceParticipantComponent(t, "AllergyIntolerance", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasLastOccurrenceElement()) {
      composeDateTime(t, "AllergyIntolerance", "lastOccurrence", element.getLastOccurrenceElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getReaction().size(); i++) {
      composeAllergyIntoleranceReactionComponent(t, "AllergyIntolerance", "reaction", element.getReaction().get(i), i);
    }
  }

  protected void composeAllergyIntoleranceParticipantComponent(Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "AllergyIntoleranceParticipantComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "AllergyIntoleranceParticipantComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeAllergyIntoleranceReactionComponent(Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "reaction", name, element, index);
    if (element.hasSubstance()) {
      composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "substance", element.getSubstance(), -1);
    }
    for (int i = 0; i < element.getManifestation().size(); i++) {
      composeCodeableReference(t, "AllergyIntoleranceReactionComponent", "manifestation", element.getManifestation().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "AllergyIntoleranceReactionComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasOnsetElement()) {
      composeDateTime(t, "AllergyIntoleranceReactionComponent", "onset", element.getOnsetElement(), -1);
    }
    if (element.hasSeverityElement()) {
      composeEnum(t, "AllergyIntoleranceReactionComponent", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasExposureRoute()) {
      composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "exposureRoute", element.getExposureRoute(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "AllergyIntoleranceReactionComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeAppointment(Complex parent, String parentType, String name, Appointment element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Appointment", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Appointment", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
    }
    if (element.hasCancellationReason()) {
      composeCodeableConcept(t, "Appointment", "cancellationReason", element.getCancellationReason(), -1);
    }
    for (int i = 0; i < element.getClass_().size(); i++) {
      composeCodeableConcept(t, "Appointment", "class", element.getClass_().get(i), i);
    }
    for (int i = 0; i < element.getServiceCategory().size(); i++) {
      composeCodeableConcept(t, "Appointment", "serviceCategory", element.getServiceCategory().get(i), i);
    }
    for (int i = 0; i < element.getServiceType().size(); i++) {
      composeCodeableReference(t, "Appointment", "serviceType", element.getServiceType().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "Appointment", "specialty", element.getSpecialty().get(i), i);
    }
    if (element.hasAppointmentType()) {
      composeCodeableConcept(t, "Appointment", "appointmentType", element.getAppointmentType(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "Appointment", "reason", element.getReason().get(i), i);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "Appointment", "priority", element.getPriority(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Appointment", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "Appointment", "replaces", element.getReplaces().get(i), i);
    }
    for (int i = 0; i < element.getVirtualService().size(); i++) {
      composeVirtualServiceDetail(t, "Appointment", "virtualService", element.getVirtualService().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "Appointment", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    if (element.hasPreviousAppointment()) {
      composeReference(t, "Appointment", "previousAppointment", element.getPreviousAppointment(), -1);
    }
    if (element.hasOriginatingAppointment()) {
      composeReference(t, "Appointment", "originatingAppointment", element.getOriginatingAppointment(), -1);
    }
    if (element.hasStartElement()) {
      composeInstant(t, "Appointment", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInstant(t, "Appointment", "end", element.getEndElement(), -1);
    }
    if (element.hasMinutesDurationElement()) {
      composePositiveInt(t, "Appointment", "minutesDuration", element.getMinutesDurationElement(), -1);
    }
    for (int i = 0; i < element.getSlot().size(); i++) {
      composeReference(t, "Appointment", "slot", element.getSlot().get(i), i);
    }
    for (int i = 0; i < element.getAccount().size(); i++) {
      composeReference(t, "Appointment", "account", element.getAccount().get(i), i);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "Appointment", "created", element.getCreatedElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Appointment", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getPatientInstruction().size(); i++) {
      composeCodeableReference(t, "Appointment", "patientInstruction", element.getPatientInstruction().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Appointment", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "Appointment", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeAppointmentParticipantComponent(t, "Appointment", "participant", element.getParticipant().get(i), i);
    }
    for (int i = 0; i < element.getRequestedPeriod().size(); i++) {
      composePeriod(t, "Appointment", "requestedPeriod", element.getRequestedPeriod().get(i), i);
    }
    if (element.hasRecurrenceIdElement()) {
      composePositiveInt(t, "Appointment", "recurrenceId", element.getRecurrenceIdElement(), -1);
    }
    if (element.hasOccurrenceChangedElement()) {
      composeBoolean(t, "Appointment", "occurrenceChanged", element.getOccurrenceChangedElement(), -1);
    }
    for (int i = 0; i < element.getRecurrenceTemplate().size(); i++) {
      composeAppointmentRecurrenceTemplateComponent(t, "Appointment", "recurrenceTemplate", element.getRecurrenceTemplate().get(i), i);
    }
  }

  protected void composeAppointmentParticipantComponent(Complex parent, String parentType, String name, Appointment.AppointmentParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "AppointmentParticipantComponent", "type", element.getType().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "AppointmentParticipantComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "AppointmentParticipantComponent", "actor", element.getActor(), -1);
    }
    if (element.hasRequiredElement()) {
      composeBoolean(t, "AppointmentParticipantComponent", "required", element.getRequiredElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "AppointmentParticipantComponent", "status", element.getStatusElement(), -1);
    }
  }

  protected void composeAppointmentRecurrenceTemplateComponent(Complex parent, String parentType, String name, Appointment.AppointmentRecurrenceTemplateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "recurrenceTemplate", name, element, index);
    if (element.hasTimezone()) {
      composeCodeableConcept(t, "AppointmentRecurrenceTemplateComponent", "timezone", element.getTimezone(), -1);
    }
    if (element.hasRecurrenceType()) {
      composeCodeableConcept(t, "AppointmentRecurrenceTemplateComponent", "recurrenceType", element.getRecurrenceType(), -1);
    }
    if (element.hasLastOccurrenceDateElement()) {
      composeDate(t, "AppointmentRecurrenceTemplateComponent", "lastOccurrenceDate", element.getLastOccurrenceDateElement(), -1);
    }
    if (element.hasOccurrenceCountElement()) {
      composePositiveInt(t, "AppointmentRecurrenceTemplateComponent", "occurrenceCount", element.getOccurrenceCountElement(), -1);
    }
    for (int i = 0; i < element.getOccurrenceDate().size(); i++) {
      composeDate(t, "AppointmentRecurrenceTemplateComponent", "occurrenceDate", element.getOccurrenceDate().get(i), i);
    }
    if (element.hasWeeklyTemplate()) {
      composeAppointmentRecurrenceTemplateWeeklyTemplateComponent(t, "AppointmentRecurrenceTemplateComponent", "weeklyTemplate", element.getWeeklyTemplate(), -1);
    }
    if (element.hasMonthlyTemplate()) {
      composeAppointmentRecurrenceTemplateMonthlyTemplateComponent(t, "AppointmentRecurrenceTemplateComponent", "monthlyTemplate", element.getMonthlyTemplate(), -1);
    }
    if (element.hasYearlyTemplate()) {
      composeAppointmentRecurrenceTemplateYearlyTemplateComponent(t, "AppointmentRecurrenceTemplateComponent", "yearlyTemplate", element.getYearlyTemplate(), -1);
    }
    for (int i = 0; i < element.getExcludingDate().size(); i++) {
      composeDate(t, "AppointmentRecurrenceTemplateComponent", "excludingDate", element.getExcludingDate().get(i), i);
    }
    for (int i = 0; i < element.getExcludingRecurrenceId().size(); i++) {
      composePositiveInt(t, "AppointmentRecurrenceTemplateComponent", "excludingRecurrenceId", element.getExcludingRecurrenceId().get(i), i);
    }
  }

  protected void composeAppointmentRecurrenceTemplateWeeklyTemplateComponent(Complex parent, String parentType, String name, Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "weeklyTemplate", name, element, index);
    if (element.hasMondayElement()) {
      composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "monday", element.getMondayElement(), -1);
    }
    if (element.hasTuesdayElement()) {
      composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "tuesday", element.getTuesdayElement(), -1);
    }
    if (element.hasWednesdayElement()) {
      composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "wednesday", element.getWednesdayElement(), -1);
    }
    if (element.hasThursdayElement()) {
      composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "thursday", element.getThursdayElement(), -1);
    }
    if (element.hasFridayElement()) {
      composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "friday", element.getFridayElement(), -1);
    }
    if (element.hasSaturdayElement()) {
      composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "saturday", element.getSaturdayElement(), -1);
    }
    if (element.hasSundayElement()) {
      composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "sunday", element.getSundayElement(), -1);
    }
    if (element.hasWeekIntervalElement()) {
      composePositiveInt(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "weekInterval", element.getWeekIntervalElement(), -1);
    }
  }

  protected void composeAppointmentRecurrenceTemplateMonthlyTemplateComponent(Complex parent, String parentType, String name, Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "monthlyTemplate", name, element, index);
    if (element.hasDayOfMonthElement()) {
      composePositiveInt(t, "AppointmentRecurrenceTemplateMonthlyTemplateComponent", "dayOfMonth", element.getDayOfMonthElement(), -1);
    }
    if (element.hasNthWeekOfMonth()) {
      composeCoding(t, "AppointmentRecurrenceTemplateMonthlyTemplateComponent", "nthWeekOfMonth", element.getNthWeekOfMonth(), -1);
    }
    if (element.hasDayOfWeek()) {
      composeCoding(t, "AppointmentRecurrenceTemplateMonthlyTemplateComponent", "dayOfWeek", element.getDayOfWeek(), -1);
    }
    if (element.hasMonthIntervalElement()) {
      composePositiveInt(t, "AppointmentRecurrenceTemplateMonthlyTemplateComponent", "monthInterval", element.getMonthIntervalElement(), -1);
    }
  }

  protected void composeAppointmentRecurrenceTemplateYearlyTemplateComponent(Complex parent, String parentType, String name, Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "yearlyTemplate", name, element, index);
    if (element.hasYearIntervalElement()) {
      composePositiveInt(t, "AppointmentRecurrenceTemplateYearlyTemplateComponent", "yearInterval", element.getYearIntervalElement(), -1);
    }
  }

  protected void composeAppointmentResponse(Complex parent, String parentType, String name, AppointmentResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AppointmentResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "AppointmentResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasAppointment()) {
      composeReference(t, "AppointmentResponse", "appointment", element.getAppointment(), -1);
    }
    if (element.hasProposedNewTimeElement()) {
      composeBoolean(t, "AppointmentResponse", "proposedNewTime", element.getProposedNewTimeElement(), -1);
    }
    if (element.hasStartElement()) {
      composeInstant(t, "AppointmentResponse", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInstant(t, "AppointmentResponse", "end", element.getEndElement(), -1);
    }
    for (int i = 0; i < element.getParticipantType().size(); i++) {
      composeCodeableConcept(t, "AppointmentResponse", "participantType", element.getParticipantType().get(i), i);
    }
    if (element.hasActor()) {
      composeReference(t, "AppointmentResponse", "actor", element.getActor(), -1);
    }
    if (element.hasParticipantStatusElement()) {
      composeEnum(t, "AppointmentResponse", "participantStatus", element.getParticipantStatusElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "AppointmentResponse", "comment", element.getCommentElement(), -1);
    }
    if (element.hasRecurringElement()) {
      composeBoolean(t, "AppointmentResponse", "recurring", element.getRecurringElement(), -1);
    }
    if (element.hasOccurrenceDateElement()) {
      composeDate(t, "AppointmentResponse", "occurrenceDate", element.getOccurrenceDateElement(), -1);
    }
    if (element.hasRecurrenceIdElement()) {
      composePositiveInt(t, "AppointmentResponse", "recurrenceId", element.getRecurrenceIdElement(), -1);
    }
  }

  protected void composeArtifactAssessment(Complex parent, String parentType, String name, ArtifactAssessment element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ArtifactAssessment", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ArtifactAssessment", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCiteAs()) {
      composeType(t, "ArtifactAssessment", "citeAs", element.getCiteAs(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ArtifactAssessment", "date", element.getDateElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ArtifactAssessment", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ArtifactAssessment", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ArtifactAssessment", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasArtifact()) {
      composeType(t, "ArtifactAssessment", "artifact", element.getArtifact(), -1);
    }
    for (int i = 0; i < element.getContent().size(); i++) {
      composeArtifactAssessmentContentComponent(t, "ArtifactAssessment", "content", element.getContent().get(i), i);
    }
    if (element.hasWorkflowStatusElement()) {
      composeEnum(t, "ArtifactAssessment", "workflowStatus", element.getWorkflowStatusElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeEnum(t, "ArtifactAssessment", "disposition", element.getDispositionElement(), -1);
    }
  }

  protected void composeArtifactAssessmentContentComponent(Complex parent, String parentType, String name, ArtifactAssessment.ArtifactAssessmentContentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "content", name, element, index);
    if (element.hasInformationTypeElement()) {
      composeEnum(t, "ArtifactAssessmentContentComponent", "informationType", element.getInformationTypeElement(), -1);
    }
    if (element.hasSummaryElement()) {
      composeMarkdown(t, "ArtifactAssessmentContentComponent", "summary", element.getSummaryElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ArtifactAssessmentContentComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "ArtifactAssessmentContentComponent", "classifier", element.getClassifier().get(i), i);
    }
    if (element.hasAuthor()) {
      composeReference(t, "ArtifactAssessmentContentComponent", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getPath().size(); i++) {
      composeUri(t, "ArtifactAssessmentContentComponent", "path", element.getPath().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "ArtifactAssessmentContentComponent", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasFreeToShareElement()) {
      composeBoolean(t, "ArtifactAssessmentContentComponent", "freeToShare", element.getFreeToShareElement(), -1);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeArtifactAssessmentContentComponent(t, "ArtifactAssessmentContentComponent", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeAuditEvent(Complex parent, String parentType, String name, AuditEvent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AuditEvent", name, element, index);
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "AuditEvent", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "AuditEvent", "code", element.getCode(), -1);
    }
    if (element.hasActionElement()) {
      composeEnum(t, "AuditEvent", "action", element.getActionElement(), -1);
    }
    if (element.hasSeverityElement()) {
      composeEnum(t, "AuditEvent", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasOccurred()) {
      composeType(t, "AuditEvent", "occurred", element.getOccurred(), -1);
    }
    if (element.hasRecordedElement()) {
      composeInstant(t, "AuditEvent", "recorded", element.getRecordedElement(), -1);
    }
    if (element.hasOutcome()) {
      composeAuditEventOutcomeComponent(t, "AuditEvent", "outcome", element.getOutcome(), -1);
    }
    for (int i = 0; i < element.getAuthorization().size(); i++) {
      composeCodeableConcept(t, "AuditEvent", "authorization", element.getAuthorization().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "AuditEvent", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "AuditEvent", "patient", element.getPatient(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "AuditEvent", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getAgent().size(); i++) {
      composeAuditEventAgentComponent(t, "AuditEvent", "agent", element.getAgent().get(i), i);
    }
    if (element.hasSource()) {
      composeAuditEventSourceComponent(t, "AuditEvent", "source", element.getSource(), -1);
    }
    for (int i = 0; i < element.getEntity().size(); i++) {
      composeAuditEventEntityComponent(t, "AuditEvent", "entity", element.getEntity().get(i), i);
    }
  }

  protected void composeAuditEventOutcomeComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventOutcomeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "outcome", name, element, index);
    if (element.hasCode()) {
      composeCoding(t, "AuditEventOutcomeComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeCodeableConcept(t, "AuditEventOutcomeComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeAuditEventAgentComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventAgentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "agent", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "AuditEventAgentComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getRole().size(); i++) {
      composeCodeableConcept(t, "AuditEventAgentComponent", "role", element.getRole().get(i), i);
    }
    if (element.hasWho()) {
      composeReference(t, "AuditEventAgentComponent", "who", element.getWho(), -1);
    }
    if (element.hasRequestorElement()) {
      composeBoolean(t, "AuditEventAgentComponent", "requestor", element.getRequestorElement(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "AuditEventAgentComponent", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getPolicy().size(); i++) {
      composeUri(t, "AuditEventAgentComponent", "policy", element.getPolicy().get(i), i);
    }
    if (element.hasNetwork()) {
      composeType(t, "AuditEventAgentComponent", "network", element.getNetwork(), -1);
    }
    for (int i = 0; i < element.getAuthorization().size(); i++) {
      composeCodeableConcept(t, "AuditEventAgentComponent", "authorization", element.getAuthorization().get(i), i);
    }
  }

  protected void composeAuditEventSourceComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventSourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "source", name, element, index);
    if (element.hasSite()) {
      composeReference(t, "AuditEventSourceComponent", "site", element.getSite(), -1);
    }
    if (element.hasObserver()) {
      composeReference(t, "AuditEventSourceComponent", "observer", element.getObserver(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "AuditEventSourceComponent", "type", element.getType().get(i), i);
    }
  }

  protected void composeAuditEventEntityComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventEntityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entity", name, element, index);
    if (element.hasWhat()) {
      composeReference(t, "AuditEventEntityComponent", "what", element.getWhat(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "AuditEventEntityComponent", "role", element.getRole(), -1);
    }
    for (int i = 0; i < element.getSecurityLabel().size(); i++) {
      composeCodeableConcept(t, "AuditEventEntityComponent", "securityLabel", element.getSecurityLabel().get(i), i);
    }
    if (element.hasQueryElement()) {
      composeBase64Binary(t, "AuditEventEntityComponent", "query", element.getQueryElement(), -1);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeAuditEventEntityDetailComponent(t, "AuditEventEntityComponent", "detail", element.getDetail().get(i), i);
    }
    for (int i = 0; i < element.getAgent().size(); i++) {
      composeAuditEventAgentComponent(t, "AuditEventEntityComponent", "agent", element.getAgent().get(i), i);
    }
  }

  protected void composeAuditEventEntityDetailComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventEntityDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "AuditEventEntityDetailComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "AuditEventEntityDetailComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeBasic(Complex parent, String parentType, String name, Basic element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Basic", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Basic", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Basic", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Basic", "subject", element.getSubject(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "Basic", "created", element.getCreatedElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "Basic", "author", element.getAuthor(), -1);
    }
  }

  protected void composeBinary(Complex parent, String parentType, String name, Binary element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeResource(t, "Binary", name, element, index);
    if (element.hasContentTypeElement()) {
      composeCode(t, "Binary", "contentType", element.getContentTypeElement(), -1);
    }
    if (element.hasSecurityContext()) {
      composeReference(t, "Binary", "securityContext", element.getSecurityContext(), -1);
    }
    if (element.hasDataElement()) {
      composeBase64Binary(t, "Binary", "data", element.getDataElement(), -1);
    }
  }

  protected void composeBiologicallyDerivedProduct(Complex parent, String parentType, String name, BiologicallyDerivedProduct element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "BiologicallyDerivedProduct", name, element, index);
    if (element.hasProductCategory()) {
      composeCoding(t, "BiologicallyDerivedProduct", "productCategory", element.getProductCategory(), -1);
    }
    if (element.hasProductCode()) {
      composeCodeableConcept(t, "BiologicallyDerivedProduct", "productCode", element.getProductCode(), -1);
    }
    for (int i = 0; i < element.getParent().size(); i++) {
      composeReference(t, "BiologicallyDerivedProduct", "parent", element.getParent().get(i), i);
    }
    for (int i = 0; i < element.getRequest().size(); i++) {
      composeReference(t, "BiologicallyDerivedProduct", "request", element.getRequest().get(i), i);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "BiologicallyDerivedProduct", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasBiologicalSourceEvent()) {
      composeIdentifier(t, "BiologicallyDerivedProduct", "biologicalSourceEvent", element.getBiologicalSourceEvent(), -1);
    }
    for (int i = 0; i < element.getProcessingFacility().size(); i++) {
      composeReference(t, "BiologicallyDerivedProduct", "processingFacility", element.getProcessingFacility().get(i), i);
    }
    if (element.hasDivisionElement()) {
      composeString(t, "BiologicallyDerivedProduct", "division", element.getDivisionElement(), -1);
    }
    if (element.hasProductStatus()) {
      composeCoding(t, "BiologicallyDerivedProduct", "productStatus", element.getProductStatus(), -1);
    }
    if (element.hasExpirationDateElement()) {
      composeDateTime(t, "BiologicallyDerivedProduct", "expirationDate", element.getExpirationDateElement(), -1);
    }
    if (element.hasCollection()) {
      composeBiologicallyDerivedProductCollectionComponent(t, "BiologicallyDerivedProduct", "collection", element.getCollection(), -1);
    }
    if (element.hasStorageTempRequirements()) {
      composeRange(t, "BiologicallyDerivedProduct", "storageTempRequirements", element.getStorageTempRequirements(), -1);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeBiologicallyDerivedProductPropertyComponent(t, "BiologicallyDerivedProduct", "property", element.getProperty().get(i), i);
    }
  }

  protected void composeBiologicallyDerivedProductCollectionComponent(Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "collection", name, element, index);
    if (element.hasCollector()) {
      composeReference(t, "BiologicallyDerivedProductCollectionComponent", "collector", element.getCollector(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "BiologicallyDerivedProductCollectionComponent", "source", element.getSource(), -1);
    }
    if (element.hasCollected()) {
      composeType(t, "BiologicallyDerivedProductCollectionComponent", "collected", element.getCollected(), -1);
    }
  }

  protected void composeBiologicallyDerivedProductPropertyComponent(Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCoding(t, "BiologicallyDerivedProductPropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "BiologicallyDerivedProductPropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeBodyStructure(Complex parent, String parentType, String name, BodyStructure element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "BodyStructure", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "BodyStructure", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "BodyStructure", "active", element.getActiveElement(), -1);
    }
    if (element.hasMorphology()) {
      composeCodeableConcept(t, "BodyStructure", "morphology", element.getMorphology(), -1);
    }
    for (int i = 0; i < element.getIncludedStructure().size(); i++) {
      composeBodyStructureIncludedStructureComponent(t, "BodyStructure", "includedStructure", element.getIncludedStructure().get(i), i);
    }
    for (int i = 0; i < element.getExcludedStructure().size(); i++) {
      composeBodyStructureExcludedStructureComponent(t, "BodyStructure", "excludedStructure", element.getExcludedStructure().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "BodyStructure", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getImage().size(); i++) {
      composeAttachment(t, "BodyStructure", "image", element.getImage().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "BodyStructure", "patient", element.getPatient(), -1);
    }
  }

  protected void composeBodyStructureIncludedStructureComponent(Complex parent, String parentType, String name, BodyStructure.BodyStructureIncludedStructureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "includedStructure", name, element, index);
    if (element.hasStructure()) {
      composeCodeableConcept(t, "BodyStructureIncludedStructureComponent", "structure", element.getStructure(), -1);
    }
    if (element.hasLaterality()) {
      composeCodeableConcept(t, "BodyStructureIncludedStructureComponent", "laterality", element.getLaterality(), -1);
    }
    for (int i = 0; i < element.getQualifier().size(); i++) {
      composeCodeableConcept(t, "BodyStructureIncludedStructureComponent", "qualifier", element.getQualifier().get(i), i);
    }
  }

  protected void composeBodyStructureExcludedStructureComponent(Complex parent, String parentType, String name, BodyStructure.BodyStructureExcludedStructureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "excludedStructure", name, element, index);
    if (element.hasStructure()) {
      composeCodeableConcept(t, "BodyStructureExcludedStructureComponent", "structure", element.getStructure(), -1);
    }
    if (element.hasLaterality()) {
      composeCodeableConcept(t, "BodyStructureExcludedStructureComponent", "laterality", element.getLaterality(), -1);
    }
    for (int i = 0; i < element.getQualifier().size(); i++) {
      composeCodeableConcept(t, "BodyStructureExcludedStructureComponent", "qualifier", element.getQualifier().get(i), i);
    }
  }

  protected void composeBundle(Complex parent, String parentType, String name, Bundle element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeResource(t, "Bundle", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "Bundle", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "Bundle", "type", element.getTypeElement(), -1);
    }
    if (element.hasTimestampElement()) {
      composeInstant(t, "Bundle", "timestamp", element.getTimestampElement(), -1);
    }
    if (element.hasTotalElement()) {
      composeUnsignedInt(t, "Bundle", "total", element.getTotalElement(), -1);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composeBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
    }
    for (int i = 0; i < element.getEntry().size(); i++) {
      composeBundleEntryComponent(t, "Bundle", "entry", element.getEntry().get(i), i);
    }
    if (element.hasSignature()) {
      composeSignature(t, "Bundle", "signature", element.getSignature(), -1);
    }
    if (element.hasIssues()) {
      composeResource(t, "Bundle", "issues", element.getIssues(), -1);
    }
  }

  protected void composeBundleLinkComponent(Complex parent, String parentType, String name, Bundle.BundleLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasRelationElement()) {
      composeEnum(t, "BundleLinkComponent", "relation", element.getRelationElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "BundleLinkComponent", "url", element.getUrlElement(), -1);
    }
  }

  protected void composeBundleEntryComponent(Complex parent, String parentType, String name, Bundle.BundleEntryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entry", name, element, index);
    for (int i = 0; i < element.getLink().size(); i++) {
      composeBundleLinkComponent(t, "BundleEntryComponent", "link", element.getLink().get(i), i);
    }
    if (element.hasFullUrlElement()) {
      composeUri(t, "BundleEntryComponent", "fullUrl", element.getFullUrlElement(), -1);
    }
    if (element.hasResource()) {
      composeResource(t, "BundleEntryComponent", "resource", element.getResource(), -1);
    }
    if (element.hasSearch()) {
      composeBundleEntrySearchComponent(t, "BundleEntryComponent", "search", element.getSearch(), -1);
    }
    if (element.hasRequest()) {
      composeBundleEntryRequestComponent(t, "BundleEntryComponent", "request", element.getRequest(), -1);
    }
    if (element.hasResponse()) {
      composeBundleEntryResponseComponent(t, "BundleEntryComponent", "response", element.getResponse(), -1);
    }
  }

  protected void composeBundleEntrySearchComponent(Complex parent, String parentType, String name, Bundle.BundleEntrySearchComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "search", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "BundleEntrySearchComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasScoreElement()) {
      composeDecimal(t, "BundleEntrySearchComponent", "score", element.getScoreElement(), -1);
    }
  }

  protected void composeBundleEntryRequestComponent(Complex parent, String parentType, String name, Bundle.BundleEntryRequestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "request", name, element, index);
    if (element.hasMethodElement()) {
      composeEnum(t, "BundleEntryRequestComponent", "method", element.getMethodElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "BundleEntryRequestComponent", "url", element.getUrlElement(), -1);
    }
    if (element.hasIfNoneMatchElement()) {
      composeString(t, "BundleEntryRequestComponent", "ifNoneMatch", element.getIfNoneMatchElement(), -1);
    }
    if (element.hasIfModifiedSinceElement()) {
      composeInstant(t, "BundleEntryRequestComponent", "ifModifiedSince", element.getIfModifiedSinceElement(), -1);
    }
    if (element.hasIfMatchElement()) {
      composeString(t, "BundleEntryRequestComponent", "ifMatch", element.getIfMatchElement(), -1);
    }
    if (element.hasIfNoneExistElement()) {
      composeString(t, "BundleEntryRequestComponent", "ifNoneExist", element.getIfNoneExistElement(), -1);
    }
  }

  protected void composeBundleEntryResponseComponent(Complex parent, String parentType, String name, Bundle.BundleEntryResponseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "response", name, element, index);
    if (element.hasStatusElement()) {
      composeString(t, "BundleEntryResponseComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasLocationElement()) {
      composeUri(t, "BundleEntryResponseComponent", "location", element.getLocationElement(), -1);
    }
    if (element.hasEtagElement()) {
      composeString(t, "BundleEntryResponseComponent", "etag", element.getEtagElement(), -1);
    }
    if (element.hasLastModifiedElement()) {
      composeInstant(t, "BundleEntryResponseComponent", "lastModified", element.getLastModifiedElement(), -1);
    }
    if (element.hasOutcome()) {
      composeResource(t, "BundleEntryResponseComponent", "outcome", element.getOutcome(), -1);
    }
  }

  protected void composeCapabilityStatement(Complex parent, String parentType, String name, CapabilityStatement element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "CapabilityStatement", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "CapabilityStatement", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CapabilityStatement", "version", element.getVersionElement(), -1);
    }
    if (element.hasVersionAlgorithm()) {
      composeType(t, "CapabilityStatement", "versionAlgorithm", element.getVersionAlgorithm(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CapabilityStatement", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CapabilityStatement", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "CapabilityStatement", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "CapabilityStatement", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "CapabilityStatement", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "CapabilityStatement", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "CapabilityStatement", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "CapabilityStatement", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "CapabilityStatement", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CapabilityStatement", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCopyrightLabelElement()) {
      composeString(t, "CapabilityStatement", "copyrightLabel", element.getCopyrightLabelElement(), -1);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "CapabilityStatement", "kind", element.getKindElement(), -1);
    }
    for (int i = 0; i < element.getInstantiates().size(); i++) {
      composeCanonical(t, "CapabilityStatement", "instantiates", element.getInstantiates().get(i), i);
    }
    for (int i = 0; i < element.getImports().size(); i++) {
      composeCanonical(t, "CapabilityStatement", "imports", element.getImports().get(i), i);
    }
    if (element.hasSoftware()) {
      composeCapabilityStatementSoftwareComponent(t, "CapabilityStatement", "software", element.getSoftware(), -1);
    }
    if (element.hasImplementation()) {
      composeCapabilityStatementImplementationComponent(t, "CapabilityStatement", "implementation", element.getImplementation(), -1);
    }
    if (element.hasFhirVersionElement()) {
      composeEnum(t, "CapabilityStatement", "fhirVersion", element.getFhirVersionElement(), -1);
    }
    for (int i = 0; i < element.getFormat().size(); i++) {
      composeCode(t, "CapabilityStatement", "format", element.getFormat().get(i), i);
    }
    for (int i = 0; i < element.getPatchFormat().size(); i++) {
      composeCode(t, "CapabilityStatement", "patchFormat", element.getPatchFormat().get(i), i);
    }
    for (int i = 0; i < element.getAcceptLanguage().size(); i++) {
      composeCode(t, "CapabilityStatement", "acceptLanguage", element.getAcceptLanguage().get(i), i);
    }
    for (int i = 0; i < element.getImplementationGuide().size(); i++) {
      composeCanonical(t, "CapabilityStatement", "implementationGuide", element.getImplementationGuide().get(i), i);
    }
    for (int i = 0; i < element.getRest().size(); i++) {
      composeCapabilityStatementRestComponent(t, "CapabilityStatement", "rest", element.getRest().get(i), i);
    }
    for (int i = 0; i < element.getMessaging().size(); i++) {
      composeCapabilityStatementMessagingComponent(t, "CapabilityStatement", "messaging", element.getMessaging().get(i), i);
    }
    for (int i = 0; i < element.getDocument().size(); i++) {
      composeCapabilityStatementDocumentComponent(t, "CapabilityStatement", "document", element.getDocument().get(i), i);
    }
  }

  protected void composeCapabilityStatementSoftwareComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementSoftwareComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "software", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "CapabilityStatementSoftwareComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CapabilityStatementSoftwareComponent", "version", element.getVersionElement(), -1);
    }
    if (element.hasReleaseDateElement()) {
      composeDateTime(t, "CapabilityStatementSoftwareComponent", "releaseDate", element.getReleaseDateElement(), -1);
    }
  }

  protected void composeCapabilityStatementImplementationComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementImplementationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "implementation", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "CapabilityStatementImplementationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUrl(t, "CapabilityStatementImplementationComponent", "url", element.getUrlElement(), -1);
    }
    if (element.hasCustodian()) {
      composeReference(t, "CapabilityStatementImplementationComponent", "custodian", element.getCustodian(), -1);
    }
  }

  protected void composeCapabilityStatementRestComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "rest", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "CapabilityStatementRestComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementRestComponent", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasSecurity()) {
      composeCapabilityStatementRestSecurityComponent(t, "CapabilityStatementRestComponent", "security", element.getSecurity(), -1);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeCapabilityStatementRestResourceComponent(t, "CapabilityStatementRestComponent", "resource", element.getResource().get(i), i);
    }
    for (int i = 0; i < element.getInteraction().size(); i++) {
      composeCapabilityStatementSystemInteractionComponent(t, "CapabilityStatementRestComponent", "interaction", element.getInteraction().get(i), i);
    }
    for (int i = 0; i < element.getSearchParam().size(); i++) {
      composeCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatementRestComponent", "searchParam", element.getSearchParam().get(i), i);
    }
    for (int i = 0; i < element.getOperation().size(); i++) {
      composeCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatementRestComponent", "operation", element.getOperation().get(i), i);
    }
    for (int i = 0; i < element.getCompartment().size(); i++) {
      composeCanonical(t, "CapabilityStatementRestComponent", "compartment", element.getCompartment().get(i), i);
    }
  }

  protected void composeCapabilityStatementRestSecurityComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestSecurityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "security", name, element, index);
    if (element.hasCorsElement()) {
      composeBoolean(t, "CapabilityStatementRestSecurityComponent", "cors", element.getCorsElement(), -1);
    }
    for (int i = 0; i < element.getService().size(); i++) {
      composeCodeableConcept(t, "CapabilityStatementRestSecurityComponent", "service", element.getService().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CapabilityStatementRestSecurityComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeCapabilityStatementRestResourceComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasTypeElement()) {
      composeCode(t, "CapabilityStatementRestResourceComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "CapabilityStatementRestResourceComponent", "profile", element.getProfileElement(), -1);
    }
    for (int i = 0; i < element.getSupportedProfile().size(); i++) {
      composeCanonical(t, "CapabilityStatementRestResourceComponent", "supportedProfile", element.getSupportedProfile().get(i), i);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementRestResourceComponent", "documentation", element.getDocumentationElement(), -1);
    }
    for (int i = 0; i < element.getInteraction().size(); i++) {
      composeCapabilityStatementResourceInteractionComponent(t, "CapabilityStatementRestResourceComponent", "interaction", element.getInteraction().get(i), i);
    }
    if (element.hasVersioningElement()) {
      composeEnum(t, "CapabilityStatementRestResourceComponent", "versioning", element.getVersioningElement(), -1);
    }
    if (element.hasReadHistoryElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "readHistory", element.getReadHistoryElement(), -1);
    }
    if (element.hasUpdateCreateElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "updateCreate", element.getUpdateCreateElement(), -1);
    }
    if (element.hasConditionalCreateElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalCreate", element.getConditionalCreateElement(), -1);
    }
    if (element.hasConditionalReadElement()) {
      composeEnum(t, "CapabilityStatementRestResourceComponent", "conditionalRead", element.getConditionalReadElement(), -1);
    }
    if (element.hasConditionalUpdateElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalUpdate", element.getConditionalUpdateElement(), -1);
    }
    if (element.hasConditionalPatchElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalPatch", element.getConditionalPatchElement(), -1);
    }
    if (element.hasConditionalDeleteElement()) {
      composeEnum(t, "CapabilityStatementRestResourceComponent", "conditionalDelete", element.getConditionalDeleteElement(), -1);
    }
    for (int i = 0; i < element.getReferencePolicy().size(); i++) {
      composeEnum(t, "CapabilityStatementRestResourceComponent", "referencePolicy", element.getReferencePolicy().get(i), i);
    }
    for (int i = 0; i < element.getSearchInclude().size(); i++) {
      composeString(t, "CapabilityStatementRestResourceComponent", "searchInclude", element.getSearchInclude().get(i), i);
    }
    for (int i = 0; i < element.getSearchRevInclude().size(); i++) {
      composeString(t, "CapabilityStatementRestResourceComponent", "searchRevInclude", element.getSearchRevInclude().get(i), i);
    }
    for (int i = 0; i < element.getSearchParam().size(); i++) {
      composeCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatementRestResourceComponent", "searchParam", element.getSearchParam().get(i), i);
    }
    for (int i = 0; i < element.getOperation().size(); i++) {
      composeCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatementRestResourceComponent", "operation", element.getOperation().get(i), i);
    }
  }

  protected void composeCapabilityStatementResourceInteractionComponent(Complex parent, String parentType, String name, CapabilityStatement.ResourceInteractionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "interaction", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "ResourceInteractionComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "ResourceInteractionComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeCapabilityStatementRestResourceSearchParamComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "searchParam", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "CapabilityStatementRestResourceSearchParamComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "CapabilityStatementRestResourceSearchParamComponent", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "CapabilityStatementRestResourceSearchParamComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementRestResourceSearchParamComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeCapabilityStatementRestResourceOperationComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "CapabilityStatementRestResourceOperationComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "CapabilityStatementRestResourceOperationComponent", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementRestResourceOperationComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeCapabilityStatementSystemInteractionComponent(Complex parent, String parentType, String name, CapabilityStatement.SystemInteractionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "interaction", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "SystemInteractionComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "SystemInteractionComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeCapabilityStatementMessagingComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "messaging", name, element, index);
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeCapabilityStatementMessagingEndpointComponent(t, "CapabilityStatementMessagingComponent", "endpoint", element.getEndpoint().get(i), i);
    }
    if (element.hasReliableCacheElement()) {
      composeUnsignedInt(t, "CapabilityStatementMessagingComponent", "reliableCache", element.getReliableCacheElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementMessagingComponent", "documentation", element.getDocumentationElement(), -1);
    }
    for (int i = 0; i < element.getSupportedMessage().size(); i++) {
      composeCapabilityStatementMessagingSupportedMessageComponent(t, "CapabilityStatementMessagingComponent", "supportedMessage", element.getSupportedMessage().get(i), i);
    }
  }

  protected void composeCapabilityStatementMessagingEndpointComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingEndpointComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "endpoint", name, element, index);
    if (element.hasProtocol()) {
      composeCoding(t, "CapabilityStatementMessagingEndpointComponent", "protocol", element.getProtocol(), -1);
    }
    if (element.hasAddressElement()) {
      composeUrl(t, "CapabilityStatementMessagingEndpointComponent", "address", element.getAddressElement(), -1);
    }
  }

  protected void composeCapabilityStatementMessagingSupportedMessageComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportedMessage", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "CapabilityStatementMessagingSupportedMessageComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "CapabilityStatementMessagingSupportedMessageComponent", "definition", element.getDefinitionElement(), -1);
    }
  }

  protected void composeCapabilityStatementDocumentComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementDocumentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "document", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "CapabilityStatementDocumentComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementDocumentComponent", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "CapabilityStatementDocumentComponent", "profile", element.getProfileElement(), -1);
    }
  }

  protected void composeCarePlan(Complex parent, String parentType, String name, CarePlan element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CarePlan", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CarePlan", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "CarePlan", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "CarePlan", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "CarePlan", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "CarePlan", "replaces", element.getReplaces().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "CarePlan", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "CarePlan", "intent", element.getIntentElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "CarePlan", "category", element.getCategory().get(i), i);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CarePlan", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "CarePlan", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "CarePlan", "encounter", element.getEncounter(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CarePlan", "period", element.getPeriod(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "CarePlan", "created", element.getCreatedElement(), -1);
    }
    if (element.hasCustodian()) {
      composeReference(t, "CarePlan", "custodian", element.getCustodian(), -1);
    }
    for (int i = 0; i < element.getContributor().size(); i++) {
      composeReference(t, "CarePlan", "contributor", element.getContributor().get(i), i);
    }
    for (int i = 0; i < element.getCareTeam().size(); i++) {
      composeReference(t, "CarePlan", "careTeam", element.getCareTeam().get(i), i);
    }
    for (int i = 0; i < element.getAddresses().size(); i++) {
      composeCodeableReference(t, "CarePlan", "addresses", element.getAddresses().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "CarePlan", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getGoal().size(); i++) {
      composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
    }
    for (int i = 0; i < element.getActivity().size(); i++) {
      composeCarePlanActivityComponent(t, "CarePlan", "activity", element.getActivity().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "CarePlan", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCarePlanActivityComponent(Complex parent, String parentType, String name, CarePlan.CarePlanActivityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "activity", name, element, index);
    for (int i = 0; i < element.getPerformedActivity().size(); i++) {
      composeCodeableReference(t, "CarePlanActivityComponent", "performedActivity", element.getPerformedActivity().get(i), i);
    }
    for (int i = 0; i < element.getProgress().size(); i++) {
      composeAnnotation(t, "CarePlanActivityComponent", "progress", element.getProgress().get(i), i);
    }
    if (element.hasPlannedActivityReference()) {
      composeReference(t, "CarePlanActivityComponent", "plannedActivityReference", element.getPlannedActivityReference(), -1);
    }
    if (element.hasPlannedActivityDetail()) {
      composeCarePlanActivityPlannedActivityDetailComponent(t, "CarePlanActivityComponent", "plannedActivityDetail", element.getPlannedActivityDetail(), -1);
    }
  }

  protected void composeCarePlanActivityPlannedActivityDetailComponent(Complex parent, String parentType, String name, CarePlan.CarePlanActivityPlannedActivityDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "plannedActivityDetail", name, element, index);
    if (element.hasKindElement()) {
      composeEnum(t, "CarePlanActivityPlannedActivityDetailComponent", "kind", element.getKindElement(), -1);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "CarePlanActivityPlannedActivityDetailComponent", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "CarePlanActivityPlannedActivityDetailComponent", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "CarePlanActivityPlannedActivityDetailComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "CarePlanActivityPlannedActivityDetailComponent", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getGoal().size(); i++) {
      composeReference(t, "CarePlanActivityPlannedActivityDetailComponent", "goal", element.getGoal().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CarePlanActivityPlannedActivityDetailComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "CarePlanActivityPlannedActivityDetailComponent", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "CarePlanActivityPlannedActivityDetailComponent", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasScheduled()) {
      composeType(t, "CarePlanActivityPlannedActivityDetailComponent", "scheduled", element.getScheduled(), -1);
    }
    if (element.hasLocation()) {
      composeCodeableReference(t, "CarePlanActivityPlannedActivityDetailComponent", "location", element.getLocation(), -1);
    }
    if (element.hasReported()) {
      composeType(t, "CarePlanActivityPlannedActivityDetailComponent", "reported", element.getReported(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "CarePlanActivityPlannedActivityDetailComponent", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasProduct()) {
      composeType(t, "CarePlanActivityPlannedActivityDetailComponent", "product", element.getProduct(), -1);
    }
    if (element.hasDailyAmount()) {
      composeQuantity(t, "CarePlanActivityPlannedActivityDetailComponent", "dailyAmount", element.getDailyAmount(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "CarePlanActivityPlannedActivityDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "CarePlanActivityPlannedActivityDetailComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeCareTeam(Complex parent, String parentType, String name, CareTeam element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CareTeam", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CareTeam", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CareTeam", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "CareTeam", "category", element.getCategory().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "CareTeam", "name", element.getNameElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "CareTeam", "subject", element.getSubject(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeCareTeamParticipantComponent(t, "CareTeam", "participant", element.getParticipant().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "CareTeam", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getManagingOrganization().size(); i++) {
      composeReference(t, "CareTeam", "managingOrganization", element.getManagingOrganization().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "CareTeam", "telecom", element.getTelecom().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "CareTeam", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCareTeamParticipantComponent(Complex parent, String parentType, String name, CareTeam.CareTeamParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasRole()) {
      composeCodeableConcept(t, "CareTeamParticipantComponent", "role", element.getRole(), -1);
    }
    if (element.hasMember()) {
      composeReference(t, "CareTeamParticipantComponent", "member", element.getMember(), -1);
    }
    if (element.hasOnBehalfOf()) {
      composeReference(t, "CareTeamParticipantComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
    }
    if (element.hasCoverage()) {
      composeType(t, "CareTeamParticipantComponent", "coverage", element.getCoverage(), -1);
    }
  }

  protected void composeChargeItem(Complex parent, String parentType, String name, ChargeItem element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ChargeItem", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ChargeItem", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getDefinitionUri().size(); i++) {
      composeUri(t, "ChargeItem", "definitionUri", element.getDefinitionUri().get(i), i);
    }
    for (int i = 0; i < element.getDefinitionCanonical().size(); i++) {
      composeCanonical(t, "ChargeItem", "definitionCanonical", element.getDefinitionCanonical().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ChargeItem", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "ChargeItem", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ChargeItem", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "ChargeItem", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "ChargeItem", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "ChargeItem", "occurrence", element.getOccurrence(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeChargeItemPerformerComponent(t, "ChargeItem", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasPerformingOrganization()) {
      composeReference(t, "ChargeItem", "performingOrganization", element.getPerformingOrganization(), -1);
    }
    if (element.hasRequestingOrganization()) {
      composeReference(t, "ChargeItem", "requestingOrganization", element.getRequestingOrganization(), -1);
    }
    if (element.hasCostCenter()) {
      composeReference(t, "ChargeItem", "costCenter", element.getCostCenter(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ChargeItem", "quantity", element.getQuantity(), -1);
    }
    for (int i = 0; i < element.getBodysite().size(); i++) {
      composeCodeableConcept(t, "ChargeItem", "bodysite", element.getBodysite().get(i), i);
    }
    if (element.hasUnitPriceComponent()) {
      composeMonetaryComponent(t, "ChargeItem", "unitPriceComponent", element.getUnitPriceComponent(), -1);
    }
    if (element.hasTotalPriceComponent()) {
      composeMonetaryComponent(t, "ChargeItem", "totalPriceComponent", element.getTotalPriceComponent(), -1);
    }
    if (element.hasOverrideReason()) {
      composeCodeableConcept(t, "ChargeItem", "overrideReason", element.getOverrideReason(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "ChargeItem", "enterer", element.getEnterer(), -1);
    }
    if (element.hasEnteredDateElement()) {
      composeDateTime(t, "ChargeItem", "enteredDate", element.getEnteredDateElement(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableConcept(t, "ChargeItem", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getService().size(); i++) {
      composeCodeableReference(t, "ChargeItem", "service", element.getService().get(i), i);
    }
    for (int i = 0; i < element.getProduct().size(); i++) {
      composeCodeableReference(t, "ChargeItem", "product", element.getProduct().get(i), i);
    }
    for (int i = 0; i < element.getAccount().size(); i++) {
      composeReference(t, "ChargeItem", "account", element.getAccount().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ChargeItem", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "ChargeItem", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
  }

  protected void composeChargeItemPerformerComponent(Complex parent, String parentType, String name, ChargeItem.ChargeItemPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ChargeItemPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ChargeItemPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeChargeItemDefinition(Complex parent, String parentType, String name, ChargeItemDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "ChargeItemDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ChargeItemDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ChargeItemDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ChargeItemDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ChargeItemDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ChargeItemDefinition", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getDerivedFromUri().size(); i++) {
      composeUri(t, "ChargeItemDefinition", "derivedFromUri", element.getDerivedFromUri().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeCanonical(t, "ChargeItemDefinition", "partOf", element.getPartOf().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeCanonical(t, "ChargeItemDefinition", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ChargeItemDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ChargeItemDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ChargeItemDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ChargeItemDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ChargeItemDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ChargeItemDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ChargeItemDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ChargeItemDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ChargeItemDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ChargeItemDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ChargeItemDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ChargeItemDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ChargeItemDefinition", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeReference(t, "ChargeItemDefinition", "instance", element.getInstance().get(i), i);
    }
    for (int i = 0; i < element.getApplicability().size(); i++) {
      composeChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinition", "applicability", element.getApplicability().get(i), i);
    }
    for (int i = 0; i < element.getPropertyGroup().size(); i++) {
      composeChargeItemDefinitionPropertyGroupComponent(t, "ChargeItemDefinition", "propertyGroup", element.getPropertyGroup().get(i), i);
    }
  }

  protected void composeChargeItemDefinitionApplicabilityComponent(Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "applicability", name, element, index);
    if (element.hasCondition()) {
      composeExpression(t, "ChargeItemDefinitionApplicabilityComponent", "condition", element.getCondition(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "ChargeItemDefinitionApplicabilityComponent", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    if (element.hasRelatedArtifact()) {
      composeRelatedArtifact(t, "ChargeItemDefinitionApplicabilityComponent", "relatedArtifact", element.getRelatedArtifact(), -1);
    }
  }

  protected void composeChargeItemDefinitionPropertyGroupComponent(Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "propertyGroup", name, element, index);
    for (int i = 0; i < element.getApplicability().size(); i++) {
      composeChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinitionPropertyGroupComponent", "applicability", element.getApplicability().get(i), i);
    }
    for (int i = 0; i < element.getPriceComponent().size(); i++) {
      composeMonetaryComponent(t, "ChargeItemDefinitionPropertyGroupComponent", "priceComponent", element.getPriceComponent().get(i), i);
    }
  }

  protected void composeCitation(Complex parent, String parentType, String name, Citation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "Citation", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Citation", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Citation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Citation", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Citation", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Citation", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Citation", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Citation", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Citation", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Citation", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Citation", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Citation", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Citation", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Citation", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Citation", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Citation", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Citation", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Citation", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "Citation", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "Citation", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "Citation", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "Citation", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "Citation", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getSummary().size(); i++) {
      composeCitationSummaryComponent(t, "Citation", "summary", element.getSummary().get(i), i);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCitationClassificationComponent(t, "Citation", "classification", element.getClassification().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Citation", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getCurrentState().size(); i++) {
      composeCodeableConcept(t, "Citation", "currentState", element.getCurrentState().get(i), i);
    }
    for (int i = 0; i < element.getStatusDate().size(); i++) {
      composeCitationStatusDateComponent(t, "Citation", "statusDate", element.getStatusDate().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "Citation", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasCitedArtifact()) {
      composeCitationCitedArtifactComponent(t, "Citation", "citedArtifact", element.getCitedArtifact(), -1);
    }
  }

  protected void composeCitationSummaryComponent(Complex parent, String parentType, String name, Citation.CitationSummaryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "summary", name, element, index);
    if (element.hasStyle()) {
      composeCodeableConcept(t, "CitationSummaryComponent", "style", element.getStyle(), -1);
    }
    if (element.hasTextElement()) {
      composeMarkdown(t, "CitationSummaryComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composeCitationClassificationComponent(Complex parent, String parentType, String name, Citation.CitationClassificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "classification", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationClassificationComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "CitationClassificationComponent", "classifier", element.getClassifier().get(i), i);
    }
  }

  protected void composeCitationStatusDateComponent(Complex parent, String parentType, String name, Citation.CitationStatusDateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statusDate", name, element, index);
    if (element.hasActivity()) {
      composeCodeableConcept(t, "CitationStatusDateComponent", "activity", element.getActivity(), -1);
    }
    if (element.hasActualElement()) {
      composeBoolean(t, "CitationStatusDateComponent", "actual", element.getActualElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CitationStatusDateComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeCitationCitedArtifactComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "citedArtifact", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CitationCitedArtifactComponent", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getRelatedIdentifier().size(); i++) {
      composeIdentifier(t, "CitationCitedArtifactComponent", "relatedIdentifier", element.getRelatedIdentifier().get(i), i);
    }
    if (element.hasDateAccessedElement()) {
      composeDateTime(t, "CitationCitedArtifactComponent", "dateAccessed", element.getDateAccessedElement(), -1);
    }
    if (element.hasVersion()) {
      composeCitationCitedArtifactVersionComponent(t, "CitationCitedArtifactComponent", "version", element.getVersion(), -1);
    }
    for (int i = 0; i < element.getCurrentState().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactComponent", "currentState", element.getCurrentState().get(i), i);
    }
    for (int i = 0; i < element.getStatusDate().size(); i++) {
      composeCitationCitedArtifactStatusDateComponent(t, "CitationCitedArtifactComponent", "statusDate", element.getStatusDate().get(i), i);
    }
    for (int i = 0; i < element.getTitle().size(); i++) {
      composeCitationCitedArtifactTitleComponent(t, "CitationCitedArtifactComponent", "title", element.getTitle().get(i), i);
    }
    for (int i = 0; i < element.getAbstract().size(); i++) {
      composeCitationCitedArtifactAbstractComponent(t, "CitationCitedArtifactComponent", "abstract", element.getAbstract().get(i), i);
    }
    if (element.hasPart()) {
      composeCitationCitedArtifactPartComponent(t, "CitationCitedArtifactComponent", "part", element.getPart(), -1);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeCitationCitedArtifactRelatesToComponent(t, "CitationCitedArtifactComponent", "relatesTo", element.getRelatesTo().get(i), i);
    }
    for (int i = 0; i < element.getPublicationForm().size(); i++) {
      composeCitationCitedArtifactPublicationFormComponent(t, "CitationCitedArtifactComponent", "publicationForm", element.getPublicationForm().get(i), i);
    }
    for (int i = 0; i < element.getWebLocation().size(); i++) {
      composeCitationCitedArtifactWebLocationComponent(t, "CitationCitedArtifactComponent", "webLocation", element.getWebLocation().get(i), i);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCitationCitedArtifactClassificationComponent(t, "CitationCitedArtifactComponent", "classification", element.getClassification().get(i), i);
    }
    if (element.hasContributorship()) {
      composeCitationCitedArtifactContributorshipComponent(t, "CitationCitedArtifactComponent", "contributorship", element.getContributorship(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "CitationCitedArtifactComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCitationCitedArtifactVersionComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactVersionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "version", name, element, index);
    if (element.hasValueElement()) {
      composeString(t, "CitationCitedArtifactVersionComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasBaseCitation()) {
      composeReference(t, "CitationCitedArtifactVersionComponent", "baseCitation", element.getBaseCitation(), -1);
    }
  }

  protected void composeCitationCitedArtifactStatusDateComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactStatusDateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statusDate", name, element, index);
    if (element.hasActivity()) {
      composeCodeableConcept(t, "CitationCitedArtifactStatusDateComponent", "activity", element.getActivity(), -1);
    }
    if (element.hasActualElement()) {
      composeBoolean(t, "CitationCitedArtifactStatusDateComponent", "actual", element.getActualElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CitationCitedArtifactStatusDateComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeCitationCitedArtifactTitleComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactTitleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "title", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactTitleComponent", "type", element.getType().get(i), i);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "CitationCitedArtifactTitleComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasTextElement()) {
      composeMarkdown(t, "CitationCitedArtifactTitleComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactAbstractComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactAbstractComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "abstract", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactAbstractComponent", "type", element.getType(), -1);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "CitationCitedArtifactAbstractComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasTextElement()) {
      composeMarkdown(t, "CitationCitedArtifactAbstractComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CitationCitedArtifactAbstractComponent", "copyright", element.getCopyrightElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactPartComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactPartComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "part", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactPartComponent", "type", element.getType(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "CitationCitedArtifactPartComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasBaseCitation()) {
      composeReference(t, "CitationCitedArtifactPartComponent", "baseCitation", element.getBaseCitation(), -1);
    }
  }

  protected void composeCitationCitedArtifactRelatesToComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactRelatesToComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatesTo", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "CitationCitedArtifactRelatesToComponent", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactRelatesToComponent", "classifier", element.getClassifier().get(i), i);
    }
    if (element.hasLabelElement()) {
      composeString(t, "CitationCitedArtifactRelatesToComponent", "label", element.getLabelElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "CitationCitedArtifactRelatesToComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasCitationElement()) {
      composeMarkdown(t, "CitationCitedArtifactRelatesToComponent", "citation", element.getCitationElement(), -1);
    }
    if (element.hasDocument()) {
      composeAttachment(t, "CitationCitedArtifactRelatesToComponent", "document", element.getDocument(), -1);
    }
    if (element.hasResourceElement()) {
      composeCanonical(t, "CitationCitedArtifactRelatesToComponent", "resource", element.getResourceElement(), -1);
    }
    if (element.hasResourceReference()) {
      composeReference(t, "CitationCitedArtifactRelatesToComponent", "resourceReference", element.getResourceReference(), -1);
    }
  }

  protected void composeCitationCitedArtifactPublicationFormComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "publicationForm", name, element, index);
    if (element.hasPublishedIn()) {
      composeCitationCitedArtifactPublicationFormPublishedInComponent(t, "CitationCitedArtifactPublicationFormComponent", "publishedIn", element.getPublishedIn(), -1);
    }
    if (element.hasCitedMedium()) {
      composeCodeableConcept(t, "CitationCitedArtifactPublicationFormComponent", "citedMedium", element.getCitedMedium(), -1);
    }
    if (element.hasVolumeElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "volume", element.getVolumeElement(), -1);
    }
    if (element.hasIssueElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "issue", element.getIssueElement(), -1);
    }
    if (element.hasPublicationDateYearElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateYear", element.getPublicationDateYearElement(), -1);
    }
    if (element.hasPublicationDateMonthElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateMonth", element.getPublicationDateMonthElement(), -1);
    }
    if (element.hasPublicationDateDayElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateDay", element.getPublicationDateDayElement(), -1);
    }
    if (element.hasPublicationDateSeasonElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateSeason", element.getPublicationDateSeasonElement(), -1);
    }
    if (element.hasPublicationDateTextElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateText", element.getPublicationDateTextElement(), -1);
    }
    if (element.hasArticleDateElement()) {
      composeDateTime(t, "CitationCitedArtifactPublicationFormComponent", "articleDate", element.getArticleDateElement(), -1);
    }
    if (element.hasLastRevisionDateElement()) {
      composeDateTime(t, "CitationCitedArtifactPublicationFormComponent", "lastRevisionDate", element.getLastRevisionDateElement(), -1);
    }
    for (int i = 0; i < element.getLanguage().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactPublicationFormComponent", "language", element.getLanguage().get(i), i);
    }
    if (element.hasAccessionNumberElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "accessionNumber", element.getAccessionNumberElement(), -1);
    }
    if (element.hasPageStringElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "pageString", element.getPageStringElement(), -1);
    }
    if (element.hasFirstPageElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "firstPage", element.getFirstPageElement(), -1);
    }
    if (element.hasLastPageElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "lastPage", element.getLastPageElement(), -1);
    }
    if (element.hasPageCountElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "pageCount", element.getPageCountElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CitationCitedArtifactPublicationFormComponent", "copyright", element.getCopyrightElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactPublicationFormPublishedInComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormPublishedInComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "publishedIn", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasPublisher()) {
      composeReference(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "publisher", element.getPublisher(), -1);
    }
    if (element.hasPublisherLocationElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "publisherLocation", element.getPublisherLocationElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactWebLocationComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactWebLocationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "webLocation", name, element, index);
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactWebLocationComponent", "classifier", element.getClassifier().get(i), i);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "CitationCitedArtifactWebLocationComponent", "url", element.getUrlElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactClassificationComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactClassificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "classification", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactClassificationComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactClassificationComponent", "classifier", element.getClassifier().get(i), i);
    }
    for (int i = 0; i < element.getArtifactAssessment().size(); i++) {
      composeReference(t, "CitationCitedArtifactClassificationComponent", "artifactAssessment", element.getArtifactAssessment().get(i), i);
    }
  }

  protected void composeCitationCitedArtifactContributorshipComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contributorship", name, element, index);
    if (element.hasCompleteElement()) {
      composeBoolean(t, "CitationCitedArtifactContributorshipComponent", "complete", element.getCompleteElement(), -1);
    }
    for (int i = 0; i < element.getEntry().size(); i++) {
      composeCitationCitedArtifactContributorshipEntryComponent(t, "CitationCitedArtifactContributorshipComponent", "entry", element.getEntry().get(i), i);
    }
    for (int i = 0; i < element.getSummary().size(); i++) {
      composeCitationContributorshipSummaryComponent(t, "CitationCitedArtifactContributorshipComponent", "summary", element.getSummary().get(i), i);
    }
  }

  protected void composeCitationCitedArtifactContributorshipEntryComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entry", name, element, index);
    if (element.hasContributor()) {
      composeReference(t, "CitationCitedArtifactContributorshipEntryComponent", "contributor", element.getContributor(), -1);
    }
    if (element.hasForenameInitialsElement()) {
      composeString(t, "CitationCitedArtifactContributorshipEntryComponent", "forenameInitials", element.getForenameInitialsElement(), -1);
    }
    for (int i = 0; i < element.getAffiliation().size(); i++) {
      composeReference(t, "CitationCitedArtifactContributorshipEntryComponent", "affiliation", element.getAffiliation().get(i), i);
    }
    for (int i = 0; i < element.getContributionType().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryComponent", "contributionType", element.getContributionType().get(i), i);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryComponent", "role", element.getRole(), -1);
    }
    for (int i = 0; i < element.getContributionInstance().size(); i++) {
      composeCitationCitedArtifactContributorshipEntryContributionInstanceComponent(t, "CitationCitedArtifactContributorshipEntryComponent", "contributionInstance", element.getContributionInstance().get(i), i);
    }
    if (element.hasCorrespondingContactElement()) {
      composeBoolean(t, "CitationCitedArtifactContributorshipEntryComponent", "correspondingContact", element.getCorrespondingContactElement(), -1);
    }
    if (element.hasRankingOrderElement()) {
      composePositiveInt(t, "CitationCitedArtifactContributorshipEntryComponent", "rankingOrder", element.getRankingOrderElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactContributorshipEntryContributionInstanceComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contributionInstance", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryContributionInstanceComponent", "type", element.getType(), -1);
    }
    if (element.hasTimeElement()) {
      composeDateTime(t, "CitationCitedArtifactContributorshipEntryContributionInstanceComponent", "time", element.getTimeElement(), -1);
    }
  }

  protected void composeCitationContributorshipSummaryComponent(Complex parent, String parentType, String name, Citation.ContributorshipSummaryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "summary", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ContributorshipSummaryComponent", "type", element.getType(), -1);
    }
    if (element.hasStyle()) {
      composeCodeableConcept(t, "ContributorshipSummaryComponent", "style", element.getStyle(), -1);
    }
    if (element.hasSource()) {
      composeCodeableConcept(t, "ContributorshipSummaryComponent", "source", element.getSource(), -1);
    }
    if (element.hasValueElement()) {
      composeMarkdown(t, "ContributorshipSummaryComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeClaim(Complex parent, String parentType, String name, Claim element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Claim", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Claim", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Claim", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "Claim", "subType", element.getSubType(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "Claim", "use", element.getUseElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "Claim", "patient", element.getPatient(), -1);
    }
    if (element.hasBillablePeriod()) {
      composePeriod(t, "Claim", "billablePeriod", element.getBillablePeriod(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "Claim", "created", element.getCreatedElement(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "Claim", "enterer", element.getEnterer(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "Claim", "insurer", element.getInsurer(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "Claim", "provider", element.getProvider(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "Claim", "priority", element.getPriority(), -1);
    }
    if (element.hasFundsReserve()) {
      composeCodeableConcept(t, "Claim", "fundsReserve", element.getFundsReserve(), -1);
    }
    for (int i = 0; i < element.getRelated().size(); i++) {
      composeClaimRelatedClaimComponent(t, "Claim", "related", element.getRelated().get(i), i);
    }
    if (element.hasPrescription()) {
      composeReference(t, "Claim", "prescription", element.getPrescription(), -1);
    }
    if (element.hasOriginalPrescription()) {
      composeReference(t, "Claim", "originalPrescription", element.getOriginalPrescription(), -1);
    }
    if (element.hasPayee()) {
      composeClaimPayeeComponent(t, "Claim", "payee", element.getPayee(), -1);
    }
    if (element.hasReferral()) {
      composeReference(t, "Claim", "referral", element.getReferral(), -1);
    }
    for (int i = 0; i < element.getEncounter().size(); i++) {
      composeReference(t, "Claim", "encounter", element.getEncounter().get(i), i);
    }
    if (element.hasFacility()) {
      composeReference(t, "Claim", "facility", element.getFacility(), -1);
    }
    if (element.hasDiagnosisRelatedGroup()) {
      composeCodeableConcept(t, "Claim", "diagnosisRelatedGroup", element.getDiagnosisRelatedGroup(), -1);
    }
    for (int i = 0; i < element.getCareTeam().size(); i++) {
      composeClaimCareTeamComponent(t, "Claim", "careTeam", element.getCareTeam().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeClaimSupportingInformationComponent(t, "Claim", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeClaimDiagnosisComponent(t, "Claim", "diagnosis", element.getDiagnosis().get(i), i);
    }
    for (int i = 0; i < element.getProcedure().size(); i++) {
      composeClaimProcedureComponent(t, "Claim", "procedure", element.getProcedure().get(i), i);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeClaimInsuranceComponent(t, "Claim", "insurance", element.getInsurance().get(i), i);
    }
    if (element.hasAccident()) {
      composeClaimAccidentComponent(t, "Claim", "accident", element.getAccident(), -1);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "Claim", "patientPaid", element.getPatientPaid(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeClaimItemComponent(t, "Claim", "item", element.getItem().get(i), i);
    }
    if (element.hasTotal()) {
      composeMoney(t, "Claim", "total", element.getTotal(), -1);
    }
  }

  protected void composeClaimRelatedClaimComponent(Complex parent, String parentType, String name, Claim.RelatedClaimComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "related", name, element, index);
    if (element.hasClaim()) {
      composeReference(t, "RelatedClaimComponent", "claim", element.getClaim(), -1);
    }
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "RelatedClaimComponent", "relationship", element.getRelationship(), -1);
    }
    if (element.hasReference()) {
      composeIdentifier(t, "RelatedClaimComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeClaimPayeeComponent(Complex parent, String parentType, String name, Claim.PayeeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payee", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PayeeComponent", "type", element.getType(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "PayeeComponent", "party", element.getParty(), -1);
    }
  }

  protected void composeClaimCareTeamComponent(Complex parent, String parentType, String name, Claim.CareTeamComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "careTeam", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "CareTeamComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "CareTeamComponent", "provider", element.getProvider(), -1);
    }
    if (element.hasResponsibleElement()) {
      composeBoolean(t, "CareTeamComponent", "responsible", element.getResponsibleElement(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "CareTeamComponent", "role", element.getRole(), -1);
    }
    if (element.hasSpecialty()) {
      composeCodeableConcept(t, "CareTeamComponent", "specialty", element.getSpecialty(), -1);
    }
  }

  protected void composeClaimSupportingInformationComponent(Complex parent, String parentType, String name, Claim.SupportingInformationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportingInfo", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "code", element.getCode(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "SupportingInformationComponent", "timing", element.getTiming(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "SupportingInformationComponent", "value", element.getValue(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "reason", element.getReason(), -1);
    }
  }

  protected void composeClaimDiagnosisComponent(Complex parent, String parentType, String name, Claim.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "DiagnosisComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasDiagnosis()) {
      composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "DiagnosisComponent", "type", element.getType().get(i), i);
    }
    if (element.hasOnAdmission()) {
      composeCodeableConcept(t, "DiagnosisComponent", "onAdmission", element.getOnAdmission(), -1);
    }
  }

  protected void composeClaimProcedureComponent(Complex parent, String parentType, String name, Claim.ProcedureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "procedure", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "ProcedureComponent", "sequence", element.getSequenceElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "ProcedureComponent", "type", element.getType().get(i), i);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ProcedureComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasProcedure()) {
      composeType(t, "ProcedureComponent", "procedure", element.getProcedure(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "ProcedureComponent", "udi", element.getUdi().get(i), i);
    }
  }

  protected void composeClaimInsuranceComponent(Complex parent, String parentType, String name, Claim.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "InsuranceComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasFocalElement()) {
      composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "InsuranceComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasBusinessArrangementElement()) {
      composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
    }
    for (int i = 0; i < element.getPreAuthRef().size(); i++) {
      composeString(t, "InsuranceComponent", "preAuthRef", element.getPreAuthRef().get(i), i);
    }
    if (element.hasClaimResponse()) {
      composeReference(t, "InsuranceComponent", "claimResponse", element.getClaimResponse(), -1);
    }
  }

  protected void composeClaimAccidentComponent(Complex parent, String parentType, String name, Claim.AccidentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "accident", name, element, index);
    if (element.hasDateElement()) {
      composeDate(t, "AccidentComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "AccidentComponent", "type", element.getType(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "AccidentComponent", "location", element.getLocation(), -1);
    }
  }

  protected void composeClaimItemComponent(Complex parent, String parentType, String name, Claim.ItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "ItemComponent", "sequence", element.getSequenceElement(), -1);
    }
    for (int i = 0; i < element.getCareTeamSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "careTeamSequence", element.getCareTeamSequence().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosisSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
    }
    for (int i = 0; i < element.getProcedureSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "procedureSequence", element.getProcedureSequence().get(i), i);
    }
    for (int i = 0; i < element.getInformationSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "informationSequence", element.getInformationSequence().get(i), i);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "ItemComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "ItemComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "ItemComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "ItemComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasServiced()) {
      composeType(t, "ItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "ItemComponent", "location", element.getLocation(), -1);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "ItemComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "ItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "ItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "ItemComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "ItemComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "ItemComponent", "udi", element.getUdi().get(i), i);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeClaimBodySiteComponent(t, "ItemComponent", "bodySite", element.getBodySite().get(i), i);
    }
    for (int i = 0; i < element.getEncounter().size(); i++) {
      composeReference(t, "ItemComponent", "encounter", element.getEncounter().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeClaimDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeClaimBodySiteComponent(Complex parent, String parentType, String name, Claim.BodySiteComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "bodySite", name, element, index);
    for (int i = 0; i < element.getSite().size(); i++) {
      composeCodeableReference(t, "BodySiteComponent", "site", element.getSite().get(i), i);
    }
    for (int i = 0; i < element.getSubSite().size(); i++) {
      composeCodeableConcept(t, "BodySiteComponent", "subSite", element.getSubSite().get(i), i);
    }
  }

  protected void composeClaimDetailComponent(Complex parent, String parentType, String name, Claim.DetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "DetailComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "DetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "DetailComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "DetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "DetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "DetailComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "DetailComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "DetailComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "DetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "DetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "DetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "DetailComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "DetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "DetailComponent", "udi", element.getUdi().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeClaimSubDetailComponent(t, "DetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeClaimSubDetailComponent(Complex parent, String parentType, String name, Claim.SubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SubDetailComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "SubDetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SubDetailComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "SubDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "SubDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "SubDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "SubDetailComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "SubDetailComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "SubDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "SubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "SubDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "SubDetailComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "SubDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "SubDetailComponent", "udi", element.getUdi().get(i), i);
    }
  }

  protected void composeClaimResponse(Complex parent, String parentType, String name, ClaimResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ClaimResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ClaimResponse", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ClaimResponse", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "ClaimResponse", "subType", element.getSubType(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "ClaimResponse", "use", element.getUseElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "ClaimResponse", "patient", element.getPatient(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "ClaimResponse", "created", element.getCreatedElement(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "ClaimResponse", "insurer", element.getInsurer(), -1);
    }
    if (element.hasRequestor()) {
      composeReference(t, "ClaimResponse", "requestor", element.getRequestor(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "ClaimResponse", "request", element.getRequest(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "ClaimResponse", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "ClaimResponse", "decision", element.getDecision(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "ClaimResponse", "disposition", element.getDispositionElement(), -1);
    }
    if (element.hasPreAuthRefElement()) {
      composeString(t, "ClaimResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
    }
    if (element.hasPreAuthPeriod()) {
      composePeriod(t, "ClaimResponse", "preAuthPeriod", element.getPreAuthPeriod(), -1);
    }
    if (element.hasPayeeType()) {
      composeCodeableConcept(t, "ClaimResponse", "payeeType", element.getPayeeType(), -1);
    }
    for (int i = 0; i < element.getEncounter().size(); i++) {
      composeReference(t, "ClaimResponse", "encounter", element.getEncounter().get(i), i);
    }
    if (element.hasDiagnosisRelatedGroup()) {
      composeCodeableConcept(t, "ClaimResponse", "diagnosisRelatedGroup", element.getDiagnosisRelatedGroup(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeClaimResponseItemComponent(t, "ClaimResponse", "item", element.getItem().get(i), i);
    }
    for (int i = 0; i < element.getAddItem().size(); i++) {
      composeClaimResponseAddedItemComponent(t, "ClaimResponse", "addItem", element.getAddItem().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getTotal().size(); i++) {
      composeClaimResponseTotalComponent(t, "ClaimResponse", "total", element.getTotal().get(i), i);
    }
    if (element.hasPayment()) {
      composeClaimResponsePaymentComponent(t, "ClaimResponse", "payment", element.getPayment(), -1);
    }
    if (element.hasFundsReserve()) {
      composeCodeableConcept(t, "ClaimResponse", "fundsReserve", element.getFundsReserve(), -1);
    }
    if (element.hasFormCode()) {
      composeCodeableConcept(t, "ClaimResponse", "formCode", element.getFormCode(), -1);
    }
    if (element.hasForm()) {
      composeAttachment(t, "ClaimResponse", "form", element.getForm(), -1);
    }
    for (int i = 0; i < element.getProcessNote().size(); i++) {
      composeClaimResponseNoteComponent(t, "ClaimResponse", "processNote", element.getProcessNote().get(i), i);
    }
    for (int i = 0; i < element.getCommunicationRequest().size(); i++) {
      composeReference(t, "ClaimResponse", "communicationRequest", element.getCommunicationRequest().get(i), i);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeClaimResponseInsuranceComponent(t, "ClaimResponse", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getError().size(); i++) {
      composeClaimResponseErrorComponent(t, "ClaimResponse", "error", element.getError().get(i), i);
    }
  }

  protected void composeClaimResponseItemComponent(Complex parent, String parentType, String name, ClaimResponse.ItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasItemSequenceElement()) {
      composePositiveInt(t, "ItemComponent", "itemSequence", element.getItemSequenceElement(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "ItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "ItemComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "ItemComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeClaimResponseItemDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeClaimResponseAdjudicationComponent(Complex parent, String parentType, String name, ClaimResponse.AdjudicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "adjudication", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "AdjudicationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "AdjudicationComponent", "reason", element.getReason(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "AdjudicationComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasValueElement()) {
      composeDecimal(t, "AdjudicationComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeClaimResponseItemDetailComponent(Complex parent, String parentType, String name, ClaimResponse.ItemDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasDetailSequenceElement()) {
      composePositiveInt(t, "ItemDetailComponent", "detailSequence", element.getDetailSequenceElement(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "ItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "ItemDetailComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "ItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeClaimResponseSubDetailComponent(t, "ItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeClaimResponseSubDetailComponent(Complex parent, String parentType, String name, ClaimResponse.SubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasSubDetailSequenceElement()) {
      composePositiveInt(t, "SubDetailComponent", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "SubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "SubDetailComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "SubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
  }

  protected void composeClaimResponseAddedItemComponent(Complex parent, String parentType, String name, ClaimResponse.AddedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "addItem", name, element, index);
    for (int i = 0; i < element.getItemSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "itemSequence", element.getItemSequence().get(i), i);
    }
    for (int i = 0; i < element.getDetailSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "detailSequence", element.getDetailSequence().get(i), i);
    }
    for (int i = 0; i < element.getSubdetailSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "subdetailSequence", element.getSubdetailSequence().get(i), i);
    }
    for (int i = 0; i < element.getProvider().size(); i++) {
      composeReference(t, "AddedItemComponent", "provider", element.getProvider().get(i), i);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "AddedItemComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "AddedItemComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasServiced()) {
      composeType(t, "AddedItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "AddedItemComponent", "location", element.getLocation(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "AddedItemComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeClaimResponseBodySiteComponent(t, "AddedItemComponent", "bodySite", element.getBodySite().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "AddedItemComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "AddedItemComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeClaimResponseAddedItemDetailComponent(t, "AddedItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeClaimResponseBodySiteComponent(Complex parent, String parentType, String name, ClaimResponse.BodySiteComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "bodySite", name, element, index);
    for (int i = 0; i < element.getSite().size(); i++) {
      composeCodeableReference(t, "BodySiteComponent", "site", element.getSite().get(i), i);
    }
    for (int i = 0; i < element.getSubSite().size(); i++) {
      composeCodeableConcept(t, "BodySiteComponent", "subSite", element.getSubSite().get(i), i);
    }
  }

  protected void composeClaimResponseAddedItemDetailComponent(Complex parent, String parentType, String name, ClaimResponse.AddedItemDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "AddedItemDetailComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "AddedItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeClaimResponseAddedItemSubDetailComponent(t, "AddedItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeClaimResponseAddedItemSubDetailComponent(Complex parent, String parentType, String name, ClaimResponse.AddedItemSubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "AddedItemSubDetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemSubDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "AddedItemSubDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemSubDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemSubDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemSubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemSubDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "AddedItemSubDetailComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemSubDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemSubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "AddedItemSubDetailComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "AddedItemSubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
  }

  protected void composeClaimResponseTotalComponent(Complex parent, String parentType, String name, ClaimResponse.TotalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "total", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "TotalComponent", "category", element.getCategory(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "TotalComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeClaimResponsePaymentComponent(Complex parent, String parentType, String name, ClaimResponse.PaymentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payment", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PaymentComponent", "type", element.getType(), -1);
    }
    if (element.hasAdjustment()) {
      composeMoney(t, "PaymentComponent", "adjustment", element.getAdjustment(), -1);
    }
    if (element.hasAdjustmentReason()) {
      composeCodeableConcept(t, "PaymentComponent", "adjustmentReason", element.getAdjustmentReason(), -1);
    }
    if (element.hasDateElement()) {
      composeDate(t, "PaymentComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "PaymentComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "PaymentComponent", "identifier", element.getIdentifier(), -1);
    }
  }

  protected void composeClaimResponseNoteComponent(Complex parent, String parentType, String name, ClaimResponse.NoteComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "processNote", name, element, index);
    if (element.hasNumberElement()) {
      composePositiveInt(t, "NoteComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "NoteComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "NoteComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "NoteComponent", "language", element.getLanguage(), -1);
    }
  }

  protected void composeClaimResponseInsuranceComponent(Complex parent, String parentType, String name, ClaimResponse.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "InsuranceComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasFocalElement()) {
      composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasBusinessArrangementElement()) {
      composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
    }
    if (element.hasClaimResponse()) {
      composeReference(t, "InsuranceComponent", "claimResponse", element.getClaimResponse(), -1);
    }
  }

  protected void composeClaimResponseErrorComponent(Complex parent, String parentType, String name, ClaimResponse.ErrorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "error", name, element, index);
    if (element.hasItemSequenceElement()) {
      composePositiveInt(t, "ErrorComponent", "itemSequence", element.getItemSequenceElement(), -1);
    }
    if (element.hasDetailSequenceElement()) {
      composePositiveInt(t, "ErrorComponent", "detailSequence", element.getDetailSequenceElement(), -1);
    }
    if (element.hasSubDetailSequenceElement()) {
      composePositiveInt(t, "ErrorComponent", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ErrorComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeClinicalImpression(Complex parent, String parentType, String name, ClinicalImpression element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ClinicalImpression", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ClinicalImpression", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ClinicalImpression", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "ClinicalImpression", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ClinicalImpression", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "ClinicalImpression", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "ClinicalImpression", "encounter", element.getEncounter(), -1);
    }
    if (element.hasEffective()) {
      composeType(t, "ClinicalImpression", "effective", element.getEffective(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ClinicalImpression", "date", element.getDateElement(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "ClinicalImpression", "performer", element.getPerformer(), -1);
    }
    if (element.hasPrevious()) {
      composeReference(t, "ClinicalImpression", "previous", element.getPrevious(), -1);
    }
    for (int i = 0; i < element.getProblem().size(); i++) {
      composeReference(t, "ClinicalImpression", "problem", element.getProblem().get(i), i);
    }
    if (element.hasChangePattern()) {
      composeCodeableConcept(t, "ClinicalImpression", "changePattern", element.getChangePattern(), -1);
    }
    for (int i = 0; i < element.getProtocol().size(); i++) {
      composeUri(t, "ClinicalImpression", "protocol", element.getProtocol().get(i), i);
    }
    if (element.hasSummaryElement()) {
      composeString(t, "ClinicalImpression", "summary", element.getSummaryElement(), -1);
    }
    for (int i = 0; i < element.getFinding().size(); i++) {
      composeClinicalImpressionFindingComponent(t, "ClinicalImpression", "finding", element.getFinding().get(i), i);
    }
    for (int i = 0; i < element.getPrognosisCodeableConcept().size(); i++) {
      composeCodeableConcept(t, "ClinicalImpression", "prognosisCodeableConcept", element.getPrognosisCodeableConcept().get(i), i);
    }
    for (int i = 0; i < element.getPrognosisReference().size(); i++) {
      composeReference(t, "ClinicalImpression", "prognosisReference", element.getPrognosisReference().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "ClinicalImpression", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ClinicalImpression", "note", element.getNote().get(i), i);
    }
  }

  protected void composeClinicalImpressionFindingComponent(Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionFindingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "finding", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "ClinicalImpressionFindingComponent", "item", element.getItem(), -1);
    }
    if (element.hasBasisElement()) {
      composeString(t, "ClinicalImpressionFindingComponent", "basis", element.getBasisElement(), -1);
    }
  }

  protected void composeClinicalUseDefinition(Complex parent, String parentType, String name, ClinicalUseDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ClinicalUseDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ClinicalUseDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ClinicalUseDefinition", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "ClinicalUseDefinition", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "ClinicalUseDefinition", "subject", element.getSubject().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "ClinicalUseDefinition", "status", element.getStatus(), -1);
    }
    if (element.hasContraindication()) {
      composeClinicalUseDefinitionContraindicationComponent(t, "ClinicalUseDefinition", "contraindication", element.getContraindication(), -1);
    }
    if (element.hasIndication()) {
      composeClinicalUseDefinitionIndicationComponent(t, "ClinicalUseDefinition", "indication", element.getIndication(), -1);
    }
    if (element.hasInteraction()) {
      composeClinicalUseDefinitionInteractionComponent(t, "ClinicalUseDefinition", "interaction", element.getInteraction(), -1);
    }
    for (int i = 0; i < element.getPopulation().size(); i++) {
      composeReference(t, "ClinicalUseDefinition", "population", element.getPopulation().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "ClinicalUseDefinition", "library", element.getLibrary().get(i), i);
    }
    if (element.hasUndesirableEffect()) {
      composeClinicalUseDefinitionUndesirableEffectComponent(t, "ClinicalUseDefinition", "undesirableEffect", element.getUndesirableEffect(), -1);
    }
    if (element.hasWarning()) {
      composeClinicalUseDefinitionWarningComponent(t, "ClinicalUseDefinition", "warning", element.getWarning(), -1);
    }
  }

  protected void composeClinicalUseDefinitionContraindicationComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contraindication", name, element, index);
    if (element.hasDiseaseSymptomProcedure()) {
      composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
    }
    if (element.hasDiseaseStatus()) {
      composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "diseaseStatus", element.getDiseaseStatus(), -1);
    }
    for (int i = 0; i < element.getComorbidity().size(); i++) {
      composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "comorbidity", element.getComorbidity().get(i), i);
    }
    for (int i = 0; i < element.getIndication().size(); i++) {
      composeReference(t, "ClinicalUseDefinitionContraindicationComponent", "indication", element.getIndication().get(i), i);
    }
    if (element.hasApplicability()) {
      composeExpression(t, "ClinicalUseDefinitionContraindicationComponent", "applicability", element.getApplicability(), -1);
    }
    for (int i = 0; i < element.getOtherTherapy().size(); i++) {
      composeClinicalUseDefinitionContraindicationOtherTherapyComponent(t, "ClinicalUseDefinitionContraindicationComponent", "otherTherapy", element.getOtherTherapy().get(i), i);
    }
  }

  protected void composeClinicalUseDefinitionContraindicationOtherTherapyComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "otherTherapy", name, element, index);
    if (element.hasRelationshipType()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionContraindicationOtherTherapyComponent", "relationshipType", element.getRelationshipType(), -1);
    }
    if (element.hasTreatment()) {
      composeCodeableReference(t, "ClinicalUseDefinitionContraindicationOtherTherapyComponent", "treatment", element.getTreatment(), -1);
    }
  }

  protected void composeClinicalUseDefinitionIndicationComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "indication", name, element, index);
    if (element.hasDiseaseSymptomProcedure()) {
      composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
    }
    if (element.hasDiseaseStatus()) {
      composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "diseaseStatus", element.getDiseaseStatus(), -1);
    }
    for (int i = 0; i < element.getComorbidity().size(); i++) {
      composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "comorbidity", element.getComorbidity().get(i), i);
    }
    if (element.hasIntendedEffect()) {
      composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "intendedEffect", element.getIntendedEffect(), -1);
    }
    if (element.hasDuration()) {
      composeType(t, "ClinicalUseDefinitionIndicationComponent", "duration", element.getDuration(), -1);
    }
    for (int i = 0; i < element.getUndesirableEffect().size(); i++) {
      composeReference(t, "ClinicalUseDefinitionIndicationComponent", "undesirableEffect", element.getUndesirableEffect().get(i), i);
    }
    if (element.hasApplicability()) {
      composeExpression(t, "ClinicalUseDefinitionIndicationComponent", "applicability", element.getApplicability(), -1);
    }
    for (int i = 0; i < element.getOtherTherapy().size(); i++) {
      composeClinicalUseDefinitionContraindicationOtherTherapyComponent(t, "ClinicalUseDefinitionIndicationComponent", "otherTherapy", element.getOtherTherapy().get(i), i);
    }
  }

  protected void composeClinicalUseDefinitionInteractionComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "interaction", name, element, index);
    for (int i = 0; i < element.getInteractant().size(); i++) {
      composeClinicalUseDefinitionInteractionInteractantComponent(t, "ClinicalUseDefinitionInteractionComponent", "interactant", element.getInteractant().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "type", element.getType(), -1);
    }
    if (element.hasEffect()) {
      composeCodeableReference(t, "ClinicalUseDefinitionInteractionComponent", "effect", element.getEffect(), -1);
    }
    if (element.hasIncidence()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "incidence", element.getIncidence(), -1);
    }
    for (int i = 0; i < element.getManagement().size(); i++) {
      composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "management", element.getManagement().get(i), i);
    }
  }

  protected void composeClinicalUseDefinitionInteractionInteractantComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "interactant", name, element, index);
    if (element.hasItem()) {
      composeType(t, "ClinicalUseDefinitionInteractionInteractantComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeClinicalUseDefinitionUndesirableEffectComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "undesirableEffect", name, element, index);
    if (element.hasSymptomConditionEffect()) {
      composeCodeableReference(t, "ClinicalUseDefinitionUndesirableEffectComponent", "symptomConditionEffect", element.getSymptomConditionEffect(), -1);
    }
    if (element.hasClassification()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionUndesirableEffectComponent", "classification", element.getClassification(), -1);
    }
    if (element.hasFrequencyOfOccurrence()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionUndesirableEffectComponent", "frequencyOfOccurrence", element.getFrequencyOfOccurrence(), -1);
    }
  }

  protected void composeClinicalUseDefinitionWarningComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "warning", name, element, index);
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ClinicalUseDefinitionWarningComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionWarningComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeCodeSystem(Complex parent, String parentType, String name, CodeSystem element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "CodeSystem", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "CodeSystem", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CodeSystem", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CodeSystem", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "CodeSystem", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CodeSystem", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CodeSystem", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "CodeSystem", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "CodeSystem", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "CodeSystem", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "CodeSystem", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "CodeSystem", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "CodeSystem", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "CodeSystem", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CodeSystem", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "CodeSystem", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "CodeSystem", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "CodeSystem", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "CodeSystem", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "CodeSystem", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "CodeSystem", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "CodeSystem", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "CodeSystem", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "CodeSystem", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasCaseSensitiveElement()) {
      composeBoolean(t, "CodeSystem", "caseSensitive", element.getCaseSensitiveElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "CodeSystem", "valueSet", element.getValueSetElement(), -1);
    }
    if (element.hasHierarchyMeaningElement()) {
      composeEnum(t, "CodeSystem", "hierarchyMeaning", element.getHierarchyMeaningElement(), -1);
    }
    if (element.hasCompositionalElement()) {
      composeBoolean(t, "CodeSystem", "compositional", element.getCompositionalElement(), -1);
    }
    if (element.hasVersionNeededElement()) {
      composeBoolean(t, "CodeSystem", "versionNeeded", element.getVersionNeededElement(), -1);
    }
    if (element.hasContentElement()) {
      composeEnum(t, "CodeSystem", "content", element.getContentElement(), -1);
    }
    if (element.hasSupplementsElement()) {
      composeCanonical(t, "CodeSystem", "supplements", element.getSupplementsElement(), -1);
    }
    if (element.hasCountElement()) {
      composeUnsignedInt(t, "CodeSystem", "count", element.getCountElement(), -1);
    }
    for (int i = 0; i < element.getFilter().size(); i++) {
      composeCodeSystemFilterComponent(t, "CodeSystem", "filter", element.getFilter().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeCodeSystemPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getConcept().size(); i++) {
      composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
    }
  }

  protected void composeCodeSystemFilterComponent(Complex parent, String parentType, String name, CodeSystem.CodeSystemFilterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "filter", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "CodeSystemFilterComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "CodeSystemFilterComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getOperator().size(); i++) {
      composeEnum(t, "CodeSystemFilterComponent", "operator", element.getOperator().get(i), i);
    }
    if (element.hasValueElement()) {
      composeString(t, "CodeSystemFilterComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeCodeSystemPropertyComponent(Complex parent, String parentType, String name, CodeSystem.PropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "PropertyComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasUriElement()) {
      composeUri(t, "PropertyComponent", "uri", element.getUriElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "PropertyComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "PropertyComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composeCodeSystemConceptDefinitionComponent(Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "concept", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "ConceptDefinitionComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "ConceptDefinitionComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeString(t, "ConceptDefinitionComponent", "definition", element.getDefinitionElement(), -1);
    }
    for (int i = 0; i < element.getDesignation().size(); i++) {
      composeCodeSystemConceptDefinitionDesignationComponent(t, "ConceptDefinitionComponent", "designation", element.getDesignation().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeCodeSystemConceptPropertyComponent(t, "ConceptDefinitionComponent", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getConcept().size(); i++) {
      composeCodeSystemConceptDefinitionComponent(t, "ConceptDefinitionComponent", "concept", element.getConcept().get(i), i);
    }
  }

  protected void composeCodeSystemConceptDefinitionDesignationComponent(Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionDesignationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "designation", name, element, index);
    if (element.hasLanguageElement()) {
      composeCode(t, "ConceptDefinitionDesignationComponent", "language", element.getLanguageElement(), -1);
    }
    if (element.hasUse()) {
      composeCoding(t, "ConceptDefinitionDesignationComponent", "use", element.getUse(), -1);
    }
    for (int i = 0; i < element.getAdditionalUse().size(); i++) {
      composeCoding(t, "ConceptDefinitionDesignationComponent", "additionalUse", element.getAdditionalUse().get(i), i);
    }
    if (element.hasValueElement()) {
      composeString(t, "ConceptDefinitionDesignationComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeCodeSystemConceptPropertyComponent(Complex parent, String parentType, String name, CodeSystem.ConceptPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "ConceptPropertyComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ConceptPropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeCommunication(Complex parent, String parentType, String name, Communication element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Communication", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Communication", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "Communication", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "Communication", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Communication", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "Communication", "partOf", element.getPartOf().get(i), i);
    }
    for (int i = 0; i < element.getInResponseTo().size(); i++) {
      composeReference(t, "Communication", "inResponseTo", element.getInResponseTo().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Communication", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "Communication", "statusReason", element.getStatusReason(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Communication", "category", element.getCategory().get(i), i);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "Communication", "priority", element.getPriorityElement(), -1);
    }
    for (int i = 0; i < element.getMedium().size(); i++) {
      composeCodeableConcept(t, "Communication", "medium", element.getMedium().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "Communication", "subject", element.getSubject(), -1);
    }
    if (element.hasTopic()) {
      composeCodeableConcept(t, "Communication", "topic", element.getTopic(), -1);
    }
    for (int i = 0; i < element.getAbout().size(); i++) {
      composeReference(t, "Communication", "about", element.getAbout().get(i), i);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Communication", "encounter", element.getEncounter(), -1);
    }
    if (element.hasSentElement()) {
      composeDateTime(t, "Communication", "sent", element.getSentElement(), -1);
    }
    if (element.hasReceivedElement()) {
      composeDateTime(t, "Communication", "received", element.getReceivedElement(), -1);
    }
    for (int i = 0; i < element.getRecipient().size(); i++) {
      composeReference(t, "Communication", "recipient", element.getRecipient().get(i), i);
    }
    if (element.hasSender()) {
      composeReference(t, "Communication", "sender", element.getSender(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "Communication", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getPayload().size(); i++) {
      composeCommunicationPayloadComponent(t, "Communication", "payload", element.getPayload().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Communication", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCommunicationPayloadComponent(Complex parent, String parentType, String name, Communication.CommunicationPayloadComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payload", name, element, index);
    if (element.hasContent()) {
      composeType(t, "CommunicationPayloadComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeCommunicationRequest(Complex parent, String parentType, String name, CommunicationRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CommunicationRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CommunicationRequest", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "CommunicationRequest", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "CommunicationRequest", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "CommunicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CommunicationRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "CommunicationRequest", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "CommunicationRequest", "intent", element.getIntentElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "CommunicationRequest", "category", element.getCategory().get(i), i);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "CommunicationRequest", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "CommunicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    for (int i = 0; i < element.getMedium().size(); i++) {
      composeCodeableConcept(t, "CommunicationRequest", "medium", element.getMedium().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "CommunicationRequest", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getAbout().size(); i++) {
      composeReference(t, "CommunicationRequest", "about", element.getAbout().get(i), i);
    }
    if (element.hasEncounter()) {
      composeReference(t, "CommunicationRequest", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getPayload().size(); i++) {
      composeCommunicationRequestPayloadComponent(t, "CommunicationRequest", "payload", element.getPayload().get(i), i);
    }
    if (element.hasOccurrence()) {
      composeType(t, "CommunicationRequest", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "CommunicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "CommunicationRequest", "requester", element.getRequester(), -1);
    }
    for (int i = 0; i < element.getRecipient().size(); i++) {
      composeReference(t, "CommunicationRequest", "recipient", element.getRecipient().get(i), i);
    }
    for (int i = 0; i < element.getInformationProvider().size(); i++) {
      composeReference(t, "CommunicationRequest", "informationProvider", element.getInformationProvider().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "CommunicationRequest", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "CommunicationRequest", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCommunicationRequestPayloadComponent(Complex parent, String parentType, String name, CommunicationRequest.CommunicationRequestPayloadComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payload", name, element, index);
    if (element.hasContent()) {
      composeType(t, "CommunicationRequestPayloadComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeCompartmentDefinition(Complex parent, String parentType, String name, CompartmentDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "CompartmentDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "CompartmentDefinition", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CompartmentDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasVersionAlgorithm()) {
      composeType(t, "CompartmentDefinition", "versionAlgorithm", element.getVersionAlgorithm(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "CompartmentDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CompartmentDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CompartmentDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "CompartmentDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "CompartmentDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "CompartmentDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "CompartmentDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CompartmentDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "CompartmentDefinition", "useContext", element.getUseContext().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "CompartmentDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeEnum(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
    }
    if (element.hasSearchElement()) {
      composeBoolean(t, "CompartmentDefinition", "search", element.getSearchElement(), -1);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeCompartmentDefinitionResourceComponent(t, "CompartmentDefinition", "resource", element.getResource().get(i), i);
    }
  }

  protected void composeCompartmentDefinitionResourceComponent(Complex parent, String parentType, String name, CompartmentDefinition.CompartmentDefinitionResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "CompartmentDefinitionResourceComponent", "code", element.getCodeElement(), -1);
    }
    for (int i = 0; i < element.getParam().size(); i++) {
      composeString(t, "CompartmentDefinitionResourceComponent", "param", element.getParam().get(i), i);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "CompartmentDefinitionResourceComponent", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasStartParamElement()) {
      composeUri(t, "CompartmentDefinitionResourceComponent", "startParam", element.getStartParamElement(), -1);
    }
    if (element.hasEndParamElement()) {
      composeUri(t, "CompartmentDefinitionResourceComponent", "endParam", element.getEndParamElement(), -1);
    }
  }

  protected void composeComposition(Complex parent, String parentType, String name, Composition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Composition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Composition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Composition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Composition", "version", element.getVersionElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Composition", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Composition", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Composition", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "Composition", "subject", element.getSubject().get(i), i);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Composition", "encounter", element.getEncounter(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Composition", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Composition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "Composition", "author", element.getAuthor().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "Composition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Composition", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Composition", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getAttester().size(); i++) {
      composeCompositionAttesterComponent(t, "Composition", "attester", element.getAttester().get(i), i);
    }
    if (element.hasCustodian()) {
      composeReference(t, "Composition", "custodian", element.getCustodian(), -1);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeRelatedArtifact(t, "Composition", "relatesTo", element.getRelatesTo().get(i), i);
    }
    for (int i = 0; i < element.getEvent().size(); i++) {
      composeCompositionEventComponent(t, "Composition", "event", element.getEvent().get(i), i);
    }
    for (int i = 0; i < element.getSection().size(); i++) {
      composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
    }
  }

  protected void composeCompositionAttesterComponent(Complex parent, String parentType, String name, Composition.CompositionAttesterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "attester", name, element, index);
    if (element.hasMode()) {
      composeCodeableConcept(t, "CompositionAttesterComponent", "mode", element.getMode(), -1);
    }
    if (element.hasTimeElement()) {
      composeDateTime(t, "CompositionAttesterComponent", "time", element.getTimeElement(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "CompositionAttesterComponent", "party", element.getParty(), -1);
    }
  }

  protected void composeCompositionEventComponent(Complex parent, String parentType, String name, Composition.CompositionEventComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "event", name, element, index);
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "CompositionEventComponent", "code", element.getCode().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CompositionEventComponent", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeReference(t, "CompositionEventComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeCompositionSectionComponent(Complex parent, String parentType, String name, Composition.SectionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "section", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "SectionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "SectionComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "SectionComponent", "author", element.getAuthor().get(i), i);
    }
    if (element.hasFocus()) {
      composeReference(t, "SectionComponent", "focus", element.getFocus(), -1);
    }
    if (element.hasText()) {
      composeNarrative(t, "SectionComponent", "text", element.getText(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "SectionComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasOrderedBy()) {
      composeCodeableConcept(t, "SectionComponent", "orderedBy", element.getOrderedBy(), -1);
    }
    for (int i = 0; i < element.getEntry().size(); i++) {
      composeReference(t, "SectionComponent", "entry", element.getEntry().get(i), i);
    }
    if (element.hasEmptyReason()) {
      composeCodeableConcept(t, "SectionComponent", "emptyReason", element.getEmptyReason(), -1);
    }
    for (int i = 0; i < element.getSection().size(); i++) {
      composeCompositionSectionComponent(t, "SectionComponent", "section", element.getSection().get(i), i);
    }
  }

  protected void composeConceptMap(Complex parent, String parentType, String name, ConceptMap element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "ConceptMap", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ConceptMap", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ConceptMap", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ConceptMap", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ConceptMap", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ConceptMap", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ConceptMap", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ConceptMap", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ConceptMap", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ConceptMap", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ConceptMap", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ConceptMap", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ConceptMap", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ConceptMap", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ConceptMap", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ConceptMap", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ConceptMap", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "ConceptMap", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "ConceptMap", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "ConceptMap", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "ConceptMap", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "ConceptMap", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "ConceptMap", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "ConceptMap", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasSourceScope()) {
      composeType(t, "ConceptMap", "sourceScope", element.getSourceScope(), -1);
    }
    if (element.hasTargetScope()) {
      composeType(t, "ConceptMap", "targetScope", element.getTargetScope(), -1);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeConceptMapGroupComponent(t, "ConceptMap", "group", element.getGroup().get(i), i);
    }
  }

  protected void composeConceptMapGroupComponent(Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "group", name, element, index);
    if (element.hasSourceElement()) {
      composeCanonical(t, "ConceptMapGroupComponent", "source", element.getSourceElement(), -1);
    }
    if (element.hasTargetElement()) {
      composeCanonical(t, "ConceptMapGroupComponent", "target", element.getTargetElement(), -1);
    }
    for (int i = 0; i < element.getElement().size(); i++) {
      composeConceptMapSourceElementComponent(t, "ConceptMapGroupComponent", "element", element.getElement().get(i), i);
    }
    if (element.hasUnmapped()) {
      composeConceptMapGroupUnmappedComponent(t, "ConceptMapGroupComponent", "unmapped", element.getUnmapped(), -1);
    }
  }

  protected void composeConceptMapSourceElementComponent(Complex parent, String parentType, String name, ConceptMap.SourceElementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "element", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "SourceElementComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "SourceElementComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "SourceElementComponent", "valueSet", element.getValueSetElement(), -1);
    }
    if (element.hasNoMapElement()) {
      composeBoolean(t, "SourceElementComponent", "noMap", element.getNoMapElement(), -1);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeConceptMapTargetElementComponent(t, "SourceElementComponent", "target", element.getTarget().get(i), i);
    }
  }

  protected void composeConceptMapTargetElementComponent(Complex parent, String parentType, String name, ConceptMap.TargetElementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "TargetElementComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "TargetElementComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "TargetElementComponent", "valueSet", element.getValueSetElement(), -1);
    }
    if (element.hasRelationshipElement()) {
      composeEnum(t, "TargetElementComponent", "relationship", element.getRelationshipElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "TargetElementComponent", "comment", element.getCommentElement(), -1);
    }
    for (int i = 0; i < element.getDependsOn().size(); i++) {
      composeConceptMapOtherElementComponent(t, "TargetElementComponent", "dependsOn", element.getDependsOn().get(i), i);
    }
    for (int i = 0; i < element.getProduct().size(); i++) {
      composeConceptMapOtherElementComponent(t, "TargetElementComponent", "product", element.getProduct().get(i), i);
    }
  }

  protected void composeConceptMapOtherElementComponent(Complex parent, String parentType, String name, ConceptMap.OtherElementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dependsOn", name, element, index);
    if (element.hasPropertyElement()) {
      composeUri(t, "OtherElementComponent", "property", element.getPropertyElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "OtherElementComponent", "value", element.getValue(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "OtherElementComponent", "valueSet", element.getValueSetElement(), -1);
    }
  }

  protected void composeConceptMapGroupUnmappedComponent(Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupUnmappedComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "unmapped", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "ConceptMapGroupUnmappedComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "ConceptMapGroupUnmappedComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "ConceptMapGroupUnmappedComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "ConceptMapGroupUnmappedComponent", "valueSet", element.getValueSetElement(), -1);
    }
    if (element.hasRelationshipElement()) {
      composeEnum(t, "ConceptMapGroupUnmappedComponent", "relationship", element.getRelationshipElement(), -1);
    }
    if (element.hasOtherMapElement()) {
      composeCanonical(t, "ConceptMapGroupUnmappedComponent", "otherMap", element.getOtherMapElement(), -1);
    }
  }

  protected void composeCondition(Complex parent, String parentType, String name, Condition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Condition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Condition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasClinicalStatus()) {
      composeCodeableConcept(t, "Condition", "clinicalStatus", element.getClinicalStatus(), -1);
    }
    if (element.hasVerificationStatus()) {
      composeCodeableConcept(t, "Condition", "verificationStatus", element.getVerificationStatus(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Condition", "category", element.getCategory().get(i), i);
    }
    if (element.hasSeverity()) {
      composeCodeableConcept(t, "Condition", "severity", element.getSeverity(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Condition", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeCodeableConcept(t, "Condition", "bodySite", element.getBodySite().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "Condition", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Condition", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOnset()) {
      composeType(t, "Condition", "onset", element.getOnset(), -1);
    }
    if (element.hasAbatement()) {
      composeType(t, "Condition", "abatement", element.getAbatement(), -1);
    }
    if (element.hasRecordedDateElement()) {
      composeDateTime(t, "Condition", "recordedDate", element.getRecordedDateElement(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeConditionParticipantComponent(t, "Condition", "participant", element.getParticipant().get(i), i);
    }
    for (int i = 0; i < element.getStage().size(); i++) {
      composeConditionStageComponent(t, "Condition", "stage", element.getStage().get(i), i);
    }
    for (int i = 0; i < element.getEvidence().size(); i++) {
      composeCodeableReference(t, "Condition", "evidence", element.getEvidence().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Condition", "note", element.getNote().get(i), i);
    }
  }

  protected void composeConditionParticipantComponent(Complex parent, String parentType, String name, Condition.ConditionParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ConditionParticipantComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ConditionParticipantComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeConditionStageComponent(Complex parent, String parentType, String name, Condition.ConditionStageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "stage", name, element, index);
    if (element.hasSummary()) {
      composeCodeableConcept(t, "ConditionStageComponent", "summary", element.getSummary(), -1);
    }
    for (int i = 0; i < element.getAssessment().size(); i++) {
      composeReference(t, "ConditionStageComponent", "assessment", element.getAssessment().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ConditionStageComponent", "type", element.getType(), -1);
    }
  }

  protected void composeConditionDefinition(Complex parent, String parentType, String name, ConditionDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "ConditionDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ConditionDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ConditionDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ConditionDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ConditionDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ConditionDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "ConditionDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ConditionDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ConditionDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ConditionDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ConditionDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ConditionDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ConditionDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ConditionDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ConditionDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ConditionDefinition", "code", element.getCode(), -1);
    }
    if (element.hasSeverity()) {
      composeCodeableConcept(t, "ConditionDefinition", "severity", element.getSeverity(), -1);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "ConditionDefinition", "bodySite", element.getBodySite(), -1);
    }
    if (element.hasStage()) {
      composeCodeableConcept(t, "ConditionDefinition", "stage", element.getStage(), -1);
    }
    if (element.hasHasSeverityElement()) {
      composeBoolean(t, "ConditionDefinition", "hasSeverity", element.getHasSeverityElement(), -1);
    }
    if (element.hasHasBodySiteElement()) {
      composeBoolean(t, "ConditionDefinition", "hasBodySite", element.getHasBodySiteElement(), -1);
    }
    if (element.hasHasStageElement()) {
      composeBoolean(t, "ConditionDefinition", "hasStage", element.getHasStageElement(), -1);
    }
    for (int i = 0; i < element.getDefinition().size(); i++) {
      composeUri(t, "ConditionDefinition", "definition", element.getDefinition().get(i), i);
    }
    for (int i = 0; i < element.getObservation().size(); i++) {
      composeConditionDefinitionObservationComponent(t, "ConditionDefinition", "observation", element.getObservation().get(i), i);
    }
    for (int i = 0; i < element.getMedication().size(); i++) {
      composeConditionDefinitionMedicationComponent(t, "ConditionDefinition", "medication", element.getMedication().get(i), i);
    }
    for (int i = 0; i < element.getPrecondition().size(); i++) {
      composeConditionDefinitionPreconditionComponent(t, "ConditionDefinition", "precondition", element.getPrecondition().get(i), i);
    }
    for (int i = 0; i < element.getTeam().size(); i++) {
      composeReference(t, "ConditionDefinition", "team", element.getTeam().get(i), i);
    }
    for (int i = 0; i < element.getQuestionnaire().size(); i++) {
      composeConditionDefinitionQuestionnaireComponent(t, "ConditionDefinition", "questionnaire", element.getQuestionnaire().get(i), i);
    }
    for (int i = 0; i < element.getPlan().size(); i++) {
      composeConditionDefinitionPlanComponent(t, "ConditionDefinition", "plan", element.getPlan().get(i), i);
    }
  }

  protected void composeConditionDefinitionObservationComponent(Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionObservationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "observation", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "ConditionDefinitionObservationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ConditionDefinitionObservationComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeConditionDefinitionMedicationComponent(Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionMedicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "medication", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "ConditionDefinitionMedicationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ConditionDefinitionMedicationComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeConditionDefinitionPreconditionComponent(Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionPreconditionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "precondition", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "ConditionDefinitionPreconditionComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ConditionDefinitionPreconditionComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ConditionDefinitionPreconditionComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeConditionDefinitionQuestionnaireComponent(Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionQuestionnaireComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "questionnaire", name, element, index);
    if (element.hasPurposeElement()) {
      composeEnum(t, "ConditionDefinitionQuestionnaireComponent", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "ConditionDefinitionQuestionnaireComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeConditionDefinitionPlanComponent(Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionPlanComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "plan", name, element, index);
    if (element.hasRole()) {
      composeCodeableConcept(t, "ConditionDefinitionPlanComponent", "role", element.getRole(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "ConditionDefinitionPlanComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeConsent(Complex parent, String parentType, String name, Consent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Consent", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Consent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Consent", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Consent", "category", element.getCategory().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "Consent", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDate(t, "Consent", "date", element.getDateElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Consent", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getGrantor().size(); i++) {
      composeReference(t, "Consent", "grantor", element.getGrantor().get(i), i);
    }
    for (int i = 0; i < element.getGrantee().size(); i++) {
      composeReference(t, "Consent", "grantee", element.getGrantee().get(i), i);
    }
    for (int i = 0; i < element.getManager().size(); i++) {
      composeReference(t, "Consent", "manager", element.getManager().get(i), i);
    }
    for (int i = 0; i < element.getController().size(); i++) {
      composeReference(t, "Consent", "controller", element.getController().get(i), i);
    }
    for (int i = 0; i < element.getSourceAttachment().size(); i++) {
      composeAttachment(t, "Consent", "sourceAttachment", element.getSourceAttachment().get(i), i);
    }
    for (int i = 0; i < element.getSourceReference().size(); i++) {
      composeReference(t, "Consent", "sourceReference", element.getSourceReference().get(i), i);
    }
    for (int i = 0; i < element.getRegulatoryBasis().size(); i++) {
      composeCodeableConcept(t, "Consent", "regulatoryBasis", element.getRegulatoryBasis().get(i), i);
    }
    if (element.hasPolicyBasis()) {
      composeConsentPolicyBasisComponent(t, "Consent", "policyBasis", element.getPolicyBasis(), -1);
    }
    for (int i = 0; i < element.getPolicyText().size(); i++) {
      composeReference(t, "Consent", "policyText", element.getPolicyText().get(i), i);
    }
    for (int i = 0; i < element.getVerification().size(); i++) {
      composeConsentVerificationComponent(t, "Consent", "verification", element.getVerification().get(i), i);
    }
    if (element.hasProvision()) {
      composeConsentProvisionComponent(t, "Consent", "provision", element.getProvision(), -1);
    }
  }

  protected void composeConsentPolicyBasisComponent(Complex parent, String parentType, String name, Consent.ConsentPolicyBasisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "policyBasis", name, element, index);
    if (element.hasReference()) {
      composeReference(t, "ConsentPolicyBasisComponent", "reference", element.getReference(), -1);
    }
    if (element.hasUrlElement()) {
      composeUrl(t, "ConsentPolicyBasisComponent", "url", element.getUrlElement(), -1);
    }
  }

  protected void composeConsentVerificationComponent(Complex parent, String parentType, String name, Consent.ConsentVerificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "verification", name, element, index);
    if (element.hasVerifiedElement()) {
      composeBoolean(t, "ConsentVerificationComponent", "verified", element.getVerifiedElement(), -1);
    }
    if (element.hasVerificationType()) {
      composeCodeableConcept(t, "ConsentVerificationComponent", "verificationType", element.getVerificationType(), -1);
    }
    if (element.hasVerifiedBy()) {
      composeReference(t, "ConsentVerificationComponent", "verifiedBy", element.getVerifiedBy(), -1);
    }
    if (element.hasVerifiedWith()) {
      composeReference(t, "ConsentVerificationComponent", "verifiedWith", element.getVerifiedWith(), -1);
    }
    for (int i = 0; i < element.getVerificationDate().size(); i++) {
      composeDateTime(t, "ConsentVerificationComponent", "verificationDate", element.getVerificationDate().get(i), i);
    }
  }

  protected void composeConsentProvisionComponent(Complex parent, String parentType, String name, Consent.ProvisionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "provision", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "ProvisionComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ProvisionComponent", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getActor().size(); i++) {
      composeConsentProvisionActorComponent(t, "ProvisionComponent", "actor", element.getActor().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeCodeableConcept(t, "ProvisionComponent", "action", element.getAction().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabel().size(); i++) {
      composeCoding(t, "ProvisionComponent", "securityLabel", element.getSecurityLabel().get(i), i);
    }
    for (int i = 0; i < element.getPurpose().size(); i++) {
      composeCoding(t, "ProvisionComponent", "purpose", element.getPurpose().get(i), i);
    }
    for (int i = 0; i < element.getDocumentType().size(); i++) {
      composeCoding(t, "ProvisionComponent", "documentType", element.getDocumentType().get(i), i);
    }
    for (int i = 0; i < element.getResourceType().size(); i++) {
      composeCoding(t, "ProvisionComponent", "resourceType", element.getResourceType().get(i), i);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "ProvisionComponent", "code", element.getCode().get(i), i);
    }
    if (element.hasDataPeriod()) {
      composePeriod(t, "ProvisionComponent", "dataPeriod", element.getDataPeriod(), -1);
    }
    for (int i = 0; i < element.getData().size(); i++) {
      composeConsentProvisionDataComponent(t, "ProvisionComponent", "data", element.getData().get(i), i);
    }
    if (element.hasExpression()) {
      composeExpression(t, "ProvisionComponent", "expression", element.getExpression(), -1);
    }
    for (int i = 0; i < element.getProvision().size(); i++) {
      composeConsentProvisionComponent(t, "ProvisionComponent", "provision", element.getProvision().get(i), i);
    }
  }

  protected void composeConsentProvisionActorComponent(Complex parent, String parentType, String name, Consent.ProvisionActorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "actor", name, element, index);
    if (element.hasRole()) {
      composeCodeableConcept(t, "ProvisionActorComponent", "role", element.getRole(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "ProvisionActorComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeConsentProvisionDataComponent(Complex parent, String parentType, String name, Consent.ProvisionDataComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "data", name, element, index);
    if (element.hasMeaningElement()) {
      composeEnum(t, "ProvisionDataComponent", "meaning", element.getMeaningElement(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "ProvisionDataComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeContract(Complex parent, String parentType, String name, Contract element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Contract", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Contract", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "Contract", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Contract", "version", element.getVersionElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Contract", "status", element.getStatusElement(), -1);
    }
    if (element.hasLegalState()) {
      composeCodeableConcept(t, "Contract", "legalState", element.getLegalState(), -1);
    }
    if (element.hasInstantiatesCanonical()) {
      composeReference(t, "Contract", "instantiatesCanonical", element.getInstantiatesCanonical(), -1);
    }
    if (element.hasInstantiatesUriElement()) {
      composeUri(t, "Contract", "instantiatesUri", element.getInstantiatesUriElement(), -1);
    }
    if (element.hasContentDerivative()) {
      composeCodeableConcept(t, "Contract", "contentDerivative", element.getContentDerivative(), -1);
    }
    if (element.hasIssuedElement()) {
      composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
    }
    if (element.hasApplies()) {
      composePeriod(t, "Contract", "applies", element.getApplies(), -1);
    }
    if (element.hasExpirationType()) {
      composeCodeableConcept(t, "Contract", "expirationType", element.getExpirationType(), -1);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "Contract", "subject", element.getSubject().get(i), i);
    }
    for (int i = 0; i < element.getAuthority().size(); i++) {
      composeReference(t, "Contract", "authority", element.getAuthority().get(i), i);
    }
    for (int i = 0; i < element.getDomain().size(); i++) {
      composeReference(t, "Contract", "domain", element.getDomain().get(i), i);
    }
    for (int i = 0; i < element.getSite().size(); i++) {
      composeReference(t, "Contract", "site", element.getSite().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "Contract", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Contract", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "Contract", "subtitle", element.getSubtitleElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "Contract", "alias", element.getAlias().get(i), i);
    }
    if (element.hasAuthor()) {
      composeReference(t, "Contract", "author", element.getAuthor(), -1);
    }
    if (element.hasScope()) {
      composeCodeableConcept(t, "Contract", "scope", element.getScope(), -1);
    }
    if (element.hasTopic()) {
      composeType(t, "Contract", "topic", element.getTopic(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getSubType().size(); i++) {
      composeCodeableConcept(t, "Contract", "subType", element.getSubType().get(i), i);
    }
    if (element.hasContentDefinition()) {
      composeContractContentDefinitionComponent(t, "Contract", "contentDefinition", element.getContentDefinition(), -1);
    }
    for (int i = 0; i < element.getTerm().size(); i++) {
      composeContractTermComponent(t, "Contract", "term", element.getTerm().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "Contract", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getRelevantHistory().size(); i++) {
      composeReference(t, "Contract", "relevantHistory", element.getRelevantHistory().get(i), i);
    }
    for (int i = 0; i < element.getSigner().size(); i++) {
      composeContractSignatoryComponent(t, "Contract", "signer", element.getSigner().get(i), i);
    }
    for (int i = 0; i < element.getFriendly().size(); i++) {
      composeContractFriendlyLanguageComponent(t, "Contract", "friendly", element.getFriendly().get(i), i);
    }
    for (int i = 0; i < element.getLegal().size(); i++) {
      composeContractLegalLanguageComponent(t, "Contract", "legal", element.getLegal().get(i), i);
    }
    for (int i = 0; i < element.getRule().size(); i++) {
      composeContractComputableLanguageComponent(t, "Contract", "rule", element.getRule().get(i), i);
    }
    if (element.hasLegallyBinding()) {
      composeType(t, "Contract", "legallyBinding", element.getLegallyBinding(), -1);
    }
  }

  protected void composeContractContentDefinitionComponent(Complex parent, String parentType, String name, Contract.ContentDefinitionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contentDefinition", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ContentDefinitionComponent", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "ContentDefinitionComponent", "subType", element.getSubType(), -1);
    }
    if (element.hasPublisher()) {
      composeReference(t, "ContentDefinitionComponent", "publisher", element.getPublisher(), -1);
    }
    if (element.hasPublicationDateElement()) {
      composeDateTime(t, "ContentDefinitionComponent", "publicationDate", element.getPublicationDateElement(), -1);
    }
    if (element.hasPublicationStatusElement()) {
      composeEnum(t, "ContentDefinitionComponent", "publicationStatus", element.getPublicationStatusElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ContentDefinitionComponent", "copyright", element.getCopyrightElement(), -1);
    }
  }

  protected void composeContractTermComponent(Complex parent, String parentType, String name, Contract.TermComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "term", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "TermComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasIssuedElement()) {
      composeDateTime(t, "TermComponent", "issued", element.getIssuedElement(), -1);
    }
    if (element.hasApplies()) {
      composePeriod(t, "TermComponent", "applies", element.getApplies(), -1);
    }
    if (element.hasTopic()) {
      composeType(t, "TermComponent", "topic", element.getTopic(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "TermComponent", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "TermComponent", "subType", element.getSubType(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "TermComponent", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getSecurityLabel().size(); i++) {
      composeContractSecurityLabelComponent(t, "TermComponent", "securityLabel", element.getSecurityLabel().get(i), i);
    }
    if (element.hasOffer()) {
      composeContractOfferComponent(t, "TermComponent", "offer", element.getOffer(), -1);
    }
    for (int i = 0; i < element.getAsset().size(); i++) {
      composeContractAssetComponent(t, "TermComponent", "asset", element.getAsset().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeContractActionComponent(t, "TermComponent", "action", element.getAction().get(i), i);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeContractTermComponent(t, "TermComponent", "group", element.getGroup().get(i), i);
    }
  }

  protected void composeContractSecurityLabelComponent(Complex parent, String parentType, String name, Contract.SecurityLabelComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "securityLabel", name, element, index);
    for (int i = 0; i < element.getNumber().size(); i++) {
      composeUnsignedInt(t, "SecurityLabelComponent", "number", element.getNumber().get(i), i);
    }
    if (element.hasClassification()) {
      composeCoding(t, "SecurityLabelComponent", "classification", element.getClassification(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCoding(t, "SecurityLabelComponent", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getControl().size(); i++) {
      composeCoding(t, "SecurityLabelComponent", "control", element.getControl().get(i), i);
    }
  }

  protected void composeContractOfferComponent(Complex parent, String parentType, String name, Contract.ContractOfferComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "offer", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ContractOfferComponent", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getParty().size(); i++) {
      composeContractPartyComponent(t, "ContractOfferComponent", "party", element.getParty().get(i), i);
    }
    if (element.hasTopic()) {
      composeReference(t, "ContractOfferComponent", "topic", element.getTopic(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ContractOfferComponent", "type", element.getType(), -1);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "ContractOfferComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getDecisionMode().size(); i++) {
      composeCodeableConcept(t, "ContractOfferComponent", "decisionMode", element.getDecisionMode().get(i), i);
    }
    for (int i = 0; i < element.getAnswer().size(); i++) {
      composeContractAnswerComponent(t, "ContractOfferComponent", "answer", element.getAnswer().get(i), i);
    }
    if (element.hasTextElement()) {
      composeString(t, "ContractOfferComponent", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getLinkId().size(); i++) {
      composeString(t, "ContractOfferComponent", "linkId", element.getLinkId().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabelNumber().size(); i++) {
      composeUnsignedInt(t, "ContractOfferComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
    }
  }

  protected void composeContractPartyComponent(Complex parent, String parentType, String name, Contract.ContractPartyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "party", name, element, index);
    for (int i = 0; i < element.getReference().size(); i++) {
      composeReference(t, "ContractPartyComponent", "reference", element.getReference().get(i), i);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "ContractPartyComponent", "role", element.getRole(), -1);
    }
  }

  protected void composeContractAnswerComponent(Complex parent, String parentType, String name, Contract.AnswerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "answer", name, element, index);
    if (element.hasValue()) {
      composeType(t, "AnswerComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeContractAssetComponent(Complex parent, String parentType, String name, Contract.ContractAssetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "asset", name, element, index);
    if (element.hasScope()) {
      composeCodeableConcept(t, "ContractAssetComponent", "scope", element.getScope(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "ContractAssetComponent", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getTypeReference().size(); i++) {
      composeReference(t, "ContractAssetComponent", "typeReference", element.getTypeReference().get(i), i);
    }
    for (int i = 0; i < element.getSubtype().size(); i++) {
      composeCodeableConcept(t, "ContractAssetComponent", "subtype", element.getSubtype().get(i), i);
    }
    if (element.hasRelationship()) {
      composeCoding(t, "ContractAssetComponent", "relationship", element.getRelationship(), -1);
    }
    for (int i = 0; i < element.getContext().size(); i++) {
      composeContractAssetContextComponent(t, "ContractAssetComponent", "context", element.getContext().get(i), i);
    }
    if (element.hasConditionElement()) {
      composeString(t, "ContractAssetComponent", "condition", element.getConditionElement(), -1);
    }
    for (int i = 0; i < element.getPeriodType().size(); i++) {
      composeCodeableConcept(t, "ContractAssetComponent", "periodType", element.getPeriodType().get(i), i);
    }
    for (int i = 0; i < element.getPeriod().size(); i++) {
      composePeriod(t, "ContractAssetComponent", "period", element.getPeriod().get(i), i);
    }
    for (int i = 0; i < element.getUsePeriod().size(); i++) {
      composePeriod(t, "ContractAssetComponent", "usePeriod", element.getUsePeriod().get(i), i);
    }
    if (element.hasTextElement()) {
      composeString(t, "ContractAssetComponent", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getLinkId().size(); i++) {
      composeString(t, "ContractAssetComponent", "linkId", element.getLinkId().get(i), i);
    }
    for (int i = 0; i < element.getAnswer().size(); i++) {
      composeContractAnswerComponent(t, "ContractAssetComponent", "answer", element.getAnswer().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabelNumber().size(); i++) {
      composeUnsignedInt(t, "ContractAssetComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
    }
    for (int i = 0; i < element.getValuedItem().size(); i++) {
      composeContractValuedItemComponent(t, "ContractAssetComponent", "valuedItem", element.getValuedItem().get(i), i);
    }
  }

  protected void composeContractAssetContextComponent(Complex parent, String parentType, String name, Contract.AssetContextComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "context", name, element, index);
    if (element.hasReference()) {
      composeReference(t, "AssetContextComponent", "reference", element.getReference(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "AssetContextComponent", "code", element.getCode().get(i), i);
    }
    if (element.hasTextElement()) {
      composeString(t, "AssetContextComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composeContractValuedItemComponent(Complex parent, String parentType, String name, Contract.ValuedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "valuedItem", name, element, index);
    if (element.hasEntity()) {
      composeType(t, "ValuedItemComponent", "entity", element.getEntity(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "ValuedItemComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasEffectiveTimeElement()) {
      composeDateTime(t, "ValuedItemComponent", "effectiveTime", element.getEffectiveTimeElement(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ValuedItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "ValuedItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "ValuedItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasPointsElement()) {
      composeDecimal(t, "ValuedItemComponent", "points", element.getPointsElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "ValuedItemComponent", "net", element.getNet(), -1);
    }
    if (element.hasPaymentElement()) {
      composeString(t, "ValuedItemComponent", "payment", element.getPaymentElement(), -1);
    }
    if (element.hasPaymentDateElement()) {
      composeDateTime(t, "ValuedItemComponent", "paymentDate", element.getPaymentDateElement(), -1);
    }
    if (element.hasResponsible()) {
      composeReference(t, "ValuedItemComponent", "responsible", element.getResponsible(), -1);
    }
    if (element.hasRecipient()) {
      composeReference(t, "ValuedItemComponent", "recipient", element.getRecipient(), -1);
    }
    for (int i = 0; i < element.getLinkId().size(); i++) {
      composeString(t, "ValuedItemComponent", "linkId", element.getLinkId().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabelNumber().size(); i++) {
      composeUnsignedInt(t, "ValuedItemComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
    }
  }

  protected void composeContractActionComponent(Complex parent, String parentType, String name, Contract.ActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "ActionComponent", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ActionComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeContractActionSubjectComponent(t, "ActionComponent", "subject", element.getSubject().get(i), i);
    }
    if (element.hasIntent()) {
      composeCodeableConcept(t, "ActionComponent", "intent", element.getIntent(), -1);
    }
    for (int i = 0; i < element.getLinkId().size(); i++) {
      composeString(t, "ActionComponent", "linkId", element.getLinkId().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "ActionComponent", "status", element.getStatus(), -1);
    }
    if (element.hasContext()) {
      composeReference(t, "ActionComponent", "context", element.getContext(), -1);
    }
    for (int i = 0; i < element.getContextLinkId().size(); i++) {
      composeString(t, "ActionComponent", "contextLinkId", element.getContextLinkId().get(i), i);
    }
    if (element.hasOccurrence()) {
      composeType(t, "ActionComponent", "occurrence", element.getOccurrence(), -1);
    }
    for (int i = 0; i < element.getRequester().size(); i++) {
      composeReference(t, "ActionComponent", "requester", element.getRequester().get(i), i);
    }
    for (int i = 0; i < element.getRequesterLinkId().size(); i++) {
      composeString(t, "ActionComponent", "requesterLinkId", element.getRequesterLinkId().get(i), i);
    }
    for (int i = 0; i < element.getPerformerType().size(); i++) {
      composeCodeableConcept(t, "ActionComponent", "performerType", element.getPerformerType().get(i), i);
    }
    if (element.hasPerformerRole()) {
      composeCodeableConcept(t, "ActionComponent", "performerRole", element.getPerformerRole(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "ActionComponent", "performer", element.getPerformer(), -1);
    }
    for (int i = 0; i < element.getPerformerLinkId().size(); i++) {
      composeString(t, "ActionComponent", "performerLinkId", element.getPerformerLinkId().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "ActionComponent", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getReasonLinkId().size(); i++) {
      composeString(t, "ActionComponent", "reasonLinkId", element.getReasonLinkId().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ActionComponent", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabelNumber().size(); i++) {
      composeUnsignedInt(t, "ActionComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
    }
  }

  protected void composeContractActionSubjectComponent(Complex parent, String parentType, String name, Contract.ActionSubjectComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subject", name, element, index);
    for (int i = 0; i < element.getReference().size(); i++) {
      composeReference(t, "ActionSubjectComponent", "reference", element.getReference().get(i), i);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "ActionSubjectComponent", "role", element.getRole(), -1);
    }
  }

  protected void composeContractSignatoryComponent(Complex parent, String parentType, String name, Contract.SignatoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "signer", name, element, index);
    if (element.hasType()) {
      composeCoding(t, "SignatoryComponent", "type", element.getType(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "SignatoryComponent", "party", element.getParty(), -1);
    }
    for (int i = 0; i < element.getSignature().size(); i++) {
      composeSignature(t, "SignatoryComponent", "signature", element.getSignature().get(i), i);
    }
  }

  protected void composeContractFriendlyLanguageComponent(Complex parent, String parentType, String name, Contract.FriendlyLanguageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "friendly", name, element, index);
    if (element.hasContent()) {
      composeType(t, "FriendlyLanguageComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeContractLegalLanguageComponent(Complex parent, String parentType, String name, Contract.LegalLanguageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "legal", name, element, index);
    if (element.hasContent()) {
      composeType(t, "LegalLanguageComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeContractComputableLanguageComponent(Complex parent, String parentType, String name, Contract.ComputableLanguageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "rule", name, element, index);
    if (element.hasContent()) {
      composeType(t, "ComputableLanguageComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeCoverage(Complex parent, String parentType, String name, Coverage element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Coverage", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Coverage", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Coverage", "status", element.getStatusElement(), -1);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "Coverage", "kind", element.getKindElement(), -1);
    }
    for (int i = 0; i < element.getPaymentBy().size(); i++) {
      composeCoveragePaymentByComponent(t, "Coverage", "paymentBy", element.getPaymentBy().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
    }
    if (element.hasPolicyHolder()) {
      composeReference(t, "Coverage", "policyHolder", element.getPolicyHolder(), -1);
    }
    if (element.hasSubscriber()) {
      composeReference(t, "Coverage", "subscriber", element.getSubscriber(), -1);
    }
    for (int i = 0; i < element.getSubscriberId().size(); i++) {
      composeIdentifier(t, "Coverage", "subscriberId", element.getSubscriberId().get(i), i);
    }
    if (element.hasBeneficiary()) {
      composeReference(t, "Coverage", "beneficiary", element.getBeneficiary(), -1);
    }
    if (element.hasDependentElement()) {
      composeString(t, "Coverage", "dependent", element.getDependentElement(), -1);
    }
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "Coverage", "relationship", element.getRelationship(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Coverage", "period", element.getPeriod(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "Coverage", "insurer", element.getInsurer(), -1);
    }
    for (int i = 0; i < element.getClass_().size(); i++) {
      composeCoverageClassComponent(t, "Coverage", "class", element.getClass_().get(i), i);
    }
    if (element.hasOrderElement()) {
      composePositiveInt(t, "Coverage", "order", element.getOrderElement(), -1);
    }
    if (element.hasNetworkElement()) {
      composeString(t, "Coverage", "network", element.getNetworkElement(), -1);
    }
    for (int i = 0; i < element.getCostToBeneficiary().size(); i++) {
      composeCoverageCostToBeneficiaryComponent(t, "Coverage", "costToBeneficiary", element.getCostToBeneficiary().get(i), i);
    }
    if (element.hasSubrogationElement()) {
      composeBoolean(t, "Coverage", "subrogation", element.getSubrogationElement(), -1);
    }
    for (int i = 0; i < element.getContract().size(); i++) {
      composeReference(t, "Coverage", "contract", element.getContract().get(i), i);
    }
    if (element.hasInsurancePlan()) {
      composeReference(t, "Coverage", "insurancePlan", element.getInsurancePlan(), -1);
    }
  }

  protected void composeCoveragePaymentByComponent(Complex parent, String parentType, String name, Coverage.CoveragePaymentByComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "paymentBy", name, element, index);
    if (element.hasParty()) {
      composeReference(t, "CoveragePaymentByComponent", "party", element.getParty(), -1);
    }
    if (element.hasResponsibilityElement()) {
      composeString(t, "CoveragePaymentByComponent", "responsibility", element.getResponsibilityElement(), -1);
    }
  }

  protected void composeCoverageClassComponent(Complex parent, String parentType, String name, Coverage.ClassComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "class", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ClassComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeIdentifier(t, "ClassComponent", "value", element.getValue(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ClassComponent", "name", element.getNameElement(), -1);
    }
  }

  protected void composeCoverageCostToBeneficiaryComponent(Complex parent, String parentType, String name, Coverage.CostToBeneficiaryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "costToBeneficiary", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CostToBeneficiaryComponent", "type", element.getType(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "CostToBeneficiaryComponent", "category", element.getCategory(), -1);
    }
    if (element.hasNetwork()) {
      composeCodeableConcept(t, "CostToBeneficiaryComponent", "network", element.getNetwork(), -1);
    }
    if (element.hasUnit()) {
      composeCodeableConcept(t, "CostToBeneficiaryComponent", "unit", element.getUnit(), -1);
    }
    if (element.hasTerm()) {
      composeCodeableConcept(t, "CostToBeneficiaryComponent", "term", element.getTerm(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "CostToBeneficiaryComponent", "value", element.getValue(), -1);
    }
    for (int i = 0; i < element.getException().size(); i++) {
      composeCoverageExemptionComponent(t, "CostToBeneficiaryComponent", "exception", element.getException().get(i), i);
    }
  }

  protected void composeCoverageExemptionComponent(Complex parent, String parentType, String name, Coverage.ExemptionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "exception", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ExemptionComponent", "type", element.getType(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ExemptionComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeCoverageEligibilityRequest(Complex parent, String parentType, String name, CoverageEligibilityRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CoverageEligibilityRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CoverageEligibilityRequest", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CoverageEligibilityRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "CoverageEligibilityRequest", "priority", element.getPriority(), -1);
    }
    for (int i = 0; i < element.getPurpose().size(); i++) {
      composeEnum(t, "CoverageEligibilityRequest", "purpose", element.getPurpose().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "CoverageEligibilityRequest", "patient", element.getPatient(), -1);
    }
    if (element.hasServiced()) {
      composeType(t, "CoverageEligibilityRequest", "serviced", element.getServiced(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "CoverageEligibilityRequest", "created", element.getCreatedElement(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "CoverageEligibilityRequest", "enterer", element.getEnterer(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "CoverageEligibilityRequest", "provider", element.getProvider(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "CoverageEligibilityRequest", "insurer", element.getInsurer(), -1);
    }
    if (element.hasFacility()) {
      composeReference(t, "CoverageEligibilityRequest", "facility", element.getFacility(), -1);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeCoverageEligibilityRequestSupportingInformationComponent(t, "CoverageEligibilityRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeCoverageEligibilityRequestInsuranceComponent(t, "CoverageEligibilityRequest", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeCoverageEligibilityRequestDetailsComponent(t, "CoverageEligibilityRequest", "item", element.getItem().get(i), i);
    }
  }

  protected void composeCoverageEligibilityRequestSupportingInformationComponent(Complex parent, String parentType, String name, CoverageEligibilityRequest.SupportingInformationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportingInfo", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasInformation()) {
      composeReference(t, "SupportingInformationComponent", "information", element.getInformation(), -1);
    }
    if (element.hasAppliesToAllElement()) {
      composeBoolean(t, "SupportingInformationComponent", "appliesToAll", element.getAppliesToAllElement(), -1);
    }
  }

  protected void composeCoverageEligibilityRequestInsuranceComponent(Complex parent, String parentType, String name, CoverageEligibilityRequest.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasFocalElement()) {
      composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasBusinessArrangementElement()) {
      composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
    }
  }

  protected void composeCoverageEligibilityRequestDetailsComponent(Complex parent, String parentType, String name, CoverageEligibilityRequest.DetailsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    for (int i = 0; i < element.getSupportingInfoSequence().size(); i++) {
      composePositiveInt(t, "DetailsComponent", "supportingInfoSequence", element.getSupportingInfoSequence().get(i), i);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "DetailsComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "DetailsComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "DetailsComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasProvider()) {
      composeReference(t, "DetailsComponent", "provider", element.getProvider(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "DetailsComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "DetailsComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFacility()) {
      composeReference(t, "DetailsComponent", "facility", element.getFacility(), -1);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeCoverageEligibilityRequestDiagnosisComponent(t, "DetailsComponent", "diagnosis", element.getDiagnosis().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeReference(t, "DetailsComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeCoverageEligibilityRequestDiagnosisComponent(Complex parent, String parentType, String name, CoverageEligibilityRequest.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasDiagnosis()) {
      composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
    }
  }

  protected void composeCoverageEligibilityResponse(Complex parent, String parentType, String name, CoverageEligibilityResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CoverageEligibilityResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CoverageEligibilityResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CoverageEligibilityResponse", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getPurpose().size(); i++) {
      composeEnum(t, "CoverageEligibilityResponse", "purpose", element.getPurpose().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "CoverageEligibilityResponse", "patient", element.getPatient(), -1);
    }
    if (element.hasServiced()) {
      composeType(t, "CoverageEligibilityResponse", "serviced", element.getServiced(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "CoverageEligibilityResponse", "created", element.getCreatedElement(), -1);
    }
    if (element.hasRequestor()) {
      composeReference(t, "CoverageEligibilityResponse", "requestor", element.getRequestor(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "CoverageEligibilityResponse", "request", element.getRequest(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "CoverageEligibilityResponse", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "CoverageEligibilityResponse", "disposition", element.getDispositionElement(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "CoverageEligibilityResponse", "insurer", element.getInsurer(), -1);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeCoverageEligibilityResponseInsuranceComponent(t, "CoverageEligibilityResponse", "insurance", element.getInsurance().get(i), i);
    }
    if (element.hasPreAuthRefElement()) {
      composeString(t, "CoverageEligibilityResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
    }
    if (element.hasForm()) {
      composeCodeableConcept(t, "CoverageEligibilityResponse", "form", element.getForm(), -1);
    }
    for (int i = 0; i < element.getError().size(); i++) {
      composeCoverageEligibilityResponseErrorsComponent(t, "CoverageEligibilityResponse", "error", element.getError().get(i), i);
    }
  }

  protected void composeCoverageEligibilityResponseInsuranceComponent(Complex parent, String parentType, String name, CoverageEligibilityResponse.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasInforceElement()) {
      composeBoolean(t, "InsuranceComponent", "inforce", element.getInforceElement(), -1);
    }
    if (element.hasBenefitPeriod()) {
      composePeriod(t, "InsuranceComponent", "benefitPeriod", element.getBenefitPeriod(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeCoverageEligibilityResponseItemsComponent(t, "InsuranceComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeCoverageEligibilityResponseItemsComponent(Complex parent, String parentType, String name, CoverageEligibilityResponse.ItemsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "ItemsComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "ItemsComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "ItemsComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasProvider()) {
      composeReference(t, "ItemsComponent", "provider", element.getProvider(), -1);
    }
    if (element.hasExcludedElement()) {
      composeBoolean(t, "ItemsComponent", "excluded", element.getExcludedElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ItemsComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ItemsComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasNetwork()) {
      composeCodeableConcept(t, "ItemsComponent", "network", element.getNetwork(), -1);
    }
    if (element.hasUnit()) {
      composeCodeableConcept(t, "ItemsComponent", "unit", element.getUnit(), -1);
    }
    if (element.hasTerm()) {
      composeCodeableConcept(t, "ItemsComponent", "term", element.getTerm(), -1);
    }
    for (int i = 0; i < element.getBenefit().size(); i++) {
      composeCoverageEligibilityResponseBenefitComponent(t, "ItemsComponent", "benefit", element.getBenefit().get(i), i);
    }
    if (element.hasAuthorizationRequiredElement()) {
      composeBoolean(t, "ItemsComponent", "authorizationRequired", element.getAuthorizationRequiredElement(), -1);
    }
    for (int i = 0; i < element.getAuthorizationSupporting().size(); i++) {
      composeCodeableConcept(t, "ItemsComponent", "authorizationSupporting", element.getAuthorizationSupporting().get(i), i);
    }
    if (element.hasAuthorizationUrlElement()) {
      composeUri(t, "ItemsComponent", "authorizationUrl", element.getAuthorizationUrlElement(), -1);
    }
  }

  protected void composeCoverageEligibilityResponseBenefitComponent(Complex parent, String parentType, String name, CoverageEligibilityResponse.BenefitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "benefit", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "BenefitComponent", "type", element.getType(), -1);
    }
    if (element.hasAllowed()) {
      composeType(t, "BenefitComponent", "allowed", element.getAllowed(), -1);
    }
    if (element.hasUsed()) {
      composeType(t, "BenefitComponent", "used", element.getUsed(), -1);
    }
  }

  protected void composeCoverageEligibilityResponseErrorsComponent(Complex parent, String parentType, String name, CoverageEligibilityResponse.ErrorsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "error", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "ErrorsComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeDetectedIssue(Complex parent, String parentType, String name, DetectedIssue element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DetectedIssue", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DetectedIssue", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DetectedIssue", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "DetectedIssue", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "DetectedIssue", "code", element.getCode(), -1);
    }
    if (element.hasSeverityElement()) {
      composeEnum(t, "DetectedIssue", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "DetectedIssue", "subject", element.getSubject(), -1);
    }
    if (element.hasIdentified()) {
      composeType(t, "DetectedIssue", "identified", element.getIdentified(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getImplicated().size(); i++) {
      composeReference(t, "DetectedIssue", "implicated", element.getImplicated().get(i), i);
    }
    for (int i = 0; i < element.getEvidence().size(); i++) {
      composeDetectedIssueEvidenceComponent(t, "DetectedIssue", "evidence", element.getEvidence().get(i), i);
    }
    if (element.hasDetailElement()) {
      composeString(t, "DetectedIssue", "detail", element.getDetailElement(), -1);
    }
    if (element.hasReferenceElement()) {
      composeUri(t, "DetectedIssue", "reference", element.getReferenceElement(), -1);
    }
    for (int i = 0; i < element.getMitigation().size(); i++) {
      composeDetectedIssueMitigationComponent(t, "DetectedIssue", "mitigation", element.getMitigation().get(i), i);
    }
  }

  protected void composeDetectedIssueEvidenceComponent(Complex parent, String parentType, String name, DetectedIssue.DetectedIssueEvidenceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "evidence", name, element, index);
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "DetectedIssueEvidenceComponent", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeReference(t, "DetectedIssueEvidenceComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeDetectedIssueMitigationComponent(Complex parent, String parentType, String name, DetectedIssue.DetectedIssueMitigationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "mitigation", name, element, index);
    if (element.hasAction()) {
      composeCodeableConcept(t, "DetectedIssueMitigationComponent", "action", element.getAction(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "DetectedIssueMitigationComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "DetectedIssueMitigationComponent", "author", element.getAuthor(), -1);
    }
  }

  protected void composeDevice(Complex parent, String parentType, String name, Device element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Device", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Device", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasDisplayNameElement()) {
      composeString(t, "Device", "displayName", element.getDisplayNameElement(), -1);
    }
    if (element.hasDefinition()) {
      composeCodeableReference(t, "Device", "definition", element.getDefinition(), -1);
    }
    for (int i = 0; i < element.getUdiCarrier().size(); i++) {
      composeDeviceUdiCarrierComponent(t, "Device", "udiCarrier", element.getUdiCarrier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Device", "status", element.getStatusElement(), -1);
    }
    if (element.hasAvailabilityStatus()) {
      composeCodeableConcept(t, "Device", "availabilityStatus", element.getAvailabilityStatus(), -1);
    }
    if (element.hasBiologicalSourceEvent()) {
      composeIdentifier(t, "Device", "biologicalSourceEvent", element.getBiologicalSourceEvent(), -1);
    }
    if (element.hasManufacturerElement()) {
      composeString(t, "Device", "manufacturer", element.getManufacturerElement(), -1);
    }
    if (element.hasManufactureDateElement()) {
      composeDateTime(t, "Device", "manufactureDate", element.getManufactureDateElement(), -1);
    }
    if (element.hasExpirationDateElement()) {
      composeDateTime(t, "Device", "expirationDate", element.getExpirationDateElement(), -1);
    }
    if (element.hasLotNumberElement()) {
      composeString(t, "Device", "lotNumber", element.getLotNumberElement(), -1);
    }
    if (element.hasSerialNumberElement()) {
      composeString(t, "Device", "serialNumber", element.getSerialNumberElement(), -1);
    }
    for (int i = 0; i < element.getDeviceName().size(); i++) {
      composeDeviceDeviceNameComponent(t, "Device", "deviceName", element.getDeviceName().get(i), i);
    }
    if (element.hasModelNumberElement()) {
      composeString(t, "Device", "modelNumber", element.getModelNumberElement(), -1);
    }
    if (element.hasPartNumberElement()) {
      composeString(t, "Device", "partNumber", element.getPartNumberElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Device", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Device", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getVersion().size(); i++) {
      composeDeviceVersionComponent(t, "Device", "version", element.getVersion().get(i), i);
    }
    for (int i = 0; i < element.getSpecialization().size(); i++) {
      composeDeviceSpecializationComponent(t, "Device", "specialization", element.getSpecialization().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeDevicePropertyComponent(t, "Device", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getOperation().size(); i++) {
      composeDeviceOperationComponent(t, "Device", "operation", element.getOperation().get(i), i);
    }
    for (int i = 0; i < element.getAssociation().size(); i++) {
      composeDeviceAssociationComponent(t, "Device", "association", element.getAssociation().get(i), i);
    }
    if (element.hasOwner()) {
      composeReference(t, "Device", "owner", element.getOwner(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactPoint(t, "Device", "contact", element.getContact().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "Device", "location", element.getLocation(), -1);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "Device", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "Device", "endpoint", element.getEndpoint().get(i), i);
    }
    for (int i = 0; i < element.getGateway().size(); i++) {
      composeCodeableReference(t, "Device", "gateway", element.getGateway().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Device", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getSafety().size(); i++) {
      composeCodeableConcept(t, "Device", "safety", element.getSafety().get(i), i);
    }
    if (element.hasParent()) {
      composeReference(t, "Device", "parent", element.getParent(), -1);
    }
  }

  protected void composeDeviceUdiCarrierComponent(Complex parent, String parentType, String name, Device.DeviceUdiCarrierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "udiCarrier", name, element, index);
    if (element.hasDeviceIdentifierElement()) {
      composeString(t, "DeviceUdiCarrierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
    }
    if (element.hasIssuerElement()) {
      composeUri(t, "DeviceUdiCarrierComponent", "issuer", element.getIssuerElement(), -1);
    }
    if (element.hasJurisdictionElement()) {
      composeUri(t, "DeviceUdiCarrierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
    }
    if (element.hasCarrierAIDCElement()) {
      composeBase64Binary(t, "DeviceUdiCarrierComponent", "carrierAIDC", element.getCarrierAIDCElement(), -1);
    }
    if (element.hasCarrierHRFElement()) {
      composeString(t, "DeviceUdiCarrierComponent", "carrierHRF", element.getCarrierHRFElement(), -1);
    }
    if (element.hasEntryTypeElement()) {
      composeEnum(t, "DeviceUdiCarrierComponent", "entryType", element.getEntryTypeElement(), -1);
    }
  }

  protected void composeDeviceDeviceNameComponent(Complex parent, String parentType, String name, Device.DeviceDeviceNameComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "deviceName", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "DeviceDeviceNameComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "DeviceDeviceNameComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composeDeviceVersionComponent(Complex parent, String parentType, String name, Device.DeviceVersionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "version", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceVersionComponent", "type", element.getType(), -1);
    }
    if (element.hasComponent()) {
      composeIdentifier(t, "DeviceVersionComponent", "component", element.getComponent(), -1);
    }
    if (element.hasInstallDateElement()) {
      composeDateTime(t, "DeviceVersionComponent", "installDate", element.getInstallDateElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "DeviceVersionComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeDeviceSpecializationComponent(Complex parent, String parentType, String name, Device.DeviceSpecializationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "specialization", name, element, index);
    if (element.hasSystemType()) {
      composeCodeableConcept(t, "DeviceSpecializationComponent", "systemType", element.getSystemType(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "DeviceSpecializationComponent", "version", element.getVersionElement(), -1);
    }
    if (element.hasCategory()) {
      composeCoding(t, "DeviceSpecializationComponent", "category", element.getCategory(), -1);
    }
  }

  protected void composeDevicePropertyComponent(Complex parent, String parentType, String name, Device.DevicePropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DevicePropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "DevicePropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeDeviceOperationComponent(Complex parent, String parentType, String name, Device.DeviceOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasStatus()) {
      composeCodeableConcept(t, "DeviceOperationComponent", "status", element.getStatus(), -1);
    }
    for (int i = 0; i < element.getStatusReason().size(); i++) {
      composeCodeableConcept(t, "DeviceOperationComponent", "statusReason", element.getStatusReason().get(i), i);
    }
    for (int i = 0; i < element.getOperator().size(); i++) {
      composeReference(t, "DeviceOperationComponent", "operator", element.getOperator().get(i), i);
    }
    if (element.hasMode()) {
      composeCodeableConcept(t, "DeviceOperationComponent", "mode", element.getMode(), -1);
    }
    if (element.hasCycle()) {
      composeCount(t, "DeviceOperationComponent", "cycle", element.getCycle(), -1);
    }
    if (element.hasDuration()) {
      composeDuration(t, "DeviceOperationComponent", "duration", element.getDuration(), -1);
    }
  }

  protected void composeDeviceAssociationComponent(Complex parent, String parentType, String name, Device.DeviceAssociationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "association", name, element, index);
    if (element.hasStatus()) {
      composeCodeableConcept(t, "DeviceAssociationComponent", "status", element.getStatus(), -1);
    }
    for (int i = 0; i < element.getStatusReason().size(); i++) {
      composeCodeableConcept(t, "DeviceAssociationComponent", "statusReason", element.getStatusReason().get(i), i);
    }
    if (element.hasHumanSubject()) {
      composeReference(t, "DeviceAssociationComponent", "humanSubject", element.getHumanSubject(), -1);
    }
    if (element.hasBodyStructure()) {
      composeCodeableReference(t, "DeviceAssociationComponent", "bodyStructure", element.getBodyStructure(), -1);
    }
  }

  protected void composeDeviceDefinition(Complex parent, String parentType, String name, DeviceDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceDefinition", name, element, index);
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "DeviceDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getUdiDeviceIdentifier().size(); i++) {
      composeDeviceDefinitionUdiDeviceIdentifierComponent(t, "DeviceDefinition", "udiDeviceIdentifier", element.getUdiDeviceIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getRegulatoryIdentifier().size(); i++) {
      composeDeviceDefinitionRegulatoryIdentifierComponent(t, "DeviceDefinition", "regulatoryIdentifier", element.getRegulatoryIdentifier().get(i), i);
    }
    if (element.hasPartNumberElement()) {
      composeString(t, "DeviceDefinition", "partNumber", element.getPartNumberElement(), -1);
    }
    if (element.hasManufacturer()) {
      composeReference(t, "DeviceDefinition", "manufacturer", element.getManufacturer(), -1);
    }
    for (int i = 0; i < element.getDeviceName().size(); i++) {
      composeDeviceDefinitionDeviceNameComponent(t, "DeviceDefinition", "deviceName", element.getDeviceName().get(i), i);
    }
    if (element.hasModelNumberElement()) {
      composeString(t, "DeviceDefinition", "modelNumber", element.getModelNumberElement(), -1);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeDeviceDefinitionClassificationComponent(t, "DeviceDefinition", "classification", element.getClassification().get(i), i);
    }
    for (int i = 0; i < element.getSpecialization().size(); i++) {
      composeRelatedArtifact(t, "DeviceDefinition", "specialization", element.getSpecialization().get(i), i);
    }
    for (int i = 0; i < element.getHasPart().size(); i++) {
      composeDeviceDefinitionHasPartComponent(t, "DeviceDefinition", "hasPart", element.getHasPart().get(i), i);
    }
    for (int i = 0; i < element.getPackaging().size(); i++) {
      composeDeviceDefinitionPackagingComponent(t, "DeviceDefinition", "packaging", element.getPackaging().get(i), i);
    }
    for (int i = 0; i < element.getVersion().size(); i++) {
      composeDeviceDefinitionVersionComponent(t, "DeviceDefinition", "version", element.getVersion().get(i), i);
    }
    for (int i = 0; i < element.getSafety().size(); i++) {
      composeCodeableConcept(t, "DeviceDefinition", "safety", element.getSafety().get(i), i);
    }
    for (int i = 0; i < element.getShelfLifeStorage().size(); i++) {
      composeProductShelfLife(t, "DeviceDefinition", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
    }
    for (int i = 0; i < element.getLanguageCode().size(); i++) {
      composeCodeableConcept(t, "DeviceDefinition", "languageCode", element.getLanguageCode().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeDeviceDefinitionPropertyComponent(t, "DeviceDefinition", "property", element.getProperty().get(i), i);
    }
    if (element.hasOwner()) {
      composeReference(t, "DeviceDefinition", "owner", element.getOwner(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactPoint(t, "DeviceDefinition", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composeDeviceDefinitionLinkComponent(t, "DeviceDefinition", "link", element.getLink().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "DeviceDefinition", "note", element.getNote().get(i), i);
    }
    if (element.hasParentDevice()) {
      composeReference(t, "DeviceDefinition", "parentDevice", element.getParentDevice(), -1);
    }
    for (int i = 0; i < element.getMaterial().size(); i++) {
      composeDeviceDefinitionMaterialComponent(t, "DeviceDefinition", "material", element.getMaterial().get(i), i);
    }
    for (int i = 0; i < element.getProductionIdentifierInUDI().size(); i++) {
      composeEnum(t, "DeviceDefinition", "productionIdentifierInUDI", element.getProductionIdentifierInUDI().get(i), i);
    }
    if (element.hasGuideline()) {
      composeDeviceDefinitionGuidelineComponent(t, "DeviceDefinition", "guideline", element.getGuideline(), -1);
    }
    if (element.hasCorrectiveAction()) {
      composeDeviceDefinitionCorrectiveActionComponent(t, "DeviceDefinition", "correctiveAction", element.getCorrectiveAction(), -1);
    }
    for (int i = 0; i < element.getChargeItem().size(); i++) {
      composeDeviceDefinitionChargeItemComponent(t, "DeviceDefinition", "chargeItem", element.getChargeItem().get(i), i);
    }
  }

  protected void composeDeviceDefinitionUdiDeviceIdentifierComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "udiDeviceIdentifier", name, element, index);
    if (element.hasDeviceIdentifierElement()) {
      composeString(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
    }
    if (element.hasIssuerElement()) {
      composeUri(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "issuer", element.getIssuerElement(), -1);
    }
    if (element.hasJurisdictionElement()) {
      composeUri(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
    }
    for (int i = 0; i < element.getMarketDistribution().size(); i++) {
      composeDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "marketDistribution", element.getMarketDistribution().get(i), i);
    }
  }

  protected void composeDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(Complex parent, String parentType, String name, DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "marketDistribution", name, element, index);
    if (element.hasMarketPeriod()) {
      composePeriod(t, "UdiDeviceIdentifierMarketDistributionComponent", "marketPeriod", element.getMarketPeriod(), -1);
    }
    if (element.hasSubJurisdictionElement()) {
      composeUri(t, "UdiDeviceIdentifierMarketDistributionComponent", "subJurisdiction", element.getSubJurisdictionElement(), -1);
    }
  }

  protected void composeDeviceDefinitionRegulatoryIdentifierComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "regulatoryIdentifier", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "DeviceDefinitionRegulatoryIdentifierComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasDeviceIdentifierElement()) {
      composeString(t, "DeviceDefinitionRegulatoryIdentifierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
    }
    if (element.hasIssuerElement()) {
      composeUri(t, "DeviceDefinitionRegulatoryIdentifierComponent", "issuer", element.getIssuerElement(), -1);
    }
    if (element.hasJurisdictionElement()) {
      composeUri(t, "DeviceDefinitionRegulatoryIdentifierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
    }
  }

  protected void composeDeviceDefinitionDeviceNameComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionDeviceNameComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "deviceName", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "DeviceDefinitionDeviceNameComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "DeviceDefinitionDeviceNameComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composeDeviceDefinitionClassificationComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionClassificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "classification", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceDefinitionClassificationComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getJustification().size(); i++) {
      composeRelatedArtifact(t, "DeviceDefinitionClassificationComponent", "justification", element.getJustification().get(i), i);
    }
  }

  protected void composeDeviceDefinitionHasPartComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionHasPartComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "hasPart", name, element, index);
    if (element.hasReference()) {
      composeReference(t, "DeviceDefinitionHasPartComponent", "reference", element.getReference(), -1);
    }
    if (element.hasCountElement()) {
      composeInteger(t, "DeviceDefinitionHasPartComponent", "count", element.getCountElement(), -1);
    }
  }

  protected void composeDeviceDefinitionPackagingComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionPackagingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "packaging", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "DeviceDefinitionPackagingComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceDefinitionPackagingComponent", "type", element.getType(), -1);
    }
    if (element.hasCountElement()) {
      composeInteger(t, "DeviceDefinitionPackagingComponent", "count", element.getCountElement(), -1);
    }
    for (int i = 0; i < element.getDistributor().size(); i++) {
      composeDeviceDefinitionPackagingDistributorComponent(t, "DeviceDefinitionPackagingComponent", "distributor", element.getDistributor().get(i), i);
    }
    for (int i = 0; i < element.getUdiDeviceIdentifier().size(); i++) {
      composeDeviceDefinitionUdiDeviceIdentifierComponent(t, "DeviceDefinitionPackagingComponent", "udiDeviceIdentifier", element.getUdiDeviceIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getPackaging().size(); i++) {
      composeDeviceDefinitionPackagingComponent(t, "DeviceDefinitionPackagingComponent", "packaging", element.getPackaging().get(i), i);
    }
  }

  protected void composeDeviceDefinitionPackagingDistributorComponent(Complex parent, String parentType, String name, DeviceDefinition.PackagingDistributorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "distributor", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "PackagingDistributorComponent", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getOrganizationReference().size(); i++) {
      composeReference(t, "PackagingDistributorComponent", "organizationReference", element.getOrganizationReference().get(i), i);
    }
  }

  protected void composeDeviceDefinitionVersionComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionVersionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "version", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceDefinitionVersionComponent", "type", element.getType(), -1);
    }
    if (element.hasComponent()) {
      composeIdentifier(t, "DeviceDefinitionVersionComponent", "component", element.getComponent(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "DeviceDefinitionVersionComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeDeviceDefinitionPropertyComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceDefinitionPropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "DeviceDefinitionPropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeDeviceDefinitionLinkComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasRelation()) {
      composeCoding(t, "DeviceDefinitionLinkComponent", "relation", element.getRelation(), -1);
    }
    if (element.hasRelatedDevice()) {
      composeCodeableReference(t, "DeviceDefinitionLinkComponent", "relatedDevice", element.getRelatedDevice(), -1);
    }
  }

  protected void composeDeviceDefinitionMaterialComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionMaterialComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "material", name, element, index);
    if (element.hasSubstance()) {
      composeCodeableConcept(t, "DeviceDefinitionMaterialComponent", "substance", element.getSubstance(), -1);
    }
    if (element.hasAlternateElement()) {
      composeBoolean(t, "DeviceDefinitionMaterialComponent", "alternate", element.getAlternateElement(), -1);
    }
    if (element.hasAllergenicIndicatorElement()) {
      composeBoolean(t, "DeviceDefinitionMaterialComponent", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
    }
  }

  protected void composeDeviceDefinitionGuidelineComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionGuidelineComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "guideline", name, element, index);
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "DeviceDefinitionGuidelineComponent", "useContext", element.getUseContext().get(i), i);
    }
    if (element.hasUsageInstructionElement()) {
      composeMarkdown(t, "DeviceDefinitionGuidelineComponent", "usageInstruction", element.getUsageInstructionElement(), -1);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "DeviceDefinitionGuidelineComponent", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getIndication().size(); i++) {
      composeCodeableReference(t, "DeviceDefinitionGuidelineComponent", "indication", element.getIndication().get(i), i);
    }
    for (int i = 0; i < element.getContraindication().size(); i++) {
      composeCodeableReference(t, "DeviceDefinitionGuidelineComponent", "contraindication", element.getContraindication().get(i), i);
    }
    for (int i = 0; i < element.getWarning().size(); i++) {
      composeCodeableReference(t, "DeviceDefinitionGuidelineComponent", "warning", element.getWarning().get(i), i);
    }
    if (element.hasIntendedUseElement()) {
      composeString(t, "DeviceDefinitionGuidelineComponent", "intendedUse", element.getIntendedUseElement(), -1);
    }
  }

  protected void composeDeviceDefinitionCorrectiveActionComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionCorrectiveActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "correctiveAction", name, element, index);
    if (element.hasRecallElement()) {
      composeBoolean(t, "DeviceDefinitionCorrectiveActionComponent", "recall", element.getRecallElement(), -1);
    }
    if (element.hasScopeElement()) {
      composeEnum(t, "DeviceDefinitionCorrectiveActionComponent", "scope", element.getScopeElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "DeviceDefinitionCorrectiveActionComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeDeviceDefinitionChargeItemComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionChargeItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "chargeItem", name, element, index);
    if (element.hasChargeItemCode()) {
      composeCodeableReference(t, "DeviceDefinitionChargeItemComponent", "chargeItemCode", element.getChargeItemCode(), -1);
    }
    if (element.hasCount()) {
      composeQuantity(t, "DeviceDefinitionChargeItemComponent", "count", element.getCount(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "DeviceDefinitionChargeItemComponent", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "DeviceDefinitionChargeItemComponent", "useContext", element.getUseContext().get(i), i);
    }
  }

  protected void composeDeviceDispense(Complex parent, String parentType, String name, DeviceDispense element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceDispense", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceDispense", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "DeviceDispense", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "DeviceDispense", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DeviceDispense", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableReference(t, "DeviceDispense", "statusReason", element.getStatusReason(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "DeviceDispense", "category", element.getCategory().get(i), i);
    }
    if (element.hasDevice()) {
      composeCodeableReference(t, "DeviceDispense", "device", element.getDevice(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "DeviceDispense", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "DeviceDispense", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "DeviceDispense", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeDeviceDispensePerformerComponent(t, "DeviceDispense", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "DeviceDispense", "location", element.getLocation(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceDispense", "type", element.getType(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "DeviceDispense", "quantity", element.getQuantity(), -1);
    }
    if (element.hasPreparedDateElement()) {
      composeDateTime(t, "DeviceDispense", "preparedDate", element.getPreparedDateElement(), -1);
    }
    if (element.hasWhenHandedOverElement()) {
      composeDateTime(t, "DeviceDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
    }
    if (element.hasDestination()) {
      composeReference(t, "DeviceDispense", "destination", element.getDestination(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "DeviceDispense", "note", element.getNote().get(i), i);
    }
    if (element.hasUsageInstructionElement()) {
      composeString(t, "DeviceDispense", "usageInstruction", element.getUsageInstructionElement(), -1);
    }
    for (int i = 0; i < element.getEventHistory().size(); i++) {
      composeReference(t, "DeviceDispense", "eventHistory", element.getEventHistory().get(i), i);
    }
  }

  protected void composeDeviceDispensePerformerComponent(Complex parent, String parentType, String name, DeviceDispense.DeviceDispensePerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "DeviceDispensePerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "DeviceDispensePerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeDeviceMetric(Complex parent, String parentType, String name, DeviceMetric element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceMetric", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceMetric", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceMetric", "type", element.getType(), -1);
    }
    if (element.hasUnit()) {
      composeCodeableConcept(t, "DeviceMetric", "unit", element.getUnit(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "DeviceMetric", "source", element.getSource(), -1);
    }
    if (element.hasParent()) {
      composeReference(t, "DeviceMetric", "parent", element.getParent(), -1);
    }
    if (element.hasOperationalStatusElement()) {
      composeEnum(t, "DeviceMetric", "operationalStatus", element.getOperationalStatusElement(), -1);
    }
    if (element.hasColorElement()) {
      composeEnum(t, "DeviceMetric", "color", element.getColorElement(), -1);
    }
    if (element.hasCategoryElement()) {
      composeEnum(t, "DeviceMetric", "category", element.getCategoryElement(), -1);
    }
    if (element.hasMeasurementPeriod()) {
      composeTiming(t, "DeviceMetric", "measurementPeriod", element.getMeasurementPeriod(), -1);
    }
    for (int i = 0; i < element.getCalibration().size(); i++) {
      composeDeviceMetricCalibrationComponent(t, "DeviceMetric", "calibration", element.getCalibration().get(i), i);
    }
  }

  protected void composeDeviceMetricCalibrationComponent(Complex parent, String parentType, String name, DeviceMetric.DeviceMetricCalibrationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "calibration", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "DeviceMetricCalibrationComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasStateElement()) {
      composeEnum(t, "DeviceMetricCalibrationComponent", "state", element.getStateElement(), -1);
    }
    if (element.hasTimeElement()) {
      composeInstant(t, "DeviceMetricCalibrationComponent", "time", element.getTimeElement(), -1);
    }
  }

  protected void composeDeviceRequest(Complex parent, String parentType, String name, DeviceRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceRequest", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "DeviceRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "DeviceRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "DeviceRequest", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "DeviceRequest", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "DeviceRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DeviceRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "DeviceRequest", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "DeviceRequest", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "DeviceRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableReference(t, "DeviceRequest", "code", element.getCode(), -1);
    }
    if (element.hasQuantityElement()) {
      composeInteger(t, "DeviceRequest", "quantity", element.getQuantityElement(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeDeviceRequestParameterComponent(t, "DeviceRequest", "parameter", element.getParameter().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "DeviceRequest", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "DeviceRequest", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "DeviceRequest", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "DeviceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "DeviceRequest", "requester", element.getRequester(), -1);
    }
    if (element.hasPerformerType()) {
      composeCodeableConcept(t, "DeviceRequest", "performerType", element.getPerformerType(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "DeviceRequest", "performer", element.getPerformer(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "DeviceRequest", "reason", element.getReason().get(i), i);
    }
    if (element.hasAsNeededElement()) {
      composeBoolean(t, "DeviceRequest", "asNeeded", element.getAsNeededElement(), -1);
    }
    if (element.hasAsNeededFor()) {
      composeCodeableConcept(t, "DeviceRequest", "asNeededFor", element.getAsNeededFor(), -1);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeReference(t, "DeviceRequest", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "DeviceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "DeviceRequest", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getRelevantHistory().size(); i++) {
      composeReference(t, "DeviceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
    }
  }

  protected void composeDeviceRequestParameterComponent(Complex parent, String parentType, String name, DeviceRequest.DeviceRequestParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "DeviceRequestParameterComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "DeviceRequestParameterComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeDeviceUsage(Complex parent, String parentType, String name, DeviceUsage element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceUsage", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceUsage", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "DeviceUsage", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DeviceUsage", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "DeviceUsage", "category", element.getCategory().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "DeviceUsage", "patient", element.getPatient(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeReference(t, "DeviceUsage", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    if (element.hasContext()) {
      composeReference(t, "DeviceUsage", "context", element.getContext(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "DeviceUsage", "timing", element.getTiming(), -1);
    }
    if (element.hasDateAssertedElement()) {
      composeDateTime(t, "DeviceUsage", "dateAsserted", element.getDateAssertedElement(), -1);
    }
    if (element.hasUsageStatus()) {
      composeCodeableConcept(t, "DeviceUsage", "usageStatus", element.getUsageStatus(), -1);
    }
    for (int i = 0; i < element.getUsageReason().size(); i++) {
      composeCodeableConcept(t, "DeviceUsage", "usageReason", element.getUsageReason().get(i), i);
    }
    if (element.hasAdherence()) {
      composeDeviceUsageAdherenceComponent(t, "DeviceUsage", "adherence", element.getAdherence(), -1);
    }
    if (element.hasInformationSource()) {
      composeReference(t, "DeviceUsage", "informationSource", element.getInformationSource(), -1);
    }
    if (element.hasDevice()) {
      composeCodeableReference(t, "DeviceUsage", "device", element.getDevice(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "DeviceUsage", "reason", element.getReason().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCodeableReference(t, "DeviceUsage", "bodySite", element.getBodySite(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "DeviceUsage", "note", element.getNote().get(i), i);
    }
  }

  protected void composeDeviceUsageAdherenceComponent(Complex parent, String parentType, String name, DeviceUsage.DeviceUsageAdherenceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "adherence", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "DeviceUsageAdherenceComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableConcept(t, "DeviceUsageAdherenceComponent", "reason", element.getReason().get(i), i);
    }
  }

  protected void composeDiagnosticReport(Complex parent, String parentType, String name, DiagnosticReport element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DiagnosticReport", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DiagnosticReport", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "DiagnosticReport", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DiagnosticReport", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "DiagnosticReport", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "DiagnosticReport", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "DiagnosticReport", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "DiagnosticReport", "encounter", element.getEncounter(), -1);
    }
    if (element.hasEffective()) {
      composeType(t, "DiagnosticReport", "effective", element.getEffective(), -1);
    }
    if (element.hasIssuedElement()) {
      composeInstant(t, "DiagnosticReport", "issued", element.getIssuedElement(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "DiagnosticReport", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getResultsInterpreter().size(); i++) {
      composeReference(t, "DiagnosticReport", "resultsInterpreter", element.getResultsInterpreter().get(i), i);
    }
    for (int i = 0; i < element.getSpecimen().size(); i++) {
      composeReference(t, "DiagnosticReport", "specimen", element.getSpecimen().get(i), i);
    }
    for (int i = 0; i < element.getResult().size(); i++) {
      composeReference(t, "DiagnosticReport", "result", element.getResult().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "DiagnosticReport", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getStudy().size(); i++) {
      composeReference(t, "DiagnosticReport", "study", element.getStudy().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeDiagnosticReportSupportingInfoComponent(t, "DiagnosticReport", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getMedia().size(); i++) {
      composeDiagnosticReportMediaComponent(t, "DiagnosticReport", "media", element.getMedia().get(i), i);
    }
    if (element.hasComposition()) {
      composeReference(t, "DiagnosticReport", "composition", element.getComposition(), -1);
    }
    if (element.hasConclusionElement()) {
      composeString(t, "DiagnosticReport", "conclusion", element.getConclusionElement(), -1);
    }
    for (int i = 0; i < element.getConclusionCode().size(); i++) {
      composeCodeableConcept(t, "DiagnosticReport", "conclusionCode", element.getConclusionCode().get(i), i);
    }
    for (int i = 0; i < element.getPresentedForm().size(); i++) {
      composeAttachment(t, "DiagnosticReport", "presentedForm", element.getPresentedForm().get(i), i);
    }
  }

  protected void composeDiagnosticReportSupportingInfoComponent(Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportSupportingInfoComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportingInfo", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DiagnosticReportSupportingInfoComponent", "type", element.getType(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "DiagnosticReportSupportingInfoComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeDiagnosticReportMediaComponent(Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportMediaComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "media", name, element, index);
    if (element.hasCommentElement()) {
      composeString(t, "DiagnosticReportMediaComponent", "comment", element.getCommentElement(), -1);
    }
    if (element.hasLink()) {
      composeReference(t, "DiagnosticReportMediaComponent", "link", element.getLink(), -1);
    }
  }

  protected void composeDocumentManifest(Complex parent, String parentType, String name, DocumentManifest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DocumentManifest", name, element, index);
    if (element.hasMasterIdentifier()) {
      composeIdentifier(t, "DocumentManifest", "masterIdentifier", element.getMasterIdentifier(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DocumentManifest", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DocumentManifest", "type", element.getType(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "DocumentManifest", "subject", element.getSubject(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "DocumentManifest", "created", element.getCreatedElement(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "DocumentManifest", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getRecipient().size(); i++) {
      composeReference(t, "DocumentManifest", "recipient", element.getRecipient().get(i), i);
    }
    if (element.hasSourceElement()) {
      composeUri(t, "DocumentManifest", "source", element.getSourceElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "DocumentManifest", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getContent().size(); i++) {
      composeReference(t, "DocumentManifest", "content", element.getContent().get(i), i);
    }
    for (int i = 0; i < element.getRelated().size(); i++) {
      composeDocumentManifestRelatedComponent(t, "DocumentManifest", "related", element.getRelated().get(i), i);
    }
  }

  protected void composeDocumentManifestRelatedComponent(Complex parent, String parentType, String name, DocumentManifest.DocumentManifestRelatedComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "related", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "DocumentManifestRelatedComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasRef()) {
      composeReference(t, "DocumentManifestRelatedComponent", "ref", element.getRef(), -1);
    }
  }

  protected void composeDocumentReference(Complex parent, String parentType, String name, DocumentReference element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DocumentReference", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "DocumentReference", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DocumentReference", "status", element.getStatusElement(), -1);
    }
    if (element.hasDocStatusElement()) {
      composeEnum(t, "DocumentReference", "docStatus", element.getDocStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DocumentReference", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "DocumentReference", "category", element.getCategory().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "DocumentReference", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getContext().size(); i++) {
      composeReference(t, "DocumentReference", "context", element.getContext().get(i), i);
    }
    for (int i = 0; i < element.getEvent().size(); i++) {
      composeCodeableReference(t, "DocumentReference", "event", element.getEvent().get(i), i);
    }
    if (element.hasFacilityType()) {
      composeCodeableConcept(t, "DocumentReference", "facilityType", element.getFacilityType(), -1);
    }
    if (element.hasPracticeSetting()) {
      composeCodeableConcept(t, "DocumentReference", "practiceSetting", element.getPracticeSetting(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "DocumentReference", "period", element.getPeriod(), -1);
    }
    if (element.hasDateElement()) {
      composeInstant(t, "DocumentReference", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "DocumentReference", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getAttester().size(); i++) {
      composeDocumentReferenceAttesterComponent(t, "DocumentReference", "attester", element.getAttester().get(i), i);
    }
    if (element.hasCustodian()) {
      composeReference(t, "DocumentReference", "custodian", element.getCustodian(), -1);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeDocumentReferenceRelatesToComponent(t, "DocumentReference", "relatesTo", element.getRelatesTo().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "DocumentReference", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getSecurityLabel().size(); i++) {
      composeCodeableConcept(t, "DocumentReference", "securityLabel", element.getSecurityLabel().get(i), i);
    }
    for (int i = 0; i < element.getContent().size(); i++) {
      composeDocumentReferenceContentComponent(t, "DocumentReference", "content", element.getContent().get(i), i);
    }
  }

  protected void composeDocumentReferenceAttesterComponent(Complex parent, String parentType, String name, DocumentReference.DocumentReferenceAttesterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "attester", name, element, index);
    if (element.hasMode()) {
      composeCodeableConcept(t, "DocumentReferenceAttesterComponent", "mode", element.getMode(), -1);
    }
    if (element.hasTimeElement()) {
      composeDateTime(t, "DocumentReferenceAttesterComponent", "time", element.getTimeElement(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "DocumentReferenceAttesterComponent", "party", element.getParty(), -1);
    }
  }

  protected void composeDocumentReferenceRelatesToComponent(Complex parent, String parentType, String name, DocumentReference.DocumentReferenceRelatesToComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatesTo", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "DocumentReferenceRelatesToComponent", "code", element.getCode(), -1);
    }
    if (element.hasTarget()) {
      composeReference(t, "DocumentReferenceRelatesToComponent", "target", element.getTarget(), -1);
    }
  }

  protected void composeDocumentReferenceContentComponent(Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "content", name, element, index);
    if (element.hasAttachment()) {
      composeAttachment(t, "DocumentReferenceContentComponent", "attachment", element.getAttachment(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeDocumentReferenceContentProfileComponent(t, "DocumentReferenceContentComponent", "profile", element.getProfile().get(i), i);
    }
  }

  protected void composeDocumentReferenceContentProfileComponent(Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentProfileComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "profile", name, element, index);
    if (element.hasValue()) {
      composeType(t, "DocumentReferenceContentProfileComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeEncounter(Complex parent, String parentType, String name, Encounter element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Encounter", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Encounter", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusHistory().size(); i++) {
      composeEncounterStatusHistoryComponent(t, "Encounter", "statusHistory", element.getStatusHistory().get(i), i);
    }
    for (int i = 0; i < element.getClass_().size(); i++) {
      composeCodeableConcept(t, "Encounter", "class", element.getClass_().get(i), i);
    }
    for (int i = 0; i < element.getClassHistory().size(); i++) {
      composeEncounterClassHistoryComponent(t, "Encounter", "classHistory", element.getClassHistory().get(i), i);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "Encounter", "priority", element.getPriority(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getServiceType().size(); i++) {
      composeCodeableReference(t, "Encounter", "serviceType", element.getServiceType().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "Encounter", "subject", element.getSubject(), -1);
    }
    if (element.hasSubjectStatus()) {
      composeCodeableConcept(t, "Encounter", "subjectStatus", element.getSubjectStatus(), -1);
    }
    for (int i = 0; i < element.getEpisodeOfCare().size(); i++) {
      composeReference(t, "Encounter", "episodeOfCare", element.getEpisodeOfCare().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Encounter", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getCareTeam().size(); i++) {
      composeReference(t, "Encounter", "careTeam", element.getCareTeam().get(i), i);
    }
    if (element.hasPartOf()) {
      composeReference(t, "Encounter", "partOf", element.getPartOf(), -1);
    }
    if (element.hasServiceProvider()) {
      composeReference(t, "Encounter", "serviceProvider", element.getServiceProvider(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeEncounterParticipantComponent(t, "Encounter", "participant", element.getParticipant().get(i), i);
    }
    for (int i = 0; i < element.getAppointment().size(); i++) {
      composeReference(t, "Encounter", "appointment", element.getAppointment().get(i), i);
    }
    for (int i = 0; i < element.getVirtualService().size(); i++) {
      composeVirtualServiceDetail(t, "Encounter", "virtualService", element.getVirtualService().get(i), i);
    }
    if (element.hasActualPeriod()) {
      composePeriod(t, "Encounter", "actualPeriod", element.getActualPeriod(), -1);
    }
    if (element.hasPlannedStartDateElement()) {
      composeDateTime(t, "Encounter", "plannedStartDate", element.getPlannedStartDateElement(), -1);
    }
    if (element.hasPlannedEndDateElement()) {
      composeDateTime(t, "Encounter", "plannedEndDate", element.getPlannedEndDateElement(), -1);
    }
    if (element.hasLength()) {
      composeDuration(t, "Encounter", "length", element.getLength(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "Encounter", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeEncounterDiagnosisComponent(t, "Encounter", "diagnosis", element.getDiagnosis().get(i), i);
    }
    for (int i = 0; i < element.getAccount().size(); i++) {
      composeReference(t, "Encounter", "account", element.getAccount().get(i), i);
    }
    if (element.hasAdmission()) {
      composeEncounterAdmissionComponent(t, "Encounter", "admission", element.getAdmission(), -1);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeEncounterLocationComponent(t, "Encounter", "location", element.getLocation().get(i), i);
    }
  }

  protected void composeEncounterStatusHistoryComponent(Complex parent, String parentType, String name, Encounter.StatusHistoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statusHistory", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "StatusHistoryComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "StatusHistoryComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEncounterClassHistoryComponent(Complex parent, String parentType, String name, Encounter.ClassHistoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "classHistory", name, element, index);
    if (element.hasClass_()) {
      composeCoding(t, "ClassHistoryComponent", "class", element.getClass_(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ClassHistoryComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEncounterParticipantComponent(Complex parent, String parentType, String name, Encounter.EncounterParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "EncounterParticipantComponent", "type", element.getType().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EncounterParticipantComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "EncounterParticipantComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeEncounterDiagnosisComponent(Complex parent, String parentType, String name, Encounter.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasCondition()) {
      composeReference(t, "DiagnosisComponent", "condition", element.getCondition(), -1);
    }
    if (element.hasUse()) {
      composeCodeableConcept(t, "DiagnosisComponent", "use", element.getUse(), -1);
    }
    if (element.hasRankElement()) {
      composePositiveInt(t, "DiagnosisComponent", "rank", element.getRankElement(), -1);
    }
  }

  protected void composeEncounterAdmissionComponent(Complex parent, String parentType, String name, Encounter.EncounterAdmissionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "admission", name, element, index);
    if (element.hasPreAdmissionIdentifier()) {
      composeIdentifier(t, "EncounterAdmissionComponent", "preAdmissionIdentifier", element.getPreAdmissionIdentifier(), -1);
    }
    if (element.hasOrigin()) {
      composeReference(t, "EncounterAdmissionComponent", "origin", element.getOrigin(), -1);
    }
    if (element.hasAdmitSource()) {
      composeCodeableConcept(t, "EncounterAdmissionComponent", "admitSource", element.getAdmitSource(), -1);
    }
    if (element.hasReAdmission()) {
      composeCodeableConcept(t, "EncounterAdmissionComponent", "reAdmission", element.getReAdmission(), -1);
    }
    for (int i = 0; i < element.getDietPreference().size(); i++) {
      composeCodeableConcept(t, "EncounterAdmissionComponent", "dietPreference", element.getDietPreference().get(i), i);
    }
    for (int i = 0; i < element.getSpecialCourtesy().size(); i++) {
      composeCodeableConcept(t, "EncounterAdmissionComponent", "specialCourtesy", element.getSpecialCourtesy().get(i), i);
    }
    for (int i = 0; i < element.getSpecialArrangement().size(); i++) {
      composeCodeableConcept(t, "EncounterAdmissionComponent", "specialArrangement", element.getSpecialArrangement().get(i), i);
    }
    if (element.hasDestination()) {
      composeReference(t, "EncounterAdmissionComponent", "destination", element.getDestination(), -1);
    }
    if (element.hasDischargeDisposition()) {
      composeCodeableConcept(t, "EncounterAdmissionComponent", "dischargeDisposition", element.getDischargeDisposition(), -1);
    }
  }

  protected void composeEncounterLocationComponent(Complex parent, String parentType, String name, Encounter.EncounterLocationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "location", name, element, index);
    if (element.hasLocation()) {
      composeReference(t, "EncounterLocationComponent", "location", element.getLocation(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EncounterLocationComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasForm()) {
      composeCodeableConcept(t, "EncounterLocationComponent", "form", element.getForm(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EncounterLocationComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEndpoint(Complex parent, String parentType, String name, Endpoint element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Endpoint", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Endpoint", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Endpoint", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getConnectionType().size(); i++) {
      composeCodeableConcept(t, "Endpoint", "connectionType", element.getConnectionType().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "Endpoint", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Endpoint", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getEnvironmentType().size(); i++) {
      composeCodeableConcept(t, "Endpoint", "environmentType", element.getEnvironmentType().get(i), i);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "Endpoint", "managingOrganization", element.getManagingOrganization(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactPoint(t, "Endpoint", "contact", element.getContact().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Endpoint", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getPayloadType().size(); i++) {
      composeCodeableConcept(t, "Endpoint", "payloadType", element.getPayloadType().get(i), i);
    }
    for (int i = 0; i < element.getPayloadMimeType().size(); i++) {
      composeCode(t, "Endpoint", "payloadMimeType", element.getPayloadMimeType().get(i), i);
    }
    if (element.hasAddressElement()) {
      composeUrl(t, "Endpoint", "address", element.getAddressElement(), -1);
    }
    for (int i = 0; i < element.getHeader().size(); i++) {
      composeString(t, "Endpoint", "header", element.getHeader().get(i), i);
    }
  }

  protected void composeEnrollmentRequest(Complex parent, String parentType, String name, EnrollmentRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EnrollmentRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EnrollmentRequest", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EnrollmentRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "EnrollmentRequest", "created", element.getCreatedElement(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "EnrollmentRequest", "insurer", element.getInsurer(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "EnrollmentRequest", "provider", element.getProvider(), -1);
    }
    if (element.hasCandidate()) {
      composeReference(t, "EnrollmentRequest", "candidate", element.getCandidate(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "EnrollmentRequest", "coverage", element.getCoverage(), -1);
    }
  }

  protected void composeEnrollmentResponse(Complex parent, String parentType, String name, EnrollmentResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EnrollmentResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EnrollmentResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EnrollmentResponse", "status", element.getStatusElement(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "EnrollmentResponse", "request", element.getRequest(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "EnrollmentResponse", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "EnrollmentResponse", "disposition", element.getDispositionElement(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "EnrollmentResponse", "created", element.getCreatedElement(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "EnrollmentResponse", "organization", element.getOrganization(), -1);
    }
    if (element.hasRequestProvider()) {
      composeReference(t, "EnrollmentResponse", "requestProvider", element.getRequestProvider(), -1);
    }
  }

  protected void composeEpisodeOfCare(Complex parent, String parentType, String name, EpisodeOfCare element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EpisodeOfCare", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EpisodeOfCare", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusHistory().size(); i++) {
      composeEpisodeOfCareStatusHistoryComponent(t, "EpisodeOfCare", "statusHistory", element.getStatusHistory().get(i), i);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "EpisodeOfCare", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeEpisodeOfCareDiagnosisComponent(t, "EpisodeOfCare", "diagnosis", element.getDiagnosis().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "EpisodeOfCare", "patient", element.getPatient(), -1);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "EpisodeOfCare", "managingOrganization", element.getManagingOrganization(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getReferralRequest().size(); i++) {
      composeReference(t, "EpisodeOfCare", "referralRequest", element.getReferralRequest().get(i), i);
    }
    if (element.hasCareManager()) {
      composeReference(t, "EpisodeOfCare", "careManager", element.getCareManager(), -1);
    }
    for (int i = 0; i < element.getCareTeam().size(); i++) {
      composeReference(t, "EpisodeOfCare", "careTeam", element.getCareTeam().get(i), i);
    }
    for (int i = 0; i < element.getAccount().size(); i++) {
      composeReference(t, "EpisodeOfCare", "account", element.getAccount().get(i), i);
    }
  }

  protected void composeEpisodeOfCareStatusHistoryComponent(Complex parent, String parentType, String name, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statusHistory", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "EpisodeOfCareStatusHistoryComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EpisodeOfCareStatusHistoryComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEpisodeOfCareDiagnosisComponent(Complex parent, String parentType, String name, EpisodeOfCare.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasCondition()) {
      composeCodeableReference(t, "DiagnosisComponent", "condition", element.getCondition(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "DiagnosisComponent", "role", element.getRole(), -1);
    }
    if (element.hasRankElement()) {
      composePositiveInt(t, "DiagnosisComponent", "rank", element.getRankElement(), -1);
    }
  }

  protected void composeEventDefinition(Complex parent, String parentType, String name, EventDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "EventDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "EventDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EventDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "EventDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "EventDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "EventDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "EventDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EventDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "EventDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "EventDefinition", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "EventDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "EventDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "EventDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "EventDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "EventDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "EventDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "EventDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "EventDefinition", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "EventDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "EventDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "EventDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "EventDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "EventDefinition", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "EventDefinition", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "EventDefinition", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "EventDefinition", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "EventDefinition", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "EventDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getTrigger().size(); i++) {
      composeTriggerDefinition(t, "EventDefinition", "trigger", element.getTrigger().get(i), i);
    }
  }

  protected void composeEvidence(Complex parent, String parentType, String name, Evidence element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "Evidence", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Evidence", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Evidence", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Evidence", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Evidence", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Evidence", "title", element.getTitleElement(), -1);
    }
    if (element.hasCiteAs()) {
      composeType(t, "Evidence", "citeAs", element.getCiteAs(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Evidence", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Evidence", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Evidence", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Evidence", "useContext", element.getUseContext().get(i), i);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Evidence", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Evidence", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Evidence", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Evidence", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "Evidence", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "Evidence", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "Evidence", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "Evidence", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "Evidence", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Evidence", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasAssertionElement()) {
      composeMarkdown(t, "Evidence", "assertion", element.getAssertionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Evidence", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getVariableDefinition().size(); i++) {
      composeEvidenceVariableDefinitionComponent(t, "Evidence", "variableDefinition", element.getVariableDefinition().get(i), i);
    }
    if (element.hasSynthesisType()) {
      composeCodeableConcept(t, "Evidence", "synthesisType", element.getSynthesisType(), -1);
    }
    for (int i = 0; i < element.getStudyDesign().size(); i++) {
      composeCodeableConcept(t, "Evidence", "studyDesign", element.getStudyDesign().get(i), i);
    }
    for (int i = 0; i < element.getStatistic().size(); i++) {
      composeEvidenceStatisticComponent(t, "Evidence", "statistic", element.getStatistic().get(i), i);
    }
    for (int i = 0; i < element.getCertainty().size(); i++) {
      composeEvidenceCertaintyComponent(t, "Evidence", "certainty", element.getCertainty().get(i), i);
    }
  }

  protected void composeEvidenceVariableDefinitionComponent(Complex parent, String parentType, String name, Evidence.EvidenceVariableDefinitionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "variableDefinition", name, element, index);
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "EvidenceVariableDefinitionComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceVariableDefinitionComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasVariableRole()) {
      composeCodeableConcept(t, "EvidenceVariableDefinitionComponent", "variableRole", element.getVariableRole(), -1);
    }
    if (element.hasObserved()) {
      composeReference(t, "EvidenceVariableDefinitionComponent", "observed", element.getObserved(), -1);
    }
    if (element.hasIntended()) {
      composeReference(t, "EvidenceVariableDefinitionComponent", "intended", element.getIntended(), -1);
    }
    if (element.hasDirectnessMatch()) {
      composeCodeableConcept(t, "EvidenceVariableDefinitionComponent", "directnessMatch", element.getDirectnessMatch(), -1);
    }
  }

  protected void composeEvidenceStatisticComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statistic", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceStatisticComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceStatisticComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasStatisticType()) {
      composeCodeableConcept(t, "EvidenceStatisticComponent", "statisticType", element.getStatisticType(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "EvidenceStatisticComponent", "category", element.getCategory(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "EvidenceStatisticComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasNumberOfEventsElement()) {
      composeUnsignedInt(t, "EvidenceStatisticComponent", "numberOfEvents", element.getNumberOfEventsElement(), -1);
    }
    if (element.hasNumberAffectedElement()) {
      composeUnsignedInt(t, "EvidenceStatisticComponent", "numberAffected", element.getNumberAffectedElement(), -1);
    }
    if (element.hasSampleSize()) {
      composeEvidenceStatisticSampleSizeComponent(t, "EvidenceStatisticComponent", "sampleSize", element.getSampleSize(), -1);
    }
    for (int i = 0; i < element.getAttributeEstimate().size(); i++) {
      composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
    }
    for (int i = 0; i < element.getModelCharacteristic().size(); i++) {
      composeEvidenceStatisticModelCharacteristicComponent(t, "EvidenceStatisticComponent", "modelCharacteristic", element.getModelCharacteristic().get(i), i);
    }
  }

  protected void composeEvidenceStatisticSampleSizeComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticSampleSizeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "sampleSize", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceStatisticSampleSizeComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceStatisticSampleSizeComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasNumberOfStudiesElement()) {
      composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "numberOfStudies", element.getNumberOfStudiesElement(), -1);
    }
    if (element.hasNumberOfParticipantsElement()) {
      composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "numberOfParticipants", element.getNumberOfParticipantsElement(), -1);
    }
    if (element.hasKnownDataCountElement()) {
      composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "knownDataCount", element.getKnownDataCountElement(), -1);
    }
  }

  protected void composeEvidenceStatisticAttributeEstimateComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticAttributeEstimateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "attributeEstimate", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceStatisticAttributeEstimateComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceStatisticAttributeEstimateComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "EvidenceStatisticAttributeEstimateComponent", "type", element.getType(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "EvidenceStatisticAttributeEstimateComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasLevelElement()) {
      composeDecimal(t, "EvidenceStatisticAttributeEstimateComponent", "level", element.getLevelElement(), -1);
    }
    if (element.hasRange()) {
      composeRange(t, "EvidenceStatisticAttributeEstimateComponent", "range", element.getRange(), -1);
    }
    for (int i = 0; i < element.getAttributeEstimate().size(); i++) {
      composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticAttributeEstimateComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
    }
  }

  protected void composeEvidenceStatisticModelCharacteristicComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticModelCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "modelCharacteristic", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "EvidenceStatisticModelCharacteristicComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeQuantity(t, "EvidenceStatisticModelCharacteristicComponent", "value", element.getValue(), -1);
    }
    for (int i = 0; i < element.getVariable().size(); i++) {
      composeEvidenceStatisticModelCharacteristicVariableComponent(t, "EvidenceStatisticModelCharacteristicComponent", "variable", element.getVariable().get(i), i);
    }
    for (int i = 0; i < element.getAttributeEstimate().size(); i++) {
      composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticModelCharacteristicComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
    }
  }

  protected void composeEvidenceStatisticModelCharacteristicVariableComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticModelCharacteristicVariableComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "variable", name, element, index);
    if (element.hasVariableDefinition()) {
      composeReference(t, "EvidenceStatisticModelCharacteristicVariableComponent", "variableDefinition", element.getVariableDefinition(), -1);
    }
    if (element.hasHandlingElement()) {
      composeEnum(t, "EvidenceStatisticModelCharacteristicVariableComponent", "handling", element.getHandlingElement(), -1);
    }
    for (int i = 0; i < element.getValueCategory().size(); i++) {
      composeCodeableConcept(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueCategory", element.getValueCategory().get(i), i);
    }
    for (int i = 0; i < element.getValueQuantity().size(); i++) {
      composeQuantity(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueQuantity", element.getValueQuantity().get(i), i);
    }
    for (int i = 0; i < element.getValueRange().size(); i++) {
      composeRange(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueRange", element.getValueRange().get(i), i);
    }
  }

  protected void composeEvidenceCertaintyComponent(Complex parent, String parentType, String name, Evidence.EvidenceCertaintyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "certainty", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceCertaintyComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceCertaintyComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "EvidenceCertaintyComponent", "type", element.getType(), -1);
    }
    if (element.hasRating()) {
      composeCodeableConcept(t, "EvidenceCertaintyComponent", "rating", element.getRating(), -1);
    }
    if (element.hasRaterElement()) {
      composeString(t, "EvidenceCertaintyComponent", "rater", element.getRaterElement(), -1);
    }
    for (int i = 0; i < element.getSubcomponent().size(); i++) {
      composeEvidenceCertaintyComponent(t, "EvidenceCertaintyComponent", "subcomponent", element.getSubcomponent().get(i), i);
    }
  }

  protected void composeEvidenceReport(Complex parent, String parentType, String name, EvidenceReport element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "EvidenceReport", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "EvidenceReport", "url", element.getUrlElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EvidenceReport", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "EvidenceReport", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EvidenceReport", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getRelatedIdentifier().size(); i++) {
      composeIdentifier(t, "EvidenceReport", "relatedIdentifier", element.getRelatedIdentifier().get(i), i);
    }
    if (element.hasCiteAs()) {
      composeType(t, "EvidenceReport", "citeAs", element.getCiteAs(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "EvidenceReport", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceReport", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "EvidenceReport", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasSubject()) {
      composeEvidenceReportSubjectComponent(t, "EvidenceReport", "subject", element.getSubject(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "EvidenceReport", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeEvidenceReportRelatesToComponent(t, "EvidenceReport", "relatesTo", element.getRelatesTo().get(i), i);
    }
    for (int i = 0; i < element.getSection().size(); i++) {
      composeEvidenceReportSectionComponent(t, "EvidenceReport", "section", element.getSection().get(i), i);
    }
  }

  protected void composeEvidenceReportSubjectComponent(Complex parent, String parentType, String name, EvidenceReport.EvidenceReportSubjectComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subject", name, element, index);
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeEvidenceReportSubjectCharacteristicComponent(t, "EvidenceReportSubjectComponent", "characteristic", element.getCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceReportSubjectComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeEvidenceReportSubjectCharacteristicComponent(Complex parent, String parentType, String name, EvidenceReport.EvidenceReportSubjectCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "EvidenceReportSubjectCharacteristicComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "EvidenceReportSubjectCharacteristicComponent", "value", element.getValue(), -1);
    }
    if (element.hasExcludeElement()) {
      composeBoolean(t, "EvidenceReportSubjectCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EvidenceReportSubjectCharacteristicComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEvidenceReportRelatesToComponent(Complex parent, String parentType, String name, EvidenceReport.EvidenceReportRelatesToComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatesTo", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "EvidenceReportRelatesToComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasTarget()) {
      composeEvidenceReportRelatesToTargetComponent(t, "EvidenceReportRelatesToComponent", "target", element.getTarget(), -1);
    }
  }

  protected void composeEvidenceReportRelatesToTargetComponent(Complex parent, String parentType, String name, EvidenceReport.EvidenceReportRelatesToTargetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "EvidenceReportRelatesToTargetComponent", "url", element.getUrlElement(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "EvidenceReportRelatesToTargetComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasDisplayElement()) {
      composeMarkdown(t, "EvidenceReportRelatesToTargetComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasResource()) {
      composeReference(t, "EvidenceReportRelatesToTargetComponent", "resource", element.getResource(), -1);
    }
  }

  protected void composeEvidenceReportSectionComponent(Complex parent, String parentType, String name, EvidenceReport.SectionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "section", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "SectionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasFocus()) {
      composeCodeableConcept(t, "SectionComponent", "focus", element.getFocus(), -1);
    }
    if (element.hasFocusReference()) {
      composeReference(t, "SectionComponent", "focusReference", element.getFocusReference(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "SectionComponent", "author", element.getAuthor().get(i), i);
    }
    if (element.hasText()) {
      composeNarrative(t, "SectionComponent", "text", element.getText(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "SectionComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasOrderedBy()) {
      composeCodeableConcept(t, "SectionComponent", "orderedBy", element.getOrderedBy(), -1);
    }
    for (int i = 0; i < element.getEntryClassifier().size(); i++) {
      composeCodeableConcept(t, "SectionComponent", "entryClassifier", element.getEntryClassifier().get(i), i);
    }
    for (int i = 0; i < element.getEntryReference().size(); i++) {
      composeReference(t, "SectionComponent", "entryReference", element.getEntryReference().get(i), i);
    }
    for (int i = 0; i < element.getEntryQuantity().size(); i++) {
      composeQuantity(t, "SectionComponent", "entryQuantity", element.getEntryQuantity().get(i), i);
    }
    if (element.hasEmptyReason()) {
      composeCodeableConcept(t, "SectionComponent", "emptyReason", element.getEmptyReason(), -1);
    }
    for (int i = 0; i < element.getSection().size(); i++) {
      composeEvidenceReportSectionComponent(t, "SectionComponent", "section", element.getSection().get(i), i);
    }
  }

  protected void composeEvidenceVariable(Complex parent, String parentType, String name, EvidenceVariable element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "EvidenceVariable", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "EvidenceVariable", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EvidenceVariable", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "EvidenceVariable", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "EvidenceVariable", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "EvidenceVariable", "title", element.getTitleElement(), -1);
    }
    if (element.hasShortTitleElement()) {
      composeString(t, "EvidenceVariable", "shortTitle", element.getShortTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "EvidenceVariable", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EvidenceVariable", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "EvidenceVariable", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "EvidenceVariable", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "EvidenceVariable", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "EvidenceVariable", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceVariable", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "EvidenceVariable", "useContext", element.getUseContext().get(i), i);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "EvidenceVariable", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "EvidenceVariable", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "EvidenceVariable", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "EvidenceVariable", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "EvidenceVariable", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasActualElement()) {
      composeBoolean(t, "EvidenceVariable", "actual", element.getActualElement(), -1);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeEvidenceVariableCharacteristicComponent(t, "EvidenceVariable", "characteristic", element.getCharacteristic().get(i), i);
    }
    if (element.hasHandlingElement()) {
      composeEnum(t, "EvidenceVariable", "handling", element.getHandlingElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeEvidenceVariableCategoryComponent(t, "EvidenceVariable", "category", element.getCategory().get(i), i);
    }
  }

  protected void composeEvidenceVariableCharacteristicComponent(Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasLinkIdElement()) {
      composeId(t, "EvidenceVariableCharacteristicComponent", "linkId", element.getLinkIdElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceVariableCharacteristicComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceVariableCharacteristicComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasExcludeElement()) {
      composeBoolean(t, "EvidenceVariableCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
    }
    if (element.hasDefinitionReference()) {
      composeReference(t, "EvidenceVariableCharacteristicComponent", "definitionReference", element.getDefinitionReference(), -1);
    }
    if (element.hasDefinitionCanonicalElement()) {
      composeCanonical(t, "EvidenceVariableCharacteristicComponent", "definitionCanonical", element.getDefinitionCanonicalElement(), -1);
    }
    if (element.hasDefinitionCodeableConcept()) {
      composeCodeableConcept(t, "EvidenceVariableCharacteristicComponent", "definitionCodeableConcept", element.getDefinitionCodeableConcept(), -1);
    }
    if (element.hasDefinitionExpression()) {
      composeExpression(t, "EvidenceVariableCharacteristicComponent", "definitionExpression", element.getDefinitionExpression(), -1);
    }
    if (element.hasDefinitionIdElement()) {
      composeId(t, "EvidenceVariableCharacteristicComponent", "definitionId", element.getDefinitionIdElement(), -1);
    }
    if (element.hasDefinitionByTypeAndValue()) {
      composeEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(t, "EvidenceVariableCharacteristicComponent", "definitionByTypeAndValue", element.getDefinitionByTypeAndValue(), -1);
    }
    if (element.hasDefinitionByCombination()) {
      composeEvidenceVariableCharacteristicDefinitionByCombinationComponent(t, "EvidenceVariableCharacteristicComponent", "definitionByCombination", element.getDefinitionByCombination(), -1);
    }
    for (int i = 0; i < element.getTimeFromEvent().size(); i++) {
      composeEvidenceVariableCharacteristicTimeFromEventComponent(t, "EvidenceVariableCharacteristicComponent", "timeFromEvent", element.getTimeFromEvent().get(i), i);
    }
  }

  protected void composeEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "definitionByTypeAndValue", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getMethod().size(); i++) {
      composeCodeableConcept(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "method", element.getMethod().get(i), i);
    }
    if (element.hasDevice()) {
      composeReference(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "device", element.getDevice(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "value", element.getValue(), -1);
    }
    if (element.hasOffset()) {
      composeCodeableConcept(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "offset", element.getOffset(), -1);
    }
  }

  protected void composeEvidenceVariableCharacteristicDefinitionByCombinationComponent(Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "definitionByCombination", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "EvidenceVariableCharacteristicDefinitionByCombinationComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasThresholdElement()) {
      composePositiveInt(t, "EvidenceVariableCharacteristicDefinitionByCombinationComponent", "threshold", element.getThresholdElement(), -1);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeEvidenceVariableCharacteristicComponent(t, "EvidenceVariableCharacteristicDefinitionByCombinationComponent", "characteristic", element.getCharacteristic().get(i), i);
    }
  }

  protected void composeEvidenceVariableCharacteristicTimeFromEventComponent(Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "timeFromEvent", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasEvent()) {
      composeType(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "event", element.getEvent(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasRange()) {
      composeRange(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "range", element.getRange(), -1);
    }
  }

  protected void composeEvidenceVariableCategoryComponent(Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCategoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "category", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "EvidenceVariableCategoryComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "EvidenceVariableCategoryComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeExampleScenario(Complex parent, String parentType, String name, ExampleScenario element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "ExampleScenario", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ExampleScenario", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ExampleScenario", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ExampleScenario", "version", element.getVersionElement(), -1);
    }
    if (element.hasVersionAlgorithm()) {
      composeType(t, "ExampleScenario", "versionAlgorithm", element.getVersionAlgorithm(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenario", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ExampleScenario", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ExampleScenario", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ExampleScenario", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ExampleScenario", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ExampleScenario", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ExampleScenario", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ExampleScenario", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ExampleScenario", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ExampleScenario", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCopyrightLabelElement()) {
      composeString(t, "ExampleScenario", "copyrightLabel", element.getCopyrightLabelElement(), -1);
    }
    for (int i = 0; i < element.getActor().size(); i++) {
      composeExampleScenarioActorComponent(t, "ExampleScenario", "actor", element.getActor().get(i), i);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeExampleScenarioInstanceComponent(t, "ExampleScenario", "instance", element.getInstance().get(i), i);
    }
    for (int i = 0; i < element.getProcess().size(); i++) {
      composeExampleScenarioProcessComponent(t, "ExampleScenario", "process", element.getProcess().get(i), i);
    }
  }

  protected void composeExampleScenarioActorComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioActorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "actor", name, element, index);
    if (element.hasKeyElement()) {
      composeString(t, "ExampleScenarioActorComponent", "key", element.getKeyElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ExampleScenarioActorComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenarioActorComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioActorComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeExampleScenarioInstanceComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "instance", name, element, index);
    if (element.hasKeyElement()) {
      composeString(t, "ExampleScenarioInstanceComponent", "key", element.getKeyElement(), -1);
    }
    if (element.hasStructureType()) {
      composeCoding(t, "ExampleScenarioInstanceComponent", "structureType", element.getStructureType(), -1);
    }
    if (element.hasStructureVersionElement()) {
      composeString(t, "ExampleScenarioInstanceComponent", "structureVersion", element.getStructureVersionElement(), -1);
    }
    if (element.hasStructureProfile()) {
      composeType(t, "ExampleScenarioInstanceComponent", "structureProfile", element.getStructureProfile(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenarioInstanceComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioInstanceComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasContent()) {
      composeReference(t, "ExampleScenarioInstanceComponent", "content", element.getContent(), -1);
    }
    for (int i = 0; i < element.getVersion().size(); i++) {
      composeExampleScenarioInstanceVersionComponent(t, "ExampleScenarioInstanceComponent", "version", element.getVersion().get(i), i);
    }
    for (int i = 0; i < element.getContainedInstance().size(); i++) {
      composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioInstanceComponent", "containedInstance", element.getContainedInstance().get(i), i);
    }
  }

  protected void composeExampleScenarioInstanceVersionComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceVersionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "version", name, element, index);
    if (element.hasKeyElement()) {
      composeString(t, "ExampleScenarioInstanceVersionComponent", "key", element.getKeyElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenarioInstanceVersionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioInstanceVersionComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasContent()) {
      composeReference(t, "ExampleScenarioInstanceVersionComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeExampleScenarioInstanceContainedInstanceComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "containedInstance", name, element, index);
    if (element.hasInstanceReferenceElement()) {
      composeString(t, "ExampleScenarioInstanceContainedInstanceComponent", "instanceReference", element.getInstanceReferenceElement(), -1);
    }
    if (element.hasVersionReferenceElement()) {
      composeString(t, "ExampleScenarioInstanceContainedInstanceComponent", "versionReference", element.getVersionReferenceElement(), -1);
    }
  }

  protected void composeExampleScenarioProcessComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "process", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenarioProcessComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioProcessComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasPreConditionsElement()) {
      composeMarkdown(t, "ExampleScenarioProcessComponent", "preConditions", element.getPreConditionsElement(), -1);
    }
    if (element.hasPostConditionsElement()) {
      composeMarkdown(t, "ExampleScenarioProcessComponent", "postConditions", element.getPostConditionsElement(), -1);
    }
    for (int i = 0; i < element.getStep().size(); i++) {
      composeExampleScenarioProcessStepComponent(t, "ExampleScenarioProcessComponent", "step", element.getStep().get(i), i);
    }
  }

  protected void composeExampleScenarioProcessStepComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "step", name, element, index);
    if (element.hasNumberElement()) {
      composeString(t, "ExampleScenarioProcessStepComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasProcess()) {
      composeExampleScenarioProcessComponent(t, "ExampleScenarioProcessStepComponent", "process", element.getProcess(), -1);
    }
    if (element.hasWorkflowElement()) {
      composeCanonical(t, "ExampleScenarioProcessStepComponent", "workflow", element.getWorkflowElement(), -1);
    }
    if (element.hasOperation()) {
      composeExampleScenarioProcessStepOperationComponent(t, "ExampleScenarioProcessStepComponent", "operation", element.getOperation(), -1);
    }
    for (int i = 0; i < element.getAlternative().size(); i++) {
      composeExampleScenarioProcessStepAlternativeComponent(t, "ExampleScenarioProcessStepComponent", "alternative", element.getAlternative().get(i), i);
    }
    if (element.hasPauseElement()) {
      composeBoolean(t, "ExampleScenarioProcessStepComponent", "pause", element.getPauseElement(), -1);
    }
  }

  protected void composeExampleScenarioProcessStepOperationComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasType()) {
      composeCoding(t, "ExampleScenarioProcessStepOperationComponent", "type", element.getType(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenarioProcessStepOperationComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasInitiatorElement()) {
      composeString(t, "ExampleScenarioProcessStepOperationComponent", "initiator", element.getInitiatorElement(), -1);
    }
    if (element.hasReceiverElement()) {
      composeString(t, "ExampleScenarioProcessStepOperationComponent", "receiver", element.getReceiverElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioProcessStepOperationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasInitiatorActiveElement()) {
      composeBoolean(t, "ExampleScenarioProcessStepOperationComponent", "initiatorActive", element.getInitiatorActiveElement(), -1);
    }
    if (element.hasReceiverActiveElement()) {
      composeBoolean(t, "ExampleScenarioProcessStepOperationComponent", "receiverActive", element.getReceiverActiveElement(), -1);
    }
    if (element.hasRequest()) {
      composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioProcessStepOperationComponent", "request", element.getRequest(), -1);
    }
    if (element.hasResponse()) {
      composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioProcessStepOperationComponent", "response", element.getResponse(), -1);
    }
  }

  protected void composeExampleScenarioProcessStepAlternativeComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "alternative", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenarioProcessStepAlternativeComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioProcessStepAlternativeComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getStep().size(); i++) {
      composeExampleScenarioProcessStepComponent(t, "ExampleScenarioProcessStepAlternativeComponent", "step", element.getStep().get(i), i);
    }
  }

  protected void composeExplanationOfBenefit(Complex parent, String parentType, String name, ExplanationOfBenefit element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ExplanationOfBenefit", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ExplanationOfBenefit", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "subType", element.getSubType(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "ExplanationOfBenefit", "use", element.getUseElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "ExplanationOfBenefit", "patient", element.getPatient(), -1);
    }
    if (element.hasBillablePeriod()) {
      composePeriod(t, "ExplanationOfBenefit", "billablePeriod", element.getBillablePeriod(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "ExplanationOfBenefit", "created", element.getCreatedElement(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "ExplanationOfBenefit", "enterer", element.getEnterer(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "ExplanationOfBenefit", "insurer", element.getInsurer(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "priority", element.getPriority(), -1);
    }
    if (element.hasFundsReserveRequested()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserveRequested", element.getFundsReserveRequested(), -1);
    }
    if (element.hasFundsReserve()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserve", element.getFundsReserve(), -1);
    }
    for (int i = 0; i < element.getRelated().size(); i++) {
      composeExplanationOfBenefitRelatedClaimComponent(t, "ExplanationOfBenefit", "related", element.getRelated().get(i), i);
    }
    if (element.hasPrescription()) {
      composeReference(t, "ExplanationOfBenefit", "prescription", element.getPrescription(), -1);
    }
    if (element.hasOriginalPrescription()) {
      composeReference(t, "ExplanationOfBenefit", "originalPrescription", element.getOriginalPrescription(), -1);
    }
    if (element.hasPayee()) {
      composeExplanationOfBenefitPayeeComponent(t, "ExplanationOfBenefit", "payee", element.getPayee(), -1);
    }
    if (element.hasReferral()) {
      composeReference(t, "ExplanationOfBenefit", "referral", element.getReferral(), -1);
    }
    for (int i = 0; i < element.getEncounter().size(); i++) {
      composeReference(t, "ExplanationOfBenefit", "encounter", element.getEncounter().get(i), i);
    }
    if (element.hasFacility()) {
      composeReference(t, "ExplanationOfBenefit", "facility", element.getFacility(), -1);
    }
    if (element.hasClaim()) {
      composeReference(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
    }
    if (element.hasClaimResponse()) {
      composeReference(t, "ExplanationOfBenefit", "claimResponse", element.getClaimResponse(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "ExplanationOfBenefit", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "decision", element.getDecision(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "ExplanationOfBenefit", "disposition", element.getDispositionElement(), -1);
    }
    for (int i = 0; i < element.getPreAuthRef().size(); i++) {
      composeString(t, "ExplanationOfBenefit", "preAuthRef", element.getPreAuthRef().get(i), i);
    }
    for (int i = 0; i < element.getPreAuthRefPeriod().size(); i++) {
      composePeriod(t, "ExplanationOfBenefit", "preAuthRefPeriod", element.getPreAuthRefPeriod().get(i), i);
    }
    if (element.hasDiagnosisRelatedGroup()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "diagnosisRelatedGroup", element.getDiagnosisRelatedGroup(), -1);
    }
    for (int i = 0; i < element.getCareTeam().size(); i++) {
      composeExplanationOfBenefitCareTeamComponent(t, "ExplanationOfBenefit", "careTeam", element.getCareTeam().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeExplanationOfBenefitSupportingInformationComponent(t, "ExplanationOfBenefit", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeExplanationOfBenefitDiagnosisComponent(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis().get(i), i);
    }
    for (int i = 0; i < element.getProcedure().size(); i++) {
      composeExplanationOfBenefitProcedureComponent(t, "ExplanationOfBenefit", "procedure", element.getProcedure().get(i), i);
    }
    if (element.hasPrecedenceElement()) {
      composePositiveInt(t, "ExplanationOfBenefit", "precedence", element.getPrecedenceElement(), -1);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeExplanationOfBenefitInsuranceComponent(t, "ExplanationOfBenefit", "insurance", element.getInsurance().get(i), i);
    }
    if (element.hasAccident()) {
      composeExplanationOfBenefitAccidentComponent(t, "ExplanationOfBenefit", "accident", element.getAccident(), -1);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "ExplanationOfBenefit", "patientPaid", element.getPatientPaid(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeExplanationOfBenefitItemComponent(t, "ExplanationOfBenefit", "item", element.getItem().get(i), i);
    }
    for (int i = 0; i < element.getAddItem().size(); i++) {
      composeExplanationOfBenefitAddedItemComponent(t, "ExplanationOfBenefit", "addItem", element.getAddItem().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getTotal().size(); i++) {
      composeExplanationOfBenefitTotalComponent(t, "ExplanationOfBenefit", "total", element.getTotal().get(i), i);
    }
    if (element.hasPayment()) {
      composeExplanationOfBenefitPaymentComponent(t, "ExplanationOfBenefit", "payment", element.getPayment(), -1);
    }
    if (element.hasFormCode()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "formCode", element.getFormCode(), -1);
    }
    if (element.hasForm()) {
      composeAttachment(t, "ExplanationOfBenefit", "form", element.getForm(), -1);
    }
    for (int i = 0; i < element.getProcessNote().size(); i++) {
      composeExplanationOfBenefitNoteComponent(t, "ExplanationOfBenefit", "processNote", element.getProcessNote().get(i), i);
    }
    if (element.hasBenefitPeriod()) {
      composePeriod(t, "ExplanationOfBenefit", "benefitPeriod", element.getBenefitPeriod(), -1);
    }
    for (int i = 0; i < element.getBenefitBalance().size(); i++) {
      composeExplanationOfBenefitBenefitBalanceComponent(t, "ExplanationOfBenefit", "benefitBalance", element.getBenefitBalance().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitRelatedClaimComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.RelatedClaimComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "related", name, element, index);
    if (element.hasClaim()) {
      composeReference(t, "RelatedClaimComponent", "claim", element.getClaim(), -1);
    }
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "RelatedClaimComponent", "relationship", element.getRelationship(), -1);
    }
    if (element.hasReference()) {
      composeIdentifier(t, "RelatedClaimComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeExplanationOfBenefitPayeeComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.PayeeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payee", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PayeeComponent", "type", element.getType(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "PayeeComponent", "party", element.getParty(), -1);
    }
  }

  protected void composeExplanationOfBenefitCareTeamComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.CareTeamComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "careTeam", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "CareTeamComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "CareTeamComponent", "provider", element.getProvider(), -1);
    }
    if (element.hasResponsibleElement()) {
      composeBoolean(t, "CareTeamComponent", "responsible", element.getResponsibleElement(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "CareTeamComponent", "role", element.getRole(), -1);
    }
    if (element.hasSpecialty()) {
      composeCodeableConcept(t, "CareTeamComponent", "specialty", element.getSpecialty(), -1);
    }
  }

  protected void composeExplanationOfBenefitSupportingInformationComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.SupportingInformationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportingInfo", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "code", element.getCode(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "SupportingInformationComponent", "timing", element.getTiming(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "SupportingInformationComponent", "value", element.getValue(), -1);
    }
    if (element.hasReason()) {
      composeCoding(t, "SupportingInformationComponent", "reason", element.getReason(), -1);
    }
  }

  protected void composeExplanationOfBenefitDiagnosisComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "DiagnosisComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasDiagnosis()) {
      composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "DiagnosisComponent", "type", element.getType().get(i), i);
    }
    if (element.hasOnAdmission()) {
      composeCodeableConcept(t, "DiagnosisComponent", "onAdmission", element.getOnAdmission(), -1);
    }
  }

  protected void composeExplanationOfBenefitProcedureComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.ProcedureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "procedure", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "ProcedureComponent", "sequence", element.getSequenceElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "ProcedureComponent", "type", element.getType().get(i), i);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ProcedureComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasProcedure()) {
      composeType(t, "ProcedureComponent", "procedure", element.getProcedure(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "ProcedureComponent", "udi", element.getUdi().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitInsuranceComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasFocalElement()) {
      composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    for (int i = 0; i < element.getPreAuthRef().size(); i++) {
      composeString(t, "InsuranceComponent", "preAuthRef", element.getPreAuthRef().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAccidentComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AccidentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "accident", name, element, index);
    if (element.hasDateElement()) {
      composeDate(t, "AccidentComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "AccidentComponent", "type", element.getType(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "AccidentComponent", "location", element.getLocation(), -1);
    }
  }

  protected void composeExplanationOfBenefitItemComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.ItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "ItemComponent", "sequence", element.getSequenceElement(), -1);
    }
    for (int i = 0; i < element.getCareTeamSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "careTeamSequence", element.getCareTeamSequence().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosisSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
    }
    for (int i = 0; i < element.getProcedureSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "procedureSequence", element.getProcedureSequence().get(i), i);
    }
    for (int i = 0; i < element.getInformationSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "informationSequence", element.getInformationSequence().get(i), i);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "ItemComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "ItemComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "ItemComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "ItemComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasServiced()) {
      composeType(t, "ItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "ItemComponent", "location", element.getLocation(), -1);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "ItemComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "ItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "ItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "ItemComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "ItemComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "ItemComponent", "udi", element.getUdi().get(i), i);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeExplanationOfBenefitItemBodySiteComponent(t, "ItemComponent", "bodySite", element.getBodySite().get(i), i);
    }
    for (int i = 0; i < element.getEncounter().size(); i++) {
      composeReference(t, "ItemComponent", "encounter", element.getEncounter().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "ItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "ItemComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "ItemComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeExplanationOfBenefitDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitItemBodySiteComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.ItemBodySiteComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "bodySite", name, element, index);
    for (int i = 0; i < element.getSite().size(); i++) {
      composeCodeableReference(t, "ItemBodySiteComponent", "site", element.getSite().get(i), i);
    }
    for (int i = 0; i < element.getSubSite().size(); i++) {
      composeCodeableConcept(t, "ItemBodySiteComponent", "subSite", element.getSubSite().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAdjudicationComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AdjudicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "adjudication", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "AdjudicationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "AdjudicationComponent", "reason", element.getReason(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "AdjudicationComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasValueElement()) {
      composeDecimal(t, "AdjudicationComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeExplanationOfBenefitDetailComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.DetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "DetailComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "DetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "DetailComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "DetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "DetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "DetailComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "DetailComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "DetailComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "DetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "DetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "DetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "DetailComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "DetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "DetailComponent", "udi", element.getUdi().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "DetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "DetailComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "DetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeExplanationOfBenefitSubDetailComponent(t, "DetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitSubDetailComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.SubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SubDetailComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "SubDetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SubDetailComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "SubDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "SubDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "SubDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "SubDetailComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "SubDetailComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "SubDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "SubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "SubDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "SubDetailComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "SubDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "SubDetailComponent", "udi", element.getUdi().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "SubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "SubDetailComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "SubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAddedItemComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "addItem", name, element, index);
    for (int i = 0; i < element.getItemSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "itemSequence", element.getItemSequence().get(i), i);
    }
    for (int i = 0; i < element.getDetailSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "detailSequence", element.getDetailSequence().get(i), i);
    }
    for (int i = 0; i < element.getSubDetailSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "subDetailSequence", element.getSubDetailSequence().get(i), i);
    }
    for (int i = 0; i < element.getProvider().size(); i++) {
      composeReference(t, "AddedItemComponent", "provider", element.getProvider().get(i), i);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "AddedItemComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "AddedItemComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasServiced()) {
      composeType(t, "AddedItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "AddedItemComponent", "location", element.getLocation(), -1);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "AddedItemComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "AddedItemComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeExplanationOfBenefitAddedItemBodySiteComponent(t, "AddedItemComponent", "bodySite", element.getBodySite().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "AddedItemComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeExplanationOfBenefitAddedItemDetailComponent(t, "AddedItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAddedItemBodySiteComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemBodySiteComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "bodySite", name, element, index);
    for (int i = 0; i < element.getSite().size(); i++) {
      composeCodeableReference(t, "AddedItemBodySiteComponent", "site", element.getSite().get(i), i);
    }
    for (int i = 0; i < element.getSubSite().size(); i++) {
      composeCodeableConcept(t, "AddedItemBodySiteComponent", "subSite", element.getSubSite().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAddedItemDetailComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "AddedItemDetailComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "AddedItemDetailComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeExplanationOfBenefitAddedItemDetailSubDetailComponent(t, "AddedItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAddedItemDetailSubDetailComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailSubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    if (element.hasProductOrServiceEnd()) {
      composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasPatientPaid()) {
      composeMoney(t, "AddedItemDetailSubDetailComponent", "patientPaid", element.getPatientPaid(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemDetailSubDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemDetailSubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemDetailSubDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasTax()) {
      composeMoney(t, "AddedItemDetailSubDetailComponent", "tax", element.getTax(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemDetailSubDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemDetailSubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemDetailSubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitTotalComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.TotalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "total", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "TotalComponent", "category", element.getCategory(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "TotalComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeExplanationOfBenefitPaymentComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.PaymentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payment", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PaymentComponent", "type", element.getType(), -1);
    }
    if (element.hasAdjustment()) {
      composeMoney(t, "PaymentComponent", "adjustment", element.getAdjustment(), -1);
    }
    if (element.hasAdjustmentReason()) {
      composeCodeableConcept(t, "PaymentComponent", "adjustmentReason", element.getAdjustmentReason(), -1);
    }
    if (element.hasDateElement()) {
      composeDate(t, "PaymentComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "PaymentComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "PaymentComponent", "identifier", element.getIdentifier(), -1);
    }
  }

  protected void composeExplanationOfBenefitNoteComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.NoteComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "processNote", name, element, index);
    if (element.hasNumberElement()) {
      composePositiveInt(t, "NoteComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "NoteComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "NoteComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "NoteComponent", "language", element.getLanguage(), -1);
    }
  }

  protected void composeExplanationOfBenefitBenefitBalanceComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitBalanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "benefitBalance", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "BenefitBalanceComponent", "category", element.getCategory(), -1);
    }
    if (element.hasExcludedElement()) {
      composeBoolean(t, "BenefitBalanceComponent", "excluded", element.getExcludedElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "BenefitBalanceComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "BenefitBalanceComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasNetwork()) {
      composeCodeableConcept(t, "BenefitBalanceComponent", "network", element.getNetwork(), -1);
    }
    if (element.hasUnit()) {
      composeCodeableConcept(t, "BenefitBalanceComponent", "unit", element.getUnit(), -1);
    }
    if (element.hasTerm()) {
      composeCodeableConcept(t, "BenefitBalanceComponent", "term", element.getTerm(), -1);
    }
    for (int i = 0; i < element.getFinancial().size(); i++) {
      composeExplanationOfBenefitBenefitComponent(t, "BenefitBalanceComponent", "financial", element.getFinancial().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitBenefitComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "financial", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "BenefitComponent", "type", element.getType(), -1);
    }
    if (element.hasAllowed()) {
      composeType(t, "BenefitComponent", "allowed", element.getAllowed(), -1);
    }
    if (element.hasUsed()) {
      composeType(t, "BenefitComponent", "used", element.getUsed(), -1);
    }
  }

  protected void composeFamilyMemberHistory(Complex parent, String parentType, String name, FamilyMemberHistory element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "FamilyMemberHistory", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "FamilyMemberHistory", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "FamilyMemberHistory", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "FamilyMemberHistory", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "FamilyMemberHistory", "status", element.getStatusElement(), -1);
    }
    if (element.hasDataAbsentReason()) {
      composeCodeableConcept(t, "FamilyMemberHistory", "dataAbsentReason", element.getDataAbsentReason(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "FamilyMemberHistory", "patient", element.getPatient(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "FamilyMemberHistory", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeFamilyMemberHistoryParticipantComponent(t, "FamilyMemberHistory", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "FamilyMemberHistory", "name", element.getNameElement(), -1);
    }
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "FamilyMemberHistory", "relationship", element.getRelationship(), -1);
    }
    if (element.hasSex()) {
      composeCodeableConcept(t, "FamilyMemberHistory", "sex", element.getSex(), -1);
    }
    if (element.hasBorn()) {
      composeType(t, "FamilyMemberHistory", "born", element.getBorn(), -1);
    }
    if (element.hasAge()) {
      composeType(t, "FamilyMemberHistory", "age", element.getAge(), -1);
    }
    if (element.hasEstimatedAgeElement()) {
      composeBoolean(t, "FamilyMemberHistory", "estimatedAge", element.getEstimatedAgeElement(), -1);
    }
    if (element.hasDeceased()) {
      composeType(t, "FamilyMemberHistory", "deceased", element.getDeceased(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "FamilyMemberHistory", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeFamilyMemberHistoryConditionComponent(t, "FamilyMemberHistory", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getProcedure().size(); i++) {
      composeFamilyMemberHistoryProcedureComponent(t, "FamilyMemberHistory", "procedure", element.getProcedure().get(i), i);
    }
  }

  protected void composeFamilyMemberHistoryParticipantComponent(Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "FamilyMemberHistoryParticipantComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "FamilyMemberHistoryParticipantComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeFamilyMemberHistoryConditionComponent(Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryConditionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "condition", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "FamilyMemberHistoryConditionComponent", "code", element.getCode(), -1);
    }
    if (element.hasOutcome()) {
      composeCodeableConcept(t, "FamilyMemberHistoryConditionComponent", "outcome", element.getOutcome(), -1);
    }
    if (element.hasContributedToDeathElement()) {
      composeBoolean(t, "FamilyMemberHistoryConditionComponent", "contributedToDeath", element.getContributedToDeathElement(), -1);
    }
    if (element.hasOnset()) {
      composeType(t, "FamilyMemberHistoryConditionComponent", "onset", element.getOnset(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "FamilyMemberHistoryConditionComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeFamilyMemberHistoryProcedureComponent(Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryProcedureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "procedure", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "FamilyMemberHistoryProcedureComponent", "code", element.getCode(), -1);
    }
    if (element.hasOutcome()) {
      composeCodeableConcept(t, "FamilyMemberHistoryProcedureComponent", "outcome", element.getOutcome(), -1);
    }
    if (element.hasContributedToDeathElement()) {
      composeBoolean(t, "FamilyMemberHistoryProcedureComponent", "contributedToDeath", element.getContributedToDeathElement(), -1);
    }
    if (element.hasPerformed()) {
      composeType(t, "FamilyMemberHistoryProcedureComponent", "performed", element.getPerformed(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "FamilyMemberHistoryProcedureComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeFlag(Complex parent, String parentType, String name, Flag element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Flag", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Flag", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Flag", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Flag", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Flag", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Flag", "subject", element.getSubject(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Flag", "period", element.getPeriod(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Flag", "encounter", element.getEncounter(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "Flag", "author", element.getAuthor(), -1);
    }
  }

  protected void composeFormularyItem(Complex parent, String parentType, String name, FormularyItem element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "FormularyItem", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "FormularyItem", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "FormularyItem", "code", element.getCode(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "FormularyItem", "status", element.getStatusElement(), -1);
    }
  }

  protected void composeGenomicStudy(Complex parent, String parentType, String name, GenomicStudy element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "GenomicStudy", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "GenomicStudy", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "GenomicStudy", "status", element.getStatus(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "GenomicStudy", "type", element.getType().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "GenomicStudy", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "GenomicStudy", "encounter", element.getEncounter(), -1);
    }
    if (element.hasStartDateElement()) {
      composeDateTime(t, "GenomicStudy", "startDate", element.getStartDateElement(), -1);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "GenomicStudy", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasReferrer()) {
      composeReference(t, "GenomicStudy", "referrer", element.getReferrer(), -1);
    }
    for (int i = 0; i < element.getInterpreter().size(); i++) {
      composeReference(t, "GenomicStudy", "interpreter", element.getInterpreter().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "GenomicStudy", "reason", element.getReason().get(i), i);
    }
    if (element.hasInstantiatesCanonicalElement()) {
      composeCanonical(t, "GenomicStudy", "instantiatesCanonical", element.getInstantiatesCanonicalElement(), -1);
    }
    if (element.hasInstantiatesUriElement()) {
      composeUri(t, "GenomicStudy", "instantiatesUri", element.getInstantiatesUriElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "GenomicStudy", "note", element.getNote().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "GenomicStudy", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getAnalysis().size(); i++) {
      composeGenomicStudyAnalysisComponent(t, "GenomicStudy", "analysis", element.getAnalysis().get(i), i);
    }
  }

  protected void composeGenomicStudyAnalysisComponent(Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "analysis", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "GenomicStudyAnalysisComponent", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getMethodType().size(); i++) {
      composeCodeableConcept(t, "GenomicStudyAnalysisComponent", "methodType", element.getMethodType().get(i), i);
    }
    for (int i = 0; i < element.getChangeType().size(); i++) {
      composeCodeableConcept(t, "GenomicStudyAnalysisComponent", "changeType", element.getChangeType().get(i), i);
    }
    if (element.hasGenomeBuild()) {
      composeCodeableConcept(t, "GenomicStudyAnalysisComponent", "genomeBuild", element.getGenomeBuild(), -1);
    }
    if (element.hasInstantiatesCanonicalElement()) {
      composeCanonical(t, "GenomicStudyAnalysisComponent", "instantiatesCanonical", element.getInstantiatesCanonicalElement(), -1);
    }
    if (element.hasInstantiatesUriElement()) {
      composeUri(t, "GenomicStudyAnalysisComponent", "instantiatesUri", element.getInstantiatesUriElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "GenomicStudyAnalysisComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "GenomicStudyAnalysisComponent", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getSpecimen().size(); i++) {
      composeReference(t, "GenomicStudyAnalysisComponent", "specimen", element.getSpecimen().get(i), i);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "GenomicStudyAnalysisComponent", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "GenomicStudyAnalysisComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasProtocolPerformed()) {
      composeReference(t, "GenomicStudyAnalysisComponent", "protocolPerformed", element.getProtocolPerformed(), -1);
    }
    for (int i = 0; i < element.getRegionsStudied().size(); i++) {
      composeReference(t, "GenomicStudyAnalysisComponent", "regionsStudied", element.getRegionsStudied().get(i), i);
    }
    for (int i = 0; i < element.getRegionsCalled().size(); i++) {
      composeReference(t, "GenomicStudyAnalysisComponent", "regionsCalled", element.getRegionsCalled().get(i), i);
    }
    for (int i = 0; i < element.getInput().size(); i++) {
      composeGenomicStudyAnalysisInputComponent(t, "GenomicStudyAnalysisComponent", "input", element.getInput().get(i), i);
    }
    for (int i = 0; i < element.getOutput().size(); i++) {
      composeGenomicStudyAnalysisOutputComponent(t, "GenomicStudyAnalysisComponent", "output", element.getOutput().get(i), i);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeGenomicStudyAnalysisPerformerComponent(t, "GenomicStudyAnalysisComponent", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getDevice().size(); i++) {
      composeGenomicStudyAnalysisDeviceComponent(t, "GenomicStudyAnalysisComponent", "device", element.getDevice().get(i), i);
    }
  }

  protected void composeGenomicStudyAnalysisInputComponent(Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisInputComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "input", name, element, index);
    if (element.hasFile()) {
      composeReference(t, "GenomicStudyAnalysisInputComponent", "file", element.getFile(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "GenomicStudyAnalysisInputComponent", "type", element.getType(), -1);
    }
    if (element.hasGeneratedBy()) {
      composeType(t, "GenomicStudyAnalysisInputComponent", "generatedBy", element.getGeneratedBy(), -1);
    }
  }

  protected void composeGenomicStudyAnalysisOutputComponent(Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisOutputComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "output", name, element, index);
    if (element.hasFile()) {
      composeReference(t, "GenomicStudyAnalysisOutputComponent", "file", element.getFile(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "GenomicStudyAnalysisOutputComponent", "type", element.getType(), -1);
    }
  }

  protected void composeGenomicStudyAnalysisPerformerComponent(Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasActor()) {
      composeReference(t, "GenomicStudyAnalysisPerformerComponent", "actor", element.getActor(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "GenomicStudyAnalysisPerformerComponent", "role", element.getRole(), -1);
    }
  }

  protected void composeGenomicStudyAnalysisDeviceComponent(Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisDeviceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "device", name, element, index);
    if (element.hasDevice()) {
      composeReference(t, "GenomicStudyAnalysisDeviceComponent", "device", element.getDevice(), -1);
    }
    if (element.hasFunction()) {
      composeCodeableConcept(t, "GenomicStudyAnalysisDeviceComponent", "function", element.getFunction(), -1);
    }
  }

  protected void composeGoal(Complex parent, String parentType, String name, Goal element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Goal", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Goal", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasLifecycleStatusElement()) {
      composeEnum(t, "Goal", "lifecycleStatus", element.getLifecycleStatusElement(), -1);
    }
    if (element.hasAchievementStatus()) {
      composeCodeableConcept(t, "Goal", "achievementStatus", element.getAchievementStatus(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Goal", "category", element.getCategory().get(i), i);
    }
    if (element.hasContinuousElement()) {
      composeBoolean(t, "Goal", "continuous", element.getContinuousElement(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "Goal", "priority", element.getPriority(), -1);
    }
    if (element.hasDescription()) {
      composeCodeableConcept(t, "Goal", "description", element.getDescription(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Goal", "subject", element.getSubject(), -1);
    }
    if (element.hasStart()) {
      composeType(t, "Goal", "start", element.getStart(), -1);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeGoalTargetComponent(t, "Goal", "target", element.getTarget().get(i), i);
    }
    if (element.hasStatusDateElement()) {
      composeDate(t, "Goal", "statusDate", element.getStatusDateElement(), -1);
    }
    if (element.hasStatusReasonElement()) {
      composeString(t, "Goal", "statusReason", element.getStatusReasonElement(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "Goal", "source", element.getSource(), -1);
    }
    for (int i = 0; i < element.getAddresses().size(); i++) {
      composeReference(t, "Goal", "addresses", element.getAddresses().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Goal", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getOutcome().size(); i++) {
      composeCodeableReference(t, "Goal", "outcome", element.getOutcome().get(i), i);
    }
  }

  protected void composeGoalTargetComponent(Complex parent, String parentType, String name, Goal.GoalTargetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasMeasure()) {
      composeCodeableConcept(t, "GoalTargetComponent", "measure", element.getMeasure(), -1);
    }
    if (element.hasDetail()) {
      composeType(t, "GoalTargetComponent", "detail", element.getDetail(), -1);
    }
    if (element.hasDue()) {
      composeType(t, "GoalTargetComponent", "due", element.getDue(), -1);
    }
  }

  protected void composeGraphDefinition(Complex parent, String parentType, String name, GraphDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "GraphDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "GraphDefinition", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "GraphDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasVersionAlgorithm()) {
      composeType(t, "GraphDefinition", "versionAlgorithm", element.getVersionAlgorithm(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "GraphDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "GraphDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "GraphDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "GraphDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "GraphDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "GraphDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "GraphDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "GraphDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "GraphDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "GraphDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasStartElement()) {
      composeId(t, "GraphDefinition", "start", element.getStartElement(), -1);
    }
    for (int i = 0; i < element.getNode().size(); i++) {
      composeGraphDefinitionNodeComponent(t, "GraphDefinition", "node", element.getNode().get(i), i);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composeGraphDefinitionLinkComponent(t, "GraphDefinition", "link", element.getLink().get(i), i);
    }
  }

  protected void composeGraphDefinitionNodeComponent(Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionNodeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "node", name, element, index);
    if (element.hasNodeIdElement()) {
      composeId(t, "GraphDefinitionNodeComponent", "nodeId", element.getNodeIdElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "GraphDefinitionNodeComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "GraphDefinitionNodeComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "GraphDefinitionNodeComponent", "profile", element.getProfileElement(), -1);
    }
  }

  protected void composeGraphDefinitionLinkComponent(Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasMinElement()) {
      composeInteger(t, "GraphDefinitionLinkComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "max", element.getMaxElement(), -1);
    }
    if (element.hasSourceIdElement()) {
      composeId(t, "GraphDefinitionLinkComponent", "sourceId", element.getSourceIdElement(), -1);
    }
    if (element.hasPathElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasSliceNameElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "sliceName", element.getSliceNameElement(), -1);
    }
    if (element.hasTargetIdElement()) {
      composeId(t, "GraphDefinitionLinkComponent", "targetId", element.getTargetIdElement(), -1);
    }
    if (element.hasParamsElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "params", element.getParamsElement(), -1);
    }
    for (int i = 0; i < element.getCompartment().size(); i++) {
      composeGraphDefinitionLinkCompartmentComponent(t, "GraphDefinitionLinkComponent", "compartment", element.getCompartment().get(i), i);
    }
  }

  protected void composeGraphDefinitionLinkCompartmentComponent(Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkCompartmentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "compartment", name, element, index);
    if (element.hasUseElement()) {
      composeEnum(t, "GraphDefinitionLinkCompartmentComponent", "use", element.getUseElement(), -1);
    }
    if (element.hasRuleElement()) {
      composeEnum(t, "GraphDefinitionLinkCompartmentComponent", "rule", element.getRuleElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeEnum(t, "GraphDefinitionLinkCompartmentComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "GraphDefinitionLinkCompartmentComponent", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "GraphDefinitionLinkCompartmentComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeGroup(Complex parent, String parentType, String name, Group element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Group", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Group", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Group", "active", element.getActiveElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "Group", "type", element.getTypeElement(), -1);
    }
    if (element.hasMembershipElement()) {
      composeEnum(t, "Group", "membership", element.getMembershipElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Group", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Group", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasQuantityElement()) {
      composeUnsignedInt(t, "Group", "quantity", element.getQuantityElement(), -1);
    }
    if (element.hasManagingEntity()) {
      composeReference(t, "Group", "managingEntity", element.getManagingEntity(), -1);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeGroupCharacteristicComponent(t, "Group", "characteristic", element.getCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getMember().size(); i++) {
      composeGroupMemberComponent(t, "Group", "member", element.getMember().get(i), i);
    }
  }

  protected void composeGroupCharacteristicComponent(Complex parent, String parentType, String name, Group.GroupCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "GroupCharacteristicComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "GroupCharacteristicComponent", "value", element.getValue(), -1);
    }
    if (element.hasExcludeElement()) {
      composeBoolean(t, "GroupCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "GroupCharacteristicComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeGroupMemberComponent(Complex parent, String parentType, String name, Group.GroupMemberComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "member", name, element, index);
    if (element.hasEntity()) {
      composeReference(t, "GroupMemberComponent", "entity", element.getEntity(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "GroupMemberComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasInactiveElement()) {
      composeBoolean(t, "GroupMemberComponent", "inactive", element.getInactiveElement(), -1);
    }
  }

  protected void composeGuidanceResponse(Complex parent, String parentType, String name, GuidanceResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "GuidanceResponse", name, element, index);
    if (element.hasRequestIdentifier()) {
      composeIdentifier(t, "GuidanceResponse", "requestIdentifier", element.getRequestIdentifier(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "GuidanceResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasModule()) {
      composeType(t, "GuidanceResponse", "module", element.getModule(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "GuidanceResponse", "status", element.getStatusElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "GuidanceResponse", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "GuidanceResponse", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrenceDateTimeElement()) {
      composeDateTime(t, "GuidanceResponse", "occurrenceDateTime", element.getOccurrenceDateTimeElement(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "GuidanceResponse", "performer", element.getPerformer(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "GuidanceResponse", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "GuidanceResponse", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getEvaluationMessage().size(); i++) {
      composeReference(t, "GuidanceResponse", "evaluationMessage", element.getEvaluationMessage().get(i), i);
    }
    if (element.hasOutputParameters()) {
      composeReference(t, "GuidanceResponse", "outputParameters", element.getOutputParameters(), -1);
    }
    if (element.hasResult()) {
      composeReference(t, "GuidanceResponse", "result", element.getResult(), -1);
    }
    for (int i = 0; i < element.getDataRequirement().size(); i++) {
      composeDataRequirement(t, "GuidanceResponse", "dataRequirement", element.getDataRequirement().get(i), i);
    }
  }

  protected void composeHealthcareService(Complex parent, String parentType, String name, HealthcareService element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "HealthcareService", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "HealthcareService", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "HealthcareService", "active", element.getActiveElement(), -1);
    }
    if (element.hasProvidedBy()) {
      composeReference(t, "HealthcareService", "providedBy", element.getProvidedBy(), -1);
    }
    for (int i = 0; i < element.getOfferedIn().size(); i++) {
      composeReference(t, "HealthcareService", "offeredIn", element.getOfferedIn().get(i), i);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "specialty", element.getSpecialty().get(i), i);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeReference(t, "HealthcareService", "location", element.getLocation().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "HealthcareService", "name", element.getNameElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "HealthcareService", "comment", element.getCommentElement(), -1);
    }
    if (element.hasExtraDetailsElement()) {
      composeMarkdown(t, "HealthcareService", "extraDetails", element.getExtraDetailsElement(), -1);
    }
    if (element.hasPhoto()) {
      composeAttachment(t, "HealthcareService", "photo", element.getPhoto(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeExtendedContactDetail(t, "HealthcareService", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getCoverageArea().size(); i++) {
      composeReference(t, "HealthcareService", "coverageArea", element.getCoverageArea().get(i), i);
    }
    for (int i = 0; i < element.getServiceProvisionCode().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "serviceProvisionCode", element.getServiceProvisionCode().get(i), i);
    }
    for (int i = 0; i < element.getEligibility().size(); i++) {
      composeHealthcareServiceEligibilityComponent(t, "HealthcareService", "eligibility", element.getEligibility().get(i), i);
    }
    for (int i = 0; i < element.getProgram().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "program", element.getProgram().get(i), i);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "characteristic", element.getCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "communication", element.getCommunication().get(i), i);
    }
    for (int i = 0; i < element.getReferralMethod().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "referralMethod", element.getReferralMethod().get(i), i);
    }
    if (element.hasAppointmentRequiredElement()) {
      composeBoolean(t, "HealthcareService", "appointmentRequired", element.getAppointmentRequiredElement(), -1);
    }
    for (int i = 0; i < element.getAvailability().size(); i++) {
      composeAvailability(t, "HealthcareService", "availability", element.getAvailability().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "HealthcareService", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composeHealthcareServiceEligibilityComponent(Complex parent, String parentType, String name, HealthcareService.HealthcareServiceEligibilityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "eligibility", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "HealthcareServiceEligibilityComponent", "code", element.getCode(), -1);
    }
    if (element.hasCommentElement()) {
      composeMarkdown(t, "HealthcareServiceEligibilityComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeImagingSelection(Complex parent, String parentType, String name, ImagingSelection element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ImagingSelection", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ImagingSelection", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ImagingSelection", "status", element.getStatusElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "ImagingSelection", "subject", element.getSubject(), -1);
    }
    if (element.hasIssuedElement()) {
      composeInstant(t, "ImagingSelection", "issued", element.getIssuedElement(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeImagingSelectionPerformerComponent(t, "ImagingSelection", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "ImagingSelection", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "ImagingSelection", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ImagingSelection", "code", element.getCode(), -1);
    }
    if (element.hasStudyUidElement()) {
      composeId(t, "ImagingSelection", "studyUid", element.getStudyUidElement(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeReference(t, "ImagingSelection", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "ImagingSelection", "endpoint", element.getEndpoint().get(i), i);
    }
    if (element.hasSeriesUidElement()) {
      composeId(t, "ImagingSelection", "seriesUid", element.getSeriesUidElement(), -1);
    }
    if (element.hasSeriesNumberElement()) {
      composeUnsignedInt(t, "ImagingSelection", "seriesNumber", element.getSeriesNumberElement(), -1);
    }
    if (element.hasFrameOfReferenceUidElement()) {
      composeId(t, "ImagingSelection", "frameOfReferenceUid", element.getFrameOfReferenceUidElement(), -1);
    }
    if (element.hasBodySite()) {
      composeCodeableReference(t, "ImagingSelection", "bodySite", element.getBodySite(), -1);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeReference(t, "ImagingSelection", "focus", element.getFocus().get(i), i);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeImagingSelectionInstanceComponent(t, "ImagingSelection", "instance", element.getInstance().get(i), i);
    }
    for (int i = 0; i < element.getImageRegion().size(); i++) {
      composeImagingSelectionImageRegion3DComponent(t, "ImagingSelection", "imageRegion", element.getImageRegion().get(i), i);
    }
  }

  protected void composeImagingSelectionPerformerComponent(Complex parent, String parentType, String name, ImagingSelection.ImagingSelectionPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ImagingSelectionPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ImagingSelectionPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeImagingSelectionInstanceComponent(Complex parent, String parentType, String name, ImagingSelection.ImagingSelectionInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "instance", name, element, index);
    if (element.hasUidElement()) {
      composeId(t, "ImagingSelectionInstanceComponent", "uid", element.getUidElement(), -1);
    }
    if (element.hasNumberElement()) {
      composeUnsignedInt(t, "ImagingSelectionInstanceComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasSopClass()) {
      composeCoding(t, "ImagingSelectionInstanceComponent", "sopClass", element.getSopClass(), -1);
    }
    for (int i = 0; i < element.getSubset().size(); i++) {
      composeString(t, "ImagingSelectionInstanceComponent", "subset", element.getSubset().get(i), i);
    }
    for (int i = 0; i < element.getImageRegion().size(); i++) {
      composeImagingSelectionImageRegion2DComponent(t, "ImagingSelectionInstanceComponent", "imageRegion", element.getImageRegion().get(i), i);
    }
  }

  protected void composeImagingSelectionImageRegion2DComponent(Complex parent, String parentType, String name, ImagingSelection.ImageRegion2DComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "imageRegion", name, element, index);
    if (element.hasRegionTypeElement()) {
      composeEnum(t, "ImageRegion2DComponent", "regionType", element.getRegionTypeElement(), -1);
    }
    for (int i = 0; i < element.getCoordinate().size(); i++) {
      composeDecimal(t, "ImageRegion2DComponent", "coordinate", element.getCoordinate().get(i), i);
    }
  }

  protected void composeImagingSelectionImageRegion3DComponent(Complex parent, String parentType, String name, ImagingSelection.ImageRegion3DComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "imageRegion", name, element, index);
    if (element.hasRegionTypeElement()) {
      composeEnum(t, "ImageRegion3DComponent", "regionType", element.getRegionTypeElement(), -1);
    }
    for (int i = 0; i < element.getCoordinate().size(); i++) {
      composeDecimal(t, "ImageRegion3DComponent", "coordinate", element.getCoordinate().get(i), i);
    }
  }

  protected void composeImagingStudy(Complex parent, String parentType, String name, ImagingStudy element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ImagingStudy", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ImagingStudy", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getModality().size(); i++) {
      composeCodeableConcept(t, "ImagingStudy", "modality", element.getModality().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "ImagingStudy", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "ImagingStudy", "encounter", element.getEncounter(), -1);
    }
    if (element.hasStartedElement()) {
      composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "ImagingStudy", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasReferrer()) {
      composeReference(t, "ImagingStudy", "referrer", element.getReferrer(), -1);
    }
    for (int i = 0; i < element.getInterpreter().size(); i++) {
      composeReference(t, "ImagingStudy", "interpreter", element.getInterpreter().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "ImagingStudy", "endpoint", element.getEndpoint().get(i), i);
    }
    if (element.hasNumberOfSeriesElement()) {
      composeUnsignedInt(t, "ImagingStudy", "numberOfSeries", element.getNumberOfSeriesElement(), -1);
    }
    if (element.hasNumberOfInstancesElement()) {
      composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
    }
    for (int i = 0; i < element.getProcedure().size(); i++) {
      composeCodeableReference(t, "ImagingStudy", "procedure", element.getProcedure().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "ImagingStudy", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "ImagingStudy", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ImagingStudy", "note", element.getNote().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getSeries().size(); i++) {
      composeImagingStudySeriesComponent(t, "ImagingStudy", "series", element.getSeries().get(i), i);
    }
  }

  protected void composeImagingStudySeriesComponent(Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "series", name, element, index);
    if (element.hasUidElement()) {
      composeId(t, "ImagingStudySeriesComponent", "uid", element.getUidElement(), -1);
    }
    if (element.hasNumberElement()) {
      composeUnsignedInt(t, "ImagingStudySeriesComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasModality()) {
      composeCodeableConcept(t, "ImagingStudySeriesComponent", "modality", element.getModality(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImagingStudySeriesComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasNumberOfInstancesElement()) {
      composeUnsignedInt(t, "ImagingStudySeriesComponent", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "ImagingStudySeriesComponent", "endpoint", element.getEndpoint().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCodeableReference(t, "ImagingStudySeriesComponent", "bodySite", element.getBodySite(), -1);
    }
    if (element.hasLaterality()) {
      composeCodeableConcept(t, "ImagingStudySeriesComponent", "laterality", element.getLaterality(), -1);
    }
    for (int i = 0; i < element.getSpecimen().size(); i++) {
      composeReference(t, "ImagingStudySeriesComponent", "specimen", element.getSpecimen().get(i), i);
    }
    if (element.hasStartedElement()) {
      composeDateTime(t, "ImagingStudySeriesComponent", "started", element.getStartedElement(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeImagingStudySeriesPerformerComponent(t, "ImagingStudySeriesComponent", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeImagingStudySeriesInstanceComponent(t, "ImagingStudySeriesComponent", "instance", element.getInstance().get(i), i);
    }
  }

  protected void composeImagingStudySeriesPerformerComponent(Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ImagingStudySeriesPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ImagingStudySeriesPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeImagingStudySeriesInstanceComponent(Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "instance", name, element, index);
    if (element.hasUidElement()) {
      composeId(t, "ImagingStudySeriesInstanceComponent", "uid", element.getUidElement(), -1);
    }
    if (element.hasSopClass()) {
      composeCoding(t, "ImagingStudySeriesInstanceComponent", "sopClass", element.getSopClass(), -1);
    }
    if (element.hasNumberElement()) {
      composeUnsignedInt(t, "ImagingStudySeriesInstanceComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ImagingStudySeriesInstanceComponent", "title", element.getTitleElement(), -1);
    }
  }

  protected void composeImmunization(Complex parent, String parentType, String name, Immunization element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Immunization", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Immunization", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Immunization", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Immunization", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "Immunization", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasVaccineCode()) {
      composeCodeableConcept(t, "Immunization", "vaccineCode", element.getVaccineCode(), -1);
    }
    if (element.hasAdministeredProduct()) {
      composeCodeableReference(t, "Immunization", "administeredProduct", element.getAdministeredProduct(), -1);
    }
    if (element.hasManufacturer()) {
      composeCodeableReference(t, "Immunization", "manufacturer", element.getManufacturer(), -1);
    }
    if (element.hasLotNumberElement()) {
      composeString(t, "Immunization", "lotNumber", element.getLotNumberElement(), -1);
    }
    if (element.hasExpirationDateElement()) {
      composeDate(t, "Immunization", "expirationDate", element.getExpirationDateElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "Immunization", "patient", element.getPatient(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Immunization", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "Immunization", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    if (element.hasOccurrence()) {
      composeType(t, "Immunization", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasPrimarySourceElement()) {
      composeBoolean(t, "Immunization", "primarySource", element.getPrimarySourceElement(), -1);
    }
    if (element.hasInformationSource()) {
      composeCodeableReference(t, "Immunization", "informationSource", element.getInformationSource(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "Immunization", "location", element.getLocation(), -1);
    }
    if (element.hasSite()) {
      composeCodeableConcept(t, "Immunization", "site", element.getSite(), -1);
    }
    if (element.hasRoute()) {
      composeCodeableConcept(t, "Immunization", "route", element.getRoute(), -1);
    }
    if (element.hasDoseQuantity()) {
      composeQuantity(t, "Immunization", "doseQuantity", element.getDoseQuantity(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeImmunizationPerformerComponent(t, "Immunization", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Immunization", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "Immunization", "reason", element.getReason().get(i), i);
    }
    if (element.hasIsSubpotentElement()) {
      composeBoolean(t, "Immunization", "isSubpotent", element.getIsSubpotentElement(), -1);
    }
    for (int i = 0; i < element.getSubpotentReason().size(); i++) {
      composeCodeableConcept(t, "Immunization", "subpotentReason", element.getSubpotentReason().get(i), i);
    }
    for (int i = 0; i < element.getProgramEligibility().size(); i++) {
      composeImmunizationProgramEligibilityComponent(t, "Immunization", "programEligibility", element.getProgramEligibility().get(i), i);
    }
    if (element.hasFundingSource()) {
      composeCodeableConcept(t, "Immunization", "fundingSource", element.getFundingSource(), -1);
    }
    for (int i = 0; i < element.getReaction().size(); i++) {
      composeImmunizationReactionComponent(t, "Immunization", "reaction", element.getReaction().get(i), i);
    }
    for (int i = 0; i < element.getProtocolApplied().size(); i++) {
      composeImmunizationProtocolAppliedComponent(t, "Immunization", "protocolApplied", element.getProtocolApplied().get(i), i);
    }
  }

  protected void composeImmunizationPerformerComponent(Complex parent, String parentType, String name, Immunization.ImmunizationPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ImmunizationPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ImmunizationPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeImmunizationProgramEligibilityComponent(Complex parent, String parentType, String name, Immunization.ImmunizationProgramEligibilityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "programEligibility", name, element, index);
    if (element.hasProgram()) {
      composeCodeableConcept(t, "ImmunizationProgramEligibilityComponent", "program", element.getProgram(), -1);
    }
    if (element.hasProgramStatus()) {
      composeCodeableConcept(t, "ImmunizationProgramEligibilityComponent", "programStatus", element.getProgramStatus(), -1);
    }
  }

  protected void composeImmunizationReactionComponent(Complex parent, String parentType, String name, Immunization.ImmunizationReactionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "reaction", name, element, index);
    if (element.hasDateElement()) {
      composeDateTime(t, "ImmunizationReactionComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasManifestation()) {
      composeCodeableReference(t, "ImmunizationReactionComponent", "manifestation", element.getManifestation(), -1);
    }
    if (element.hasReportedElement()) {
      composeBoolean(t, "ImmunizationReactionComponent", "reported", element.getReportedElement(), -1);
    }
  }

  protected void composeImmunizationProtocolAppliedComponent(Complex parent, String parentType, String name, Immunization.ImmunizationProtocolAppliedComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "protocolApplied", name, element, index);
    if (element.hasSeriesElement()) {
      composeString(t, "ImmunizationProtocolAppliedComponent", "series", element.getSeriesElement(), -1);
    }
    if (element.hasAuthority()) {
      composeReference(t, "ImmunizationProtocolAppliedComponent", "authority", element.getAuthority(), -1);
    }
    for (int i = 0; i < element.getTargetDisease().size(); i++) {
      composeCodeableConcept(t, "ImmunizationProtocolAppliedComponent", "targetDisease", element.getTargetDisease().get(i), i);
    }
    if (element.hasDoseNumberElement()) {
      composeString(t, "ImmunizationProtocolAppliedComponent", "doseNumber", element.getDoseNumberElement(), -1);
    }
    if (element.hasSeriesDosesElement()) {
      composeString(t, "ImmunizationProtocolAppliedComponent", "seriesDoses", element.getSeriesDosesElement(), -1);
    }
  }

  protected void composeImmunizationEvaluation(Complex parent, String parentType, String name, ImmunizationEvaluation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ImmunizationEvaluation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ImmunizationEvaluation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ImmunizationEvaluation", "status", element.getStatusElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "ImmunizationEvaluation", "patient", element.getPatient(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ImmunizationEvaluation", "date", element.getDateElement(), -1);
    }
    if (element.hasAuthority()) {
      composeReference(t, "ImmunizationEvaluation", "authority", element.getAuthority(), -1);
    }
    if (element.hasTargetDisease()) {
      composeCodeableConcept(t, "ImmunizationEvaluation", "targetDisease", element.getTargetDisease(), -1);
    }
    if (element.hasImmunizationEvent()) {
      composeReference(t, "ImmunizationEvaluation", "immunizationEvent", element.getImmunizationEvent(), -1);
    }
    if (element.hasDoseStatus()) {
      composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatus", element.getDoseStatus(), -1);
    }
    for (int i = 0; i < element.getDoseStatusReason().size(); i++) {
      composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatusReason", element.getDoseStatusReason().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImmunizationEvaluation", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasSeriesElement()) {
      composeString(t, "ImmunizationEvaluation", "series", element.getSeriesElement(), -1);
    }
    if (element.hasDoseNumberElement()) {
      composeString(t, "ImmunizationEvaluation", "doseNumber", element.getDoseNumberElement(), -1);
    }
    if (element.hasSeriesDosesElement()) {
      composeString(t, "ImmunizationEvaluation", "seriesDoses", element.getSeriesDosesElement(), -1);
    }
  }

  protected void composeImmunizationRecommendation(Complex parent, String parentType, String name, ImmunizationRecommendation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ImmunizationRecommendation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ImmunizationRecommendation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "ImmunizationRecommendation", "patient", element.getPatient(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ImmunizationRecommendation", "date", element.getDateElement(), -1);
    }
    if (element.hasAuthority()) {
      composeReference(t, "ImmunizationRecommendation", "authority", element.getAuthority(), -1);
    }
    for (int i = 0; i < element.getRecommendation().size(); i++) {
      composeImmunizationRecommendationRecommendationComponent(t, "ImmunizationRecommendation", "recommendation", element.getRecommendation().get(i), i);
    }
  }

  protected void composeImmunizationRecommendationRecommendationComponent(Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "recommendation", name, element, index);
    for (int i = 0; i < element.getVaccineCode().size(); i++) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "vaccineCode", element.getVaccineCode().get(i), i);
    }
    for (int i = 0; i < element.getTargetDisease().size(); i++) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "targetDisease", element.getTargetDisease().get(i), i);
    }
    for (int i = 0; i < element.getContraindicatedVaccineCode().size(); i++) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "contraindicatedVaccineCode", element.getContraindicatedVaccineCode().get(i), i);
    }
    if (element.hasForecastStatus()) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "forecastStatus", element.getForecastStatus(), -1);
    }
    for (int i = 0; i < element.getForecastReason().size(); i++) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "forecastReason", element.getForecastReason().get(i), i);
    }
    for (int i = 0; i < element.getDateCriterion().size(); i++) {
      composeImmunizationRecommendationRecommendationDateCriterionComponent(t, "ImmunizationRecommendationRecommendationComponent", "dateCriterion", element.getDateCriterion().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImmunizationRecommendationRecommendationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasSeriesElement()) {
      composeString(t, "ImmunizationRecommendationRecommendationComponent", "series", element.getSeriesElement(), -1);
    }
    if (element.hasDoseNumberElement()) {
      composeString(t, "ImmunizationRecommendationRecommendationComponent", "doseNumber", element.getDoseNumberElement(), -1);
    }
    if (element.hasSeriesDosesElement()) {
      composeString(t, "ImmunizationRecommendationRecommendationComponent", "seriesDoses", element.getSeriesDosesElement(), -1);
    }
    for (int i = 0; i < element.getSupportingImmunization().size(); i++) {
      composeReference(t, "ImmunizationRecommendationRecommendationComponent", "supportingImmunization", element.getSupportingImmunization().get(i), i);
    }
    for (int i = 0; i < element.getSupportingPatientInformation().size(); i++) {
      composeReference(t, "ImmunizationRecommendationRecommendationComponent", "supportingPatientInformation", element.getSupportingPatientInformation().get(i), i);
    }
  }

  protected void composeImmunizationRecommendationRecommendationDateCriterionComponent(Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dateCriterion", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationDateCriterionComponent", "code", element.getCode(), -1);
    }
    if (element.hasValueElement()) {
      composeDateTime(t, "ImmunizationRecommendationRecommendationDateCriterionComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeImplementationGuide(Complex parent, String parentType, String name, ImplementationGuide element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "ImplementationGuide", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ImplementationGuide", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
    }
    if (element.hasVersionAlgorithm()) {
      composeType(t, "ImplementationGuide", "versionAlgorithm", element.getVersionAlgorithm(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ImplementationGuide", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ImplementationGuide", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ImplementationGuide", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ImplementationGuide", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ImplementationGuide", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ImplementationGuide", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ImplementationGuide", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ImplementationGuide", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCopyrightLabelElement()) {
      composeString(t, "ImplementationGuide", "copyrightLabel", element.getCopyrightLabelElement(), -1);
    }
    if (element.hasPackageIdElement()) {
      composeId(t, "ImplementationGuide", "packageId", element.getPackageIdElement(), -1);
    }
    if (element.hasLicenseElement()) {
      composeEnum(t, "ImplementationGuide", "license", element.getLicenseElement(), -1);
    }
    for (int i = 0; i < element.getFhirVersion().size(); i++) {
      composeEnum(t, "ImplementationGuide", "fhirVersion", element.getFhirVersion().get(i), i);
    }
    for (int i = 0; i < element.getDependsOn().size(); i++) {
      composeImplementationGuideDependsOnComponent(t, "ImplementationGuide", "dependsOn", element.getDependsOn().get(i), i);
    }
    for (int i = 0; i < element.getGlobal().size(); i++) {
      composeImplementationGuideGlobalComponent(t, "ImplementationGuide", "global", element.getGlobal().get(i), i);
    }
    if (element.hasDefinition()) {
      composeImplementationGuideDefinitionComponent(t, "ImplementationGuide", "definition", element.getDefinition(), -1);
    }
    if (element.hasManifest()) {
      composeImplementationGuideManifestComponent(t, "ImplementationGuide", "manifest", element.getManifest(), -1);
    }
  }

  protected void composeImplementationGuideDependsOnComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDependsOnComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dependsOn", name, element, index);
    if (element.hasUriElement()) {
      composeCanonical(t, "ImplementationGuideDependsOnComponent", "uri", element.getUriElement(), -1);
    }
    if (element.hasPackageIdElement()) {
      composeId(t, "ImplementationGuideDependsOnComponent", "packageId", element.getPackageIdElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ImplementationGuideDependsOnComponent", "version", element.getVersionElement(), -1);
    }
    if (element.hasReasonElement()) {
      composeMarkdown(t, "ImplementationGuideDependsOnComponent", "reason", element.getReasonElement(), -1);
    }
  }

  protected void composeImplementationGuideGlobalComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideGlobalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "global", name, element, index);
    if (element.hasTypeElement()) {
      composeCode(t, "ImplementationGuideGlobalComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "ImplementationGuideGlobalComponent", "profile", element.getProfileElement(), -1);
    }
  }

  protected void composeImplementationGuideDefinitionComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "definition", name, element, index);
    for (int i = 0; i < element.getGrouping().size(); i++) {
      composeImplementationGuideDefinitionGroupingComponent(t, "ImplementationGuideDefinitionComponent", "grouping", element.getGrouping().get(i), i);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeImplementationGuideDefinitionResourceComponent(t, "ImplementationGuideDefinitionComponent", "resource", element.getResource().get(i), i);
    }
    if (element.hasPage()) {
      composeImplementationGuideDefinitionPageComponent(t, "ImplementationGuideDefinitionComponent", "page", element.getPage(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeImplementationGuideDefinitionParameterComponent(t, "ImplementationGuideDefinitionComponent", "parameter", element.getParameter().get(i), i);
    }
    for (int i = 0; i < element.getTemplate().size(); i++) {
      composeImplementationGuideDefinitionTemplateComponent(t, "ImplementationGuideDefinitionComponent", "template", element.getTemplate().get(i), i);
    }
  }

  protected void composeImplementationGuideDefinitionGroupingComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "grouping", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ImplementationGuideDefinitionGroupingComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ImplementationGuideDefinitionGroupingComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeImplementationGuideDefinitionResourceComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasReference()) {
      composeReference(t, "ImplementationGuideDefinitionResourceComponent", "reference", element.getReference(), -1);
    }
    for (int i = 0; i < element.getFhirVersion().size(); i++) {
      composeEnum(t, "ImplementationGuideDefinitionResourceComponent", "fhirVersion", element.getFhirVersion().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "ImplementationGuideDefinitionResourceComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ImplementationGuideDefinitionResourceComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasIsExampleElement()) {
      composeBoolean(t, "ImplementationGuideDefinitionResourceComponent", "isExample", element.getIsExampleElement(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeCanonical(t, "ImplementationGuideDefinitionResourceComponent", "profile", element.getProfile().get(i), i);
    }
    if (element.hasGroupingIdElement()) {
      composeId(t, "ImplementationGuideDefinitionResourceComponent", "groupingId", element.getGroupingIdElement(), -1);
    }
  }

  protected void composeImplementationGuideDefinitionPageComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionPageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "page", name, element, index);
    if (element.hasSource()) {
      composeType(t, "ImplementationGuideDefinitionPageComponent", "source", element.getSource(), -1);
    }
    if (element.hasNameElement()) {
      composeUrl(t, "ImplementationGuideDefinitionPageComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ImplementationGuideDefinitionPageComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasGenerationElement()) {
      composeEnum(t, "ImplementationGuideDefinitionPageComponent", "generation", element.getGenerationElement(), -1);
    }
    for (int i = 0; i < element.getPage().size(); i++) {
      composeImplementationGuideDefinitionPageComponent(t, "ImplementationGuideDefinitionPageComponent", "page", element.getPage().get(i), i);
    }
  }

  protected void composeImplementationGuideDefinitionParameterComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasCode()) {
      composeCoding(t, "ImplementationGuideDefinitionParameterComponent", "code", element.getCode(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "ImplementationGuideDefinitionParameterComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeImplementationGuideDefinitionTemplateComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "template", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "ImplementationGuideDefinitionTemplateComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasSourceElement()) {
      composeString(t, "ImplementationGuideDefinitionTemplateComponent", "source", element.getSourceElement(), -1);
    }
    if (element.hasScopeElement()) {
      composeString(t, "ImplementationGuideDefinitionTemplateComponent", "scope", element.getScopeElement(), -1);
    }
  }

  protected void composeImplementationGuideManifestComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideManifestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "manifest", name, element, index);
    if (element.hasRenderingElement()) {
      composeUrl(t, "ImplementationGuideManifestComponent", "rendering", element.getRenderingElement(), -1);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeImplementationGuideManifestResourceComponent(t, "ImplementationGuideManifestComponent", "resource", element.getResource().get(i), i);
    }
    for (int i = 0; i < element.getPage().size(); i++) {
      composeImplementationGuideManifestPageComponent(t, "ImplementationGuideManifestComponent", "page", element.getPage().get(i), i);
    }
    for (int i = 0; i < element.getImage().size(); i++) {
      composeString(t, "ImplementationGuideManifestComponent", "image", element.getImage().get(i), i);
    }
    for (int i = 0; i < element.getOther().size(); i++) {
      composeString(t, "ImplementationGuideManifestComponent", "other", element.getOther().get(i), i);
    }
  }

  protected void composeImplementationGuideManifestResourceComponent(Complex parent, String parentType, String name, ImplementationGuide.ManifestResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasReference()) {
      composeReference(t, "ManifestResourceComponent", "reference", element.getReference(), -1);
    }
    if (element.hasIsExampleElement()) {
      composeBoolean(t, "ManifestResourceComponent", "isExample", element.getIsExampleElement(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeCanonical(t, "ManifestResourceComponent", "profile", element.getProfile().get(i), i);
    }
    if (element.hasRelativePathElement()) {
      composeUrl(t, "ManifestResourceComponent", "relativePath", element.getRelativePathElement(), -1);
    }
  }

  protected void composeImplementationGuideManifestPageComponent(Complex parent, String parentType, String name, ImplementationGuide.ManifestPageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "page", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ManifestPageComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ManifestPageComponent", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getAnchor().size(); i++) {
      composeString(t, "ManifestPageComponent", "anchor", element.getAnchor().get(i), i);
    }
  }

  protected void composeIngredient(Complex parent, String parentType, String name, Ingredient element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Ingredient", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "Ingredient", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Ingredient", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getFor().size(); i++) {
      composeReference(t, "Ingredient", "for", element.getFor().get(i), i);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "Ingredient", "role", element.getRole(), -1);
    }
    for (int i = 0; i < element.getFunction().size(); i++) {
      composeCodeableConcept(t, "Ingredient", "function", element.getFunction().get(i), i);
    }
    if (element.hasGroup()) {
      composeCodeableConcept(t, "Ingredient", "group", element.getGroup(), -1);
    }
    if (element.hasAllergenicIndicatorElement()) {
      composeBoolean(t, "Ingredient", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeIngredientManufacturerComponent(t, "Ingredient", "manufacturer", element.getManufacturer().get(i), i);
    }
    if (element.hasSubstance()) {
      composeIngredientSubstanceComponent(t, "Ingredient", "substance", element.getSubstance(), -1);
    }
  }

  protected void composeIngredientManufacturerComponent(Complex parent, String parentType, String name, Ingredient.IngredientManufacturerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "manufacturer", name, element, index);
    if (element.hasRoleElement()) {
      composeEnum(t, "IngredientManufacturerComponent", "role", element.getRoleElement(), -1);
    }
    if (element.hasManufacturer()) {
      composeReference(t, "IngredientManufacturerComponent", "manufacturer", element.getManufacturer(), -1);
    }
  }

  protected void composeIngredientSubstanceComponent(Complex parent, String parentType, String name, Ingredient.IngredientSubstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "substance", name, element, index);
    if (element.hasCode()) {
      composeCodeableReference(t, "IngredientSubstanceComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getStrength().size(); i++) {
      composeIngredientSubstanceStrengthComponent(t, "IngredientSubstanceComponent", "strength", element.getStrength().get(i), i);
    }
  }

  protected void composeIngredientSubstanceStrengthComponent(Complex parent, String parentType, String name, Ingredient.IngredientSubstanceStrengthComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "strength", name, element, index);
    if (element.hasPresentation()) {
      composeType(t, "IngredientSubstanceStrengthComponent", "presentation", element.getPresentation(), -1);
    }
    if (element.hasTextPresentationElement()) {
      composeString(t, "IngredientSubstanceStrengthComponent", "textPresentation", element.getTextPresentationElement(), -1);
    }
    if (element.hasConcentration()) {
      composeType(t, "IngredientSubstanceStrengthComponent", "concentration", element.getConcentration(), -1);
    }
    if (element.hasTextConcentrationElement()) {
      composeString(t, "IngredientSubstanceStrengthComponent", "textConcentration", element.getTextConcentrationElement(), -1);
    }
    if (element.hasBasis()) {
      composeCodeableConcept(t, "IngredientSubstanceStrengthComponent", "basis", element.getBasis(), -1);
    }
    if (element.hasMeasurementPointElement()) {
      composeString(t, "IngredientSubstanceStrengthComponent", "measurementPoint", element.getMeasurementPointElement(), -1);
    }
    for (int i = 0; i < element.getCountry().size(); i++) {
      composeCodeableConcept(t, "IngredientSubstanceStrengthComponent", "country", element.getCountry().get(i), i);
    }
    for (int i = 0; i < element.getReferenceStrength().size(); i++) {
      composeIngredientSubstanceStrengthReferenceStrengthComponent(t, "IngredientSubstanceStrengthComponent", "referenceStrength", element.getReferenceStrength().get(i), i);
    }
  }

  protected void composeIngredientSubstanceStrengthReferenceStrengthComponent(Complex parent, String parentType, String name, Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "referenceStrength", name, element, index);
    if (element.hasSubstance()) {
      composeCodeableReference(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "substance", element.getSubstance(), -1);
    }
    if (element.hasStrength()) {
      composeType(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "strength", element.getStrength(), -1);
    }
    if (element.hasMeasurementPointElement()) {
      composeString(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "measurementPoint", element.getMeasurementPointElement(), -1);
    }
    for (int i = 0; i < element.getCountry().size(); i++) {
      composeCodeableConcept(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "country", element.getCountry().get(i), i);
    }
  }

  protected void composeInsurancePlan(Complex parent, String parentType, String name, InsurancePlan element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "InsurancePlan", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "InsurancePlan", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "InsurancePlan", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "InsurancePlan", "type", element.getType().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "InsurancePlan", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "InsurancePlan", "alias", element.getAlias().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "InsurancePlan", "period", element.getPeriod(), -1);
    }
    if (element.hasOwnedBy()) {
      composeReference(t, "InsurancePlan", "ownedBy", element.getOwnedBy(), -1);
    }
    if (element.hasAdministeredBy()) {
      composeReference(t, "InsurancePlan", "administeredBy", element.getAdministeredBy(), -1);
    }
    for (int i = 0; i < element.getCoverageArea().size(); i++) {
      composeReference(t, "InsurancePlan", "coverageArea", element.getCoverageArea().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeExtendedContactDetail(t, "InsurancePlan", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "InsurancePlan", "endpoint", element.getEndpoint().get(i), i);
    }
    for (int i = 0; i < element.getNetwork().size(); i++) {
      composeReference(t, "InsurancePlan", "network", element.getNetwork().get(i), i);
    }
    for (int i = 0; i < element.getCoverage().size(); i++) {
      composeInsurancePlanCoverageComponent(t, "InsurancePlan", "coverage", element.getCoverage().get(i), i);
    }
    for (int i = 0; i < element.getPlan().size(); i++) {
      composeInsurancePlanPlanComponent(t, "InsurancePlan", "plan", element.getPlan().get(i), i);
    }
  }

  protected void composeInsurancePlanCoverageComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanCoverageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "coverage", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "InsurancePlanCoverageComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getNetwork().size(); i++) {
      composeReference(t, "InsurancePlanCoverageComponent", "network", element.getNetwork().get(i), i);
    }
    for (int i = 0; i < element.getBenefit().size(); i++) {
      composeInsurancePlanCoverageBenefitComponent(t, "InsurancePlanCoverageComponent", "benefit", element.getBenefit().get(i), i);
    }
  }

  protected void composeInsurancePlanCoverageBenefitComponent(Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "benefit", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CoverageBenefitComponent", "type", element.getType(), -1);
    }
    if (element.hasRequirementElement()) {
      composeString(t, "CoverageBenefitComponent", "requirement", element.getRequirementElement(), -1);
    }
    for (int i = 0; i < element.getLimit().size(); i++) {
      composeInsurancePlanCoverageBenefitLimitComponent(t, "CoverageBenefitComponent", "limit", element.getLimit().get(i), i);
    }
  }

  protected void composeInsurancePlanCoverageBenefitLimitComponent(Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitLimitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "limit", name, element, index);
    if (element.hasValue()) {
      composeQuantity(t, "CoverageBenefitLimitComponent", "value", element.getValue(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "CoverageBenefitLimitComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeInsurancePlanPlanComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "plan", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "InsurancePlanPlanComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "InsurancePlanPlanComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCoverageArea().size(); i++) {
      composeReference(t, "InsurancePlanPlanComponent", "coverageArea", element.getCoverageArea().get(i), i);
    }
    for (int i = 0; i < element.getNetwork().size(); i++) {
      composeReference(t, "InsurancePlanPlanComponent", "network", element.getNetwork().get(i), i);
    }
    for (int i = 0; i < element.getGeneralCost().size(); i++) {
      composeInsurancePlanPlanGeneralCostComponent(t, "InsurancePlanPlanComponent", "generalCost", element.getGeneralCost().get(i), i);
    }
    for (int i = 0; i < element.getSpecificCost().size(); i++) {
      composeInsurancePlanPlanSpecificCostComponent(t, "InsurancePlanPlanComponent", "specificCost", element.getSpecificCost().get(i), i);
    }
  }

  protected void composeInsurancePlanPlanGeneralCostComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanGeneralCostComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "generalCost", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "InsurancePlanPlanGeneralCostComponent", "type", element.getType(), -1);
    }
    if (element.hasGroupSizeElement()) {
      composePositiveInt(t, "InsurancePlanPlanGeneralCostComponent", "groupSize", element.getGroupSizeElement(), -1);
    }
    if (element.hasCost()) {
      composeMoney(t, "InsurancePlanPlanGeneralCostComponent", "cost", element.getCost(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "InsurancePlanPlanGeneralCostComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeInsurancePlanPlanSpecificCostComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanSpecificCostComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "specificCost", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "InsurancePlanPlanSpecificCostComponent", "category", element.getCategory(), -1);
    }
    for (int i = 0; i < element.getBenefit().size(); i++) {
      composeInsurancePlanPlanBenefitComponent(t, "InsurancePlanPlanSpecificCostComponent", "benefit", element.getBenefit().get(i), i);
    }
  }

  protected void composeInsurancePlanPlanBenefitComponent(Complex parent, String parentType, String name, InsurancePlan.PlanBenefitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "benefit", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PlanBenefitComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCost().size(); i++) {
      composeInsurancePlanPlanBenefitCostComponent(t, "PlanBenefitComponent", "cost", element.getCost().get(i), i);
    }
  }

  protected void composeInsurancePlanPlanBenefitCostComponent(Complex parent, String parentType, String name, InsurancePlan.PlanBenefitCostComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "cost", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PlanBenefitCostComponent", "type", element.getType(), -1);
    }
    if (element.hasApplicability()) {
      composeCodeableConcept(t, "PlanBenefitCostComponent", "applicability", element.getApplicability(), -1);
    }
    for (int i = 0; i < element.getQualifiers().size(); i++) {
      composeCodeableConcept(t, "PlanBenefitCostComponent", "qualifiers", element.getQualifiers().get(i), i);
    }
    if (element.hasValue()) {
      composeQuantity(t, "PlanBenefitCostComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeInventoryReport(Complex parent, String parentType, String name, InventoryReport element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "InventoryReport", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "InventoryReport", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "InventoryReport", "status", element.getStatusElement(), -1);
    }
    if (element.hasCountTypeElement()) {
      composeEnum(t, "InventoryReport", "countType", element.getCountTypeElement(), -1);
    }
    if (element.hasOperationType()) {
      composeCodeableConcept(t, "InventoryReport", "operationType", element.getOperationType(), -1);
    }
    if (element.hasOperationTypeReason()) {
      composeCodeableConcept(t, "InventoryReport", "operationTypeReason", element.getOperationTypeReason(), -1);
    }
    if (element.hasReportedDateTimeElement()) {
      composeDateTime(t, "InventoryReport", "reportedDateTime", element.getReportedDateTimeElement(), -1);
    }
    if (element.hasReporter()) {
      composeReference(t, "InventoryReport", "reporter", element.getReporter(), -1);
    }
    if (element.hasReportingPeriod()) {
      composePeriod(t, "InventoryReport", "reportingPeriod", element.getReportingPeriod(), -1);
    }
    for (int i = 0; i < element.getInventoryListing().size(); i++) {
      composeInventoryReportInventoryListingComponent(t, "InventoryReport", "inventoryListing", element.getInventoryListing().get(i), i);
    }
    if (element.hasNote()) {
      composeAnnotation(t, "InventoryReport", "note", element.getNote(), -1);
    }
  }

  protected void composeInventoryReportInventoryListingComponent(Complex parent, String parentType, String name, InventoryReport.InventoryReportInventoryListingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "inventoryListing", name, element, index);
    if (element.hasLocation()) {
      composeReference(t, "InventoryReportInventoryListingComponent", "location", element.getLocation(), -1);
    }
    if (element.hasItemStatus()) {
      composeCodeableConcept(t, "InventoryReportInventoryListingComponent", "itemStatus", element.getItemStatus(), -1);
    }
    if (element.hasCountingDateTimeElement()) {
      composeDateTime(t, "InventoryReportInventoryListingComponent", "countingDateTime", element.getCountingDateTimeElement(), -1);
    }
    for (int i = 0; i < element.getItems().size(); i++) {
      composeInventoryReportInventoryListingItemsComponent(t, "InventoryReportInventoryListingComponent", "items", element.getItems().get(i), i);
    }
  }

  protected void composeInventoryReportInventoryListingItemsComponent(Complex parent, String parentType, String name, InventoryReport.InventoryReportInventoryListingItemsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "items", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "InventoryReportInventoryListingItemsComponent", "category", element.getCategory(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "InventoryReportInventoryListingItemsComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasItem()) {
      composeCodeableReference(t, "InventoryReportInventoryListingItemsComponent", "item", element.getItem(), -1);
    }
    if (element.hasLotElement()) {
      composeString(t, "InventoryReportInventoryListingItemsComponent", "lot", element.getLotElement(), -1);
    }
    if (element.hasSerialElement()) {
      composeString(t, "InventoryReportInventoryListingItemsComponent", "serial", element.getSerialElement(), -1);
    }
    if (element.hasExpiryElement()) {
      composeDateTime(t, "InventoryReportInventoryListingItemsComponent", "expiry", element.getExpiryElement(), -1);
    }
    if (element.hasManufacturingDateElement()) {
      composeDateTime(t, "InventoryReportInventoryListingItemsComponent", "manufacturingDate", element.getManufacturingDateElement(), -1);
    }
  }

  protected void composeInvoice(Complex parent, String parentType, String name, Invoice element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Invoice", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Invoice", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Invoice", "status", element.getStatusElement(), -1);
    }
    if (element.hasCancelledReasonElement()) {
      composeString(t, "Invoice", "cancelledReason", element.getCancelledReasonElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Invoice", "type", element.getType(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Invoice", "subject", element.getSubject(), -1);
    }
    if (element.hasRecipient()) {
      composeReference(t, "Invoice", "recipient", element.getRecipient(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Invoice", "date", element.getDateElement(), -1);
    }
    if (element.hasCreationElement()) {
      composeDateTime(t, "Invoice", "creation", element.getCreationElement(), -1);
    }
    if (element.hasPeriod()) {
      composeType(t, "Invoice", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeInvoiceParticipantComponent(t, "Invoice", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasIssuer()) {
      composeReference(t, "Invoice", "issuer", element.getIssuer(), -1);
    }
    if (element.hasAccount()) {
      composeReference(t, "Invoice", "account", element.getAccount(), -1);
    }
    for (int i = 0; i < element.getLineItem().size(); i++) {
      composeInvoiceLineItemComponent(t, "Invoice", "lineItem", element.getLineItem().get(i), i);
    }
    for (int i = 0; i < element.getTotalPriceComponent().size(); i++) {
      composeMonetaryComponent(t, "Invoice", "totalPriceComponent", element.getTotalPriceComponent().get(i), i);
    }
    if (element.hasTotalNet()) {
      composeMoney(t, "Invoice", "totalNet", element.getTotalNet(), -1);
    }
    if (element.hasTotalGross()) {
      composeMoney(t, "Invoice", "totalGross", element.getTotalGross(), -1);
    }
    if (element.hasPaymentTermsElement()) {
      composeMarkdown(t, "Invoice", "paymentTerms", element.getPaymentTermsElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Invoice", "note", element.getNote().get(i), i);
    }
  }

  protected void composeInvoiceParticipantComponent(Complex parent, String parentType, String name, Invoice.InvoiceParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasRole()) {
      composeCodeableConcept(t, "InvoiceParticipantComponent", "role", element.getRole(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "InvoiceParticipantComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeInvoiceLineItemComponent(Complex parent, String parentType, String name, Invoice.InvoiceLineItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "lineItem", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "InvoiceLineItemComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasServiced()) {
      composeType(t, "InvoiceLineItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasChargeItem()) {
      composeType(t, "InvoiceLineItemComponent", "chargeItem", element.getChargeItem(), -1);
    }
    for (int i = 0; i < element.getPriceComponent().size(); i++) {
      composeMonetaryComponent(t, "InvoiceLineItemComponent", "priceComponent", element.getPriceComponent().get(i), i);
    }
  }

  protected void composeLibrary(Complex parent, String parentType, String name, Library element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "Library", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Library", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Library", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Library", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Library", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Library", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "Library", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Library", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Library", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Library", "type", element.getType(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "Library", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Library", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Library", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Library", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Library", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Library", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Library", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Library", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "Library", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Library", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Library", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Library", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "Library", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "Library", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "Library", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "Library", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "Library", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "Library", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "Library", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeParameterDefinition(t, "Library", "parameter", element.getParameter().get(i), i);
    }
    for (int i = 0; i < element.getDataRequirement().size(); i++) {
      composeDataRequirement(t, "Library", "dataRequirement", element.getDataRequirement().get(i), i);
    }
    for (int i = 0; i < element.getContent().size(); i++) {
      composeAttachment(t, "Library", "content", element.getContent().get(i), i);
    }
  }

  protected void composeLinkage(Complex parent, String parentType, String name, Linkage element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Linkage", name, element, index);
    if (element.hasActiveElement()) {
      composeBoolean(t, "Linkage", "active", element.getActiveElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "Linkage", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeLinkageItemComponent(t, "Linkage", "item", element.getItem().get(i), i);
    }
  }

  protected void composeLinkageItemComponent(Complex parent, String parentType, String name, Linkage.LinkageItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "LinkageItemComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasResource()) {
      composeReference(t, "LinkageItemComponent", "resource", element.getResource(), -1);
    }
  }

  protected void composeListResource(Complex parent, String parentType, String name, ListResource element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "List", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ListResource", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ListResource", "status", element.getStatusElement(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "ListResource", "mode", element.getModeElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ListResource", "title", element.getTitleElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ListResource", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "ListResource", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "ListResource", "encounter", element.getEncounter(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ListResource", "date", element.getDateElement(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "ListResource", "source", element.getSource(), -1);
    }
    if (element.hasOrderedBy()) {
      composeCodeableConcept(t, "ListResource", "orderedBy", element.getOrderedBy(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ListResource", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getEntry().size(); i++) {
      composeListResourceEntryComponent(t, "ListResource", "entry", element.getEntry().get(i), i);
    }
    if (element.hasEmptyReason()) {
      composeCodeableConcept(t, "ListResource", "emptyReason", element.getEmptyReason(), -1);
    }
  }

  protected void composeListResourceEntryComponent(Complex parent, String parentType, String name, ListResource.ListResourceEntryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entry", name, element, index);
    if (element.hasFlag()) {
      composeCodeableConcept(t, "ListResourceEntryComponent", "flag", element.getFlag(), -1);
    }
    if (element.hasDeletedElement()) {
      composeBoolean(t, "ListResourceEntryComponent", "deleted", element.getDeletedElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ListResourceEntryComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasItem()) {
      composeReference(t, "ListResourceEntryComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeLocation(Complex parent, String parentType, String name, Location element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Location", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Location", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Location", "status", element.getStatusElement(), -1);
    }
    if (element.hasOperationalStatus()) {
      composeCoding(t, "Location", "operationalStatus", element.getOperationalStatus(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Location", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "Location", "alias", element.getAlias().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Location", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "Location", "mode", element.getModeElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Location", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeExtendedContactDetail(t, "Location", "contact", element.getContact().get(i), i);
    }
    if (element.hasAddress()) {
      composeAddress(t, "Location", "address", element.getAddress(), -1);
    }
    if (element.hasForm()) {
      composeCodeableConcept(t, "Location", "form", element.getForm(), -1);
    }
    if (element.hasPosition()) {
      composeLocationPositionComponent(t, "Location", "position", element.getPosition(), -1);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "Location", "managingOrganization", element.getManagingOrganization(), -1);
    }
    if (element.hasPartOf()) {
      composeReference(t, "Location", "partOf", element.getPartOf(), -1);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeCodeableConcept(t, "Location", "characteristic", element.getCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getHoursOfOperation().size(); i++) {
      composeAvailability(t, "Location", "hoursOfOperation", element.getHoursOfOperation().get(i), i);
    }
    for (int i = 0; i < element.getVirtualService().size(); i++) {
      composeVirtualServiceDetail(t, "Location", "virtualService", element.getVirtualService().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "Location", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composeLocationPositionComponent(Complex parent, String parentType, String name, Location.LocationPositionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "position", name, element, index);
    if (element.hasLongitudeElement()) {
      composeDecimal(t, "LocationPositionComponent", "longitude", element.getLongitudeElement(), -1);
    }
    if (element.hasLatitudeElement()) {
      composeDecimal(t, "LocationPositionComponent", "latitude", element.getLatitudeElement(), -1);
    }
    if (element.hasAltitudeElement()) {
      composeDecimal(t, "LocationPositionComponent", "altitude", element.getAltitudeElement(), -1);
    }
  }

  protected void composeManufacturedItemDefinition(Complex parent, String parentType, String name, ManufacturedItemDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ManufacturedItemDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ManufacturedItemDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ManufacturedItemDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ManufacturedItemDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasManufacturedDoseForm()) {
      composeCodeableConcept(t, "ManufacturedItemDefinition", "manufacturedDoseForm", element.getManufacturedDoseForm(), -1);
    }
    if (element.hasUnitOfPresentation()) {
      composeCodeableConcept(t, "ManufacturedItemDefinition", "unitOfPresentation", element.getUnitOfPresentation(), -1);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "ManufacturedItemDefinition", "manufacturer", element.getManufacturer().get(i), i);
    }
    for (int i = 0; i < element.getMarketingStatus().size(); i++) {
      composeMarketingStatus(t, "ManufacturedItemDefinition", "marketingStatus", element.getMarketingStatus().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeCodeableConcept(t, "ManufacturedItemDefinition", "ingredient", element.getIngredient().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeManufacturedItemDefinitionPropertyComponent(t, "ManufacturedItemDefinition", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeManufacturedItemDefinitionComponentComponent(t, "ManufacturedItemDefinition", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeManufacturedItemDefinitionPropertyComponent(Complex parent, String parentType, String name, ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ManufacturedItemDefinitionPropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ManufacturedItemDefinitionPropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeManufacturedItemDefinitionComponentComponent(Complex parent, String parentType, String name, ManufacturedItemDefinition.ManufacturedItemDefinitionComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ManufacturedItemDefinitionComponentComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getFunction().size(); i++) {
      composeCodeableConcept(t, "ManufacturedItemDefinitionComponentComponent", "function", element.getFunction().get(i), i);
    }
    for (int i = 0; i < element.getAmount().size(); i++) {
      composeQuantity(t, "ManufacturedItemDefinitionComponentComponent", "amount", element.getAmount().get(i), i);
    }
    for (int i = 0; i < element.getConstituent().size(); i++) {
      composeManufacturedItemDefinitionComponentConstituentComponent(t, "ManufacturedItemDefinitionComponentComponent", "constituent", element.getConstituent().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeManufacturedItemDefinitionPropertyComponent(t, "ManufacturedItemDefinitionComponentComponent", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeManufacturedItemDefinitionComponentComponent(t, "ManufacturedItemDefinitionComponentComponent", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeManufacturedItemDefinitionComponentConstituentComponent(Complex parent, String parentType, String name, ManufacturedItemDefinition.ManufacturedItemDefinitionComponentConstituentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "constituent", name, element, index);
    for (int i = 0; i < element.getAmount().size(); i++) {
      composeQuantity(t, "ManufacturedItemDefinitionComponentConstituentComponent", "amount", element.getAmount().get(i), i);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeCodeableConcept(t, "ManufacturedItemDefinitionComponentConstituentComponent", "location", element.getLocation().get(i), i);
    }
    for (int i = 0; i < element.getFunction().size(); i++) {
      composeCodeableConcept(t, "ManufacturedItemDefinitionComponentConstituentComponent", "function", element.getFunction().get(i), i);
    }
    for (int i = 0; i < element.getHasIngredient().size(); i++) {
      composeCodeableReference(t, "ManufacturedItemDefinitionComponentConstituentComponent", "hasIngredient", element.getHasIngredient().get(i), i);
    }
  }

  protected void composeMeasure(Complex parent, String parentType, String name, Measure element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "Measure", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Measure", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Measure", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Measure", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Measure", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Measure", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "Measure", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Measure", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Measure", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "Measure", "subject", element.getSubject(), -1);
    }
    if (element.hasBasisElement()) {
      composeEnum(t, "Measure", "basis", element.getBasisElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Measure", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Measure", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Measure", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Measure", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Measure", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Measure", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Measure", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "Measure", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Measure", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Measure", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Measure", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "Measure", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "Measure", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "Measure", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "Measure", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "Measure", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "Measure", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "Measure", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "Measure", "library", element.getLibrary().get(i), i);
    }
    if (element.hasDisclaimerElement()) {
      composeMarkdown(t, "Measure", "disclaimer", element.getDisclaimerElement(), -1);
    }
    if (element.hasScoring()) {
      composeCodeableConcept(t, "Measure", "scoring", element.getScoring(), -1);
    }
    if (element.hasScoringUnit()) {
      composeCodeableConcept(t, "Measure", "scoringUnit", element.getScoringUnit(), -1);
    }
    if (element.hasCompositeScoring()) {
      composeCodeableConcept(t, "Measure", "compositeScoring", element.getCompositeScoring(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Measure", "type", element.getType().get(i), i);
    }
    if (element.hasRiskAdjustmentElement()) {
      composeString(t, "Measure", "riskAdjustment", element.getRiskAdjustmentElement(), -1);
    }
    if (element.hasRateAggregationElement()) {
      composeString(t, "Measure", "rateAggregation", element.getRateAggregationElement(), -1);
    }
    if (element.hasRationaleElement()) {
      composeMarkdown(t, "Measure", "rationale", element.getRationaleElement(), -1);
    }
    if (element.hasClinicalRecommendationStatementElement()) {
      composeMarkdown(t, "Measure", "clinicalRecommendationStatement", element.getClinicalRecommendationStatementElement(), -1);
    }
    if (element.hasImprovementNotation()) {
      composeCodeableConcept(t, "Measure", "improvementNotation", element.getImprovementNotation(), -1);
    }
    for (int i = 0; i < element.getTerm().size(); i++) {
      composeMeasureTermComponent(t, "Measure", "term", element.getTerm().get(i), i);
    }
    if (element.hasGuidanceElement()) {
      composeMarkdown(t, "Measure", "guidance", element.getGuidanceElement(), -1);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeMeasureGroupComponent(t, "Measure", "group", element.getGroup().get(i), i);
    }
    for (int i = 0; i < element.getSupplementalData().size(); i++) {
      composeMeasureSupplementalDataComponent(t, "Measure", "supplementalData", element.getSupplementalData().get(i), i);
    }
  }

  protected void composeMeasureTermComponent(Complex parent, String parentType, String name, Measure.MeasureTermComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "term", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureTermComponent", "code", element.getCode(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeMarkdown(t, "MeasureTermComponent", "definition", element.getDefinitionElement(), -1);
    }
  }

  protected void composeMeasureGroupComponent(Complex parent, String parentType, String name, Measure.MeasureGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "group", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureGroupComponent", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureGroupComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "MeasureGroupComponent", "type", element.getType().get(i), i);
    }
    if (element.hasBasisElement()) {
      composeEnum(t, "MeasureGroupComponent", "basis", element.getBasisElement(), -1);
    }
    if (element.hasScoring()) {
      composeCodeableConcept(t, "MeasureGroupComponent", "scoring", element.getScoring(), -1);
    }
    if (element.hasScoringUnit()) {
      composeCodeableConcept(t, "MeasureGroupComponent", "scoringUnit", element.getScoringUnit(), -1);
    }
    if (element.hasImprovementNotation()) {
      composeCodeableConcept(t, "MeasureGroupComponent", "improvementNotation", element.getImprovementNotation(), -1);
    }
    for (int i = 0; i < element.getPopulation().size(); i++) {
      composeMeasureGroupPopulationComponent(t, "MeasureGroupComponent", "population", element.getPopulation().get(i), i);
    }
    for (int i = 0; i < element.getStratifier().size(); i++) {
      composeMeasureGroupStratifierComponent(t, "MeasureGroupComponent", "stratifier", element.getStratifier().get(i), i);
    }
  }

  protected void composeMeasureGroupPopulationComponent(Complex parent, String parentType, String name, Measure.MeasureGroupPopulationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "population", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureGroupPopulationComponent", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureGroupPopulationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCriteria()) {
      composeExpression(t, "MeasureGroupPopulationComponent", "criteria", element.getCriteria(), -1);
    }
    if (element.hasInputPopulationIdElement()) {
      composeString(t, "MeasureGroupPopulationComponent", "inputPopulationId", element.getInputPopulationIdElement(), -1);
    }
    if (element.hasAggregateMethod()) {
      composeCodeableConcept(t, "MeasureGroupPopulationComponent", "aggregateMethod", element.getAggregateMethod(), -1);
    }
  }

  protected void composeMeasureGroupStratifierComponent(Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "stratifier", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureGroupStratifierComponent", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureGroupStratifierComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCriteria()) {
      composeExpression(t, "MeasureGroupStratifierComponent", "criteria", element.getCriteria(), -1);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeMeasureGroupStratifierComponentComponent(t, "MeasureGroupStratifierComponent", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeMeasureGroupStratifierComponentComponent(Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureGroupStratifierComponentComponent", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureGroupStratifierComponentComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCriteria()) {
      composeExpression(t, "MeasureGroupStratifierComponentComponent", "criteria", element.getCriteria(), -1);
    }
  }

  protected void composeMeasureSupplementalDataComponent(Complex parent, String parentType, String name, Measure.MeasureSupplementalDataComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supplementalData", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureSupplementalDataComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getUsage().size(); i++) {
      composeCodeableConcept(t, "MeasureSupplementalDataComponent", "usage", element.getUsage().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureSupplementalDataComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCriteria()) {
      composeExpression(t, "MeasureSupplementalDataComponent", "criteria", element.getCriteria(), -1);
    }
  }

  protected void composeMeasureReport(Complex parent, String parentType, String name, MeasureReport element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MeasureReport", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MeasureReport", "status", element.getStatusElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "MeasureReport", "type", element.getTypeElement(), -1);
    }
    if (element.hasDataUpdateTypeElement()) {
      composeEnum(t, "MeasureReport", "dataUpdateType", element.getDataUpdateTypeElement(), -1);
    }
    if (element.hasMeasureElement()) {
      composeCanonical(t, "MeasureReport", "measure", element.getMeasureElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MeasureReport", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "MeasureReport", "date", element.getDateElement(), -1);
    }
    if (element.hasReporter()) {
      composeReference(t, "MeasureReport", "reporter", element.getReporter(), -1);
    }
    if (element.hasReportingVendor()) {
      composeReference(t, "MeasureReport", "reportingVendor", element.getReportingVendor(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "MeasureReport", "location", element.getLocation(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "MeasureReport", "period", element.getPeriod(), -1);
    }
    if (element.hasInputParameters()) {
      composeReference(t, "MeasureReport", "inputParameters", element.getInputParameters(), -1);
    }
    if (element.hasScoring()) {
      composeCodeableConcept(t, "MeasureReport", "scoring", element.getScoring(), -1);
    }
    if (element.hasImprovementNotation()) {
      composeCodeableConcept(t, "MeasureReport", "improvementNotation", element.getImprovementNotation(), -1);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeMeasureReportGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i), i);
    }
    for (int i = 0; i < element.getEvaluatedResource().size(); i++) {
      composeReference(t, "MeasureReport", "evaluatedResource", element.getEvaluatedResource().get(i), i);
    }
  }

  protected void composeMeasureReportGroupComponent(Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "group", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureReportGroupComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getPopulation().size(); i++) {
      composeMeasureReportGroupPopulationComponent(t, "MeasureReportGroupComponent", "population", element.getPopulation().get(i), i);
    }
    if (element.hasMeasureScore()) {
      composeType(t, "MeasureReportGroupComponent", "measureScore", element.getMeasureScore(), -1);
    }
    for (int i = 0; i < element.getStratifier().size(); i++) {
      composeMeasureReportGroupStratifierComponent(t, "MeasureReportGroupComponent", "stratifier", element.getStratifier().get(i), i);
    }
  }

  protected void composeMeasureReportGroupPopulationComponent(Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupPopulationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "population", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureReportGroupPopulationComponent", "code", element.getCode(), -1);
    }
    if (element.hasCountElement()) {
      composeInteger(t, "MeasureReportGroupPopulationComponent", "count", element.getCountElement(), -1);
    }
    if (element.hasSubjectResults()) {
      composeReference(t, "MeasureReportGroupPopulationComponent", "subjectResults", element.getSubjectResults(), -1);
    }
  }

  protected void composeMeasureReportGroupStratifierComponent(Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "stratifier", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureReportGroupStratifierComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getStratum().size(); i++) {
      composeMeasureReportStratifierGroupComponent(t, "MeasureReportGroupStratifierComponent", "stratum", element.getStratum().get(i), i);
    }
  }

  protected void composeMeasureReportStratifierGroupComponent(Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "stratum", name, element, index);
    if (element.hasValue()) {
      composeType(t, "StratifierGroupComponent", "value", element.getValue(), -1);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeMeasureReportStratifierGroupComponentComponent(t, "StratifierGroupComponent", "component", element.getComponent().get(i), i);
    }
    for (int i = 0; i < element.getPopulation().size(); i++) {
      composeMeasureReportStratifierGroupPopulationComponent(t, "StratifierGroupComponent", "population", element.getPopulation().get(i), i);
    }
    if (element.hasMeasureScore()) {
      composeType(t, "StratifierGroupComponent", "measureScore", element.getMeasureScore(), -1);
    }
  }

  protected void composeMeasureReportStratifierGroupComponentComponent(Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "StratifierGroupComponentComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "StratifierGroupComponentComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMeasureReportStratifierGroupPopulationComponent(Complex parent, String parentType, String name, MeasureReport.StratifierGroupPopulationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "population", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "StratifierGroupPopulationComponent", "code", element.getCode(), -1);
    }
    if (element.hasCountElement()) {
      composeInteger(t, "StratifierGroupPopulationComponent", "count", element.getCountElement(), -1);
    }
    if (element.hasSubjectResults()) {
      composeReference(t, "StratifierGroupPopulationComponent", "subjectResults", element.getSubjectResults(), -1);
    }
  }

  protected void composeMedication(Complex parent, String parentType, String name, Medication element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Medication", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Medication", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Medication", "code", element.getCode(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Medication", "status", element.getStatusElement(), -1);
    }
    if (element.hasMarketingAuthorizationHolder()) {
      composeReference(t, "Medication", "marketingAuthorizationHolder", element.getMarketingAuthorizationHolder(), -1);
    }
    if (element.hasDoseForm()) {
      composeCodeableConcept(t, "Medication", "doseForm", element.getDoseForm(), -1);
    }
    if (element.hasTotalVolume()) {
      composeRatio(t, "Medication", "totalVolume", element.getTotalVolume(), -1);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeMedicationIngredientComponent(t, "Medication", "ingredient", element.getIngredient().get(i), i);
    }
    if (element.hasBatch()) {
      composeMedicationBatchComponent(t, "Medication", "batch", element.getBatch(), -1);
    }
  }

  protected void composeMedicationIngredientComponent(Complex parent, String parentType, String name, Medication.MedicationIngredientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "ingredient", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "MedicationIngredientComponent", "item", element.getItem(), -1);
    }
    if (element.hasIsActiveElement()) {
      composeBoolean(t, "MedicationIngredientComponent", "isActive", element.getIsActiveElement(), -1);
    }
    if (element.hasStrength()) {
      composeType(t, "MedicationIngredientComponent", "strength", element.getStrength(), -1);
    }
  }

  protected void composeMedicationBatchComponent(Complex parent, String parentType, String name, Medication.MedicationBatchComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "batch", name, element, index);
    if (element.hasLotNumberElement()) {
      composeString(t, "MedicationBatchComponent", "lotNumber", element.getLotNumberElement(), -1);
    }
    if (element.hasExpirationDateElement()) {
      composeDateTime(t, "MedicationBatchComponent", "expirationDate", element.getExpirationDateElement(), -1);
    }
  }

  protected void composeMedicationAdministration(Complex parent, String parentType, String name, MedicationAdministration element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationAdministration", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationAdministration", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "MedicationAdministration", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "MedicationAdministration", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationAdministration", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusReason().size(); i++) {
      composeCodeableConcept(t, "MedicationAdministration", "statusReason", element.getStatusReason().get(i), i);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "MedicationAdministration", "category", element.getCategory().get(i), i);
    }
    if (element.hasMedication()) {
      composeCodeableReference(t, "MedicationAdministration", "medication", element.getMedication(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MedicationAdministration", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "MedicationAdministration", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "MedicationAdministration", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    if (element.hasOccurence()) {
      composeType(t, "MedicationAdministration", "occurence", element.getOccurence(), -1);
    }
    if (element.hasRecordedElement()) {
      composeDateTime(t, "MedicationAdministration", "recorded", element.getRecordedElement(), -1);
    }
    if (element.hasIsSubPotentElement()) {
      composeBoolean(t, "MedicationAdministration", "isSubPotent", element.getIsSubPotentElement(), -1);
    }
    for (int i = 0; i < element.getSubPotentReason().size(); i++) {
      composeCodeableConcept(t, "MedicationAdministration", "subPotentReason", element.getSubPotentReason().get(i), i);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeMedicationAdministrationPerformerComponent(t, "MedicationAdministration", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "MedicationAdministration", "reason", element.getReason().get(i), i);
    }
    if (element.hasRequest()) {
      composeReference(t, "MedicationAdministration", "request", element.getRequest(), -1);
    }
    for (int i = 0; i < element.getDevice().size(); i++) {
      composeReference(t, "MedicationAdministration", "device", element.getDevice().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationAdministration", "note", element.getNote().get(i), i);
    }
    if (element.hasDosage()) {
      composeMedicationAdministrationDosageComponent(t, "MedicationAdministration", "dosage", element.getDosage(), -1);
    }
    for (int i = 0; i < element.getEventHistory().size(); i++) {
      composeReference(t, "MedicationAdministration", "eventHistory", element.getEventHistory().get(i), i);
    }
  }

  protected void composeMedicationAdministrationPerformerComponent(Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "MedicationAdministrationPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "MedicationAdministrationPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeMedicationAdministrationDosageComponent(Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationDosageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dosage", name, element, index);
    if (element.hasTextElement()) {
      composeString(t, "MedicationAdministrationDosageComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasSite()) {
      composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "site", element.getSite(), -1);
    }
    if (element.hasRoute()) {
      composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "route", element.getRoute(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "method", element.getMethod(), -1);
    }
    if (element.hasDose()) {
      composeQuantity(t, "MedicationAdministrationDosageComponent", "dose", element.getDose(), -1);
    }
    if (element.hasRate()) {
      composeType(t, "MedicationAdministrationDosageComponent", "rate", element.getRate(), -1);
    }
  }

  protected void composeMedicationDispense(Complex parent, String parentType, String name, MedicationDispense element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationDispense", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationDispense", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "MedicationDispense", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "MedicationDispense", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationDispense", "status", element.getStatusElement(), -1);
    }
    if (element.hasNotPerformedReason()) {
      composeCodeableReference(t, "MedicationDispense", "notPerformedReason", element.getNotPerformedReason(), -1);
    }
    if (element.hasStatusChangedElement()) {
      composeDateTime(t, "MedicationDispense", "statusChanged", element.getStatusChangedElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "MedicationDispense", "category", element.getCategory().get(i), i);
    }
    if (element.hasMedication()) {
      composeCodeableReference(t, "MedicationDispense", "medication", element.getMedication(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MedicationDispense", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "MedicationDispense", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "MedicationDispense", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeMedicationDispensePerformerComponent(t, "MedicationDispense", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "MedicationDispense", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getAuthorizingPrescription().size(); i++) {
      composeReference(t, "MedicationDispense", "authorizingPrescription", element.getAuthorizingPrescription().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationDispense", "quantity", element.getQuantity(), -1);
    }
    if (element.hasDaysSupply()) {
      composeQuantity(t, "MedicationDispense", "daysSupply", element.getDaysSupply(), -1);
    }
    if (element.hasRecordedElement()) {
      composeDateTime(t, "MedicationDispense", "recorded", element.getRecordedElement(), -1);
    }
    if (element.hasWhenPreparedElement()) {
      composeDateTime(t, "MedicationDispense", "whenPrepared", element.getWhenPreparedElement(), -1);
    }
    if (element.hasWhenHandedOverElement()) {
      composeDateTime(t, "MedicationDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
    }
    if (element.hasDestination()) {
      composeReference(t, "MedicationDispense", "destination", element.getDestination(), -1);
    }
    for (int i = 0; i < element.getReceiver().size(); i++) {
      composeReference(t, "MedicationDispense", "receiver", element.getReceiver().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationDispense", "note", element.getNote().get(i), i);
    }
    if (element.hasRenderedDosageInstructionElement()) {
      composeString(t, "MedicationDispense", "renderedDosageInstruction", element.getRenderedDosageInstructionElement(), -1);
    }
    for (int i = 0; i < element.getDosageInstruction().size(); i++) {
      composeDosage(t, "MedicationDispense", "dosageInstruction", element.getDosageInstruction().get(i), i);
    }
    if (element.hasSubstitution()) {
      composeMedicationDispenseSubstitutionComponent(t, "MedicationDispense", "substitution", element.getSubstitution(), -1);
    }
    for (int i = 0; i < element.getEventHistory().size(); i++) {
      composeReference(t, "MedicationDispense", "eventHistory", element.getEventHistory().get(i), i);
    }
  }

  protected void composeMedicationDispensePerformerComponent(Complex parent, String parentType, String name, MedicationDispense.MedicationDispensePerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "MedicationDispensePerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "MedicationDispensePerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeMedicationDispenseSubstitutionComponent(Complex parent, String parentType, String name, MedicationDispense.MedicationDispenseSubstitutionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "substitution", name, element, index);
    if (element.hasWasSubstitutedElement()) {
      composeBoolean(t, "MedicationDispenseSubstitutionComponent", "wasSubstituted", element.getWasSubstitutedElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationDispenseSubstitutionComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableConcept(t, "MedicationDispenseSubstitutionComponent", "reason", element.getReason().get(i), i);
    }
    if (element.hasResponsibleParty()) {
      composeReference(t, "MedicationDispenseSubstitutionComponent", "responsibleParty", element.getResponsibleParty(), -1);
    }
  }

  protected void composeMedicationKnowledge(Complex parent, String parentType, String name, MedicationKnowledge element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationKnowledge", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationKnowledge", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "MedicationKnowledge", "code", element.getCode(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationKnowledge", "status", element.getStatusElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "MedicationKnowledge", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getIntendedJurisdiction().size(); i++) {
      composeCodeableConcept(t, "MedicationKnowledge", "intendedJurisdiction", element.getIntendedJurisdiction().get(i), i);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeString(t, "MedicationKnowledge", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getRelatedMedicationKnowledge().size(); i++) {
      composeMedicationKnowledgeRelatedMedicationKnowledgeComponent(t, "MedicationKnowledge", "relatedMedicationKnowledge", element.getRelatedMedicationKnowledge().get(i), i);
    }
    for (int i = 0; i < element.getAssociatedMedication().size(); i++) {
      composeReference(t, "MedicationKnowledge", "associatedMedication", element.getAssociatedMedication().get(i), i);
    }
    for (int i = 0; i < element.getProductType().size(); i++) {
      composeCodeableConcept(t, "MedicationKnowledge", "productType", element.getProductType().get(i), i);
    }
    for (int i = 0; i < element.getMonograph().size(); i++) {
      composeMedicationKnowledgeMonographComponent(t, "MedicationKnowledge", "monograph", element.getMonograph().get(i), i);
    }
    if (element.hasPreparationInstructionElement()) {
      composeMarkdown(t, "MedicationKnowledge", "preparationInstruction", element.getPreparationInstructionElement(), -1);
    }
    for (int i = 0; i < element.getCost().size(); i++) {
      composeMedicationKnowledgeCostComponent(t, "MedicationKnowledge", "cost", element.getCost().get(i), i);
    }
    for (int i = 0; i < element.getMonitoringProgram().size(); i++) {
      composeMedicationKnowledgeMonitoringProgramComponent(t, "MedicationKnowledge", "monitoringProgram", element.getMonitoringProgram().get(i), i);
    }
    for (int i = 0; i < element.getIndicationGuideline().size(); i++) {
      composeMedicationKnowledgeIndicationGuidelineComponent(t, "MedicationKnowledge", "indicationGuideline", element.getIndicationGuideline().get(i), i);
    }
    for (int i = 0; i < element.getMedicineClassification().size(); i++) {
      composeMedicationKnowledgeMedicineClassificationComponent(t, "MedicationKnowledge", "medicineClassification", element.getMedicineClassification().get(i), i);
    }
    for (int i = 0; i < element.getPackaging().size(); i++) {
      composeMedicationKnowledgePackagingComponent(t, "MedicationKnowledge", "packaging", element.getPackaging().get(i), i);
    }
    for (int i = 0; i < element.getClinicalUseIssue().size(); i++) {
      composeReference(t, "MedicationKnowledge", "clinicalUseIssue", element.getClinicalUseIssue().get(i), i);
    }
    for (int i = 0; i < element.getStorageGuideline().size(); i++) {
      composeMedicationKnowledgeStorageGuidelineComponent(t, "MedicationKnowledge", "storageGuideline", element.getStorageGuideline().get(i), i);
    }
    for (int i = 0; i < element.getRegulatory().size(); i++) {
      composeMedicationKnowledgeRegulatoryComponent(t, "MedicationKnowledge", "regulatory", element.getRegulatory().get(i), i);
    }
    if (element.hasDefinitional()) {
      composeMedicationKnowledgeDefinitionalComponent(t, "MedicationKnowledge", "definitional", element.getDefinitional(), -1);
    }
  }

  protected void composeMedicationKnowledgeRelatedMedicationKnowledgeComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatedMedicationKnowledge", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeRelatedMedicationKnowledgeComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getReference().size(); i++) {
      composeReference(t, "MedicationKnowledgeRelatedMedicationKnowledgeComponent", "reference", element.getReference().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeMonographComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonographComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "monograph", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeMonographComponent", "type", element.getType(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "MedicationKnowledgeMonographComponent", "source", element.getSource(), -1);
    }
  }

  protected void composeMedicationKnowledgeCostComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeCostComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "cost", name, element, index);
    for (int i = 0; i < element.getEffectiveDate().size(); i++) {
      composePeriod(t, "MedicationKnowledgeCostComponent", "effectiveDate", element.getEffectiveDate().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeCostComponent", "type", element.getType(), -1);
    }
    if (element.hasSourceElement()) {
      composeString(t, "MedicationKnowledgeCostComponent", "source", element.getSourceElement(), -1);
    }
    if (element.hasCost()) {
      composeType(t, "MedicationKnowledgeCostComponent", "cost", element.getCost(), -1);
    }
  }

  protected void composeMedicationKnowledgeMonitoringProgramComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "monitoringProgram", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeMonitoringProgramComponent", "type", element.getType(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "MedicationKnowledgeMonitoringProgramComponent", "name", element.getNameElement(), -1);
    }
  }

  protected void composeMedicationKnowledgeIndicationGuidelineComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIndicationGuidelineComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "indicationGuideline", name, element, index);
    for (int i = 0; i < element.getIndication().size(); i++) {
      composeCodeableReference(t, "MedicationKnowledgeIndicationGuidelineComponent", "indication", element.getIndication().get(i), i);
    }
    for (int i = 0; i < element.getDosingGuideline().size(); i++) {
      composeMedicationKnowledgeIndicationGuidelineDosingGuidelineComponent(t, "MedicationKnowledgeIndicationGuidelineComponent", "dosingGuideline", element.getDosingGuideline().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeIndicationGuidelineDosingGuidelineComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dosingGuideline", name, element, index);
    if (element.hasTreatmentIntent()) {
      composeCodeableConcept(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent", "treatmentIntent", element.getTreatmentIntent(), -1);
    }
    for (int i = 0; i < element.getDosage().size(); i++) {
      composeMedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent", "dosage", element.getDosage().get(i), i);
    }
    if (element.hasAdministrationTreatment()) {
      composeCodeableConcept(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent", "administrationTreatment", element.getAdministrationTreatment(), -1);
    }
    for (int i = 0; i < element.getPatientCharacteristic().size(); i++) {
      composeMedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent", "patientCharacteristic", element.getPatientCharacteristic().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dosage", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getDosage().size(); i++) {
      composeDosage(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent", "dosage", element.getDosage().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "patientCharacteristic", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMedicationKnowledgeMedicineClassificationComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "medicineClassification", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeMedicineClassificationComponent", "type", element.getType(), -1);
    }
    if (element.hasSource()) {
      composeType(t, "MedicationKnowledgeMedicineClassificationComponent", "source", element.getSource(), -1);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCodeableConcept(t, "MedicationKnowledgeMedicineClassificationComponent", "classification", element.getClassification().get(i), i);
    }
  }

  protected void composeMedicationKnowledgePackagingComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgePackagingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "packaging", name, element, index);
    for (int i = 0; i < element.getCost().size(); i++) {
      composeMedicationKnowledgeCostComponent(t, "MedicationKnowledgePackagingComponent", "cost", element.getCost().get(i), i);
    }
    if (element.hasPackagedProduct()) {
      composeReference(t, "MedicationKnowledgePackagingComponent", "packagedProduct", element.getPackagedProduct(), -1);
    }
  }

  protected void composeMedicationKnowledgeStorageGuidelineComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeStorageGuidelineComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "storageGuideline", name, element, index);
    if (element.hasReferenceElement()) {
      composeUri(t, "MedicationKnowledgeStorageGuidelineComponent", "reference", element.getReferenceElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationKnowledgeStorageGuidelineComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasStabilityDuration()) {
      composeDuration(t, "MedicationKnowledgeStorageGuidelineComponent", "stabilityDuration", element.getStabilityDuration(), -1);
    }
    for (int i = 0; i < element.getEnvironmentalSetting().size(); i++) {
      composeMedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent(t, "MedicationKnowledgeStorageGuidelineComponent", "environmentalSetting", element.getEnvironmentalSetting().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "environmentalSetting", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "MedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMedicationKnowledgeRegulatoryComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "regulatory", name, element, index);
    if (element.hasRegulatoryAuthority()) {
      composeReference(t, "MedicationKnowledgeRegulatoryComponent", "regulatoryAuthority", element.getRegulatoryAuthority(), -1);
    }
    for (int i = 0; i < element.getSubstitution().size(); i++) {
      composeMedicationKnowledgeRegulatorySubstitutionComponent(t, "MedicationKnowledgeRegulatoryComponent", "substitution", element.getSubstitution().get(i), i);
    }
    for (int i = 0; i < element.getSchedule().size(); i++) {
      composeCodeableConcept(t, "MedicationKnowledgeRegulatoryComponent", "schedule", element.getSchedule().get(i), i);
    }
    if (element.hasMaxDispense()) {
      composeMedicationKnowledgeRegulatoryMaxDispenseComponent(t, "MedicationKnowledgeRegulatoryComponent", "maxDispense", element.getMaxDispense(), -1);
    }
  }

  protected void composeMedicationKnowledgeRegulatorySubstitutionComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "substitution", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeRegulatorySubstitutionComponent", "type", element.getType(), -1);
    }
    if (element.hasAllowedElement()) {
      composeBoolean(t, "MedicationKnowledgeRegulatorySubstitutionComponent", "allowed", element.getAllowedElement(), -1);
    }
  }

  protected void composeMedicationKnowledgeRegulatoryMaxDispenseComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "maxDispense", name, element, index);
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationKnowledgeRegulatoryMaxDispenseComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasPeriod()) {
      composeDuration(t, "MedicationKnowledgeRegulatoryMaxDispenseComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeMedicationKnowledgeDefinitionalComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDefinitionalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "definitional", name, element, index);
    for (int i = 0; i < element.getDefinition().size(); i++) {
      composeReference(t, "MedicationKnowledgeDefinitionalComponent", "definition", element.getDefinition().get(i), i);
    }
    if (element.hasDoseForm()) {
      composeCodeableConcept(t, "MedicationKnowledgeDefinitionalComponent", "doseForm", element.getDoseForm(), -1);
    }
    for (int i = 0; i < element.getIntendedRoute().size(); i++) {
      composeCodeableConcept(t, "MedicationKnowledgeDefinitionalComponent", "intendedRoute", element.getIntendedRoute().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeMedicationKnowledgeDefinitionalIngredientComponent(t, "MedicationKnowledgeDefinitionalComponent", "ingredient", element.getIngredient().get(i), i);
    }
    for (int i = 0; i < element.getDrugCharacteristic().size(); i++) {
      composeMedicationKnowledgeDefinitionalDrugCharacteristicComponent(t, "MedicationKnowledgeDefinitionalComponent", "drugCharacteristic", element.getDrugCharacteristic().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeDefinitionalIngredientComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDefinitionalIngredientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "ingredient", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "MedicationKnowledgeDefinitionalIngredientComponent", "item", element.getItem(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeDefinitionalIngredientComponent", "type", element.getType(), -1);
    }
    if (element.hasStrength()) {
      composeType(t, "MedicationKnowledgeDefinitionalIngredientComponent", "strength", element.getStrength(), -1);
    }
  }

  protected void composeMedicationKnowledgeDefinitionalDrugCharacteristicComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDefinitionalDrugCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "drugCharacteristic", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeDefinitionalDrugCharacteristicComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "MedicationKnowledgeDefinitionalDrugCharacteristicComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMedicationRequest(Complex parent, String parentType, String name, MedicationRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationRequest", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "MedicationRequest", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasPriorPrescription()) {
      composeReference(t, "MedicationRequest", "priorPrescription", element.getPriorPrescription(), -1);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "MedicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "MedicationRequest", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasStatusChangedElement()) {
      composeDateTime(t, "MedicationRequest", "statusChanged", element.getStatusChangedElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "MedicationRequest", "intent", element.getIntentElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "MedicationRequest", "category", element.getCategory().get(i), i);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "MedicationRequest", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "MedicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasMedication()) {
      composeCodeableReference(t, "MedicationRequest", "medication", element.getMedication(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MedicationRequest", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getInformationSource().size(); i++) {
      composeReference(t, "MedicationRequest", "informationSource", element.getInformationSource().get(i), i);
    }
    if (element.hasEncounter()) {
      composeReference(t, "MedicationRequest", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "MedicationRequest", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "MedicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "MedicationRequest", "requester", element.getRequester(), -1);
    }
    if (element.hasReportedElement()) {
      composeBoolean(t, "MedicationRequest", "reported", element.getReportedElement(), -1);
    }
    if (element.hasPerformerType()) {
      composeCodeableConcept(t, "MedicationRequest", "performerType", element.getPerformerType(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "MedicationRequest", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasDevice()) {
      composeCodeableReference(t, "MedicationRequest", "device", element.getDevice(), -1);
    }
    if (element.hasRecorder()) {
      composeReference(t, "MedicationRequest", "recorder", element.getRecorder(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "MedicationRequest", "reason", element.getReason().get(i), i);
    }
    if (element.hasCourseOfTherapyType()) {
      composeCodeableConcept(t, "MedicationRequest", "courseOfTherapyType", element.getCourseOfTherapyType(), -1);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeReference(t, "MedicationRequest", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationRequest", "note", element.getNote().get(i), i);
    }
    if (element.hasDose()) {
      composeMedicationRequestDoseComponent(t, "MedicationRequest", "dose", element.getDose(), -1);
    }
    if (element.hasDispenseRequest()) {
      composeMedicationRequestDispenseRequestComponent(t, "MedicationRequest", "dispenseRequest", element.getDispenseRequest(), -1);
    }
    if (element.hasSubstitution()) {
      composeMedicationRequestSubstitutionComponent(t, "MedicationRequest", "substitution", element.getSubstitution(), -1);
    }
    for (int i = 0; i < element.getEventHistory().size(); i++) {
      composeReference(t, "MedicationRequest", "eventHistory", element.getEventHistory().get(i), i);
    }
  }

  protected void composeMedicationRequestDoseComponent(Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDoseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dose", name, element, index);
    if (element.hasRenderedDosageInstructionElement()) {
      composeString(t, "MedicationRequestDoseComponent", "renderedDosageInstruction", element.getRenderedDosageInstructionElement(), -1);
    }
    if (element.hasEffectiveDosePeriod()) {
      composePeriod(t, "MedicationRequestDoseComponent", "effectiveDosePeriod", element.getEffectiveDosePeriod(), -1);
    }
    for (int i = 0; i < element.getDosageInstruction().size(); i++) {
      composeDosage(t, "MedicationRequestDoseComponent", "dosageInstruction", element.getDosageInstruction().get(i), i);
    }
  }

  protected void composeMedicationRequestDispenseRequestComponent(Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dispenseRequest", name, element, index);
    if (element.hasInitialFill()) {
      composeMedicationRequestDispenseRequestInitialFillComponent(t, "MedicationRequestDispenseRequestComponent", "initialFill", element.getInitialFill(), -1);
    }
    if (element.hasDispenseInterval()) {
      composeDuration(t, "MedicationRequestDispenseRequestComponent", "dispenseInterval", element.getDispenseInterval(), -1);
    }
    if (element.hasValidityPeriod()) {
      composePeriod(t, "MedicationRequestDispenseRequestComponent", "validityPeriod", element.getValidityPeriod(), -1);
    }
    if (element.hasNumberOfRepeatsAllowedElement()) {
      composeUnsignedInt(t, "MedicationRequestDispenseRequestComponent", "numberOfRepeatsAllowed", element.getNumberOfRepeatsAllowedElement(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationRequestDispenseRequestComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasExpectedSupplyDuration()) {
      composeDuration(t, "MedicationRequestDispenseRequestComponent", "expectedSupplyDuration", element.getExpectedSupplyDuration(), -1);
    }
    if (element.hasDispenser()) {
      composeReference(t, "MedicationRequestDispenseRequestComponent", "dispenser", element.getDispenser(), -1);
    }
    for (int i = 0; i < element.getDispenserInstruction().size(); i++) {
      composeAnnotation(t, "MedicationRequestDispenseRequestComponent", "dispenserInstruction", element.getDispenserInstruction().get(i), i);
    }
    if (element.hasDoseAdministrationAid()) {
      composeCodeableConcept(t, "MedicationRequestDispenseRequestComponent", "doseAdministrationAid", element.getDoseAdministrationAid(), -1);
    }
  }

  protected void composeMedicationRequestDispenseRequestInitialFillComponent(Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "initialFill", name, element, index);
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationRequestDispenseRequestInitialFillComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasDuration()) {
      composeDuration(t, "MedicationRequestDispenseRequestInitialFillComponent", "duration", element.getDuration(), -1);
    }
  }

  protected void composeMedicationRequestSubstitutionComponent(Complex parent, String parentType, String name, MedicationRequest.MedicationRequestSubstitutionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "substitution", name, element, index);
    if (element.hasAllowed()) {
      composeType(t, "MedicationRequestSubstitutionComponent", "allowed", element.getAllowed(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "MedicationRequestSubstitutionComponent", "reason", element.getReason(), -1);
    }
  }

  protected void composeMedicationUsage(Complex parent, String parentType, String name, MedicationUsage element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationUsage", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationUsage", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "MedicationUsage", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationUsage", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "MedicationUsage", "category", element.getCategory().get(i), i);
    }
    if (element.hasMedication()) {
      composeCodeableReference(t, "MedicationUsage", "medication", element.getMedication(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MedicationUsage", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "MedicationUsage", "encounter", element.getEncounter(), -1);
    }
    if (element.hasEffective()) {
      composeType(t, "MedicationUsage", "effective", element.getEffective(), -1);
    }
    if (element.hasDateAssertedElement()) {
      composeDateTime(t, "MedicationUsage", "dateAsserted", element.getDateAssertedElement(), -1);
    }
    for (int i = 0; i < element.getInformationSource().size(); i++) {
      composeReference(t, "MedicationUsage", "informationSource", element.getInformationSource().get(i), i);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeReference(t, "MedicationUsage", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "MedicationUsage", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationUsage", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getRelatedClinicalInformation().size(); i++) {
      composeReference(t, "MedicationUsage", "relatedClinicalInformation", element.getRelatedClinicalInformation().get(i), i);
    }
    if (element.hasRenderedDosageInstructionElement()) {
      composeString(t, "MedicationUsage", "renderedDosageInstruction", element.getRenderedDosageInstructionElement(), -1);
    }
    for (int i = 0; i < element.getDosage().size(); i++) {
      composeDosage(t, "MedicationUsage", "dosage", element.getDosage().get(i), i);
    }
    if (element.hasAdherence()) {
      composeMedicationUsageAdherenceComponent(t, "MedicationUsage", "adherence", element.getAdherence(), -1);
    }
  }

  protected void composeMedicationUsageAdherenceComponent(Complex parent, String parentType, String name, MedicationUsage.MedicationUsageAdherenceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "adherence", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MedicationUsageAdherenceComponent", "code", element.getCode(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "MedicationUsageAdherenceComponent", "reason", element.getReason(), -1);
    }
  }

  protected void composeMedicinalProductDefinition(Complex parent, String parentType, String name, MedicinalProductDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicinalProductDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicinalProductDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "type", element.getType(), -1);
    }
    if (element.hasDomain()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "domain", element.getDomain(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "MedicinalProductDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "status", element.getStatus(), -1);
    }
    if (element.hasStatusDateElement()) {
      composeDateTime(t, "MedicinalProductDefinition", "statusDate", element.getStatusDateElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "MedicinalProductDefinition", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCombinedPharmaceuticalDoseForm()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "combinedPharmaceuticalDoseForm", element.getCombinedPharmaceuticalDoseForm(), -1);
    }
    for (int i = 0; i < element.getRoute().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "route", element.getRoute().get(i), i);
    }
    if (element.hasIndicationElement()) {
      composeMarkdown(t, "MedicinalProductDefinition", "indication", element.getIndicationElement(), -1);
    }
    if (element.hasLegalStatusOfSupply()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
    }
    if (element.hasAdditionalMonitoringIndicator()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "additionalMonitoringIndicator", element.getAdditionalMonitoringIndicator(), -1);
    }
    for (int i = 0; i < element.getSpecialMeasures().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "specialMeasures", element.getSpecialMeasures().get(i), i);
    }
    if (element.hasPediatricUseIndicator()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "pediatricUseIndicator", element.getPediatricUseIndicator(), -1);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "classification", element.getClassification().get(i), i);
    }
    for (int i = 0; i < element.getMarketingStatus().size(); i++) {
      composeMarketingStatus(t, "MedicinalProductDefinition", "marketingStatus", element.getMarketingStatus().get(i), i);
    }
    for (int i = 0; i < element.getPackagedMedicinalProduct().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "packagedMedicinalProduct", element.getPackagedMedicinalProduct().get(i), i);
    }
    for (int i = 0; i < element.getComprisedOf().size(); i++) {
      composeReference(t, "MedicinalProductDefinition", "comprisedOf", element.getComprisedOf().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "ingredient", element.getIngredient().get(i), i);
    }
    for (int i = 0; i < element.getImpurity().size(); i++) {
      composeCodeableReference(t, "MedicinalProductDefinition", "impurity", element.getImpurity().get(i), i);
    }
    for (int i = 0; i < element.getAttachedDocument().size(); i++) {
      composeReference(t, "MedicinalProductDefinition", "attachedDocument", element.getAttachedDocument().get(i), i);
    }
    for (int i = 0; i < element.getMasterFile().size(); i++) {
      composeReference(t, "MedicinalProductDefinition", "masterFile", element.getMasterFile().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeMedicinalProductDefinitionContactComponent(t, "MedicinalProductDefinition", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getClinicalTrial().size(); i++) {
      composeReference(t, "MedicinalProductDefinition", "clinicalTrial", element.getClinicalTrial().get(i), i);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "MedicinalProductDefinition", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeMedicinalProductDefinitionNameComponent(t, "MedicinalProductDefinition", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getCrossReference().size(); i++) {
      composeMedicinalProductDefinitionCrossReferenceComponent(t, "MedicinalProductDefinition", "crossReference", element.getCrossReference().get(i), i);
    }
    for (int i = 0; i < element.getOperation().size(); i++) {
      composeMedicinalProductDefinitionOperationComponent(t, "MedicinalProductDefinition", "operation", element.getOperation().get(i), i);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeMedicinalProductDefinitionCharacteristicComponent(t, "MedicinalProductDefinition", "characteristic", element.getCharacteristic().get(i), i);
    }
  }

  protected void composeMedicinalProductDefinitionContactComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionContactComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contact", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionContactComponent", "type", element.getType(), -1);
    }
    if (element.hasContact()) {
      composeReference(t, "MedicinalProductDefinitionContactComponent", "contact", element.getContact(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionNameComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "name", name, element, index);
    if (element.hasProductNameElement()) {
      composeString(t, "MedicinalProductDefinitionNameComponent", "productName", element.getProductNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getPart().size(); i++) {
      composeMedicinalProductDefinitionNamePartComponent(t, "MedicinalProductDefinitionNameComponent", "part", element.getPart().get(i), i);
    }
    for (int i = 0; i < element.getUsage().size(); i++) {
      composeMedicinalProductDefinitionNameUsageComponent(t, "MedicinalProductDefinitionNameComponent", "usage", element.getUsage().get(i), i);
    }
  }

  protected void composeMedicinalProductDefinitionNamePartComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNamePartComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "part", name, element, index);
    if (element.hasPartElement()) {
      composeString(t, "MedicinalProductDefinitionNamePartComponent", "part", element.getPartElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNamePartComponent", "type", element.getType(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionNameUsageComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameUsageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "usage", name, element, index);
    if (element.hasCountry()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameUsageComponent", "country", element.getCountry(), -1);
    }
    if (element.hasJurisdiction()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameUsageComponent", "jurisdiction", element.getJurisdiction(), -1);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameUsageComponent", "language", element.getLanguage(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionCrossReferenceComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "crossReference", name, element, index);
    if (element.hasProduct()) {
      composeCodeableReference(t, "MedicinalProductDefinitionCrossReferenceComponent", "product", element.getProduct(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionCrossReferenceComponent", "type", element.getType(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionOperationComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasType()) {
      composeCodeableReference(t, "MedicinalProductDefinitionOperationComponent", "type", element.getType(), -1);
    }
    if (element.hasEffectiveDate()) {
      composePeriod(t, "MedicinalProductDefinitionOperationComponent", "effectiveDate", element.getEffectiveDate(), -1);
    }
    for (int i = 0; i < element.getOrganization().size(); i++) {
      composeReference(t, "MedicinalProductDefinitionOperationComponent", "organization", element.getOrganization().get(i), i);
    }
    if (element.hasConfidentialityIndicator()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionOperationComponent", "confidentialityIndicator", element.getConfidentialityIndicator(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionCharacteristicComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionCharacteristicComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "MedicinalProductDefinitionCharacteristicComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMessageDefinition(Complex parent, String parentType, String name, MessageDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "MessageDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "MessageDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MessageDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "MessageDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "MessageDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "MessageDefinition", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeCanonical(t, "MessageDefinition", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MessageDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "MessageDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "MessageDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "MessageDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "MessageDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "MessageDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "MessageDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "MessageDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "MessageDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "MessageDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasBaseElement()) {
      composeCanonical(t, "MessageDefinition", "base", element.getBaseElement(), -1);
    }
    for (int i = 0; i < element.getParent().size(); i++) {
      composeCanonical(t, "MessageDefinition", "parent", element.getParent().get(i), i);
    }
    if (element.hasEvent()) {
      composeType(t, "MessageDefinition", "event", element.getEvent(), -1);
    }
    if (element.hasCategoryElement()) {
      composeEnum(t, "MessageDefinition", "category", element.getCategoryElement(), -1);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeMessageDefinitionFocusComponent(t, "MessageDefinition", "focus", element.getFocus().get(i), i);
    }
    if (element.hasResponseRequiredElement()) {
      composeEnum(t, "MessageDefinition", "responseRequired", element.getResponseRequiredElement(), -1);
    }
    for (int i = 0; i < element.getAllowedResponse().size(); i++) {
      composeMessageDefinitionAllowedResponseComponent(t, "MessageDefinition", "allowedResponse", element.getAllowedResponse().get(i), i);
    }
    if (element.hasGraphElement()) {
      composeCanonical(t, "MessageDefinition", "graph", element.getGraphElement(), -1);
    }
  }

  protected void composeMessageDefinitionFocusComponent(Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionFocusComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "focus", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "MessageDefinitionFocusComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "MessageDefinitionFocusComponent", "profile", element.getProfileElement(), -1);
    }
    if (element.hasMinElement()) {
      composeUnsignedInt(t, "MessageDefinitionFocusComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "MessageDefinitionFocusComponent", "max", element.getMaxElement(), -1);
    }
  }

  protected void composeMessageDefinitionAllowedResponseComponent(Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionAllowedResponseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "allowedResponse", name, element, index);
    if (element.hasMessageElement()) {
      composeCanonical(t, "MessageDefinitionAllowedResponseComponent", "message", element.getMessageElement(), -1);
    }
    if (element.hasSituationElement()) {
      composeMarkdown(t, "MessageDefinitionAllowedResponseComponent", "situation", element.getSituationElement(), -1);
    }
  }

  protected void composeMessageHeader(Complex parent, String parentType, String name, MessageHeader element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MessageHeader", name, element, index);
    if (element.hasEvent()) {
      composeType(t, "MessageHeader", "event", element.getEvent(), -1);
    }
    for (int i = 0; i < element.getDestination().size(); i++) {
      composeMessageHeaderMessageDestinationComponent(t, "MessageHeader", "destination", element.getDestination().get(i), i);
    }
    if (element.hasSender()) {
      composeReference(t, "MessageHeader", "sender", element.getSender(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "MessageHeader", "enterer", element.getEnterer(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "MessageHeader", "author", element.getAuthor(), -1);
    }
    if (element.hasSource()) {
      composeMessageHeaderMessageSourceComponent(t, "MessageHeader", "source", element.getSource(), -1);
    }
    if (element.hasResponsible()) {
      composeReference(t, "MessageHeader", "responsible", element.getResponsible(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "MessageHeader", "reason", element.getReason(), -1);
    }
    if (element.hasResponse()) {
      composeMessageHeaderResponseComponent(t, "MessageHeader", "response", element.getResponse(), -1);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeReference(t, "MessageHeader", "focus", element.getFocus().get(i), i);
    }
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "MessageHeader", "definition", element.getDefinitionElement(), -1);
    }
  }

  protected void composeMessageHeaderMessageDestinationComponent(Complex parent, String parentType, String name, MessageHeader.MessageDestinationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "destination", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "MessageDestinationComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTarget()) {
      composeReference(t, "MessageDestinationComponent", "target", element.getTarget(), -1);
    }
    if (element.hasEndpointElement()) {
      composeUrl(t, "MessageDestinationComponent", "endpoint", element.getEndpointElement(), -1);
    }
    if (element.hasReceiver()) {
      composeReference(t, "MessageDestinationComponent", "receiver", element.getReceiver(), -1);
    }
  }

  protected void composeMessageHeaderMessageSourceComponent(Complex parent, String parentType, String name, MessageHeader.MessageSourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "source", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "MessageSourceComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasSoftwareElement()) {
      composeString(t, "MessageSourceComponent", "software", element.getSoftwareElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "MessageSourceComponent", "version", element.getVersionElement(), -1);
    }
    if (element.hasContact()) {
      composeContactPoint(t, "MessageSourceComponent", "contact", element.getContact(), -1);
    }
    if (element.hasEndpointElement()) {
      composeUrl(t, "MessageSourceComponent", "endpoint", element.getEndpointElement(), -1);
    }
  }

  protected void composeMessageHeaderResponseComponent(Complex parent, String parentType, String name, MessageHeader.MessageHeaderResponseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "response", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "MessageHeaderResponseComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasCodeElement()) {
      composeEnum(t, "MessageHeaderResponseComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDetails()) {
      composeReference(t, "MessageHeaderResponseComponent", "details", element.getDetails(), -1);
    }
  }

  protected void composeMolecularSequence(Complex parent, String parentType, String name, MolecularSequence element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MolecularSequence", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MolecularSequence", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "MolecularSequence", "type", element.getTypeElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MolecularSequence", "subject", element.getSubject(), -1);
    }
    if (element.hasSpecimen()) {
      composeReference(t, "MolecularSequence", "specimen", element.getSpecimen(), -1);
    }
    if (element.hasDevice()) {
      composeReference(t, "MolecularSequence", "device", element.getDevice(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "MolecularSequence", "performer", element.getPerformer(), -1);
    }
    if (element.hasLiteralElement()) {
      composeString(t, "MolecularSequence", "literal", element.getLiteralElement(), -1);
    }
    for (int i = 0; i < element.getFormatted().size(); i++) {
      composeAttachment(t, "MolecularSequence", "formatted", element.getFormatted().get(i), i);
    }
    for (int i = 0; i < element.getRelative().size(); i++) {
      composeMolecularSequenceRelativeComponent(t, "MolecularSequence", "relative", element.getRelative().get(i), i);
    }
  }

  protected void composeMolecularSequenceRelativeComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRelativeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relative", name, element, index);
    if (element.hasCoordinateSystem()) {
      composeCodeableConcept(t, "MolecularSequenceRelativeComponent", "coordinateSystem", element.getCoordinateSystem(), -1);
    }
    if (element.hasOrdinalPositionElement()) {
      composeInteger(t, "MolecularSequenceRelativeComponent", "ordinalPosition", element.getOrdinalPositionElement(), -1);
    }
    if (element.hasSequenceRange()) {
      composeRange(t, "MolecularSequenceRelativeComponent", "sequenceRange", element.getSequenceRange(), -1);
    }
    if (element.hasStartingSequence()) {
      composeMolecularSequenceRelativeStartingSequenceComponent(t, "MolecularSequenceRelativeComponent", "startingSequence", element.getStartingSequence(), -1);
    }
    for (int i = 0; i < element.getEdit().size(); i++) {
      composeMolecularSequenceRelativeEditComponent(t, "MolecularSequenceRelativeComponent", "edit", element.getEdit().get(i), i);
    }
  }

  protected void composeMolecularSequenceRelativeStartingSequenceComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRelativeStartingSequenceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "startingSequence", name, element, index);
    if (element.hasGenomeAssembly()) {
      composeCodeableConcept(t, "MolecularSequenceRelativeStartingSequenceComponent", "genomeAssembly", element.getGenomeAssembly(), -1);
    }
    if (element.hasChromosome()) {
      composeCodeableConcept(t, "MolecularSequenceRelativeStartingSequenceComponent", "chromosome", element.getChromosome(), -1);
    }
    if (element.hasSequence()) {
      composeType(t, "MolecularSequenceRelativeStartingSequenceComponent", "sequence", element.getSequence(), -1);
    }
    if (element.hasWindowStartElement()) {
      composeInteger(t, "MolecularSequenceRelativeStartingSequenceComponent", "windowStart", element.getWindowStartElement(), -1);
    }
    if (element.hasWindowEndElement()) {
      composeInteger(t, "MolecularSequenceRelativeStartingSequenceComponent", "windowEnd", element.getWindowEndElement(), -1);
    }
    if (element.hasOrientationElement()) {
      composeEnum(t, "MolecularSequenceRelativeStartingSequenceComponent", "orientation", element.getOrientationElement(), -1);
    }
    if (element.hasStrandElement()) {
      composeEnum(t, "MolecularSequenceRelativeStartingSequenceComponent", "strand", element.getStrandElement(), -1);
    }
  }

  protected void composeMolecularSequenceRelativeEditComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRelativeEditComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "edit", name, element, index);
    if (element.hasStartElement()) {
      composeInteger(t, "MolecularSequenceRelativeEditComponent", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInteger(t, "MolecularSequenceRelativeEditComponent", "end", element.getEndElement(), -1);
    }
    if (element.hasReplacementSequenceElement()) {
      composeString(t, "MolecularSequenceRelativeEditComponent", "replacementSequence", element.getReplacementSequenceElement(), -1);
    }
    if (element.hasReplacedSequenceElement()) {
      composeString(t, "MolecularSequenceRelativeEditComponent", "replacedSequence", element.getReplacedSequenceElement(), -1);
    }
  }

  protected void composeNamingSystem(Complex parent, String parentType, String name, NamingSystem element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "NamingSystem", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "NamingSystem", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "NamingSystem", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "NamingSystem", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "NamingSystem", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "NamingSystem", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "NamingSystem", "status", element.getStatusElement(), -1);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "NamingSystem", "kind", element.getKindElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "NamingSystem", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "NamingSystem", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "NamingSystem", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "NamingSystem", "contact", element.getContact().get(i), i);
    }
    if (element.hasResponsibleElement()) {
      composeString(t, "NamingSystem", "responsible", element.getResponsibleElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "NamingSystem", "type", element.getType(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "NamingSystem", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "NamingSystem", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "NamingSystem", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "NamingSystem", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "NamingSystem", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "NamingSystem", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "NamingSystem", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "NamingSystem", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "NamingSystem", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "NamingSystem", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "NamingSystem", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "NamingSystem", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "NamingSystem", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "NamingSystem", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasUsageElement()) {
      composeString(t, "NamingSystem", "usage", element.getUsageElement(), -1);
    }
    for (int i = 0; i < element.getUniqueId().size(); i++) {
      composeNamingSystemUniqueIdComponent(t, "NamingSystem", "uniqueId", element.getUniqueId().get(i), i);
    }
  }

  protected void composeNamingSystemUniqueIdComponent(Complex parent, String parentType, String name, NamingSystem.NamingSystemUniqueIdComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "uniqueId", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "NamingSystemUniqueIdComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "NamingSystemUniqueIdComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasPreferredElement()) {
      composeBoolean(t, "NamingSystemUniqueIdComponent", "preferred", element.getPreferredElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "NamingSystemUniqueIdComponent", "comment", element.getCommentElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "NamingSystemUniqueIdComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasAuthoritativeElement()) {
      composeBoolean(t, "NamingSystemUniqueIdComponent", "authoritative", element.getAuthoritativeElement(), -1);
    }
  }

  protected void composeNutritionIntake(Complex parent, String parentType, String name, NutritionIntake element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "NutritionIntake", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "NutritionIntake", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "NutritionIntake", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "NutritionIntake", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "NutritionIntake", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "NutritionIntake", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "NutritionIntake", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusReason().size(); i++) {
      composeCodeableConcept(t, "NutritionIntake", "statusReason", element.getStatusReason().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "NutritionIntake", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "NutritionIntake", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "NutritionIntake", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "NutritionIntake", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasRecordedElement()) {
      composeDateTime(t, "NutritionIntake", "recorded", element.getRecordedElement(), -1);
    }
    if (element.hasReported()) {
      composeType(t, "NutritionIntake", "reported", element.getReported(), -1);
    }
    for (int i = 0; i < element.getConsumedItem().size(); i++) {
      composeNutritionIntakeConsumedItemComponent(t, "NutritionIntake", "consumedItem", element.getConsumedItem().get(i), i);
    }
    for (int i = 0; i < element.getIngredientLabel().size(); i++) {
      composeNutritionIntakeIngredientLabelComponent(t, "NutritionIntake", "ingredientLabel", element.getIngredientLabel().get(i), i);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeNutritionIntakePerformerComponent(t, "NutritionIntake", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "NutritionIntake", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeReference(t, "NutritionIntake", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "NutritionIntake", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "NutritionIntake", "note", element.getNote().get(i), i);
    }
  }

  protected void composeNutritionIntakeConsumedItemComponent(Complex parent, String parentType, String name, NutritionIntake.NutritionIntakeConsumedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "consumedItem", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "NutritionIntakeConsumedItemComponent", "type", element.getType(), -1);
    }
    if (element.hasNutritionProduct()) {
      composeCodeableReference(t, "NutritionIntakeConsumedItemComponent", "nutritionProduct", element.getNutritionProduct(), -1);
    }
    if (element.hasSchedule()) {
      composeTiming(t, "NutritionIntakeConsumedItemComponent", "schedule", element.getSchedule(), -1);
    }
    if (element.hasAmount()) {
      composeQuantity(t, "NutritionIntakeConsumedItemComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasRate()) {
      composeQuantity(t, "NutritionIntakeConsumedItemComponent", "rate", element.getRate(), -1);
    }
    if (element.hasNotConsumedElement()) {
      composeBoolean(t, "NutritionIntakeConsumedItemComponent", "notConsumed", element.getNotConsumedElement(), -1);
    }
    if (element.hasNotConsumedReason()) {
      composeCodeableConcept(t, "NutritionIntakeConsumedItemComponent", "notConsumedReason", element.getNotConsumedReason(), -1);
    }
  }

  protected void composeNutritionIntakeIngredientLabelComponent(Complex parent, String parentType, String name, NutritionIntake.NutritionIntakeIngredientLabelComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "ingredientLabel", name, element, index);
    if (element.hasNutrient()) {
      composeCodeableReference(t, "NutritionIntakeIngredientLabelComponent", "nutrient", element.getNutrient(), -1);
    }
    if (element.hasAmount()) {
      composeQuantity(t, "NutritionIntakeIngredientLabelComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeNutritionIntakePerformerComponent(Complex parent, String parentType, String name, NutritionIntake.NutritionIntakePerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "NutritionIntakePerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "NutritionIntakePerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeNutritionOrder(Complex parent, String parentType, String name, NutritionOrder element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "NutritionOrder", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "NutritionOrder", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "NutritionOrder", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "NutritionOrder", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getInstantiates().size(); i++) {
      composeUri(t, "NutritionOrder", "instantiates", element.getInstantiates().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "NutritionOrder", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "NutritionOrder", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "NutritionOrder", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeCode(t, "NutritionOrder", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "NutritionOrder", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "NutritionOrder", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "NutritionOrder", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    if (element.hasDateTimeElement()) {
      composeDateTime(t, "NutritionOrder", "dateTime", element.getDateTimeElement(), -1);
    }
    if (element.hasOrderer()) {
      composeReference(t, "NutritionOrder", "orderer", element.getOrderer(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeCodeableReference(t, "NutritionOrder", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getAllergyIntolerance().size(); i++) {
      composeReference(t, "NutritionOrder", "allergyIntolerance", element.getAllergyIntolerance().get(i), i);
    }
    for (int i = 0; i < element.getFoodPreferenceModifier().size(); i++) {
      composeCodeableConcept(t, "NutritionOrder", "foodPreferenceModifier", element.getFoodPreferenceModifier().get(i), i);
    }
    for (int i = 0; i < element.getExcludeFoodModifier().size(); i++) {
      composeCodeableConcept(t, "NutritionOrder", "excludeFoodModifier", element.getExcludeFoodModifier().get(i), i);
    }
    if (element.hasOutsideFoodAllowedElement()) {
      composeBoolean(t, "NutritionOrder", "outsideFoodAllowed", element.getOutsideFoodAllowedElement(), -1);
    }
    if (element.hasOralDiet()) {
      composeNutritionOrderOralDietComponent(t, "NutritionOrder", "oralDiet", element.getOralDiet(), -1);
    }
    for (int i = 0; i < element.getSupplement().size(); i++) {
      composeNutritionOrderSupplementComponent(t, "NutritionOrder", "supplement", element.getSupplement().get(i), i);
    }
    if (element.hasEnteralFormula()) {
      composeNutritionOrderEnteralFormulaComponent(t, "NutritionOrder", "enteralFormula", element.getEnteralFormula(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "NutritionOrder", "note", element.getNote().get(i), i);
    }
  }

  protected void composeNutritionOrderOralDietComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "oralDiet", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "NutritionOrderOralDietComponent", "type", element.getType().get(i), i);
    }
    if (element.hasSchedule()) {
      composeNutritionOrderOralDietScheduleComponent(t, "NutritionOrderOralDietComponent", "schedule", element.getSchedule(), -1);
    }
    for (int i = 0; i < element.getNutrient().size(); i++) {
      composeNutritionOrderOralDietNutrientComponent(t, "NutritionOrderOralDietComponent", "nutrient", element.getNutrient().get(i), i);
    }
    for (int i = 0; i < element.getTexture().size(); i++) {
      composeNutritionOrderOralDietTextureComponent(t, "NutritionOrderOralDietComponent", "texture", element.getTexture().get(i), i);
    }
    for (int i = 0; i < element.getFluidConsistencyType().size(); i++) {
      composeCodeableConcept(t, "NutritionOrderOralDietComponent", "fluidConsistencyType", element.getFluidConsistencyType().get(i), i);
    }
    if (element.hasInstructionElement()) {
      composeString(t, "NutritionOrderOralDietComponent", "instruction", element.getInstructionElement(), -1);
    }
  }

  protected void composeNutritionOrderOralDietScheduleComponent(Complex parent, String parentType, String name, NutritionOrder.OralDietScheduleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "schedule", name, element, index);
    for (int i = 0; i < element.getTiming().size(); i++) {
      composeTiming(t, "OralDietScheduleComponent", "timing", element.getTiming().get(i), i);
    }
    if (element.hasAsNeededElement()) {
      composeBoolean(t, "OralDietScheduleComponent", "asNeeded", element.getAsNeededElement(), -1);
    }
    if (element.hasAsNeededFor()) {
      composeCodeableConcept(t, "OralDietScheduleComponent", "asNeededFor", element.getAsNeededFor(), -1);
    }
  }

  protected void composeNutritionOrderOralDietNutrientComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietNutrientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "nutrient", name, element, index);
    if (element.hasModifier()) {
      composeCodeableConcept(t, "NutritionOrderOralDietNutrientComponent", "modifier", element.getModifier(), -1);
    }
    if (element.hasAmount()) {
      composeQuantity(t, "NutritionOrderOralDietNutrientComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeNutritionOrderOralDietTextureComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietTextureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "texture", name, element, index);
    if (element.hasModifier()) {
      composeCodeableConcept(t, "NutritionOrderOralDietTextureComponent", "modifier", element.getModifier(), -1);
    }
    if (element.hasFoodType()) {
      composeCodeableConcept(t, "NutritionOrderOralDietTextureComponent", "foodType", element.getFoodType(), -1);
    }
  }

  protected void composeNutritionOrderSupplementComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderSupplementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supplement", name, element, index);
    if (element.hasType()) {
      composeCodeableReference(t, "NutritionOrderSupplementComponent", "type", element.getType(), -1);
    }
    if (element.hasProductNameElement()) {
      composeString(t, "NutritionOrderSupplementComponent", "productName", element.getProductNameElement(), -1);
    }
    if (element.hasSchedule()) {
      composeNutritionOrderSupplementScheduleComponent(t, "NutritionOrderSupplementComponent", "schedule", element.getSchedule(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "NutritionOrderSupplementComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasInstructionElement()) {
      composeString(t, "NutritionOrderSupplementComponent", "instruction", element.getInstructionElement(), -1);
    }
  }

  protected void composeNutritionOrderSupplementScheduleComponent(Complex parent, String parentType, String name, NutritionOrder.SupplementScheduleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "schedule", name, element, index);
    for (int i = 0; i < element.getTiming().size(); i++) {
      composeTiming(t, "SupplementScheduleComponent", "timing", element.getTiming().get(i), i);
    }
    if (element.hasAsNeededElement()) {
      composeBoolean(t, "SupplementScheduleComponent", "asNeeded", element.getAsNeededElement(), -1);
    }
    if (element.hasAsNeededFor()) {
      composeCodeableConcept(t, "SupplementScheduleComponent", "asNeededFor", element.getAsNeededFor(), -1);
    }
  }

  protected void composeNutritionOrderEnteralFormulaComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "enteralFormula", name, element, index);
    if (element.hasBaseFormulaType()) {
      composeCodeableReference(t, "NutritionOrderEnteralFormulaComponent", "baseFormulaType", element.getBaseFormulaType(), -1);
    }
    if (element.hasBaseFormulaProductNameElement()) {
      composeString(t, "NutritionOrderEnteralFormulaComponent", "baseFormulaProductName", element.getBaseFormulaProductNameElement(), -1);
    }
    for (int i = 0; i < element.getDeliveryDevice().size(); i++) {
      composeCodeableReference(t, "NutritionOrderEnteralFormulaComponent", "deliveryDevice", element.getDeliveryDevice().get(i), i);
    }
    for (int i = 0; i < element.getAdditive().size(); i++) {
      composeNutritionOrderEnteralFormulaAdditiveComponent(t, "NutritionOrderEnteralFormulaComponent", "additive", element.getAdditive().get(i), i);
    }
    if (element.hasCaloricDensity()) {
      composeQuantity(t, "NutritionOrderEnteralFormulaComponent", "caloricDensity", element.getCaloricDensity(), -1);
    }
    if (element.hasRouteOfAdministration()) {
      composeCodeableConcept(t, "NutritionOrderEnteralFormulaComponent", "routeOfAdministration", element.getRouteOfAdministration(), -1);
    }
    for (int i = 0; i < element.getAdministration().size(); i++) {
      composeNutritionOrderEnteralFormulaAdministrationComponent(t, "NutritionOrderEnteralFormulaComponent", "administration", element.getAdministration().get(i), i);
    }
    if (element.hasMaxVolumeToDeliver()) {
      composeQuantity(t, "NutritionOrderEnteralFormulaComponent", "maxVolumeToDeliver", element.getMaxVolumeToDeliver(), -1);
    }
    if (element.hasAdministrationInstructionElement()) {
      composeString(t, "NutritionOrderEnteralFormulaComponent", "administrationInstruction", element.getAdministrationInstructionElement(), -1);
    }
  }

  protected void composeNutritionOrderEnteralFormulaAdditiveComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdditiveComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "additive", name, element, index);
    if (element.hasType()) {
      composeCodeableReference(t, "NutritionOrderEnteralFormulaAdditiveComponent", "type", element.getType(), -1);
    }
    if (element.hasProductNameElement()) {
      composeString(t, "NutritionOrderEnteralFormulaAdditiveComponent", "productName", element.getProductNameElement(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "NutritionOrderEnteralFormulaAdditiveComponent", "quantity", element.getQuantity(), -1);
    }
  }

  protected void composeNutritionOrderEnteralFormulaAdministrationComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "administration", name, element, index);
    if (element.hasSchedule()) {
      composeNutritionOrderEnteralFormulaScheduleComponent(t, "NutritionOrderEnteralFormulaAdministrationComponent", "schedule", element.getSchedule(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "NutritionOrderEnteralFormulaAdministrationComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasRate()) {
      composeType(t, "NutritionOrderEnteralFormulaAdministrationComponent", "rate", element.getRate(), -1);
    }
  }

  protected void composeNutritionOrderEnteralFormulaScheduleComponent(Complex parent, String parentType, String name, NutritionOrder.EnteralFormulaScheduleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "schedule", name, element, index);
    for (int i = 0; i < element.getTiming().size(); i++) {
      composeTiming(t, "EnteralFormulaScheduleComponent", "timing", element.getTiming().get(i), i);
    }
    if (element.hasAsNeededElement()) {
      composeBoolean(t, "EnteralFormulaScheduleComponent", "asNeeded", element.getAsNeededElement(), -1);
    }
    if (element.hasAsNeededFor()) {
      composeCodeableConcept(t, "EnteralFormulaScheduleComponent", "asNeededFor", element.getAsNeededFor(), -1);
    }
  }

  protected void composeNutritionProduct(Complex parent, String parentType, String name, NutritionProduct element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "NutritionProduct", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "NutritionProduct", "code", element.getCode(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "NutritionProduct", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "NutritionProduct", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "NutritionProduct", "manufacturer", element.getManufacturer().get(i), i);
    }
    for (int i = 0; i < element.getNutrient().size(); i++) {
      composeNutritionProductNutrientComponent(t, "NutritionProduct", "nutrient", element.getNutrient().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeNutritionProductIngredientComponent(t, "NutritionProduct", "ingredient", element.getIngredient().get(i), i);
    }
    for (int i = 0; i < element.getKnownAllergen().size(); i++) {
      composeCodeableReference(t, "NutritionProduct", "knownAllergen", element.getKnownAllergen().get(i), i);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeNutritionProductCharacteristicComponent(t, "NutritionProduct", "characteristic", element.getCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeNutritionProductInstanceComponent(t, "NutritionProduct", "instance", element.getInstance().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "NutritionProduct", "note", element.getNote().get(i), i);
    }
  }

  protected void composeNutritionProductNutrientComponent(Complex parent, String parentType, String name, NutritionProduct.NutritionProductNutrientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "nutrient", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "NutritionProductNutrientComponent", "item", element.getItem(), -1);
    }
    for (int i = 0; i < element.getAmount().size(); i++) {
      composeRatio(t, "NutritionProductNutrientComponent", "amount", element.getAmount().get(i), i);
    }
  }

  protected void composeNutritionProductIngredientComponent(Complex parent, String parentType, String name, NutritionProduct.NutritionProductIngredientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "ingredient", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "NutritionProductIngredientComponent", "item", element.getItem(), -1);
    }
    for (int i = 0; i < element.getAmount().size(); i++) {
      composeRatio(t, "NutritionProductIngredientComponent", "amount", element.getAmount().get(i), i);
    }
  }

  protected void composeNutritionProductCharacteristicComponent(Complex parent, String parentType, String name, NutritionProduct.NutritionProductCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "NutritionProductCharacteristicComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "NutritionProductCharacteristicComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeNutritionProductInstanceComponent(Complex parent, String parentType, String name, NutritionProduct.NutritionProductInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "instance", name, element, index);
    if (element.hasQuantity()) {
      composeQuantity(t, "NutritionProductInstanceComponent", "quantity", element.getQuantity(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "NutritionProductInstanceComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "NutritionProductInstanceComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasLotNumberElement()) {
      composeString(t, "NutritionProductInstanceComponent", "lotNumber", element.getLotNumberElement(), -1);
    }
    if (element.hasExpiryElement()) {
      composeDateTime(t, "NutritionProductInstanceComponent", "expiry", element.getExpiryElement(), -1);
    }
    if (element.hasUseByElement()) {
      composeDateTime(t, "NutritionProductInstanceComponent", "useBy", element.getUseByElement(), -1);
    }
    if (element.hasBiologicalSourceEvent()) {
      composeIdentifier(t, "NutritionProductInstanceComponent", "biologicalSourceEvent", element.getBiologicalSourceEvent(), -1);
    }
  }

  protected void composeObservation(Complex parent, String parentType, String name, Observation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Observation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Observation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasInstantiates()) {
      composeType(t, "Observation", "instantiates", element.getInstantiates(), -1);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Observation", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getTriggeredBy().size(); i++) {
      composeObservationTriggeredByComponent(t, "Observation", "triggeredBy", element.getTriggeredBy().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "Observation", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Observation", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Observation", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Observation", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeReference(t, "Observation", "focus", element.getFocus().get(i), i);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Observation", "encounter", element.getEncounter(), -1);
    }
    if (element.hasEffective()) {
      composeType(t, "Observation", "effective", element.getEffective(), -1);
    }
    if (element.hasIssuedElement()) {
      composeInstant(t, "Observation", "issued", element.getIssuedElement(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "Observation", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasValue()) {
      composeType(t, "Observation", "value", element.getValue(), -1);
    }
    if (element.hasDataAbsentReason()) {
      composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
    }
    for (int i = 0; i < element.getInterpretation().size(); i++) {
      composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Observation", "note", element.getNote().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "Observation", "bodySite", element.getBodySite(), -1);
    }
    if (element.hasBodyStructure()) {
      composeReference(t, "Observation", "bodyStructure", element.getBodyStructure(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "Observation", "method", element.getMethod(), -1);
    }
    if (element.hasSpecimen()) {
      composeReference(t, "Observation", "specimen", element.getSpecimen(), -1);
    }
    if (element.hasDevice()) {
      composeReference(t, "Observation", "device", element.getDevice(), -1);
    }
    for (int i = 0; i < element.getReferenceRange().size(); i++) {
      composeObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
    }
    for (int i = 0; i < element.getHasMember().size(); i++) {
      composeReference(t, "Observation", "hasMember", element.getHasMember().get(i), i);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeReference(t, "Observation", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeObservationComponentComponent(t, "Observation", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeObservationTriggeredByComponent(Complex parent, String parentType, String name, Observation.ObservationTriggeredByComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "triggeredBy", name, element, index);
    if (element.hasObservation()) {
      composeReference(t, "ObservationTriggeredByComponent", "observation", element.getObservation(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ObservationTriggeredByComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasReasonElement()) {
      composeString(t, "ObservationTriggeredByComponent", "reason", element.getReasonElement(), -1);
    }
  }

  protected void composeObservationReferenceRangeComponent(Complex parent, String parentType, String name, Observation.ObservationReferenceRangeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "referenceRange", name, element, index);
    if (element.hasLow()) {
      composeQuantity(t, "ObservationReferenceRangeComponent", "low", element.getLow(), -1);
    }
    if (element.hasHigh()) {
      composeQuantity(t, "ObservationReferenceRangeComponent", "high", element.getHigh(), -1);
    }
    if (element.hasNormalValue()) {
      composeCodeableConcept(t, "ObservationReferenceRangeComponent", "normalValue", element.getNormalValue(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ObservationReferenceRangeComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getAppliesTo().size(); i++) {
      composeCodeableConcept(t, "ObservationReferenceRangeComponent", "appliesTo", element.getAppliesTo().get(i), i);
    }
    if (element.hasAge()) {
      composeRange(t, "ObservationReferenceRangeComponent", "age", element.getAge(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "ObservationReferenceRangeComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composeObservationComponentComponent(Complex parent, String parentType, String name, Observation.ObservationComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "ObservationComponentComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ObservationComponentComponent", "value", element.getValue(), -1);
    }
    if (element.hasDataAbsentReason()) {
      composeCodeableConcept(t, "ObservationComponentComponent", "dataAbsentReason", element.getDataAbsentReason(), -1);
    }
    for (int i = 0; i < element.getInterpretation().size(); i++) {
      composeCodeableConcept(t, "ObservationComponentComponent", "interpretation", element.getInterpretation().get(i), i);
    }
    for (int i = 0; i < element.getReferenceRange().size(); i++) {
      composeObservationReferenceRangeComponent(t, "ObservationComponentComponent", "referenceRange", element.getReferenceRange().get(i), i);
    }
  }

  protected void composeObservationDefinition(Complex parent, String parentType, String name, ObservationDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ObservationDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ObservationDefinition", "url", element.getUrlElement(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "ObservationDefinition", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ObservationDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ObservationDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ObservationDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ObservationDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ObservationDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ObservationDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ObservationDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ObservationDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ObservationDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ObservationDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ObservationDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ObservationDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ObservationDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ObservationDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ObservationDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "ObservationDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getDerivedFromCanonical().size(); i++) {
      composeCanonical(t, "ObservationDefinition", "derivedFromCanonical", element.getDerivedFromCanonical().get(i), i);
    }
    for (int i = 0; i < element.getDerivedFromUri().size(); i++) {
      composeUri(t, "ObservationDefinition", "derivedFromUri", element.getDerivedFromUri().get(i), i);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeCodeableConcept(t, "ObservationDefinition", "subject", element.getSubject().get(i), i);
    }
    if (element.hasPerformerType()) {
      composeCodeableConcept(t, "ObservationDefinition", "performerType", element.getPerformerType(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "ObservationDefinition", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ObservationDefinition", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getPermittedDataType().size(); i++) {
      composeEnum(t, "ObservationDefinition", "permittedDataType", element.getPermittedDataType().get(i), i);
    }
    if (element.hasMultipleResultsAllowedElement()) {
      composeBoolean(t, "ObservationDefinition", "multipleResultsAllowed", element.getMultipleResultsAllowedElement(), -1);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "ObservationDefinition", "bodySite", element.getBodySite(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "ObservationDefinition", "method", element.getMethod(), -1);
    }
    for (int i = 0; i < element.getSpecimen().size(); i++) {
      composeReference(t, "ObservationDefinition", "specimen", element.getSpecimen().get(i), i);
    }
    for (int i = 0; i < element.getDevice().size(); i++) {
      composeReference(t, "ObservationDefinition", "device", element.getDevice().get(i), i);
    }
    if (element.hasPreferredReportNameElement()) {
      composeString(t, "ObservationDefinition", "preferredReportName", element.getPreferredReportNameElement(), -1);
    }
    if (element.hasQuantitativeDetails()) {
      composeObservationDefinitionQuantitativeDetailsComponent(t, "ObservationDefinition", "quantitativeDetails", element.getQuantitativeDetails(), -1);
    }
    for (int i = 0; i < element.getQualifiedValue().size(); i++) {
      composeObservationDefinitionQualifiedValueComponent(t, "ObservationDefinition", "qualifiedValue", element.getQualifiedValue().get(i), i);
    }
    for (int i = 0; i < element.getHasMember().size(); i++) {
      composeReference(t, "ObservationDefinition", "hasMember", element.getHasMember().get(i), i);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeObservationDefinitionComponentComponent(t, "ObservationDefinition", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeObservationDefinitionQuantitativeDetailsComponent(Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "quantitativeDetails", name, element, index);
    if (element.hasUnit()) {
      composeCodeableConcept(t, "ObservationDefinitionQuantitativeDetailsComponent", "unit", element.getUnit(), -1);
    }
    if (element.hasCustomaryUnit()) {
      composeCodeableConcept(t, "ObservationDefinitionQuantitativeDetailsComponent", "customaryUnit", element.getCustomaryUnit(), -1);
    }
    if (element.hasConversionFactorElement()) {
      composeDecimal(t, "ObservationDefinitionQuantitativeDetailsComponent", "conversionFactor", element.getConversionFactorElement(), -1);
    }
    if (element.hasDecimalPrecisionElement()) {
      composeInteger(t, "ObservationDefinitionQuantitativeDetailsComponent", "decimalPrecision", element.getDecimalPrecisionElement(), -1);
    }
  }

  protected void composeObservationDefinitionQualifiedValueComponent(Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQualifiedValueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "qualifiedValue", name, element, index);
    if (element.hasContext()) {
      composeCodeableConcept(t, "ObservationDefinitionQualifiedValueComponent", "context", element.getContext(), -1);
    }
    for (int i = 0; i < element.getAppliesTo().size(); i++) {
      composeCodeableConcept(t, "ObservationDefinitionQualifiedValueComponent", "appliesTo", element.getAppliesTo().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "ObservationDefinitionQualifiedValueComponent", "gender", element.getGenderElement(), -1);
    }
    if (element.hasAge()) {
      composeRange(t, "ObservationDefinitionQualifiedValueComponent", "age", element.getAge(), -1);
    }
    if (element.hasGestationalAge()) {
      composeRange(t, "ObservationDefinitionQualifiedValueComponent", "gestationalAge", element.getGestationalAge(), -1);
    }
    if (element.hasConditionElement()) {
      composeString(t, "ObservationDefinitionQualifiedValueComponent", "condition", element.getConditionElement(), -1);
    }
    if (element.hasRangeCategoryElement()) {
      composeEnum(t, "ObservationDefinitionQualifiedValueComponent", "rangeCategory", element.getRangeCategoryElement(), -1);
    }
    if (element.hasRange()) {
      composeRange(t, "ObservationDefinitionQualifiedValueComponent", "range", element.getRange(), -1);
    }
    if (element.hasValidCodedValueSetElement()) {
      composeCanonical(t, "ObservationDefinitionQualifiedValueComponent", "validCodedValueSet", element.getValidCodedValueSetElement(), -1);
    }
    if (element.hasNormalCodedValueSetElement()) {
      composeCanonical(t, "ObservationDefinitionQualifiedValueComponent", "normalCodedValueSet", element.getNormalCodedValueSetElement(), -1);
    }
    if (element.hasAbnormalCodedValueSetElement()) {
      composeCanonical(t, "ObservationDefinitionQualifiedValueComponent", "abnormalCodedValueSet", element.getAbnormalCodedValueSetElement(), -1);
    }
    if (element.hasCriticalCodedValueSetElement()) {
      composeCanonical(t, "ObservationDefinitionQualifiedValueComponent", "criticalCodedValueSet", element.getCriticalCodedValueSetElement(), -1);
    }
  }

  protected void composeObservationDefinitionComponentComponent(Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "ObservationDefinitionComponentComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getPermittedDataType().size(); i++) {
      composeEnum(t, "ObservationDefinitionComponentComponent", "permittedDataType", element.getPermittedDataType().get(i), i);
    }
    if (element.hasQuantitativeDetails()) {
      composeObservationDefinitionQuantitativeDetailsComponent(t, "ObservationDefinitionComponentComponent", "quantitativeDetails", element.getQuantitativeDetails(), -1);
    }
    for (int i = 0; i < element.getQualifiedValue().size(); i++) {
      composeObservationDefinitionQualifiedValueComponent(t, "ObservationDefinitionComponentComponent", "qualifiedValue", element.getQualifiedValue().get(i), i);
    }
  }

  protected void composeOperationDefinition(Complex parent, String parentType, String name, OperationDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "OperationDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "OperationDefinition", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "OperationDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasVersionAlgorithm()) {
      composeType(t, "OperationDefinition", "versionAlgorithm", element.getVersionAlgorithm(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "OperationDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "OperationDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "OperationDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "OperationDefinition", "kind", element.getKindElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "OperationDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "OperationDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "OperationDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "OperationDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "OperationDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "OperationDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "OperationDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "OperationDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "OperationDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCopyrightLabelElement()) {
      composeString(t, "OperationDefinition", "copyrightLabel", element.getCopyrightLabelElement(), -1);
    }
    if (element.hasAffectsStateElement()) {
      composeBoolean(t, "OperationDefinition", "affectsState", element.getAffectsStateElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "OperationDefinition", "code", element.getCodeElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeMarkdown(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
    }
    if (element.hasBaseElement()) {
      composeCanonical(t, "OperationDefinition", "base", element.getBaseElement(), -1);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeCode(t, "OperationDefinition", "resource", element.getResource().get(i), i);
    }
    if (element.hasSystemElement()) {
      composeBoolean(t, "OperationDefinition", "system", element.getSystemElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeBoolean(t, "OperationDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasInstanceElement()) {
      composeBoolean(t, "OperationDefinition", "instance", element.getInstanceElement(), -1);
    }
    if (element.hasInputProfileElement()) {
      composeCanonical(t, "OperationDefinition", "inputProfile", element.getInputProfileElement(), -1);
    }
    if (element.hasOutputProfileElement()) {
      composeCanonical(t, "OperationDefinition", "outputProfile", element.getOutputProfileElement(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeOperationDefinitionParameterComponent(t, "OperationDefinition", "parameter", element.getParameter().get(i), i);
    }
    for (int i = 0; i < element.getOverload().size(); i++) {
      composeOperationDefinitionOverloadComponent(t, "OperationDefinition", "overload", element.getOverload().get(i), i);
    }
  }

  protected void composeOperationDefinitionParameterComponent(Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasNameElement()) {
      composeCode(t, "OperationDefinitionParameterComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "OperationDefinitionParameterComponent", "use", element.getUseElement(), -1);
    }
    for (int i = 0; i < element.getScope().size(); i++) {
      composeEnum(t, "OperationDefinitionParameterComponent", "scope", element.getScope().get(i), i);
    }
    if (element.hasMinElement()) {
      composeInteger(t, "OperationDefinitionParameterComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "OperationDefinitionParameterComponent", "max", element.getMaxElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "OperationDefinitionParameterComponent", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "OperationDefinitionParameterComponent", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getAllowedType().size(); i++) {
      composeEnum(t, "OperationDefinitionParameterComponent", "allowedType", element.getAllowedType().get(i), i);
    }
    for (int i = 0; i < element.getTargetProfile().size(); i++) {
      composeCanonical(t, "OperationDefinitionParameterComponent", "targetProfile", element.getTargetProfile().get(i), i);
    }
    if (element.hasSearchTypeElement()) {
      composeEnum(t, "OperationDefinitionParameterComponent", "searchType", element.getSearchTypeElement(), -1);
    }
    if (element.hasBinding()) {
      composeOperationDefinitionParameterBindingComponent(t, "OperationDefinitionParameterComponent", "binding", element.getBinding(), -1);
    }
    for (int i = 0; i < element.getReferencedFrom().size(); i++) {
      composeOperationDefinitionParameterReferencedFromComponent(t, "OperationDefinitionParameterComponent", "referencedFrom", element.getReferencedFrom().get(i), i);
    }
    for (int i = 0; i < element.getPart().size(); i++) {
      composeOperationDefinitionParameterComponent(t, "OperationDefinitionParameterComponent", "part", element.getPart().get(i), i);
    }
  }

  protected void composeOperationDefinitionParameterBindingComponent(Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterBindingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "binding", name, element, index);
    if (element.hasStrengthElement()) {
      composeEnum(t, "OperationDefinitionParameterBindingComponent", "strength", element.getStrengthElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "OperationDefinitionParameterBindingComponent", "valueSet", element.getValueSetElement(), -1);
    }
  }

  protected void composeOperationDefinitionParameterReferencedFromComponent(Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterReferencedFromComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "referencedFrom", name, element, index);
    if (element.hasSourceElement()) {
      composeString(t, "OperationDefinitionParameterReferencedFromComponent", "source", element.getSourceElement(), -1);
    }
    if (element.hasSourceIdElement()) {
      composeString(t, "OperationDefinitionParameterReferencedFromComponent", "sourceId", element.getSourceIdElement(), -1);
    }
  }

  protected void composeOperationDefinitionOverloadComponent(Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionOverloadComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "overload", name, element, index);
    for (int i = 0; i < element.getParameterName().size(); i++) {
      composeString(t, "OperationDefinitionOverloadComponent", "parameterName", element.getParameterName().get(i), i);
    }
    if (element.hasCommentElement()) {
      composeString(t, "OperationDefinitionOverloadComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeOperationOutcome(Complex parent, String parentType, String name, OperationOutcome element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "OperationOutcome", name, element, index);
    for (int i = 0; i < element.getIssue().size(); i++) {
      composeOperationOutcomeIssueComponent(t, "OperationOutcome", "issue", element.getIssue().get(i), i);
    }
  }

  protected void composeOperationOutcomeIssueComponent(Complex parent, String parentType, String name, OperationOutcome.OperationOutcomeIssueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "issue", name, element, index);
    if (element.hasSeverityElement()) {
      composeEnum(t, "OperationOutcomeIssueComponent", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeEnum(t, "OperationOutcomeIssueComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDetails()) {
      composeCodeableConcept(t, "OperationOutcomeIssueComponent", "details", element.getDetails(), -1);
    }
    if (element.hasDiagnosticsElement()) {
      composeString(t, "OperationOutcomeIssueComponent", "diagnostics", element.getDiagnosticsElement(), -1);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeString(t, "OperationOutcomeIssueComponent", "location", element.getLocation().get(i), i);
    }
    for (int i = 0; i < element.getExpression().size(); i++) {
      composeString(t, "OperationOutcomeIssueComponent", "expression", element.getExpression().get(i), i);
    }
  }

  protected void composeOrganization(Complex parent, String parentType, String name, Organization element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Organization", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Organization", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Organization", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Organization", "type", element.getType().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "Organization", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "Organization", "alias", element.getAlias().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Organization", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeExtendedContactDetail(t, "Organization", "contact", element.getContact().get(i), i);
    }
    if (element.hasPartOf()) {
      composeReference(t, "Organization", "partOf", element.getPartOf(), -1);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "Organization", "endpoint", element.getEndpoint().get(i), i);
    }
    for (int i = 0; i < element.getQualification().size(); i++) {
      composeOrganizationQualificationComponent(t, "Organization", "qualification", element.getQualification().get(i), i);
    }
  }

  protected void composeOrganizationQualificationComponent(Complex parent, String parentType, String name, Organization.OrganizationQualificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "qualification", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "OrganizationQualificationComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "OrganizationQualificationComponent", "code", element.getCode(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "OrganizationQualificationComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasIssuer()) {
      composeReference(t, "OrganizationQualificationComponent", "issuer", element.getIssuer(), -1);
    }
  }

  protected void composeOrganizationAffiliation(Complex parent, String parentType, String name, OrganizationAffiliation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "OrganizationAffiliation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "OrganizationAffiliation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "OrganizationAffiliation", "active", element.getActiveElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "OrganizationAffiliation", "period", element.getPeriod(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "OrganizationAffiliation", "organization", element.getOrganization(), -1);
    }
    if (element.hasParticipatingOrganization()) {
      composeReference(t, "OrganizationAffiliation", "participatingOrganization", element.getParticipatingOrganization(), -1);
    }
    for (int i = 0; i < element.getNetwork().size(); i++) {
      composeReference(t, "OrganizationAffiliation", "network", element.getNetwork().get(i), i);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "OrganizationAffiliation", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "OrganizationAffiliation", "specialty", element.getSpecialty().get(i), i);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeReference(t, "OrganizationAffiliation", "location", element.getLocation().get(i), i);
    }
    for (int i = 0; i < element.getHealthcareService().size(); i++) {
      composeReference(t, "OrganizationAffiliation", "healthcareService", element.getHealthcareService().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeExtendedContactDetail(t, "OrganizationAffiliation", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "OrganizationAffiliation", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composePackagedProductDefinition(Complex parent, String parentType, String name, PackagedProductDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PackagedProductDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PackagedProductDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "PackagedProductDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PackagedProductDefinition", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getPackageFor().size(); i++) {
      composeReference(t, "PackagedProductDefinition", "packageFor", element.getPackageFor().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "PackagedProductDefinition", "status", element.getStatus(), -1);
    }
    if (element.hasStatusDateElement()) {
      composeDateTime(t, "PackagedProductDefinition", "statusDate", element.getStatusDateElement(), -1);
    }
    for (int i = 0; i < element.getContainedItemQuantity().size(); i++) {
      composeQuantity(t, "PackagedProductDefinition", "containedItemQuantity", element.getContainedItemQuantity().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "PackagedProductDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getLegalStatusOfSupply().size(); i++) {
      composePackagedProductDefinitionLegalStatusOfSupplyComponent(t, "PackagedProductDefinition", "legalStatusOfSupply", element.getLegalStatusOfSupply().get(i), i);
    }
    for (int i = 0; i < element.getMarketingStatus().size(); i++) {
      composeMarketingStatus(t, "PackagedProductDefinition", "marketingStatus", element.getMarketingStatus().get(i), i);
    }
    if (element.hasCopackagedIndicatorElement()) {
      composeBoolean(t, "PackagedProductDefinition", "copackagedIndicator", element.getCopackagedIndicatorElement(), -1);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "PackagedProductDefinition", "manufacturer", element.getManufacturer().get(i), i);
    }
    for (int i = 0; i < element.getAttachedDocument().size(); i++) {
      composeReference(t, "PackagedProductDefinition", "attachedDocument", element.getAttachedDocument().get(i), i);
    }
    if (element.hasPackaging()) {
      composePackagedProductDefinitionPackagingComponent(t, "PackagedProductDefinition", "packaging", element.getPackaging(), -1);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composePackagedProductDefinitionPackagingPropertyComponent(t, "PackagedProductDefinition", "characteristic", element.getCharacteristic().get(i), i);
    }
  }

  protected void composePackagedProductDefinitionLegalStatusOfSupplyComponent(Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionLegalStatusOfSupplyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "legalStatusOfSupply", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "PackagedProductDefinitionLegalStatusOfSupplyComponent", "code", element.getCode(), -1);
    }
    if (element.hasJurisdiction()) {
      composeCodeableConcept(t, "PackagedProductDefinitionLegalStatusOfSupplyComponent", "jurisdiction", element.getJurisdiction(), -1);
    }
  }

  protected void composePackagedProductDefinitionPackagingComponent(Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackagingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "packaging", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PackagedProductDefinitionPackagingComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PackagedProductDefinitionPackagingComponent", "type", element.getType(), -1);
    }
    if (element.hasComponentPartElement()) {
      composeBoolean(t, "PackagedProductDefinitionPackagingComponent", "componentPart", element.getComponentPartElement(), -1);
    }
    if (element.hasQuantityElement()) {
      composeInteger(t, "PackagedProductDefinitionPackagingComponent", "quantity", element.getQuantityElement(), -1);
    }
    for (int i = 0; i < element.getMaterial().size(); i++) {
      composeCodeableConcept(t, "PackagedProductDefinitionPackagingComponent", "material", element.getMaterial().get(i), i);
    }
    for (int i = 0; i < element.getAlternateMaterial().size(); i++) {
      composeCodeableConcept(t, "PackagedProductDefinitionPackagingComponent", "alternateMaterial", element.getAlternateMaterial().get(i), i);
    }
    for (int i = 0; i < element.getShelfLifeStorage().size(); i++) {
      composeProductShelfLife(t, "PackagedProductDefinitionPackagingComponent", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "PackagedProductDefinitionPackagingComponent", "manufacturer", element.getManufacturer().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composePackagedProductDefinitionPackagingPropertyComponent(t, "PackagedProductDefinitionPackagingComponent", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getContainedItem().size(); i++) {
      composePackagedProductDefinitionPackagingContainedItemComponent(t, "PackagedProductDefinitionPackagingComponent", "containedItem", element.getContainedItem().get(i), i);
    }
    for (int i = 0; i < element.getPackaging().size(); i++) {
      composePackagedProductDefinitionPackagingComponent(t, "PackagedProductDefinitionPackagingComponent", "packaging", element.getPackaging().get(i), i);
    }
  }

  protected void composePackagedProductDefinitionPackagingPropertyComponent(Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackagingPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PackagedProductDefinitionPackagingPropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "PackagedProductDefinitionPackagingPropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composePackagedProductDefinitionPackagingContainedItemComponent(Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackagingContainedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "containedItem", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "PackagedProductDefinitionPackagingContainedItemComponent", "item", element.getItem(), -1);
    }
    if (element.hasAmount()) {
      composeQuantity(t, "PackagedProductDefinitionPackagingContainedItemComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeParameters(Complex parent, String parentType, String name, Parameters element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeResource(t, "Parameters", name, element, index);
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeParametersParameterComponent(t, "Parameters", "parameter", element.getParameter().get(i), i);
    }
  }

  protected void composeParametersParameterComponent(Complex parent, String parentType, String name, Parameters.ParametersParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ParametersParameterComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ParametersParameterComponent", "value", element.getValue(), -1);
    }
    if (element.hasResource()) {
      composeResource(t, "ParametersParameterComponent", "resource", element.getResource(), -1);
    }
    for (int i = 0; i < element.getPart().size(); i++) {
      composeParametersParameterComponent(t, "ParametersParameterComponent", "part", element.getPart().get(i), i);
    }
  }

  protected void composePatient(Complex parent, String parentType, String name, Patient element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Patient", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Patient", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Patient", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "Patient", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
    }
    if (element.hasBirthDateElement()) {
      composeDate(t, "Patient", "birthDate", element.getBirthDateElement(), -1);
    }
    if (element.hasDeceased()) {
      composeType(t, "Patient", "deceased", element.getDeceased(), -1);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "Patient", "address", element.getAddress().get(i), i);
    }
    if (element.hasMaritalStatus()) {
      composeCodeableConcept(t, "Patient", "maritalStatus", element.getMaritalStatus(), -1);
    }
    if (element.hasMultipleBirth()) {
      composeType(t, "Patient", "multipleBirth", element.getMultipleBirth(), -1);
    }
    for (int i = 0; i < element.getPhoto().size(); i++) {
      composeAttachment(t, "Patient", "photo", element.getPhoto().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composePatientContactComponent(t, "Patient", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composePatientCommunicationComponent(t, "Patient", "communication", element.getCommunication().get(i), i);
    }
    for (int i = 0; i < element.getGeneralPractitioner().size(); i++) {
      composeReference(t, "Patient", "generalPractitioner", element.getGeneralPractitioner().get(i), i);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "Patient", "managingOrganization", element.getManagingOrganization(), -1);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composePatientLinkComponent(t, "Patient", "link", element.getLink().get(i), i);
    }
  }

  protected void composePatientContactComponent(Complex parent, String parentType, String name, Patient.ContactComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contact", name, element, index);
    for (int i = 0; i < element.getRelationship().size(); i++) {
      composeCodeableConcept(t, "ContactComponent", "relationship", element.getRelationship().get(i), i);
    }
    if (element.hasName()) {
      composeHumanName(t, "ContactComponent", "name", element.getName(), -1);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "ContactComponent", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasAddress()) {
      composeAddress(t, "ContactComponent", "address", element.getAddress(), -1);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "ContactComponent", "gender", element.getGenderElement(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "ContactComponent", "organization", element.getOrganization(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ContactComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composePatientCommunicationComponent(Complex parent, String parentType, String name, Patient.PatientCommunicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "communication", name, element, index);
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "PatientCommunicationComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasPreferredElement()) {
      composeBoolean(t, "PatientCommunicationComponent", "preferred", element.getPreferredElement(), -1);
    }
  }

  protected void composePatientLinkComponent(Complex parent, String parentType, String name, Patient.PatientLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasOther()) {
      composeReference(t, "PatientLinkComponent", "other", element.getOther(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "PatientLinkComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composePaymentNotice(Complex parent, String parentType, String name, PaymentNotice element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PaymentNotice", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PaymentNotice", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "PaymentNotice", "status", element.getStatusElement(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "PaymentNotice", "request", element.getRequest(), -1);
    }
    if (element.hasResponse()) {
      composeReference(t, "PaymentNotice", "response", element.getResponse(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "PaymentNotice", "created", element.getCreatedElement(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "PaymentNotice", "provider", element.getProvider(), -1);
    }
    if (element.hasPayment()) {
      composeReference(t, "PaymentNotice", "payment", element.getPayment(), -1);
    }
    if (element.hasPaymentDateElement()) {
      composeDate(t, "PaymentNotice", "paymentDate", element.getPaymentDateElement(), -1);
    }
    if (element.hasPayee()) {
      composeReference(t, "PaymentNotice", "payee", element.getPayee(), -1);
    }
    if (element.hasRecipient()) {
      composeReference(t, "PaymentNotice", "recipient", element.getRecipient(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "PaymentNotice", "amount", element.getAmount(), -1);
    }
    if (element.hasPaymentStatus()) {
      composeCodeableConcept(t, "PaymentNotice", "paymentStatus", element.getPaymentStatus(), -1);
    }
  }

  protected void composePaymentReconciliation(Complex parent, String parentType, String name, PaymentReconciliation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PaymentReconciliation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PaymentReconciliation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PaymentReconciliation", "type", element.getType(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "PaymentReconciliation", "status", element.getStatusElement(), -1);
    }
    if (element.hasKind()) {
      composeCodeableConcept(t, "PaymentReconciliation", "kind", element.getKind(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "PaymentReconciliation", "period", element.getPeriod(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "PaymentReconciliation", "created", element.getCreatedElement(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "PaymentReconciliation", "enterer", element.getEnterer(), -1);
    }
    if (element.hasIssuerType()) {
      composeCodeableConcept(t, "PaymentReconciliation", "issuerType", element.getIssuerType(), -1);
    }
    if (element.hasPaymentIssuer()) {
      composeReference(t, "PaymentReconciliation", "paymentIssuer", element.getPaymentIssuer(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "PaymentReconciliation", "request", element.getRequest(), -1);
    }
    if (element.hasRequestor()) {
      composeReference(t, "PaymentReconciliation", "requestor", element.getRequestor(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "PaymentReconciliation", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "PaymentReconciliation", "disposition", element.getDispositionElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDate(t, "PaymentReconciliation", "date", element.getDateElement(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "PaymentReconciliation", "location", element.getLocation(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "PaymentReconciliation", "method", element.getMethod(), -1);
    }
    if (element.hasCardBrandElement()) {
      composeString(t, "PaymentReconciliation", "cardBrand", element.getCardBrandElement(), -1);
    }
    if (element.hasAccountNumberElement()) {
      composeString(t, "PaymentReconciliation", "accountNumber", element.getAccountNumberElement(), -1);
    }
    if (element.hasExpirationDateElement()) {
      composeDate(t, "PaymentReconciliation", "expirationDate", element.getExpirationDateElement(), -1);
    }
    if (element.hasProcessorElement()) {
      composeString(t, "PaymentReconciliation", "processor", element.getProcessorElement(), -1);
    }
    if (element.hasReferenceNumberElement()) {
      composeString(t, "PaymentReconciliation", "referenceNumber", element.getReferenceNumberElement(), -1);
    }
    if (element.hasAuthorizationElement()) {
      composeString(t, "PaymentReconciliation", "authorization", element.getAuthorizationElement(), -1);
    }
    if (element.hasTenderedAmount()) {
      composeMoney(t, "PaymentReconciliation", "tenderedAmount", element.getTenderedAmount(), -1);
    }
    if (element.hasReturnedAmount()) {
      composeMoney(t, "PaymentReconciliation", "returnedAmount", element.getReturnedAmount(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "PaymentReconciliation", "amount", element.getAmount(), -1);
    }
    if (element.hasPaymentIdentifier()) {
      composeIdentifier(t, "PaymentReconciliation", "paymentIdentifier", element.getPaymentIdentifier(), -1);
    }
    for (int i = 0; i < element.getAllocation().size(); i++) {
      composePaymentReconciliationAllocationComponent(t, "PaymentReconciliation", "allocation", element.getAllocation().get(i), i);
    }
    if (element.hasFormCode()) {
      composeCodeableConcept(t, "PaymentReconciliation", "formCode", element.getFormCode(), -1);
    }
    for (int i = 0; i < element.getProcessNote().size(); i++) {
      composePaymentReconciliationNotesComponent(t, "PaymentReconciliation", "processNote", element.getProcessNote().get(i), i);
    }
  }

  protected void composePaymentReconciliationAllocationComponent(Complex parent, String parentType, String name, PaymentReconciliation.PaymentReconciliationAllocationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "allocation", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "PaymentReconciliationAllocationComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasPredecessor()) {
      composeIdentifier(t, "PaymentReconciliationAllocationComponent", "predecessor", element.getPredecessor(), -1);
    }
    if (element.hasTarget()) {
      composeReference(t, "PaymentReconciliationAllocationComponent", "target", element.getTarget(), -1);
    }
    if (element.hasTargetItem()) {
      composeType(t, "PaymentReconciliationAllocationComponent", "targetItem", element.getTargetItem(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "PaymentReconciliationAllocationComponent", "encounter", element.getEncounter(), -1);
    }
    if (element.hasAccount()) {
      composeReference(t, "PaymentReconciliationAllocationComponent", "account", element.getAccount(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PaymentReconciliationAllocationComponent", "type", element.getType(), -1);
    }
    if (element.hasSubmitter()) {
      composeReference(t, "PaymentReconciliationAllocationComponent", "submitter", element.getSubmitter(), -1);
    }
    if (element.hasResponse()) {
      composeReference(t, "PaymentReconciliationAllocationComponent", "response", element.getResponse(), -1);
    }
    if (element.hasDateElement()) {
      composeDate(t, "PaymentReconciliationAllocationComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasResponsible()) {
      composeReference(t, "PaymentReconciliationAllocationComponent", "responsible", element.getResponsible(), -1);
    }
    if (element.hasPayee()) {
      composeReference(t, "PaymentReconciliationAllocationComponent", "payee", element.getPayee(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "PaymentReconciliationAllocationComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composePaymentReconciliationNotesComponent(Complex parent, String parentType, String name, PaymentReconciliation.NotesComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "processNote", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "NotesComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "NotesComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composePermission(Complex parent, String parentType, String name, Permission element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Permission", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "Permission", "status", element.getStatusElement(), -1);
    }
    if (element.hasAsserter()) {
      composeReference(t, "Permission", "asserter", element.getAsserter(), -1);
    }
    for (int i = 0; i < element.getDate().size(); i++) {
      composeDateTime(t, "Permission", "date", element.getDate().get(i), i);
    }
    if (element.hasValidity()) {
      composePeriod(t, "Permission", "validity", element.getValidity(), -1);
    }
    if (element.hasJustification()) {
      composePermissionJustificationComponent(t, "Permission", "justification", element.getJustification(), -1);
    }
    if (element.hasCombiningElement()) {
      composeEnum(t, "Permission", "combining", element.getCombiningElement(), -1);
    }
    for (int i = 0; i < element.getRule().size(); i++) {
      composePermissionrRuleComponent(t, "Permission", "rule", element.getRule().get(i), i);
    }
  }

  protected void composePermissionJustificationComponent(Complex parent, String parentType, String name, Permission.PermissionJustificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "justification", name, element, index);
    for (int i = 0; i < element.getBasis().size(); i++) {
      composeCodeableConcept(t, "PermissionJustificationComponent", "basis", element.getBasis().get(i), i);
    }
    for (int i = 0; i < element.getEvidence().size(); i++) {
      composeReference(t, "PermissionJustificationComponent", "evidence", element.getEvidence().get(i), i);
    }
  }

  protected void composePermissionrRuleComponent(Complex parent, String parentType, String name, Permission.RuleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "rule", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "RuleComponent", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getData().size(); i++) {
      composePermissionrRuleDataComponent(t, "RuleComponent", "data", element.getData().get(i), i);
    }
    for (int i = 0; i < element.getActivity().size(); i++) {
      composePermissionrRuleActivityComponent(t, "RuleComponent", "activity", element.getActivity().get(i), i);
    }
    for (int i = 0; i < element.getLimit().size(); i++) {
      composeCodeableConcept(t, "RuleComponent", "limit", element.getLimit().get(i), i);
    }
  }

  protected void composePermissionrRuleDataComponent(Complex parent, String parentType, String name, Permission.RuleDataComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "data", name, element, index);
    for (int i = 0; i < element.getResource().size(); i++) {
      composePermissionrRuleDataResourceComponent(t, "RuleDataComponent", "resource", element.getResource().get(i), i);
    }
    for (int i = 0; i < element.getSecurity().size(); i++) {
      composeCoding(t, "RuleDataComponent", "security", element.getSecurity().get(i), i);
    }
    for (int i = 0; i < element.getPeriod().size(); i++) {
      composePeriod(t, "RuleDataComponent", "period", element.getPeriod().get(i), i);
    }
    if (element.hasExpression()) {
      composeExpression(t, "RuleDataComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composePermissionrRuleDataResourceComponent(Complex parent, String parentType, String name, Permission.RuleDataResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasMeaningElement()) {
      composeEnum(t, "RuleDataResourceComponent", "meaning", element.getMeaningElement(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "RuleDataResourceComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composePermissionrRuleActivityComponent(Complex parent, String parentType, String name, Permission.RuleActivityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "activity", name, element, index);
    for (int i = 0; i < element.getActor().size(); i++) {
      composeReference(t, "RuleActivityComponent", "actor", element.getActor().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeCodeableConcept(t, "RuleActivityComponent", "action", element.getAction().get(i), i);
    }
    for (int i = 0; i < element.getPurpose().size(); i++) {
      composeCodeableConcept(t, "RuleActivityComponent", "purpose", element.getPurpose().get(i), i);
    }
  }

  protected void composePerson(Complex parent, String parentType, String name, Person element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Person", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Person", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Person", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "Person", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "Person", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "Person", "gender", element.getGenderElement(), -1);
    }
    if (element.hasBirthDateElement()) {
      composeDate(t, "Person", "birthDate", element.getBirthDateElement(), -1);
    }
    if (element.hasDeceased()) {
      composeType(t, "Person", "deceased", element.getDeceased(), -1);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "Person", "address", element.getAddress().get(i), i);
    }
    if (element.hasMaritalStatus()) {
      composeCodeableConcept(t, "Person", "maritalStatus", element.getMaritalStatus(), -1);
    }
    for (int i = 0; i < element.getPhoto().size(); i++) {
      composeAttachment(t, "Person", "photo", element.getPhoto().get(i), i);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composePersonCommunicationComponent(t, "Person", "communication", element.getCommunication().get(i), i);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "Person", "managingOrganization", element.getManagingOrganization(), -1);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composePersonLinkComponent(t, "Person", "link", element.getLink().get(i), i);
    }
  }

  protected void composePersonCommunicationComponent(Complex parent, String parentType, String name, Person.PersonCommunicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "communication", name, element, index);
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "PersonCommunicationComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasPreferredElement()) {
      composeBoolean(t, "PersonCommunicationComponent", "preferred", element.getPreferredElement(), -1);
    }
  }

  protected void composePersonLinkComponent(Complex parent, String parentType, String name, Person.PersonLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasTarget()) {
      composeReference(t, "PersonLinkComponent", "target", element.getTarget(), -1);
    }
    if (element.hasAssuranceElement()) {
      composeEnum(t, "PersonLinkComponent", "assurance", element.getAssuranceElement(), -1);
    }
  }

  protected void composePlanDefinition(Complex parent, String parentType, String name, PlanDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "PlanDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "PlanDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PlanDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "PlanDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "PlanDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "PlanDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "PlanDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PlanDefinition", "type", element.getType(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "PlanDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "PlanDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "PlanDefinition", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "PlanDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "PlanDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "PlanDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "PlanDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "PlanDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "PlanDefinition", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "PlanDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "PlanDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "PlanDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "PlanDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "PlanDefinition", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "PlanDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "PlanDefinition", "library", element.getLibrary().get(i), i);
    }
    for (int i = 0; i < element.getGoal().size(); i++) {
      composePlanDefinitionGoalComponent(t, "PlanDefinition", "goal", element.getGoal().get(i), i);
    }
    for (int i = 0; i < element.getActor().size(); i++) {
      composePlanDefinitionActorComponent(t, "PlanDefinition", "actor", element.getActor().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composePlanDefinitionActionComponent(t, "PlanDefinition", "action", element.getAction().get(i), i);
    }
    if (element.hasAsNeeded()) {
      composeType(t, "PlanDefinition", "asNeeded", element.getAsNeeded(), -1);
    }
  }

  protected void composePlanDefinitionGoalComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "goal", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "category", element.getCategory(), -1);
    }
    if (element.hasDescription()) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "description", element.getDescription(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "priority", element.getPriority(), -1);
    }
    if (element.hasStart()) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "start", element.getStart(), -1);
    }
    for (int i = 0; i < element.getAddresses().size(); i++) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "addresses", element.getAddresses().get(i), i);
    }
    for (int i = 0; i < element.getDocumentation().size(); i++) {
      composeRelatedArtifact(t, "PlanDefinitionGoalComponent", "documentation", element.getDocumentation().get(i), i);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composePlanDefinitionGoalTargetComponent(t, "PlanDefinitionGoalComponent", "target", element.getTarget().get(i), i);
    }
  }

  protected void composePlanDefinitionGoalTargetComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalTargetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasMeasure()) {
      composeCodeableConcept(t, "PlanDefinitionGoalTargetComponent", "measure", element.getMeasure(), -1);
    }
    if (element.hasDetail()) {
      composeType(t, "PlanDefinitionGoalTargetComponent", "detail", element.getDetail(), -1);
    }
    if (element.hasDue()) {
      composeDuration(t, "PlanDefinitionGoalTargetComponent", "due", element.getDue(), -1);
    }
  }

  protected void composePlanDefinitionActorComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "actor", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "PlanDefinitionActorComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "PlanDefinitionActorComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getOption().size(); i++) {
      composePlanDefinitionActorOptionComponent(t, "PlanDefinitionActorComponent", "option", element.getOption().get(i), i);
    }
  }

  protected void composePlanDefinitionActorOptionComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActorOptionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "option", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "PlanDefinitionActorOptionComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTypeCanonicalElement()) {
      composeCanonical(t, "PlanDefinitionActorOptionComponent", "typeCanonical", element.getTypeCanonicalElement(), -1);
    }
    if (element.hasTypeReference()) {
      composeReference(t, "PlanDefinitionActorOptionComponent", "typeReference", element.getTypeReference(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "PlanDefinitionActorOptionComponent", "role", element.getRole(), -1);
    }
  }

  protected void composePlanDefinitionActionComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasLinkIdElement()) {
      composeString(t, "PlanDefinitionActionComponent", "linkId", element.getLinkIdElement(), -1);
    }
    if (element.hasPrefixElement()) {
      composeString(t, "PlanDefinitionActionComponent", "prefix", element.getPrefixElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "PlanDefinitionActionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "PlanDefinitionActionComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTextEquivalentElement()) {
      composeString(t, "PlanDefinitionActionComponent", "textEquivalent", element.getTextEquivalentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "PlanDefinitionActionComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableConcept(t, "PlanDefinitionActionComponent", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getDocumentation().size(); i++) {
      composeRelatedArtifact(t, "PlanDefinitionActionComponent", "documentation", element.getDocumentation().get(i), i);
    }
    for (int i = 0; i < element.getGoalId().size(); i++) {
      composeId(t, "PlanDefinitionActionComponent", "goalId", element.getGoalId().get(i), i);
    }
    if (element.hasSubject()) {
      composeType(t, "PlanDefinitionActionComponent", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getTrigger().size(); i++) {
      composeTriggerDefinition(t, "PlanDefinitionActionComponent", "trigger", element.getTrigger().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composePlanDefinitionActionConditionComponent(t, "PlanDefinitionActionComponent", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getInput().size(); i++) {
      composePlanDefinitionActionInputComponent(t, "PlanDefinitionActionComponent", "input", element.getInput().get(i), i);
    }
    for (int i = 0; i < element.getOutput().size(); i++) {
      composePlanDefinitionActionOutputComponent(t, "PlanDefinitionActionComponent", "output", element.getOutput().get(i), i);
    }
    for (int i = 0; i < element.getRelatedAction().size(); i++) {
      composePlanDefinitionActionRelatedActionComponent(t, "PlanDefinitionActionComponent", "relatedAction", element.getRelatedAction().get(i), i);
    }
    if (element.hasTiming()) {
      composeType(t, "PlanDefinitionActionComponent", "timing", element.getTiming(), -1);
    }
    if (element.hasLocation()) {
      composeCodeableReference(t, "PlanDefinitionActionComponent", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composePlanDefinitionActionParticipantComponent(t, "PlanDefinitionActionComponent", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PlanDefinitionActionComponent", "type", element.getType(), -1);
    }
    if (element.hasGroupingBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
    }
    if (element.hasSelectionBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
    }
    if (element.hasRequiredBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
    }
    if (element.hasPrecheckBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
    }
    if (element.hasCardinalityBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
    }
    if (element.hasDefinition()) {
      composeType(t, "PlanDefinitionActionComponent", "definition", element.getDefinition(), -1);
    }
    if (element.hasTransformElement()) {
      composeCanonical(t, "PlanDefinitionActionComponent", "transform", element.getTransformElement(), -1);
    }
    for (int i = 0; i < element.getDynamicValue().size(); i++) {
      composePlanDefinitionActionDynamicValueComponent(t, "PlanDefinitionActionComponent", "dynamicValue", element.getDynamicValue().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composePlanDefinitionActionComponent(t, "PlanDefinitionActionComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composePlanDefinitionActionConditionComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionConditionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "condition", name, element, index);
    if (element.hasKindElement()) {
      composeEnum(t, "PlanDefinitionActionConditionComponent", "kind", element.getKindElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "PlanDefinitionActionConditionComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composePlanDefinitionActionInputComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionInputComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "input", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "PlanDefinitionActionInputComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasRequirement()) {
      composeDataRequirement(t, "PlanDefinitionActionInputComponent", "requirement", element.getRequirement(), -1);
    }
    if (element.hasRelatedDataElement()) {
      composeId(t, "PlanDefinitionActionInputComponent", "relatedData", element.getRelatedDataElement(), -1);
    }
  }

  protected void composePlanDefinitionActionOutputComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionOutputComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "output", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "PlanDefinitionActionOutputComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasRequirement()) {
      composeDataRequirement(t, "PlanDefinitionActionOutputComponent", "requirement", element.getRequirement(), -1);
    }
    if (element.hasRelatedDataElement()) {
      composeString(t, "PlanDefinitionActionOutputComponent", "relatedData", element.getRelatedDataElement(), -1);
    }
  }

  protected void composePlanDefinitionActionRelatedActionComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionRelatedActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatedAction", name, element, index);
    if (element.hasTargetIdElement()) {
      composeId(t, "PlanDefinitionActionRelatedActionComponent", "targetId", element.getTargetIdElement(), -1);
    }
    if (element.hasRelationshipElement()) {
      composeEnum(t, "PlanDefinitionActionRelatedActionComponent", "relationship", element.getRelationshipElement(), -1);
    }
    if (element.hasOffset()) {
      composeType(t, "PlanDefinitionActionRelatedActionComponent", "offset", element.getOffset(), -1);
    }
  }

  protected void composePlanDefinitionActionParticipantComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasActorIdElement()) {
      composeString(t, "PlanDefinitionActionParticipantComponent", "actorId", element.getActorIdElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "PlanDefinitionActionParticipantComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTypeCanonicalElement()) {
      composeCanonical(t, "PlanDefinitionActionParticipantComponent", "typeCanonical", element.getTypeCanonicalElement(), -1);
    }
    if (element.hasTypeReference()) {
      composeReference(t, "PlanDefinitionActionParticipantComponent", "typeReference", element.getTypeReference(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "PlanDefinitionActionParticipantComponent", "role", element.getRole(), -1);
    }
    if (element.hasFunction()) {
      composeCodeableConcept(t, "PlanDefinitionActionParticipantComponent", "function", element.getFunction(), -1);
    }
  }

  protected void composePlanDefinitionActionDynamicValueComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionDynamicValueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dynamicValue", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "PlanDefinitionActionDynamicValueComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "PlanDefinitionActionDynamicValueComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composePractitioner(Complex parent, String parentType, String name, Practitioner element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Practitioner", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Practitioner", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "Practitioner", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "Practitioner", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "Practitioner", "gender", element.getGenderElement(), -1);
    }
    if (element.hasBirthDateElement()) {
      composeDate(t, "Practitioner", "birthDate", element.getBirthDateElement(), -1);
    }
    if (element.hasDeceased()) {
      composeType(t, "Practitioner", "deceased", element.getDeceased(), -1);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "Practitioner", "address", element.getAddress().get(i), i);
    }
    for (int i = 0; i < element.getPhoto().size(); i++) {
      composeAttachment(t, "Practitioner", "photo", element.getPhoto().get(i), i);
    }
    for (int i = 0; i < element.getQualification().size(); i++) {
      composePractitionerQualificationComponent(t, "Practitioner", "qualification", element.getQualification().get(i), i);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composeCodeableConcept(t, "Practitioner", "communication", element.getCommunication().get(i), i);
    }
  }

  protected void composePractitionerQualificationComponent(Complex parent, String parentType, String name, Practitioner.PractitionerQualificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "qualification", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PractitionerQualificationComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "PractitionerQualificationComponent", "code", element.getCode(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "PractitionerQualificationComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasIssuer()) {
      composeReference(t, "PractitionerQualificationComponent", "issuer", element.getIssuer(), -1);
    }
  }

  protected void composePractitionerRole(Complex parent, String parentType, String name, PractitionerRole element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PractitionerRole", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PractitionerRole", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "PractitionerRole", "active", element.getActiveElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "PractitionerRole", "period", element.getPeriod(), -1);
    }
    if (element.hasPractitioner()) {
      composeReference(t, "PractitionerRole", "practitioner", element.getPractitioner(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "PractitionerRole", "organization", element.getOrganization(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "PractitionerRole", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "PractitionerRole", "specialty", element.getSpecialty().get(i), i);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeReference(t, "PractitionerRole", "location", element.getLocation().get(i), i);
    }
    for (int i = 0; i < element.getHealthcareService().size(); i++) {
      composeReference(t, "PractitionerRole", "healthcareService", element.getHealthcareService().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeExtendedContactDetail(t, "PractitionerRole", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getAvailability().size(); i++) {
      composeAvailability(t, "PractitionerRole", "availability", element.getAvailability().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "PractitionerRole", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composeProcedure(Complex parent, String parentType, String name, Procedure element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Procedure", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Procedure", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "Procedure", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "Procedure", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Procedure", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "Procedure", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Procedure", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "Procedure", "statusReason", element.getStatusReason(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Procedure", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Procedure", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Procedure", "subject", element.getSubject(), -1);
    }
    if (element.hasFocus()) {
      composeReference(t, "Procedure", "focus", element.getFocus(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Procedure", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "Procedure", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasRecordedElement()) {
      composeDateTime(t, "Procedure", "recorded", element.getRecordedElement(), -1);
    }
    if (element.hasRecorder()) {
      composeReference(t, "Procedure", "recorder", element.getRecorder(), -1);
    }
    if (element.hasReported()) {
      composeType(t, "Procedure", "reported", element.getReported(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeProcedurePerformerComponent(t, "Procedure", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "Procedure", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "Procedure", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeCodeableConcept(t, "Procedure", "bodySite", element.getBodySite().get(i), i);
    }
    if (element.hasOutcome()) {
      composeCodeableConcept(t, "Procedure", "outcome", element.getOutcome(), -1);
    }
    for (int i = 0; i < element.getReport().size(); i++) {
      composeReference(t, "Procedure", "report", element.getReport().get(i), i);
    }
    for (int i = 0; i < element.getComplication().size(); i++) {
      composeCodeableReference(t, "Procedure", "complication", element.getComplication().get(i), i);
    }
    for (int i = 0; i < element.getFollowUp().size(); i++) {
      composeCodeableConcept(t, "Procedure", "followUp", element.getFollowUp().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Procedure", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getFocalDevice().size(); i++) {
      composeProcedureFocalDeviceComponent(t, "Procedure", "focalDevice", element.getFocalDevice().get(i), i);
    }
    for (int i = 0; i < element.getUsed().size(); i++) {
      composeCodeableReference(t, "Procedure", "used", element.getUsed().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "Procedure", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
  }

  protected void composeProcedurePerformerComponent(Complex parent, String parentType, String name, Procedure.ProcedurePerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ProcedurePerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ProcedurePerformerComponent", "actor", element.getActor(), -1);
    }
    if (element.hasOnBehalfOf()) {
      composeReference(t, "ProcedurePerformerComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ProcedurePerformerComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeProcedureFocalDeviceComponent(Complex parent, String parentType, String name, Procedure.ProcedureFocalDeviceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "focalDevice", name, element, index);
    if (element.hasAction()) {
      composeCodeableConcept(t, "ProcedureFocalDeviceComponent", "action", element.getAction(), -1);
    }
    if (element.hasManipulated()) {
      composeReference(t, "ProcedureFocalDeviceComponent", "manipulated", element.getManipulated(), -1);
    }
  }

  protected void composeProvenance(Complex parent, String parentType, String name, Provenance element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Provenance", name, element, index);
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeReference(t, "Provenance", "target", element.getTarget().get(i), i);
    }
    if (element.hasOccurred()) {
      composeType(t, "Provenance", "occurred", element.getOccurred(), -1);
    }
    if (element.hasRecordedElement()) {
      composeInstant(t, "Provenance", "recorded", element.getRecordedElement(), -1);
    }
    for (int i = 0; i < element.getPolicy().size(); i++) {
      composeUri(t, "Provenance", "policy", element.getPolicy().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "Provenance", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getAuthorization().size(); i++) {
      composeCodeableReference(t, "Provenance", "authorization", element.getAuthorization().get(i), i);
    }
    if (element.hasActivity()) {
      composeCodeableConcept(t, "Provenance", "activity", element.getActivity(), -1);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Provenance", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "Provenance", "patient", element.getPatient(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Provenance", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getAgent().size(); i++) {
      composeProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent().get(i), i);
    }
    for (int i = 0; i < element.getEntity().size(); i++) {
      composeProvenanceEntityComponent(t, "Provenance", "entity", element.getEntity().get(i), i);
    }
    for (int i = 0; i < element.getSignature().size(); i++) {
      composeSignature(t, "Provenance", "signature", element.getSignature().get(i), i);
    }
  }

  protected void composeProvenanceAgentComponent(Complex parent, String parentType, String name, Provenance.ProvenanceAgentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "agent", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ProvenanceAgentComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getRole().size(); i++) {
      composeCodeableConcept(t, "ProvenanceAgentComponent", "role", element.getRole().get(i), i);
    }
    if (element.hasWho()) {
      composeReference(t, "ProvenanceAgentComponent", "who", element.getWho(), -1);
    }
    if (element.hasOnBehalfOf()) {
      composeReference(t, "ProvenanceAgentComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
    }
  }

  protected void composeProvenanceEntityComponent(Complex parent, String parentType, String name, Provenance.ProvenanceEntityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entity", name, element, index);
    if (element.hasRoleElement()) {
      composeEnum(t, "ProvenanceEntityComponent", "role", element.getRoleElement(), -1);
    }
    if (element.hasWhat()) {
      composeReference(t, "ProvenanceEntityComponent", "what", element.getWhat(), -1);
    }
    for (int i = 0; i < element.getAgent().size(); i++) {
      composeProvenanceAgentComponent(t, "ProvenanceEntityComponent", "agent", element.getAgent().get(i), i);
    }
  }

  protected void composeQuestionnaire(Complex parent, String parentType, String name, Questionnaire element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeMetadataResource(t, "Questionnaire", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Questionnaire", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Questionnaire", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Questionnaire", "version", element.getVersionElement(), -1);
    }
    if (element.hasVersionAlgorithm()) {
      composeType(t, "Questionnaire", "versionAlgorithm", element.getVersionAlgorithm(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Questionnaire", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Questionnaire", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeCanonical(t, "Questionnaire", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Questionnaire", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Questionnaire", "experimental", element.getExperimentalElement(), -1);
    }
    for (int i = 0; i < element.getSubjectType().size(); i++) {
      composeCode(t, "Questionnaire", "subjectType", element.getSubjectType().get(i), i);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Questionnaire", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Questionnaire", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Questionnaire", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Questionnaire", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Questionnaire", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Questionnaire", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Questionnaire", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Questionnaire", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCopyrightLabelElement()) {
      composeString(t, "Questionnaire", "copyrightLabel", element.getCopyrightLabelElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Questionnaire", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Questionnaire", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "Questionnaire", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "Questionnaire", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
    }
  }

  protected void composeQuestionnaireItemComponent(Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasLinkIdElement()) {
      composeString(t, "QuestionnaireItemComponent", "linkId", element.getLinkIdElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeUri(t, "QuestionnaireItemComponent", "definition", element.getDefinitionElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "QuestionnaireItemComponent", "code", element.getCode().get(i), i);
    }
    if (element.hasPrefixElement()) {
      composeString(t, "QuestionnaireItemComponent", "prefix", element.getPrefixElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "QuestionnaireItemComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "QuestionnaireItemComponent", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getEnableWhen().size(); i++) {
      composeQuestionnaireItemEnableWhenComponent(t, "QuestionnaireItemComponent", "enableWhen", element.getEnableWhen().get(i), i);
    }
    if (element.hasEnableBehaviorElement()) {
      composeEnum(t, "QuestionnaireItemComponent", "enableBehavior", element.getEnableBehaviorElement(), -1);
    }
    if (element.hasDisabledDisplayElement()) {
      composeEnum(t, "QuestionnaireItemComponent", "disabledDisplay", element.getDisabledDisplayElement(), -1);
    }
    if (element.hasRequiredElement()) {
      composeBoolean(t, "QuestionnaireItemComponent", "required", element.getRequiredElement(), -1);
    }
    if (element.hasRepeatsElement()) {
      composeBoolean(t, "QuestionnaireItemComponent", "repeats", element.getRepeatsElement(), -1);
    }
    if (element.hasReadOnlyElement()) {
      composeBoolean(t, "QuestionnaireItemComponent", "readOnly", element.getReadOnlyElement(), -1);
    }
    if (element.hasMaxLengthElement()) {
      composeInteger(t, "QuestionnaireItemComponent", "maxLength", element.getMaxLengthElement(), -1);
    }
    if (element.hasAnswerConstraintElement()) {
      composeEnum(t, "QuestionnaireItemComponent", "answerConstraint", element.getAnswerConstraintElement(), -1);
    }
    if (element.hasAnswerValueSetElement()) {
      composeCanonical(t, "QuestionnaireItemComponent", "answerValueSet", element.getAnswerValueSetElement(), -1);
    }
    for (int i = 0; i < element.getAnswerOption().size(); i++) {
      composeQuestionnaireItemAnswerOptionComponent(t, "QuestionnaireItemComponent", "answerOption", element.getAnswerOption().get(i), i);
    }
    for (int i = 0; i < element.getInitial().size(); i++) {
      composeQuestionnaireItemInitialComponent(t, "QuestionnaireItemComponent", "initial", element.getInitial().get(i), i);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireItemComponent(t, "QuestionnaireItemComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeQuestionnaireItemEnableWhenComponent(Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemEnableWhenComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "enableWhen", name, element, index);
    if (element.hasQuestionElement()) {
      composeString(t, "QuestionnaireItemEnableWhenComponent", "question", element.getQuestionElement(), -1);
    }
    if (element.hasOperatorElement()) {
      composeEnum(t, "QuestionnaireItemEnableWhenComponent", "operator", element.getOperatorElement(), -1);
    }
    if (element.hasAnswer()) {
      composeType(t, "QuestionnaireItemEnableWhenComponent", "answer", element.getAnswer(), -1);
    }
  }

  protected void composeQuestionnaireItemAnswerOptionComponent(Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemAnswerOptionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "answerOption", name, element, index);
    if (element.hasValue()) {
      composeType(t, "QuestionnaireItemAnswerOptionComponent", "value", element.getValue(), -1);
    }
    if (element.hasInitialSelectedElement()) {
      composeBoolean(t, "QuestionnaireItemAnswerOptionComponent", "initialSelected", element.getInitialSelectedElement(), -1);
    }
  }

  protected void composeQuestionnaireItemInitialComponent(Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemInitialComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "initial", name, element, index);
    if (element.hasValue()) {
      composeType(t, "QuestionnaireItemInitialComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeQuestionnaireResponse(Complex parent, String parentType, String name, QuestionnaireResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "QuestionnaireResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "QuestionnaireResponse", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "QuestionnaireResponse", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "QuestionnaireResponse", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasQuestionnaireElement()) {
      composeCanonical(t, "QuestionnaireResponse", "questionnaire", element.getQuestionnaireElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "QuestionnaireResponse", "status", element.getStatusElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "QuestionnaireResponse", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "QuestionnaireResponse", "encounter", element.getEncounter(), -1);
    }
    if (element.hasAuthoredElement()) {
      composeDateTime(t, "QuestionnaireResponse", "authored", element.getAuthoredElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "QuestionnaireResponse", "author", element.getAuthor(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "QuestionnaireResponse", "source", element.getSource(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
    }
  }

  protected void composeQuestionnaireResponseItemComponent(Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasLinkIdElement()) {
      composeString(t, "QuestionnaireResponseItemComponent", "linkId", element.getLinkIdElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeUri(t, "QuestionnaireResponseItemComponent", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "QuestionnaireResponseItemComponent", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getAnswer().size(); i++) {
      composeQuestionnaireResponseItemAnswerComponent(t, "QuestionnaireResponseItemComponent", "answer", element.getAnswer().get(i), i);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponseItemComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeQuestionnaireResponseItemAnswerComponent(Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "answer", name, element, index);
    if (element.hasValue()) {
      composeType(t, "QuestionnaireResponseItemAnswerComponent", "value", element.getValue(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponseItemAnswerComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeRegulatedAuthorization(Complex parent, String parentType, String name, RegulatedAuthorization element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "RegulatedAuthorization", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "RegulatedAuthorization", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "RegulatedAuthorization", "subject", element.getSubject().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "RegulatedAuthorization", "type", element.getType(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "RegulatedAuthorization", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getRegion().size(); i++) {
      composeCodeableConcept(t, "RegulatedAuthorization", "region", element.getRegion().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "RegulatedAuthorization", "status", element.getStatus(), -1);
    }
    if (element.hasStatusDateElement()) {
      composeDateTime(t, "RegulatedAuthorization", "statusDate", element.getStatusDateElement(), -1);
    }
    if (element.hasValidityPeriod()) {
      composePeriod(t, "RegulatedAuthorization", "validityPeriod", element.getValidityPeriod(), -1);
    }
    for (int i = 0; i < element.getIndication().size(); i++) {
      composeCodeableReference(t, "RegulatedAuthorization", "indication", element.getIndication().get(i), i);
    }
    if (element.hasIntendedUse()) {
      composeCodeableConcept(t, "RegulatedAuthorization", "intendedUse", element.getIntendedUse(), -1);
    }
    for (int i = 0; i < element.getBasis().size(); i++) {
      composeCodeableConcept(t, "RegulatedAuthorization", "basis", element.getBasis().get(i), i);
    }
    if (element.hasHolder()) {
      composeReference(t, "RegulatedAuthorization", "holder", element.getHolder(), -1);
    }
    if (element.hasRegulator()) {
      composeReference(t, "RegulatedAuthorization", "regulator", element.getRegulator(), -1);
    }
    for (int i = 0; i < element.getAttachedDocument().size(); i++) {
      composeReference(t, "RegulatedAuthorization", "attachedDocument", element.getAttachedDocument().get(i), i);
    }
    if (element.hasCase()) {
      composeRegulatedAuthorizationCaseComponent(t, "RegulatedAuthorization", "case", element.getCase(), -1);
    }
  }

  protected void composeRegulatedAuthorizationCaseComponent(Complex parent, String parentType, String name, RegulatedAuthorization.RegulatedAuthorizationCaseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "case", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "RegulatedAuthorizationCaseComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "RegulatedAuthorizationCaseComponent", "type", element.getType(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "RegulatedAuthorizationCaseComponent", "status", element.getStatus(), -1);
    }
    if (element.hasDate()) {
      composeType(t, "RegulatedAuthorizationCaseComponent", "date", element.getDate(), -1);
    }
    for (int i = 0; i < element.getApplication().size(); i++) {
      composeRegulatedAuthorizationCaseComponent(t, "RegulatedAuthorizationCaseComponent", "application", element.getApplication().get(i), i);
    }
  }

  protected void composeRelatedPerson(Complex parent, String parentType, String name, RelatedPerson element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "RelatedPerson", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "RelatedPerson", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "RelatedPerson", "active", element.getActiveElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "RelatedPerson", "patient", element.getPatient(), -1);
    }
    for (int i = 0; i < element.getRelationship().size(); i++) {
      composeCodeableConcept(t, "RelatedPerson", "relationship", element.getRelationship().get(i), i);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "RelatedPerson", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "RelatedPerson", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "RelatedPerson", "gender", element.getGenderElement(), -1);
    }
    if (element.hasBirthDateElement()) {
      composeDate(t, "RelatedPerson", "birthDate", element.getBirthDateElement(), -1);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "RelatedPerson", "address", element.getAddress().get(i), i);
    }
    for (int i = 0; i < element.getPhoto().size(); i++) {
      composeAttachment(t, "RelatedPerson", "photo", element.getPhoto().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "RelatedPerson", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composeRelatedPersonCommunicationComponent(t, "RelatedPerson", "communication", element.getCommunication().get(i), i);
    }
  }

  protected void composeRelatedPersonCommunicationComponent(Complex parent, String parentType, String name, RelatedPerson.RelatedPersonCommunicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "communication", name, element, index);
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "RelatedPersonCommunicationComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasPreferredElement()) {
      composeBoolean(t, "RelatedPersonCommunicationComponent", "preferred", element.getPreferredElement(), -1);
    }
  }

  protected void composeRequestOrchestration(Complex parent, String parentType, String name, RequestOrchestration element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "RequestOrchestration", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "RequestOrchestration", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "RequestOrchestration", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "RequestOrchestration", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "RequestOrchestration", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "RequestOrchestration", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "RequestOrchestration", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "RequestOrchestration", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "RequestOrchestration", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "RequestOrchestration", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "RequestOrchestration", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "RequestOrchestration", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "RequestOrchestration", "encounter", element.getEncounter(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "RequestOrchestration", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "RequestOrchestration", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableReference(t, "RequestOrchestration", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getGoal().size(); i++) {
      composeReference(t, "RequestOrchestration", "goal", element.getGoal().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "RequestOrchestration", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeRequestOrchestrationActionComponent(t, "RequestOrchestration", "action", element.getAction().get(i), i);
    }
  }

  protected void composeRequestOrchestrationActionComponent(Complex parent, String parentType, String name, RequestOrchestration.RequestOrchestrationActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasLinkIdElement()) {
      composeString(t, "RequestOrchestrationActionComponent", "linkId", element.getLinkIdElement(), -1);
    }
    if (element.hasPrefixElement()) {
      composeString(t, "RequestOrchestrationActionComponent", "prefix", element.getPrefixElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "RequestOrchestrationActionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "RequestOrchestrationActionComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTextEquivalentElement()) {
      composeString(t, "RequestOrchestrationActionComponent", "textEquivalent", element.getTextEquivalentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "RequestOrchestrationActionComponent", "priority", element.getPriorityElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "RequestOrchestrationActionComponent", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getDocumentation().size(); i++) {
      composeRelatedArtifact(t, "RequestOrchestrationActionComponent", "documentation", element.getDocumentation().get(i), i);
    }
    for (int i = 0; i < element.getGoal().size(); i++) {
      composeReference(t, "RequestOrchestrationActionComponent", "goal", element.getGoal().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeRequestOrchestrationActionConditionComponent(t, "RequestOrchestrationActionComponent", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getInput().size(); i++) {
      composeRequestOrchestrationActionInputComponent(t, "RequestOrchestrationActionComponent", "input", element.getInput().get(i), i);
    }
    for (int i = 0; i < element.getOutput().size(); i++) {
      composeRequestOrchestrationActionOutputComponent(t, "RequestOrchestrationActionComponent", "output", element.getOutput().get(i), i);
    }
    for (int i = 0; i < element.getRelatedAction().size(); i++) {
      composeRequestOrchestrationActionRelatedActionComponent(t, "RequestOrchestrationActionComponent", "relatedAction", element.getRelatedAction().get(i), i);
    }
    if (element.hasTiming()) {
      composeType(t, "RequestOrchestrationActionComponent", "timing", element.getTiming(), -1);
    }
    if (element.hasLocation()) {
      composeCodeableReference(t, "RequestOrchestrationActionComponent", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeRequestOrchestrationActionParticipantComponent(t, "RequestOrchestrationActionComponent", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "RequestOrchestrationActionComponent", "type", element.getType(), -1);
    }
    if (element.hasGroupingBehaviorElement()) {
      composeEnum(t, "RequestOrchestrationActionComponent", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
    }
    if (element.hasSelectionBehaviorElement()) {
      composeEnum(t, "RequestOrchestrationActionComponent", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
    }
    if (element.hasRequiredBehaviorElement()) {
      composeEnum(t, "RequestOrchestrationActionComponent", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
    }
    if (element.hasPrecheckBehaviorElement()) {
      composeEnum(t, "RequestOrchestrationActionComponent", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
    }
    if (element.hasCardinalityBehaviorElement()) {
      composeEnum(t, "RequestOrchestrationActionComponent", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
    }
    if (element.hasResource()) {
      composeReference(t, "RequestOrchestrationActionComponent", "resource", element.getResource(), -1);
    }
    if (element.hasDefinition()) {
      composeType(t, "RequestOrchestrationActionComponent", "definition", element.getDefinition(), -1);
    }
    if (element.hasTransformElement()) {
      composeCanonical(t, "RequestOrchestrationActionComponent", "transform", element.getTransformElement(), -1);
    }
    for (int i = 0; i < element.getDynamicValue().size(); i++) {
      composeRequestOrchestrationActionDynamicValueComponent(t, "RequestOrchestrationActionComponent", "dynamicValue", element.getDynamicValue().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeRequestOrchestrationActionComponent(t, "RequestOrchestrationActionComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composeRequestOrchestrationActionConditionComponent(Complex parent, String parentType, String name, RequestOrchestration.RequestOrchestrationActionConditionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "condition", name, element, index);
    if (element.hasKindElement()) {
      composeEnum(t, "RequestOrchestrationActionConditionComponent", "kind", element.getKindElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "RequestOrchestrationActionConditionComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composeRequestOrchestrationActionInputComponent(Complex parent, String parentType, String name, RequestOrchestration.RequestOrchestrationActionInputComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "input", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "RequestOrchestrationActionInputComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasRequirement()) {
      composeDataRequirement(t, "RequestOrchestrationActionInputComponent", "requirement", element.getRequirement(), -1);
    }
    if (element.hasRelatedDataElement()) {
      composeId(t, "RequestOrchestrationActionInputComponent", "relatedData", element.getRelatedDataElement(), -1);
    }
  }

  protected void composeRequestOrchestrationActionOutputComponent(Complex parent, String parentType, String name, RequestOrchestration.RequestOrchestrationActionOutputComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "output", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "RequestOrchestrationActionOutputComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasRequirement()) {
      composeDataRequirement(t, "RequestOrchestrationActionOutputComponent", "requirement", element.getRequirement(), -1);
    }
    if (element.hasRelatedDataElement()) {
      composeString(t, "RequestOrchestrationActionOutputComponent", "relatedData", element.getRelatedDataElement(), -1);
    }
  }

  protected void composeRequestOrchestrationActionRelatedActionComponent(Complex parent, String parentType, String name, RequestOrchestration.RequestOrchestrationActionRelatedActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatedAction", name, element, index);
    if (element.hasTargetIdElement()) {
      composeId(t, "RequestOrchestrationActionRelatedActionComponent", "targetId", element.getTargetIdElement(), -1);
    }
    if (element.hasRelationshipElement()) {
      composeEnum(t, "RequestOrchestrationActionRelatedActionComponent", "relationship", element.getRelationshipElement(), -1);
    }
    if (element.hasOffset()) {
      composeType(t, "RequestOrchestrationActionRelatedActionComponent", "offset", element.getOffset(), -1);
    }
  }

  protected void composeRequestOrchestrationActionParticipantComponent(Complex parent, String parentType, String name, RequestOrchestration.RequestOrchestrationActionParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "RequestOrchestrationActionParticipantComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTypeCanonicalElement()) {
      composeCanonical(t, "RequestOrchestrationActionParticipantComponent", "typeCanonical", element.getTypeCanonicalElement(), -1);
    }
    if (element.hasTypeReference()) {
      composeReference(t, "RequestOrchestrationActionParticipantComponent", "typeReference", element.getTypeReference(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "RequestOrchestrationActionParticipantComponent", "role", element.getRole(), -1);
    }
    if (element.hasFunction()) {
      composeCodeableConcept(t, "RequestOrchestrationActionParticipantComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeType(t, "RequestOrchestrationActionParticipantComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeRequestOrchestrationActionDynamicValueComponent(Complex parent, String parentType, String name, RequestOrchestration.RequestOrchestrationActionDynamicValueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dynamicValue", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "RequestOrchestrationActionDynamicValueComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "RequestOrchestrationActionDynamicValueComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composeRequirements(Complex parent, String parentType, String name, Requirements element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeCanonicalResource(t, "Requirements", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Requirements", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Requirements", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Requirements", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Requirements", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Requirements", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Requirements", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Requirements", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Requirements", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Requirements", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Requirements", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Requirements", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Requirements", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Requirements", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Requirements", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Requirements", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCopyrightLabelElement()) {
      composeString(t, "Requirements", "copyrightLabel", element.getCopyrightLabelElement(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeCanonical(t, "Requirements", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    for (int i = 0; i < element.getActor().size(); i++) {
      composeCanonical(t, "Requirements", "actor", element.getActor().get(i), i);
    }
    for (int i = 0; i < element.getStatement().size(); i++) {
      composeRequirementsStatementComponent(t, "Requirements", "statement", element.getStatement().get(i), i);
    }
  }

  protected void composeRequirementsStatementComponent(Complex parent, String parentType, String name, Requirements.RequirementsStatementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statement", name, element, index);
    if (element.hasKeyElement()) {
      composeId(t, "RequirementsStatementComponent", "key", element.getKeyElement(), -1);
    }
    if (element.hasLabelElement()) {
      composeString(t, "RequirementsStatementComponent", "label", element.getLabelElement(), -1);
    }
    for (int i = 0; i < element.getConformance().size(); i++) {
      composeEnum(t, "RequirementsStatementComponent", "conformance", element.getConformance().get(i), i);
    }
    if (element.hasConditionalityElement()) {
      composeBoolean(t, "RequirementsStatementComponent", "conditionality", element.getConditionalityElement(), -1);
    }
    if (element.hasRequirementElement()) {
      composeMarkdown(t, "RequirementsStatementComponent", "requirement", element.getRequirementElement(), -1);
    }
    if (element.hasDerivedFromElement()) {
      composeString(t, "RequirementsStatementComponent", "derivedFrom", element.getDerivedFromElement(), -1);
    }
    if (element.hasParentElement()) {
      composeString(t, "RequirementsStatementComponent", "parent", element.getParentElement(), -1);
    }
    for (int i = 0; i < element.getSatisfiedBy().size(); i++) {
      composeUrl(t, "RequirementsStatementComponent", "satisfiedBy", element.getSatisfiedBy().get(i), i);
    }
    for (int i = 0; i < element.getReference().size(); i++) {
      composeUrl(t, "RequirementsStatementComponent", "reference", element.getReference().get(i), i);
    }
    for (int i = 0; i < element.getSource().size(); i++) {
      composeReference(t, "RequirementsStatementComponent", "source", element.getSource().get(i), i);
    }
  }

  protected void composeResearchStudy(Complex parent, String parentType, String name, ResearchStudy element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ResearchStudy", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ResearchStudy", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ResearchStudy", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ResearchStudy", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ResearchStudy", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ResearchStudy", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getLabel().size(); i++) {
      composeResearchStudyLabelComponent(t, "ResearchStudy", "label", element.getLabel().get(i), i);
    }
    for (int i = 0; i < element.getProtocol().size(); i++) {
      composeReference(t, "ResearchStudy", "protocol", element.getProtocol().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "ResearchStudy", "partOf", element.getPartOf().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "ResearchStudy", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ResearchStudy", "date", element.getDateElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ResearchStudy", "status", element.getStatusElement(), -1);
    }
    if (element.hasPrimaryPurposeType()) {
      composeCodeableConcept(t, "ResearchStudy", "primaryPurposeType", element.getPrimaryPurposeType(), -1);
    }
    if (element.hasPhase()) {
      composeCodeableConcept(t, "ResearchStudy", "phase", element.getPhase(), -1);
    }
    for (int i = 0; i < element.getStudyDesign().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "studyDesign", element.getStudyDesign().get(i), i);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeCodeableReference(t, "ResearchStudy", "focus", element.getFocus().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getKeyword().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "keyword", element.getKeyword().get(i), i);
    }
    for (int i = 0; i < element.getRegion().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "region", element.getRegion().get(i), i);
    }
    if (element.hasDescriptionSummaryElement()) {
      composeMarkdown(t, "ResearchStudy", "descriptionSummary", element.getDescriptionSummaryElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ResearchStudy", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ResearchStudy", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getSite().size(); i++) {
      composeReference(t, "ResearchStudy", "site", element.getSite().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ResearchStudy", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "classifier", element.getClassifier().get(i), i);
    }
    for (int i = 0; i < element.getAssociatedParty().size(); i++) {
      composeResearchStudyAssociatedPartyComponent(t, "ResearchStudy", "associatedParty", element.getAssociatedParty().get(i), i);
    }
    for (int i = 0; i < element.getProgressStatus().size(); i++) {
      composeResearchStudyProgressStatusComponent(t, "ResearchStudy", "progressStatus", element.getProgressStatus().get(i), i);
    }
    if (element.hasWhyStopped()) {
      composeCodeableConcept(t, "ResearchStudy", "whyStopped", element.getWhyStopped(), -1);
    }
    if (element.hasRecruitment()) {
      composeResearchStudyRecruitmentComponent(t, "ResearchStudy", "recruitment", element.getRecruitment(), -1);
    }
    for (int i = 0; i < element.getComparisonGroup().size(); i++) {
      composeResearchStudyComparisonGroupComponent(t, "ResearchStudy", "comparisonGroup", element.getComparisonGroup().get(i), i);
    }
    for (int i = 0; i < element.getObjective().size(); i++) {
      composeResearchStudyObjectiveComponent(t, "ResearchStudy", "objective", element.getObjective().get(i), i);
    }
    for (int i = 0; i < element.getOutcomeMeasure().size(); i++) {
      composeResearchStudyOutcomeMeasureComponent(t, "ResearchStudy", "outcomeMeasure", element.getOutcomeMeasure().get(i), i);
    }
    for (int i = 0; i < element.getResult().size(); i++) {
      composeReference(t, "ResearchStudy", "result", element.getResult().get(i), i);
    }
  }

  protected void composeResearchStudyLabelComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyLabelComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "label", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ResearchStudyLabelComponent", "type", element.getType(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "ResearchStudyLabelComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeResearchStudyAssociatedPartyComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyAssociatedPartyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "associatedParty", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ResearchStudyAssociatedPartyComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "ResearchStudyAssociatedPartyComponent", "role", element.getRole(), -1);
    }
    for (int i = 0; i < element.getPeriod().size(); i++) {
      composePeriod(t, "ResearchStudyAssociatedPartyComponent", "period", element.getPeriod().get(i), i);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "ResearchStudyAssociatedPartyComponent", "classifier", element.getClassifier().get(i), i);
    }
    if (element.hasParty()) {
      composeReference(t, "ResearchStudyAssociatedPartyComponent", "party", element.getParty(), -1);
    }
  }

  protected void composeResearchStudyProgressStatusComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyProgressStatusComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "progressStatus", name, element, index);
    if (element.hasState()) {
      composeCodeableConcept(t, "ResearchStudyProgressStatusComponent", "state", element.getState(), -1);
    }
    if (element.hasActualElement()) {
      composeBoolean(t, "ResearchStudyProgressStatusComponent", "actual", element.getActualElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ResearchStudyProgressStatusComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeResearchStudyRecruitmentComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyRecruitmentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "recruitment", name, element, index);
    if (element.hasTargetNumberElement()) {
      composeUnsignedInt(t, "ResearchStudyRecruitmentComponent", "targetNumber", element.getTargetNumberElement(), -1);
    }
    if (element.hasActualNumberElement()) {
      composeUnsignedInt(t, "ResearchStudyRecruitmentComponent", "actualNumber", element.getActualNumberElement(), -1);
    }
    if (element.hasEligibility()) {
      composeReference(t, "ResearchStudyRecruitmentComponent", "eligibility", element.getEligibility(), -1);
    }
    if (element.hasActualGroup()) {
      composeReference(t, "ResearchStudyRecruitmentComponent", "actualGroup", element.getActualGroup(), -1);
    }
  }

  protected void composeResearchStudyComparisonGroupComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyComparisonGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "comparisonGroup", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ResearchStudyComparisonGroupComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "ResearchStudyComparisonGroupComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ResearchStudyComparisonGroupComponent", "type", element.getType(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ResearchStudyComparisonGroupComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getIntendedExposure().size(); i++) {
      composeReference(t, "ResearchStudyComparisonGroupComponent", "intendedExposure", element.getIntendedExposure().get(i), i);
    }
    if (element.hasObservedGroup()) {
      composeReference(t, "ResearchStudyComparisonGroupComponent", "observedGroup", element.getObservedGroup(), -1);
    }
  }

  protected void composeResearchStudyObjectiveComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyObjectiveComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "objective", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ResearchStudyObjectiveComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ResearchStudyObjectiveComponent", "type", element.getType(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ResearchStudyObjectiveComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeResearchStudyOutcomeMeasureComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyOutcomeMeasureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "outcomeMeasure", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ResearchStudyOutcomeMeasureComponent", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "ResearchStudyOutcomeMeasureComponent", "type", element.getType().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ResearchStudyOutcomeMeasureComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "ResearchStudyOutcomeMeasureComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeResearchSubject(Complex parent, String parentType, String name, ResearchSubject element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ResearchSubject", name, element, index);
    for (int i = 0; i < element.getIdentifier(