/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VerificationresultFailureAction {
    FATAL,
    WARN,
    RECONLY,
    NONE,
    NULL;


    public static VerificationresultFailureAction fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fatal".equals(codeString)) {
            return FATAL;
        }
        if ("warn".equals(codeString)) {
            return WARN;
        }
        if ("rec-only".equals(codeString)) {
            return RECONLY;
        }
        if ("none".equals(codeString)) {
            return NONE;
        }
        throw new FHIRException("Unknown VerificationresultFailureAction code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FATAL: {
                return "fatal";
            }
            case WARN: {
                return "warn";
            }
            case RECONLY: {
                return "rec-only";
            }
            case NONE: {
                return "none";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/failure-action";
    }

    public String getDefinition() {
        switch (this) {
            case FATAL: {
                return "";
            }
            case WARN: {
                return "";
            }
            case RECONLY: {
                return "";
            }
            case NONE: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FATAL: {
                return "Fatal";
            }
            case WARN: {
                return "Warning";
            }
            case RECONLY: {
                return "Record only";
            }
            case NONE: {
                return "None";
            }
        }
        return "?";
    }
}

