/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VerificationresultCanPushUpdates {
    YES,
    NO,
    UNDETERMINED,
    NULL;


    public static VerificationresultCanPushUpdates fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("yes".equals(codeString)) {
            return YES;
        }
        if ("no".equals(codeString)) {
            return NO;
        }
        if ("undetermined".equals(codeString)) {
            return UNDETERMINED;
        }
        throw new FHIRException("Unknown VerificationresultCanPushUpdates code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case YES: {
                return "yes";
            }
            case NO: {
                return "no";
            }
            case UNDETERMINED: {
                return "undetermined";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/can-push-updates";
    }

    public String getDefinition() {
        switch (this) {
            case YES: {
                return "";
            }
            case NO: {
                return "";
            }
            case UNDETERMINED: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case YES: {
                return "Yes";
            }
            case NO: {
                return "No";
            }
            case UNDETERMINED: {
                return "Undetermined";
            }
        }
        return "?";
    }
}

