/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.VariantState;

public class VariantStateEnumFactory
implements EnumFactory<VariantState> {
    @Override
    public VariantState fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("positive".equals(codeString)) {
            return VariantState.POSITIVE;
        }
        if ("negative".equals(codeString)) {
            return VariantState.NEGATIVE;
        }
        if ("absent".equals(codeString)) {
            return VariantState.ABSENT;
        }
        throw new IllegalArgumentException("Unknown VariantState code '" + codeString + "'");
    }

    @Override
    public String toCode(VariantState code) {
        if (code == VariantState.POSITIVE) {
            return "positive";
        }
        if (code == VariantState.NEGATIVE) {
            return "negative";
        }
        if (code == VariantState.ABSENT) {
            return "absent";
        }
        return "?";
    }

    @Override
    public String toSystem(VariantState code) {
        return code.getSystem();
    }
}

