/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3MaritalStatus {
    A,
    D,
    I,
    L,
    M,
    C,
    P,
    T,
    U,
    S,
    W,
    NULL;


    public static V3MaritalStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("A".equals(codeString)) {
            return A;
        }
        if ("D".equals(codeString)) {
            return D;
        }
        if ("I".equals(codeString)) {
            return I;
        }
        if ("L".equals(codeString)) {
            return L;
        }
        if ("M".equals(codeString)) {
            return M;
        }
        if ("C".equals(codeString)) {
            return C;
        }
        if ("P".equals(codeString)) {
            return P;
        }
        if ("T".equals(codeString)) {
            return T;
        }
        if ("U".equals(codeString)) {
            return U;
        }
        if ("S".equals(codeString)) {
            return S;
        }
        if ("W".equals(codeString)) {
            return W;
        }
        throw new FHIRException("Unknown V3MaritalStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case A: {
                return "A";
            }
            case D: {
                return "D";
            }
            case I: {
                return "I";
            }
            case L: {
                return "L";
            }
            case M: {
                return "M";
            }
            case C: {
                return "C";
            }
            case P: {
                return "P";
            }
            case T: {
                return "T";
            }
            case U: {
                return "U";
            }
            case S: {
                return "S";
            }
            case W: {
                return "W";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus";
    }

    public String getDefinition() {
        switch (this) {
            case A: {
                return "Marriage contract has been declared null and to not have existed";
            }
            case D: {
                return "Marriage contract has been declared dissolved and inactive";
            }
            case I: {
                return "Subject to an Interlocutory Decree.";
            }
            case L: {
                return "Legally Separated";
            }
            case M: {
                return "A current marriage contract is active";
            }
            case C: {
                return "a marriage recognized in some jurisdictions and based on the parties' agreement to consider themselves married and can also be based on documentation of cohabitation.\r\n\n                        This definition was based on https://www.merriam-webster.com/dictionary/common-law%20marriage.";
            }
            case P: {
                return "More than 1 current spouse";
            }
            case T: {
                return "Person declares that a domestic partner relationship exists.";
            }
            case U: {
                return "Currently not in a marriage contract.";
            }
            case S: {
                return "No marriage contract has ever been entered";
            }
            case W: {
                return "The spouse has died";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case A: {
                return "Annulled";
            }
            case D: {
                return "Divorced";
            }
            case I: {
                return "Interlocutory";
            }
            case L: {
                return "Legally Separated";
            }
            case M: {
                return "Married";
            }
            case C: {
                return "Common Law";
            }
            case P: {
                return "Polygamous";
            }
            case T: {
                return "Domestic partner";
            }
            case U: {
                return "unmarried";
            }
            case S: {
                return "Never Married";
            }
            case W: {
                return "Widowed";
            }
        }
        return "?";
    }
}

