/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3LocalRemoteControlState {
    L,
    R,
    NULL;


    public static V3LocalRemoteControlState fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("L".equals(codeString)) {
            return L;
        }
        if ("R".equals(codeString)) {
            return R;
        }
        throw new FHIRException("Unknown V3LocalRemoteControlState code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case L: {
                return "L";
            }
            case R: {
                return "R";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-LocalRemoteControlState";
    }

    public String getDefinition() {
        switch (this) {
            case L: {
                return "An equipment can either work autonomously ('Local' control state).";
            }
            case R: {
                return "An equipment can be controlled by another system, e.g., LAS computer ('Remote' control state).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case L: {
                return "Local";
            }
            case R: {
                return "Remote";
            }
        }
        return "?";
    }
}

