/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3ContentProcessingMode {
    SEQL,
    UNOR,
    NULL;


    public static V3ContentProcessingMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("SEQL".equals(codeString)) {
            return SEQL;
        }
        if ("UNOR".equals(codeString)) {
            return UNOR;
        }
        throw new FHIRException("Unknown V3ContentProcessingMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SEQL: {
                return "SEQL";
            }
            case UNOR: {
                return "UNOR";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-ContentProcessingMode";
    }

    public String getDefinition() {
        switch (this) {
            case SEQL: {
                return "Description:The content should be processed in a sequential fashion.";
            }
            case UNOR: {
                return "Description:The content may be processed in any order.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SEQL: {
                return "Sequential";
            }
            case UNOR: {
                return "Unordered";
            }
        }
        return "?";
    }
}

