/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SmartCapabilities {
    LAUNCHEHR,
    LAUNCHSTANDALONE,
    CLIENTPUBLIC,
    CLIENTCONFIDENTIALSYMMETRIC,
    SSOOPENIDCONNECT,
    CONTEXTPASSTHROUGHBANNER,
    CONTEXTPASSTHROUGHSTYLE,
    CONTEXTEHRPATIENT,
    CONTEXTEHRENCOUNTER,
    CONTEXTSTANDALONEPATIENT,
    CONTEXTSTANDALONEENCOUNTER,
    PERMISSIONOFFLINE,
    PERMISSIONPATIENT,
    PERMISSIONUSER,
    NULL;


    public static SmartCapabilities fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("launch-ehr".equals(codeString)) {
            return LAUNCHEHR;
        }
        if ("launch-standalone".equals(codeString)) {
            return LAUNCHSTANDALONE;
        }
        if ("client-public".equals(codeString)) {
            return CLIENTPUBLIC;
        }
        if ("client-confidential-symmetric".equals(codeString)) {
            return CLIENTCONFIDENTIALSYMMETRIC;
        }
        if ("sso-openid-connect".equals(codeString)) {
            return SSOOPENIDCONNECT;
        }
        if ("context-passthrough-banner".equals(codeString)) {
            return CONTEXTPASSTHROUGHBANNER;
        }
        if ("context-passthrough-style".equals(codeString)) {
            return CONTEXTPASSTHROUGHSTYLE;
        }
        if ("context-ehr-patient".equals(codeString)) {
            return CONTEXTEHRPATIENT;
        }
        if ("context-ehr-encounter".equals(codeString)) {
            return CONTEXTEHRENCOUNTER;
        }
        if ("context-standalone-patient".equals(codeString)) {
            return CONTEXTSTANDALONEPATIENT;
        }
        if ("context-standalone-encounter".equals(codeString)) {
            return CONTEXTSTANDALONEENCOUNTER;
        }
        if ("permission-offline".equals(codeString)) {
            return PERMISSIONOFFLINE;
        }
        if ("permission-patient".equals(codeString)) {
            return PERMISSIONPATIENT;
        }
        if ("permission-user".equals(codeString)) {
            return PERMISSIONUSER;
        }
        throw new FHIRException("Unknown SmartCapabilities code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LAUNCHEHR: {
                return "launch-ehr";
            }
            case LAUNCHSTANDALONE: {
                return "launch-standalone";
            }
            case CLIENTPUBLIC: {
                return "client-public";
            }
            case CLIENTCONFIDENTIALSYMMETRIC: {
                return "client-confidential-symmetric";
            }
            case SSOOPENIDCONNECT: {
                return "sso-openid-connect";
            }
            case CONTEXTPASSTHROUGHBANNER: {
                return "context-passthrough-banner";
            }
            case CONTEXTPASSTHROUGHSTYLE: {
                return "context-passthrough-style";
            }
            case CONTEXTEHRPATIENT: {
                return "context-ehr-patient";
            }
            case CONTEXTEHRENCOUNTER: {
                return "context-ehr-encounter";
            }
            case CONTEXTSTANDALONEPATIENT: {
                return "context-standalone-patient";
            }
            case CONTEXTSTANDALONEENCOUNTER: {
                return "context-standalone-encounter";
            }
            case PERMISSIONOFFLINE: {
                return "permission-offline";
            }
            case PERMISSIONPATIENT: {
                return "permission-patient";
            }
            case PERMISSIONUSER: {
                return "permission-user";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/smart-capabilities";
    }

    public String getDefinition() {
        switch (this) {
            case LAUNCHEHR: {
                return "support for SMART\u2019s EHR Launch mode.";
            }
            case LAUNCHSTANDALONE: {
                return "support for SMART\u2019s Standalone Launch mode.";
            }
            case CLIENTPUBLIC: {
                return "support for SMART\u2019s public client profile (no client authentication).";
            }
            case CLIENTCONFIDENTIALSYMMETRIC: {
                return "support for SMART\u2019s confidential client profile (symmetric client secret authentication).";
            }
            case SSOOPENIDCONNECT: {
                return "support for SMART\u2019s OpenID Connect profile.";
            }
            case CONTEXTPASSTHROUGHBANNER: {
                return "support for \u201cneed patient banner\u201d launch context (conveyed via need_patient_banner token parameter).";
            }
            case CONTEXTPASSTHROUGHSTYLE: {
                return "support for \u201cSMART style URL\u201d launch context (conveyed via smart_style_url token parameter).";
            }
            case CONTEXTEHRPATIENT: {
                return "support for patient-level launch context (requested by launch/patient scope, conveyed via patient token parameter).";
            }
            case CONTEXTEHRENCOUNTER: {
                return "support for encounter-level launch context (requested by launch/encounter scope, conveyed via encounter token parameter).";
            }
            case CONTEXTSTANDALONEPATIENT: {
                return "support for patient-level launch context (requested by launch/patient scope, conveyed via patient token parameter).";
            }
            case CONTEXTSTANDALONEENCOUNTER: {
                return "support for encounter-level launch context (requested by launch/encounter scope, conveyed via encounter token parameter).";
            }
            case PERMISSIONOFFLINE: {
                return "support for refresh tokens (requested by offline_access scope).";
            }
            case PERMISSIONPATIENT: {
                return "support for patient-level scopes (e.g. patient/Observation.read).";
            }
            case PERMISSIONUSER: {
                return "support for user-level scopes (e.g. user/Appointment.read).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LAUNCHEHR: {
                return "EHR Launch Mode";
            }
            case LAUNCHSTANDALONE: {
                return "Standalone Launch Mode";
            }
            case CLIENTPUBLIC: {
                return "Public Client Profile";
            }
            case CLIENTCONFIDENTIALSYMMETRIC: {
                return "Confidential Client Profile";
            }
            case SSOOPENIDCONNECT: {
                return "Supports OpenID Connect";
            }
            case CONTEXTPASSTHROUGHBANNER: {
                return "Allows \"Need Patient Banner\"";
            }
            case CONTEXTPASSTHROUGHSTYLE: {
                return "Allows \"Smart Style Style\"";
            }
            case CONTEXTEHRPATIENT: {
                return "Allows \"Patient Level Launch Context (EHR)\"";
            }
            case CONTEXTEHRENCOUNTER: {
                return "Allows \"Encounter Level Launch Context (EHR)\"";
            }
            case CONTEXTSTANDALONEPATIENT: {
                return "Allows \"Patient Level Launch Context (STANDALONE)\"";
            }
            case CONTEXTSTANDALONEENCOUNTER: {
                return "Allows \"Encounter Level Launch Context (STANDALONE)\"";
            }
            case PERMISSIONOFFLINE: {
                return "Supports Refresh Token";
            }
            case PERMISSIONPATIENT: {
                return "Supports Patient Level Scopes";
            }
            case PERMISSIONUSER: {
                return "Supports User Level Scopes";
            }
        }
        return "?";
    }
}

