/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RiskEstimateType {
    PROPORTION,
    DERIVEDPROPORTION,
    MEAN,
    MEDIAN,
    COUNT,
    DESCRIPTIVE,
    NULL;


    public static RiskEstimateType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proportion".equals(codeString)) {
            return PROPORTION;
        }
        if ("derivedProportion".equals(codeString)) {
            return DERIVEDPROPORTION;
        }
        if ("mean".equals(codeString)) {
            return MEAN;
        }
        if ("median".equals(codeString)) {
            return MEDIAN;
        }
        if ("count".equals(codeString)) {
            return COUNT;
        }
        if ("descriptive".equals(codeString)) {
            return DESCRIPTIVE;
        }
        throw new FHIRException("Unknown RiskEstimateType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPORTION: {
                return "proportion";
            }
            case DERIVEDPROPORTION: {
                return "derivedProportion";
            }
            case MEAN: {
                return "mean";
            }
            case MEDIAN: {
                return "median";
            }
            case COUNT: {
                return "count";
            }
            case DESCRIPTIVE: {
                return "descriptive";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/risk-estimate-type";
    }

    public String getDefinition() {
        switch (this) {
            case PROPORTION: {
                return "dichotomous measure (present or absent) reported as a ratio compared to the denominator of 1 (A percentage is a proportion with denominator of 100).";
            }
            case DERIVEDPROPORTION: {
                return "A special use case where the proportion is derived from a formula rather than derived from summary evidence.";
            }
            case MEAN: {
                return "continuous numerical measure reported as an average.";
            }
            case MEDIAN: {
                return "continuous numerical measure reported as the middle of the range.";
            }
            case COUNT: {
                return "descriptive measure reported as total number of items.";
            }
            case DESCRIPTIVE: {
                return "descriptive measure reported as narrative.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPORTION: {
                return "proportion";
            }
            case DERIVEDPROPORTION: {
                return "derivedProportion";
            }
            case MEAN: {
                return "mean";
            }
            case MEDIAN: {
                return "median";
            }
            case COUNT: {
                return "count";
            }
            case DESCRIPTIVE: {
                return "descriptive";
            }
        }
        return "?";
    }
}

