/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.RequestPriority;

public class RequestPriorityEnumFactory
implements EnumFactory<RequestPriority> {
    @Override
    public RequestPriority fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("routine".equals(codeString)) {
            return RequestPriority.ROUTINE;
        }
        if ("urgent".equals(codeString)) {
            return RequestPriority.URGENT;
        }
        if ("asap".equals(codeString)) {
            return RequestPriority.ASAP;
        }
        if ("stat".equals(codeString)) {
            return RequestPriority.STAT;
        }
        throw new IllegalArgumentException("Unknown RequestPriority code '" + codeString + "'");
    }

    @Override
    public String toCode(RequestPriority code) {
        if (code == RequestPriority.ROUTINE) {
            return "routine";
        }
        if (code == RequestPriority.URGENT) {
            return "urgent";
        }
        if (code == RequestPriority.ASAP) {
            return "asap";
        }
        if (code == RequestPriority.STAT) {
            return "stat";
        }
        return "?";
    }

    @Override
    public String toSystem(RequestPriority code) {
        return code.getSystem();
    }
}

