/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RecommendationStrength {
    STRONG,
    WEAK,
    NULL;


    public static RecommendationStrength fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("strong".equals(codeString)) {
            return STRONG;
        }
        if ("weak".equals(codeString)) {
            return WEAK;
        }
        throw new FHIRException("Unknown RecommendationStrength code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case STRONG: {
                return "strong";
            }
            case WEAK: {
                return "weak";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/recommendation-strength";
    }

    public String getDefinition() {
        switch (this) {
            case STRONG: {
                return "Strong recommendation.";
            }
            case WEAK: {
                return "Weak recommendation.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case STRONG: {
                return "Strong";
            }
            case WEAK: {
                return "Weak";
            }
        }
        return "?";
    }
}

