/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ReactionEventSeverity {
    MILD,
    MODERATE,
    SEVERE,
    NULL;


    public static ReactionEventSeverity fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("mild".equals(codeString)) {
            return MILD;
        }
        if ("moderate".equals(codeString)) {
            return MODERATE;
        }
        if ("severe".equals(codeString)) {
            return SEVERE;
        }
        throw new FHIRException("Unknown ReactionEventSeverity code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MILD: {
                return "mild";
            }
            case MODERATE: {
                return "moderate";
            }
            case SEVERE: {
                return "severe";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/reaction-event-severity";
    }

    public String getDefinition() {
        switch (this) {
            case MILD: {
                return "Causes mild physiological effects.";
            }
            case MODERATE: {
                return "Causes moderate physiological effects.";
            }
            case SEVERE: {
                return "Causes severe physiological effects.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MILD: {
                return "Mild";
            }
            case MODERATE: {
                return "Moderate";
            }
            case SEVERE: {
                return "Severe";
            }
        }
        return "?";
    }
}

