/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.MessageSignificanceCategory;

public class MessageSignificanceCategoryEnumFactory
implements EnumFactory<MessageSignificanceCategory> {
    @Override
    public MessageSignificanceCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("consequence".equals(codeString)) {
            return MessageSignificanceCategory.CONSEQUENCE;
        }
        if ("currency".equals(codeString)) {
            return MessageSignificanceCategory.CURRENCY;
        }
        if ("notification".equals(codeString)) {
            return MessageSignificanceCategory.NOTIFICATION;
        }
        throw new IllegalArgumentException("Unknown MessageSignificanceCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MessageSignificanceCategory code) {
        if (code == MessageSignificanceCategory.CONSEQUENCE) {
            return "consequence";
        }
        if (code == MessageSignificanceCategory.CURRENCY) {
            return "currency";
        }
        if (code == MessageSignificanceCategory.NOTIFICATION) {
            return "notification";
        }
        return "?";
    }

    @Override
    public String toSystem(MessageSignificanceCategory code) {
        return code.getSystem();
    }
}

