/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationrequestCourseOfTherapy {
    CONTINUOUS,
    ACUTE,
    SEASONAL,
    NULL;


    public static MedicationrequestCourseOfTherapy fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("continuous".equals(codeString)) {
            return CONTINUOUS;
        }
        if ("acute".equals(codeString)) {
            return ACUTE;
        }
        if ("seasonal".equals(codeString)) {
            return SEASONAL;
        }
        throw new FHIRException("Unknown MedicationrequestCourseOfTherapy code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CONTINUOUS: {
                return "continuous";
            }
            case ACUTE: {
                return "acute";
            }
            case SEASONAL: {
                return "seasonal";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/medicationrequest-course-of-therapy";
    }

    public String getDefinition() {
        switch (this) {
            case CONTINUOUS: {
                return "A medication which is expected to be continued beyond the present order and which the patient should be assumed to be taking unless explicitly stopped.";
            }
            case ACUTE: {
                return "A medication which the patient is only expected to consume for the duration of the current order and which is not expected to be renewed.";
            }
            case SEASONAL: {
                return "A medication which is expected to be used on a part time basis at certain times of the year";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CONTINUOUS: {
                return "Continuous long term therapy";
            }
            case ACUTE: {
                return "Short course (acute) therapy";
            }
            case SEASONAL: {
                return "Seasonal";
            }
        }
        return "?";
    }
}

