/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.MeasureType;

public class MeasureTypeEnumFactory
implements EnumFactory<MeasureType> {
    @Override
    public MeasureType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("process".equals(codeString)) {
            return MeasureType.PROCESS;
        }
        if ("outcome".equals(codeString)) {
            return MeasureType.OUTCOME;
        }
        if ("structure".equals(codeString)) {
            return MeasureType.STRUCTURE;
        }
        if ("patient-reported-outcome".equals(codeString)) {
            return MeasureType.PATIENTREPORTEDOUTCOME;
        }
        if ("composite".equals(codeString)) {
            return MeasureType.COMPOSITE;
        }
        throw new IllegalArgumentException("Unknown MeasureType code '" + codeString + "'");
    }

    @Override
    public String toCode(MeasureType code) {
        if (code == MeasureType.PROCESS) {
            return "process";
        }
        if (code == MeasureType.OUTCOME) {
            return "outcome";
        }
        if (code == MeasureType.STRUCTURE) {
            return "structure";
        }
        if (code == MeasureType.PATIENTREPORTEDOUTCOME) {
            return "patient-reported-outcome";
        }
        if (code == MeasureType.COMPOSITE) {
            return "composite";
        }
        return "?";
    }

    @Override
    public String toSystem(MeasureType code) {
        return code.getSystem();
    }
}

