/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.MatchGrade;

public class MatchGradeEnumFactory
implements EnumFactory<MatchGrade> {
    @Override
    public MatchGrade fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("certain".equals(codeString)) {
            return MatchGrade.CERTAIN;
        }
        if ("probable".equals(codeString)) {
            return MatchGrade.PROBABLE;
        }
        if ("possible".equals(codeString)) {
            return MatchGrade.POSSIBLE;
        }
        if ("certainly-not".equals(codeString)) {
            return MatchGrade.CERTAINLYNOT;
        }
        throw new IllegalArgumentException("Unknown MatchGrade code '" + codeString + "'");
    }

    @Override
    public String toCode(MatchGrade code) {
        if (code == MatchGrade.CERTAIN) {
            return "certain";
        }
        if (code == MatchGrade.PROBABLE) {
            return "probable";
        }
        if (code == MatchGrade.POSSIBLE) {
            return "possible";
        }
        if (code == MatchGrade.CERTAINLYNOT) {
            return "certainly-not";
        }
        return "?";
    }

    @Override
    public String toSystem(MatchGrade code) {
        return code.getSystem();
    }
}

