/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LocationStatus {
    ACTIVE,
    SUSPENDED,
    INACTIVE,
    NULL;


    public static LocationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        throw new FHIRException("Unknown LocationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case INACTIVE: {
                return "inactive";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/location-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The location is operational.";
            }
            case SUSPENDED: {
                return "The location is temporarily closed.";
            }
            case INACTIVE: {
                return "The location is no longer used.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case INACTIVE: {
                return "Inactive";
            }
        }
        return "?";
    }
}

