/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExDiagnosisOnAdmission {
    YES,
    NO,
    UNKNOWN,
    NULL;


    public static ExDiagnosisOnAdmission fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("yes".equals(codeString)) {
            return YES;
        }
        if ("no".equals(codeString)) {
            return NO;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ExDiagnosisOnAdmission code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case YES: {
                return "yes";
            }
            case NO: {
                return "no";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/ex-diagnosis-on-admission";
    }

    public String getDefinition() {
        switch (this) {
            case YES: {
                return "Diagnosis was present at time of inpatient admission.";
            }
            case NO: {
                return "Diagnosis was not present at time of inpatient admission.";
            }
            case UNKNOWN: {
                return "Not known if condition was present at the time of inpatient admission.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case YES: {
                return "Yes";
            }
            case NO: {
                return "No";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

