/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EndpointStatus {
    ACTIVE,
    SUSPENDED,
    ERROR,
    OFF,
    ENTEREDINERROR,
    TEST,
    NULL;


    public static EndpointStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        if ("off".equals(codeString)) {
            return OFF;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("test".equals(codeString)) {
            return TEST;
        }
        throw new FHIRException("Unknown EndpointStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case ERROR: {
                return "error";
            }
            case OFF: {
                return "off";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case TEST: {
                return "test";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/endpoint-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "This endpoint is expected to be active and can be used.";
            }
            case SUSPENDED: {
                return "This endpoint is temporarily unavailable.";
            }
            case ERROR: {
                return "This endpoint has exceeded connectivity thresholds and is considered in an error state and should no longer be attempted to connect to until corrective action is taken.";
            }
            case OFF: {
                return "This endpoint is no longer to be used.";
            }
            case ENTEREDINERROR: {
                return "This instance should not have been part of this patient's medical record.";
            }
            case TEST: {
                return "This endpoint is not intended for production usage.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case ERROR: {
                return "Error";
            }
            case OFF: {
                return "Off";
            }
            case ENTEREDINERROR: {
                return "Entered in error";
            }
            case TEST: {
                return "Test";
            }
        }
        return "?";
    }
}

