/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DeviceNametype {
    UDILABELNAME,
    USERFRIENDLYNAME,
    PATIENTREPORTEDNAME,
    MANUFACTURERNAME,
    MODELNAME,
    OTHER,
    NULL;


    public static DeviceNametype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("udi-label-name".equals(codeString)) {
            return UDILABELNAME;
        }
        if ("user-friendly-name".equals(codeString)) {
            return USERFRIENDLYNAME;
        }
        if ("patient-reported-name".equals(codeString)) {
            return PATIENTREPORTEDNAME;
        }
        if ("manufacturer-name".equals(codeString)) {
            return MANUFACTURERNAME;
        }
        if ("model-name".equals(codeString)) {
            return MODELNAME;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown DeviceNametype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UDILABELNAME: {
                return "udi-label-name";
            }
            case USERFRIENDLYNAME: {
                return "user-friendly-name";
            }
            case PATIENTREPORTEDNAME: {
                return "patient-reported-name";
            }
            case MANUFACTURERNAME: {
                return "manufacturer-name";
            }
            case MODELNAME: {
                return "model-name";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/device-nametype";
    }

    public String getDefinition() {
        switch (this) {
            case UDILABELNAME: {
                return "UDI Label name.";
            }
            case USERFRIENDLYNAME: {
                return "User Friendly name.";
            }
            case PATIENTREPORTEDNAME: {
                return "Patient Reported name.";
            }
            case MANUFACTURERNAME: {
                return "Manufacturer name.";
            }
            case MODELNAME: {
                return "Model name.";
            }
            case OTHER: {
                return "other.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UDILABELNAME: {
                return "UDI Label name";
            }
            case USERFRIENDLYNAME: {
                return "User Friendly name";
            }
            case PATIENTREPORTEDNAME: {
                return "Patient Reported name";
            }
            case MANUFACTURERNAME: {
                return "Manufacturer name";
            }
            case MODELNAME: {
                return "Model name";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }
}

