/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CoverageSelfpay {
    PAY,
    NULL;


    public static CoverageSelfpay fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("pay".equals(codeString)) {
            return PAY;
        }
        throw new FHIRException("Unknown CoverageSelfpay code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PAY: {
                return "pay";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/coverage-selfpay";
    }

    public String getDefinition() {
        switch (this) {
            case PAY: {
                return "An individual or organization is paying directly for goods and services.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PAY: {
                return "Pay";
            }
        }
        return "?";
    }
}

