/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractScope {
    POLICY,
    NULL;


    public static ContractScope fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("policy".equals(codeString)) {
            return POLICY;
        }
        throw new FHIRException("Unknown ContractScope code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case POLICY: {
                return "policy";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contract-scope";
    }

    public String getDefinition() {
        switch (this) {
            case POLICY: {
                return "To be completed";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case POLICY: {
                return "Policy";
            }
        }
        return "?";
    }
}

