/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ContractAction;

public class ContractActionEnumFactory
implements EnumFactory<ContractAction> {
    @Override
    public ContractAction fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("action-a".equals(codeString)) {
            return ContractAction.ACTIONA;
        }
        if ("action-b".equals(codeString)) {
            return ContractAction.ACTIONB;
        }
        throw new IllegalArgumentException("Unknown ContractAction code '" + codeString + "'");
    }

    @Override
    public String toCode(ContractAction code) {
        if (code == ContractAction.ACTIONA) {
            return "action-a";
        }
        if (code == ContractAction.ACTIONB) {
            return "action-b";
        }
        return "?";
    }

    @Override
    public String toSystem(ContractAction code) {
        return code.getSystem();
    }
}

