/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConsentStateCodes {
    DRAFT,
    PROPOSED,
    ACTIVE,
    REJECTED,
    INACTIVE,
    ENTEREDINERROR,
    NULL;


    public static ConsentStateCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("proposed".equals(codeString)) {
            return PROPOSED;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("rejected".equals(codeString)) {
            return REJECTED;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown ConsentStateCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case PROPOSED: {
                return "proposed";
            }
            case ACTIVE: {
                return "active";
            }
            case REJECTED: {
                return "rejected";
            }
            case INACTIVE: {
                return "inactive";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/consent-state-codes";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The consent is in development or awaiting use but is not yet intended to be acted upon.";
            }
            case PROPOSED: {
                return "The consent has been proposed but not yet agreed to by all parties. The negotiation stage.";
            }
            case ACTIVE: {
                return "The consent is to be followed and enforced.";
            }
            case REJECTED: {
                return "The consent has been rejected by one or more of the parties.";
            }
            case INACTIVE: {
                return "The consent is terminated or replaced.";
            }
            case ENTEREDINERROR: {
                return "The consent was created wrongly (e.g. wrong patient) and should be ignored.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Pending";
            }
            case PROPOSED: {
                return "Proposed";
            }
            case ACTIVE: {
                return "Active";
            }
            case REJECTED: {
                return "Rejected";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

