/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.CodeSearchSupport;

public class CodeSearchSupportEnumFactory
implements EnumFactory<CodeSearchSupport> {
    @Override
    public CodeSearchSupport fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("explicit".equals(codeString)) {
            return CodeSearchSupport.EXPLICIT;
        }
        if ("all".equals(codeString)) {
            return CodeSearchSupport.ALL;
        }
        throw new IllegalArgumentException("Unknown CodeSearchSupport code '" + codeString + "'");
    }

    @Override
    public String toCode(CodeSearchSupport code) {
        if (code == CodeSearchSupport.EXPLICIT) {
            return "explicit";
        }
        if (code == CodeSearchSupport.ALL) {
            return "all";
        }
        return "?";
    }

    @Override
    public String toSystem(CodeSearchSupport code) {
        return code.getSystem();
    }
}

