/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventSeriousness {
    NONSERIOUS,
    SERIOUS,
    NULL;


    public static AdverseEventSeriousness fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("non-serious".equals(codeString)) {
            return NONSERIOUS;
        }
        if ("serious".equals(codeString)) {
            return SERIOUS;
        }
        throw new FHIRException("Unknown AdverseEventSeriousness code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NONSERIOUS: {
                return "non-serious";
            }
            case SERIOUS: {
                return "serious";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/adverse-event-seriousness";
    }

    public String getDefinition() {
        switch (this) {
            case NONSERIOUS: {
                return "This event is considered not to have the potential for persistent or costly injury or consequence.";
            }
            case SERIOUS: {
                return "This event is considered to have the potential for persistent or costly injury or consequence.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NONSERIOUS: {
                return "Non-serious";
            }
            case SERIOUS: {
                return "Serious";
            }
        }
        return "?";
    }
}

