/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Adjudication {
    SUBMITTED,
    COPAY,
    ELIGIBLE,
    DEDUCTIBLE,
    UNALLOCDEDUCT,
    ELIGPERCENT,
    TAX,
    BENEFIT,
    NULL;


    public static Adjudication fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("submitted".equals(codeString)) {
            return SUBMITTED;
        }
        if ("copay".equals(codeString)) {
            return COPAY;
        }
        if ("eligible".equals(codeString)) {
            return ELIGIBLE;
        }
        if ("deductible".equals(codeString)) {
            return DEDUCTIBLE;
        }
        if ("unallocdeduct".equals(codeString)) {
            return UNALLOCDEDUCT;
        }
        if ("eligpercent".equals(codeString)) {
            return ELIGPERCENT;
        }
        if ("tax".equals(codeString)) {
            return TAX;
        }
        if ("benefit".equals(codeString)) {
            return BENEFIT;
        }
        throw new FHIRException("Unknown Adjudication code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SUBMITTED: {
                return "submitted";
            }
            case COPAY: {
                return "copay";
            }
            case ELIGIBLE: {
                return "eligible";
            }
            case DEDUCTIBLE: {
                return "deductible";
            }
            case UNALLOCDEDUCT: {
                return "unallocdeduct";
            }
            case ELIGPERCENT: {
                return "eligpercent";
            }
            case TAX: {
                return "tax";
            }
            case BENEFIT: {
                return "benefit";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/adjudication";
    }

    public String getDefinition() {
        switch (this) {
            case SUBMITTED: {
                return "The total submitted amount for the claim or group or line item.";
            }
            case COPAY: {
                return "Patient Co-Payment";
            }
            case ELIGIBLE: {
                return "Amount of the change which is considered for adjudication.";
            }
            case DEDUCTIBLE: {
                return "Amount deducted from the eligible amount prior to adjudication.";
            }
            case UNALLOCDEDUCT: {
                return "The amount of deductible which could not allocated to other line items.";
            }
            case ELIGPERCENT: {
                return "Eligible Percentage.";
            }
            case TAX: {
                return "The amount of tax.";
            }
            case BENEFIT: {
                return "Amount payable under the coverage";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SUBMITTED: {
                return "Submitted Amount";
            }
            case COPAY: {
                return "CoPay";
            }
            case ELIGIBLE: {
                return "Eligible Amount";
            }
            case DEDUCTIBLE: {
                return "Deductible";
            }
            case UNALLOCDEDUCT: {
                return "Unallocated Deductible";
            }
            case ELIGPERCENT: {
                return "Eligible %";
            }
            case TAX: {
                return "Tax";
            }
            case BENEFIT: {
                return "Benefit Amount";
            }
        }
        return "?";
    }
}

