/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.AddressType;

public class AddressTypeEnumFactory
implements EnumFactory<AddressType> {
    @Override
    public AddressType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("postal".equals(codeString)) {
            return AddressType.POSTAL;
        }
        if ("physical".equals(codeString)) {
            return AddressType.PHYSICAL;
        }
        if ("both".equals(codeString)) {
            return AddressType.BOTH;
        }
        throw new IllegalArgumentException("Unknown AddressType code '" + codeString + "'");
    }

    @Override
    public String toCode(AddressType code) {
        if (code == AddressType.POSTAL) {
            return "postal";
        }
        if (code == AddressType.PHYSICAL) {
            return "physical";
        }
        if (code == AddressType.BOTH) {
            return "both";
        }
        return "?";
    }

    @Override
    public String toSystem(AddressType code) {
        return code.getSystem();
    }
}

