/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Statistic;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="OrderedDistribution")
public class OrderedDistribution
extends BackboneType
implements ICompositeType {
    @Child(name="description", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A description of the content and value of the statistic", formalDefinition="A description of the content and value of the statistic.")
    protected StringType description;
    @Child(name="note", type={Annotation.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
    protected List<Annotation> note;
    @Child(name="numberOfIntervals", type={IntegerType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of intervals in an array, eg 4 for quartiles", formalDefinition="Number of intervals in an array, eg 4 for quartiles.")
    protected IntegerType numberOfIntervals;
    @Child(name="bottomOfFirstInterval", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Bottom of first interval", formalDefinition="Bottom of first interval.")
    protected Quantity bottomOfFirstInterval;
    @Child(name="interval", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Interval", formalDefinition="Interval.")
    protected List<OrderedDistributionIntervalComponent> interval;
    @Child(name="topOfInterval", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Singular value of the statistic at the upper bound of the interval", formalDefinition="Singular value of the statistic at the upper bound of the interval.")
    protected Quantity topOfInterval;
    private static final long serialVersionUID = -1559333328L;

    public OrderedDistribution() {
    }

    public OrderedDistribution(IntegerType numberOfIntervals) {
        this.numberOfIntervals = numberOfIntervals;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderedDistribution.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public OrderedDistribution setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public OrderedDistribution setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public OrderedDistribution setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public OrderedDistribution addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public IntegerType getNumberOfIntervalsElement() {
        if (this.numberOfIntervals == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderedDistribution.numberOfIntervals");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfIntervals = new IntegerType();
            }
        }
        return this.numberOfIntervals;
    }

    public boolean hasNumberOfIntervalsElement() {
        return this.numberOfIntervals != null && !this.numberOfIntervals.isEmpty();
    }

    public boolean hasNumberOfIntervals() {
        return this.numberOfIntervals != null && !this.numberOfIntervals.isEmpty();
    }

    public OrderedDistribution setNumberOfIntervalsElement(IntegerType value) {
        this.numberOfIntervals = value;
        return this;
    }

    public int getNumberOfIntervals() {
        return this.numberOfIntervals == null || this.numberOfIntervals.isEmpty() ? 0 : (Integer)this.numberOfIntervals.getValue();
    }

    public OrderedDistribution setNumberOfIntervals(int value) {
        if (this.numberOfIntervals == null) {
            this.numberOfIntervals = new IntegerType();
        }
        this.numberOfIntervals.setValue((Object)value);
        return this;
    }

    public Quantity getBottomOfFirstInterval() {
        if (this.bottomOfFirstInterval == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderedDistribution.bottomOfFirstInterval");
            }
            if (Configuration.doAutoCreate()) {
                this.bottomOfFirstInterval = new Quantity();
            }
        }
        return this.bottomOfFirstInterval;
    }

    public boolean hasBottomOfFirstInterval() {
        return this.bottomOfFirstInterval != null && !this.bottomOfFirstInterval.isEmpty();
    }

    public OrderedDistribution setBottomOfFirstInterval(Quantity value) {
        this.bottomOfFirstInterval = value;
        return this;
    }

    public List<OrderedDistributionIntervalComponent> getInterval() {
        if (this.interval == null) {
            this.interval = new ArrayList<OrderedDistributionIntervalComponent>();
        }
        return this.interval;
    }

    public OrderedDistribution setInterval(List<OrderedDistributionIntervalComponent> theInterval) {
        this.interval = theInterval;
        return this;
    }

    public boolean hasInterval() {
        if (this.interval == null) {
            return false;
        }
        for (OrderedDistributionIntervalComponent item : this.interval) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OrderedDistributionIntervalComponent addInterval() {
        OrderedDistributionIntervalComponent t = new OrderedDistributionIntervalComponent();
        if (this.interval == null) {
            this.interval = new ArrayList<OrderedDistributionIntervalComponent>();
        }
        this.interval.add(t);
        return t;
    }

    public OrderedDistribution addInterval(OrderedDistributionIntervalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.interval == null) {
            this.interval = new ArrayList<OrderedDistributionIntervalComponent>();
        }
        this.interval.add(t);
        return this;
    }

    public OrderedDistributionIntervalComponent getIntervalFirstRep() {
        if (this.getInterval().isEmpty()) {
            this.addInterval();
        }
        return this.getInterval().get(0);
    }

    public Quantity getTopOfInterval() {
        if (this.topOfInterval == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderedDistribution.topOfInterval");
            }
            if (Configuration.doAutoCreate()) {
                this.topOfInterval = new Quantity();
            }
        }
        return this.topOfInterval;
    }

    public boolean hasTopOfInterval() {
        return this.topOfInterval != null && !this.topOfInterval.isEmpty();
    }

    public OrderedDistribution setTopOfInterval(Quantity value) {
        this.topOfInterval = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("description", "string", "A description of the content and value of the statistic.", 0, 1, this.description));
        children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("numberOfIntervals", "integer", "Number of intervals in an array, eg 4 for quartiles.", 0, 1, this.numberOfIntervals));
        children.add(new Property("bottomOfFirstInterval", "Quantity", "Bottom of first interval.", 0, 1, this.bottomOfFirstInterval));
        children.add(new Property("interval", "", "Interval.", 0, Integer.MAX_VALUE, this.interval));
        children.add(new Property("topOfInterval", "Quantity", "Singular value of the statistic at the upper bound of the interval.", 0, 1, this.topOfInterval));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1724546052: {
                return new Property("description", "string", "A description of the content and value of the statistic.", 0, 1, this.description);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -569541330: {
                return new Property("numberOfIntervals", "integer", "Number of intervals in an array, eg 4 for quartiles.", 0, 1, this.numberOfIntervals);
            }
            case 37889363: {
                return new Property("bottomOfFirstInterval", "Quantity", "Bottom of first interval.", 0, 1, this.bottomOfFirstInterval);
            }
            case 570418373: {
                return new Property("interval", "", "Interval.", 0, Integer.MAX_VALUE, this.interval);
            }
            case 691816177: {
                return new Property("topOfInterval", "Quantity", "Singular value of the statistic at the upper bound of the interval.", 0, 1, this.topOfInterval);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.description;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -569541330: {
                Base[] baseArray;
                if (this.numberOfIntervals == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.numberOfIntervals;
                }
                return baseArray;
            }
            case 37889363: {
                Base[] baseArray;
                if (this.bottomOfFirstInterval == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.bottomOfFirstInterval;
                }
                return baseArray;
            }
            case 570418373: {
                return this.interval == null ? new Base[]{} : this.interval.toArray(new Base[this.interval.size()]);
            }
            case 691816177: {
                Base[] baseArray;
                if (this.topOfInterval == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.topOfInterval;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -569541330: {
                this.numberOfIntervals = this.castToInteger(value);
                return value;
            }
            case 37889363: {
                this.bottomOfFirstInterval = this.castToQuantity(value);
                return value;
            }
            case 570418373: {
                this.getInterval().add((OrderedDistributionIntervalComponent)value);
                return value;
            }
            case 691816177: {
                this.topOfInterval = this.castToQuantity(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("numberOfIntervals")) {
            this.numberOfIntervals = this.castToInteger(value);
        } else if (name.equals("bottomOfFirstInterval")) {
            this.bottomOfFirstInterval = this.castToQuantity(value);
        } else if (name.equals("interval")) {
            this.getInterval().add((OrderedDistributionIntervalComponent)value);
        } else if (name.equals("topOfInterval")) {
            this.topOfInterval = this.castToQuantity(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -569541330: {
                return this.getNumberOfIntervalsElement();
            }
            case 37889363: {
                return this.getBottomOfFirstInterval();
            }
            case 570418373: {
                return this.addInterval();
            }
            case 691816177: {
                return this.getTopOfInterval();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return new String[]{"string"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -569541330: {
                return new String[]{"integer"};
            }
            case 37889363: {
                return new String[]{"Quantity"};
            }
            case 570418373: {
                return new String[0];
            }
            case 691816177: {
                return new String[]{"Quantity"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type OrderedDistribution.description");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("numberOfIntervals")) {
            throw new FHIRException("Cannot call addChild on a primitive type OrderedDistribution.numberOfIntervals");
        }
        if (name.equals("bottomOfFirstInterval")) {
            this.bottomOfFirstInterval = new Quantity();
            return this.bottomOfFirstInterval;
        }
        if (name.equals("interval")) {
            return this.addInterval();
        }
        if (name.equals("topOfInterval")) {
            this.topOfInterval = new Quantity();
            return this.topOfInterval;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OrderedDistribution";
    }

    @Override
    public OrderedDistribution copy() {
        OrderedDistribution dst = new OrderedDistribution();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(OrderedDistribution dst) {
        super.copyValues(dst);
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.numberOfIntervals = this.numberOfIntervals == null ? null : this.numberOfIntervals.copy();
        Quantity quantity = dst.bottomOfFirstInterval = this.bottomOfFirstInterval == null ? null : this.bottomOfFirstInterval.copy();
        if (this.interval != null) {
            dst.interval = new ArrayList<OrderedDistributionIntervalComponent>();
            for (OrderedDistributionIntervalComponent orderedDistributionIntervalComponent : this.interval) {
                dst.interval.add(orderedDistributionIntervalComponent.copy());
            }
        }
        dst.topOfInterval = this.topOfInterval == null ? null : this.topOfInterval.copy();
    }

    @Override
    protected OrderedDistribution typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof OrderedDistribution)) {
            return false;
        }
        OrderedDistribution o = (OrderedDistribution)other_;
        return OrderedDistribution.compareDeep(this.description, o.description, true) && OrderedDistribution.compareDeep(this.note, o.note, true) && OrderedDistribution.compareDeep(this.numberOfIntervals, o.numberOfIntervals, true) && OrderedDistribution.compareDeep(this.bottomOfFirstInterval, o.bottomOfFirstInterval, true) && OrderedDistribution.compareDeep(this.interval, o.interval, true) && OrderedDistribution.compareDeep(this.topOfInterval, o.topOfInterval, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof OrderedDistribution)) {
            return false;
        }
        OrderedDistribution o = (OrderedDistribution)other_;
        return OrderedDistribution.compareValues(this.description, o.description, true) && OrderedDistribution.compareValues(this.numberOfIntervals, o.numberOfIntervals, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.numberOfIntervals, this.bottomOfFirstInterval, this.interval, this.topOfInterval});
    }

    @Block
    public static class OrderedDistributionIntervalComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="rankOrder", type={IntegerType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Relative order of interval", formalDefinition="Relative order of interval.")
        protected IntegerType rankOrder;
        @Child(name="intervalStatistic", type={Statistic.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Values and parameters for a single statistic related to the interval", formalDefinition="Values and parameters for a single statistic related to the interval.")
        protected List<Statistic> intervalStatistic;
        private static final long serialVersionUID = 1714817635L;

        public OrderedDistributionIntervalComponent() {
        }

        public OrderedDistributionIntervalComponent(IntegerType rankOrder) {
            this.rankOrder = rankOrder;
        }

        public IntegerType getRankOrderElement() {
            if (this.rankOrder == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrderedDistributionIntervalComponent.rankOrder");
                }
                if (Configuration.doAutoCreate()) {
                    this.rankOrder = new IntegerType();
                }
            }
            return this.rankOrder;
        }

        public boolean hasRankOrderElement() {
            return this.rankOrder != null && !this.rankOrder.isEmpty();
        }

        public boolean hasRankOrder() {
            return this.rankOrder != null && !this.rankOrder.isEmpty();
        }

        public OrderedDistributionIntervalComponent setRankOrderElement(IntegerType value) {
            this.rankOrder = value;
            return this;
        }

        public int getRankOrder() {
            return this.rankOrder == null || this.rankOrder.isEmpty() ? 0 : (Integer)this.rankOrder.getValue();
        }

        public OrderedDistributionIntervalComponent setRankOrder(int value) {
            if (this.rankOrder == null) {
                this.rankOrder = new IntegerType();
            }
            this.rankOrder.setValue((Object)value);
            return this;
        }

        public List<Statistic> getIntervalStatistic() {
            if (this.intervalStatistic == null) {
                this.intervalStatistic = new ArrayList<Statistic>();
            }
            return this.intervalStatistic;
        }

        public OrderedDistributionIntervalComponent setIntervalStatistic(List<Statistic> theIntervalStatistic) {
            this.intervalStatistic = theIntervalStatistic;
            return this;
        }

        public boolean hasIntervalStatistic() {
            if (this.intervalStatistic == null) {
                return false;
            }
            for (Statistic item : this.intervalStatistic) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Statistic addIntervalStatistic() {
            Statistic t = new Statistic();
            if (this.intervalStatistic == null) {
                this.intervalStatistic = new ArrayList<Statistic>();
            }
            this.intervalStatistic.add(t);
            return t;
        }

        public OrderedDistributionIntervalComponent addIntervalStatistic(Statistic t) {
            if (t == null) {
                return this;
            }
            if (this.intervalStatistic == null) {
                this.intervalStatistic = new ArrayList<Statistic>();
            }
            this.intervalStatistic.add(t);
            return this;
        }

        public Statistic getIntervalStatisticFirstRep() {
            if (this.getIntervalStatistic().isEmpty()) {
                this.addIntervalStatistic();
            }
            return this.getIntervalStatistic().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("rankOrder", "integer", "Relative order of interval.", 0, 1, this.rankOrder));
            children.add(new Property("intervalStatistic", "Statistic", "Values and parameters for a single statistic related to the interval.", 0, Integer.MAX_VALUE, this.intervalStatistic));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -656537982: {
                    return new Property("rankOrder", "integer", "Relative order of interval.", 0, 1, this.rankOrder);
                }
                case 227099147: {
                    return new Property("intervalStatistic", "Statistic", "Values and parameters for a single statistic related to the interval.", 0, Integer.MAX_VALUE, this.intervalStatistic);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -656537982: {
                    Base[] baseArray;
                    if (this.rankOrder == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.rankOrder;
                    }
                    return baseArray;
                }
                case 227099147: {
                    return this.intervalStatistic == null ? new Base[]{} : this.intervalStatistic.toArray(new Base[this.intervalStatistic.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -656537982: {
                    this.rankOrder = this.castToInteger(value);
                    return value;
                }
                case 227099147: {
                    this.getIntervalStatistic().add(this.castToStatistic(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("rankOrder")) {
                this.rankOrder = this.castToInteger(value);
            } else if (name.equals("intervalStatistic")) {
                this.getIntervalStatistic().add(this.castToStatistic(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -656537982: {
                    return this.getRankOrderElement();
                }
                case 227099147: {
                    return this.addIntervalStatistic();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -656537982: {
                    return new String[]{"integer"};
                }
                case 227099147: {
                    return new String[]{"Statistic"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("rankOrder")) {
                throw new FHIRException("Cannot call addChild on a primitive type OrderedDistribution.rankOrder");
            }
            if (name.equals("intervalStatistic")) {
                return this.addIntervalStatistic();
            }
            return super.addChild(name);
        }

        @Override
        public OrderedDistributionIntervalComponent copy() {
            OrderedDistributionIntervalComponent dst = new OrderedDistributionIntervalComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OrderedDistributionIntervalComponent dst) {
            super.copyValues(dst);
            IntegerType integerType = dst.rankOrder = this.rankOrder == null ? null : this.rankOrder.copy();
            if (this.intervalStatistic != null) {
                dst.intervalStatistic = new ArrayList<Statistic>();
                for (Statistic i : this.intervalStatistic) {
                    dst.intervalStatistic.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OrderedDistributionIntervalComponent)) {
                return false;
            }
            OrderedDistributionIntervalComponent o = (OrderedDistributionIntervalComponent)other_;
            return OrderedDistributionIntervalComponent.compareDeep(this.rankOrder, o.rankOrder, true) && OrderedDistributionIntervalComponent.compareDeep(this.intervalStatistic, o.intervalStatistic, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OrderedDistributionIntervalComponent)) {
                return false;
            }
            OrderedDistributionIntervalComponent o = (OrderedDistributionIntervalComponent)other_;
            return OrderedDistributionIntervalComponent.compareValues(this.rankOrder, o.rankOrder, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.rankOrder, this.intervalStatistic});
        }

        @Override
        public String fhirType() {
            return "OrderedDistribution.interval";
        }
    }
}

