/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.VersionUtilities;

public class MetadataResourceManager<T extends MetadataResource> {
    private List<T> list = new ArrayList<T>();
    private Map<String, T> map = new HashMap<String, T>();

    public void copy(MetadataResourceManager<T> source) {
        this.list.clear();
        this.map.clear();
        this.list.addAll(source.list);
        this.map.putAll(source.map);
    }

    public void see(T r) {
        if (!((Resource)r).hasId()) {
            ((Resource)r).setId(UUID.randomUUID().toString());
        }
        if (this.map.containsKey(((Resource)r).getId())) {
            this.drop(((Resource)r).getId());
        }
        this.list.add(r);
        this.map.put(((Resource)r).getId(), r);
        if (((MetadataResource)r).hasUrl()) {
            if (((MetadataResource)r).hasVersion()) {
                this.map.put(((MetadataResource)r).getUrl() + "|" + ((MetadataResource)r).getVersion(), r);
            }
            this.updateList(((MetadataResource)r).getUrl(), ((MetadataResource)r).getVersion());
        }
    }

    private void updateList(String url, String version) {
        ArrayList<MetadataResource> rl = new ArrayList<MetadataResource>();
        for (MetadataResource t : this.list) {
            if (!url.equals(t.getUrl()) || rl.contains(t)) continue;
            rl.add(t);
        }
        if (rl.size() > 0) {
            Collections.sort(rl, new MetadataResourceVersionComparator());
            this.map.put(url, (MetadataResource)rl.get(rl.size() - 1));
            if (version != null) {
                MetadataResource latest = null;
                for (MetadataResource t : rl) {
                    if (!VersionUtilities.versionsCompatible((String)t.getVersion(), (String)version)) continue;
                    latest = t;
                }
                if (latest != null) {
                    this.map.put(url + "|" + VersionUtilities.getMajMin((String)latest.getVersion()), (MetadataResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    public T get(String url) {
        return (T)((MetadataResource)this.map.get(url));
    }

    public boolean has(String url) {
        return this.map.containsKey(url);
    }

    public T get(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return (T)((MetadataResource)this.map.get(system + "|" + version));
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null) {
            return (T)((MetadataResource)this.map.get(system + "|" + mm));
        }
        return null;
    }

    public boolean has(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return true;
        }
        String mm = VersionUtilities.getMajMin((String)version);
        if (mm != null) {
            return this.map.containsKey(system + "|" + mm);
        }
        return false;
    }

    public int size() {
        return this.list.size();
    }

    public void drop(String id) {
        MetadataResource res = (MetadataResource)this.map.get(id);
        if (res != null) {
            this.list.remove(res);
            this.map.remove(id);
            this.map.remove(res.getUrl());
            if (res.hasVersion()) {
                this.map.remove(res.getUrl() + "|" + res.getVersion());
                String mm = VersionUtilities.getMajMin((String)res.getVersion());
                if (mm != null) {
                    this.map.remove(res.getUrl() + "|" + mm);
                }
            }
            this.updateList(res.getUrl(), res.getVersion());
        }
    }

    public void listAll(List<T> result) {
        result.addAll(this.list);
    }

    public void listAllM(List<MetadataResource> result) {
        result.addAll(this.list);
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public List<T> getList() {
        return this.list;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public class MetadataResourceVersionComparator<T extends MetadataResource>
    implements Comparator<T> {
        @Override
        public int compare(T arg1, T arg2) {
            String v1 = ((MetadataResource)arg1).getVersion();
            String v2 = ((MetadataResource)arg2).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(MetadataResourceManager.this.list.indexOf(arg1), MetadataResourceManager.this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin((String)v1);
            String mm2 = VersionUtilities.getMajMin((String)v2);
            if (mm1 == null || mm2 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm2);
        }
    }
}

