/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3GenderStatus {
    I,
    N,
    NULL;


    public static V3GenderStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("I".equals(codeString)) {
            return I;
        }
        if ("N".equals(codeString)) {
            return N;
        }
        throw new FHIRException("Unknown V3GenderStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case I: {
                return "I";
            }
            case N: {
                return "N";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/GenderStatus";
    }

    public String getDefinition() {
        switch (this) {
            case I: {
                return "Reproductively intact";
            }
            case N: {
                return "Reproductively neutered";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case I: {
                return "Intact";
            }
            case N: {
                return "Neutered";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

