/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ReportParticipantType {
    TESTENGINE,
    CLIENT,
    SERVER,
    NULL;


    public static ReportParticipantType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("test-engine".equals(codeString)) {
            return TESTENGINE;
        }
        if ("client".equals(codeString)) {
            return CLIENT;
        }
        if ("server".equals(codeString)) {
            return SERVER;
        }
        throw new FHIRException("Unknown ReportParticipantType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TESTENGINE: {
                return "test-engine";
            }
            case CLIENT: {
                return "client";
            }
            case SERVER: {
                return "server";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/report-participant-type";
    }

    public String getDefinition() {
        switch (this) {
            case TESTENGINE: {
                return "The test execution engine.";
            }
            case CLIENT: {
                return "A FHIR Client";
            }
            case SERVER: {
                return "A FHIR Server";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TESTENGINE: {
                return "Test Engine";
            }
            case CLIENT: {
                return "Client";
            }
            case SERVER: {
                return "Server";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

