/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProcessOutcome {
    COMPLETE,
    PENDED,
    ERROR,
    NULL;


    public static ProcessOutcome fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        if ("pended".equals(codeString)) {
            return PENDED;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        throw new FHIRException("Unknown ProcessOutcome code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COMPLETE: {
                return "complete";
            }
            case PENDED: {
                return "pended";
            }
            case ERROR: {
                return "error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/processoutcomecodes";
    }

    public String getDefinition() {
        switch (this) {
            case COMPLETE: {
                return "The requested processing has completed.";
            }
            case PENDED: {
                return "The requested processing has been suspended.";
            }
            case ERROR: {
                return "The requested processing has terminated with some errors being found.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COMPLETE: {
                return "Complete";
            }
            case PENDED: {
                return "Pended";
            }
            case ERROR: {
                return "Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

