/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.MedicationRequestIntent;

public class MedicationRequestIntentEnumFactory
implements EnumFactory<MedicationRequestIntent> {
    @Override
    public MedicationRequestIntent fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return MedicationRequestIntent.PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return MedicationRequestIntent.PLAN;
        }
        if ("order".equals(codeString)) {
            return MedicationRequestIntent.ORDER;
        }
        if ("instance-order".equals(codeString)) {
            return MedicationRequestIntent.INSTANCEORDER;
        }
        throw new IllegalArgumentException("Unknown MedicationRequestIntent code '" + codeString + "'");
    }

    @Override
    public String toCode(MedicationRequestIntent code) {
        if (code == MedicationRequestIntent.PROPOSAL) {
            return "proposal";
        }
        if (code == MedicationRequestIntent.PLAN) {
            return "plan";
        }
        if (code == MedicationRequestIntent.ORDER) {
            return "order";
        }
        if (code == MedicationRequestIntent.INSTANCEORDER) {
            return "instance-order";
        }
        return "?";
    }

    @Override
    public String toSystem(MedicationRequestIntent code) {
        return code.getSystem();
    }
}

