/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExDiagnosisrelatedgroup {
    _100,
    _101,
    _300,
    _400,
    NULL;


    public static ExDiagnosisrelatedgroup fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("100".equals(codeString)) {
            return _100;
        }
        if ("101".equals(codeString)) {
            return _101;
        }
        if ("300".equals(codeString)) {
            return _300;
        }
        if ("400".equals(codeString)) {
            return _400;
        }
        throw new FHIRException("Unknown ExDiagnosisrelatedgroup code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _100: {
                return "100";
            }
            case _101: {
                return "101";
            }
            case _300: {
                return "300";
            }
            case _400: {
                return "400";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-diagnosisrelatedgroup";
    }

    public String getDefinition() {
        switch (this) {
            case _100: {
                return "Normal Vaginal Delivery.";
            }
            case _101: {
                return "Appendectomy without rupture or other complications.";
            }
            case _300: {
                return "Emergency department treatment of a tooth abcess.";
            }
            case _400: {
                return "Head trauma - concussion.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _100: {
                return "Normal Vaginal Delivery";
            }
            case _101: {
                return "Appendectomy - uncomplicated";
            }
            case _300: {
                return "Tooth abcess";
            }
            case _400: {
                return "Head trauma - concussion";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

