/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DWebType {
    WADORS,
    WADOURI,
    IID,
    NULL;


    public static DWebType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("WADO-RS".equals(codeString)) {
            return WADORS;
        }
        if ("WADO-URI".equals(codeString)) {
            return WADOURI;
        }
        if ("IID".equals(codeString)) {
            return IID;
        }
        throw new FHIRException("Unknown DWebType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case WADORS: {
                return "WADO-RS";
            }
            case WADOURI: {
                return "WADO-URI";
            }
            case IID: {
                return "IID";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/dWebType";
    }

    public String getDefinition() {
        switch (this) {
            case WADORS: {
                return "Web Access to DICOM Persistent Objects - RESTful Services";
            }
            case WADOURI: {
                return "Web Access to DICOM Persistent Objects - URI";
            }
            case IID: {
                return "IHE - Invoke Image Display Profile";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case WADORS: {
                return "WADO-RS";
            }
            case WADOURI: {
                return "WADO-URI";
            }
            case IID: {
                return "IID";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

