/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ConsentStatus;

public class ConsentStatusEnumFactory
implements EnumFactory<ConsentStatus> {
    @Override
    public ConsentStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return ConsentStatus.DRAFT;
        }
        if ("proposed".equals(codeString)) {
            return ConsentStatus.PROPOSED;
        }
        if ("active".equals(codeString)) {
            return ConsentStatus.ACTIVE;
        }
        if ("rejected".equals(codeString)) {
            return ConsentStatus.REJECTED;
        }
        if ("inactive".equals(codeString)) {
            return ConsentStatus.INACTIVE;
        }
        if ("entered-in-error".equals(codeString)) {
            return ConsentStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown ConsentStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(ConsentStatus code) {
        if (code == ConsentStatus.DRAFT) {
            return "draft";
        }
        if (code == ConsentStatus.PROPOSED) {
            return "proposed";
        }
        if (code == ConsentStatus.ACTIVE) {
            return "active";
        }
        if (code == ConsentStatus.REJECTED) {
            return "rejected";
        }
        if (code == ConsentStatus.INACTIVE) {
            return "inactive";
        }
        if (code == ConsentStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(ConsentStatus code) {
        return code.getSystem();
    }
}

